/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPopupMenu;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableRoundRect;
import jmri.jmrit.logix.OBlock;
import jmri.util.swing.JmriMouseEvent;

public class LocoLabel
extends PositionableRoundRect {
    private OBlock _block;

    public LocoLabel(Editor editor) {
        super(editor);
        this.setEditable(false);
    }

    public void setBlock(OBlock b) {
        this._block = b;
        this.invalidateShape();
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        this.setRotateMenu(popup);
        this.getEditor().setRemoveMenu(this, popup);
        return true;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this._block == null) {
            return;
        }
        String trainName = (String)this._block.getValue();
        if (trainName == null) {
            return;
        }
        Font font = this._block.getMarkerFont();
        if (font == null) {
            font = this.getFont();
        }
        g.setFont(font);
        int textWidth = this.getFontMetrics(font).stringWidth(trainName);
        int textHeight = this.getFontMetrics(font).getHeight();
        int hOffset = Math.max((this.maxWidth() - textWidth) / 2, 0);
        int vOffset = Math.max((this.maxHeight() - textHeight) / 2, 0) + this.getFontMetrics(font).getAscent();
        g.setColor(this._block.getMarkerForeground());
        g.drawString(trainName, hOffset, vOffset);
    }

    @Override
    protected void paintHandles(Graphics2D g2d) {
    }

    @Override
    protected boolean doHandleMove(JmriMouseEvent event) {
        return false;
    }

    @Override
    public boolean storeItem() {
        return false;
    }
}

