/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.controlPanelEditor.shape.Bundle;
import jmri.jmrit.display.controlPanelEditor.shape.DrawFrame;
import jmri.jmrit.display.controlPanelEditor.shape.DrawPolygon;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableShape;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionablePolygon
extends PositionableShape {
    private ArrayList<Rectangle> _vertexHandles;
    private boolean _editing = false;
    private static final Logger log = LoggerFactory.getLogger(PositionablePolygon.class);

    private PositionablePolygon(Editor editor) {
        super(editor);
    }

    public PositionablePolygon(Editor editor, Shape shape) {
        super(editor, shape);
    }

    @Override
    public Positionable deepClone() {
        PositionablePolygon pos = new PositionablePolygon(this._editor);
        return this.finishClone(pos);
    }

    @Override
    protected Positionable finishClone(PositionableShape pos) {
        GeneralPath path = new GeneralPath(0);
        path.append(this.getPathIterator(null), false);
        pos.setShape(path);
        return super.finishClone(pos);
    }

    protected void editing(boolean edit) {
        this._editing = edit;
        log.debug("set _editing = {}", (Object)this._editing);
    }

    @Override
    public boolean setEditItemMenu(JPopupMenu popup) {
        String txt = Bundle.getMessage("editShape", Bundle.getMessage("Polygon"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositionablePolygon.this.makeEditFrame(false);
            }
        });
        return true;
    }

    @Override
    protected DrawFrame makeEditFrame(boolean create) {
        this._editFrame = new DrawPolygon("editShape", "Polygon", this, this.getEditor(), create);
        this._editFrame.setDisplayParams(this);
        return this._editFrame;
    }

    @Override
    public void removeHandles() {
        this._vertexHandles = null;
        super.removeHandles();
    }

    @Override
    public void drawHandles() {
        if (this._editing) {
            this._vertexHandles = new ArrayList();
            PathIterator iter = this.getPathIterator(null);
            float[] coord = new float[6];
            while (!iter.isDone()) {
                iter.currentSegment(coord);
                int x = Math.round(coord[0]);
                int y = Math.round(coord[1]);
                this._vertexHandles.add(new Rectangle(x - 4, y - 4, 8, 8));
                iter.next();
            }
        } else {
            super.drawHandles();
        }
    }

    @Override
    public void doMousePressed(JmriMouseEvent event) {
        this._hitIndex = -1;
        if (!this._editor.isEditable()) {
            return;
        }
        if (this._editing) {
            if (this._vertexHandles != null) {
                Point pt;
                this._lastX = event.getX();
                this._lastY = event.getY();
                int x = this._lastX - this.getX();
                int y = this._lastY - this.getY();
                try {
                    pt = this.getInversePoint(x, y);
                }
                catch (NoninvertibleTransformException nte) {
                    log.error("Can't locate Hit Rectangles {}", (Object)nte.getMessage());
                    return;
                }
                for (int i = 0; i < this._vertexHandles.size(); ++i) {
                    if (!this._vertexHandles.get(i).contains(pt.x, pt.y)) continue;
                    this._hitIndex = i;
                }
            }
            log.debug("doMousePressed _editing = {}, _hitIndex= {}", (Object)this._editing, (Object)this._hitIndex);
        } else {
            super.doMousePressed(event);
        }
    }

    @Override
    protected boolean doHandleMove(JmriMouseEvent event) {
        if (this._hitIndex >= 0 && this._editor.isEditable()) {
            if (this._editing) {
                Point pt = new Point(event.getX() - this._lastX, event.getY() - this._lastY);
                Rectangle rect = this._vertexHandles.get(this._hitIndex);
                rect.x += pt.x;
                rect.y += pt.y;
                DrawPolygon editFrame = (DrawPolygon)this.getEditFrame();
                if (editFrame != null) {
                    if (event.getX() - this.getX() < 0) {
                        this._editor.moveItem(this, event.getX() - this.getX(), 0);
                    } else if (this.isLeftMost(rect.x)) {
                        this._editor.moveItem(this, event.getX() - this._lastX, 0);
                    }
                    if (event.getY() - this.getY() < 0) {
                        this._editor.moveItem(this, 0, event.getY() - this.getY());
                    } else if (this.isTopMost(rect.y)) {
                        this._editor.moveItem(this, 0, event.getY() - this._lastY);
                    }
                    editFrame.doHandleMove(this._hitIndex, pt);
                }
                this._lastX = event.getX();
                this._lastY = event.getY();
            } else {
                float deltaX = event.getX() - this._lastX;
                float deltaY = event.getY() - this._lastY;
                float width = this._width;
                float height = this._height;
                if (this._height < 4 || this._width < 4) {
                    log.error("Bad size _width= {}, _height= {}", (Object)this._width, (Object)this._height);
                }
                GeneralPath path = null;
                switch (this._hitIndex) {
                    case 0: {
                        if (height - deltaY > 4.0f) {
                            path = this.scale(1.0f, (height - deltaY) / height);
                            this._editor.moveItem(this, 0, (int)deltaY);
                            break;
                        }
                        path = this.scale(1.0f, 4.0f / height);
                        this._editor.moveItem(this, 0, this._height - 4);
                        break;
                    }
                    case 1: {
                        path = this.scale(Math.max(4.0f / width, (width + deltaX) / width), 1.0f);
                        break;
                    }
                    case 2: {
                        path = this.scale(1.0f, Math.max(4.0f / height, (height + deltaY) / height));
                        break;
                    }
                    case 3: {
                        if ((float)this._width - deltaX > 4.0f) {
                            path = this.scale((width - deltaX) / width, 1.0f);
                            this._editor.moveItem(this, (int)deltaX, 0);
                            break;
                        }
                        path = this.scale(4.0f / width, 1.0f);
                        this._editor.moveItem(this, this._width - 4, 0);
                        break;
                    }
                    default: {
                        log.warn("Unhandled direction code: {}", (Object)this._hitIndex);
                    }
                }
                if (path != null) {
                    this.setShape(path);
                }
            }
            this.drawHandles();
            this.repaint();
            this.updateSize();
            this._lastX = event.getX();
            this._lastY = event.getY();
            log.debug("doHandleMove _editing = {}, _hitIndex= {}", (Object)this._editing, (Object)this._hitIndex);
            return true;
        }
        return false;
    }

    private boolean isLeftMost(int x) {
        for (Rectangle vertexHandle : this._vertexHandles) {
            if (vertexHandle.x >= x) continue;
            return false;
        }
        return true;
    }

    private boolean isTopMost(int y) {
        for (Rectangle vertexHandle : this._vertexHandles) {
            if (vertexHandle.y >= y) continue;
            return false;
        }
        return true;
    }

    private GeneralPath scale(float ratioX, float ratioY) {
        GeneralPath path = new GeneralPath(0);
        PathIterator iter = this.getPathIterator(null);
        float[] coord = new float[6];
        while (!iter.isDone()) {
            int type = iter.currentSegment(coord);
            switch (type) {
                case 0: {
                    path.moveTo(coord[0] * ratioX, coord[1] * ratioY);
                    break;
                }
                case 1: {
                    path.lineTo(coord[0] * ratioX, coord[1] * ratioY);
                    break;
                }
                case 2: {
                    path.quadTo(coord[0], coord[1], coord[2], coord[3]);
                    break;
                }
                case 3: {
                    path.curveTo(coord[0], coord[1], coord[2], coord[3], coord[4], coord[5]);
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
                default: {
                    log.warn("Unhandled path iterator type: {}", (Object)type);
                }
            }
            iter.next();
        }
        return path;
    }

    @Override
    protected void paintHandles(Graphics2D g2d) {
        if (this._editing) {
            if (this._vertexHandles != null) {
                g2d.setStroke(new BasicStroke(2.0f));
                for (Rectangle rect : this._vertexHandles) {
                    g2d.setColor(Color.BLUE);
                    g2d.fill(rect);
                    g2d.setColor(Editor.HIGHLIGHT_COLOR);
                    g2d.draw(rect);
                }
                if (this._hitIndex >= 0) {
                    Rectangle rect = this._vertexHandles.get(this._hitIndex);
                    g2d.setColor(Color.RED);
                    g2d.fill(rect);
                    g2d.draw(rect);
                }
            }
        } else {
            super.paintHandles(g2d);
        }
    }

    @Override
    protected void invalidateShape() {
    }

    @Override
    protected Shape makeShape() {
        return new GeneralPath(0);
    }
}

