/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import jmri.Block;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.Path;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public class BlockContentsIcon
extends jmri.jmrit.display.BlockContentsIcon {
    private LayoutBlock lBlock = null;
    LayoutEditor panel;
    private static final Logger log = LoggerFactory.getLogger(BlockContentsIcon.class);

    public BlockContentsIcon(String s, LayoutEditor panel) {
        super(s, (Editor)panel);
        this.panel = panel;
        log.debug("BlockContentsIcon ctor= {}", (Object)BlockContentsIcon.class.getName());
    }

    @Override
    public void setBlock(NamedBeanHandle<Block> m) {
        super.setBlock(m);
        if (this.getBlock() != null) {
            this.lBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.getBlock());
        }
    }

    @Override
    protected void addRosterToIcon(RosterEntry roster) {
        int dirB;
        int dirA;
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() || this.lBlock == null) {
            super.addRosterToIcon(roster);
            return;
        }
        int paths = this.lBlock.getNumberOfThroughPaths();
        Block srcBlock = null;
        Block desBlock = null;
        for (int i = 0; i < paths; ++i) {
            if (!this.lBlock.isThroughPathActive(i).booleanValue()) continue;
            srcBlock = this.lBlock.getThroughPathSource(i);
            desBlock = this.lBlock.getThroughPathDestination(i);
            break;
        }
        if (srcBlock != null && desBlock != null) {
            dirA = this.lBlock.getNeighbourDirection(srcBlock);
            dirB = this.lBlock.getNeighbourDirection(desBlock);
        } else {
            dirA = 64;
            dirB = 128;
        }
        Object[] options = new Object[]{"Facing " + Path.decodeDirection(dirB), "Facing " + Path.decodeDirection(dirA), "Do Not Add"};
        int n = JmriJOptionPane.showOptionDialog(this, "Would you like to assign loco " + roster.titleString() + " to this location", "Assign Loco", -1, 3, null, options, options[2]);
        switch (n) {
            case -1: 
            case 2: {
                return;
            }
            case 0: {
                this.flipRosterIcon = true;
                this.getBlock().setDirection(dirB);
                break;
            }
            default: {
                this.flipRosterIcon = false;
                this.getBlock().setDirection(dirA);
            }
        }
        if (this.getBlock().getValue() == roster) {
            this.updateIconFromRosterVal(roster);
        } else {
            this.setValue(roster);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        this.panel.redrawPanel();
    }
}

