/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jmri.BasicRosterEntry;
import jmri.Block;
import jmri.BlockManager;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.beantable.BlockTableAction;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockValueFile
extends XmlFile {
    private BlockManager blockManager = InstanceManager.getDefault(BlockManager.class);
    private static final String defaultFileName = FileUtil.getUserFilesPath() + "blockvalues.xml";
    private Element root = null;
    private static final Logger log = LoggerFactory.getLogger(BlockValueFile.class);

    public void readBlockValues() throws JDOMException, IOException {
        log.debug("entered readBlockValues");
        ArrayList blocks = new ArrayList(this.blockManager.getNamedBeanSet().size());
        this.blockManager.getNamedBeanSet().forEach(bean -> blocks.add(bean.getSystemName()));
        if (this.checkFile(defaultFileName)) {
            Element blockvalues;
            this.root = this.rootFromName(defaultFileName);
            if (this.root != null && blocks.size() > 0 && (blockvalues = this.root.getChild("blockvalues")) != null) {
                List blockList = blockvalues.getChildren("block");
                BlockTableAction.RestoreRule rr = BlockTableAction.getRestoreRule();
                boolean allPoweredUp = true;
                for (PowerManager pm : InstanceManager.getList(PowerManager.class)) {
                    if (pm.getPower() == 2) continue;
                    allPoweredUp = false;
                }
                if (rr == BlockTableAction.RestoreRule.RESTOREONLYIFALLOCCUPIED && allPoweredUp) {
                    for (Element bl : blockList) {
                        String sysName;
                        Block b;
                        if (bl.getAttribute("systemname") == null || (b = (Block)this.blockManager.getBySystemName(sysName = bl.getAttribute("systemname").getValue())) == null || b.getState() == 2) continue;
                        log.error("block {} unoccupied but has saved value, not setting any block values, rule={}", (Object)b.getDisplayName(), (Object)rr);
                        return;
                    }
                }
                int blks = 0;
                int sets = 0;
                for (Element bl : blockList) {
                    if (bl.getAttribute("systemname") == null) {
                        log.warn("unexpected null in systemName {} {}", (Object)bl, (Object)bl.getAttributes());
                        break;
                    }
                    String sysName = bl.getAttribute("systemname").getValue();
                    Block b = (Block)this.blockManager.getBySystemName(sysName);
                    if (b == null) continue;
                    ++blks;
                    if (rr != BlockTableAction.RestoreRule.RESTOREALWAYS && allPoweredUp && b.getState() != 2) continue;
                    Object v = bl.getAttribute("value").getValue();
                    if (bl.getAttribute("valueClass") != null) {
                        IdTag tag;
                        RosterEntry re;
                        if (bl.getAttribute("valueClass").getValue().equals("jmri.jmrit.roster.RosterEntry") && (re = Roster.getDefault().getEntryForId((String)v)) != null) {
                            v = re;
                        }
                        if (bl.getAttribute("valueClass").getValue().equals("jmri.IdTag") && (tag = InstanceManager.getDefault(IdTagManager.class).getIdTag((String)v)) != null) {
                            v = tag;
                        }
                    }
                    b.setValue(v);
                    ++sets;
                    int dd = 0;
                    Attribute a = bl.getAttribute("dir");
                    if (a != null) {
                        try {
                            dd = a.getIntValue();
                        }
                        catch (DataConversionException e) {
                            log.error("failed to convert direction attribute");
                        }
                    }
                    b.setDirection(dd);
                }
                log.info("{} of {} block values restored. Rule={}, Power={}", new Object[]{sets, blks, rr, allPoweredUp ? "ON" : "OFF"});
            }
        }
    }

    public void writeBlockValues() throws IOException {
        log.debug("entered writeBlockValues");
        if (this.blockManager.getNamedBeanSet().size() > 0) {
            this.root = new Element("block_values");
            Document doc = BlockValueFile.newDocument(this.root, this.dtdLocation + "block-values.dtd");
            boolean valuesFound = false;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", "text/xsl");
            m.put("href", "/xml/XSLT/blockValues.xsl");
            ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
            doc.addContent(0, (Content)p);
            Element values = new Element("blockvalues");
            for (Block b : this.blockManager.getNamedBeanSet()) {
                if (b != null) {
                    Object o = b.getValue();
                    if (o == null) continue;
                    Element val = new Element("block");
                    val.setAttribute("systemname", b.getSystemName());
                    if (o instanceof RosterEntry) {
                        val.setAttribute("value", ((BasicRosterEntry)o).getId());
                        val.setAttribute("valueClass", "jmri.jmrit.roster.RosterEntry");
                    } else if (o instanceof IdTag) {
                        val.setAttribute("value", ((IdTag)o).getSystemName());
                        val.setAttribute("valueClass", "jmri.IdTag");
                    } else {
                        val.setAttribute("value", o.toString());
                    }
                    int v = b.getDirection();
                    if (v != 0) {
                        val.setAttribute("dir", "" + v);
                    }
                    values.addContent((Content)val);
                    valuesFound = true;
                    continue;
                }
                log.error("Block null in blockManager.getNamedBeanSet()");
            }
            this.root.addContent((Content)values);
            if (valuesFound) {
                try {
                    File file;
                    if (!this.checkFile(defaultFileName) && !(file = new File(defaultFileName)).createNewFile()) {
                        log.error("createNewFile failed");
                    }
                    this.writeXML(this.findFile(defaultFileName), doc);
                }
                catch (IOException ioe) {
                    log.error("While writing block value file ", (Throwable)ioe);
                    throw ioe;
                }
            }
        }
    }
}

