/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import javax.swing.ImageIcon;
import jmri.IdTag;
import jmri.Reportable;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Cannot rename for user data compatiblity reasons.")
public class GlobalVariableIcon
extends jmri.jmrit.display.GlobalVariableIcon {
    private final String defaultText = " ";
    private static final Logger log = LoggerFactory.getLogger(GlobalVariableIcon.class);

    public GlobalVariableIcon(String s, LayoutEditor panel) {
        super(s, (Editor)panel);
        log.debug("GlobalVariableIcon ctor= {}", (Object)GlobalVariableIcon.class.getName());
    }

    @Override
    public void setText(String text) {
        if (text == null || text.isEmpty()) {
            super.setText(" ");
        } else {
            super.setText(text);
        }
    }

    @Override
    public void displayState() {
        log.debug("displayState");
        if (this.getGlobalVariable() == null) {
            this.setText(" ");
            this.updateSize();
            return;
        }
        Object key = this.getGlobalVariable().getValue();
        if (key != null) {
            HashMap<String, NamedIcon> map = this.getMap();
            if (map == null) {
                Object val = key;
                if (val instanceof String) {
                    if (((String)val).isEmpty()) {
                        this.setText(" ");
                    } else {
                        this.setText((String)val);
                    }
                    this.setIcon(null);
                    this._text = true;
                    this._icon = false;
                    this.setAttributes(this.getPopupUtility(), this);
                    this.updateSize();
                } else if (val instanceof ImageIcon) {
                    this.setIcon((ImageIcon)val);
                    this.setText(null);
                    this._text = false;
                    this._icon = true;
                    this.updateSize();
                } else if (val instanceof Number) {
                    this.setText(val.toString());
                    this.setIcon(null);
                    this._text = true;
                    this._icon = false;
                    this.updateSize();
                } else if (val instanceof IdTag) {
                    this.setText(((IdTag)val).getDisplayName());
                    this.setIcon(null);
                    this._text = true;
                    this._icon = false;
                    this.updateSize();
                } else if (val instanceof Reportable) {
                    this.setText(((Reportable)val).toReportString());
                    this.setIcon(null);
                    this._text = true;
                    this._icon = false;
                    this.updateSize();
                } else {
                    log.warn("can't display current value of {}, val= {} of Class {}", new Object[]{this.getNamedGlobalVariable().getName(), val, val.getClass().getName()});
                }
            } else {
                NamedIcon newicon = map.get(key.toString());
                if (newicon != null) {
                    this.setText(null);
                    super.setIcon(newicon);
                    this._text = false;
                    this._icon = true;
                    this.updateSize();
                } else {
                    this.setIcon(this.getDefaultIcon());
                    this.setText(null);
                    this._text = false;
                    this._icon = true;
                    this.updateSize();
                }
            }
        } else {
            this.setIcon(null);
            this.setText(" ");
            this._text = true;
            this._icon = false;
            this.updateSize();
        }
    }

    @Override
    public void setGlobalVariable(String pName) {
        super.setGlobalVariable(pName);
    }

    @Override
    protected void setValue(Object obj) {
        this.getGlobalVariable().setValue(obj);
        this.updateSize();
    }
}

