/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import jmri.BeanSetting;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Path;
import jmri.Reportable;
import jmri.Sensor;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.beantable.beanedit.BeanEditItem;
import jmri.jmrit.beantable.beanedit.BeanItemPanel;
import jmri.jmrit.beantable.beanedit.BlockEditAction;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorAuxTools;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrackExpectedState;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.MemoryIcon;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.roster.RosterEntry;
import jmri.swing.NamedBeanComboBox;
import jmri.util.LoggingUtil;
import jmri.util.MathUtil;
import jmri.util.swing.JmriColorChooser;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.SplitButtonColorChooserPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LayoutBlock
extends AbstractNamedBean
implements PropertyChangeListener {
    private static final List<Integer> updateReferences = new ArrayList<Integer>(500);
    private final List<Integer> actedUponUpdates = new ArrayList<Integer>(500);
    public static final int OCCUPIED = 2;
    public static final int EMPTY = 4;
    public static final String PROPERTY_REDRAW = "redraw";
    public static final String PROPERTY_ROUTING = "routing";
    public static final String PROPERTY_PATH = "path";
    public static final String PROPERTY_THROUGH_PATH_ADDED = "through-path-added";
    public static final String PROPERTY_THROUGH_PATH_REMOVED = "through-path-removed";
    public static final String PROPERTY_NEIGHBOUR_PACKET_FLOW = "neighbourpacketflow";
    public static final String PROPERTY_NEIGHBOUR_METRIC = "neighbourmetric";
    public static final String PROPERTY_NEIGHBOUR_LENGTH = "neighbourlength";
    public static final String PROPERTY_VALID = "valid";
    public static final String PROPERTY_LENGTH = "length";
    public static final String PROPERTY_HOP = "hop";
    public static final String PROPERTY_METRIC = "metric";
    private int useCount = 0;
    private NamedBeanHandle<Sensor> occupancyNamedSensor = null;
    private NamedBeanHandle<Memory> namedMemory = null;
    private boolean setSensorFromBlockEnabled = true;
    private Block block = null;
    private final List<LayoutEditor> panels = new ArrayList<LayoutEditor>();
    private PropertyChangeListener mBlockListener = null;
    private int jmriblknum = 1;
    private boolean useExtraColor = false;
    private boolean suppressNameUpdate = false;
    private String occupancySensorName = "";
    private String memoryName = "";
    private int occupiedSense = 2;
    private Color blockTrackColor = Color.darkGray;
    private Color blockOccupiedColor = Color.red;
    private Color blockExtraColor = Color.white;
    private final NamedBeanComboBox<Memory> memoryComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(MemoryManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final JTextField metricField = new JTextField(10);
    private final JComboBox<String> senseBox = new JComboBox();
    private int senseActiveIndex;
    private int senseInactiveIndex;
    private JColorChooser trackColorChooser = null;
    private JColorChooser occupiedColorChooser = null;
    private JColorChooser extraColorChooser = null;
    private final String[] working = new String[]{"Bi-Directional", "Receive Only", "Send Only"};
    protected List<JComboBox<String>> neighbourDir;
    boolean active = true;
    private boolean defaultMetric = true;
    static long time = 0L;
    private LayoutEditorAuxTools auxTools = null;
    private ConnectivityUtil connection = null;
    private boolean layoutConnectivity = true;
    public static final int RESERVED = 8;
    private final List<Adjacencies> neighbours = new ArrayList<Adjacencies>();
    private final List<ThroughPaths> throughPaths = new ArrayList<ThroughPaths>();
    private final List<Routes> routes = new ArrayList<Routes>();
    static final int ADDITION = 0;
    static final int UPDATE = 2;
    static final int REMOVAL = 4;
    static final int RXTX = 0;
    static final int RXONLY = 2;
    static final int TXONLY = 4;
    static final int NONE = 8;
    int metric = 100;
    private static final Logger log = LoggerFactory.getLogger(LayoutBlock.class);
    private static final Logger searchRouteLog = LoggerFactory.getLogger((String)(LayoutBlock.class.getName() + ".SearchRouteLogging"));
    private static final Logger updateRouteLog = LoggerFactory.getLogger((String)(LayoutBlock.class.getName() + ".UpdateRouteLogging"));
    private static final Logger addRouteLog = LoggerFactory.getLogger((String)(LayoutBlock.class.getName() + ".AddRouteLogging"));
    private static final Logger deleteRouteLog = LoggerFactory.getLogger((String)(LayoutBlock.class.getName() + ".DeleteRouteLogging"));

    @Deprecated(since="5.11.2", forRemoval=true)
    public void enableDeleteRouteLog() {
        LoggingUtil.warnOnce(log, "Deprecated, please use the SLF4J categories", new Object[0]);
    }

    @Deprecated(since="5.11.2", forRemoval=true)
    public void disableDeleteRouteLog() {
        LoggingUtil.warnOnce(log, "Deprecated, please use the SLF4J categories", new Object[0]);
    }

    public LayoutBlock(String sName, String uName) {
        super(sName, uName);
    }

    public void initializeLayoutBlock() {
        this.block = null;
        String userName = this.getUserName();
        if (userName != null && !userName.isEmpty()) {
            this.block = (Block)InstanceManager.getDefault(BlockManager.class).getByUserName(userName);
        }
        if (this.block == null) {
            String s;
            BlockManager bm = InstanceManager.getDefault(BlockManager.class);
            while (true) {
                if (this.jmriblknum > 50000) {
                    throw new IndexOutOfBoundsException("Run away prevented while trying to create a block");
                }
                s = "IB" + this.jmriblknum;
                ++this.jmriblknum;
                this.block = (Block)bm.getBySystemName(s);
                if (this.block != null) {
                    log.debug("System name is already used: {}", (Object)s);
                    continue;
                }
                this.block = bm.createNewBlock(s, null);
                if (this.block == null) {
                    log.debug("Null block returned: {}", (Object)s);
                    continue;
                }
                Block testGet = (Block)bm.getBySystemName(s);
                if (testGet != null && bm.getNamedBeanSet().contains(testGet)) break;
                log.debug("Registration failed: {}", (Object)s);
            }
            log.debug("Block is valid: {}", (Object)s);
            this.block.setUserName(this.getUserName());
        }
        this.mBlockListener = this::handleBlockChange;
        this.block.addPropertyChangeListener(this.mBlockListener, this.getUserName(), "Layout Block:" + this.getUserName());
        if (this.occupancyNamedSensor != null) {
            this.block.setNamedSensor(this.occupancyNamedSensor);
        }
    }

    public void initializeLayoutBlockRouting() {
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            return;
        }
        this.setBlockMetric();
        this.block.getPaths().stream().forEach(this::addAdjacency);
    }

    public String getId() {
        return this.getUserName();
    }

    public Color getBlockTrackColor() {
        return this.blockTrackColor;
    }

    public void setBlockTrackColor(Color color) {
        this.blockTrackColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public Color getBlockOccupiedColor() {
        return this.blockOccupiedColor;
    }

    public void setBlockOccupiedColor(Color color) {
        this.blockOccupiedColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public Color getBlockExtraColor() {
        return this.blockExtraColor;
    }

    public void setBlockExtraColor(Color color) {
        this.blockExtraColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public boolean getUseExtraColor() {
        return this.useExtraColor;
    }

    public void setUseExtraColor(boolean b) {
        this.useExtraColor = b;
        if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            this.stateUpdate();
        }
        if (this.getBlock() != null) {
            this.getBlock().setAllocated(b);
        }
    }

    public void incrementUse() {
        ++this.useCount;
    }

    public void decrementUse() {
        --this.useCount;
        if (this.useCount <= 0) {
            this.useCount = 0;
        }
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void addLayoutEditor(LayoutEditor panel) {
        if (!this.panels.contains(panel)) {
            this.panels.add(panel);
        }
    }

    public void deleteLayoutEditor(LayoutEditor panel) {
        if (this.panels.contains(panel)) {
            this.panels.remove(panel);
        }
    }

    public boolean isOnPanel(LayoutEditor panel) {
        return this.panels.contains(panel);
    }

    public void redrawLayoutBlockPanels() {
        this.panels.stream().forEach(LayoutEditor::redrawPanel);
        this.firePropertyChange(PROPERTY_REDRAW, null, null);
    }

    public Sensor validateSensor(String sensorName, Component openFrame) {
        if (sensorName == null || sensorName.isEmpty()) {
            if (this.occupancyNamedSensor != null) {
                this.setOccupancySensorName(null);
            }
            return null;
        }
        Sensor s = InstanceManager.sensorManagerInstance().getSensor(sensorName);
        if (s == null) {
            JmriJOptionPane.showMessageDialog(openFrame, MessageFormat.format(Bundle.getMessage("Error7"), sensorName), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        NamedBeanHandle<Sensor> savedNamedSensor = this.occupancyNamedSensor;
        this.occupancyNamedSensor = null;
        LayoutBlock b = InstanceManager.getDefault(LayoutBlockManager.class).getBlockWithSensorAssigned(s);
        if (b != this) {
            if (b != null) {
                if (b.getUseCount() > 0) {
                    this.occupancyNamedSensor = savedNamedSensor;
                    JmriJOptionPane.showMessageDialog(openFrame, Bundle.getMessage("Error6", sensorName, b.getId()), Bundle.getMessage("ErrorTitle"), 0);
                    return null;
                }
                b.setOccupancySensorName(null);
            }
            this.setOccupancySensorName(sensorName);
        }
        return s;
    }

    public Memory validateMemory(String memName, Component openFrame) {
        if (memName == null || memName.isEmpty()) {
            return null;
        }
        Memory m = InstanceManager.memoryManagerInstance().getMemory(memName);
        if (m == null) {
            JmriJOptionPane.showMessageDialog(openFrame, MessageFormat.format(Bundle.getMessage("Error16"), memName), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        this.memoryName = memName;
        if (m != this.getMemory() && !this.panels.isEmpty()) {
            boolean updateall = false;
            boolean found = false;
            for (LayoutEditor panel : this.panels) {
                for (MemoryIcon memIcon : panel.getMemoryLabelList()) {
                    if (memIcon.getLayoutBlock() != this) continue;
                    if (!updateall && !found) {
                        int n = JmriJOptionPane.showConfirmDialog(openFrame, "Would you like to update all memory icons on the panel linked to the block to use the new one?", "Update Memory Icons", 0);
                        found = true;
                        if (n == 0) {
                            updateall = true;
                        }
                    }
                    if (!updateall) continue;
                    memIcon.setMemory(this.memoryName);
                }
            }
        }
        return m;
    }

    public Color getBlockColor() {
        if (this.getOccupancy() == 2) {
            return this.blockOccupiedColor;
        }
        if (this.useExtraColor) {
            return this.blockExtraColor;
        }
        return this.blockTrackColor;
    }

    public Block getBlock() {
        return this.block;
    }

    public String getMemoryName() {
        if (this.namedMemory != null) {
            return this.namedMemory.getName();
        }
        return this.memoryName;
    }

    public Memory getMemory() {
        if (this.namedMemory == null) {
            this.setMemoryName(this.memoryName);
        }
        if (this.namedMemory != null) {
            return this.namedMemory.getBean();
        }
        return null;
    }

    public void setMemoryName(String name) {
        if (name == null || name.isEmpty()) {
            this.namedMemory = null;
            this.memoryName = "";
            return;
        }
        this.memoryName = name;
        Memory memory = InstanceManager.memoryManagerInstance().getMemory(name);
        if (memory != null) {
            this.namedMemory = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, memory);
        }
    }

    public void setMemory(Memory m, String name) {
        if (m == null) {
            this.namedMemory = null;
            this.memoryName = name == null ? "" : name;
            return;
        }
        this.namedMemory = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, m);
    }

    public String getOccupancySensorName() {
        if (this.occupancyNamedSensor == null && this.block != null) {
            this.occupancyNamedSensor = this.block.getNamedSensor();
        }
        if (this.occupancyNamedSensor != null) {
            return this.occupancyNamedSensor.getName();
        }
        return this.occupancySensorName;
    }

    public Sensor getOccupancySensor() {
        if (this.occupancyNamedSensor == null && this.setSensorFromBlockEnabled && this.block != null) {
            this.occupancyNamedSensor = this.block.getNamedSensor();
        }
        if (this.occupancyNamedSensor != null) {
            return this.occupancyNamedSensor.getBean();
        }
        return null;
    }

    public void setOccupancySensorName(String name) {
        if (name == null || name.isEmpty()) {
            if (this.occupancyNamedSensor != null) {
                this.occupancyNamedSensor.getBean().removePropertyChangeListener(this.mBlockListener);
            }
            this.occupancyNamedSensor = null;
            this.occupancySensorName = "";
            if (this.block != null) {
                this.block.setNamedSensor(null);
            }
            return;
        }
        this.occupancySensorName = name;
        Sensor sensor = InstanceManager.sensorManagerInstance().getSensor(name);
        if (sensor != null) {
            this.occupancyNamedSensor = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, sensor);
            if (this.block != null) {
                this.block.setNamedSensor(this.occupancyNamedSensor);
            }
        }
    }

    public int getOccupiedSense() {
        return this.occupiedSense;
    }

    public void setOccupiedSense(int sense) {
        this.occupiedSense = sense;
    }

    public int getOccupancy() {
        Sensor s;
        if (this.occupancyNamedSensor == null) {
            s = null;
            if (!this.occupancySensorName.isEmpty()) {
                s = InstanceManager.sensorManagerInstance().getSensor(this.occupancySensorName);
            }
            if (s == null) {
                if (this.block != null) {
                    return this.block.getState();
                }
                return 1;
            }
            this.occupancyNamedSensor = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this.occupancySensorName, s);
            if (this.block != null) {
                this.block.setNamedSensor(this.occupancyNamedSensor);
            }
        }
        if ((s = this.getOccupancySensor()) == null) {
            return 1;
        }
        if (s.getKnownState() != this.occupiedSense) {
            return 4;
        }
        if (s.getKnownState() == this.occupiedSense) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getState() {
        return this.getOccupancy();
    }

    @Override
    public void setState(int i) {
        log.error("this state does nothing {}", (Object)this.getDisplayName());
    }

    public LayoutEditor getMaxConnectedPanel() {
        LayoutEditor result = null;
        if (this.block != null && !this.panels.isEmpty()) {
            int maxConnectivity = Integer.MIN_VALUE;
            for (LayoutEditor panel : this.panels) {
                List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
                if (maxConnectivity >= c.size()) continue;
                maxConnectivity = c.size();
                result = panel;
            }
        }
        return result;
    }

    public void updatePaths() {
        if (this.block != null && !this.panels.isEmpty()) {
            LayoutEditor panel = this.panels.get(0);
            List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
            if (this.panels.size() > 1) {
                for (int i = 1; i < this.panels.size(); ++i) {
                    if (c.size() >= this.panels.get(i).getLEAuxTools().getConnectivityList(this).size()) continue;
                    panel = this.panels.get(i);
                    c = panel.getLEAuxTools().getConnectivityList(this);
                }
                PositionablePoint point = panel.getFinder().findPositionableLinkPoint(this);
                if (point != null && point.getLinkedEditor() != null && this.panels.contains(point.getLinkedEditor())) {
                    c = panel.getLEAuxTools().getConnectivityList(this);
                    c.addAll(point.getLinkedEditor().getLEAuxTools().getConnectivityList(this));
                } else {
                    for (LayoutEditor tPanel : this.panels) {
                        int response;
                        if (tPanel == panel || !InstanceManager.getDefault(LayoutBlockManager.class).warn() || this.compareConnectivity(c, tPanel.getLEAuxTools().getConnectivityList(this)) || (response = JmriJOptionPane.showOptionDialog(null, MessageFormat.format(Bundle.getMessage("Warn1"), this.getUserName(), tPanel.getLayoutName(), panel.getLayoutName()), Bundle.getMessage("WarningTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonOKPlus")}, Bundle.getMessage("ButtonOK"))) != 1) continue;
                        InstanceManager.getDefault(LayoutBlockManager.class).turnOffWarning();
                    }
                }
            }
            this.updateBlockPaths(c, panel);
        }
    }

    public void updatePathsUsingPanel(LayoutEditor panel) {
        if (panel == null) {
            log.error("Null panel in call to updatePathsUsingPanel");
            return;
        }
        List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
        this.updateBlockPaths(c, panel);
    }

    private void updateBlockPaths(List<LayoutConnectivity> c, LayoutEditor panel) {
        Path p2;
        int i;
        addRouteLog.debug("From {} updateBlockPaths Called", (Object)this.getDisplayName());
        this.auxTools = panel.getLEAuxTools();
        List<Path> paths = this.block.getPaths();
        boolean[] used = new boolean[c.size()];
        int[] need = new int[paths.size()];
        Arrays.fill(used, false);
        Arrays.fill(need, -1);
        for (i = 0; i < paths.size(); ++i) {
            p2 = paths.get(i);
            for (int j = 0; j < c.size() && need[i] == -1; ++j) {
                LayoutConnectivity lc;
                if (used[j] || (lc = c.get(j)).getBlock1().getBlock() != p2.getBlock() && lc.getBlock2().getBlock() != p2.getBlock()) continue;
                used[j] = true;
                need[i] = j;
            }
        }
        for (i = 0; i < paths.size(); ++i) {
            if (need[i] < 0) continue;
            p2 = paths.get(i);
            LayoutConnectivity lc = c.get(need[i]);
            if (lc.getBlock1() == this) {
                p2.setToBlockDirection(lc.getDirection());
                p2.setFromBlockDirection(lc.getReverseDirection());
            } else {
                p2.setToBlockDirection(lc.getReverseDirection());
                p2.setFromBlockDirection(lc.getDirection());
            }
            ArrayList<BeanSetting> beans = new ArrayList<BeanSetting>(p2.getSettings());
            for (BeanSetting bean : beans) {
                p2.removeSetting(bean);
            }
            this.auxTools.addBeanSettings(p2, lc, this);
        }
        for (i = 0; i < paths.size(); ++i) {
            if (need[i] >= 0) continue;
            this.block.removePath(paths.get(i));
            if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) continue;
            this.removeAdjacency(paths.get(i));
        }
        for (int j = 0; j < c.size(); ++j) {
            if (used[j]) continue;
            LayoutConnectivity lc = c.get(j);
            Path newp = lc.getBlock1() == this ? new Path(lc.getBlock2().getBlock(), lc.getDirection(), lc.getReverseDirection()) : new Path(lc.getBlock1().getBlock(), lc.getReverseDirection(), lc.getDirection());
            this.block.addPath(newp);
            addRouteLog.debug("From {} addPath({})", (Object)this.getDisplayName(), (Object)newp.toString());
            if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
                this.addAdjacency(newp);
            }
            this.auxTools.addBeanSettings(newp, lc, this);
        }
        if (log.isDebugEnabled()) {
            this.block.getPaths().stream().forEach(p -> log.debug("From {} to {}", (Object)this.getDisplayName(), p));
        }
    }

    private boolean compareConnectivity(List<LayoutConnectivity> main, List<LayoutConnectivity> test) {
        boolean result = false;
        if (!main.isEmpty() && !test.isEmpty()) {
            result = true;
            for (LayoutConnectivity tc : test) {
                LayoutBlock tlb1 = tc.getBlock1();
                LayoutBlock tlb2 = tc.getBlock2();
                boolean found = false;
                for (LayoutConnectivity mc : main) {
                    LayoutBlock mlb1 = mc.getBlock1();
                    LayoutBlock mlb2 = mc.getBlock2();
                    if ((tlb1 != mlb1 || tlb2 != mlb2) && (tlb1 != mlb2 || tlb2 != mlb1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result = false;
                break;
            }
        } else if (main.isEmpty() && test.isEmpty()) {
            result = true;
        }
        return result;
    }

    void handleBlockChange(PropertyChangeEvent e) {
        Memory m = this.getMemory();
        if (m != null && this.block != null && !this.suppressNameUpdate) {
            Object val = this.block.getValue();
            if (val != null && !(val instanceof RosterEntry) && !(val instanceof Reportable)) {
                val = val.toString();
            }
            m.setValue(val);
        }
        if ("UserName".equals(e.getPropertyName())) {
            this.setUserName(e.getNewValue().toString());
            InstanceManager.getDefault(NamedBeanHandleManager.class).renameBean(e.getOldValue().toString(), e.getNewValue().toString(), this);
        }
        if ("OccupancySensorChange".equals(e.getPropertyName())) {
            if (e.getNewValue() == null) {
                this.setOccupancySensorName(null);
            } else {
                Sensor sensor = (Sensor)e.getNewValue();
                this.setSensorFromBlockEnabled = false;
                if (this.validateSensor(sensor.getSystemName(), null) == null) {
                    Sensor origSensor = (Sensor)e.getOldValue();
                    this.block.setSensor(origSensor == null ? "" : origSensor.getSystemName());
                }
                this.setSensorFromBlockEnabled = true;
            }
        }
        this.redrawLayoutBlockPanels();
        if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            this.stateUpdate();
        }
    }

    private void deactivateBlock() {
        if (this.mBlockListener != null && this.block != null) {
            this.block.removePropertyChangeListener(this.mBlockListener);
        }
        this.mBlockListener = null;
    }

    public void setSuppressNameUpdate(boolean set) {
        this.suppressNameUpdate = set;
    }

    public void editLayoutBlock(Component callingPane) {
        LayoutBlockEditAction beanEdit = new LayoutBlockEditAction();
        if (this.block == null) {
            Block b;
            String userName = this.getUserName();
            if (userName != null && !userName.isEmpty() && (b = InstanceManager.getDefault(BlockManager.class).getBlock(userName)) != null) {
                beanEdit.setBean(b);
            }
        } else {
            beanEdit.setBean(this.block);
        }
        beanEdit.actionPerformed(null);
    }

    void remove() {
        this.deactivateBlock();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    void setBlockMetric() {
        if (!this.defaultMetric) {
            return;
        }
        updateRouteLog.debug("From '{}' default set block metric called", (Object)this.getDisplayName());
        LayoutEditor panel = this.getMaxConnectedPanel();
        if (panel == null) {
            updateRouteLog.debug("From '{}' unable to set metric as we are not connected to a panel yet", (Object)this.getDisplayName());
            return;
        }
        String userName = this.getUserName();
        if (userName == null) {
            log.info("From '{}': unable to get user name", (Object)this.getDisplayName());
            return;
        }
        ArrayList<TrackSegment> ts = panel.getFinder().findTrackSegmentByBlock(userName);
        int mainline = 0;
        int side = 0;
        for (TrackSegment t : ts) {
            if (t.isMainline()) {
                ++mainline;
                continue;
            }
            ++side;
        }
        this.metric = mainline > side ? 50 : (mainline < side ? 200 : 50);
        updateRouteLog.debug("From '{}' metric set to {}", (Object)this.getDisplayName(), (Object)this.metric);
        RoutingPacket update = new RoutingPacket(2, this.getBlock(), -1, this.metric, -1.0f, -1, this.getNextPacketID());
        this.firePropertyChange(PROPERTY_ROUTING, null, update);
    }

    public boolean useDefaultMetric() {
        return this.defaultMetric;
    }

    public void useDefaultMetric(boolean boo) {
        if (boo == this.defaultMetric) {
            return;
        }
        this.defaultMetric = boo;
        if (boo) {
            this.setBlockMetric();
        }
    }

    public void setBlockMetric(int m) {
        if (this.metric == m) {
            return;
        }
        this.metric = m;
        this.defaultMetric = false;
        RoutingPacket update = new RoutingPacket(2, this.getBlock(), -1, this.metric, -1.0f, -1, this.getNextPacketID());
        this.firePropertyChange(PROPERTY_ROUTING, null, update);
    }

    public int getBlockMetric() {
        return this.metric;
    }

    public void addAllThroughPaths() {
        addRouteLog.debug("Add all ThroughPaths {}", (Object)this.getDisplayName());
        if (this.block != null && !this.panels.isEmpty()) {
            LayoutEditor panel = this.panels.get(0);
            List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
            if (this.panels.size() > 1) {
                for (int i = 1; i < this.panels.size(); ++i) {
                    if (c.size() >= this.panels.get(i).getLEAuxTools().getConnectivityList(this).size()) continue;
                    panel = this.panels.get(i);
                    c = panel.getLEAuxTools().getConnectivityList(this);
                }
                for (LayoutEditor tPanel : this.panels) {
                    int response;
                    if (tPanel == panel || !InstanceManager.getDefault(LayoutBlockManager.class).warn() || this.compareConnectivity(c, tPanel.getLEAuxTools().getConnectivityList(this)) || (response = JmriJOptionPane.showOptionDialog(null, MessageFormat.format(Bundle.getMessage("Warn1"), this.getUserName(), tPanel.getLayoutName(), panel.getLayoutName()), Bundle.getMessage("WarningTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonOKPlus")}, Bundle.getMessage("ButtonOK"))) != 1) continue;
                    InstanceManager.getDefault(LayoutBlockManager.class).turnOffWarning();
                }
            }
            this.auxTools = panel.getLEAuxTools();
            List<LayoutConnectivity> d = this.auxTools.getConnectivityList(this);
            ArrayList<LayoutBlock> attachedBlocks = new ArrayList<LayoutBlock>();
            for (LayoutConnectivity connectivity : d) {
                if (connectivity.getBlock1() != this) {
                    attachedBlocks.add(connectivity.getBlock1());
                    continue;
                }
                attachedBlocks.add(connectivity.getBlock2());
            }
            for (LayoutBlock attachedBlock : attachedBlocks) {
                addRouteLog.debug("From {} block is attached {}", (Object)this.getDisplayName(), (Object)attachedBlock.getDisplayName());
                for (LayoutBlock layoutBlock : attachedBlocks) {
                    this.addThroughPath(attachedBlock.getBlock(), layoutBlock.getBlock(), panel);
                }
            }
        }
    }

    private void addNeighbour(Block addBlock, int direction, int workingDirection) {
        boolean layoutConnectivityBefore = this.layoutConnectivity;
        addRouteLog.debug("From {} asked to add block {} as new neighbour {}", new Object[]{this.getDisplayName(), addBlock.getDisplayName(), this.decodePacketFlow(workingDirection)});
        if (this.getAdjacency(addBlock) != null) {
            addRouteLog.debug("Block is already registered");
            this.addThroughPath(this.getAdjacency(addBlock));
        } else {
            Adjacencies adj = new Adjacencies(addBlock, direction, workingDirection);
            this.neighbours.add(adj);
            LayoutBlock blk = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(addBlock);
            LayoutEditor editor = this.getMaxConnectedPanel();
            if (editor != null && this.connection == null) {
                this.connection = editor.getConnectivityUtil();
            }
            Routes route = null;
            if (workingDirection == 0 || workingDirection == 2) {
                route = blk != null ? new Routes(addBlock, this.getBlock(), 1, direction, blk.getBlockMetric(), addBlock.getLengthMm()) : new Routes(addBlock, this.getBlock(), 1, direction, 0, 0.0f);
                this.routes.add(route);
            }
            if (blk != null) {
                boolean mutual = blk.informNeighbourOfAttachment(this, this.getBlock(), workingDirection);
                if (workingDirection == 0 || workingDirection == 2) {
                    blk.addPropertyChangeListener(this);
                } else {
                    blk.removePropertyChangeListener(this);
                }
                int neighwork = blk.getAdjacencyPacketFlow(this.getBlock());
                addRouteLog.debug("{}.getAdjacencyPacketFlow({}): {}, {}", new Object[]{blk.getDisplayName(), this.getBlock().getDisplayName(), neighwork == -1 ? "Unset" : this.decodePacketFlow(neighwork), neighwork});
                if (neighwork != -1) {
                    addRouteLog.debug("From {} Updating flow direction to {} for block {} choice of {} {}", new Object[]{this.getDisplayName(), this.decodePacketFlow(this.determineAdjPacketFlow(workingDirection, neighwork)), blk.getDisplayName(), this.decodePacketFlow(workingDirection), this.decodePacketFlow(neighwork)});
                    int newPacketFlow = this.determineAdjPacketFlow(workingDirection, neighwork);
                    adj.setPacketFlow(newPacketFlow);
                    if (newPacketFlow == 4) {
                        for (int j = this.routes.size() - 1; j > -1; --j) {
                            Routes ro = this.routes.get(j);
                            if (ro.getDestBlock() != addBlock || ro.getNextBlock() != this.getBlock()) continue;
                            adj.removeRouteAdvertisedToNeighbour(ro);
                            this.routes.remove(j);
                        }
                        RoutingPacket newUpdate = new RoutingPacket(4, addBlock, -1, -1, -1.0f, -1, this.getNextPacketID());
                        this.neighbours.forEach(adja -> adja.removeRouteAdvertisedToNeighbour(addBlock));
                        this.firePropertyChange(PROPERTY_ROUTING, null, newUpdate);
                    }
                } else {
                    addRouteLog.debug("From {} neighbour {} working direction is not valid", (Object)this.getDisplayName(), (Object)addBlock.getDisplayName());
                    return;
                }
                adj.setMutual(mutual);
                if (route != null) {
                    route.stateChange();
                }
                this.addThroughPath(this.getAdjacency(addBlock));
                if ((workingDirection == 0 || workingDirection == 4) && mutual) {
                    blk.informNeighbourOfValidRoutes(this.getBlock());
                }
            } else {
                addRouteLog.debug("From {} neighbour {} has no layoutBlock associated, metric set to {}", new Object[]{this.getDisplayName(), addBlock.getDisplayName(), adj.getMetric()});
            }
        }
        addRouteLog.debug("From {} layout connectivity before {}", (Object)this.getDisplayName(), (Object)layoutConnectivityBefore);
        if (!layoutConnectivityBefore) {
            for (Adjacencies neighbour : this.neighbours) {
                this.addThroughPath(neighbour);
            }
        }
    }

    private boolean informNeighbourOfAttachment(LayoutBlock lBlock, Block block, int workingDirection) {
        Adjacencies adj = this.getAdjacency(block);
        if (adj == null) {
            addRouteLog.debug("From {} neighbour {} has informed us of its attachment to us, however we do not yet have it registered", (Object)this.getDisplayName(), (Object)lBlock.getDisplayName());
            return false;
        }
        if (!adj.isMutual()) {
            addRouteLog.debug("From {} neighbour {} wants us to {}; we have it set as {}", new Object[]{this.getDisplayName(), block.getDisplayName(), this.decodePacketFlow(workingDirection), this.decodePacketFlow(adj.getPacketFlow())});
            int newPacketFlow = this.determineAdjPacketFlow(adj.getPacketFlow(), workingDirection);
            addRouteLog.debug("From {} neighbour {} passed {} we have {} this will be updated to {}", new Object[]{this.getDisplayName(), block.getDisplayName(), this.decodePacketFlow(workingDirection), this.decodePacketFlow(adj.getPacketFlow()), this.decodePacketFlow(newPacketFlow)});
            adj.setPacketFlow(newPacketFlow);
            if (newPacketFlow != 4) {
                Routes r;
                RoutingPacket update;
                Routes neighRoute = this.getValidRoute(this.getBlock(), adj.getBlock());
                if (neighRoute == null) {
                    log.info("Null route so will bomb out");
                    return false;
                }
                if (neighRoute.getMetric() != adj.getMetric()) {
                    addRouteLog.debug("From {} The value of the metric we have for this route is not correct {}, stored {} v {}", new Object[]{this.getDisplayName(), this.getBlock().getDisplayName(), neighRoute.getMetric(), adj.getMetric()});
                    neighRoute.setMetric(adj.getMetric());
                    update = new RoutingPacket(2, adj.getBlock(), -1, adj.getMetric() + this.metric, -1.0f, -1, this.getNextPacketID());
                    this.firePropertyChange(PROPERTY_ROUTING, null, update);
                }
                if (neighRoute.getMetric() != (int)adj.getLength()) {
                    addRouteLog.debug("From {} The value of the length we have for this route is not correct {}, stored {} v {}", new Object[]{this.getDisplayName(), this.getBlock().getDisplayName(), neighRoute.getMetric(), adj.getMetric()});
                    neighRoute.setLength(adj.getLength());
                    update = new RoutingPacket(2, adj.getBlock(), -1, -1, adj.getLength() + block.getLengthMm(), -1, this.getNextPacketID());
                    this.firePropertyChange(PROPERTY_ROUTING, null, update);
                }
                if ((r = this.getRouteByDestBlock(block)) != null) {
                    r.setMetric(lBlock.getBlockMetric());
                } else {
                    log.warn("No getRouteByDestBlock('{}')", (Object)block.getDisplayName());
                }
            }
            addRouteLog.debug("From {} We were not a mutual adjacency with {} but now are", (Object)this.getDisplayName(), (Object)lBlock.getDisplayName());
            if (newPacketFlow == 0 || newPacketFlow == 2) {
                lBlock.addPropertyChangeListener(this);
            } else {
                lBlock.removePropertyChangeListener(this);
            }
            if (newPacketFlow == 4) {
                int j;
                for (j = this.routes.size() - 1; j > -1; --j) {
                    Routes ro = this.routes.get(j);
                    if (ro.getDestBlock() != block || ro.getNextBlock() != this.getBlock()) continue;
                    adj.removeRouteAdvertisedToNeighbour(ro);
                    this.routes.remove(j);
                }
                for (j = this.throughPaths.size() - 1; j > -1; --j) {
                    if (this.throughPaths.get(j).getDestinationBlock() != block) continue;
                    addRouteLog.debug("From {} removed throughpath {} {}", new Object[]{this.getDisplayName(), this.throughPaths.get(j).getSourceBlock().getDisplayName(), this.throughPaths.get(j).getDestinationBlock().getDisplayName()});
                    this.throughPaths.remove(j);
                }
                RoutingPacket newUpdate = new RoutingPacket(4, block, -1, -1, -1.0f, -1, this.getNextPacketID());
                this.neighbours.forEach(adja -> adja.removeRouteAdvertisedToNeighbour(block));
                this.firePropertyChange(PROPERTY_ROUTING, null, newUpdate);
            }
            adj.setMutual(true);
            this.addThroughPath(adj);
            if (newPacketFlow == 0 || newPacketFlow == 4) {
                addRouteLog.debug("From {} inform neighbour of valid routes", (Object)this.getDisplayName());
                this.informNeighbourOfValidRoutes(block);
            }
        }
        return true;
    }

    private int determineAdjPacketFlow(int our, int neigh) {
        updateRouteLog.debug("From {} values passed our {} neigh {}", new Object[]{this.getDisplayName(), this.decodePacketFlow(our), this.decodePacketFlow(neigh)});
        if (our == 0 && neigh == 0) {
            return 0;
        }
        if (neigh == 2) {
            neigh = 4;
        } else if (neigh == 4) {
            neigh = 2;
        }
        if (our == neigh) {
            return our;
        }
        return 8;
    }

    private void informNeighbourOfValidRoutes(Block newblock) {
        ArrayList<Block> validFromPath = new ArrayList<Block>();
        addRouteLog.debug("From {} new block {}", (Object)this.getDisplayName(), (Object)newblock.getDisplayName());
        for (ThroughPaths tp : this.throughPaths) {
            addRouteLog.debug("From {} B through routes {} {}", new Object[]{this.getDisplayName(), tp.getSourceBlock().getDisplayName(), tp.getDestinationBlock().getDisplayName()});
            if (tp.getSourceBlock() == newblock) {
                validFromPath.add(tp.getDestinationBlock());
                continue;
            }
            if (tp.getDestinationBlock() != newblock) continue;
            validFromPath.add(tp.getSourceBlock());
        }
        addRouteLog.debug("From {} ===== valid from size path {} ====", (Object)this.getDisplayName(), (Object)validFromPath.size());
        addRouteLog.debug("To {}", (Object)newblock.getDisplayName());
        LayoutBlock lBnewblock = null;
        Adjacencies adj = this.getAdjacency(newblock);
        if (adj.isMutual()) {
            addRouteLog.debug("From {} adj with {} is mutual", (Object)this.getDisplayName(), (Object)newblock.getDisplayName());
            lBnewblock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(newblock);
        } else {
            addRouteLog.debug("From {} adj with {} is NOT mutual", (Object)this.getDisplayName(), (Object)newblock.getDisplayName());
        }
        if (lBnewblock == null) {
            return;
        }
        for (Routes ro : new ArrayList<Routes>(this.routes)) {
            RoutingPacket update;
            addRouteLog.debug("next:{} dest:{}", (Object)ro.getNextBlock().getDisplayName(), (Object)ro.getDestBlock().getDisplayName());
            if (ro.getNextBlock() == this.getBlock()) {
                addRouteLog.debug("From {} ro next block is this", (Object)this.getDisplayName());
                if (!validFromPath.contains(ro.getDestBlock())) continue;
                addRouteLog.debug("From {} route to {} we have it with a metric of {} we will add our metric of {} this will be sent to {} a", new Object[]{this.getDisplayName(), ro.getDestBlock().getDisplayName(), ro.getMetric(), this.metric, lBnewblock.getDisplayName()});
                update = new RoutingPacket(0, ro.getDestBlock(), ro.getHopCount() + 1, ro.getMetric() + this.metric, ro.getLength() + this.block.getLengthMm(), -1, this.getNextPacketID());
                lBnewblock.addRouteFromNeighbour(this, update);
                continue;
            }
            if (validFromPath.contains(ro.getNextBlock())) {
                addRouteLog.debug("From {} route to {} we have it with a metric of {} we will add our metric of {} this will be sent to {} b", new Object[]{this.getDisplayName(), ro.getDestBlock().getDisplayName(), ro.getMetric(), this.metric, lBnewblock.getDisplayName()});
                if (adj.advertiseRouteToNeighbour(ro)) {
                    addRouteLog.debug("Told to advertise to neighbour");
                    adj.addRouteAdvertisedToNeighbour(ro);
                    update = new RoutingPacket(0, ro.getDestBlock(), ro.getHopCount() + 1, ro.getMetric() + this.metric, ro.getLength() + this.block.getLengthMm(), -1, this.getNextPacketID());
                    lBnewblock.addRouteFromNeighbour(this, update);
                    continue;
                }
                addRouteLog.debug("Not advertised to neighbour");
                continue;
            }
            addRouteLog.debug("failed valid from path Not advertised/added");
        }
    }

    private void addAdjacency(Path addPath) {
        addRouteLog.debug("From {} path to be added {} {}", new Object[]{this.getDisplayName(), addPath.getBlock().getDisplayName(), Path.decodeDirection(addPath.getToBlockDirection())});
        Block destBlockToAdd = addPath.getBlock();
        int ourWorkingDirection = 0;
        if (destBlockToAdd == null) {
            log.error("Found null destination block for path from {}", (Object)this.getDisplayName());
            return;
        }
        if (this.getBlock().isBlockDenied(destBlockToAdd.getDisplayName())) {
            ourWorkingDirection = 2;
        } else if (destBlockToAdd.isBlockDenied(this.getBlock().getDisplayName())) {
            ourWorkingDirection = 4;
        }
        addRouteLog.debug("From {} to block {} we should therefore be... {}", new Object[]{this.getDisplayName(), addPath.getBlock().getDisplayName(), this.decodePacketFlow(ourWorkingDirection)});
        this.addNeighbour(addPath.getBlock(), addPath.getToBlockDirection(), ourWorkingDirection);
    }

    private void removeAdjacency(Path removedPath) {
        Block ablock = removedPath.getBlock();
        if (ablock != null) {
            deleteRouteLog.debug("From {} Adjacency to be removed {} {}", new Object[]{this.getDisplayName(), ablock.getDisplayName(), Path.decodeDirection(removedPath.getToBlockDirection())});
            LayoutBlock layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(ablock);
            if (layoutBlock != null) {
                this.removeAdjacency(layoutBlock);
            }
        } else {
            log.debug("removeAdjacency() removedPath.getBlock() is null");
        }
    }

    private void removeAdjacency(LayoutBlock layoutBlock) {
        int i;
        deleteRouteLog.debug("From {} Adjacency to be removed {}", (Object)this.getDisplayName(), (Object)layoutBlock.getDisplayName());
        Block removedBlock = layoutBlock.getBlock();
        List<Routes> tmpBlock = this.removeRouteReceivedFromNeighbour(removedBlock);
        for (i = this.neighbours.size() - 1; i > -1; --i) {
            if (this.neighbours.get(i).getBlock() != removedBlock) continue;
            layoutBlock.removePropertyChangeListener(this);
            deleteRouteLog.debug("From {} block {} found and removed", (Object)this.getDisplayName(), (Object)removedBlock.getDisplayName());
            LayoutBlock layoutBlockToNotify = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.neighbours.get(i).getBlock());
            if (layoutBlockToNotify == null) {
                log.error("Unable to notify neighbours for block {}", (Object)this.neighbours.get(i).getBlock());
                continue;
            }
            this.getAdjacency(this.neighbours.get(i).getBlock()).dispose();
            this.neighbours.remove(i);
            layoutBlockToNotify.notifiedNeighbourNoLongerMutual(this);
        }
        for (i = this.throughPaths.size() - 1; i > -1; --i) {
            if (this.throughPaths.get(i).getSourceBlock() == removedBlock) {
                if (this.getAdjacency(this.throughPaths.get(i).getSourceBlock()) != null) continue;
                deleteRouteLog.debug("remove {} to {}", (Object)this.throughPaths.get(i).getSourceBlock().getDisplayName(), (Object)this.throughPaths.get(i).getDestinationBlock().getDisplayName());
                this.throughPaths.remove(i);
                continue;
            }
            if (this.throughPaths.get(i).getDestinationBlock() != removedBlock || this.getAdjacency(this.throughPaths.get(i).getDestinationBlock()) != null) continue;
            deleteRouteLog.debug("remove {} to {}", (Object)this.throughPaths.get(i).getSourceBlock().getDisplayName(), (Object)this.throughPaths.get(i).getDestinationBlock().getDisplayName());
            this.throughPaths.remove(i);
        }
        deleteRouteLog.debug("From {} neighbour has been removed - Number of routes to this neighbour removed{}", (Object)this.getDisplayName(), (Object)tmpBlock.size());
        this.notifyNeighboursOfRemoval(tmpBlock, removedBlock);
    }

    private void removeRouteFromNeighbour(LayoutBlock src, RoutingPacket update) {
        InstanceManager.getDefault(LayoutBlockManager.class).setLastRoutingChange();
        Block srcblk = src.getBlock();
        Block destblk = update.getBlock();
        String msgPrefix = "From " + this.getDisplayName() + " notify block " + srcblk.getDisplayName() + " ";
        deleteRouteLog.debug("{} remove route from neighbour called", (Object)msgPrefix);
        if (InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(srcblk) == this) {
            deleteRouteLog.debug("From {} source block is the same as our block! {}", (Object)this.getDisplayName(), (Object)destblk.getDisplayName());
            return;
        }
        deleteRouteLog.debug("{} (Direct Notification) neighbour {} has removed route to {}", new Object[]{msgPrefix, srcblk.getDisplayName(), destblk.getDisplayName()});
        deleteRouteLog.debug("{} routes in table {} Remove route from neighbour", (Object)msgPrefix, (Object)this.routes.size());
        ArrayList<Routes> routesToRemove = new ArrayList<Routes>();
        for (int i = this.routes.size() - 1; i > -1; --i) {
            Routes ro = this.routes.get(i);
            if (ro.getNextBlock() != srcblk || ro.getDestBlock() != destblk) continue;
            routesToRemove.add(new Routes(this.routes.get(i).getDestBlock(), this.routes.get(i).getNextBlock(), 0, 0, 0, 0.0f));
            deleteRouteLog.debug("{} route to {} from block {} to be removed triggered by propertyChange", new Object[]{msgPrefix, ro.getDestBlock().getDisplayName(), ro.getNextBlock().getDisplayName()});
            this.routes.remove(i);
        }
        this.notifyNeighboursOfRemoval(routesToRemove, srcblk);
    }

    private List<Routes> removeRouteReceivedFromNeighbour(Block removedBlock) {
        ArrayList<Routes> tmpBlock = new ArrayList<Routes>();
        for (int j = this.routes.size() - 1; j > -1; --j) {
            Routes ro = this.routes.get(j);
            deleteRouteLog.debug("From {} route to check {} from Block {}", new Object[]{this.getDisplayName(), this.routes.get(j).getDestBlock().getDisplayName(), this.routes.get(j).getNextBlock().getDisplayName()});
            if (ro.getDestBlock() == removedBlock) {
                deleteRouteLog.debug("From {} route to {} from block {} to be removed triggered by adjancey removal as dest block has been removed", new Object[]{this.getDisplayName(), this.routes.get(j).getDestBlock().getDisplayName(), this.routes.get(j).getNextBlock().getDisplayName()});
                if (!tmpBlock.contains(ro)) {
                    tmpBlock.add(ro);
                }
                this.routes.remove(j);
                continue;
            }
            if (ro.getNextBlock() != removedBlock) continue;
            deleteRouteLog.debug("From {} route to {} from block {} to be removed triggered by adjancey removal", new Object[]{this.getDisplayName(), this.routes.get(j).getDestBlock().getDisplayName(), this.routes.get(j).getNextBlock().getDisplayName()});
            if (!tmpBlock.contains(ro)) {
                tmpBlock.add(ro);
            }
            this.routes.remove(j);
        }
        return tmpBlock;
    }

    private void updateNeighbourPacketFlow(Block neighbour, int flow) {
        Adjacencies neighAdj = this.getAdjacency(neighbour);
        if (flow == 2) {
            flow = 4;
        } else if (flow == 4) {
            flow = 2;
        }
        if (neighAdj.getPacketFlow() == flow) {
            return;
        }
        this.updateNeighbourPacketFlow(neighAdj, flow);
    }

    protected void updateNeighbourPacketFlow(Adjacencies neighbour, int flow) {
        if (neighbour.getPacketFlow() == flow) {
            return;
        }
        LayoutBlock neighLBlock = neighbour.getLayoutBlock();
        Runnable r = () -> neighLBlock.updateNeighbourPacketFlow(this.block, flow);
        Block neighBlock = neighbour.getBlock();
        int oldPacketFlow = neighbour.getPacketFlow();
        neighbour.setPacketFlow(flow);
        SwingUtilities.invokeLater(r);
        if (flow == 4) {
            neighBlock.addBlockDenyList(this.block);
            neighLBlock.removePropertyChangeListener(this);
            List<Routes> tmpBlock = this.removeRouteReceivedFromNeighbour(neighBlock);
            this.notifyNeighboursOfRemoval(tmpBlock, neighBlock);
            for (int i = this.throughPaths.size() - 1; i > -1; --i) {
                if (this.throughPaths.get(i).getDestinationBlock() != neighBlock) continue;
                this.throughPaths.remove(i);
                this.firePropertyChange(PROPERTY_THROUGH_PATH_REMOVED, null, null);
            }
            if (oldPacketFlow == 2) {
                this.addThroughPath(neighbour);
            }
        } else if (flow == 2) {
            neighLBlock.addPropertyChangeListener(this);
            neighBlock.removeBlockDenyList(this.block);
            this.block.addBlockDenyList(neighBlock);
            for (int i = this.throughPaths.size() - 1; i > -1; --i) {
                if (this.throughPaths.get(i).getSourceBlock() != neighBlock) continue;
                this.throughPaths.remove(i);
                this.firePropertyChange(PROPERTY_THROUGH_PATH_REMOVED, null, null);
            }
            if (oldPacketFlow == 4) {
                this.routes.add(new Routes(neighBlock, this.getBlock(), 1, neighbour.getDirection(), neighLBlock.getBlockMetric(), neighBlock.getLengthMm()));
                this.addThroughPath(neighbour);
            }
        } else if (flow == 0) {
            neighBlock.removeBlockDenyList(this.block);
            this.block.removeBlockDenyList(neighBlock);
            neighLBlock.addPropertyChangeListener(this);
            if (oldPacketFlow == 4) {
                this.routes.add(new Routes(neighBlock, this.getBlock(), 1, neighbour.getDirection(), neighLBlock.getBlockMetric(), neighBlock.getLengthMm()));
            }
            this.addThroughPath(neighbour);
        }
    }

    private void notifyNeighboursOfRemoval(List<Routes> routesToRemove, Block notifyingblk) {
        String msgPrefix = "From " + this.getDisplayName() + " notify block " + notifyingblk.getDisplayName() + " ";
        deleteRouteLog.debug("{} notifyNeighboursOfRemoval called for routes from {} ===", (Object)msgPrefix, (Object)notifyingblk.getDisplayName());
        boolean notifyvalid = false;
        for (int i = this.neighbours.size() - 1; i > -1; --i) {
            if (this.neighbours.get(i).getBlock() != notifyingblk) continue;
            notifyvalid = true;
        }
        deleteRouteLog.debug("{} The notifying block is still valid? {}", (Object)msgPrefix, (Object)notifyvalid);
        for (int j = routesToRemove.size() - 1; j > -1; --j) {
            boolean stillexist = false;
            Block destBlock = routesToRemove.get(j).getDestBlock();
            Block sourceBlock = routesToRemove.get(j).getNextBlock();
            RoutingPacket newUpdate = new RoutingPacket(4, destBlock, -1, -1, -1.0f, -1, this.getNextPacketID());
            deleteRouteLog.debug("From {} notify block {} checking {} from {}", new Object[]{this.getDisplayName(), notifyingblk.getDisplayName(), destBlock.getDisplayName(), sourceBlock.getDisplayName()});
            ArrayList<Routes> validroute = new ArrayList<Routes>();
            List<Routes> destRoutes = this.getDestRoutes(destBlock);
            for (Routes r : destRoutes) {
                if (r.getNextBlock() == this.getBlock()) {
                    deleteRouteLog.debug("{} The destBlock {} is our neighbour", (Object)msgPrefix, (Object)destBlock.getDisplayName());
                    validroute.add(new Routes(r.getDestBlock(), r.getNextBlock(), 0, 0, 0, 0.0f));
                    stillexist = true;
                    continue;
                }
                deleteRouteLog.debug("{} we still have a route to {} via {} in our list", new Object[]{msgPrefix, destBlock.getDisplayName(), r.getNextBlock().getDisplayName()});
                validroute.add(new Routes(destBlock, r.getNextBlock(), 0, 0, 0, 0.0f));
                stillexist = true;
            }
            if (stillexist) {
                deleteRouteLog.debug("{}A Route still exists", (Object)msgPrefix);
                deleteRouteLog.debug("{} the number of routes installed to block {} is {}", new Object[]{msgPrefix, destBlock.getDisplayName(), validroute.size()});
                if (validroute.size() == 1) {
                    LayoutBlock layoutBlock;
                    Block nextHop = ((Routes)validroute.get(0)).getNextBlock();
                    if (((Routes)validroute.get(0)).getNextBlock() != this.getBlock()) {
                        layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(nextHop);
                        deleteRouteLog.debug("{} We only have a single valid route left to {} So will tell {} we no longer have it", new Object[]{msgPrefix, destBlock.getDisplayName(), layoutBlock == null ? "NULL" : layoutBlock.getDisplayName()});
                        if (layoutBlock != null) {
                            layoutBlock.removeRouteFromNeighbour(this, newUpdate);
                        }
                        this.getAdjacency(nextHop).removeRouteAdvertisedToNeighbour(routesToRemove.get(j));
                    }
                    ArrayList<Block> validNeighboursToNotify = new ArrayList<Block>();
                    for (int i = this.neighbours.size() - 1; i > -1; --i) {
                        if (this.neighbours.get(i).getBlock() == destBlock || this.neighbours.get(i).getBlock() == nextHop || !this.validThroughPath(notifyingblk, this.neighbours.get(i).getBlock())) continue;
                        Block block = this.neighbours.get(i).getBlock();
                        deleteRouteLog.debug("{} we could of potentially sent the route to {}", (Object)msgPrefix, (Object)block.getDisplayName());
                        if (!this.validThroughPath(nextHop, block)) {
                            deleteRouteLog.debug("{} there is no other valid path so will mark for removal", (Object)msgPrefix);
                            validNeighboursToNotify.add(block);
                            continue;
                        }
                        deleteRouteLog.debug("{} there is another valid path so will NOT mark for removal", (Object)msgPrefix);
                    }
                    deleteRouteLog.debug("{} the next block is our selves so we won't remove!", (Object)msgPrefix);
                    deleteRouteLog.debug("{} do we need to find out if we could of send the route to another neighbour such as?", (Object)msgPrefix);
                    for (Block block : validNeighboursToNotify) {
                        if (!this.validThroughPath(block, destBlock)) {
                            layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(block);
                            if (layoutBlock != null) {
                                layoutBlock.removeRouteFromNeighbour(this, newUpdate);
                            }
                            this.getAdjacency(block).removeRouteAdvertisedToNeighbour(routesToRemove.get(j));
                            continue;
                        }
                        deleteRouteLog.debug("{}{} has a valid path to {}", new Object[]{msgPrefix, block.getDisplayName(), destBlock.getDisplayName()});
                    }
                    continue;
                }
                deleteRouteLog.debug("{} routes left to block {}", (Object)msgPrefix, (Object)destBlock.getDisplayName());
                for (Routes item : validroute) {
                    if (this.validThroughPath(notifyingblk, item.getNextBlock())) {
                        deleteRouteLog.debug("{} to {} Is a valid route", (Object)msgPrefix, (Object)item.getNextBlock().getDisplayName());
                        item.setMiscFlags(2);
                        continue;
                    }
                    deleteRouteLog.debug("{} to {} Is not a valid route", (Object)msgPrefix, (Object)item.getNextBlock().getDisplayName());
                    item.setMiscFlags(1);
                }
                for (int i = 0; i < validroute.size(); ++i) {
                    if (((Routes)validroute.get(i)).getMiscFlags() != 2) continue;
                    Block nextblk = ((Routes)validroute.get(i)).getNextBlock();
                    deleteRouteLog.debug("{} route from {} has been flagged for removal", (Object)msgPrefix, (Object)nextblk.getDisplayName());
                    boolean leaveroute = false;
                    for (Routes routes : validroute) {
                        if (routes.getMiscFlags() != 1 || !this.validThroughPath(nextblk, routes.getNextBlock())) continue;
                        deleteRouteLog.debug("{} we have a valid path from {} to {}", new Object[]{msgPrefix, nextblk.getDisplayName(), routes.getNextBlock()});
                        leaveroute = true;
                    }
                    if (!leaveroute) {
                        LayoutBlock layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(nextblk);
                        deleteRouteLog.debug("{}############ We need to send notification to {} to remove route ########### haven't found an example of this yet!", (Object)msgPrefix, (Object)nextblk.getDisplayName());
                        if (layoutBlock == null) {
                            log.error("Unable to fetch block {}", (Object)nextblk);
                            continue;
                        }
                        layoutBlock.removeRouteFromNeighbour(this, newUpdate);
                        this.getAdjacency(nextblk).removeRouteAdvertisedToNeighbour(routesToRemove.get(j));
                        continue;
                    }
                    deleteRouteLog.debug("{} a valid path through exists {} so we will not remove route.", (Object)msgPrefix, (Object)nextblk.getDisplayName());
                }
                continue;
            }
            deleteRouteLog.debug("{} We have no other routes to {} Therefore we will broadast this to our neighbours", (Object)msgPrefix, (Object)destBlock.getDisplayName());
            for (Adjacencies adj : this.neighbours) {
                adj.removeRouteAdvertisedToNeighbour(destBlock);
            }
            this.firePropertyChange(PROPERTY_ROUTING, null, newUpdate);
        }
        deleteRouteLog.debug("{} finshed check and notifying of removed routes from {} ===", (Object)msgPrefix, (Object)notifyingblk.getDisplayName());
    }

    private void addThroughPath(@Nonnull Adjacencies adj) {
        Block newAdj = adj.getBlock();
        int packetFlow = adj.getPacketFlow();
        addRouteLog.debug("From {} addThroughPathCalled with adj {}", (Object)this.getDisplayName(), (Object)adj.getBlock().getDisplayName());
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() == newAdj) continue;
            int neighPacketFlow = neighbour.getPacketFlow();
            addRouteLog.debug("From {} our direction: {}, neighbour direction: {}", new Object[]{this.getDisplayName(), this.decodePacketFlow(packetFlow), this.decodePacketFlow(neighPacketFlow)});
            if (packetFlow == 0 && neighPacketFlow == 0) {
                this.addThroughPath(neighbour.getBlock(), newAdj);
                this.addThroughPath(newAdj, neighbour.getBlock());
                continue;
            }
            if (packetFlow == 2 && neighPacketFlow == 4) {
                this.addThroughPath(neighbour.getBlock(), newAdj);
                continue;
            }
            if (packetFlow == 4 && neighPacketFlow == 2) {
                this.addThroughPath(newAdj, neighbour.getBlock());
                continue;
            }
            if (packetFlow == 0 && neighPacketFlow == 4) {
                this.addThroughPath(neighbour.getBlock(), newAdj);
                continue;
            }
            if (packetFlow == 0 && neighPacketFlow == 2) {
                this.addThroughPath(newAdj, neighbour.getBlock());
                continue;
            }
            if (packetFlow == 2 && neighPacketFlow == 0) {
                this.addThroughPath(neighbour.getBlock(), newAdj);
                continue;
            }
            if (packetFlow == 4 && neighPacketFlow == 0) {
                this.addThroughPath(newAdj, neighbour.getBlock());
                continue;
            }
            addRouteLog.debug("Invalid combination {} and {}", (Object)this.decodePacketFlow(packetFlow), (Object)this.decodePacketFlow(neighPacketFlow));
        }
    }

    private void addThroughPath(@Nonnull Block srcBlock, @Nonnull Block dstBlock) {
        addRouteLog.debug("Block {}.addThroughPath(src:{}, dst: {})", new Object[]{this.getDisplayName(), srcBlock.getDisplayName(), dstBlock.getDisplayName()});
        if (this.block != null && !this.panels.isEmpty()) {
            LayoutEditor panel = this.panels.get(0);
            List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
            if (this.panels.size() > 1) {
                for (int i = 1; i < this.panels.size(); ++i) {
                    if (c.size() >= this.panels.get(i).getLEAuxTools().getConnectivityList(this).size()) continue;
                    panel = this.panels.get(i);
                    c = panel.getLEAuxTools().getConnectivityList(this);
                }
                for (LayoutEditor tPanel : this.panels) {
                    int response;
                    if (tPanel == panel || !InstanceManager.getDefault(LayoutBlockManager.class).warn() || this.compareConnectivity(c, tPanel.getLEAuxTools().getConnectivityList(this)) || (response = JmriJOptionPane.showOptionDialog(null, MessageFormat.format(Bundle.getMessage("Warn1"), this.getUserName(), tPanel.getLayoutName(), panel.getLayoutName()), Bundle.getMessage("WarningTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonOKPlus")}, Bundle.getMessage("ButtonOK"))) != 1) continue;
                    InstanceManager.getDefault(LayoutBlockManager.class).turnOffWarning();
                }
            }
            this.addThroughPath(srcBlock, dstBlock, panel);
        }
    }

    private void addThroughPath(Block srcBlock, Block dstBlock, LayoutEditor panel) {
        List<LayoutTrackExpectedState<LayoutTurnout>> tmpdtos;
        List<LayoutTrackExpectedState<LayoutTurnout>> stod;
        this.layoutConnectivity = true;
        if (srcBlock == dstBlock) {
            return;
        }
        addRouteLog.debug("Block {}.addThroughPath(src:{}, dst: {}, <panel>)", new Object[]{this.getDisplayName(), srcBlock.getDisplayName(), dstBlock.getDisplayName()});
        boolean add = true;
        for (ThroughPaths throughPath : this.throughPaths) {
            if (throughPath.getSourceBlock() != srcBlock || throughPath.getDestinationBlock() != dstBlock) continue;
            add = false;
        }
        if (!add) {
            return;
        }
        addRouteLog.debug("Block {}, src: {}, dst: {}", new Object[]{this.block.getDisplayName(), srcBlock.getDisplayName(), dstBlock.getDisplayName()});
        this.connection = panel.getConnectivityUtil();
        try {
            MDC.put((String)"loggingDisabled", (String)this.connection.getClass().getCanonicalName());
            stod = this.connection.getTurnoutList(this.block, srcBlock, dstBlock, true);
            MDC.remove((String)"loggingDisabled");
        }
        catch (NullPointerException ex) {
            MDC.remove((String)"loggingDisabled");
            if (addRouteLog.isDebugEnabled()) {
                log.error("Exception ({}) caught while trying to discover turnout connectivity\nBlock: {}, srcBlock ({}) to dstBlock ({})", new Object[]{ex.getMessage(), this.block.getDisplayName(), srcBlock.getDisplayName(), dstBlock.getDisplayName()});
                log.error("@ Line # {}", (Object)ex.getStackTrace()[1].getLineNumber());
            }
            return;
        }
        if (!this.connection.isTurnoutConnectivityComplete()) {
            this.layoutConnectivity = false;
        }
        try {
            MDC.put((String)"loggingDisabled", (String)this.connection.getClass().getName());
            tmpdtos = this.connection.getTurnoutList(this.block, dstBlock, srcBlock, true);
            MDC.remove((String)"loggingDisabled");
        }
        catch (NullPointerException ex) {
            MDC.remove((String)"loggingDisabled");
            addRouteLog.debug("Exception ({}) caught while trying to discover turnout connectivity\nBlock: {}, dstBlock ({}) to  srcBlock ({})", new Object[]{ex.getMessage(), this.block.getDisplayName(), dstBlock.getDisplayName(), srcBlock.getDisplayName()});
            addRouteLog.debug("@ Line # {}", (Object)ex.getStackTrace()[1].getLineNumber());
            return;
        }
        if (!this.connection.isTurnoutConnectivityComplete()) {
            this.layoutConnectivity = false;
        }
        if (stod.size() == tmpdtos.size()) {
            int i;
            ArrayList<LayoutTrackExpectedState<LayoutTurnout>> dtos = new ArrayList<LayoutTrackExpectedState<LayoutTurnout>>();
            for (i = tmpdtos.size(); i > 0; --i) {
                dtos.add(tmpdtos.get(i - 1));
            }
            addRouteLog.debug("From {} destination size {} v source size {}", new Object[]{this.getDisplayName(), dtos.size(), stod.size()});
            for (i = 0; i < dtos.size(); ++i) {
                if (((LayoutTrackExpectedState)dtos.get(i)).getObject() == stod.get(i).getObject()) continue;
                addRouteLog.debug("{} != {}: will quit", ((LayoutTrackExpectedState)dtos.get(i)).getObject(), stod.get(i).getObject());
                return;
            }
            for (i = 0; i < dtos.size(); ++i) {
                int y;
                int x = stod.get(i).getExpectedState();
                if (x != (y = ((LayoutTrackExpectedState)dtos.get(i)).getExpectedState().intValue())) {
                    addRouteLog.debug("{} not on setting equal will quit {}, {}", new Object[]{this.block.getDisplayName(), x, y});
                    return;
                }
                if (x != 1) continue;
                addRouteLog.debug("{} turnout state returned as UNKNOWN", (Object)this.block.getDisplayName());
                return;
            }
            HashSet<LayoutTurnout> set = new HashSet<LayoutTurnout>();
            for (LayoutTrackExpectedState<LayoutTurnout> layoutTurnoutLayoutTrackExpectedState : stod) {
                boolean val = set.add((LayoutTurnout)layoutTurnoutLayoutTrackExpectedState.getObject());
                if (val) continue;
                return;
            }
            this.addThroughPathPostChecks(srcBlock, dstBlock, stod);
        } else {
            addRouteLog.debug("sizes are not the same therefore, we will do some further checks");
            List<LayoutTrackExpectedState<LayoutTurnout>> maxt = stod.size() >= tmpdtos.size() ? stod : tmpdtos;
            HashSet<LayoutTrackExpectedState<LayoutTurnout>> set = new HashSet<LayoutTrackExpectedState<LayoutTurnout>>(maxt);
            if (set.size() == maxt.size()) {
                addRouteLog.debug("All turnouts are unique so potentially a valid path");
                boolean allowAddition = false;
                for (LayoutTrackExpectedState<LayoutTurnout> layoutTurnoutLayoutTrackExpectedState : maxt) {
                    LayoutTurnout turn = (LayoutTurnout)layoutTurnoutLayoutTrackExpectedState.getObject();
                    if (turn.type != LayoutTurnout.TurnoutType.DOUBLE_XOVER) continue;
                    allowAddition = true;
                    if (layoutTurnoutLayoutTrackExpectedState.getExpectedState() == 2) {
                        layoutTurnoutLayoutTrackExpectedState.setExpectedState(4);
                        continue;
                    }
                    layoutTurnoutLayoutTrackExpectedState.setExpectedState(2);
                }
                if (allowAddition) {
                    addRouteLog.debug("addition allowed");
                    this.addThroughPathPostChecks(srcBlock, dstBlock, maxt);
                } else {
                    addRouteLog.debug("No double cross-over so not a valid path");
                }
            }
        }
    }

    private void addThroughPathPostChecks(Block srcBlock, Block dstBlock, List<LayoutTrackExpectedState<LayoutTurnout>> stod) {
        List<Path> paths = this.block.getPaths();
        Path srcPath = null;
        for (Path path : paths) {
            if (path.getBlock() != srcBlock) continue;
            srcPath = path;
        }
        Path dstPath = null;
        for (Path value : paths) {
            if (value.getBlock() != dstBlock) continue;
            dstPath = value;
        }
        ThroughPaths throughPaths = new ThroughPaths(srcBlock, srcPath, dstBlock, dstPath);
        throughPaths.setTurnoutList(stod);
        addRouteLog.debug("From {} added Throughpath {} {}", new Object[]{this.getDisplayName(), throughPaths.getSourceBlock().getDisplayName(), throughPaths.getDestinationBlock().getDisplayName()});
        this.throughPaths.add(throughPaths);
        this.firePropertyChange(PROPERTY_THROUGH_PATH_ADDED, null, null);
        this.informNeighbourOfValidRoutes(srcBlock);
        this.informNeighbourOfValidRoutes(dstBlock);
    }

    void notifiedNeighbourNoLongerMutual(LayoutBlock srcBlock) {
        deleteRouteLog.debug("From {}Notification from neighbour that it is no longer our friend {}", (Object)this.getDisplayName(), (Object)srcBlock.getDisplayName());
        Block blk = srcBlock.getBlock();
        for (int i = this.neighbours.size() - 1; i > -1; --i) {
            if (this.neighbours.get(i).getBlock() != blk) continue;
            this.removeAdjacency(srcBlock);
            break;
        }
    }

    void stateUpdate() {
        updateRouteLog.trace("From {} A block state change ({}) has occurred", (Object)this.getDisplayName(), (Object)this.getBlockStatusString());
        RoutingPacket update = new RoutingPacket(2, this.getBlock(), -1, -1, -1.0f, this.getBlockStatus(), this.getNextPacketID());
        this.firePropertyChange(PROPERTY_ROUTING, null, update);
    }

    int getBlockStatus() {
        if (this.getOccupancy() == 2) {
            this.useExtraColor = false;
            return 2;
        }
        if (this.useExtraColor) {
            return 8;
        }
        if (this.getOccupancy() == 4) {
            return 4;
        }
        return 1;
    }

    String getBlockStatusString() {
        String result = "UNKNOWN";
        if (this.getOccupancy() == 2) {
            result = "OCCUPIED";
        } else if (this.useExtraColor) {
            result = "RESERVED";
        } else if (this.getOccupancy() == 4) {
            result = "EMPTY";
        }
        return result;
    }

    Integer getNextPacketID() {
        Integer lastID;
        if (updateReferences.isEmpty()) {
            lastID = 0;
        } else {
            int lastIDPos = updateReferences.size() - 1;
            lastID = updateReferences.get(lastIDPos) + 1;
        }
        if (lastID > 2000) {
            lastID = 0;
        }
        updateReferences.add(lastID);
        this.actedUponUpdates.add(lastID);
        if (updateReferences.size() > 500) {
            updateReferences.subList(0, 250).clear();
        }
        if (this.actedUponUpdates.size() > 500) {
            this.actedUponUpdates.subList(0, 250).clear();
        }
        return lastID;
    }

    boolean updatePacketActedUpon(Integer packetID) {
        return this.actedUponUpdates.contains(packetID);
    }

    public List<Block> getActiveNextBlocks(Block source) {
        ArrayList<Block> currentPath = new ArrayList<Block>();
        for (ThroughPaths path : this.throughPaths) {
            if (path.getSourceBlock() != source || !path.isPathActive()) continue;
            currentPath.add(path.getDestinationBlock());
        }
        return currentPath;
    }

    public Path getThroughPathSourcePathAtIndex(int i) {
        return this.throughPaths.get(i).getSourcePath();
    }

    public Path getThroughPathDestinationPathAtIndex(int i) {
        return this.throughPaths.get(i).getDestinationPath();
    }

    public boolean validThroughPath(Block sourceBlock, Block destinationBlock) {
        for (ThroughPaths throughPath : this.throughPaths) {
            if (throughPath.getSourceBlock() == sourceBlock && throughPath.getDestinationBlock() == destinationBlock) {
                return true;
            }
            if (throughPath.getSourceBlock() != destinationBlock || throughPath.getDestinationBlock() != sourceBlock) continue;
            return true;
        }
        return false;
    }

    public int getThroughPathIndex(Block sourceBlock, Block destinationBlock) {
        for (int i = 0; i < this.throughPaths.size(); ++i) {
            if (this.throughPaths.get(i).getSourceBlock() == sourceBlock && this.throughPaths.get(i).getDestinationBlock() == destinationBlock) {
                return i;
            }
            if (this.throughPaths.get(i).getSourceBlock() != destinationBlock || this.throughPaths.get(i).getDestinationBlock() != sourceBlock) continue;
            return i;
        }
        return -1;
    }

    String decodePacketFlow(int value) {
        switch (value) {
            case 0: {
                return "Bi-Direction Operation";
            }
            case 2: {
                return "Uni-Directional - Trains can only exit to this block (RX) ";
            }
            case 4: {
                return "Uni-Directional - Trains can not be sent down this block (TX) ";
            }
            case 8: {
                return "None routing updates will be passed";
            }
        }
        log.warn("Unhandled packet flow value: {}", (Object)value);
        return "Unknown";
    }

    public void printValidThroughPaths() {
        log.info("Through paths for block {}", (Object)this.getDisplayName());
        log.info("Current Block, From Block, To Block");
        for (ThroughPaths tp : this.throughPaths) {
            String activeStr = "";
            if (tp.isPathActive()) {
                activeStr = ", *";
            }
            log.info("From {}, {}, {}{}", new Object[]{this.getDisplayName(), tp.getSourceBlock().getDisplayName(), tp.getDestinationBlock().getDisplayName(), activeStr});
        }
    }

    public void printAdjacencies() {
        log.info("Adjacencies for block {}", (Object)this.getDisplayName());
        log.info("Neighbour, Direction, mutual, relationship, metric");
        for (Adjacencies neighbour : this.neighbours) {
            log.info(" neighbor: {}, {}, {}, {}, {}", new Object[]{neighbour.getBlock().getDisplayName(), Path.decodeDirection(neighbour.getDirection()), neighbour.isMutual(), this.decodePacketFlow(neighbour.getPacketFlow()), neighbour.getMetric()});
        }
    }

    public void printRoutes() {
        log.info("Routes for block {}", (Object)this.getDisplayName());
        log.info("Destination, Next Block, Hop Count, Direction, State, Metric");
        for (Routes r : this.routes) {
            String nexthop = r.getNextBlock().getDisplayName();
            if (r.getNextBlock() == this.getBlock()) {
                nexthop = "Directly Connected";
            }
            String activeString = "";
            if (r.isRouteCurrentlyValid()) {
                activeString = ", *";
            }
            log.info(" neighbor: {}, {}, {}, {}, {}, {}{}", new Object[]{r.getDestBlock().getDisplayName(), nexthop, r.getHopCount(), Path.decodeDirection(r.getDirection()), r.getState(), r.getMetric(), activeString});
        }
    }

    public void printRoutes(String inBlockName) {
        log.info("Routes for block {}", (Object)this.getDisplayName());
        log.info("Our Block, Destination, Next Block, Hop Count, Direction, Metric");
        for (Routes route : this.routes) {
            if (!route.getDestBlock().getDisplayName().equals(inBlockName)) continue;
            log.info("From {}, {}, {}, {}, {}, {}", new Object[]{this.getDisplayName(), route.getDestBlock().getDisplayName(), route.getNextBlock().getDisplayName(), route.getHopCount(), Path.decodeDirection(route.getDirection()), route.getMetric()});
        }
    }

    public Block getNextBlock(Block destBlock, int direction) {
        int bestMetric = 965000;
        Block bestBlock = null;
        for (Routes r : this.routes) {
            if (r.getDestBlock() != destBlock || r.getDirection() != direction || r.getMetric() >= bestMetric) continue;
            bestMetric = r.getMetric();
            bestBlock = r.getNextBlock();
        }
        return bestBlock;
    }

    @CheckForNull
    public Block getNextBlock(Block previousBlock, Block destBlock) {
        int bestMetric = 965000;
        Block bestBlock = null;
        for (Routes r : this.routes) {
            if (r.getDestBlock() != destBlock || !this.validThroughPath(previousBlock, r.getNextBlock()) || r.getMetric() >= bestMetric) continue;
            bestMetric = r.getMetric();
            bestBlock = r.getNextBlock();
        }
        return bestBlock;
    }

    public int getConnectedBlockRouteIndex(Block destBlock, int direction) {
        for (int i = 0; i < this.routes.size(); ++i) {
            if (this.routes.get(i).getNextBlock() == this.getBlock()) {
                log.info("Found a block that is directly connected");
                if (this.routes.get(i).getDestBlock() == destBlock) {
                    log.info("In getConnectedBlockRouteIndex,  {}", (Object)Integer.toString(this.routes.get(i).getDirection() & direction));
                    if ((this.routes.get(i).getDirection() & direction) != 0) {
                        return i;
                    }
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("From {}, {}, nexthop {}, {}, {}, {}", new Object[]{this.getDisplayName(), this.routes.get(i).getDestBlock().getDisplayName(), this.routes.get(i).getHopCount(), Path.decodeDirection(this.routes.get(i).getDirection()), this.routes.get(i).getState(), this.routes.get(i).getMetric()});
        }
        return -1;
    }

    public int getNextBlockByIndex(Block destBlock, int direction, int offSet) {
        for (int i = offSet; i < this.routes.size(); ++i) {
            Routes ro = this.routes.get(i);
            if (ro.getDestBlock() != destBlock) continue;
            log.info("getNextBlockByIndex {}", (Object)Integer.toString(ro.getDirection() & direction));
            if ((ro.getDirection() & direction) == 0) continue;
            return i;
        }
        return -1;
    }

    public int getNextBlockByIndex(Block previousBlock, Block destBlock, int offSet) {
        for (int i = offSet; i < this.routes.size(); ++i) {
            Routes ro = this.routes.get(i);
            if (ro.getDestBlock() != destBlock) continue;
            if (this.validThroughPath(previousBlock, ro.getNextBlock())) {
                log.debug("valid through path");
                return i;
            }
            if (ro.getNextBlock() != this.getBlock()) continue;
            log.debug("getNextBlock is this block therefore directly connected");
            return i;
        }
        return -1;
    }

    public int getNextBestBlock(Block previousBlock, Block destBlock, List<Integer> excludeBlock, LayoutBlockConnectivityTools.Metric routingMethod) {
        searchRouteLog.debug("From {} find best route from {} to {} index {} routingMethod {}", new Object[]{this.getDisplayName(), previousBlock.getDisplayName(), destBlock.getDisplayName(), excludeBlock, routingMethod});
        int bestCount = 965255;
        int bestIndex = -1;
        int lastValue = 0;
        ArrayList<Block> nextBlocks = new ArrayList<Block>(5);
        if (!excludeBlock.isEmpty() && excludeBlock.get(excludeBlock.size() - 1) < this.routes.size()) {
            lastValue = routingMethod == LayoutBlockConnectivityTools.Metric.METRIC ? this.routes.get(excludeBlock.get(excludeBlock.size() - 1)).getMetric() : this.routes.get(excludeBlock.get(excludeBlock.size() - 1)).getHopCount();
            for (int i : excludeBlock) {
                nextBlocks.add(this.routes.get(i).getNextBlock());
            }
            searchRouteLog.debug("last index is {} {}", (Object)excludeBlock.get(excludeBlock.size() - 1), (Object)this.routes.get(excludeBlock.get(excludeBlock.size() - 1)).getDestBlock().getDisplayName());
        }
        for (int i = 0; i < this.routes.size(); ++i) {
            int currentValue;
            Routes ro;
            if (excludeBlock.contains(i) || nextBlocks.contains((ro = this.routes.get(i)).getNextBlock()) || (currentValue = routingMethod == LayoutBlockConnectivityTools.Metric.METRIC ? this.routes.get(i).getMetric() : this.routes.get(i).getHopCount()) < lastValue || ro.getDestBlock() != destBlock) continue;
            searchRouteLog.debug("Match on dest blocks");
            searchRouteLog.debug("Is valid through path previous block {} to {}", (Object)previousBlock.getDisplayName(), (Object)ro.getNextBlock().getDisplayName());
            if (this.validThroughPath(previousBlock, ro.getNextBlock())) {
                searchRouteLog.debug("valid through path");
                if (routingMethod == LayoutBlockConnectivityTools.Metric.METRIC) {
                    if (ro.getMetric() < bestCount) {
                        bestIndex = i;
                        bestCount = ro.getMetric();
                    }
                } else if (ro.getHopCount() < bestCount) {
                    bestIndex = i;
                    bestCount = ro.getHopCount();
                }
            }
            if (ro.getNextBlock() != this.getBlock()) continue;
            searchRouteLog.debug("getNextBlock is this block therefore directly connected");
            return i;
        }
        searchRouteLog.debug("returning {} best count {}", (Object)bestIndex, (Object)bestCount);
        return bestIndex;
    }

    @CheckForNull
    Routes getRouteByDestBlock(Block blk) {
        for (int i = this.routes.size() - 1; i > -1; --i) {
            if (this.routes.get(i).getDestBlock() != blk) continue;
            return this.routes.get(i);
        }
        return null;
    }

    @Nonnull
    List<Routes> getRouteByNeighbour(Block blk) {
        ArrayList<Routes> rtr = new ArrayList<Routes>();
        for (Routes route : this.routes) {
            if (route.getNextBlock() != blk) continue;
            rtr.add(route);
        }
        return rtr;
    }

    int getAdjacencyPacketFlow(Block blk) {
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() != blk) continue;
            return neighbour.getPacketFlow();
        }
        return -1;
    }

    boolean isValidNeighbour(Block blk) {
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() != blk) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == this) {
            log.debug("adding ourselves as a listener for some strange reason! Skipping");
            return;
        }
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block6 : switch (e.getPropertyName()) {
            case "NewRoute": {
                updateRouteLog.debug("==Event type {} New {}", (Object)e.getPropertyName(), (Object)((LayoutBlock)e.getNewValue()).getDisplayName());
                break;
            }
            case "through-path-added": {
                updateRouteLog.debug("neighbour has new through path");
                break;
            }
            case "through-path-removed": {
                updateRouteLog.debug("neighbour has through removed");
                break;
            }
            case "routing": {
                if (!(e.getSource() instanceof LayoutBlock)) break;
                LayoutBlock sourceLayoutBlock = (LayoutBlock)e.getSource();
                updateRouteLog.debug("From {} we have a routing packet update from neighbour {}", (Object)this.getDisplayName(), (Object)sourceLayoutBlock.getDisplayName());
                RoutingPacket update = (RoutingPacket)e.getNewValue();
                int updateType = update.getPacketType();
                switch (updateType) {
                    case 0: {
                        updateRouteLog.debug("\t    updateType: Addition");
                        this.addRouteFromNeighbour(sourceLayoutBlock, update);
                        break block6;
                    }
                    case 2: {
                        updateRouteLog.debug("\t    updateType: Update");
                        this.updateRoutingInfo(sourceLayoutBlock, update);
                        break block6;
                    }
                    case 4: {
                        updateRouteLog.debug("\t    updateType: Removal");
                        InstanceManager.getDefault(LayoutBlockManager.class).setLastRoutingChange();
                        this.removeRouteFromNeighbour(sourceLayoutBlock, update);
                        break block6;
                    }
                }
                break;
            }
            default: {
                log.debug("Unhandled propertyChange({}): ", (Object)e);
            }
        }
    }

    @CheckForNull
    Routes getValidRoute(Block nxtBlock, Block dstBlock) {
        if (nxtBlock != null && dstBlock != null) {
            List<Routes> rtr = this.getRouteByNeighbour(nxtBlock);
            if (rtr.isEmpty()) {
                log.debug("From {}, no routes returned for getRouteByNeighbour({})", (Object)this.getDisplayName(), (Object)nxtBlock.getDisplayName());
                return null;
            }
            for (Routes rt : rtr) {
                if (rt.getDestBlock() != dstBlock) continue;
                log.debug("From {}, found dest {}.", (Object)this.getDisplayName(), (Object)dstBlock.getDisplayName());
                return rt;
            }
            log.debug("From {}, no routes to {}.", (Object)this.getDisplayName(), (Object)nxtBlock.getDisplayName());
        } else {
            log.warn("getValidRoute({}, {}", (Object)(nxtBlock != null ? nxtBlock.getDisplayName() : "<null>"), (Object)(dstBlock != null ? dstBlock.getDisplayName() : "<null>"));
        }
        return null;
    }

    public boolean isRouteToDestValid(Block protecting, Block destination) {
        if (protecting == destination) {
            log.debug("protecting and destination blocks are the same therefore we need to check if we have a valid neighbour");
            if (this.getAdjacency(protecting) != null) {
                return true;
            }
        } else if (this.getValidRoute(protecting, destination) != null) {
            return true;
        }
        return false;
    }

    List<Routes> getDestRoutes(Block dstBlock) {
        ArrayList<Routes> rtr = new ArrayList<Routes>();
        for (Routes route : this.routes) {
            if (route.getDestBlock() != dstBlock) continue;
            rtr.add(route);
        }
        return rtr;
    }

    List<Routes> getNextRoutes(Block nxtBlock) {
        ArrayList<Routes> rtr = new ArrayList<Routes>();
        for (Routes route : this.routes) {
            if (route.getNextBlock() != nxtBlock) continue;
            rtr.add(route);
        }
        return rtr;
    }

    void updateRoutingInfo(Routes route) {
        if (route.getHopCount() >= 254) {
            return;
        }
        Block destBlock = route.getDestBlock();
        RoutingPacket update = new RoutingPacket(2, destBlock, this.getBestRouteByHop(destBlock).getHopCount() + 1, this.getBestRouteByMetric(destBlock).getMetric() + this.metric, (float)this.getBestRouteByMetric(destBlock).getMetric() + this.block.getLengthMm(), -1, this.getNextPacketID());
        this.firePropertyChange(PROPERTY_ROUTING, null, update);
    }

    void updateRoutingInfo(@Nonnull LayoutBlock src, @Nonnull RoutingPacket update) {
        Object newUpdate;
        List<Block> messageRecipients;
        RoutingPacket newUpdate2;
        List<Block> messageRecipients2;
        List<Routes> neighbourRoute;
        boolean forwardUpdate;
        Routes ro;
        updateRouteLog.debug("From {} src: {}, block: {}, hopCount: {}, metric: {}, status: {}, packetID: {}", new Object[]{this.getDisplayName(), src.getDisplayName(), update.getBlock().getDisplayName(), update.getHopCount(), update.getMetric(), update.getBlockState(), update.getPacketId()});
        Block srcblk = src.getBlock();
        Adjacencies adj = this.getAdjacency(srcblk);
        if (adj == null) {
            updateRouteLog.debug("From {} packet is from a src that is not registered {}", (Object)this.getDisplayName(), (Object)srcblk.getDisplayName());
            return;
        }
        if (this.updatePacketActedUpon(update.getPacketId()) && adj.updatePacketActedUpon(update.getPacketId())) {
            updateRouteLog.debug("Reject packet update as we have already acted up on it from this neighbour");
            return;
        }
        updateRouteLog.debug("From {} an Update packet from neighbour {}", (Object)this.getDisplayName(), (Object)src.getDisplayName());
        Block updateBlock = update.getBlock();
        if (updateBlock == this.getBlock()) {
            updateRouteLog.debug("Reject packet update as it is a route advertised by our selves");
            return;
        }
        boolean neighbour = false;
        if (updateBlock == srcblk) {
            ro = this.getValidRoute(this.getBlock(), updateBlock);
            neighbour = true;
        } else {
            ro = this.getValidRoute(srcblk, updateBlock);
        }
        if (ro == null) {
            updateRouteLog.debug("From {} update is from a source that we do not have listed as a route to the destination", (Object)this.getDisplayName());
            updateRouteLog.debug("From {} update packet is for a block that we do not have route registered for {}", (Object)this.getDisplayName(), (Object)updateBlock.getDisplayName());
            return;
        }
        this.actedUponUpdates.add(update.getPacketId());
        adj.addPacketReceivedFromNeighbour(update.getPacketId());
        int hopCount = update.getHopCount();
        int packetmetric = update.getMetric();
        int blockstate = update.getBlockState();
        float length = update.getLength();
        if (hopCount != -1) {
            if (ro.getHopCount() != hopCount) {
                updateRouteLog.debug("{} Hop counts to {} not the same so will change from {} to {}", new Object[]{this.getDisplayName(), ro.getDestBlock().getDisplayName(), ro.getHopCount(), hopCount});
                ro.setHopCount(hopCount);
                ++hopCount;
            } else {
                hopCount = -1;
            }
        }
        if ((int)length != -1) {
            float oldLength = ro.getLength();
            if (!MathUtil.equals(oldLength, length)) {
                ro.setLength(length);
                forwardUpdate = true;
                if (ro != this.getBestRouteByLength(update.getBlock())) {
                    forwardUpdate = false;
                }
                updateRouteLog.debug("From {} updating length from {} to {}", new Object[]{this.getDisplayName(), Float.valueOf(oldLength), Float.valueOf(length)});
                if (neighbour) {
                    length = srcblk.getLengthMm();
                    adj.setLength(length);
                    if (forwardUpdate) {
                        neighbourRoute = this.getNextRoutes(srcblk);
                        for (Routes nRo : neighbourRoute) {
                            float updateLength = nRo.getLength();
                            updateLength = updateLength - oldLength + length;
                            updateRouteLog.debug("From {} update metric for route {} from {} to {}", new Object[]{this.getDisplayName(), nRo.getDestBlock().getDisplayName(), Float.valueOf(nRo.getLength()), Float.valueOf(updateLength)});
                            nRo.setLength(updateLength);
                            messageRecipients2 = this.getThroughPathDestinationBySource(srcblk);
                            newUpdate2 = new RoutingPacket(2, nRo.getDestBlock(), -1, -1, updateLength + this.block.getLengthMm(), -1, this.getNextPacketID());
                            this.updateRoutesToNeighbours(messageRecipients2, nRo, newUpdate2);
                        }
                    }
                } else if (forwardUpdate) {
                    messageRecipients = this.getThroughPathSourceByDestination(srcblk);
                    newUpdate = new RoutingPacket(2, updateBlock, -1, -1, length + this.block.getLengthMm(), -1, update.getPacketId());
                    this.updateRoutesToNeighbours(messageRecipients, ro, (RoutingPacket)newUpdate);
                }
                length += (float)this.metric;
            } else {
                length = -1.0f;
            }
        }
        if (packetmetric != -1) {
            int oldmetric = ro.getMetric();
            if (oldmetric != packetmetric) {
                ro.setMetric(packetmetric);
                updateRouteLog.debug("From {} updating metric from {} to {}", new Object[]{this.getDisplayName(), oldmetric, packetmetric});
                forwardUpdate = true;
                if (ro != this.getBestRouteByMetric(update.getBlock())) {
                    forwardUpdate = false;
                }
                if (neighbour) {
                    packetmetric = src.getBlockMetric();
                    adj.setMetric(packetmetric);
                    if (forwardUpdate) {
                        neighbourRoute = this.getNextRoutes(srcblk);
                        for (Routes nRo : neighbourRoute) {
                            int updatemet = nRo.getMetric();
                            updatemet = updatemet - oldmetric + packetmetric;
                            updateRouteLog.debug("From {} update metric for route {} from {} to {}", new Object[]{this.getDisplayName(), nRo.getDestBlock().getDisplayName(), nRo.getMetric(), updatemet});
                            nRo.setMetric(updatemet);
                            messageRecipients2 = this.getThroughPathDestinationBySource(srcblk);
                            newUpdate2 = new RoutingPacket(2, nRo.getDestBlock(), hopCount, updatemet + this.metric, -1.0f, -1, this.getNextPacketID());
                            this.updateRoutesToNeighbours(messageRecipients2, nRo, newUpdate2);
                        }
                    }
                } else if (forwardUpdate) {
                    messageRecipients = this.getThroughPathSourceByDestination(srcblk);
                    newUpdate = new RoutingPacket(2, updateBlock, hopCount, packetmetric + this.metric, -1.0f, -1, update.getPacketId());
                    this.updateRoutesToNeighbours(messageRecipients, ro, (RoutingPacket)newUpdate);
                }
                packetmetric += this.metric;
            } else {
                packetmetric = -1;
            }
        }
        if (blockstate != -1) {
            boolean stateUpdated = false;
            List<Routes> rtr = this.getDestRoutes(updateBlock);
            for (Routes rt : rtr) {
                if (rt.getState() == blockstate) continue;
                stateUpdated = true;
                rt.stateChange();
            }
            if (stateUpdated) {
                RoutingPacket newUpdate3 = new RoutingPacket(2, updateBlock, -1, -1, -1.0f, blockstate, this.getNextPacketID());
                this.firePropertyChange(PROPERTY_ROUTING, null, newUpdate3);
            }
        }
        if (packetmetric != -1 || hopCount != -1 || length != -1.0f) {
            List<Block> messageRecipients3 = this.getThroughPathSourceByDestination(srcblk);
            RoutingPacket newUpdate4 = new RoutingPacket(2, updateBlock, hopCount, packetmetric, length, blockstate, update.getPacketId());
            this.updateRoutesToNeighbours(messageRecipients3, ro, newUpdate4);
        }
    }

    void updateRoutesToNeighbours(List<Block> messageRecipients, Routes ro, RoutingPacket update) {
        for (Block messageRecipient : messageRecipients) {
            Adjacencies adj = this.getAdjacency(messageRecipient);
            if (!adj.advertiseRouteToNeighbour(ro)) continue;
            adj.addRouteAdvertisedToNeighbour(ro);
            LayoutBlock recipient = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(messageRecipient);
            if (recipient == null) continue;
            recipient.updateRoutingInfo(this, update);
        }
    }

    Routes getBestRouteByMetric(Block dest) {
        int bestMetric = 965000;
        int bestIndex = -1;
        List<Routes> destRoutes = this.getDestRoutes(dest);
        for (int i = 0; i < destRoutes.size(); ++i) {
            if (destRoutes.get(i).getMetric() >= bestMetric) continue;
            bestMetric = destRoutes.get(i).getMetric();
            bestIndex = i;
        }
        if (bestIndex == -1) {
            return null;
        }
        return destRoutes.get(bestIndex);
    }

    Routes getBestRouteByHop(Block dest) {
        int bestHopCount = 255;
        int bestIndex = -1;
        List<Routes> destRoutes = this.getDestRoutes(dest);
        for (int i = 0; i < destRoutes.size(); ++i) {
            if (destRoutes.get(i).getHopCount() >= bestHopCount) continue;
            bestHopCount = destRoutes.get(i).getHopCount();
            bestIndex = i;
        }
        if (bestIndex == -1) {
            return null;
        }
        return destRoutes.get(bestIndex);
    }

    Routes getBestRouteByLength(Block dest) {
        int bestIndex = -1;
        List<Routes> destRoutes = this.getDestRoutes(dest);
        float bestLength = destRoutes.get(0).getLength();
        for (int i = 0; i < destRoutes.size(); ++i) {
            if (!(destRoutes.get(i).getLength() < bestLength)) continue;
            bestLength = destRoutes.get(i).getLength();
            bestIndex = i;
        }
        if (bestIndex == -1) {
            return null;
        }
        return destRoutes.get(bestIndex);
    }

    void addRouteToNeighbours(Routes ro) {
        addRouteLog.debug("From {} Add route to neighbour", (Object)this.getDisplayName());
        Block nextHop = ro.getNextBlock();
        ArrayList<LayoutBlock> validFromPath = new ArrayList<LayoutBlock>();
        addRouteLog.debug("From {} new block {}", (Object)this.getDisplayName(), (Object)nextHop.getDisplayName());
        for (int i = 0; i < this.throughPaths.size(); ++i) {
            LayoutBlock validBlock = null;
            addRouteLog.debug("Through routes index {}", (Object)i);
            addRouteLog.debug("From {} A through routes {} {}", new Object[]{this.getDisplayName(), this.throughPaths.get(i).getSourceBlock().getDisplayName(), this.throughPaths.get(i).getDestinationBlock().getDisplayName()});
            if (this.throughPaths.get(i).getDestinationBlock() == nextHop && this.getAdjacency(this.throughPaths.get(i).getSourceBlock()).isMutual()) {
                validBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.throughPaths.get(i).getSourceBlock());
            }
            if (validBlock == null || validFromPath.contains(validBlock)) continue;
            validFromPath.add(validBlock);
        }
        if (addRouteLog.isDebugEnabled()) {
            addRouteLog.debug("From {} ===== valid from size path {} ==== (addroutetoneigh)", (Object)this.getDisplayName(), (Object)validFromPath.size());
            validFromPath.forEach(valid -> addRouteLog.debug("fromPath: {}", (Object)valid.getDisplayName()));
            addRouteLog.debug("Next Hop {}", (Object)nextHop.getDisplayName());
        }
        RoutingPacket update = new RoutingPacket(0, ro.getDestBlock(), ro.getHopCount() + 1, ro.getMetric() + this.metric, ro.getLength() + this.getBlock().getLengthMm(), -1, this.getNextPacketID());
        for (LayoutBlock layoutBlock : validFromPath) {
            Adjacencies adj = this.getAdjacency(layoutBlock.getBlock());
            if (!adj.advertiseRouteToNeighbour(ro)) continue;
            addRouteLog.debug("From {} Sending update to {} As this has a better hop count or metric", (Object)this.getDisplayName(), (Object)layoutBlock.getDisplayName());
            adj.addRouteAdvertisedToNeighbour(ro);
            layoutBlock.addRouteFromNeighbour(this, update);
        }
    }

    void addRouteFromNeighbour(LayoutBlock src, RoutingPacket update) {
        addRouteLog.debug("From {} src: {}, block: {}, hopCount: {}, metric: {}, status: {}, packetID: {}", new Object[]{this.getDisplayName(), src.getDisplayName(), update.getBlock().getDisplayName(), update.getHopCount(), update.getMetric(), update.getBlockState(), update.getPacketId()});
        InstanceManager.getDefault(LayoutBlockManager.class).setLastRoutingChange();
        Block destBlock = update.getBlock();
        Block srcblk = src.getBlock();
        if (destBlock == this.getBlock()) {
            addRouteLog.debug("Reject packet update as it is to a route advertised by our selves");
            return;
        }
        Adjacencies adj = this.getAdjacency(srcblk);
        if (adj == null) {
            addRouteLog.debug("From {} packet is from a src that is not registered {}", (Object)this.getDisplayName(), (Object)srcblk.getDisplayName());
            return;
        }
        if (adj.getPacketFlow() == 4) {
            addRouteLog.debug("From {} packet is from a src {} that is registered as one that we should be transmitting to only", (Object)this.getDisplayName(), (Object)src.getDisplayName());
            return;
        }
        int hopCount = update.getHopCount();
        int updatemetric = update.getMetric();
        float length = update.getLength();
        if (hopCount > 255) {
            addRouteLog.debug("From {} hop count exceeded {}", (Object)this.getDisplayName(), (Object)destBlock.getDisplayName());
            return;
        }
        for (Routes ro : this.routes) {
            if (ro.getNextBlock() != srcblk || ro.getDestBlock() != destBlock) continue;
            addRouteLog.debug("From {} Route to {} is already configured", (Object)this.getDisplayName(), (Object)destBlock.getDisplayName());
            addRouteLog.debug("{} v {}", (Object)ro.getHopCount(), (Object)hopCount);
            addRouteLog.debug("{} v {}", (Object)ro.getMetric(), (Object)updatemetric);
            this.updateRoutingInfo(src, update);
            return;
        }
        addRouteLog.debug("From {} We should be adding route {}", (Object)this.getDisplayName(), (Object)destBlock.getDisplayName());
        int direction = adj.getDirection();
        Routes route = new Routes(destBlock, srcblk, hopCount, direction, updatemetric, length);
        this.routes.add(route);
        this.addRouteToNeighbours(route);
    }

    public int getNeighbourDirection(LayoutBlock neigh) {
        if (neigh == null) {
            return 0;
        }
        Block neighbourBlock = neigh.getBlock();
        return this.getNeighbourDirection(neighbourBlock);
    }

    public int getNeighbourDirection(Block neighbourBlock) {
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() != neighbourBlock) continue;
            return neighbour.getDirection();
        }
        return 0;
    }

    Adjacencies getAdjacency(Block blk) {
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() != blk) continue;
            return neighbour;
        }
        return null;
    }

    public int getNumberOfNeighbours() {
        return this.neighbours.size();
    }

    public Block getNeighbourAtIndex(int i) {
        return this.neighbours.get(i).getBlock();
    }

    public int getNeighbourDirection(int i) {
        return this.neighbours.get(i).getDirection();
    }

    public int getNeighbourMetric(int i) {
        return this.neighbours.get(i).getMetric();
    }

    public String getNeighbourPacketFlowAsString(int i) {
        return this.decodePacketFlow(this.neighbours.get(i).getPacketFlow());
    }

    public boolean isNeighbourMutual(int i) {
        return this.neighbours.get(i).isMutual();
    }

    int getNeighbourIndex(Adjacencies adj) {
        for (int i = 0; i < this.neighbours.size(); ++i) {
            if (this.neighbours.get(i) != adj) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfRoutes() {
        return this.routes.size();
    }

    public int getRouteDirectionAtIndex(int i) {
        return this.routes.get(i).getDirection();
    }

    public Block getRouteDestBlockAtIndex(int i) {
        return this.routes.get(i).getDestBlock();
    }

    public Block getRouteNextBlockAtIndex(int i) {
        return this.routes.get(i).getNextBlock();
    }

    public int getRouteHopCountAtIndex(int i) {
        return this.routes.get(i).getHopCount();
    }

    public float getRouteLengthAtIndex(int i) {
        return this.routes.get(i).getLength();
    }

    public int getRouteMetric(int i) {
        return this.routes.get(i).getMetric();
    }

    public int getRouteState(int i) {
        return this.routes.get(i).getState();
    }

    public boolean getRouteValid(int i) {
        return this.routes.get(i).isRouteCurrentlyValid();
    }

    public String getRouteStateAsString(int i) {
        int state = this.routes.get(i).getState();
        switch (state) {
            case 2: {
                return Bundle.getMessage("TrackOccupied");
            }
            case 8: {
                return Bundle.getMessage("StateReserved");
            }
            case 4: {
                return Bundle.getMessage("StateFree");
            }
        }
        return Bundle.getMessage("BeanStateUnknown");
    }

    int getRouteIndex(Routes r) {
        for (int i = 0; i < this.routes.size(); ++i) {
            if (this.routes.get(i) != r) continue;
            return i;
        }
        return -1;
    }

    public int getBlockHopCount(Block destination, Block nextBlock) {
        if (destination == nextBlock && this.isValidNeighbour(nextBlock)) {
            return 1;
        }
        for (Routes route : this.routes) {
            if (route.getDestBlock() != destination || route.getNextBlock() != nextBlock) continue;
            return route.getHopCount();
        }
        return -1;
    }

    public int getBlockMetric(Block destination, Block nextBlock) {
        if (destination == nextBlock && this.isValidNeighbour(nextBlock)) {
            return 1;
        }
        for (Routes route : this.routes) {
            if (route.getDestBlock() != destination || route.getNextBlock() != nextBlock) continue;
            return route.getMetric();
        }
        return -1;
    }

    public float getBlockLength(Block destination, Block nextBlock) {
        if (destination == nextBlock && this.isValidNeighbour(nextBlock)) {
            return 1.0f;
        }
        for (Routes route : this.routes) {
            if (route.getDestBlock() != destination || route.getNextBlock() != nextBlock) continue;
            return route.getLength();
        }
        return -1.0f;
    }

    public int getNumberOfThroughPaths() {
        return this.throughPaths.size();
    }

    public Block getThroughPathSource(int i) {
        return this.throughPaths.get(i).getSourceBlock();
    }

    public Block getThroughPathDestination(int i) {
        return this.throughPaths.get(i).getDestinationBlock();
    }

    public Boolean isThroughPathActive(int i) {
        return this.throughPaths.get(i).isPathActive();
    }

    @Nonnull
    List<Block> getThroughPathSourceByDestination(Block dest) {
        ArrayList<Block> a = new ArrayList<Block>();
        for (ThroughPaths throughPath : this.throughPaths) {
            if (throughPath.getDestinationBlock() != dest) continue;
            a.add(throughPath.getSourceBlock());
        }
        return a;
    }

    @Nonnull
    List<Block> getThroughPathDestinationBySource(Block source) {
        ArrayList<Block> a = new ArrayList<Block>();
        for (ThroughPaths throughPath : this.throughPaths) {
            if (throughPath.getSourceBlock() != source) continue;
            a.add(throughPath.getDestinationBlock());
        }
        return a;
    }

    boolean checkIsRouteOnValidThroughPath(Routes r) {
        for (ThroughPaths t : this.throughPaths) {
            if (!t.isPathActive()) continue;
            if (t.getDestinationBlock() == r.getNextBlock()) {
                return true;
            }
            if (t.getSourceBlock() != r.getNextBlock()) continue;
            return true;
        }
        return false;
    }

    public void refreshValidRoutes() {
        for (int i = 0; i < this.throughPaths.size(); ++i) {
            ThroughPaths t = this.throughPaths.get(i);
            this.setRoutesValid(t.getDestinationBlock(), t.isPathActive());
            this.setRoutesValid(t.getSourceBlock(), t.isPathActive());
            this.firePropertyChange(PROPERTY_PATH, null, i);
        }
    }

    void setRoutesValid(Block nxtHopActive, boolean state) {
        List<Routes> rtr = this.getRouteByNeighbour(nxtHopActive);
        rtr.forEach(rt -> rt.setValidCurrentRoute(state));
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Sensor && evt.getOldValue().equals(this.getOccupancySensor())) {
                throw new PropertyVetoException(this.getDisplayName(), evt);
            }
            if (evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this.getMemory())) {
                throw new PropertyVetoException(this.getDisplayName(), evt);
            }
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Sensor && evt.getOldValue().equals(this.getOccupancySensor())) {
                this.setOccupancySensorName(null);
            }
            if (evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this.getMemory())) {
                this.setMemoryName(null);
            }
        }
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            if (bean.equals(this.getBlock())) {
                report.add(new NamedBeanUsageReport("LayoutBlockBlock"));
            }
            if (bean.equals(this.getMemory())) {
                report.add(new NamedBeanUsageReport("LayoutBlockMemory"));
            }
            if (bean.equals(this.getOccupancySensor())) {
                report.add(new NamedBeanUsageReport("LayoutBlockSensor"));
            }
            for (int i = 0; i < this.getNumberOfNeighbours(); ++i) {
                if (!bean.equals(this.getNeighbourAtIndex(i))) continue;
                report.add(new NamedBeanUsageReport("LayoutBlockNeighbor", "Neighbor"));
            }
        }
        return report;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameLayoutBlock");
    }

    private class ThroughPaths
    implements PropertyChangeListener {
        Block sourceBlock;
        Block destinationBlock;
        Path sourcePath;
        Path destinationPath;
        boolean pathActive = false;
        HashMap<Turnout, Integer> _turnouts = new HashMap();
        private List<ThroughPaths> activePaths;

        ThroughPaths(Block srcBlock, Path srcPath, Block destBlock, Path dstPath) {
            this.sourceBlock = srcBlock;
            this.destinationBlock = destBlock;
            this.sourcePath = srcPath;
            this.destinationPath = dstPath;
        }

        Block getSourceBlock() {
            return this.sourceBlock;
        }

        Block getDestinationBlock() {
            return this.destinationBlock;
        }

        Path getSourcePath() {
            return this.sourcePath;
        }

        Path getDestinationPath() {
            return this.destinationPath;
        }

        boolean isPathActive() {
            return this.pathActive;
        }

        void setTurnoutList(List<LayoutTrackExpectedState<LayoutTurnout>> turnouts) {
            if (!this._turnouts.isEmpty()) {
                Set<Turnout> en = this._turnouts.keySet();
                en.forEach(listTurnout -> listTurnout.removePropertyChangeListener(this));
            }
            if (turnouts.isEmpty()) {
                this.pathActive = true;
                LayoutBlock.this.setRoutesValid(this.sourceBlock, true);
                LayoutBlock.this.setRoutesValid(this.destinationBlock, true);
                return;
            }
            this._turnouts = new HashMap(turnouts.size());
            for (LayoutTrackExpectedState<LayoutTurnout> turnout : turnouts) {
                if (turnout.getObject() instanceof LayoutSlip) {
                    int slipState = turnout.getExpectedState();
                    LayoutSlip ls = (LayoutSlip)turnout.getObject();
                    int taState = ls.getTurnoutState(slipState);
                    this._turnouts.put(ls.getTurnout(), taState);
                    ls.getTurnout().addPropertyChangeListener(this, ls.getTurnoutName(), "Layout Block Routing");
                    int tbState = ls.getTurnoutBState(slipState);
                    this._turnouts.put(ls.getTurnoutB(), tbState);
                    ls.getTurnoutB().addPropertyChangeListener(this, ls.getTurnoutBName(), "Layout Block Routing");
                    continue;
                }
                LayoutTurnout lt = (LayoutTurnout)turnout.getObject();
                if (lt.getTurnout() != null) {
                    this._turnouts.put(lt.getTurnout(), turnout.getExpectedState());
                    lt.getTurnout().addPropertyChangeListener(this, lt.getTurnoutName(), "Layout Block Routing");
                    continue;
                }
                log.error("{} has no physical turnout allocated, block = {}", (Object)lt, (Object)LayoutBlock.this.block.getDisplayName());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("KnownState".equals(e.getPropertyName())) {
                Turnout srcTurnout = (Turnout)e.getSource();
                int newVal = (Integer)e.getNewValue();
                int values = this._turnouts.get(srcTurnout);
                boolean allset = false;
                this.pathActive = false;
                if (newVal == values) {
                    allset = true;
                    if (this._turnouts.size() > 1) {
                        for (Map.Entry<Turnout, Integer> entry : this._turnouts.entrySet()) {
                            int state;
                            if (srcTurnout == entry.getKey() || (state = entry.getKey().getState()) == entry.getValue()) continue;
                            allset = false;
                            break;
                        }
                    }
                }
                this.updateActiveThroughPaths(this, allset);
                this.pathActive = allset;
            }
        }

        private void updateActiveThroughPaths(ThroughPaths tp, boolean active) {
            updateRouteLog.debug("We have been notified that a through path has changed state");
            if (this.activePaths == null) {
                this.activePaths = new ArrayList<ThroughPaths>();
            }
            if (active) {
                this.activePaths.add(tp);
                LayoutBlock.this.setRoutesValid(tp.getSourceBlock(), active);
                LayoutBlock.this.setRoutesValid(tp.getDestinationBlock(), active);
            } else {
                this.activePaths.remove(tp);
                boolean sourceInUse = false;
                boolean destinationInUse = false;
                List<ThroughPaths> copyOfPaths = this.activePaths;
                for (ThroughPaths activePath : copyOfPaths) {
                    Block testSour = activePath.getSourceBlock();
                    Block testDest = activePath.getDestinationBlock();
                    if (testSour == tp.getSourceBlock() || testDest == tp.getSourceBlock()) {
                        sourceInUse = true;
                    }
                    if (testSour != tp.getDestinationBlock() && testDest != tp.getDestinationBlock()) continue;
                    destinationInUse = true;
                }
                if (!sourceInUse) {
                    LayoutBlock.this.setRoutesValid(tp.getSourceBlock(), active);
                }
                if (!destinationInUse) {
                    LayoutBlock.this.setRoutesValid(tp.getDestinationBlock(), active);
                }
            }
            for (int i = 0; i < LayoutBlock.this.throughPaths.size(); ++i) {
                if (tp != LayoutBlock.this.throughPaths.get(i)) continue;
                LayoutBlock.this.firePropertyChange(LayoutBlock.PROPERTY_PATH, null, i);
            }
        }
    }

    private class Routes
    implements PropertyChangeListener {
        int direction;
        Block destBlock;
        Block nextBlock;
        int hopCount;
        int routeMetric;
        float length;
        int miscflags = 0;
        boolean validCurrentRoute = false;

        Routes(Block dstBlock, Block nxtBlock, int hop, int dir, int met, float len) {
            this.destBlock = dstBlock;
            this.nextBlock = nxtBlock;
            this.hopCount = hop;
            this.direction = dir;
            this.routeMetric = met;
            this.length = len;
            this.init();
        }

        final void init() {
            this.validCurrentRoute = LayoutBlock.this.checkIsRouteOnValidThroughPath(this);
            LayoutBlock.this.firePropertyChange(LayoutBlock.PROPERTY_LENGTH, null, null);
            this.destBlock.addPropertyChangeListener(this);
        }

        public String toString() {
            return "Routes(dst:" + this.destBlock + ", nxt:" + this.nextBlock + ", hop:" + this.hopCount + ", dir:" + this.direction + ", met:" + this.routeMetric + ", len: " + this.length + ")";
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("state".equals(e.getPropertyName())) {
                this.stateChange();
            }
        }

        public Block getDestBlock() {
            return this.destBlock;
        }

        public Block getNextBlock() {
            return this.nextBlock;
        }

        public int getHopCount() {
            return this.hopCount;
        }

        public int getDirection() {
            return this.direction;
        }

        public int getMetric() {
            return this.routeMetric;
        }

        public float getLength() {
            return this.length;
        }

        public void setMetric(int met) {
            if (met == this.routeMetric) {
                return;
            }
            this.routeMetric = met;
            LayoutBlock.this.firePropertyChange(LayoutBlock.PROPERTY_METRIC, null, LayoutBlock.this.getRouteIndex(this));
        }

        public void setHopCount(int hop) {
            if (this.hopCount == hop) {
                return;
            }
            this.hopCount = hop;
            LayoutBlock.this.firePropertyChange(LayoutBlock.PROPERTY_HOP, null, LayoutBlock.this.getRouteIndex(this));
        }

        public void setLength(float len) {
            if (len == this.length) {
                return;
            }
            this.length = len;
            LayoutBlock.this.firePropertyChange(LayoutBlock.PROPERTY_LENGTH, null, LayoutBlock.this.getRouteIndex(this));
        }

        void stateChange() {
            LayoutBlock.this.firePropertyChange("state", null, LayoutBlock.this.getRouteIndex(this));
        }

        int getState() {
            LayoutBlock destLBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.destBlock);
            if (destLBlock != null) {
                return destLBlock.getBlockStatus();
            }
            log.debug("Layout Block {} returned as null", (Object)this.destBlock.getDisplayName());
            return -1;
        }

        void setValidCurrentRoute(boolean boo) {
            if (this.validCurrentRoute == boo) {
                return;
            }
            this.validCurrentRoute = boo;
            LayoutBlock.this.firePropertyChange(LayoutBlock.PROPERTY_VALID, null, LayoutBlock.this.getRouteIndex(this));
        }

        boolean isRouteCurrentlyValid() {
            return this.validCurrentRoute;
        }

        void setMiscFlags(int f) {
            this.miscflags = f;
        }

        int getMiscFlags() {
            return this.miscflags;
        }
    }

    private class Adjacencies {
        Block adjBlock;
        LayoutBlock adjLayoutBlock;
        int direction;
        int packetFlow = 0;
        boolean mutualAdjacency = false;
        HashMap<Block, Routes> adjDestRoutes = new HashMap();
        List<Integer> actedUponUpdates = new ArrayList<Integer>(501);

        Adjacencies(Block block, int dir, int packetFlow) {
            this.adjBlock = block;
            this.direction = dir;
            this.packetFlow = packetFlow;
        }

        Block getBlock() {
            return this.adjBlock;
        }

        LayoutBlock getLayoutBlock() {
            return this.adjLayoutBlock;
        }

        int getDirection() {
            return this.direction;
        }

        void setMutual(boolean mut) {
            if (mut == this.mutualAdjacency) {
                return;
            }
            this.mutualAdjacency = mut;
            if (this.mutualAdjacency) {
                this.adjLayoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.adjBlock);
            }
        }

        boolean isMutual() {
            return this.mutualAdjacency;
        }

        int getPacketFlow() {
            return this.packetFlow;
        }

        void setPacketFlow(int flow) {
            if (flow != this.packetFlow) {
                int oldFlow = this.packetFlow;
                this.packetFlow = flow;
                LayoutBlock.this.firePropertyChange(LayoutBlock.PROPERTY_NEIGHBOUR_PACKET_FLOW, oldFlow, this.packetFlow);
            }
        }

        void setMetric(int met) {
            LayoutBlock.this.firePropertyChange(LayoutBlock.PROPERTY_NEIGHBOUR_METRIC, null, LayoutBlock.this.getNeighbourIndex(this));
        }

        int getMetric() {
            if (this.adjLayoutBlock != null) {
                return this.adjLayoutBlock.getBlockMetric();
            }
            this.adjLayoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.adjBlock);
            if (this.adjLayoutBlock != null) {
                return this.adjLayoutBlock.getBlockMetric();
            }
            if (log.isDebugEnabled()) {
                log.debug("Layout Block {} returned as null", (Object)this.adjBlock.getDisplayName());
            }
            return -1;
        }

        void setLength(float len) {
            LayoutBlock.this.firePropertyChange(LayoutBlock.PROPERTY_NEIGHBOUR_LENGTH, null, LayoutBlock.this.getNeighbourIndex(this));
        }

        float getLength() {
            if (this.adjLayoutBlock != null) {
                return this.adjLayoutBlock.getBlock().getLengthMm();
            }
            this.adjLayoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.adjBlock);
            if (this.adjLayoutBlock != null) {
                return this.adjLayoutBlock.getBlock().getLengthMm();
            }
            if (log.isDebugEnabled()) {
                log.debug("Layout Block {} returned as null", (Object)this.adjBlock.getDisplayName());
            }
            return -1.0f;
        }

        void removeRouteAdvertisedToNeighbour(Routes removeRoute) {
            Block dest = removeRoute.getDestBlock();
            if (this.adjDestRoutes.get(dest) == removeRoute) {
                this.adjDestRoutes.remove(dest);
            }
        }

        void removeRouteAdvertisedToNeighbour(Block block) {
            this.adjDestRoutes.remove(block);
        }

        void addRouteAdvertisedToNeighbour(Routes addedRoute) {
            this.adjDestRoutes.put(addedRoute.getDestBlock(), addedRoute);
        }

        boolean advertiseRouteToNeighbour(Routes routeToAdd) {
            if (!this.isMutual()) {
                log.debug("In block {}: Neighbour is not mutual so will not advertise it (Routes {})", (Object)LayoutBlock.this.getDisplayName(), (Object)routeToAdd);
                return false;
            }
            Block dest = routeToAdd.getDestBlock();
            if (!this.adjDestRoutes.containsKey(dest)) {
                log.debug("In block {}: We are not currently advertising a route to the destination to neighbour: {}", (Object)LayoutBlock.this.getDisplayName(), (Object)dest.getDisplayName());
                return true;
            }
            if (routeToAdd.getHopCount() > 255) {
                log.debug("Hop count is gereater than 255 we will therefore do nothing with this route");
                return false;
            }
            Routes existingRoute = this.adjDestRoutes.get(dest);
            if (existingRoute.getMetric() > routeToAdd.getMetric()) {
                return true;
            }
            if (existingRoute.getHopCount() > routeToAdd.getHopCount()) {
                return true;
            }
            if (existingRoute == routeToAdd) {
                return false;
            }
            return false;
        }

        boolean updatePacketActedUpon(Integer packetID) {
            return this.actedUponUpdates.contains(packetID);
        }

        void addPacketReceivedFromNeighbour(Integer packetID) {
            this.actedUponUpdates.add(packetID);
            if (this.actedUponUpdates.size() > 500) {
                this.actedUponUpdates.subList(0, 250).clear();
            }
        }

        void dispose() {
            this.adjBlock = null;
            this.adjLayoutBlock = null;
            this.mutualAdjacency = false;
            this.adjDestRoutes = null;
            this.actedUponUpdates = null;
        }
    }

    private static class RoutingPacket {
        int packetType;
        Block block;
        int hopCount = -1;
        int packetMetric = -1;
        int blockstate = -1;
        float length = -1.0f;
        Integer packetRef = -1;

        RoutingPacket(int packetType, Block blk, int hopCount, int packetMetric, float length, int blockstate, Integer packetRef) {
            this.packetType = packetType;
            this.block = blk;
            this.hopCount = hopCount;
            this.packetMetric = packetMetric;
            this.blockstate = blockstate;
            this.packetRef = packetRef;
            this.length = length;
        }

        int getPacketType() {
            return this.packetType;
        }

        Block getBlock() {
            return this.block;
        }

        int getHopCount() {
            return this.hopCount;
        }

        int getMetric() {
            return this.packetMetric;
        }

        int getBlockState() {
            return this.blockstate;
        }

        float getLength() {
            return this.length;
        }

        Integer getPacketId() {
            return this.packetRef;
        }
    }

    protected class LayoutBlockEditAction
    extends BlockEditAction {
        protected LayoutBlockEditAction() {
        }

        @Override
        public String helpTarget() {
            return "package.jmri.jmrit.display.EditLayoutBlock";
        }

        @Override
        protected void initPanels() {
            super.initPanels();
            BeanItemPanel ld = this.layoutDetails();
            if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
                this.blockRoutingDetails();
            }
            this.setSelectedComponent(ld);
        }

        BeanItemPanel layoutDetails() {
            BeanItemPanel layout = new BeanItemPanel();
            layout.setName(Bundle.getMessage("LayoutEditor"));
            LayoutEditor.setupComboBox(LayoutBlock.this.memoryComboBox, false, true, false);
            layout.addItem(new BeanEditItem(new JLabel("" + LayoutBlock.this.useCount), Bundle.getMessage("UseCount"), null));
            layout.addItem(new BeanEditItem(LayoutBlock.this.memoryComboBox, Bundle.getMessage("BeanNameMemory"), Bundle.getMessage("MemoryVariableTip")));
            LayoutBlock.this.senseBox.removeAllItems();
            LayoutBlock.this.senseBox.addItem(Bundle.getMessage("SensorStateActive"));
            LayoutBlock.this.senseActiveIndex = 0;
            LayoutBlock.this.senseBox.addItem(Bundle.getMessage("SensorStateInactive"));
            LayoutBlock.this.senseInactiveIndex = 1;
            layout.addItem(new BeanEditItem(LayoutBlock.this.senseBox, Bundle.getMessage("OccupiedSense"), Bundle.getMessage("OccupiedSenseHint")));
            LayoutBlock.this.trackColorChooser = new JColorChooser(LayoutBlock.this.blockTrackColor);
            LayoutBlock.this.trackColorChooser.setPreviewPanel(new JPanel());
            AbstractColorChooserPanel[] trackColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
            LayoutBlock.this.trackColorChooser.setChooserPanels(trackColorPanels);
            layout.addItem(new BeanEditItem(LayoutBlock.this.trackColorChooser, Bundle.getMessage("TrackColor"), Bundle.getMessage("TrackColorHint")));
            LayoutBlock.this.occupiedColorChooser = new JColorChooser(LayoutBlock.this.blockOccupiedColor);
            LayoutBlock.this.occupiedColorChooser.setPreviewPanel(new JPanel());
            AbstractColorChooserPanel[] occupiedColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
            LayoutBlock.this.occupiedColorChooser.setChooserPanels(occupiedColorPanels);
            layout.addItem(new BeanEditItem(LayoutBlock.this.occupiedColorChooser, Bundle.getMessage("OccupiedColor"), Bundle.getMessage("OccupiedColorHint")));
            LayoutBlock.this.extraColorChooser = new JColorChooser(LayoutBlock.this.blockExtraColor);
            LayoutBlock.this.extraColorChooser.setPreviewPanel(new JPanel());
            AbstractColorChooserPanel[] extraColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
            LayoutBlock.this.extraColorChooser.setChooserPanels(extraColorPanels);
            layout.addItem(new BeanEditItem(LayoutBlock.this.extraColorChooser, Bundle.getMessage("ExtraColor"), Bundle.getMessage("ExtraColorHint")));
            layout.setSaveItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName;
                    boolean needsRedraw = false;
                    int k = LayoutBlock.this.senseBox.getSelectedIndex();
                    int oldSense = LayoutBlock.this.occupiedSense;
                    LayoutBlock.this.occupiedSense = k == LayoutBlock.this.senseActiveIndex ? 2 : 4;
                    if (oldSense != LayoutBlock.this.occupiedSense) {
                        needsRedraw = true;
                    }
                    Color oldColor = LayoutBlock.this.blockTrackColor;
                    LayoutBlock.this.blockTrackColor = LayoutBlock.this.trackColorChooser.getColor();
                    if (oldColor != LayoutBlock.this.blockTrackColor) {
                        needsRedraw = true;
                        JmriColorChooser.addRecentColor(LayoutBlock.this.blockTrackColor);
                    }
                    oldColor = LayoutBlock.this.blockOccupiedColor;
                    LayoutBlock.this.blockOccupiedColor = LayoutBlock.this.occupiedColorChooser.getColor();
                    if (oldColor != LayoutBlock.this.blockOccupiedColor) {
                        needsRedraw = true;
                        JmriColorChooser.addRecentColor(LayoutBlock.this.blockOccupiedColor);
                    }
                    oldColor = LayoutBlock.this.blockExtraColor;
                    LayoutBlock.this.blockExtraColor = LayoutBlock.this.extraColorChooser.getColor();
                    if (oldColor != LayoutBlock.this.blockExtraColor) {
                        needsRedraw = true;
                        JmriColorChooser.addRecentColor(LayoutBlock.this.blockExtraColor);
                    }
                    if ((newName = LayoutBlock.this.memoryComboBox.getSelectedItemDisplayName()) == null) {
                        newName = "";
                    }
                    if (!LayoutBlock.this.memoryName.equals(newName)) {
                        LayoutBlock.this.setMemory(LayoutBlock.this.validateMemory(newName, null), newName);
                        if (LayoutBlock.this.getMemory() == null) {
                            LayoutBlock.this.memoryName = "";
                            LayoutBlock.this.memoryComboBox.setSelectedItem(null);
                            return;
                        }
                        LayoutBlock.this.memoryComboBox.setSelectedItem(LayoutBlock.this.getMemory());
                        needsRedraw = true;
                    }
                    if (needsRedraw) {
                        LayoutBlock.this.redrawLayoutBlockPanels();
                    }
                }
            });
            layout.setResetItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutBlock.this.memoryComboBox.setSelectedItem(LayoutBlock.this.getMemory());
                    LayoutBlock.this.trackColorChooser.setColor(LayoutBlock.this.blockTrackColor);
                    LayoutBlock.this.occupiedColorChooser.setColor(LayoutBlock.this.blockOccupiedColor);
                    LayoutBlock.this.extraColorChooser.setColor(LayoutBlock.this.blockExtraColor);
                    if (LayoutBlock.this.occupiedSense == 2) {
                        LayoutBlock.this.senseBox.setSelectedIndex(LayoutBlock.this.senseActiveIndex);
                    } else {
                        LayoutBlock.this.senseBox.setSelectedIndex(LayoutBlock.this.senseInactiveIndex);
                    }
                }
            });
            this.bei.add(layout);
            return layout;
        }

        BeanItemPanel blockRoutingDetails() {
            BeanItemPanel routing = new BeanItemPanel();
            routing.setName("Routing");
            routing.addItem(new BeanEditItem(LayoutBlock.this.metricField, "Block Metric", "set the cost for going over this block"));
            routing.addItem(new BeanEditItem(null, null, "Set the direction of the connection to the neighbouring block"));
            LayoutBlock.this.neighbourDir = new ArrayList<JComboBox<String>>(LayoutBlock.this.getNumberOfNeighbours());
            for (int i = 0; i < LayoutBlock.this.getNumberOfNeighbours(); ++i) {
                JComboBox<String> dir = new JComboBox<String>(LayoutBlock.this.working);
                routing.addItem(new BeanEditItem(dir, LayoutBlock.this.getNeighbourAtIndex(i).getDisplayName(), null));
                LayoutBlock.this.neighbourDir.add(dir);
            }
            routing.setResetItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutBlock.this.metricField.setText(Integer.toString(LayoutBlock.this.metric));
                    for (int i = 0; i < LayoutBlock.this.getNumberOfNeighbours(); ++i) {
                        JComboBox<String> dir = LayoutBlock.this.neighbourDir.get(i);
                        Block blk = LayoutBlock.this.neighbours.get(i).getBlock();
                        if (LayoutBlock.this.block.isBlockDenied(blk)) {
                            dir.setSelectedIndex(2);
                            continue;
                        }
                        if (blk.isBlockDenied(LayoutBlock.this.block)) {
                            dir.setSelectedIndex(1);
                            continue;
                        }
                        dir.setSelectedIndex(0);
                    }
                }
            });
            routing.setSaveItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int m = Integer.parseInt(LayoutBlock.this.metricField.getText().trim());
                    if (m != LayoutBlock.this.metric) {
                        LayoutBlock.this.setBlockMetric(m);
                    }
                    if (LayoutBlock.this.neighbourDir != null) {
                        block5: for (int i = 0; i < LayoutBlock.this.neighbourDir.size(); ++i) {
                            int neigh = LayoutBlock.this.neighbourDir.get(i).getSelectedIndex();
                            LayoutBlock.this.neighbours.get(i).getBlock().removeBlockDenyList(LayoutBlock.this.block);
                            LayoutBlock.this.block.removeBlockDenyList(LayoutBlock.this.neighbours.get(i).getBlock());
                            switch (neigh) {
                                case 0: {
                                    LayoutBlock.this.updateNeighbourPacketFlow(LayoutBlock.this.neighbours.get(i), 0);
                                    continue block5;
                                }
                                case 1: {
                                    LayoutBlock.this.neighbours.get(i).getBlock().addBlockDenyList(LayoutBlock.this.block.getDisplayName());
                                    LayoutBlock.this.updateNeighbourPacketFlow(LayoutBlock.this.neighbours.get(i), 4);
                                    continue block5;
                                }
                                case 2: {
                                    LayoutBlock.this.block.addBlockDenyList(LayoutBlock.this.neighbours.get(i).getBlock().getDisplayName());
                                    LayoutBlock.this.updateNeighbourPacketFlow(LayoutBlock.this.neighbours.get(i), 2);
                                    continue block5;
                                }
                            }
                        }
                    }
                }
            });
            this.bei.add(routing);
            return routing;
        }
    }
}

