/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.JmriException;
import jmri.Memory;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Signal;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.BlockValueFile;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorTools;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutBlockManager
extends AbstractManager<LayoutBlock>
implements InstanceManagerAutoDefault {
    public static final String PROPERTY_ADVANCED_ROUTING_ENABLED = "advancedRoutingEnabled";
    public static final String PROPERTY_TOPOLOGY = "topology";
    private int blkNum = 1;
    private boolean initialized = false;
    private int badBeanErrors = 0;
    private boolean warnConnectivity = true;
    protected boolean enableAdvancedRouting = false;
    private long firstRoutingChange;
    private final LayoutBlockConnectivityTools lbct = new LayoutBlockConnectivityTools();
    private long lastRoutingChange;
    private boolean checking = false;
    boolean stabilised = false;
    private Thread thr = null;
    private NamedBeanHandle<Sensor> namedStabilisedIndicator;
    private static final Logger log = LoggerFactory.getLogger(LayoutBlockManager.class);

    public LayoutBlockManager() {
        super(InstanceManager.getDefault(InternalSystemConnectionMemo.class));
        InstanceManager.sensorManagerInstance().addVetoableChangeListener(this);
        InstanceManager.memoryManagerInstance().addVetoableChangeListener(this);
    }

    @Override
    public int getXMLOrder() {
        return 120;
    }

    @Override
    public char typeLetter() {
        return 'B';
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock createNewLayoutBlock(@CheckForNull String systemName, String userName) {
        if (userName == null || userName.isEmpty()) {
            log.error("Attempt to create a LayoutBlock with no user name");
            return null;
        }
        LayoutBlock result = (LayoutBlock)this.getByUserName(userName);
        if (result != null) {
            return null;
        }
        Object sName = "";
        if (systemName == null) {
            boolean found = true;
            while (found) {
                sName = "ILB" + this.blkNum;
                ++this.blkNum;
                result = (LayoutBlock)this.getBySystemName((String)sName);
                if (result != null) continue;
                found = false;
            }
        } else {
            result = (LayoutBlock)this.getBySystemName(systemName);
            if (result != null) {
                return null;
            }
            sName = systemName;
        }
        result = new LayoutBlock((String)sName, userName);
        this.register(result);
        return result;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock createNewLayoutBlock() {
        while (true) {
            String sName;
            LayoutBlock block;
            if ((block = (LayoutBlock)this.getBySystemName(sName = "ILB" + this.blkNum)) == null) {
                String uName = "AUTOBLK:" + this.blkNum;
                block = new LayoutBlock(sName, uName);
                this.register(block);
                return block;
            }
            ++this.blkNum;
        }
    }

    public void deleteLayoutBlock(LayoutBlock block) {
        this.deregister(block);
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getLayoutBlock(@Nonnull String name) {
        LayoutBlock block = (LayoutBlock)this.getByUserName(name);
        if (block != null) {
            return block;
        }
        return (LayoutBlock)this.getBySystemName(name);
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getLayoutBlock(@CheckForNull Block block) {
        for (LayoutBlock lb : this.getNamedBeanSet()) {
            if (lb.getBlock() != block) continue;
            return lb;
        }
        return null;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getBlockWithSensorAssigned(@CheckForNull Sensor s) {
        for (LayoutBlock block : this.getNamedBeanSet()) {
            if (block.getOccupancySensor() != s) continue;
            return block;
        }
        return null;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getBlockWithMemoryAssigned(Memory m) {
        for (LayoutBlock block : this.getNamedBeanSet()) {
            if (block.getMemory() != m) continue;
            return block;
        }
        return null;
    }

    public void initializeLayoutBlockPaths() {
        log.debug("start initializeLayoutBlockPaths");
        for (LayoutBlock b : this.getNamedBeanSet()) {
            log.debug("Calling block '{}({})'.initializeLayoutBlock()", (Object)b.getSystemName(), (Object)b.getDisplayName());
            b.initializeLayoutBlock();
        }
        this.badBeanErrors = 0;
        for (LayoutBlock b : this.getNamedBeanSet()) {
            log.debug("Calling block '{}({})'.updatePaths()", (Object)b.getSystemName(), (Object)b.getDisplayName());
            b.updatePaths();
            if (b.getBlock().getValue() == null) continue;
            b.getBlock().setValue(null);
        }
        if (this.badBeanErrors > 0) {
            JmriJOptionPane.showMessageDialog(null, this.badBeanErrors + " " + Bundle.getMessage("Warn2"), Bundle.getMessage("WarningTitle"), 0);
        }
        try {
            new BlockValueFile().readBlockValues();
        }
        catch (JDOMException jde) {
            log.error("JDOM Exception when retreiving block values", (Throwable)jde);
        }
        catch (IOException ioe) {
            log.error("I/O Exception when retreiving block values", (Throwable)ioe);
        }
        this.initialized = true;
        log.debug("start initializeLayoutBlockRouting");
        this.initializeLayoutBlockRouting();
        log.debug("end initializeLayoutBlockRouting and initializeLayoutBlockPaths");
    }

    public void addBadBeanError() {
        ++this.badBeanErrors;
    }

    @CheckReturnValue
    @CheckForNull
    public SignalHead getFacingSignalHead(@CheckForNull Block facingBlock, @CheckForNull Block protectedBlock) {
        LayoutTurnout lt;
        if (facingBlock == null || protectedBlock == null) {
            log.error("null block in call to getFacingSignalHead");
            return null;
        }
        String facingBlockName = facingBlock.getUserName();
        if (facingBlockName == null || facingBlockName.isEmpty()) {
            log.error("facingBlockName has no user name");
            return null;
        }
        String protectedBlockName = protectedBlock.getUserName();
        if (protectedBlockName == null || protectedBlockName.isEmpty()) {
            log.error("protectedBlockName has no user name");
            return null;
        }
        LayoutBlock fLayoutBlock = (LayoutBlock)this.getByUserName(facingBlockName);
        LayoutBlock pLayoutBlock = (LayoutBlock)this.getByUserName(protectedBlockName);
        if (fLayoutBlock == null || pLayoutBlock == null) {
            if (fLayoutBlock == null) {
                log.error("Block {} is not on a Layout Editor panel.", (Object)facingBlock.getDisplayName());
            }
            if (pLayoutBlock == null) {
                log.error("Block {} is not on a Layout Editor panel.", (Object)protectedBlock.getDisplayName());
            }
            return null;
        }
        LayoutEditor panel = fLayoutBlock.getMaxConnectedPanel();
        List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(fLayoutBlock);
        LayoutConnectivity lc = null;
        boolean facingIsBlock1 = true;
        for (int i = 0; i < c.size() && lc == null; ++i) {
            LayoutConnectivity tlc = c.get(i);
            if (tlc.getBlock1() == fLayoutBlock && tlc.getBlock2() == pLayoutBlock) {
                lc = tlc;
                continue;
            }
            if (tlc.getBlock1() != pLayoutBlock || tlc.getBlock2() != fLayoutBlock) continue;
            lc = tlc;
            facingIsBlock1 = false;
        }
        if (lc == null) {
            log.error("Block {} ({}) is not connected to Block {}", new Object[]{facingBlock.getDisplayName(), facingBlock.getDisplayName(), protectedBlock.getDisplayName()});
            return null;
        }
        TrackSegment tr = lc.getTrackSegment();
        if (tr == null) {
            lt = lc.getXover();
            int boundaryType = lc.getXoverBoundaryType();
            switch (boundaryType) {
                case 1: {
                    if (facingIsBlock1) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                }
                case 2: {
                    if (facingIsBlock1) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                }
                case 3: {
                    if (facingIsBlock1) {
                        if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA2) == null) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                        }
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
                    }
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTC2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC2);
                }
                case 4: {
                    if (facingIsBlock1) {
                        if (lt.getSignalHead(LayoutTurnout.Geometry.POINTB2) == null) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                        }
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTB2);
                    }
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTD2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTD2);
                }
            }
            log.error("Unhandled crossover connection type: {}", (Object)boundaryType);
            log.error("crossover turnout block boundary not found in getFacingSignal");
            return null;
        }
        LayoutTrack connected = lc.getConnectedObject();
        HitPointType cType = lc.getConnectedType();
        if (connected == null) {
            log.error("No connectivity object found between Blocks {}, {} {}", new Object[]{facingBlock.getDisplayName(), protectedBlock.getDisplayName(), cType});
            return null;
        }
        if (cType == HitPointType.TRACK) {
            PositionablePoint p = panel.getFinder().findPositionablePointAtTrackSegments(tr, (TrackSegment)connected);
            boolean block1IsWestEnd = LayoutEditorTools.isAtWestEndOfAnchor(panel, tr, p);
            if (block1IsWestEnd && facingIsBlock1 || !block1IsWestEnd && !facingIsBlock1) {
                return p.getEastBoundSignalHead();
            }
            return p.getWestBoundSignalHead();
        }
        if (cType == HitPointType.TURNOUT_A) {
            lt = (LayoutTurnout)connected;
            if (lt.getLinkType() == LayoutTurnout.LinkType.NO_LINK) {
                if (facingIsBlock1) {
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                    }
                    if (((TrackSegment)lt.getConnectB()).getBlockName().equals(protectedBlock.getUserName())) {
                        if (!((TrackSegment)lt.getConnectC()).getBlockName().equals(protectedBlock.getUserName())) {
                            if (lt.getContinuingSense() == 2) {
                                return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                            }
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
                        }
                        int state = lt.getTurnout().getKnownState();
                        if (state == 2 && lt.getContinuingSense() == 2 || state == 4 && lt.getContinuingSense() == 4) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                        }
                        if (state == 4 && lt.getContinuingSense() == 2 || state == 2 && lt.getContinuingSense() == 4) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
                        }
                        log.error("Cannot choose signal head because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)lt.getTurnout().getDisplayName());
                        return null;
                    }
                    if (((TrackSegment)lt.getConnectC()).getBlockName().equals(protectedBlock.getUserName())) {
                        if (lt.getContinuingSense() == 2) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
                        }
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                    }
                    int state = lt.getTurnout().getKnownState();
                    if (state == 2 && lt.getContinuingSense() == 2 || state == 4 && lt.getContinuingSense() == 4) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                    }
                    if (state == 4 && lt.getContinuingSense() == 2 || state == 2 && lt.getContinuingSense() == 4) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
                    }
                    return null;
                }
                if (((TrackSegment)lt.getConnectB()).getBlockName().equals(facingBlock.getUserName())) {
                    if (!((TrackSegment)lt.getConnectC()).getBlockName().equals(facingBlock.getDisplayName())) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                    }
                    int state = lt.getTurnout().getKnownState();
                    if (state == 2 && lt.getContinuingSense() == 2 || state == 4 && lt.getContinuingSense() == 4) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                    }
                    if (state == 4 && lt.getContinuingSense() == 2 || state == 2 && lt.getContinuingSense() == 4) {
                        if (lt.getSignalHead(LayoutTurnout.Geometry.POINTC2) == null) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                        }
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTC2);
                    }
                    log.error("Cannot choose signal head because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)lt.getTurnout().getDisplayName());
                    return null;
                }
                if (((TrackSegment)lt.getConnectC()).getBlockName().equals(facingBlock.getUserName())) {
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTC2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC2);
                }
                if (!lt.getBlockName().equals(facingBlock.getUserName())) {
                    log.error("no signal faces block {}, and turnout is not in block either", (Object)facingBlock.getDisplayName());
                }
                return null;
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.THROAT_TO_THROAT) {
                return null;
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.FIRST_3_WAY) {
                if (!facingIsBlock1) {
                    return null;
                }
                int state = lt.getTurnout().getKnownState();
                if (state == 4) {
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
                }
                if (state == 2) {
                    LayoutTurnout tLinked = panel.getFinder().findLayoutTurnoutByTurnoutName(lt.getLinkedTurnoutName());
                    state = tLinked.getTurnout().getKnownState();
                    if (state == 2) {
                        if (tLinked.getContinuingSense() == 2) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                        }
                        if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA3) == null) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                        }
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA3);
                    }
                    if (state == 4) {
                        if (tLinked.getContinuingSense() == 4) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                        }
                        if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA3) == null) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                        }
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA3);
                    }
                    log.error("Cannot choose 3-way signal head to return because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)tLinked.getTurnout().getSystemName());
                    return null;
                }
                log.error("Cannot choose 3-way signal head to return because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)lt.getTurnout().getSystemName());
                return null;
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.SECOND_3_WAY) {
                return null;
            }
        }
        if (cType == HitPointType.TURNOUT_B) {
            lt = (LayoutTurnout)connected;
            if (lt.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER || lt.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                if (facingIsBlock1) {
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTB2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                    }
                    if (((TrackSegment)lt.getConnectA()).getBlockName().equals(protectedBlock.getUserName())) {
                        if (!((TrackSegment)lt.getConnectD()).getBlockName().equals(protectedBlock.getUserName())) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                        }
                        int state = lt.getTurnout().getKnownState();
                        if (state == 2 && lt.getContinuingSense() == 2 || state == 4 && lt.getContinuingSense() == 4) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                        }
                        if (state == 4 && lt.getContinuingSense() == 2 || state == 2 && lt.getContinuingSense() == 4) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTB2);
                        }
                        log.error("LayoutTurnout {} cannot choose signal head because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)lt, (Object)lt.getTurnout());
                        return null;
                    }
                    if (((TrackSegment)lt.getConnectD()).getBlockName().equals(protectedBlock.getUserName())) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTB2);
                    }
                    if (!lt.getBlockName().equals(protectedBlock.getUserName())) {
                        log.error("neither signal at B protects block {}, and turnout is not in block either", (Object)protectedBlock.getDisplayName());
                    }
                    return null;
                }
                if (((TrackSegment)lt.getConnectA()).getBlockName().equals(facingBlock.getUserName())) {
                    if (!((TrackSegment)lt.getConnectD()).getBlockName().equals(facingBlock.getUserName())) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                    }
                    int state = lt.getTurnout().getKnownState();
                    if (state == 2 && lt.getContinuingSense() == 2 || state == 4 && lt.getContinuingSense() == 4) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                    }
                    if (state == 4 && lt.getContinuingSense() == 2 || state == 2 && lt.getContinuingSense() == 4) {
                        if (lt.getSignalHead(LayoutTurnout.Geometry.POINTD2) == null) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                        }
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTD2);
                    }
                    log.error("Cannot choose signal head because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)lt.getTurnout().getDisplayName());
                    return null;
                }
                if (((TrackSegment)lt.getConnectD()).getBlockName().equals(facingBlock.getUserName())) {
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTD2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTD2);
                }
                if (!lt.getBlockName().equals(facingBlock.getUserName())) {
                    log.error("no signal faces block {}, and turnout is not in block either", (Object)facingBlock.getDisplayName());
                }
                return null;
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.NO_LINK && lt.getContinuingSense() == 2) {
                if (facingIsBlock1) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                }
                return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.NO_LINK) {
                if (facingIsBlock1) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA2) == null) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                }
                return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.THROAT_TO_THROAT) {
                if (!facingIsBlock1) {
                    return null;
                }
                if (lt.getContinuingSense() == 2 && lt.getSignalHead(LayoutTurnout.Geometry.POINTB2) == null) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                }
                if (lt.getContinuingSense() == 4 && lt.getSignalHead(LayoutTurnout.Geometry.POINTC2) == null) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                LayoutTurnout tLinked = panel.getFinder().findLayoutTurnoutByTurnoutName(lt.getLinkedTurnoutName());
                int state = tLinked.getTurnout().getKnownState();
                if (state == 2) {
                    if (lt.getContinuingSense() == 2) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                if (state == 4) {
                    if (lt.getContinuingSense() == 2) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTB2);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC2);
                }
                log.error("Cannot choose signal head to return because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)tLinked.getTurnout().getDisplayName());
                return null;
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.FIRST_3_WAY) {
                return null;
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.SECOND_3_WAY) {
                if (facingIsBlock1) {
                    if (lt.getContinuingSense() == 2) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                LayoutTurnout tLinked = panel.getFinder().findLayoutTurnoutByTurnoutName(lt.getLinkedTurnoutName());
                if (lt.getContinuingSense() == 2) {
                    return tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                }
                if (tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA3) == null) {
                    return tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                }
                return tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA3);
            }
        }
        if (cType == HitPointType.TURNOUT_C) {
            lt = (LayoutTurnout)connected;
            if (lt.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER || lt.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                if (facingIsBlock1) {
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTC2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                    }
                    if (((TrackSegment)lt.getConnectA()).getBlockName().equals(protectedBlock.getUserName())) {
                        if (!((TrackSegment)lt.getConnectD()).getBlockName().equals(protectedBlock.getUserName())) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTC2);
                        }
                        int state = lt.getTurnout().getKnownState();
                        if (state == 2 && lt.getContinuingSense() == 2 || state == 4 && lt.getContinuingSense() == 4) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                        }
                        if (state == 4 && lt.getContinuingSense() == 2 || state == 2 && lt.getContinuingSense() == 4) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTC2);
                        }
                        log.error("Cannot choose signal head because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)lt.getTurnout().getDisplayName());
                        return null;
                    }
                    if (((TrackSegment)lt.getConnectD()).getBlockName().equals(protectedBlock.getUserName())) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                    }
                    if (!lt.getBlockName().equals(protectedBlock.getUserName())) {
                        log.error("neither signal at C protects block {}, and turnout is not in block either", (Object)protectedBlock.getDisplayName());
                    }
                    return null;
                }
                if (((TrackSegment)lt.getConnectD()).getBlockName().equals(facingBlock.getUserName())) {
                    if (!((TrackSegment)lt.getConnectA()).getBlockName().equals(facingBlock.getUserName())) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                    }
                    int state = lt.getTurnout().getKnownState();
                    if (state == 2 && lt.getContinuingSense() == 2 || state == 4 && lt.getContinuingSense() == 4) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                    }
                    if (state == 4 && lt.getContinuingSense() == 2 || state == 2 && lt.getContinuingSense() == 4) {
                        if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA2) == null) {
                            return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                        }
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
                    }
                    log.error("Cannot choose signal head because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)lt.getTurnout().getDisplayName());
                    return null;
                }
                if (((TrackSegment)lt.getConnectA()).getBlockName().equals(facingBlock.getUserName())) {
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
                }
                if (!lt.getBlockName().equals(facingBlock.getUserName())) {
                    log.error("no signal faces block {}, and turnout is not in block either", (Object)facingBlock.getDisplayName());
                }
                return null;
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.NO_LINK && lt.getContinuingSense() == 2) {
                if (facingIsBlock1) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                if (lt.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                }
                if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA2) == null) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                }
                return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.NO_LINK) {
                if (facingIsBlock1) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                }
                return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.THROAT_TO_THROAT) {
                if (!facingIsBlock1) {
                    return null;
                }
                if (lt.getContinuingSense() == 2 && lt.getSignalHead(LayoutTurnout.Geometry.POINTC2) == null) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                if (lt.getContinuingSense() == 4 && lt.getSignalHead(LayoutTurnout.Geometry.POINTB2) == null) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                }
                LayoutTurnout tLinked = panel.getFinder().findLayoutTurnoutByTurnoutName(lt.getLinkedTurnoutName());
                int state = tLinked.getTurnout().getKnownState();
                if (state == 2) {
                    if (lt.getContinuingSense() == 2) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                }
                if (state == 4) {
                    if (lt.getContinuingSense() == 2) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTC2);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB2);
                }
                log.error("Cannot choose signal head to return because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)tLinked.getTurnout().getDisplayName());
                return null;
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.FIRST_3_WAY) {
                if (facingIsBlock1) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                if (lt.getSignalHead(LayoutTurnout.Geometry.POINTA2) == null) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                }
                return lt.getSignalHead(LayoutTurnout.Geometry.POINTA2);
            }
            if (lt.getLinkType() == LayoutTurnout.LinkType.SECOND_3_WAY) {
                if (facingIsBlock1) {
                    if (lt.getContinuingSense() == 2) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                }
                LayoutTurnout tLinked = panel.getFinder().findLayoutTurnoutByTurnoutName(lt.getLinkedTurnoutName());
                if (lt.getContinuingSense() == 2) {
                    if (tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA3) == null) {
                        return tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                    }
                    return tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA3);
                }
                if (tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA2) == null) {
                    return tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                }
                return tLinked.getSignalHead(LayoutTurnout.Geometry.POINTA2);
            }
        }
        if (cType == HitPointType.TURNOUT_D) {
            lt = (LayoutTurnout)connected;
            if (lt.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                if (facingIsBlock1) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                }
                return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
            }
            if (facingIsBlock1) {
                if (lt.getSignalHead(LayoutTurnout.Geometry.POINTD2) == null) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                }
                if (((TrackSegment)lt.getConnectC()).getBlockName().equals(protectedBlock.getUserName())) {
                    if (!((TrackSegment)lt.getConnectB()).getBlockName().equals(protectedBlock.getUserName())) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                    }
                    int state = lt.getTurnout().getKnownState();
                    if (state == 2 && lt.getContinuingSense() == 2 || state == 4 && lt.getContinuingSense() == 4) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                    }
                    if (state == 4 && lt.getContinuingSense() == 2 || state == 2 && lt.getContinuingSense() == 4) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTD2);
                    }
                    log.error("Cannot choose signal head because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)lt.getTurnout().getDisplayName());
                    return null;
                }
                if (((TrackSegment)lt.getConnectB()).getBlockName().equals(protectedBlock.getUserName())) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTD2);
                }
                if (!lt.getBlockName().equals(protectedBlock.getUserName())) {
                    log.error("neither signal at D protects block {}, and turnout is not in block either", (Object)protectedBlock.getDisplayName());
                }
                return null;
            }
            if (((TrackSegment)lt.getConnectC()).getBlockName().equals(facingBlock.getUserName())) {
                if (!((TrackSegment)lt.getConnectB()).getBlockName().equals(facingBlock.getUserName())) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                int state = lt.getTurnout().getKnownState();
                if (state == 2 && lt.getContinuingSense() == 2 || state == 4 && lt.getContinuingSense() == 4) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                if (state == 4 && lt.getContinuingSense() == 2 || state == 2 && lt.getContinuingSense() == 4) {
                    if (lt.getSignalHead(LayoutTurnout.Geometry.POINTB2) == null) {
                        return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                    }
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB2);
                }
                log.error("Cannot choose signal head because turnout {} is in an UNKNOWN or INCONSISTENT state.", (Object)lt.getTurnout().getDisplayName());
                return null;
            }
            if (((TrackSegment)lt.getConnectB()).getBlockName().equals(facingBlock.getUserName())) {
                if (lt.getSignalHead(LayoutTurnout.Geometry.POINTB2) == null) {
                    return lt.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                }
                return lt.getSignalHead(LayoutTurnout.Geometry.POINTB2);
            }
            if (!lt.getBlockName().equals(facingBlock.getUserName())) {
                log.error("no signal faces block {}, and turnout is not in block either", (Object)facingBlock.getDisplayName());
            }
            return null;
        }
        if (HitPointType.isSlipHitType(cType)) {
            if (!facingIsBlock1) {
                return null;
            }
            LayoutSlip ls = (LayoutSlip)connected;
            switch (cType) {
                case SLIP_A: {
                    if (ls.getSlipState() == 6) {
                        return ls.getSignalHead(LayoutTurnout.Geometry.POINTA2);
                    }
                    return ls.getSignalHead(LayoutTurnout.Geometry.POINTA1);
                }
                case SLIP_B: {
                    if (ls.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                        if (ls.getSlipState() == 8) {
                            return ls.getSignalHead(LayoutTurnout.Geometry.POINTB2);
                        }
                        return ls.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                    }
                    return ls.getSignalHead(LayoutTurnout.Geometry.POINTB1);
                }
                case SLIP_C: {
                    if (ls.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                        if (ls.getSlipState() == 8) {
                            return ls.getSignalHead(LayoutTurnout.Geometry.POINTC2);
                        }
                        return ls.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                    }
                    return ls.getSignalHead(LayoutTurnout.Geometry.POINTC1);
                }
                case SLIP_D: {
                    if (ls.getSlipState() == 6) {
                        return ls.getSignalHead(LayoutTurnout.Geometry.POINTD2);
                    }
                    return ls.getSignalHead(LayoutTurnout.Geometry.POINTD1);
                }
            }
        }
        if (!HitPointType.isLevelXingHitType(cType)) {
            log.error("{} {} Block Boundary not identified correctly - Blocks {}, {}", new Object[]{cType, connected, facingBlock.getDisplayName(), protectedBlock.getDisplayName()});
            return null;
        }
        LevelXing xing = (LevelXing)connected;
        switch (cType) {
            case LEVEL_XING_A: {
                if (facingIsBlock1) {
                    return xing.getSignalHead(LevelXing.Geometry.POINTA);
                }
                return xing.getSignalHead(LevelXing.Geometry.POINTC);
            }
            case LEVEL_XING_B: {
                if (facingIsBlock1) {
                    return xing.getSignalHead(LevelXing.Geometry.POINTB);
                }
                return xing.getSignalHead(LevelXing.Geometry.POINTD);
            }
            case LEVEL_XING_C: {
                if (facingIsBlock1) {
                    return xing.getSignalHead(LevelXing.Geometry.POINTC);
                }
                return xing.getSignalHead(LevelXing.Geometry.POINTA);
            }
            case LEVEL_XING_D: {
                if (facingIsBlock1) {
                    return xing.getSignalHead(LevelXing.Geometry.POINTD);
                }
                return xing.getSignalHead(LevelXing.Geometry.POINTB);
            }
        }
        return null;
    }

    @CheckReturnValue
    @CheckForNull
    public NamedBean getNamedBeanAtEndBumper(@CheckForNull Block facingBlock, @CheckForNull LayoutEditor panel) {
        SignalMast bean = this.getSignalMastAtEndBumper(facingBlock, panel);
        if (bean != null) {
            return bean;
        }
        return this.getSensorAtEndBumper(facingBlock, panel);
    }

    @CheckReturnValue
    @CheckForNull
    public SignalMast getSignalMastAtEndBumper(@CheckForNull Block facingBlock, @CheckForNull LayoutEditor panel) {
        if (facingBlock == null) {
            log.error("null block in call to getFacingSignalMast");
            return null;
        }
        String facingBlockName = facingBlock.getUserName();
        if (facingBlockName == null || facingBlockName.isEmpty()) {
            log.error("facing block has no user name");
            return null;
        }
        LayoutBlock fLayoutBlock = (LayoutBlock)this.getByUserName(facingBlockName);
        if (fLayoutBlock == null) {
            log.error("Block {} is not on a Layout Editor panel.", (Object)facingBlock.getDisplayName());
            return null;
        }
        if (panel == null) {
            panel = fLayoutBlock.getMaxConnectedPanel();
        }
        for (TrackSegment t : panel.getTrackSegments()) {
            PositionablePoint p;
            if (t.getLayoutBlock() != fLayoutBlock) continue;
            if (t.getType1() == HitPointType.POS_POINT && (p = (PositionablePoint)t.getConnect1()).getType() == PositionablePoint.PointType.END_BUMPER) {
                if (p.getEastBoundSignalMast() != null) {
                    return p.getEastBoundSignalMast();
                }
                if (p.getWestBoundSignalMast() != null) {
                    return p.getWestBoundSignalMast();
                }
            }
            if (t.getType2() != HitPointType.POS_POINT || (p = (PositionablePoint)t.getConnect2()).getType() != PositionablePoint.PointType.END_BUMPER) continue;
            if (p.getEastBoundSignalMast() != null) {
                return p.getEastBoundSignalMast();
            }
            if (p.getWestBoundSignalMast() == null) continue;
            return p.getWestBoundSignalMast();
        }
        return null;
    }

    @CheckReturnValue
    @CheckForNull
    public Sensor getSensorAtEndBumper(@CheckForNull Block facingBlock, @CheckForNull LayoutEditor panel) {
        if (facingBlock == null) {
            log.error("null block in call to getFacingSensor");
            return null;
        }
        String facingBlockName = facingBlock.getUserName();
        if (facingBlockName == null || facingBlockName.isEmpty()) {
            log.error("Block {} has no user name.", (Object)facingBlock.getDisplayName());
            return null;
        }
        LayoutBlock fLayoutBlock = (LayoutBlock)this.getByUserName(facingBlockName);
        if (fLayoutBlock == null) {
            log.error("Block {} is not on a Layout Editor panel.", (Object)facingBlock.getDisplayName());
            return null;
        }
        if (panel == null) {
            panel = fLayoutBlock.getMaxConnectedPanel();
        }
        for (TrackSegment t : panel.getTrackSegments()) {
            PositionablePoint p;
            if (t.getLayoutBlock() != fLayoutBlock) continue;
            if (t.getType1() == HitPointType.POS_POINT && (p = (PositionablePoint)t.getConnect1()).getType() == PositionablePoint.PointType.END_BUMPER) {
                if (p.getEastBoundSensor() != null) {
                    return p.getEastBoundSensor();
                }
                if (p.getWestBoundSensor() != null) {
                    return p.getWestBoundSensor();
                }
            }
            if (t.getType2() != HitPointType.POS_POINT || (p = (PositionablePoint)t.getConnect2()).getType() != PositionablePoint.PointType.END_BUMPER) continue;
            if (p.getEastBoundSensor() != null) {
                return p.getEastBoundSensor();
            }
            if (p.getWestBoundSensor() == null) continue;
            return p.getWestBoundSensor();
        }
        return null;
    }

    @CheckReturnValue
    @CheckForNull
    public NamedBean getFacingNamedBean(@CheckForNull Block facingBlock, @CheckForNull Block protectedBlock, @CheckForNull LayoutEditor panel) {
        NamedBean bean = this.getFacingBean(facingBlock, protectedBlock, panel, SignalMast.class);
        if (bean != null) {
            return bean;
        }
        bean = this.getFacingBean(facingBlock, protectedBlock, panel, Sensor.class);
        if (bean != null) {
            return bean;
        }
        return this.getFacingSignalHead(facingBlock, protectedBlock);
    }

    @CheckReturnValue
    @CheckForNull
    public SignalMast getFacingSignalMast(@Nonnull Block facingBlock, @CheckForNull Block protectedBlock) {
        return this.getFacingSignalMast(facingBlock, protectedBlock, null);
    }

    @CheckReturnValue
    @CheckForNull
    public SignalMast getFacingSignalMast(@Nonnull Block facingBlock, @CheckForNull Block protectedBlock, @CheckForNull LayoutEditor panel) {
        log.debug("calling getFacingMast on block '{}'", (Object)facingBlock.getDisplayName());
        return (SignalMast)this.getFacingBean(facingBlock, protectedBlock, panel, SignalMast.class);
    }

    @CheckReturnValue
    @CheckForNull
    public Sensor getFacingSensor(@CheckForNull Block facingBlock, @CheckForNull Block protectedBlock, @CheckForNull LayoutEditor panel) {
        return (Sensor)this.getFacingBean(facingBlock, protectedBlock, panel, Sensor.class);
    }

    @CheckReturnValue
    @CheckForNull
    public NamedBean getFacingBean(@CheckForNull Block facingBlock, @CheckForNull Block protectedBlock, @CheckForNull LayoutEditor panel, Class<?> T) {
        TrackSegment t;
        LayoutTurnout lt;
        LayoutBlock pLayoutBlock;
        String facingBlockName;
        if (facingBlock == null || protectedBlock == null) {
            log.error("null block in call to getFacingSignalMast");
            return null;
        }
        if (!T.equals(SignalMast.class) && !T.equals(Sensor.class)) {
            log.error("Incorrect class type called, must be either SignalMast or Sensor");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("find signal mast between facing {} ({}) - protected {} ({})", new Object[]{facingBlock.getDisplayName(), facingBlock.getDisplayName(), protectedBlock.getDisplayName(), protectedBlock.getDisplayName()});
        }
        if ((facingBlockName = facingBlock.getUserName()) == null || facingBlockName.isEmpty()) {
            log.error("facing block has no user name");
            return null;
        }
        LayoutBlock fLayoutBlock = (LayoutBlock)this.getByUserName(facingBlockName);
        String protectedBlockName = protectedBlock.getUserName();
        LayoutBlock layoutBlock = pLayoutBlock = protectedBlockName == null ? null : (LayoutBlock)this.getByUserName(protectedBlockName);
        if (fLayoutBlock == null || pLayoutBlock == null) {
            if (fLayoutBlock == null) {
                log.error("Block {} is not on a Layout Editor panel.", (Object)facingBlock.getDisplayName());
            }
            if (pLayoutBlock == null) {
                log.error("Block {} is not on a Layout Editor panel.", (Object)protectedBlock.getDisplayName());
            }
            return null;
        }
        if (panel == null) {
            panel = fLayoutBlock.getMaxConnectedPanel();
        }
        List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(fLayoutBlock);
        LayoutConnectivity lc = null;
        boolean facingIsBlock1 = true;
        for (int i = 0; i < c.size() && lc == null; ++i) {
            LayoutConnectivity tlc = c.get(i);
            if (tlc.getBlock1() == fLayoutBlock && tlc.getBlock2() == pLayoutBlock) {
                lc = tlc;
                continue;
            }
            if (tlc.getBlock1() != pLayoutBlock || tlc.getBlock2() != fLayoutBlock) continue;
            lc = tlc;
            facingIsBlock1 = false;
        }
        if (lc == null) {
            PositionablePoint p = panel.getFinder().findPositionableLinkPoint(fLayoutBlock);
            if (p == null) {
                p = panel.getFinder().findPositionableLinkPoint(pLayoutBlock);
            }
            if (p != null && p.getLinkedEditor() != null) {
                return this.getFacingBean(facingBlock, protectedBlock, p.getLinkedEditor(), T);
            }
            log.debug("Block {} is not connected to Block {} on panel {}", new Object[]{facingBlock.getDisplayName(), protectedBlock.getDisplayName(), panel.getLayoutName()});
            return null;
        }
        LayoutTrack connected = lc.getConnectedObject();
        TrackSegment tr = lc.getTrackSegment();
        HitPointType cType = lc.getConnectedType();
        if (connected == null && lc.getXover() != null) {
            if (lc.getXoverBoundaryType() == 1) {
                cType = fLayoutBlock == lc.getXover().getLayoutBlock() ? HitPointType.TURNOUT_A : HitPointType.TURNOUT_B;
                connected = lc.getXover();
            } else if (lc.getXoverBoundaryType() == 2) {
                cType = fLayoutBlock == lc.getXover().getLayoutBlockC() ? HitPointType.TURNOUT_C : HitPointType.TURNOUT_D;
                connected = lc.getXover();
            } else if (lc.getXoverBoundaryType() == 3) {
                cType = fLayoutBlock == lc.getXover().getLayoutBlock() ? HitPointType.TURNOUT_A : HitPointType.TURNOUT_C;
                connected = lc.getXover();
            } else if (lc.getXoverBoundaryType() == 4) {
                cType = fLayoutBlock == lc.getXover().getLayoutBlockB() ? HitPointType.TURNOUT_B : HitPointType.TURNOUT_D;
                connected = lc.getXover();
            }
        }
        if (connected == null) {
            log.error("No connectivity object found between Blocks {}, {} {}", new Object[]{facingBlock.getDisplayName(), protectedBlock.getDisplayName(), cType});
            return null;
        }
        if (cType == HitPointType.TRACK) {
            PositionablePoint p = panel.getFinder().findPositionablePointAtTrackSegments(tr, (TrackSegment)connected);
            boolean block1IsWestEnd = LayoutEditorTools.isAtWestEndOfAnchor(panel, tr, p);
            log.debug("Track is west end? {}", (Object)block1IsWestEnd);
            if (block1IsWestEnd && facingIsBlock1 || !block1IsWestEnd && !facingIsBlock1) {
                if (T.equals(SignalMast.class)) {
                    return p.getEastBoundSignalMast();
                }
                if (T.equals(Sensor.class)) {
                    return p.getEastBoundSensor();
                }
            } else {
                if (T.equals(SignalMast.class)) {
                    return p.getWestBoundSignalMast();
                }
                if (T.equals(Sensor.class)) {
                    return p.getWestBoundSensor();
                }
            }
        }
        if (cType == HitPointType.TURNOUT_A) {
            lt = (LayoutTurnout)connected;
            if ((lt.getLinkType() == LayoutTurnout.LinkType.NO_LINK || lt.getLinkType() == LayoutTurnout.LinkType.FIRST_3_WAY) && (T.equals(SignalMast.class) && lt.getSignalAMast() != null || T.equals(Sensor.class) && lt.getSensorA() != null)) {
                if (tr == null) {
                    if (lt.getConnectA() instanceof TrackSegment && (t = (TrackSegment)lt.getConnectA()).getLayoutBlock() != null && t.getLayoutBlock() == lt.getLayoutBlock()) {
                        if (T.equals(SignalMast.class)) {
                            return lt.getSignalAMast();
                        }
                        if (T.equals(Sensor.class)) {
                            return lt.getSensorA();
                        }
                    }
                } else if (tr.getLayoutBlock().getBlock() == facingBlock) {
                    if (T.equals(SignalMast.class)) {
                        return lt.getSignalAMast();
                    }
                    if (T.equals(Sensor.class)) {
                        return lt.getSensorA();
                    }
                }
            }
            return null;
        }
        if (cType == HitPointType.TURNOUT_B) {
            lt = (LayoutTurnout)connected;
            if (T.equals(SignalMast.class) && lt.getSignalBMast() != null || T.equals(Sensor.class) && lt.getSensorB() != null) {
                if (tr == null) {
                    if (lt.getConnectB() instanceof TrackSegment && (t = (TrackSegment)lt.getConnectB()).getLayoutBlock() != null && t.getLayoutBlock() == lt.getLayoutBlockB()) {
                        if (T.equals(SignalMast.class)) {
                            return lt.getSignalBMast();
                        }
                        if (T.equals(Sensor.class)) {
                            return lt.getSensorB();
                        }
                    }
                } else if (tr.getLayoutBlock().getBlock() == facingBlock) {
                    if (T.equals(SignalMast.class)) {
                        return lt.getSignalBMast();
                    }
                    if (T.equals(Sensor.class)) {
                        return lt.getSensorB();
                    }
                }
            }
            return null;
        }
        if (cType == HitPointType.TURNOUT_C) {
            lt = (LayoutTurnout)connected;
            if (T.equals(SignalMast.class) && lt.getSignalCMast() != null || T.equals(Sensor.class) && lt.getSensorC() != null) {
                if (tr == null) {
                    if (lt.getConnectC() instanceof TrackSegment && (t = (TrackSegment)lt.getConnectC()).getLayoutBlock() != null && t.getLayoutBlock() == lt.getLayoutBlockC()) {
                        if (T.equals(SignalMast.class)) {
                            return lt.getSignalCMast();
                        }
                        if (T.equals(Sensor.class)) {
                            return lt.getSensorC();
                        }
                    }
                } else if (tr.getLayoutBlock().getBlock() == facingBlock) {
                    if (T.equals(SignalMast.class)) {
                        return lt.getSignalCMast();
                    }
                    if (T.equals(Sensor.class)) {
                        return lt.getSensorC();
                    }
                }
            }
            return null;
        }
        if (cType == HitPointType.TURNOUT_D) {
            lt = (LayoutTurnout)connected;
            if (T.equals(SignalMast.class) && lt.getSignalDMast() != null || T.equals(Sensor.class) && lt.getSensorD() != null) {
                if (tr == null) {
                    if (lt.getConnectD() instanceof TrackSegment && (t = (TrackSegment)lt.getConnectD()).getLayoutBlock() != null && t.getLayoutBlock() == lt.getLayoutBlockD()) {
                        if (T.equals(SignalMast.class)) {
                            return lt.getSignalDMast();
                        }
                        if (T.equals(Sensor.class)) {
                            return lt.getSensorD();
                        }
                    }
                } else if (tr.getLayoutBlock().getBlock() == facingBlock) {
                    if (T.equals(SignalMast.class)) {
                        return lt.getSignalDMast();
                    }
                    if (T.equals(Sensor.class)) {
                        return lt.getSensorD();
                    }
                }
            }
            return null;
        }
        if (tr == null || tr.getLayoutBlock().getBlock() != facingBlock) {
            return null;
        }
        if (HitPointType.isSlipHitType(cType)) {
            LayoutSlip ls = (LayoutSlip)connected;
            if (cType == HitPointType.SLIP_A) {
                if (T.equals(SignalMast.class)) {
                    return ls.getSignalAMast();
                }
                if (T.equals(Sensor.class)) {
                    return ls.getSensorA();
                }
            }
            if (cType == HitPointType.SLIP_B) {
                if (T.equals(SignalMast.class)) {
                    return ls.getSignalBMast();
                }
                if (T.equals(Sensor.class)) {
                    return ls.getSensorB();
                }
            }
            if (cType == HitPointType.SLIP_C) {
                if (T.equals(SignalMast.class)) {
                    return ls.getSignalCMast();
                }
                if (T.equals(Sensor.class)) {
                    return ls.getSensorC();
                }
            }
            if (cType == HitPointType.SLIP_D) {
                if (T.equals(SignalMast.class)) {
                    return ls.getSignalDMast();
                }
                if (T.equals(Sensor.class)) {
                    return ls.getSensorD();
                }
            }
        }
        if (!HitPointType.isLevelXingHitType(cType)) {
            log.error("Block Boundary not identified correctly - Blocks {}, {}", (Object)facingBlock.getDisplayName(), (Object)protectedBlock.getDisplayName());
            return null;
        }
        LevelXing xing = (LevelXing)connected;
        if (cType == HitPointType.LEVEL_XING_A) {
            if (T.equals(SignalMast.class)) {
                return xing.getSignalAMast();
            }
            if (T.equals(Sensor.class)) {
                return xing.getSensorA();
            }
        }
        if (cType == HitPointType.LEVEL_XING_B) {
            if (T.equals(SignalMast.class)) {
                return xing.getSignalBMast();
            }
            if (T.equals(Sensor.class)) {
                return xing.getSensorB();
            }
        }
        if (cType == HitPointType.LEVEL_XING_C) {
            if (T.equals(SignalMast.class)) {
                return xing.getSignalCMast();
            }
            if (T.equals(Sensor.class)) {
                return xing.getSensorC();
            }
        }
        if (cType == HitPointType.LEVEL_XING_D) {
            if (T.equals(SignalMast.class)) {
                return xing.getSignalDMast();
            }
            if (T.equals(Sensor.class)) {
                return xing.getSensorD();
            }
        }
        return null;
    }

    @CheckReturnValue
    @CheckForNull
    public Object getFacingSignalObject(@Nonnull Block facingBlock, @CheckForNull Block protectedBlock) {
        Signal sig = this.getFacingSignalMast(facingBlock, protectedBlock, null);
        if (sig != null) {
            return sig;
        }
        sig = this.getFacingSignalHead(facingBlock, protectedBlock);
        return sig;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getProtectedBlockByNamedBean(@CheckForNull NamedBean nb, @CheckForNull LayoutEditor panel) {
        if (nb instanceof SignalHead) {
            return this.getProtectedBlock((SignalHead)nb, panel);
        }
        List<LayoutBlock> proBlocks = this.getProtectingBlocksByBean(nb, panel);
        if (proBlocks.isEmpty()) {
            return null;
        }
        return proBlocks.get(0);
    }

    @CheckReturnValue
    @Nonnull
    public List<LayoutBlock> getProtectingBlocksByNamedBean(@CheckForNull NamedBean nb, @CheckForNull LayoutEditor panel) {
        ArrayList<LayoutBlock> ret = new ArrayList<LayoutBlock>();
        if (nb instanceof SignalHead) {
            ret.add(this.getProtectedBlock((SignalHead)nb, panel));
            return ret;
        }
        return this.getProtectingBlocksByBean(nb, panel);
    }

    @Nonnull
    private List<LayoutBlock> getProtectingBlocksByBean(@CheckForNull NamedBean bean, @CheckForNull LayoutEditor panel) {
        if (panel == null) {
            LayoutEditor p;
            SortedSet<LayoutEditor> panels = InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class);
            List<LayoutBlock> protectingBlocks = new ArrayList<LayoutBlock>();
            Iterator iterator = panels.iterator();
            while (iterator.hasNext() && (protectingBlocks = this.getProtectingBlocksByBeanByPanel(bean, p = (LayoutEditor)iterator.next())).isEmpty()) {
            }
            return protectingBlocks;
        }
        return this.getProtectingBlocksByBeanByPanel(bean, panel);
    }

    @Nonnull
    private List<LayoutBlock> getProtectingBlocksByBeanByPanel(@CheckForNull NamedBean bean, @Nonnull LayoutEditor panel) {
        LevelXing l;
        ArrayList<LayoutBlock> protectingBlocks = new ArrayList<LayoutBlock>();
        if (!(bean instanceof SignalMast) && !(bean instanceof Sensor)) {
            log.error("Incorrect class type called, must be either SignalMast or Sensor");
            return protectingBlocks;
        }
        PositionablePoint pp = panel.getFinder().findPositionablePointByEastBoundBean(bean);
        boolean east = true;
        if (pp == null) {
            pp = panel.getFinder().findPositionablePointByWestBoundBean(bean);
            east = false;
        }
        if (pp != null) {
            TrackSegment tr = east ? (LayoutEditorTools.isAtWestEndOfAnchor(panel, pp.getConnect1(), pp) ? pp.getConnect2() : pp.getConnect1()) : (LayoutEditorTools.isAtWestEndOfAnchor(panel, pp.getConnect1(), pp) ? pp.getConnect1() : pp.getConnect2());
            if (tr != null) {
                protectingBlocks.add(tr.getLayoutBlock());
                return protectingBlocks;
            }
        }
        if ((l = panel.getFinder().findLevelXingByBean(bean)) != null) {
            if (bean instanceof SignalMast) {
                if (l.getSignalAMast() == bean) {
                    protectingBlocks.add(l.getLayoutBlockAC());
                } else if (l.getSignalBMast() == bean) {
                    protectingBlocks.add(l.getLayoutBlockBD());
                } else if (l.getSignalCMast() == bean) {
                    protectingBlocks.add(l.getLayoutBlockAC());
                } else {
                    protectingBlocks.add(l.getLayoutBlockBD());
                }
            } else if (bean instanceof Sensor) {
                if (l.getSensorA() == bean) {
                    protectingBlocks.add(l.getLayoutBlockAC());
                } else if (l.getSensorB() == bean) {
                    protectingBlocks.add(l.getLayoutBlockBD());
                } else if (l.getSensorC() == bean) {
                    protectingBlocks.add(l.getLayoutBlockAC());
                } else {
                    protectingBlocks.add(l.getLayoutBlockBD());
                }
            }
            return protectingBlocks;
        }
        LayoutSlip ls = panel.getFinder().findLayoutSlipByBean(bean);
        if (ls != null) {
            protectingBlocks.add(ls.getLayoutBlock());
            return protectingBlocks;
        }
        LayoutTurnout t = panel.getFinder().findLayoutTurnoutByBean(bean);
        if (t != null) {
            return t.getProtectedBlocks(bean);
        }
        return protectingBlocks;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getProtectedBlockByMast(@CheckForNull SignalMast signalMast, @CheckForNull LayoutEditor panel) {
        List<LayoutBlock> proBlocks = this.getProtectingBlocksByBean(signalMast, panel);
        if (proBlocks.isEmpty()) {
            return null;
        }
        return proBlocks.get(0);
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getProtectedBlockBySensor(@Nonnull String sensorName, @CheckForNull LayoutEditor panel) {
        Sensor sensor = InstanceManager.sensorManagerInstance().getSensor(sensorName);
        return this.getProtectedBlockBySensor(sensor, panel);
    }

    @Nonnull
    public List<LayoutBlock> getProtectingBlocksBySensor(@CheckForNull Sensor sensor, @CheckForNull LayoutEditor panel) {
        return this.getProtectingBlocksByBean(sensor, panel);
    }

    @Nonnull
    public List<LayoutBlock> getProtectingBlocksBySensorOld(@CheckForNull Sensor sensor, @Nonnull LayoutEditor panel) {
        LevelXing l;
        ArrayList<LayoutBlock> result = new ArrayList<LayoutBlock>();
        PositionablePoint pp = panel.getFinder().findPositionablePointByEastBoundBean(sensor);
        boolean east = true;
        if (pp == null) {
            pp = panel.getFinder().findPositionablePointByWestBoundBean(sensor);
            east = false;
        }
        if (pp != null) {
            TrackSegment tr = east ? (LayoutEditorTools.isAtWestEndOfAnchor(panel, pp.getConnect1(), pp) ? pp.getConnect2() : pp.getConnect1()) : (LayoutEditorTools.isAtWestEndOfAnchor(panel, pp.getConnect1(), pp) ? pp.getConnect1() : pp.getConnect2());
            if (tr != null) {
                result.add(tr.getLayoutBlock());
                return result;
            }
        }
        if ((l = panel.getFinder().findLevelXingByBean(sensor)) != null) {
            if (l.getSensorA() == sensor) {
                result.add(l.getLayoutBlockAC());
            } else if (l.getSensorB() == sensor) {
                result.add(l.getLayoutBlockBD());
            } else if (l.getSensorC() == sensor) {
                result.add(l.getLayoutBlockAC());
            } else {
                result.add(l.getLayoutBlockBD());
            }
            return result;
        }
        LayoutSlip ls = panel.getFinder().findLayoutSlipByBean(sensor);
        if (ls != null) {
            result.add(ls.getLayoutBlock());
            return result;
        }
        LayoutTurnout t = panel.getFinder().findLayoutTurnoutByBean(sensor);
        if (t != null) {
            return t.getProtectedBlocks(sensor);
        }
        return result;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getProtectedBlockBySensor(@CheckForNull Sensor sensor, @CheckForNull LayoutEditor panel) {
        List<LayoutBlock> proBlocks = this.getProtectingBlocksByBean(sensor, panel);
        if (proBlocks.isEmpty()) {
            return null;
        }
        return proBlocks.get(0);
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getFacingBlockByNamedBean(@Nonnull NamedBean nb, @CheckForNull LayoutEditor panel) {
        if (nb instanceof SignalHead) {
            return this.getFacingBlock((SignalHead)nb, panel);
        }
        return this.getFacingBlockByBean(nb, panel);
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getFacingBlockBySensor(@Nonnull String sensorName, @CheckForNull LayoutEditor panel) {
        LayoutBlock result = null;
        if (panel != null) {
            Sensor sensor = InstanceManager.sensorManagerInstance().getSensor(sensorName);
            result = sensor == null ? null : this.getFacingBlockBySensor(sensor, panel);
        }
        return result;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getFacingBlockByMast(@Nonnull SignalMast signalMast, @Nonnull LayoutEditor panel) {
        return this.getFacingBlockByBean(signalMast, panel);
    }

    @CheckReturnValue
    @CheckForNull
    private LayoutBlock getFacingBlockByBean(@Nonnull NamedBean bean, LayoutEditor panel) {
        if (panel == null) {
            LayoutEditor p;
            SortedSet<LayoutEditor> panels = InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class);
            LayoutBlock returnBlock = null;
            Iterator iterator = panels.iterator();
            while (iterator.hasNext() && (returnBlock = this.getFacingBlockByBeanByPanel(bean, p = (LayoutEditor)iterator.next())) == null) {
            }
            return returnBlock;
        }
        return this.getFacingBlockByBeanByPanel(bean, panel);
    }

    @CheckReturnValue
    @CheckForNull
    private LayoutBlock getFacingBlockByBeanByPanel(@Nonnull NamedBean bean, @Nonnull LayoutEditor panel) {
        LayoutSlip ls;
        LevelXing l;
        LayoutTurnout t;
        TrackSegment tr;
        PositionablePoint pp = panel.getFinder().findPositionablePointByEastBoundBean(bean);
        boolean east = true;
        if (pp == null) {
            pp = panel.getFinder().findPositionablePointByWestBoundBean(bean);
            east = false;
        }
        if (pp != null) {
            tr = east ? (LayoutEditorTools.isAtWestEndOfAnchor(panel, pp.getConnect1(), pp) ? pp.getConnect1() : pp.getConnect2()) : (LayoutEditorTools.isAtWestEndOfAnchor(panel, pp.getConnect1(), pp) ? pp.getConnect2() : pp.getConnect1());
            if (tr != null) {
                log.debug("found facing block by positionable point");
                return tr.getLayoutBlock();
            }
        }
        if ((t = panel.getFinder().findLayoutTurnoutByBean(bean)) != null) {
            log.debug("found signalmast at turnout {}", (Object)t.getTurnout().getDisplayName());
            LayoutTrack connect = null;
            if (bean instanceof SignalMast) {
                connect = t.getSignalAMast() == bean ? t.getConnectA() : (t.getSignalBMast() == bean ? t.getConnectB() : (t.getSignalCMast() == bean ? t.getConnectC() : t.getConnectD()));
            } else if (bean instanceof Sensor) {
                connect = t.getSensorA() == bean ? t.getConnectA() : (t.getSensorB() == bean ? t.getConnectB() : (t.getSensorC() == bean ? t.getConnectC() : t.getConnectD()));
            }
            if (connect instanceof TrackSegment) {
                tr = (TrackSegment)connect;
                log.debug("return block {}", (Object)tr.getLayoutBlock().getDisplayName());
                return tr.getLayoutBlock();
            }
        }
        if ((l = panel.getFinder().findLevelXingByBean(bean)) != null) {
            LayoutTrack connect = null;
            if (bean instanceof SignalMast) {
                connect = l.getSignalAMast() == bean ? l.getConnectA() : (l.getSignalBMast() == bean ? l.getConnectB() : (l.getSignalCMast() == bean ? l.getConnectC() : l.getConnectD()));
            } else if (bean instanceof Sensor) {
                connect = l.getSensorA() == bean ? l.getConnectA() : (l.getSensorB() == bean ? l.getConnectB() : (l.getSensorC() == bean ? l.getConnectC() : l.getConnectD()));
            }
            if (connect instanceof TrackSegment) {
                tr = (TrackSegment)connect;
                log.debug("return block {}", (Object)tr.getLayoutBlock().getDisplayName());
                return tr.getLayoutBlock();
            }
        }
        if ((ls = panel.getFinder().findLayoutSlipByBean(bean)) != null) {
            LayoutTrack connect = null;
            if (bean instanceof SignalMast) {
                connect = ls.getSignalAMast() == bean ? ls.getConnectA() : (ls.getSignalBMast() == bean ? ls.getConnectB() : (ls.getSignalCMast() == bean ? ls.getConnectC() : ls.getConnectD()));
            } else if (bean instanceof Sensor) {
                connect = ls.getSensorA() == bean ? ls.getConnectA() : (ls.getSensorB() == bean ? ls.getConnectB() : (ls.getSensorC() == bean ? ls.getConnectC() : ls.getConnectD()));
            }
            if (connect instanceof TrackSegment) {
                tr = (TrackSegment)connect;
                log.debug("return block {}", (Object)tr.getLayoutBlock().getDisplayName());
                return tr.getLayoutBlock();
            }
        }
        return null;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getFacingBlockBySensor(@Nonnull Sensor sensor, @Nonnull LayoutEditor panel) {
        return this.getFacingBlockByBean(sensor, panel);
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getProtectedBlock(@Nonnull SignalHead signalHead, @CheckForNull LayoutEditor panel) {
        LayoutBlock result = null;
        if (panel != null) {
            String userName = signalHead.getUserName();
            LayoutBlock layoutBlock = result = userName == null ? null : this.getProtectedBlock(userName, panel);
            if (result == null) {
                result = this.getProtectedBlock(signalHead.getSystemName(), panel);
            }
        }
        return result;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getProtectedBlock(@Nonnull String signalName, @Nonnull LayoutEditor panel) {
        TrackSegment tr;
        PositionablePoint pp = panel.getFinder().findPositionablePointByEastBoundSignal(signalName);
        if (pp == null) {
            pp = panel.getFinder().findPositionablePointByWestBoundSignal(signalName);
            if (pp == null) {
                return null;
            }
            tr = pp.getConnect1();
        } else {
            tr = pp.getConnect2();
        }
        if (tr == null) {
            return null;
        }
        return tr.getLayoutBlock();
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getFacingBlock(@Nonnull SignalHead signalHead, @CheckForNull LayoutEditor panel) {
        LayoutBlock result = null;
        if (panel != null) {
            String userName = signalHead.getUserName();
            LayoutBlock layoutBlock = result = userName == null ? null : this.getFacingBlock(userName, panel);
            if (result == null) {
                result = this.getFacingBlock(signalHead.getSystemName(), panel);
            }
        }
        return result;
    }

    @CheckReturnValue
    @CheckForNull
    public LayoutBlock getFacingBlock(@Nonnull String signalName, @Nonnull LayoutEditor panel) {
        TrackSegment tr;
        PositionablePoint pp = panel.getFinder().findPositionablePointByWestBoundSignal(signalName);
        if (pp == null) {
            pp = panel.getFinder().findPositionablePointByWestBoundSignal(signalName);
            if (pp == null) {
                return null;
            }
            tr = pp.getConnect1();
        } else {
            tr = pp.getConnect2();
        }
        if (tr == null) {
            return null;
        }
        return tr.getLayoutBlock();
    }

    public boolean warn() {
        return this.warnConnectivity;
    }

    public void turnOffWarning() {
        this.warnConnectivity = false;
    }

    public boolean isAdvancedRoutingEnabled() {
        return this.enableAdvancedRouting;
    }

    public void enableAdvancedRouting(boolean boo) {
        if (boo == this.enableAdvancedRouting) {
            return;
        }
        this.enableAdvancedRouting = boo;
        if (boo && this.initialized) {
            this.initializeLayoutBlockRouting();
        }
        this.firePropertyChange(PROPERTY_ADVANCED_ROUTING_ENABLED, !this.enableAdvancedRouting, this.enableAdvancedRouting);
    }

    private void initializeLayoutBlockRouting() {
        if (!this.enableAdvancedRouting || !this.initialized) {
            log.debug("initializeLayoutBlockRouting immediate return due to {} {}", (Object)this.enableAdvancedRouting, (Object)this.initialized);
            return;
        }
        this.firstRoutingChange = System.nanoTime();
        Enumeration en = this._tsys.elements();
        while (en.hasMoreElements()) {
            ((LayoutBlock)en.nextElement()).initializeLayoutBlockRouting();
        }
    }

    @Nonnull
    public LayoutBlockConnectivityTools getLayoutBlockConnectivityTools() {
        return this.lbct;
    }

    void setLastRoutingChange() {
        log.debug("setLastRoutingChange");
        this.lastRoutingChange = System.nanoTime();
        this.stabilised = false;
        this.setRoutingStabilised();
    }

    private void setRoutingStabilised() {
        if (this.checking) {
            return;
        }
        log.debug("routing table change has been initiated");
        this.checking = true;
        if (this.namedStabilisedIndicator != null) {
            try {
                this.namedStabilisedIndicator.getBean().setState(4);
            }
            catch (JmriException ex) {
                log.debug("Error setting stability indicator sensor");
            }
        }
        Runnable r = () -> {
            try {
                this.firePropertyChange(PROPERTY_TOPOLOGY, true, false);
                long oldvalue = this.lastRoutingChange;
                while (!this.stabilised) {
                    Thread.sleep(2000L);
                    if (oldvalue == this.lastRoutingChange) {
                        log.debug("routing table has now been stable for 2 seconds");
                        this.checking = false;
                        this.stabilised = true;
                        ThreadingUtil.runOnLayoutEventually(() -> this.firePropertyChange(PROPERTY_TOPOLOGY, false, true));
                        if (this.namedStabilisedIndicator != null) {
                            ThreadingUtil.runOnLayoutEventually(() -> {
                                log.debug("Setting StabilisedIndicator Sensor {} ACTIVE", (Object)this.namedStabilisedIndicator.getBean().getDisplayName());
                                try {
                                    this.namedStabilisedIndicator.getBean().setState(2);
                                }
                                catch (JmriException ex) {
                                    log.debug("Error setting stability indicator sensor");
                                }
                            });
                        } else {
                            log.debug("Stable, no sensor to set");
                        }
                    } else {
                        long seconds = (long)((double)(this.lastRoutingChange - this.firstRoutingChange) / 1.0E9);
                        log.debug("routing table not stable after {} in {}", (Object)String.format("%d:%02d:%02d", seconds / 3600L, seconds / 60L % 60L, seconds % 60L), (Object)Thread.currentThread().getName());
                    }
                    oldvalue = this.lastRoutingChange;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.checking = false;
            }
        };
        this.thr = ThreadingUtil.newThread(r, "Routing stabilising timer");
        this.thr.start();
    }

    public void setStabilisedSensor(@Nonnull String pName) throws JmriException {
        if (InstanceManager.getNullableDefault(SensorManager.class) != null) {
            try {
                Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(pName);
                this.namedStabilisedIndicator = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, sensor);
                try {
                    if (this.stabilised) {
                        sensor.setState(2);
                    }
                    sensor.setState(4);
                }
                catch (JmriException ex) {
                    log.error("Error setting stablilty indicator sensor");
                }
            }
            catch (IllegalArgumentException ex) {
                log.error("Sensor '{}' not available", (Object)pName);
                throw new JmriException("Sensor '" + pName + "' not available");
            }
        } else {
            log.error("No SensorManager for this protocol");
            throw new JmriException("No Sensor Manager Found");
        }
    }

    public Sensor getStabilisedSensor() {
        if (this.namedStabilisedIndicator == null) {
            return null;
        }
        return this.namedStabilisedIndicator.getBean();
    }

    @CheckReturnValue
    @CheckForNull
    public NamedBeanHandle<Sensor> getNamedStabilisedSensor() {
        return this.namedStabilisedIndicator;
    }

    public boolean routingStablised() {
        return this.stabilised;
    }

    public long getLastRoutingChange() {
        return this.lastRoutingChange;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameLayoutBlocks" : "BeanNameLayoutBlock");
    }

    @Override
    public Class<LayoutBlock> getNamedBeanClass() {
        return LayoutBlock.class;
    }

    @Nonnull
    public List<LayoutBlock> getLayoutBlocksOccupiedByRosterEntry(@Nonnull RosterEntry re) {
        ArrayList<LayoutBlock> result = new ArrayList<LayoutBlock>();
        BlockManager bm = InstanceManager.getDefault(BlockManager.class);
        List<Block> blockList = bm.getBlocksOccupiedByRosterEntry(re);
        for (Block block : blockList) {
            LayoutBlock lb;
            String uname = block.getUserName();
            if (uname == null || (lb = (LayoutBlock)this.getByUserName(uname)) == null) continue;
            result.add(lb);
        }
        return result;
    }

    @Override
    public void dispose() {
        InstanceManager.sensorManagerInstance().removeVetoableChangeListener(this);
        InstanceManager.memoryManagerInstance().removeVetoableChangeListener(this);
        super.dispose();
    }
}

