/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jmri.BeanSetting;
import jmri.Path;
import jmri.Turnout;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutModels;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurnoutView;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.PositionablePointView;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LayoutEditorAuxTools {
    private final LayoutModels models;
    private final List<LayoutConnectivity> cList = new ArrayList<LayoutConnectivity>();
    private boolean blockConnectivityChanged = false;
    private boolean initialized = false;
    private static final Logger log = LoggerFactory.getLogger(LayoutEditorAuxTools.class);

    public LayoutEditorAuxTools(LayoutModels theModels) {
        this.models = theModels;
    }

    public void setBlockConnectivityChanged() {
        this.blockConnectivityChanged = true;
    }

    public List<LayoutConnectivity> getConnectivityList(LayoutBlock blk) {
        if (!this.initialized) {
            this.initializeBlockConnectivity();
        }
        if (this.blockConnectivityChanged) {
            this.updateBlockConnectivity();
        }
        ArrayList<LayoutConnectivity> retList = new ArrayList<LayoutConnectivity>();
        for (LayoutConnectivity lc : this.cList) {
            if (lc.getBlock1() != blk && lc.getBlock2() != blk) continue;
            retList.add(lc);
        }
        return retList;
    }

    public void initializeBlockConnectivity() {
        this.cList.clear();
        List<LayoutConnectivity> lcs = null;
        for (LayoutTrackView ltv : this.models.getLayoutTrackViews()) {
            if (!(ltv instanceof PositionablePointView) && !(ltv instanceof TrackSegmentView) && !(ltv instanceof LayoutTurnoutView)) continue;
            lcs = ltv.getLayoutConnectivity();
            this.cList.addAll(lcs);
        }
        this.initialized = true;
    }

    private void updateBlockConnectivity() {
        int sz = this.cList.size();
        boolean[] found = new boolean[sz];
        Arrays.fill(found, false);
        List<LayoutConnectivity> lcs = null;
        for (PositionablePoint p : this.models.getPositionablePoints()) {
            lcs = p.getLayoutConnectivity();
            for (LayoutConnectivity lc : lcs) {
                this.checkConnectivity(lc, found);
            }
        }
        for (TrackSegment ts : this.models.getTrackSegments()) {
            lcs = ts.getLayoutConnectivity();
            for (LayoutConnectivity lc : lcs) {
                this.checkConnectivity(lc, found);
            }
        }
        for (LayoutTurnout lt : this.models.getLayoutTurnouts()) {
            lcs = lt.getLayoutConnectivity();
            for (LayoutConnectivity lc : lcs) {
                this.checkConnectivity(lc, found);
            }
        }
        for (LayoutSlip ls : this.models.getLayoutSlips()) {
            lcs = ls.getLayoutConnectivity();
            for (LayoutConnectivity lc : lcs) {
                this.checkConnectivity(lc, found);
            }
        }
        for (int i = sz - 1; i >= 0; --i) {
            if (found[i]) continue;
            this.cList.remove(i);
        }
        this.blockConnectivityChanged = false;
    }

    private void checkConnectivity(LayoutConnectivity c, boolean[] found) {
        LayoutBlock blk1 = c.getBlock1();
        LayoutBlock blk2 = c.getBlock2();
        int dir = c.getDirection();
        int rDir = c.getReverseDirection();
        TrackSegment track = c.getTrackSegment();
        LayoutTrack connected = c.getConnectedObject();
        HitPointType type = c.getConnectedType();
        LayoutTurnout xOver = c.getXover();
        int xOverType = c.getXoverBoundaryType();
        for (int i = 0; i < this.cList.size(); ++i) {
            LayoutConnectivity lc = this.cList.get(i);
            if (xOver == null) {
                if (blk1 != lc.getBlock1() || blk2 != lc.getBlock2() || track != lc.getTrackSegment() || connected != lc.getConnectedObject() || type != lc.getConnectedType() || dir != lc.getDirection()) continue;
                found[i] = true;
                break;
            }
            if (xOver != lc.getXover() || xOverType != lc.getXoverBoundaryType()) continue;
            if (blk1 == lc.getBlock1() && blk2 == lc.getBlock2() && dir == lc.getDirection()) {
                found[i] = true;
                break;
            }
            if (blk2 != lc.getBlock1() || blk1 != lc.getBlock2() || rDir != lc.getDirection()) continue;
            found[i] = true;
            break;
        }
        if (this.cList.contains(c)) {
            log.debug("checkConnectivity: Duplicate connection: '{}'", (Object)c);
        } else {
            this.cList.add(c);
        }
    }

    public void addBeanSettings(Path p, LayoutConnectivity lc, LayoutBlock layoutBlock) {
        p.clearSettings();
        LayoutTrack curConnection = null;
        LayoutTrack prevConnection = null;
        HitPointType typeCurConnection = HitPointType.NONE;
        BeanSetting bs = null;
        LayoutTurnout lt = null;
        if (lc.getBlock1() == layoutBlock) {
            curConnection = lc.getTrackSegment();
            if (curConnection != null) {
                prevConnection = lc.getConnectedObject();
                typeCurConnection = HitPointType.TRACK;
                if ((lc.getConnectedType() == HitPointType.TURNOUT_B || lc.getConnectedType() == HitPointType.TURNOUT_C) && ((LayoutTurnout)prevConnection).getTurnoutType() != LayoutTurnout.TurnoutType.NONE && LayoutTurnout.hasEnteringSingleTrack(((LayoutTurnout)prevConnection).getTurnoutType())) {
                    Turnout ltxto;
                    LayoutTurnout ltx = (LayoutTurnout)prevConnection;
                    if (lc.getConnectedType() == HitPointType.TURNOUT_B) {
                        ltxto = ltx.getTurnout();
                        if (ltxto != null) {
                            bs = new BeanSetting(ltxto, ltx.getTurnoutName(), ltx.getContinuingSense());
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnout (A): LTO = {}, blk = {}", (Object)ltx.getName(), (Object)ltx.getLayoutBlock().getDisplayName());
                        }
                    } else if (lc.getConnectedType() == HitPointType.TURNOUT_C) {
                        ltxto = ltx.getTurnout();
                        if (ltxto != null) {
                            bs = ltx.getContinuingSense() == 2 ? new BeanSetting(ltxto, ltx.getTurnoutName(), 4) : new BeanSetting(ltxto, ltx.getTurnoutName(), 2);
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnout (B): LTO = {}, blk = {}", (Object)ltx.getName(), (Object)ltx.getLayoutBlock().getDisplayName());
                        }
                    } else {
                        log.warn("Did not decode lc.getConnectedType() of {}", (Object)lc.getConnectedType());
                    }
                } else if (HitPointType.isTurnoutHitType(lc.getConnectedType()) && (((LayoutTurnout)prevConnection).getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER || ((LayoutTurnout)prevConnection).getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER)) {
                    LayoutTurnout ltz = (LayoutTurnout)prevConnection;
                    if (ltz.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER && (lc.getConnectedType() == HitPointType.TURNOUT_B || lc.getConnectedType() == HitPointType.TURNOUT_D) || ltz.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER && (lc.getConnectedType() == HitPointType.TURNOUT_A || lc.getConnectedType() == HitPointType.TURNOUT_C)) {
                        Turnout ltzto = ltz.getTurnout();
                        if (ltzto != null) {
                            bs = new BeanSetting(ltzto, ltz.getTurnoutName(), 2);
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnout (C): LTO = {}, blk = {}, TO type = {}, conn type = {}", new Object[]{ltz.getName(), ltz.getLayoutBlock().getDisplayName(), ltz.getTurnoutType(), lc.getConnectedType()});
                        }
                    }
                } else if (HitPointType.isSlipHitType(lc.getConnectedType())) {
                    LayoutSlip lsz = (LayoutSlip)prevConnection;
                    if (lsz.getSlipType() == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                        Turnout lsztob;
                        Turnout lszto;
                        if (lc.getConnectedType() == HitPointType.SLIP_C) {
                            lszto = lsz.getTurnout();
                            if (lszto != null) {
                                bs = new BeanSetting(lszto, lsz.getTurnoutName(), lsz.getTurnoutState(2));
                                p.addSetting(bs);
                            } else {
                                log.error("No assigned turnout (D): LTO = {}, blk = {}", (Object)lsz.getName(), (Object)lsz.getLayoutBlock().getDisplayName());
                            }
                            lsztob = lsz.getTurnoutB();
                            if (lsztob != null) {
                                bs = new BeanSetting(lsztob, lsz.getTurnoutBName(), lsz.getTurnoutBState(2));
                                p.addSetting(bs);
                            } else {
                                log.error("No assigned turnoutB (E): LTO = {}, blk = {}", (Object)lsz.getName(), (Object)lsz.getLayoutBlock().getDisplayName());
                            }
                        } else if (lc.getConnectedType() == HitPointType.SLIP_B) {
                            lszto = lsz.getTurnout();
                            if (lszto != null) {
                                bs = new BeanSetting(lszto, lsz.getTurnoutName(), lsz.getTurnoutState(4));
                                p.addSetting(bs);
                            } else {
                                log.error("No assigned turnout (F): LTO = {}, blk = {}", (Object)lsz.getName(), (Object)lsz.getLayoutBlock().getDisplayName());
                            }
                            lsztob = lsz.getTurnoutB();
                            if (lsztob != null) {
                                bs = new BeanSetting(lsztob, lsz.getTurnoutBName(), lsz.getTurnoutBState(4));
                                p.addSetting(bs);
                            } else {
                                log.error("No assigned turnoutB (G): LTO = {}, blk = {}", (Object)lsz.getName(), (Object)lsz.getLayoutBlock().getDisplayName());
                            }
                        } else if (lc.getConnectedType() == HitPointType.SLIP_A) {
                            log.debug("At connection A of a single slip which could go in two different directions");
                        } else if (lc.getConnectedType() == HitPointType.SLIP_D) {
                            log.debug("At connection D of a single slip which could go in two different directions");
                        }
                    } else if (lc.getConnectedType() == HitPointType.SLIP_A) {
                        log.debug("At connection A of a double slip which could go in two different directions");
                    } else if (lc.getConnectedType() == HitPointType.SLIP_B) {
                        log.debug("At connection B of a double slip which could go in two different directions");
                    } else if (lc.getConnectedType() == HitPointType.SLIP_C) {
                        log.debug("At connection C of a double slip which could go in two different directions");
                    } else if (lc.getConnectedType() == HitPointType.SLIP_D) {
                        log.debug("At connection D of a double slip which could go in two different directions");
                    } else {
                        log.info("At a double slip we could go in two different directions");
                    }
                }
            } else {
                lt = lc.getXover();
                prevConnection = lt;
                if (lt != null && lt.getTurnout() != null) {
                    int type = lc.getXoverBoundaryType();
                    if (lt.getTurnout() != null) {
                        if (type == 1) {
                            bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                            curConnection = lt.getConnectA();
                        } else if (type == 2) {
                            bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                            curConnection = lt.getConnectC();
                        } else if (type == 3) {
                            bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 4);
                            curConnection = lt.getConnectA();
                        } else if (type == 4) {
                            bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 4);
                            curConnection = lt.getConnectB();
                        } else {
                            log.warn("failed to decode lc.getXoverBoundaryType() of {} (A)", (Object)lc.getXoverBoundaryType());
                        }
                    }
                    typeCurConnection = HitPointType.TRACK;
                    if (bs != null) {
                        p.addSetting(bs);
                    } else {
                        log.error("No assigned turnout (H): LTO = {}, blk = {}, type = {}", new Object[]{lt.getName(), lt.getLayoutBlock().getDisplayName(), type});
                    }
                }
            }
        } else if (lc.getXover() != null) {
            lt = lc.getXover();
            if (lt != null && lt.getTurnout() != null) {
                int type = lc.getXoverBoundaryType();
                if (lt.getTurnout() != null) {
                    if (type == 1) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                        curConnection = lt.getConnectB();
                    } else if (type == 2) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                        curConnection = lt.getConnectD();
                    } else if (type == 3) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 4);
                        curConnection = lt.getConnectC();
                    } else if (type == 4) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 4);
                        curConnection = lt.getConnectD();
                    } else {
                        log.warn("failed to decode lc.getXoverBoundaryType() of {} (B)", (Object)lc.getXoverBoundaryType());
                    }
                }
                typeCurConnection = HitPointType.TRACK;
                if (bs != null) {
                    p.addSetting(bs);
                } else {
                    log.error("No assigned turnout (I): LTO = {}, blk = {}, type = {}", new Object[]{lt.getName(), lt.getLayoutBlock().getDisplayName(), type});
                }
            }
        } else if (lc.getConnectedObject() != null) {
            curConnection = lc.getConnectedObject();
            prevConnection = lc.getTrackSegment();
            typeCurConnection = lc.getConnectedType();
            if (HitPointType.isTurnoutHitType(typeCurConnection)) {
                LayoutTurnout.TurnoutType turnoutType = ((LayoutTurnout)curConnection).getTurnoutType();
                if (LayoutTurnout.hasEnteringDoubleTrack(turnoutType)) {
                    if (turnoutType == LayoutTurnout.TurnoutType.DOUBLE_XOVER || turnoutType == LayoutTurnout.TurnoutType.RH_XOVER && (typeCurConnection == HitPointType.TURNOUT_A || typeCurConnection == HitPointType.TURNOUT_C) || turnoutType == LayoutTurnout.TurnoutType.LH_XOVER && (typeCurConnection == HitPointType.TURNOUT_B || typeCurConnection == HitPointType.TURNOUT_D)) {
                        curConnection = null;
                    } else {
                        if (((LayoutTurnout)curConnection).getTurnout() != null) {
                            bs = new BeanSetting(((LayoutTurnout)curConnection).getTurnout(), ((LayoutTurnout)curConnection).getTurnoutName(), 2);
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnout (J): LTO = {}, blk = {}", (Object)((LayoutTurnout)curConnection).getName(), (Object)((LayoutTurnout)curConnection).getLayoutBlock().getDisplayName());
                        }
                        prevConnection = curConnection;
                        curConnection = typeCurConnection == HitPointType.TURNOUT_A ? ((LayoutTurnout)curConnection).getConnectB() : (typeCurConnection == HitPointType.TURNOUT_B ? ((LayoutTurnout)curConnection).getConnectA() : (typeCurConnection == HitPointType.TURNOUT_C ? ((LayoutTurnout)curConnection).getConnectD() : ((LayoutTurnout)curConnection).getConnectC()));
                        typeCurConnection = HitPointType.TRACK;
                    }
                } else if (typeCurConnection == HitPointType.TURNOUT_A) {
                    log.debug("At connection A of a turnout which could go in two different directions");
                    curConnection = null;
                } else if (typeCurConnection == HitPointType.TURNOUT_B) {
                    if (((LayoutTurnout)curConnection).getTurnout() != null) {
                        bs = ((LayoutTurnout)curConnection).getContinuingSense() == 2 ? new BeanSetting(((LayoutTurnout)curConnection).getTurnout(), ((LayoutTurnout)curConnection).getTurnoutName(), 2) : new BeanSetting(((LayoutTurnout)curConnection).getTurnout(), ((LayoutTurnout)curConnection).getTurnoutName(), 4);
                        p.addSetting(bs);
                    } else {
                        log.error("No assigned turnout (K): LTO = {}, blk = {}", (Object)((LayoutTurnout)curConnection).getName(), (Object)((LayoutTurnout)curConnection).getLayoutBlock().getDisplayName());
                    }
                    prevConnection = curConnection;
                    curConnection = ((LayoutTurnout)curConnection).getConnectA();
                    typeCurConnection = HitPointType.TRACK;
                } else if (typeCurConnection == HitPointType.TURNOUT_C) {
                    if (((LayoutTurnout)curConnection).getTurnout() != null) {
                        bs = ((LayoutTurnout)curConnection).getContinuingSense() == 2 ? new BeanSetting(((LayoutTurnout)curConnection).getTurnout(), ((LayoutTurnout)curConnection).getTurnoutName(), 4) : new BeanSetting(((LayoutTurnout)curConnection).getTurnout(), ((LayoutTurnout)curConnection).getTurnoutName(), 2);
                        p.addSetting(bs);
                    } else {
                        log.error("No assigned turnout (L): LTO = {}, blk = {}", (Object)((LayoutTurnout)curConnection).getName(), (Object)((LayoutTurnout)curConnection).getLayoutBlock().getDisplayName());
                    }
                    prevConnection = curConnection;
                    curConnection = ((LayoutTurnout)curConnection).getConnectA();
                    typeCurConnection = HitPointType.TRACK;
                }
            } else if (typeCurConnection == HitPointType.LEVEL_XING_A) {
                prevConnection = curConnection;
                curConnection = ((LevelXing)curConnection).getConnectC();
                typeCurConnection = HitPointType.TRACK;
            } else if (typeCurConnection == HitPointType.LEVEL_XING_C) {
                prevConnection = curConnection;
                curConnection = ((LevelXing)curConnection).getConnectA();
                typeCurConnection = HitPointType.TRACK;
            } else if (typeCurConnection == HitPointType.LEVEL_XING_B) {
                prevConnection = curConnection;
                curConnection = ((LevelXing)curConnection).getConnectD();
                typeCurConnection = HitPointType.TRACK;
            } else if (typeCurConnection == HitPointType.LEVEL_XING_D) {
                prevConnection = curConnection;
                curConnection = ((LevelXing)curConnection).getConnectB();
                typeCurConnection = HitPointType.TRACK;
            }
        } else {
            lt = lc.getXover();
            prevConnection = lt;
            if (lt != null && lt.getTurnout() != null) {
                int type = lc.getXoverBoundaryType();
                if (lt.getTurnout() != null) {
                    if (type == 1) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                        curConnection = lt.getConnectB();
                    } else if (type == 2) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                        curConnection = lt.getConnectD();
                    } else if (type == 3) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 4);
                        curConnection = lt.getConnectC();
                    } else if (type == 4) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 4);
                        curConnection = lt.getConnectD();
                    }
                }
                typeCurConnection = HitPointType.TRACK;
                if (bs != null) {
                    p.addSetting(bs);
                } else {
                    log.error("No assigned turnout (Q): LTO = {}, blk = {}", (Object)lt.getName(), (Object)lt.getLayoutBlock().getDisplayName());
                }
            }
        }
        while (curConnection != null) {
            if (typeCurConnection == HitPointType.TRACK) {
                LayoutTrack curTS = curConnection;
                if (((TrackSegment)curTS).getLayoutBlock() != layoutBlock) {
                    curConnection = null;
                    continue;
                }
                if (((TrackSegment)curTS).getConnect1() == prevConnection) {
                    prevConnection = curConnection;
                    typeCurConnection = ((TrackSegment)curTS).getType2();
                    curConnection = ((TrackSegment)curTS).getConnect2();
                } else {
                    prevConnection = curConnection;
                    typeCurConnection = ((TrackSegment)curTS).getType1();
                    curConnection = ((TrackSegment)curTS).getConnect1();
                }
                if (typeCurConnection != HitPointType.POS_POINT) continue;
                PositionablePoint pt = (PositionablePoint)curConnection;
                if (pt.getType() == PositionablePoint.PointType.END_BUMPER) {
                    curConnection = null;
                    continue;
                }
                TrackSegment track = null;
                track = pt.getConnect1() == prevConnection ? pt.getConnect2() : pt.getConnect1();
                if (track == null || track.getLayoutBlock() != layoutBlock) {
                    curConnection = null;
                    continue;
                }
                prevConnection = curConnection;
                curConnection = track;
                typeCurConnection = HitPointType.TRACK;
                continue;
            }
            if (HitPointType.isTurnoutHitType(typeCurConnection)) {
                lt = (LayoutTurnout)curConnection;
                if (lt.hasEnteringSingleTrack()) {
                    if (lt.getLayoutBlock() != layoutBlock) {
                        curConnection = null;
                        continue;
                    }
                    if (typeCurConnection == HitPointType.TURNOUT_A) {
                        curConnection = null;
                        continue;
                    }
                    if (typeCurConnection == HitPointType.TURNOUT_B) {
                        if (lt.getTurnout() != null) {
                            bs = lt.getContinuingSense() == 2 ? new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2) : new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 4);
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnout (R): LTO = {}, blk = {}", (Object)lt.getName(), (Object)lt.getLayoutBlock().getDisplayName());
                        }
                        if (lt.getLayoutBlock() != layoutBlock) {
                            curConnection = null;
                            continue;
                        }
                        prevConnection = curConnection;
                        curConnection = lt.getConnectA();
                        typeCurConnection = HitPointType.TRACK;
                        continue;
                    }
                    if (typeCurConnection != HitPointType.TURNOUT_C) continue;
                    if (lt.getTurnout() != null) {
                        bs = lt.getContinuingSense() == 2 ? new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 4) : new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                        p.addSetting(bs);
                    } else {
                        log.error("No assigned turnout (S): LTO = {}, blk = {}", (Object)lt.getName(), (Object)lt.getLayoutBlock().getDisplayName());
                    }
                    if (lt.getLayoutBlock() != layoutBlock) {
                        curConnection = null;
                        continue;
                    }
                    prevConnection = curConnection;
                    curConnection = lt.getConnectA();
                    typeCurConnection = HitPointType.TRACK;
                    continue;
                }
                if (lt.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
                    curConnection = null;
                    continue;
                }
                if (lt.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                    if (typeCurConnection == HitPointType.TURNOUT_A || typeCurConnection == HitPointType.TURNOUT_C) {
                        curConnection = null;
                        continue;
                    }
                    if (typeCurConnection == HitPointType.TURNOUT_B) {
                        if (lt.getLayoutBlockB() != layoutBlock) break;
                        if (lt.getTurnout() != null) {
                            bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnout (T): LTO = {}, blk = {}", (Object)lt.getName(), (Object)lt.getLayoutBlock().getDisplayName());
                        }
                        if (lt.getLayoutBlock() != layoutBlock) {
                            curConnection = null;
                            continue;
                        }
                        prevConnection = curConnection;
                        curConnection = lt.getConnectA();
                        typeCurConnection = HitPointType.TRACK;
                        continue;
                    }
                    if (lt.getLayoutBlockD() != layoutBlock) break;
                    if (lt.getTurnout() != null) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                        p.addSetting(bs);
                    } else {
                        log.error("No assigned turnout (U): LTO = {}, blk = {}", (Object)lt.getName(), (Object)lt.getLayoutBlock().getDisplayName());
                    }
                    if (lt.getLayoutBlockC() != layoutBlock) {
                        curConnection = null;
                        continue;
                    }
                    prevConnection = curConnection;
                    curConnection = lt.getConnectC();
                    typeCurConnection = HitPointType.TRACK;
                    continue;
                }
                if (lt.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER) continue;
                if (typeCurConnection == HitPointType.TURNOUT_B || typeCurConnection == HitPointType.TURNOUT_D) {
                    curConnection = null;
                    continue;
                }
                if (typeCurConnection == HitPointType.TURNOUT_A) {
                    if (lt.getLayoutBlock() != layoutBlock) break;
                    if (lt.getTurnout() != null) {
                        bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                        p.addSetting(bs);
                    } else {
                        log.error("No assigned turnout (V): LTO = {}, blk = {}", (Object)lt.getName(), (Object)lt.getLayoutBlock().getDisplayName());
                    }
                    if (lt.getLayoutBlockB() != layoutBlock) {
                        curConnection = null;
                        continue;
                    }
                    prevConnection = curConnection;
                    curConnection = lt.getConnectB();
                    typeCurConnection = HitPointType.TRACK;
                    continue;
                }
                if (lt.getLayoutBlockC() != layoutBlock) break;
                if (lt.getTurnout() != null) {
                    bs = new BeanSetting(lt.getTurnout(), lt.getTurnoutName(), 2);
                    p.addSetting(bs);
                } else {
                    log.error("No assigned turnout (W): LTO = {}, blk = {}", (Object)lt.getName(), (Object)lt.getLayoutBlock().getDisplayName());
                }
                if (lt.getLayoutBlockD() != layoutBlock) {
                    curConnection = null;
                    continue;
                }
                prevConnection = curConnection;
                curConnection = lt.getConnectD();
                typeCurConnection = HitPointType.TRACK;
                continue;
            }
            if (typeCurConnection == HitPointType.LEVEL_XING_A) {
                if (((LevelXing)curConnection).getLayoutBlockAC() != layoutBlock) {
                    curConnection = null;
                    continue;
                }
                prevConnection = curConnection;
                curConnection = ((LevelXing)curConnection).getConnectC();
                typeCurConnection = HitPointType.TRACK;
                continue;
            }
            if (typeCurConnection == HitPointType.LEVEL_XING_B) {
                if (((LevelXing)curConnection).getLayoutBlockBD() != layoutBlock) {
                    curConnection = null;
                    continue;
                }
                prevConnection = curConnection;
                curConnection = ((LevelXing)curConnection).getConnectD();
                typeCurConnection = HitPointType.TRACK;
                continue;
            }
            if (typeCurConnection == HitPointType.LEVEL_XING_C) {
                if (((LevelXing)curConnection).getLayoutBlockAC() != layoutBlock) {
                    curConnection = null;
                    continue;
                }
                prevConnection = curConnection;
                curConnection = ((LevelXing)curConnection).getConnectA();
                typeCurConnection = HitPointType.TRACK;
                continue;
            }
            if (typeCurConnection == HitPointType.LEVEL_XING_D) {
                if (((LevelXing)curConnection).getLayoutBlockBD() != layoutBlock) {
                    curConnection = null;
                    continue;
                }
                prevConnection = curConnection;
                curConnection = ((LevelXing)curConnection).getConnectB();
                typeCurConnection = HitPointType.TRACK;
                continue;
            }
            if (HitPointType.isSlipHitType(typeCurConnection)) {
                LayoutSlip ls = (LayoutSlip)curConnection;
                if (ls.getLayoutBlock() != layoutBlock) {
                    curConnection = null;
                    continue;
                }
                if (ls.getSlipType() == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                    if (typeCurConnection == HitPointType.SLIP_C) {
                        if (ls.getTurnout() != null) {
                            bs = new BeanSetting(ls.getTurnout(), ls.getTurnoutName(), ls.getTurnoutState(2));
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnout (X): LTO = {}, blk = {}", (Object)ls.getName(), (Object)ls.getLayoutBlock().getDisplayName());
                        }
                        if (ls.getTurnoutB() != null) {
                            bs = new BeanSetting(ls.getTurnoutB(), ls.getTurnoutBName(), ls.getTurnoutBState(2));
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnoutB (Y): LTO = {}, blk = {}", (Object)ls.getName(), (Object)ls.getLayoutBlock().getDisplayName());
                        }
                        prevConnection = curConnection;
                        curConnection = ((LayoutSlip)curConnection).getConnectC();
                        typeCurConnection = HitPointType.TRACK;
                        continue;
                    }
                    if (typeCurConnection == HitPointType.SLIP_B) {
                        if (ls.getTurnout() != null) {
                            bs = new BeanSetting(ls.getTurnout(), ls.getTurnoutName(), ls.getTurnoutState(4));
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnout (Z): LTO = {}, blk = {}", (Object)ls.getName(), (Object)ls.getLayoutBlock().getDisplayName());
                        }
                        if (ls.getTurnoutB() != null) {
                            bs = new BeanSetting(ls.getTurnoutB(), ls.getTurnoutBName(), ls.getTurnoutBState(4));
                            p.addSetting(bs);
                        } else {
                            log.error("No assigned turnoutB (1): LTO = {}, blk = {}", (Object)ls.getName(), (Object)ls.getLayoutBlock().getDisplayName());
                        }
                        prevConnection = curConnection;
                        curConnection = ((LayoutSlip)curConnection).getConnectB();
                        typeCurConnection = HitPointType.TRACK;
                        continue;
                    }
                    curConnection = null;
                    continue;
                }
                curConnection = null;
                continue;
            }
            if (HitPointType.isTurntableRayHitType(typeCurConnection)) {
                if (log.isDebugEnabled()) {
                    log.debug("Layout Block: {}, found track type: {}, to Block: {}, is potentially assigned to turntable ray", new Object[]{layoutBlock.getDisplayName(), typeCurConnection, p.getBlock().getDisplayName()});
                }
                curConnection = null;
                continue;
            }
            log.error("Layout Block: {} found unknown track type: {} to Block: {}", new Object[]{layoutBlock.getDisplayName(), typeCurConnection, p.getBlock().getDisplayName()});
            break;
        }
    }
}

