/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTrackEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LayoutEditorChecks {
    private final LayoutEditor layoutEditor;
    private final JMenu checkMenu = new JMenu(Bundle.getMessage("CheckMenuTitle"));
    private final JMenuItem checkInProgressMenuItem = new JMenuItem(Bundle.getMessage("CheckInProgressMenuItemTitle"));
    private final JMenuItem checkNoResultsMenuItem = new JMenuItem(Bundle.getMessage("CheckNoResultsMenuItemTitle"));
    private final JMenu checkUnConnectedTracksMenu = new JMenu(Bundle.getMessage("CheckUnConnectedTracksMenuTitle"));
    private final JMenu checkUnBlockedTracksMenu = new JMenu(Bundle.getMessage("CheckUnBlockedTracksMenuTitle"));
    private final JMenu checkNonContiguousBlocksMenu = new JMenu(Bundle.getMessage("CheckNonContiguousBlocksMenuTitle"));
    private final JMenu checkUnnecessaryAnchorsMenu = new JMenu(Bundle.getMessage("CheckUnnecessaryAnchorsMenuTitle"));
    private final JMenu checkLinearBezierTrackSegmentsMenu = new JMenu(Bundle.getMessage("CheckLinearBezierTrackSegmentsMenuTitle"));
    private final JMenu checkFixedRadiusBezierTrackSegmentsMenu = new JMenu(Bundle.getMessage("CheckFixedRadiusBezierTrackSegmentsMenuTitle"));
    private static final Logger log = LoggerFactory.getLogger(LayoutEditorChecks.class);

    public LayoutEditorChecks(@Nonnull LayoutEditor layoutEditor) {
        this.layoutEditor = layoutEditor;
    }

    protected void setupChecksMenu(@Nonnull JMenu toolsMenu) {
        toolsMenu.add(this.checkMenu);
        this.checkMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuSelected");
                boolean enabled = LayoutEditorChecks.this.layoutEditor.isEditable();
                LayoutEditorChecks.this.checkUnConnectedTracksMenu.setEnabled(enabled);
                LayoutEditorChecks.this.checkUnBlockedTracksMenu.setEnabled(enabled);
                LayoutEditorChecks.this.checkNonContiguousBlocksMenu.setEnabled(enabled);
                LayoutEditorChecks.this.checkUnnecessaryAnchorsMenu.setEnabled(enabled);
                LayoutEditorChecks.this.checkLinearBezierTrackSegmentsMenu.setEnabled(enabled);
                LayoutEditorChecks.this.checkFixedRadiusBezierTrackSegmentsMenu.setEnabled(enabled);
            }

            @Override
            public void menuDeselected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuDeselected");
            }

            @Override
            public void menuCanceled(@Nonnull MenuEvent menuEvent) {
                log.debug("menuCanceled");
            }
        });
        this.checkMenu.setEnabled(this.layoutEditor.isEditable());
        this.checkMenu.setToolTipText(Bundle.getMessage("CheckMenuToolTip"));
        this.checkNoResultsMenuItem.setToolTipText(Bundle.getMessage("CheckNoResultsMenuItemToolTip"));
        this.checkNoResultsMenuItem.setEnabled(false);
        this.checkInProgressMenuItem.setToolTipText(Bundle.getMessage("CheckInProgressMenuItemToolTip"));
        this.checkInProgressMenuItem.setEnabled(false);
        this.checkUnConnectedTracksMenu.setToolTipText(Bundle.getMessage("CheckUnConnectedTracksMenuToolTip"));
        this.checkUnConnectedTracksMenu.add(this.checkInProgressMenuItem);
        this.checkMenu.add(this.checkUnConnectedTracksMenu);
        this.checkUnConnectedTracksMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuSelected");
                LayoutEditorChecks.this.setupCheckUnConnectedTracksMenu();
            }

            @Override
            public void menuDeselected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuDeselected");
            }

            @Override
            public void menuCanceled(@Nonnull MenuEvent menuEvent) {
                log.debug("menuCanceled");
            }
        });
        this.checkUnBlockedTracksMenu.setToolTipText(Bundle.getMessage("CheckUnBlockedTracksMenuToolTip"));
        this.checkUnBlockedTracksMenu.add(this.checkInProgressMenuItem);
        this.checkMenu.add(this.checkUnBlockedTracksMenu);
        this.checkUnBlockedTracksMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuSelected");
                LayoutEditorChecks.this.setupCheckUnBlockedTracksMenu();
            }

            @Override
            public void menuDeselected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuDeselected");
            }

            @Override
            public void menuCanceled(@Nonnull MenuEvent menuEvent) {
                log.debug("menuCanceled");
            }
        });
        this.checkNonContiguousBlocksMenu.setToolTipText(Bundle.getMessage("CheckNonContiguousBlocksMenuToolTip"));
        this.checkNonContiguousBlocksMenu.add(this.checkInProgressMenuItem);
        this.checkMenu.add(this.checkNonContiguousBlocksMenu);
        this.checkNonContiguousBlocksMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuSelected");
                LayoutEditorChecks.this.setupCheckNonContiguousBlocksMenu();
            }

            @Override
            public void menuDeselected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuDeselected");
            }

            @Override
            public void menuCanceled(@Nonnull MenuEvent menuEvent) {
                log.debug("menuCanceled");
            }
        });
        this.checkUnnecessaryAnchorsMenu.setToolTipText(Bundle.getMessage("CheckUnnecessaryAnchorsMenuToolTip"));
        this.checkUnnecessaryAnchorsMenu.add(this.checkInProgressMenuItem);
        this.checkMenu.add(this.checkUnnecessaryAnchorsMenu);
        this.checkUnnecessaryAnchorsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuSelected");
                LayoutEditorChecks.this.setupCheckUnnecessaryAnchorsMenu();
            }

            @Override
            public void menuDeselected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuDeselected");
            }

            @Override
            public void menuCanceled(@Nonnull MenuEvent menuEvent) {
                log.debug("menuCanceled");
            }
        });
        this.checkLinearBezierTrackSegmentsMenu.setToolTipText(Bundle.getMessage("CheckLinearBezierTrackSegmentsMenuToolTip"));
        this.checkLinearBezierTrackSegmentsMenu.add(this.checkInProgressMenuItem);
        this.checkMenu.add(this.checkLinearBezierTrackSegmentsMenu);
        this.checkLinearBezierTrackSegmentsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuSelected");
                LayoutEditorChecks.this.setupCheckLinearBezierTrackSegmentsMenu();
            }

            @Override
            public void menuDeselected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuDeselected");
            }

            @Override
            public void menuCanceled(@Nonnull MenuEvent menuEvent) {
                log.debug("menuCanceled");
            }
        });
        this.checkFixedRadiusBezierTrackSegmentsMenu.setToolTipText(Bundle.getMessage("CheckFixedRadiusBezierTrackSegmentsMenuToolTip"));
        this.checkFixedRadiusBezierTrackSegmentsMenu.add(this.checkInProgressMenuItem);
        this.checkMenu.add(this.checkFixedRadiusBezierTrackSegmentsMenu);
        this.checkFixedRadiusBezierTrackSegmentsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuSelected");
                LayoutEditorChecks.this.setupCheckFixedRadiusBezierTrackSegmentsMenu();
            }

            @Override
            public void menuDeselected(@Nonnull MenuEvent menuEvent) {
                log.debug("menuDeselected");
            }

            @Override
            public void menuCanceled(@Nonnull MenuEvent menuEvent) {
                log.debug("menuCanceled");
            }
        });
    }

    private void setupCheckUnConnectedTracksMenu() {
        log.debug("setupcheckUnConnectedTracksMenu");
        Set<String> checkMarkedMenuItemNamesSet = this.getCheckMarkedMenuItemNames(this.checkUnConnectedTracksMenu);
        this.checkUnConnectedTracksMenu.removeAll();
        this.checkUnConnectedTracksMenu.add(this.checkInProgressMenuItem);
        ArrayList<String> trackNames = new ArrayList<String>();
        for (LayoutTrack layoutTrack : this.layoutEditor.getLayoutTracks()) {
            List<HitPointType> connections = layoutTrack.checkForFreeConnections();
            if (connections.isEmpty()) continue;
            trackNames.add(layoutTrack.getName());
        }
        this.checkUnConnectedTracksMenu.removeAll();
        if (trackNames.size() > 0) {
            for (String trackName : trackNames) {
                JCheckBoxMenuItem jmi = new JCheckBoxMenuItem(trackName);
                this.checkUnConnectedTracksMenu.add(jmi);
                jmi.addActionListener(event -> this.doCheckUnConnectedTracksMenuItem(trackName));
                if (!checkMarkedMenuItemNamesSet.contains(trackName)) continue;
                jmi.setSelected(true);
            }
        } else {
            this.checkUnConnectedTracksMenu.add(this.checkNoResultsMenuItem);
        }
    }

    private void doCheckUnConnectedTracksMenuItem(@Nonnull String menuItemName) {
        log.debug("docheckUnConnectedTracksMenuItem({})", (Object)menuItemName);
        LayoutTrack layoutTrack = this.layoutEditor.getFinder().findObjectByName(menuItemName);
        if (layoutTrack != null) {
            LayoutTrackView layoutTrackView = this.layoutEditor.getLayoutTrackView(layoutTrack);
            Rectangle2D trackBounds = layoutTrackView.getBounds();
            this.layoutEditor.setSelectionRect(trackBounds);
            this.layoutEditor.clearSelectionGroups();
            this.layoutEditor.amendSelectionGroup(layoutTrack);
        } else {
            this.layoutEditor.clearSelectionGroups();
        }
    }

    private void setupCheckUnBlockedTracksMenu() {
        log.debug("setupCheckUnBlockedTracksMenu");
        Set<String> checkMarkedMenuItemNamesSet = this.getCheckMarkedMenuItemNames(this.checkUnBlockedTracksMenu);
        this.checkUnBlockedTracksMenu.removeAll();
        this.checkUnBlockedTracksMenu.add(this.checkInProgressMenuItem);
        ArrayList<String> trackNames = new ArrayList<String>();
        for (LayoutTrack layoutTrack : this.layoutEditor.getLayoutTracks()) {
            if (layoutTrack.checkForUnAssignedBlocks()) continue;
            trackNames.add(layoutTrack.getName());
        }
        this.checkUnBlockedTracksMenu.removeAll();
        if (trackNames.size() > 0) {
            for (String trackName : trackNames) {
                JCheckBoxMenuItem jmi = new JCheckBoxMenuItem(trackName);
                this.checkUnBlockedTracksMenu.add(jmi);
                jmi.addActionListener(event -> this.doCheckUnBlockedTracksMenuItem(trackName));
                if (!checkMarkedMenuItemNamesSet.contains(trackName)) continue;
                jmi.setSelected(true);
            }
        } else {
            this.checkUnBlockedTracksMenu.add(this.checkNoResultsMenuItem);
        }
    }

    private void doCheckUnBlockedTracksMenuItem(@Nonnull String menuItemName) {
        log.debug("doCheckUnBlockedTracksMenuItem({})", (Object)menuItemName);
        LayoutTrack layoutTrack = this.layoutEditor.getFinder().findObjectByName(menuItemName);
        if (layoutTrack != null) {
            LayoutTrackView layoutTrackView = this.layoutEditor.getLayoutTrackView(layoutTrack);
            this.layoutEditor.setSelectionRect(layoutTrackView.getBounds());
            this.layoutEditor.clearSelectionGroups();
            this.layoutEditor.amendSelectionGroup(layoutTrack);
            LayoutTrackEditor.makeTrackEditor(layoutTrack, this.layoutEditor);
        } else {
            this.layoutEditor.clearSelectionGroups();
        }
    }

    private void setupCheckNonContiguousBlocksMenu() {
        log.debug("setupCheckNonContiguousBlocksMenu");
        this.checkNonContiguousBlocksMenu.removeAll();
        this.checkNonContiguousBlocksMenu.add(this.checkInProgressMenuItem);
        HashMap<String, List<Set<String>>> blockNamesToTrackNameSetMaps = new HashMap<String, List<Set<String>>>();
        for (LayoutTrack layoutTrack : this.layoutEditor.getLayoutTracks()) {
            layoutTrack.checkForNonContiguousBlocks(blockNamesToTrackNameSetMaps);
        }
        this.checkNonContiguousBlocksMenu.removeAll();
        for (Map.Entry entry : blockNamesToTrackNameSetMaps.entrySet()) {
            String blockName = (String)entry.getKey();
            List trackNameSets = (List)entry.getValue();
            if (trackNameSets.size() <= 1) continue;
            JMenu jmi = new JMenu(blockName);
            this.checkNonContiguousBlocksMenu.add(jmi);
            int idx = 1;
            for (Set trackNameSet : trackNameSets) {
                JMenuItem subMenuItem = new JMenuItem(Bundle.getMessage("MakeLabel", blockName) + "#" + idx++);
                jmi.add(subMenuItem);
                subMenuItem.addActionListener(event -> this.doCheckNonContiguousBlocksMenuItem(blockName, trackNameSet));
            }
        }
        if (this.checkNonContiguousBlocksMenu.getMenuComponentCount() == 0) {
            this.checkNonContiguousBlocksMenu.add(this.checkNoResultsMenuItem);
        }
    }

    private void doCheckNonContiguousBlocksMenuItem(@Nonnull String blockName, @CheckForNull Set<String> trackNameSet) {
        log.debug("doCheckNonContiguousBlocksMenuItem({})", (Object)blockName);
        if (trackNameSet != null) {
            Rectangle2D bounds = null;
            for (LayoutTrack layoutTrack : this.layoutEditor.getLayoutTracks()) {
                if (!trackNameSet.contains(layoutTrack.getName())) continue;
                LayoutTrackView layoutTrackView = this.layoutEditor.getLayoutTrackView(layoutTrack);
                Rectangle2D trackBounds = layoutTrackView.getBounds();
                if (bounds == null) {
                    bounds = trackBounds.getBounds2D();
                    continue;
                }
                bounds.add(trackBounds);
            }
            this.layoutEditor.setSelectionRect(bounds);
            this.layoutEditor.clearSelectionGroups();
            for (LayoutTrack layoutTrack : this.layoutEditor.getLayoutTracks()) {
                if (!trackNameSet.contains(layoutTrack.getName())) continue;
                this.layoutEditor.amendSelectionGroup(layoutTrack);
            }
        } else {
            this.layoutEditor.setSelectionRect(MathUtil.zeroRectangle2D);
        }
    }

    private void setupCheckUnnecessaryAnchorsMenu() {
        log.debug("setupCheckUnnecessaryAnchorsMenu");
        Set<String> checkMarkedMenuItemNamesSet = this.getCheckMarkedMenuItemNames(this.checkUnBlockedTracksMenu);
        this.checkUnnecessaryAnchorsMenu.removeAll();
        this.checkUnnecessaryAnchorsMenu.add(this.checkInProgressMenuItem);
        ArrayList<PositionablePoint> aatzlts = new ArrayList<PositionablePoint>();
        for (PositionablePoint pp : this.layoutEditor.getPositionablePoints()) {
            double dir2;
            double dir1;
            double diffRAD;
            String blockName2;
            String blockName1;
            if (pp.getType() != PositionablePoint.PointType.ANCHOR) continue;
            TrackSegment ts1 = pp.getConnect1();
            TrackSegment ts2 = pp.getConnect2();
            if (ts1 == null || ts2 == null) continue;
            TrackSegmentView ts1v = this.layoutEditor.getTrackSegmentView(ts1);
            TrackSegmentView ts2v = this.layoutEditor.getTrackSegmentView(ts2);
            if (ts1v.isArc() || ts1v.isCircle() || ts1v.isBezier() || ts2v.isArc() || ts2v.isCircle() || ts2v.isBezier() || !(blockName1 = ts1.getBlockName()).equals(blockName2 = ts2.getBlockName())) continue;
            Rectangle2D bounds1 = ts1v.getBounds();
            double length1 = Math.hypot(bounds1.getWidth(), bounds1.getHeight());
            if (length1 < 1.0) {
                aatzlts.add(pp);
                continue;
            }
            Rectangle2D bounds = ts2v.getBounds();
            double length = Math.hypot(bounds.getWidth(), bounds.getHeight());
            if (length < 1.0) {
                aatzlts.add(pp);
                continue;
            }
            if (ts1.isMainline() != ts2.isMainline()) continue;
            TrackSegmentView tsv1 = this.layoutEditor.getTrackSegmentView(ts1);
            TrackSegmentView tsv2 = this.layoutEditor.getTrackSegmentView(ts2);
            if (tsv1.isHidden() != tsv2.isHidden() || tsv1.hasDecorations() || tsv2.hasDecorations() || !MathUtil.equals(diffRAD = MathUtil.absDiffAngleRAD(dir1 = tsv1.getDirectionRAD(), dir2 = tsv2.getDirectionRAD()), 0.0) && !MathUtil.equals(diffRAD, Math.PI)) continue;
            aatzlts.add(pp);
        }
        this.checkUnnecessaryAnchorsMenu.removeAll();
        for (PositionablePoint pp : aatzlts) {
            String anchorName = pp.getName();
            JMenuItem jmi = new JMenuItem(anchorName);
            this.checkUnnecessaryAnchorsMenu.add(jmi);
            jmi.addActionListener(event -> this.doCheckUnnecessaryAnchorsMenuItem(anchorName));
            if (!checkMarkedMenuItemNamesSet.contains(anchorName)) continue;
            jmi.setSelected(true);
        }
        if (this.checkUnnecessaryAnchorsMenu.getMenuComponentCount() == 0) {
            this.checkUnnecessaryAnchorsMenu.add(this.checkNoResultsMenuItem);
        }
    }

    private void doCheckUnnecessaryAnchorsMenuItem(@Nonnull String anchorName) {
        log.debug("doCheckUnnecessaryAnchorsMenuItem({})", (Object)anchorName);
        LayoutTrack layoutTrack = this.layoutEditor.getFinder().findObjectByName(anchorName);
        if (layoutTrack != null) {
            LayoutTrackView layoutTrackView = this.layoutEditor.getLayoutTrackView(layoutTrack);
            this.layoutEditor.setSelectionRect(layoutTrackView.getBounds());
            this.layoutEditor.clearSelectionGroups();
            this.layoutEditor.amendSelectionGroup(layoutTrack);
            layoutTrackView.showPopup();
        } else {
            this.layoutEditor.clearSelectionGroups();
        }
    }

    private void setupCheckLinearBezierTrackSegmentsMenu() {
        log.debug("setupCheckLinearBezierTrackSegmentsMenu");
        Set<String> checkMarkedMenuItemNamesSet = this.getCheckMarkedMenuItemNames(this.checkLinearBezierTrackSegmentsMenu);
        this.checkLinearBezierTrackSegmentsMenu.removeAll();
        this.checkLinearBezierTrackSegmentsMenu.add(this.checkInProgressMenuItem);
        ArrayList<TrackSegmentView> linearBezierTrackSegmentViews = new ArrayList<TrackSegmentView>();
        for (TrackSegmentView tsv : this.layoutEditor.getTrackSegmentViews()) {
            Point2D end2;
            if (!tsv.isBezier()) continue;
            LayoutTrack c1 = tsv.getConnect1();
            LayoutTrack c2 = tsv.getConnect2();
            if (c1 == null || c2 == null) continue;
            Point2D end1 = this.layoutEditor.getCoords(tsv.getConnect1(), tsv.getType1());
            if (MathUtil.distance(end1, end2 = this.layoutEditor.getCoords(tsv.getConnect2(), tsv.getType2())) <= 4.0) {
                linearBezierTrackSegmentViews.add(tsv);
                continue;
            }
            boolean good = true;
            for (Point2D cp : tsv.getBezierControlPoints()) {
                if (!(Math.abs(MathUtil.distance(end1, end2, cp)) > 1.0)) continue;
                good = false;
                break;
            }
            if (!good) continue;
            linearBezierTrackSegmentViews.add(tsv);
        }
        this.checkLinearBezierTrackSegmentsMenu.removeAll();
        if (linearBezierTrackSegmentViews.size() == 0) {
            this.checkLinearBezierTrackSegmentsMenu.add(this.checkNoResultsMenuItem);
        } else {
            for (TrackSegmentView tsv : linearBezierTrackSegmentViews) {
                String name = tsv.getName();
                JMenuItem jmi = new JMenuItem(name);
                this.checkLinearBezierTrackSegmentsMenu.add(jmi);
                jmi.addActionListener(event -> this.doCheckLinearBezierTrackSegmentsMenuItem(name));
                if (!checkMarkedMenuItemNamesSet.contains(name)) continue;
                jmi.setSelected(true);
            }
        }
    }

    private void doCheckLinearBezierTrackSegmentsMenuItem(@Nonnull String trackSegmentName) {
        log.debug("doCheckLinearBezierTrackSegmentsMenuItem({})", (Object)trackSegmentName);
        LayoutTrack layoutTrack = this.layoutEditor.getFinder().findObjectByName(trackSegmentName);
        if (layoutTrack != null) {
            LayoutTrackView layoutTrackView = this.layoutEditor.getLayoutTrackView(layoutTrack);
            this.layoutEditor.setSelectionRect(layoutTrackView.getBounds());
            this.layoutEditor.clearSelectionGroups();
            this.layoutEditor.amendSelectionGroup(layoutTrack);
            layoutTrackView.showPopup();
        } else {
            this.layoutEditor.clearSelectionGroups();
        }
    }

    private void setupCheckFixedRadiusBezierTrackSegmentsMenu() {
        log.debug("setupCheckFixedRadiusBezierTrackSegmentsMenu");
        Set<String> checkMarkedMenuItemNamesSet = this.getCheckMarkedMenuItemNames(this.checkFixedRadiusBezierTrackSegmentsMenu);
        this.checkFixedRadiusBezierTrackSegmentsMenu.removeAll();
        this.checkFixedRadiusBezierTrackSegmentsMenu.add(this.checkInProgressMenuItem);
        ArrayList<TrackSegmentView> radiusBezierTrackSegmentViews = new ArrayList<TrackSegmentView>();
        for (TrackSegmentView tsv : this.layoutEditor.getTrackSegmentViews()) {
            double r2;
            double r1;
            Point2D op2;
            int cnt;
            Point2D end2;
            Point2D end1;
            double chordLength;
            if (!tsv.isBezier()) continue;
            LayoutTrack c1 = tsv.getConnect1();
            LayoutTrack c2 = tsv.getConnect2();
            if (c1 == null || c2 == null || (chordLength = MathUtil.distance(end1 = this.layoutEditor.getCoords(c1, tsv.getType1()), end2 = this.layoutEditor.getCoords(c2, tsv.getType2()))) <= 4.0 || (cnt = tsv.getNumberOfBezierControlPoints()) <= 0) continue;
            Point2D cp0 = tsv.getBezierControlPoint(0);
            Point2D cpN = tsv.getBezierControlPoint(cnt - 1);
            Point2D op1 = MathUtil.add(end1, MathUtil.orthogonal(MathUtil.subtract(cp0, end1)));
            Point2D ip = MathUtil.intersect(end1, op1, end2, op2 = MathUtil.subtract(end2, MathUtil.orthogonal(MathUtil.subtract(cpN, end2))));
            if (ip == null || !(Math.abs((r1 = MathUtil.distance(ip, end1)) - (r2 = MathUtil.distance(ip, end2))) <= 1.0)) continue;
            double ipSide = Math.signum(MathUtil.distance(end1, end2, ip));
            boolean good = true;
            for (int idx = 0; idx < cnt - 1; ++idx) {
                Point2D cp2;
                Point2D cp1 = tsv.getBezierControlPoint(idx);
                Point2D mp = MathUtil.midPoint(cp1, cp2 = tsv.getBezierControlPoint(idx + 1));
                double rM = MathUtil.distance(ip, mp);
                if (Math.abs(r1 - rM) > 1.0) {
                    good = false;
                    break;
                }
                double cpSide = Math.signum(MathUtil.distance(end1, end2, mp));
                if (!MathUtil.equals(ipSide, cpSide)) continue;
                good = false;
                break;
            }
            if (!good) continue;
            radiusBezierTrackSegmentViews.add(tsv);
        }
        this.checkFixedRadiusBezierTrackSegmentsMenu.removeAll();
        if (radiusBezierTrackSegmentViews.size() == 0) {
            this.checkFixedRadiusBezierTrackSegmentsMenu.add(this.checkNoResultsMenuItem);
        } else {
            for (TrackSegmentView tsv : radiusBezierTrackSegmentViews) {
                String name = tsv.getName();
                JMenuItem jmi = new JMenuItem(name);
                this.checkFixedRadiusBezierTrackSegmentsMenu.add(jmi);
                jmi.addActionListener(event -> this.doCheckFixedRadiusBezierTrackSegmentsMenuItem(name));
                if (!checkMarkedMenuItemNamesSet.contains(name)) continue;
                jmi.setSelected(true);
            }
        }
    }

    private void doCheckFixedRadiusBezierTrackSegmentsMenuItem(@Nonnull String trackSegmentName) {
        log.debug("doCheckFixedRadiusBezierTrackSegmentsMenuItem({})", (Object)trackSegmentName);
        LayoutTrack layoutTrack = this.layoutEditor.getFinder().findObjectByName(trackSegmentName);
        if (layoutTrack != null) {
            LayoutTrackView layoutTrackView = this.layoutEditor.getLayoutTrackView(layoutTrack);
            this.layoutEditor.setSelectionRect(layoutTrackView.getBounds());
            this.layoutEditor.clearSelectionGroups();
            this.layoutEditor.amendSelectionGroup(layoutTrack);
            layoutTrackView.showPopup();
        } else {
            this.layoutEditor.clearSelectionGroups();
        }
    }

    private Set<String> getCheckMarkedMenuItemNames(@Nonnull JMenu menu) {
        HashSet<String> results = new HashSet<String>();
        for (int idx = 0; idx < menu.getMenuComponentCount(); ++idx) {
            JCheckBoxMenuItem checkBoxMenuItem;
            Component menuComponent = menu.getMenuComponent(idx);
            if (!(menuComponent instanceof JCheckBoxMenuItem) || !(checkBoxMenuItem = (JCheckBoxMenuItem)menuComponent).isSelected()) continue;
            results.add(checkBoxMenuItem.getText());
        }
        return results;
    }
}

