/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterReporterDialog {
    private LayoutEditor layoutEditor = null;
    private transient JmriJFrame enterReporterFrame = null;
    private boolean reporterOpen = false;
    private final transient JTextField xPositionField = new JTextField(6);
    private final transient JTextField yPositionField = new JTextField(6);
    private final transient JTextField reporterNameField = new JTextField(6);
    private transient JButton reporterDone;
    private transient JButton reporterCancel;
    private static final Logger log = LoggerFactory.getLogger(EnterReporterDialog.class);

    public EnterReporterDialog(@Nonnull LayoutEditor thePanel) {
        this.layoutEditor = thePanel;
    }

    @InvokeOnGuiThread
    public void enterReporter(int defaultX, int defaultY) {
        if (this.reporterOpen) {
            this.enterReporterFrame.setVisible(true);
            return;
        }
        if (this.enterReporterFrame == null) {
            this.enterReporterFrame = new JmriJFrame(Bundle.getMessage("AddReporter"));
            this.enterReporterFrame.setLocation(70, 30);
            Container theContentPane = this.enterReporterFrame.getContentPane();
            theContentPane.setLayout(new BoxLayout(theContentPane, 3));
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            JLabel reporterLabel = new JLabel(Bundle.getMessage("ReporterName"));
            panel2.add(reporterLabel);
            reporterLabel.setLabelFor(this.reporterNameField);
            panel2.add(this.reporterNameField);
            this.reporterNameField.setToolTipText(Bundle.getMessage("ReporterNameHint"));
            theContentPane.add(panel2);
            JPanel panel3 = new JPanel();
            panel3.setLayout(new FlowLayout());
            JLabel xCoordLabel = new JLabel(Bundle.getMessage("ReporterLocationX"));
            panel3.add(xCoordLabel);
            xCoordLabel.setLabelFor(this.xPositionField);
            panel3.add(this.xPositionField);
            this.xPositionField.setToolTipText(Bundle.getMessage("ReporterLocationXHint"));
            JLabel yCoordLabel = new JLabel(Bundle.getMessage("ReporterLocationY"));
            panel3.add(yCoordLabel);
            yCoordLabel.setLabelFor(this.yPositionField);
            panel3.add(this.yPositionField);
            this.yPositionField.setToolTipText(Bundle.getMessage("ReporterLocationYHint"));
            theContentPane.add(panel3);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            this.reporterDone = new JButton(Bundle.getMessage("AddNewLabel"));
            panel5.add(this.reporterDone);
            this.reporterDone.addActionListener(this::reporterDonePressed);
            this.reporterDone.setToolTipText(Bundle.getMessage("ReporterDoneHint"));
            this.reporterCancel = new JButton(Bundle.getMessage("ButtonCancel"));
            panel5.add(this.reporterCancel);
            this.reporterCancel.addActionListener(event -> this.reporterCancelPressed());
            this.reporterCancel.setToolTipText(Bundle.getMessage("CancelHint", Bundle.getMessage("ButtonCancel")));
            theContentPane.add(panel5);
            JRootPane rootPane = SwingUtilities.getRootPane(this.reporterDone);
            rootPane.setDefaultButton(this.reporterDone);
        }
        this.xPositionField.setText(Integer.toString(defaultX));
        this.yPositionField.setText(Integer.toString(defaultY));
        this.enterReporterFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                EnterReporterDialog.this.reporterCancelPressed();
            }
        });
        this.enterReporterFrame.pack();
        this.enterReporterFrame.setVisible(true);
        this.reporterOpen = true;
    }

    private void reporterDonePressed(@Nonnull ActionEvent event) {
        String newX = "";
        int xx = 0;
        newX = this.xPositionField.getText().trim();
        try {
            xx = Integer.parseInt(newX);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.enterReporterFrame, e);
            return;
        }
        if (xx <= 0 || xx > this.layoutEditor.gContext.getLayoutWidth()) {
            log.error("invalid x: {}, LayoutWidth: {}", (Object)xx, (Object)this.layoutEditor.gContext.getLayoutWidth());
            JmriJOptionPane.showMessageDialog(this.enterReporterFrame, MessageFormat.format(Bundle.getMessage("Error2a"), String.format(" %s ", xx)), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        String newY = "";
        int yy = 0;
        newY = this.yPositionField.getText().trim();
        try {
            yy = Integer.parseInt(newY);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.enterReporterFrame, e);
            return;
        }
        if (yy <= 0 || yy > this.layoutEditor.gContext.getLayoutHeight()) {
            log.error("invalid y: {}, LayoutWidth: {}", (Object)yy, (Object)this.layoutEditor.gContext.getLayoutHeight());
            JmriJOptionPane.showMessageDialog(this.enterReporterFrame, MessageFormat.format(Bundle.getMessage("Error2a"), String.format(" %s ", yy)), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        Reporter reporter = null;
        String rName = this.reporterNameField.getText();
        if (InstanceManager.getNullableDefault(ReporterManager.class) != null) {
            try {
                reporter = InstanceManager.getDefault(ReporterManager.class).provideReporter(rName);
            }
            catch (IllegalArgumentException e) {
                JmriJOptionPane.showMessageDialog(this.enterReporterFrame, MessageFormat.format(Bundle.getMessage("Error18"), rName), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
        } else {
            JmriJOptionPane.showMessageDialog(this.enterReporterFrame, Bundle.getMessage("Error17"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.layoutEditor.addReporter(reporter, xx, yy);
        this.reporterCancelPressed();
    }

    private void reporterCancelPressed() {
        this.reporterOpen = false;
        this.enterReporterFrame.setVisible(false);
        this.enterReporterFrame.dispose();
        this.enterReporterFrame = null;
        this.layoutEditor.redrawPanel();
    }

    private void showEntryErrorDialog(Component parentComponent, NumberFormatException e) {
        JmriJOptionPane.showMessageDialog(parentComponent, String.format("%s: %s %s", Bundle.getMessage("EntryError"), e, Bundle.getMessage("TryAgain")), Bundle.getMessage("ErrorTitle"), 0);
    }
}

