/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutTrackDrawingOptions;
import jmri.util.swing.JmriColorChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTrackDrawingOptionsDialog
extends JDialog {
    private final LayoutEditor layoutEditor;
    private final LayoutTrackDrawingOptions leLTDOptions;
    private LayoutTrackDrawingOptions ltdOptions = null;
    private final String classicPresetName = Bundle.getMessage("ClassicPresetName");
    private final String draftingPresetName = Bundle.getMessage("DraftingPresetName");
    private final String realisticPresetName = Bundle.getMessage("RealisticPresetName");
    private final String realisticOhPresetName = Bundle.getMessage("RealisticOhPresetName");
    private final String british70sPresetName = Bundle.getMessage("British70sPresetName");
    private final String csdazd71PresetName = Bundle.getMessage("CsdAzd71PresetName");
    private final String customPresetName = Bundle.getMessage("CustomPresetName");
    private final List<LayoutTrackDrawingOptions> ltdoList = new ArrayList<LayoutTrackDrawingOptions>();
    private boolean copyToCustom = true;
    private JButton applyButton;
    private JButton blockDefaultColorButton;
    private JButton blockOccupiedColorButton;
    private JButton blockAlternativeColorButton;
    private JLabel ballastWidthLabel;
    private JLabel blockLineDashPercentageX10Label;
    private JLabel blockLineWidthLabel;
    private JButton cancelButton;
    private JPanel jPanelButtons;
    private JButton mainBallastColorButton;
    private JSpinner mainBallastWidthSpinner;
    private JSpinner mainBlockLineDashPercentageX10Spinner;
    private JSpinner mainBlockLineWidthSpinner;
    private JButton mainRailColorButton;
    private JSpinner mainRailCountSpinner;
    private JSpinner mainRailGapSpinner;
    private JSpinner mainRailWidthSpinner;
    private JButton mainTieColorButton;
    private JSpinner mainTieGapSpinner;
    private JSpinner mainTieLengthSpinner;
    private JSpinner mainTieWidthSpinner;
    private JLabel mainlineLabel;
    private JButton okButton;
    private JLabel optionLabel;
    private JPanel optionsPanel;
    private JComboBox<String> presetsComboBox;
    private JLabel presetsLabel;
    private JLabel railCountLabel;
    private JLabel railGapLabel;
    private JLabel railWidthLabel;
    private JButton sideBallastColorButton;
    private JSpinner sideBallastWidthSpinner;
    private JSpinner sideBlockLineDashPercentageX10Spinner;
    private JSpinner sideBlockLineWidthSpinner;
    private JButton sideRailColorButton;
    private JSpinner sideRailCountSpinner;
    private JSpinner sideRailGapSpinner;
    private JSpinner sideRailWidthSpinner;
    private JButton sideTieColorButton;
    private JSpinner sideTieGapSpinner;
    private JSpinner sideTieLengthSpinner;
    private JSpinner sideTieWidthSpinner;
    private JLabel sidelineLabel;
    private JLabel tieGapLabel;
    private JLabel tieLengthLabel;
    private JLabel tieWidthLabel;
    private static final Logger log = LoggerFactory.getLogger(LayoutTrackDrawingOptionsDialog.class);

    public LayoutTrackDrawingOptionsDialog(LayoutEditor layoutEditor, boolean modal, LayoutTrackDrawingOptions ltdOptions) {
        super((Frame)layoutEditor, modal);
        this.layoutEditor = layoutEditor;
        this.leLTDOptions = ltdOptions;
        this.ltdOptions = new LayoutTrackDrawingOptions(ltdOptions);
        this.initComponents();
        this.setTitle(Bundle.getMessage("SetTrackDrawingOptions"));
        this.setLocationRelativeTo(layoutEditor);
        this.definePresets();
        this.pack();
    }

    private void initComponents() {
        this.optionsPanel = new JPanel();
        this.optionLabel = new JLabel();
        JLabel blockDefaultColorLabel = new JLabel();
        this.blockDefaultColorButton = new JButton();
        JLabel blockOccupiedColorLabel = new JLabel();
        this.blockOccupiedColorButton = new JButton();
        JLabel blockAlternativeColorLabel = new JLabel();
        this.blockAlternativeColorButton = new JButton();
        this.mainlineLabel = new JLabel();
        this.railCountLabel = new JLabel();
        this.mainRailCountSpinner = new JSpinner();
        this.sideRailCountSpinner = new JSpinner();
        this.railWidthLabel = new JLabel();
        this.mainRailWidthSpinner = new JSpinner();
        this.sideRailWidthSpinner = new JSpinner();
        this.railGapLabel = new JLabel();
        this.sideRailGapSpinner = new JSpinner();
        this.mainRailGapSpinner = new JSpinner();
        JLabel railColorLabel = new JLabel();
        this.mainRailColorButton = new JButton();
        this.sideRailColorButton = new JButton();
        this.blockLineWidthLabel = new JLabel();
        this.mainBlockLineWidthSpinner = new JSpinner();
        this.sideBlockLineWidthSpinner = new JSpinner();
        this.ballastWidthLabel = new JLabel();
        this.mainBallastWidthSpinner = new JSpinner();
        this.sideBallastWidthSpinner = new JSpinner();
        JLabel ballastColorLabel = new JLabel();
        this.mainBallastColorButton = new JButton();
        this.sideBallastColorButton = new JButton();
        this.tieLengthLabel = new JLabel();
        this.mainTieLengthSpinner = new JSpinner();
        this.sideTieLengthSpinner = new JSpinner();
        this.tieWidthLabel = new JLabel();
        this.mainTieWidthSpinner = new JSpinner();
        this.sideTieWidthSpinner = new JSpinner();
        this.tieGapLabel = new JLabel();
        this.mainTieGapSpinner = new JSpinner();
        this.sideTieGapSpinner = new JSpinner();
        JLabel tieColorLabel = new JLabel();
        this.mainTieColorButton = new JButton();
        this.sideTieColorButton = new JButton();
        this.sidelineLabel = new JLabel();
        this.blockLineDashPercentageX10Label = new JLabel();
        this.mainBlockLineDashPercentageX10Spinner = new JSpinner();
        this.sideBlockLineDashPercentageX10Spinner = new JSpinner();
        this.jPanelButtons = new JPanel();
        this.presetsLabel = new JLabel();
        this.presetsComboBox = new JComboBox();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("SetTrackDrawingOptions");
        this.setSize(new Dimension(512, 329));
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(this.ltdOptions.getName()));
        GridBagLayout optionsPanelLayout = new GridBagLayout();
        optionsPanelLayout.columnWidths = new int[]{0, 5, 0, 5, 0};
        optionsPanelLayout.rowHeights = new int[]{0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0};
        this.optionsPanel.setLayout(optionsPanelLayout);
        this.optionLabel.setFont(this.optionLabel.getFont().deriveFont(this.optionLabel.getFont().getStyle() | 1));
        this.optionLabel.setText(Bundle.getMessage("OptionLabelText"));
        this.optionLabel.setToolTipText(Bundle.getMessage("OptionToolTip"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 100.0;
        this.optionsPanel.add((Component)this.optionLabel, gridBagConstraints);
        this.mainlineLabel.setFont(this.mainlineLabel.getFont().deriveFont(this.mainlineLabel.getFont().getStyle() | 1));
        this.mainlineLabel.setText(Bundle.getMessage("MainlineLabelText"));
        this.mainlineLabel.setToolTipText(Bundle.getMessage("MainlineColumnToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 30.0;
        this.optionsPanel.add((Component)this.mainlineLabel, gridBagConstraints);
        this.sidelineLabel.setFont(this.sidelineLabel.getFont().deriveFont(this.sidelineLabel.getFont().getStyle() | 1));
        this.sidelineLabel.setText(Bundle.getMessage("SidelineLabelText"));
        this.sidelineLabel.setToolTipText(Bundle.getMessage("SidelineColumnToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 30.0;
        this.optionsPanel.add((Component)this.sidelineLabel, gridBagConstraints);
        this.railCountLabel.setText(Bundle.getMessage("RailCountLabelText"));
        this.railCountLabel.setToolTipText(Bundle.getMessage("RailCountToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)this.railCountLabel, gridBagConstraints);
        this.mainRailCountSpinner.setModel(new SpinnerNumberModel(1, 0, 3, 1));
        this.mainRailCountSpinner.setToolTipText(Bundle.getMessage("MainRailCountToolTip"));
        this.mainRailCountSpinner.setName("");
        this.mainRailCountSpinner.setValue(this.ltdOptions.getMainRailCount());
        this.mainRailCountSpinner.addChangeListener(this::mainRailCountSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainRailCountSpinner, gridBagConstraints);
        this.sideRailCountSpinner.setModel(new SpinnerNumberModel(1, 0, 3, 1));
        this.sideRailCountSpinner.setToolTipText(Bundle.getMessage("SideRailCountToolTip"));
        this.sideRailCountSpinner.setName("");
        this.sideRailCountSpinner.setValue(this.ltdOptions.getSideRailCount());
        this.sideRailCountSpinner.addChangeListener(this::sideRailCountSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideRailCountSpinner, gridBagConstraints);
        this.railWidthLabel.setText(Bundle.getMessage("RailWidthLabelText"));
        this.railWidthLabel.setToolTipText(Bundle.getMessage("RailWidthToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)this.railWidthLabel, gridBagConstraints);
        this.mainRailWidthSpinner.setModel(new SpinnerNumberModel((Number)2, Integer.valueOf(0), null, (Number)1));
        this.mainRailWidthSpinner.setToolTipText(Bundle.getMessage("MainRailWidthToolTip"));
        this.mainRailWidthSpinner.setEnabled(this.ltdOptions.getMainRailCount() > 0);
        this.mainRailWidthSpinner.setName("");
        this.mainRailWidthSpinner.setValue(this.ltdOptions.getMainRailWidth());
        this.mainRailWidthSpinner.addChangeListener(this::mainRailWidthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainRailWidthSpinner, gridBagConstraints);
        this.sideRailWidthSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.sideRailWidthSpinner.setToolTipText(Bundle.getMessage("SideRailWidthToolTip"));
        this.sideRailWidthSpinner.setEnabled(this.ltdOptions.getSideRailCount() > 0);
        this.sideRailWidthSpinner.setName("");
        this.sideRailWidthSpinner.setValue(this.ltdOptions.getSideRailWidth());
        this.sideRailWidthSpinner.addChangeListener(this::sideRailWidthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideRailWidthSpinner, gridBagConstraints);
        this.railGapLabel.setText(Bundle.getMessage("RailGapLabelText"));
        this.railGapLabel.setToolTipText(Bundle.getMessage("RailGapToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)this.railGapLabel, gridBagConstraints);
        this.sideRailGapSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.sideRailGapSpinner.setToolTipText(Bundle.getMessage("SideRailGapToolTip"));
        this.sideRailGapSpinner.setEnabled(this.ltdOptions.getSideRailCount() > 1);
        this.sideRailGapSpinner.setName("");
        this.sideRailGapSpinner.setValue(this.ltdOptions.getSideRailGap());
        this.sideRailGapSpinner.addChangeListener(this::sideRailGapSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideRailGapSpinner, gridBagConstraints);
        this.mainRailGapSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.mainRailGapSpinner.setToolTipText(Bundle.getMessage("MainRailGapToolTip"));
        this.mainRailGapSpinner.setEnabled(this.ltdOptions.getMainRailCount() > 1);
        this.mainRailGapSpinner.setName("");
        this.mainRailGapSpinner.setValue(this.ltdOptions.getMainRailGap());
        this.mainRailGapSpinner.addChangeListener(this::mainRailGapSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainRailGapSpinner, gridBagConstraints);
        railColorLabel.setText(Bundle.getMessage("RailColorLabelText"));
        railColorLabel.setToolTipText(Bundle.getMessage("RailColorToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)railColorLabel, gridBagConstraints);
        this.mainRailColorButton.setBackground(this.ltdOptions.getMainRailColor());
        this.mainRailColorButton.setToolTipText(Bundle.getMessage("MainRailColorToolTip"));
        this.mainRailColorButton.setBorder(BorderFactory.createBevelBorder(1));
        this.mainRailColorButton.setEnabled(this.ltdOptions.getMainRailCount() > 0);
        this.mainRailColorButton.setOpaque(true);
        this.mainRailColorButton.addActionListener(this::mainRailColorButtonActionPerformed);
        GroupLayout mainRailColorButtonLayout = new GroupLayout(this.mainRailColorButton);
        this.mainRailColorButton.setLayout(mainRailColorButtonLayout);
        mainRailColorButtonLayout.setHorizontalGroup(mainRailColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        mainRailColorButtonLayout.setVerticalGroup(mainRailColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainRailColorButton, gridBagConstraints);
        this.sideRailColorButton.setBackground(this.ltdOptions.getSideRailColor());
        this.sideRailColorButton.setToolTipText(Bundle.getMessage("SideRailColorToolTip"));
        this.sideRailColorButton.setBorder(BorderFactory.createBevelBorder(1));
        this.sideRailColorButton.setEnabled(this.ltdOptions.getSideRailCount() > 0);
        this.sideRailColorButton.setOpaque(true);
        this.sideRailColorButton.addActionListener(this::sideRailColorButtonActionPerformed);
        GroupLayout sideRailColorButtonLayout = new GroupLayout(this.sideRailColorButton);
        this.sideRailColorButton.setLayout(sideRailColorButtonLayout);
        sideRailColorButtonLayout.setHorizontalGroup(sideRailColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        sideRailColorButtonLayout.setVerticalGroup(sideRailColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideRailColorButton, gridBagConstraints);
        this.blockLineWidthLabel.setText(Bundle.getMessage("BlockLineWidthLabelText"));
        this.blockLineWidthLabel.setToolTipText(Bundle.getMessage("BlockLineWidthToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)this.blockLineWidthLabel, gridBagConstraints);
        this.mainBlockLineWidthSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.mainBlockLineWidthSpinner.setToolTipText(Bundle.getMessage("MainBlockLineWidthToolTip"));
        this.mainBlockLineWidthSpinner.setName("");
        this.mainBlockLineWidthSpinner.setValue(this.ltdOptions.getMainBlockLineWidth());
        this.mainBlockLineWidthSpinner.addChangeListener(this::mainBlockLineWidthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainBlockLineWidthSpinner, gridBagConstraints);
        this.sideBlockLineWidthSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.sideBlockLineWidthSpinner.setToolTipText(Bundle.getMessage("SideBlockLineWidthToolTip"));
        this.sideBlockLineWidthSpinner.setName("");
        this.sideBlockLineWidthSpinner.setValue(this.ltdOptions.getSideBlockLineWidth());
        this.sideBlockLineWidthSpinner.addChangeListener(this::sideBlockLineWidthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideBlockLineWidthSpinner, gridBagConstraints);
        this.blockLineDashPercentageX10Label.setText(Bundle.getMessage("BlockLineDashPercentageX10LabelText"));
        this.blockLineDashPercentageX10Label.setToolTipText(Bundle.getMessage("BlockLineDashPercentageX10ToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)this.blockLineDashPercentageX10Label, gridBagConstraints);
        this.mainBlockLineDashPercentageX10Spinner.setModel(new SpinnerNumberModel(1, 0, 9, 1));
        this.mainBlockLineDashPercentageX10Spinner.setToolTipText(Bundle.getMessage("MainBlockLineWidthToolTip"));
        this.mainBlockLineDashPercentageX10Spinner.setEnabled(this.ltdOptions.getMainBlockLineWidth() > 0);
        this.mainBlockLineDashPercentageX10Spinner.setName("");
        this.mainBlockLineDashPercentageX10Spinner.setValue(this.ltdOptions.getMainBlockLineDashPercentageX10());
        this.mainBlockLineDashPercentageX10Spinner.addChangeListener(this::mainBlockLineDashPercentageX10SpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainBlockLineDashPercentageX10Spinner, gridBagConstraints);
        this.sideBlockLineDashPercentageX10Spinner.setModel(new SpinnerNumberModel(1, 0, 9, 1));
        this.sideBlockLineDashPercentageX10Spinner.setToolTipText(Bundle.getMessage("SideBlockLineDashPercentageX10ToolTip"));
        this.sideBlockLineDashPercentageX10Spinner.setEnabled(this.ltdOptions.getSideBlockLineWidth() > 0);
        this.sideBlockLineDashPercentageX10Spinner.setName("");
        this.sideBlockLineDashPercentageX10Spinner.setValue(this.ltdOptions.getSideBlockLineDashPercentageX10());
        this.sideBlockLineDashPercentageX10Spinner.addChangeListener(this::sideBlockLineDashPercentageX10SpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideBlockLineDashPercentageX10Spinner, gridBagConstraints);
        blockDefaultColorLabel.setText(Bundle.getMessage("BlockDefaultColorLabelText"));
        blockDefaultColorLabel.setToolTipText(Bundle.getMessage("BlockDefaultColorToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)blockDefaultColorLabel, gridBagConstraints);
        this.blockDefaultColorButton.setBackground(this.layoutEditor.getDefaultTrackColorColor());
        this.blockDefaultColorButton.setToolTipText(Bundle.getMessage("BlockDefaultColorToolTip"));
        this.blockDefaultColorButton.setBorder(BorderFactory.createBevelBorder(1));
        this.blockDefaultColorButton.setEnabled(true);
        this.blockDefaultColorButton.setOpaque(true);
        this.blockDefaultColorButton.addActionListener(this::blockDefaultColorButtonActionPerformed);
        GroupLayout blockDefaultColorButtonLayout = new GroupLayout(this.blockDefaultColorButton);
        this.blockDefaultColorButton.setLayout(blockDefaultColorButtonLayout);
        blockDefaultColorButtonLayout.setHorizontalGroup(blockDefaultColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        blockDefaultColorButtonLayout.setVerticalGroup(blockDefaultColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.blockDefaultColorButton, gridBagConstraints);
        blockOccupiedColorLabel.setText(Bundle.getMessage("BlockOccupiedColorLabelText"));
        blockOccupiedColorLabel.setToolTipText(Bundle.getMessage("BlockOccupiedColorToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)blockOccupiedColorLabel, gridBagConstraints);
        this.blockOccupiedColorButton.setBackground(this.layoutEditor.getDefaultOccupiedTrackColorColor());
        this.blockOccupiedColorButton.setToolTipText(Bundle.getMessage("BlockOccupiedColorToolTip"));
        this.blockOccupiedColorButton.setBorder(BorderFactory.createBevelBorder(1));
        this.blockOccupiedColorButton.setEnabled(true);
        this.blockOccupiedColorButton.setOpaque(true);
        this.blockOccupiedColorButton.addActionListener(this::blockOccupiedColorButtonActionPerformed);
        GroupLayout blockOccupiedColorButtonLayout = new GroupLayout(this.blockOccupiedColorButton);
        this.blockOccupiedColorButton.setLayout(blockOccupiedColorButtonLayout);
        blockOccupiedColorButtonLayout.setHorizontalGroup(blockOccupiedColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        blockOccupiedColorButtonLayout.setVerticalGroup(blockOccupiedColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.blockOccupiedColorButton, gridBagConstraints);
        blockAlternativeColorLabel.setText(Bundle.getMessage("BlockAlternativeColorLabelText"));
        blockAlternativeColorLabel.setToolTipText(Bundle.getMessage("BlockAlternativeColorToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)blockAlternativeColorLabel, gridBagConstraints);
        this.blockAlternativeColorButton.setBackground(this.layoutEditor.getDefaultAlternativeTrackColorColor());
        this.blockAlternativeColorButton.setToolTipText(Bundle.getMessage("BlockAlternativeColorToolTip"));
        this.blockAlternativeColorButton.setBorder(BorderFactory.createBevelBorder(1));
        this.blockAlternativeColorButton.setEnabled(true);
        this.blockAlternativeColorButton.setOpaque(true);
        this.blockAlternativeColorButton.addActionListener(this::blockAlternativeColorButtonActionPerformed);
        GroupLayout blockAlternativeColorButtonLayout = new GroupLayout(this.blockAlternativeColorButton);
        this.blockAlternativeColorButton.setLayout(blockAlternativeColorButtonLayout);
        blockAlternativeColorButtonLayout.setHorizontalGroup(blockAlternativeColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        blockAlternativeColorButtonLayout.setVerticalGroup(blockAlternativeColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.blockAlternativeColorButton, gridBagConstraints);
        this.ballastWidthLabel.setText(Bundle.getMessage("BallastWidthLabelText"));
        this.ballastWidthLabel.setToolTipText(Bundle.getMessage("BallastWidthToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)this.ballastWidthLabel, gridBagConstraints);
        this.mainBallastWidthSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.mainBallastWidthSpinner.setToolTipText(Bundle.getMessage("MainBallastWidthToolTip"));
        this.mainBallastWidthSpinner.setValue(this.ltdOptions.getMainBallastWidth());
        this.mainBallastWidthSpinner.addChangeListener(this::mainBallastWidthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainBallastWidthSpinner, gridBagConstraints);
        this.sideBallastWidthSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.sideBallastWidthSpinner.setToolTipText(Bundle.getMessage("SideBallastWidthToolTip"));
        this.sideBallastWidthSpinner.setValue(this.ltdOptions.getSideBallastWidth());
        this.sideBallastWidthSpinner.addChangeListener(this::sideBallastWidthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideBallastWidthSpinner, gridBagConstraints);
        ballastColorLabel.setText(Bundle.getMessage("BallastColorLabelText"));
        ballastColorLabel.setToolTipText(Bundle.getMessage("BallastColorToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)ballastColorLabel, gridBagConstraints);
        this.mainBallastColorButton.setBackground(this.ltdOptions.getMainBallastColor());
        this.mainBallastColorButton.setToolTipText(Bundle.getMessage("MainBallastColorToolTip"));
        this.mainBallastColorButton.setBorder(BorderFactory.createBevelBorder(1));
        this.mainBallastColorButton.setEnabled(this.ltdOptions.getMainBallastWidth() > 0);
        this.mainBallastColorButton.setOpaque(true);
        this.mainBallastColorButton.addActionListener(this::mainBallastColorButtonActionPerformed);
        GroupLayout mainBallastColorButtonLayout = new GroupLayout(this.mainBallastColorButton);
        this.mainBallastColorButton.setLayout(mainBallastColorButtonLayout);
        mainBallastColorButtonLayout.setHorizontalGroup(mainBallastColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        mainBallastColorButtonLayout.setVerticalGroup(mainBallastColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainBallastColorButton, gridBagConstraints);
        this.sideBallastColorButton.setBackground(this.ltdOptions.getSideBallastColor());
        this.sideBallastColorButton.setToolTipText(Bundle.getMessage("SideBallastColorToolTip"));
        this.sideBallastColorButton.setBorder(BorderFactory.createBevelBorder(1));
        this.sideBallastColorButton.setEnabled(this.ltdOptions.getSideBallastWidth() > 0);
        this.sideBallastColorButton.setOpaque(true);
        this.sideBallastColorButton.addActionListener(this::sideBallastColorButtonActionPerformed);
        GroupLayout sideBallastColorButtonLayout = new GroupLayout(this.sideBallastColorButton);
        this.sideBallastColorButton.setLayout(sideBallastColorButtonLayout);
        sideBallastColorButtonLayout.setHorizontalGroup(sideBallastColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        sideBallastColorButtonLayout.setVerticalGroup(sideBallastColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideBallastColorButton, gridBagConstraints);
        this.tieLengthLabel.setText(Bundle.getMessage("TieLengthLabelText"));
        this.tieLengthLabel.setToolTipText(Bundle.getMessage("TieLengthToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)this.tieLengthLabel, gridBagConstraints);
        this.mainTieLengthSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.mainTieLengthSpinner.setToolTipText(Bundle.getMessage("MainTieLengthToolTip"));
        this.mainTieLengthSpinner.setValue(this.ltdOptions.getMainTieLength());
        this.mainTieLengthSpinner.addChangeListener(this::mainTieLengthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainTieLengthSpinner, gridBagConstraints);
        this.sideTieLengthSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.sideTieLengthSpinner.setToolTipText(Bundle.getMessage("SideTieLengthToolTip"));
        this.sideTieLengthSpinner.setValue(this.ltdOptions.getSideTieLength());
        this.sideTieLengthSpinner.addChangeListener(this::sideTieLengthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideTieLengthSpinner, gridBagConstraints);
        this.tieWidthLabel.setText(Bundle.getMessage("TieWidthLabelText"));
        this.tieWidthLabel.setToolTipText(Bundle.getMessage("TieWidthToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)this.tieWidthLabel, gridBagConstraints);
        this.mainTieWidthSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.mainTieWidthSpinner.setToolTipText(Bundle.getMessage("MainTieWidthToolTip"));
        this.mainTieWidthSpinner.setEnabled(this.ltdOptions.getMainTieLength() > 0);
        this.mainTieWidthSpinner.setValue(this.ltdOptions.getMainTieWidth());
        this.mainTieWidthSpinner.addChangeListener(this::mainTieWidthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainTieWidthSpinner, gridBagConstraints);
        this.sideTieWidthSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.sideTieWidthSpinner.setToolTipText(Bundle.getMessage("SideTieWidthToolTip"));
        this.sideTieWidthSpinner.setEnabled(this.ltdOptions.getSideTieLength() > 0);
        this.sideTieWidthSpinner.setValue(this.ltdOptions.getSideTieWidth());
        this.sideTieWidthSpinner.addChangeListener(this::sideTieWidthSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideTieWidthSpinner, gridBagConstraints);
        this.tieGapLabel.setText(Bundle.getMessage("TieGapLabelText"));
        this.tieGapLabel.setToolTipText(Bundle.getMessage("TieGapToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 28;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)this.tieGapLabel, gridBagConstraints);
        this.mainTieGapSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.mainTieGapSpinner.setToolTipText(Bundle.getMessage("MainTieGapToolTip"));
        this.mainTieGapSpinner.setEnabled(this.ltdOptions.getMainTieLength() > 0);
        this.mainTieGapSpinner.setValue(this.ltdOptions.getMainTieGap());
        this.mainTieGapSpinner.addChangeListener(this::mainTieGapSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 28;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainTieGapSpinner, gridBagConstraints);
        this.sideTieGapSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.sideTieGapSpinner.setToolTipText(Bundle.getMessage("SideTieGapToolTip"));
        this.sideTieGapSpinner.setEnabled(this.ltdOptions.getSideTieLength() > 0);
        this.sideTieGapSpinner.setValue(this.ltdOptions.getSideTieGap());
        this.sideTieGapSpinner.addChangeListener(this::sideTieGapSpinnerStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 28;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideTieGapSpinner, gridBagConstraints);
        tieColorLabel.setText(Bundle.getMessage("TieColorLabelText"));
        tieColorLabel.setToolTipText(Bundle.getMessage("TieColorToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.optionsPanel.add((Component)tieColorLabel, gridBagConstraints);
        this.mainTieColorButton.setBackground(this.ltdOptions.getMainTieColor());
        this.mainTieColorButton.setToolTipText(Bundle.getMessage("MainTieColorToolTip"));
        this.mainTieColorButton.setBorder(BorderFactory.createBevelBorder(1));
        this.mainTieColorButton.setEnabled(this.ltdOptions.getMainTieLength() > 0);
        this.mainTieColorButton.setOpaque(true);
        this.mainTieColorButton.addActionListener(this::mainTieColorButtonActionPerformed);
        GroupLayout mainTieColorButtonLayout = new GroupLayout(this.mainTieColorButton);
        this.mainTieColorButton.setLayout(mainTieColorButtonLayout);
        mainTieColorButtonLayout.setHorizontalGroup(mainTieColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        mainTieColorButtonLayout.setVerticalGroup(mainTieColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.mainTieColorButton, gridBagConstraints);
        this.sideTieColorButton.setBackground(this.ltdOptions.getSideTieColor());
        this.sideTieColorButton.setToolTipText(Bundle.getMessage("SideTieColorToolTip"));
        this.sideTieColorButton.setBorder(BorderFactory.createBevelBorder(1));
        this.sideTieColorButton.setEnabled(this.ltdOptions.getSideTieLength() > 0);
        this.sideTieColorButton.setOpaque(true);
        this.sideTieColorButton.addActionListener(this::sideTieColorButtonActionPerformed);
        GroupLayout sideTieColorButtonLayout = new GroupLayout(this.sideTieColorButton);
        this.sideTieColorButton.setLayout(sideTieColorButtonLayout);
        sideTieColorButtonLayout.setHorizontalGroup(sideTieColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        sideTieColorButtonLayout.setVerticalGroup(sideTieColorButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        this.optionsPanel.add((Component)this.sideTieColorButton, gridBagConstraints);
        this.presetsLabel.setText(Bundle.getMessage("ButtonPresets"));
        this.presetsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Classic JMRI", "Drafting", "Realistic", "Realistic Oh!", "Garrish", "--", "Custom"}));
        this.presetsComboBox.addActionListener(this::presetsComboBoxActionPerformed);
        this.applyButton.setText(Bundle.getMessage("ButtonApply"));
        this.applyButton.addActionListener(this::applyButtonActionPerformed);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setActionCommand("cancelActionCommand");
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.okButton.setText(Bundle.getMessage("ButtonOK"));
        this.okButton.addActionListener(this::okButtonActionPerformed);
        GroupLayout jPanelButtonsLayout = new GroupLayout(this.jPanelButtons);
        this.jPanelButtons.setLayout(jPanelButtonsLayout);
        jPanelButtonsLayout.setHorizontalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonsLayout.createSequentialGroup().addContainerGap().addComponent(this.presetsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.presetsComboBox, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 285, Short.MAX_VALUE).addComponent(this.applyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addContainerGap()));
        jPanelButtonsLayout.linkSize(0, this.applyButton, this.cancelButton, this.okButton);
        jPanelButtonsLayout.setVerticalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.presetsComboBox, -2, -1, -2).addComponent(this.presetsLabel).addComponent(this.applyButton).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsPanel, GroupLayout.Alignment.TRAILING, -1, 722, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelButtons, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.optionsPanel, -2, 632, -2).addGap(0, 68, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 542, Short.MAX_VALUE).addComponent(this.jPanelButtons, -2, -1, -2))));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        log.debug("okButtonActionPerformed({}", (Object)evt);
        this.layoutEditor.setDefaultTrackColor(this.ltdOptions.getBlockDefaultColor());
        this.layoutEditor.setDefaultOccupiedTrackColor(this.ltdOptions.getBlockOccupiedColor());
        this.layoutEditor.setDefaultAlternativeTrackColor(this.ltdOptions.getBlockAlternativeColor());
        this.layoutEditor.setDirty();
        this.layoutEditor.redrawPanel();
        this.ltdOptions.setName(this.layoutEditor.getLayoutName());
        this.layoutEditor.setLayoutTrackDrawingOptions(this.ltdOptions);
        this.ltdOptions = null;
        this.setVisible(false);
        this.dispose();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.layoutEditor.setDefaultTrackColor(this.ltdOptions.getBlockDefaultColor());
        this.layoutEditor.setDefaultOccupiedTrackColor(this.ltdOptions.getBlockOccupiedColor());
        this.layoutEditor.setDefaultAlternativeTrackColor(this.ltdOptions.getBlockAlternativeColor());
        this.layoutEditor.setDirty();
        this.layoutEditor.redrawPanel();
        LayoutTrackDrawingOptions ltdo = new LayoutTrackDrawingOptions(this.ltdOptions);
        ltdo.setName(this.layoutEditor.getLayoutName());
        this.layoutEditor.setLayoutTrackDrawingOptions(ltdo);
    }

    private void presetsComboBoxActionPerformed(ActionEvent evt) {
        log.debug("presetsComboBoxActionPerformed({}", (Object)evt);
        int modifiers = evt.getModifiers();
        if (modifiers != 0) {
            String presetName = (String)this.presetsComboBox.getSelectedItem();
            for (LayoutTrackDrawingOptions ltdo : this.ltdoList) {
                if (!ltdo.getName().equals(presetName)) continue;
                if (this.ltdOptions.getName().equals(ltdo.getName())) break;
                this.ltdOptions = ltdo;
                this.setupControls();
                this.optionsPanel.setBorder(BorderFactory.createTitledBorder(presetName));
                this.presetsComboBox.setSelectedItem(presetName);
                break;
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        log.debug("cancelButtonActionPerformed({}", (Object)evt);
        this.layoutEditor.setLayoutTrackDrawingOptions(this.leLTDOptions);
        this.setVisible(false);
        this.dispose();
    }

    private void sideTieGapSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setSideTieGap(value);
        log.debug("sideTieGapSpinnerStateChanged({})", (Object)value);
    }

    private void mainTieGapSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setMainTieGap(value);
        log.debug("mainTieGapSpinnerStateChanged({})", (Object)value);
    }

    private void sideTieWidthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setSideTieWidth(value);
        log.debug("sideTieWidthSpinnerStateChanged({})", (Object)value);
    }

    private void mainTieWidthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setMainTieWidth(value);
        log.debug("mainTieWidthSpinnerStateChanged({})", (Object)value);
    }

    private void sideTieLengthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setSideTieLength(value);
        log.debug("sideTieLengthSpinnerStateChanged({})", (Object)value);
        this.sideTieColorButton.setEnabled(value > 0);
        this.sideTieGapSpinner.setEnabled(value > 0);
        this.sideTieWidthSpinner.setEnabled(value > 0);
    }

    private void mainTieLengthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setMainTieLength(value);
        log.debug("mainTieLengthSpinnerStateChanged({})", (Object)value);
        this.mainTieColorButton.setEnabled(value > 0);
        this.mainTieGapSpinner.setEnabled(value > 0);
        this.mainTieWidthSpinner.setEnabled(value > 0);
    }

    private void sideBallastWidthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setSideBallastWidth(value);
        log.debug("sideBallastWidthSpinnerStateChanged({})", (Object)value);
    }

    private void mainBallastWidthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setMainBallastWidth(value);
        log.debug("mainBallastWidthSpinnerStateChanged({})", (Object)value);
    }

    private void sideBlockLineWidthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setSideBlockLineWidth(value);
        log.debug("sideBlockLineWidthSpinnerStateChanged({})", (Object)value);
        this.sideBlockLineDashPercentageX10Spinner.setEnabled(value > 0);
    }

    private void mainBlockLineWidthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setMainBlockLineWidth(value);
        log.debug("mainBlockLineWidthSpinnerStateChanged({})", (Object)value);
        this.mainBlockLineDashPercentageX10Spinner.setEnabled(value > 0);
    }

    private void mainRailGapSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setMainRailGap(value);
        log.debug("sideRailGapSpinnerStateChanged({})", (Object)value);
    }

    private void sideRailGapSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setSideRailGap(value);
        log.debug("mainRailGapSpinnerStateChanged({})", (Object)value);
    }

    private void sideRailWidthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setSideRailWidth(value);
        log.debug("sideRailWidthSpinnerStateChanged({})", (Object)value);
    }

    private void mainRailWidthSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setMainRailWidth(value);
        log.debug("mainRailWidthSpinnerStateChanged({})", (Object)value);
    }

    private void sideRailCountSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setSideRailCount(value);
        log.debug("sideRailCountSpinnerStateChanged({})", (Object)value);
        this.sideRailColorButton.setEnabled(value > 0);
        this.sideRailGapSpinner.setEnabled(value > 1);
        this.sideRailWidthSpinner.setEnabled(value > 0);
    }

    private void mainRailCountSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setMainRailCount(value);
        log.debug("mainRailCountSpinnerStateChanged({})", (Object)value);
        this.mainRailColorButton.setEnabled(value > 0);
        this.mainRailGapSpinner.setEnabled(value > 1);
        this.mainRailWidthSpinner.setEnabled(value > 0);
    }

    private void mainRailColorButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Color value = button.getBackground();
        Color newColor = JmriColorChooser.showDialog(null, "Choose a color", value);
        if (newColor != null && !newColor.equals(value)) {
            this.makeCustomPreset();
            button.setBackground(newColor);
            this.ltdOptions.setMainRailColor(newColor);
        }
        log.info("*mainRailColorButtonActionPerformed({})", (Object)newColor);
    }

    private void sideRailColorButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Color value = button.getBackground();
        Color newColor = JmriColorChooser.showDialog(null, "Choose a color", value);
        if (newColor != null && !newColor.equals(value)) {
            this.makeCustomPreset();
            button.setBackground(newColor);
            this.ltdOptions.setSideRailColor(newColor);
        }
        log.info("*sideRailColorButtonActionPerformed({})", (Object)newColor);
    }

    private void mainBallastColorButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Color value = button.getBackground();
        Color newColor = JmriColorChooser.showDialog(null, "Choose a color", value);
        if (newColor != null && !newColor.equals(value)) {
            this.makeCustomPreset();
            button.setBackground(newColor);
            this.ltdOptions.setMainBallastColor(newColor);
        }
        log.info("*mainBallastColorButtonActionPerformed({})", (Object)newColor);
    }

    private void sideBallastColorButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Color value = button.getBackground();
        Color newColor = JmriColorChooser.showDialog(null, "Choose a color", value);
        if (newColor != null && !newColor.equals(value)) {
            this.makeCustomPreset();
            button.setBackground(newColor);
            this.ltdOptions.setSideBallastColor(newColor);
        }
        log.info("*sideBallastColorButtonActionPerformed({})", (Object)newColor);
    }

    private void mainTieColorButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Color value = button.getBackground();
        Color newColor = JmriColorChooser.showDialog(null, "Choose a color", value);
        if (newColor != null && !newColor.equals(value)) {
            this.makeCustomPreset();
            button.setBackground(newColor);
            this.ltdOptions.setMainTieColor(newColor);
        }
        log.info("*mainTieColorButtonActionPerformed({})", (Object)newColor);
    }

    private void sideTieColorButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Color value = button.getBackground();
        Color newColor = JmriColorChooser.showDialog(null, "Choose a color", value);
        if (newColor != null && !newColor.equals(value)) {
            this.makeCustomPreset();
            button.setBackground(newColor);
            this.ltdOptions.setSideTieColor(newColor);
        }
        log.info("*sideTieColorButtonActionPerformed({})", (Object)newColor);
    }

    private void blockDefaultColorButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Color value = button.getBackground();
        Color newColor = JmriColorChooser.showDialog(null, Bundle.getMessage("DefaultTrackColor"), value);
        if (newColor != null && !newColor.equals(value)) {
            this.makeCustomPreset();
            button.setBackground(newColor);
            this.ltdOptions.setBlockDefaultColor(newColor);
        }
        log.info("*blockDefaultColorButtonActionPerformed({})", (Object)newColor);
    }

    private void blockOccupiedColorButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Color value = button.getBackground();
        Color newColor = JmriColorChooser.showDialog(null, Bundle.getMessage("DefaultOccupiedTrackColor"), value);
        if (newColor != null && !newColor.equals(value)) {
            this.makeCustomPreset();
            button.setBackground(newColor);
            this.ltdOptions.setBlockOccupiedColor(newColor);
        }
        log.info("*blockOccupiedColorButtonActionPerformed({})", (Object)newColor);
    }

    private void blockAlternativeColorButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Color value = button.getBackground();
        Color newColor = JmriColorChooser.showDialog(null, Bundle.getMessage("DefaultAlternativeTrackColor"), value);
        if (newColor != null && !newColor.equals(value)) {
            this.makeCustomPreset();
            button.setBackground(newColor);
            this.ltdOptions.setBlockAlternativeColor(newColor);
        }
        log.info("*blockAlternativeColorButtonActionPerformed({})", (Object)newColor);
    }

    private void mainBlockLineDashPercentageX10SpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setMainBlockLineDashPercentageX10(value);
        log.debug("mainBlockLineDashPercentageX10SpinnerStateChanged({})", (Object)value);
    }

    private void sideBlockLineDashPercentageX10SpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        Integer value = (Integer)spinner.getValue();
        this.makeCustomPreset();
        this.ltdOptions.setSideBlockLineDashPercentageX10(value);
        log.debug("sideBlockLineDashPercentageX10({})", (Object)value);
    }

    private void setupControls() {
        this.copyToCustom = false;
        this.blockDefaultColorButton.setBackground(this.ltdOptions.getBlockDefaultColor());
        this.blockOccupiedColorButton.setBackground(this.ltdOptions.getBlockOccupiedColor());
        this.blockAlternativeColorButton.setBackground(this.ltdOptions.getBlockAlternativeColor());
        this.mainBallastColorButton.setBackground(this.ltdOptions.getMainBallastColor());
        this.mainBallastWidthSpinner.setValue(this.ltdOptions.getMainBallastWidth());
        this.mainBlockLineDashPercentageX10Spinner.setValue(this.ltdOptions.getMainBlockLineDashPercentageX10());
        this.mainBlockLineWidthSpinner.setValue(this.ltdOptions.getMainBlockLineWidth());
        this.mainRailColorButton.setBackground(this.ltdOptions.getMainRailColor());
        this.mainRailCountSpinner.setValue(this.ltdOptions.getMainRailCount());
        this.mainRailGapSpinner.setValue(this.ltdOptions.getMainRailGap());
        this.mainRailWidthSpinner.setValue(this.ltdOptions.getMainRailWidth());
        this.mainTieColorButton.setBackground(this.ltdOptions.getMainTieColor());
        this.mainTieGapSpinner.setValue(this.ltdOptions.getMainTieGap());
        this.mainTieLengthSpinner.setValue(this.ltdOptions.getMainTieLength());
        this.mainTieWidthSpinner.setValue(this.ltdOptions.getMainTieWidth());
        this.sideBallastColorButton.setBackground(this.ltdOptions.getSideBallastColor());
        this.sideBallastWidthSpinner.setValue(this.ltdOptions.getSideBallastWidth());
        this.sideBlockLineDashPercentageX10Spinner.setValue(this.ltdOptions.getSideBlockLineDashPercentageX10());
        this.sideBlockLineWidthSpinner.setValue(this.ltdOptions.getSideBlockLineWidth());
        this.sideRailColorButton.setBackground(this.ltdOptions.getSideRailColor());
        this.sideRailCountSpinner.setValue(this.ltdOptions.getSideRailCount());
        this.sideRailGapSpinner.setValue(this.ltdOptions.getSideRailGap());
        this.sideRailWidthSpinner.setValue(this.ltdOptions.getSideRailWidth());
        this.sideTieColorButton.setBackground(this.ltdOptions.getSideTieColor());
        this.sideTieGapSpinner.setValue(this.ltdOptions.getSideTieGap());
        this.sideTieLengthSpinner.setValue(this.ltdOptions.getSideTieLength());
        this.sideTieWidthSpinner.setValue(this.ltdOptions.getSideTieWidth());
        this.copyToCustom = true;
    }

    private void makeCustomPreset() {
        if (this.copyToCustom && !this.ltdOptions.getName().equals(this.customPresetName)) {
            this.ltdOptions = new LayoutTrackDrawingOptions(this.ltdOptions);
            this.ltdOptions.setName(this.customPresetName);
            if (!this.ltdoList.get(this.ltdoList.size() - 1).getName().equals(this.customPresetName)) {
                this.ltdoList.add(this.ltdOptions);
                this.presetsComboBox.addItem(this.ltdOptions.getName());
            }
            this.presetsComboBox.setSelectedItem(this.ltdOptions.getName());
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(this.customPresetName));
        }
    }

    private void definePresets() {
        LayoutTrackDrawingOptions tempLTDO = new LayoutTrackDrawingOptions(this.classicPresetName);
        tempLTDO.setMainBallastColor(Color.BLACK);
        tempLTDO.setMainBallastWidth(0);
        tempLTDO.setMainBlockLineDashPercentageX10(0);
        tempLTDO.setMainBlockLineWidth(4);
        tempLTDO.setMainRailColor(Color.BLACK);
        tempLTDO.setMainRailCount(1);
        tempLTDO.setMainRailGap(0);
        tempLTDO.setMainRailWidth(2);
        tempLTDO.setMainTieColor(Color.BLACK);
        tempLTDO.setMainTieGap(0);
        tempLTDO.setMainTieLength(0);
        tempLTDO.setMainTieWidth(0);
        tempLTDO.setSideBallastColor(Color.BLACK);
        tempLTDO.setSideBallastWidth(0);
        tempLTDO.setSideBlockLineDashPercentageX10(0);
        tempLTDO.setSideBlockLineWidth(2);
        tempLTDO.setSideRailColor(Color.BLACK);
        tempLTDO.setSideRailCount(1);
        tempLTDO.setSideRailGap(0);
        tempLTDO.setSideRailWidth(1);
        tempLTDO.setSideTieColor(Color.BLACK);
        tempLTDO.setSideTieGap(0);
        tempLTDO.setSideTieLength(0);
        tempLTDO.setSideTieWidth(0);
        tempLTDO.setBlockDefaultColor(Color.GRAY);
        tempLTDO.setBlockOccupiedColor(Color.RED);
        tempLTDO.setBlockAlternativeColor(Color.WHITE);
        this.ltdoList.add(tempLTDO);
        tempLTDO = new LayoutTrackDrawingOptions(this.draftingPresetName);
        tempLTDO.setMainBallastColor(Color.BLACK);
        tempLTDO.setMainBallastWidth(0);
        tempLTDO.setMainBlockLineDashPercentageX10(0);
        tempLTDO.setMainBlockLineWidth(4);
        tempLTDO.setMainRailColor(Color.BLACK);
        tempLTDO.setMainRailCount(2);
        tempLTDO.setMainRailGap(2);
        tempLTDO.setMainRailWidth(2);
        tempLTDO.setMainTieColor(Color.BLACK);
        tempLTDO.setMainTieGap(0);
        tempLTDO.setMainTieLength(0);
        tempLTDO.setMainTieWidth(0);
        tempLTDO.setSideBallastColor(Color.BLACK);
        tempLTDO.setSideBallastWidth(0);
        tempLTDO.setSideBlockLineDashPercentageX10(0);
        tempLTDO.setSideBlockLineWidth(4);
        tempLTDO.setSideRailColor(Color.BLACK);
        tempLTDO.setSideRailCount(2);
        tempLTDO.setSideRailGap(3);
        tempLTDO.setSideRailWidth(1);
        tempLTDO.setSideTieColor(Color.BLACK);
        tempLTDO.setSideTieGap(0);
        tempLTDO.setSideTieLength(0);
        tempLTDO.setSideTieWidth(0);
        tempLTDO.setBlockDefaultColor(Color.GRAY);
        tempLTDO.setBlockOccupiedColor(Color.RED);
        tempLTDO.setBlockAlternativeColor(Color.WHITE);
        this.ltdoList.add(tempLTDO);
        tempLTDO = new LayoutTrackDrawingOptions(this.realisticPresetName);
        tempLTDO.setMainBallastColor(Color.decode("#A0A0A0"));
        tempLTDO.setMainBallastWidth(13);
        tempLTDO.setMainBlockLineDashPercentageX10(0);
        tempLTDO.setMainBlockLineWidth(2);
        tempLTDO.setMainRailColor(Color.decode("#C0C0C0"));
        tempLTDO.setMainRailCount(2);
        tempLTDO.setMainRailGap(3);
        tempLTDO.setMainRailWidth(2);
        tempLTDO.setMainTieColor(Color.decode("#E0E0E0"));
        tempLTDO.setMainTieGap(7);
        tempLTDO.setMainTieLength(11);
        tempLTDO.setMainTieWidth(1);
        tempLTDO.setSideBallastColor(Color.GRAY);
        tempLTDO.setSideBallastWidth(11);
        tempLTDO.setSideBlockLineDashPercentageX10(0);
        tempLTDO.setSideBlockLineWidth(2);
        tempLTDO.setSideRailColor(Color.decode("#D07060"));
        tempLTDO.setSideRailCount(2);
        tempLTDO.setSideRailGap(3);
        tempLTDO.setSideRailWidth(1);
        tempLTDO.setSideTieColor(Color.decode("#382018"));
        tempLTDO.setSideTieGap(6);
        tempLTDO.setSideTieLength(9);
        tempLTDO.setSideTieWidth(3);
        tempLTDO.setBlockDefaultColor(Color.GRAY);
        tempLTDO.setBlockOccupiedColor(Color.RED);
        tempLTDO.setBlockAlternativeColor(Color.WHITE);
        this.ltdoList.add(tempLTDO);
        tempLTDO = new LayoutTrackDrawingOptions(this.realisticOhPresetName);
        tempLTDO.setMainBallastColor(Color.decode("#A0A0A0"));
        tempLTDO.setMainBallastWidth(26);
        tempLTDO.setMainBlockLineDashPercentageX10(0);
        tempLTDO.setMainBlockLineWidth(4);
        tempLTDO.setMainRailColor(Color.LIGHT_GRAY);
        tempLTDO.setMainRailCount(3);
        tempLTDO.setMainRailGap(6);
        tempLTDO.setMainRailWidth(2);
        tempLTDO.setMainTieColor(Color.decode("#E0E0E0"));
        tempLTDO.setMainTieGap(14);
        tempLTDO.setMainTieLength(22);
        tempLTDO.setMainTieWidth(2);
        tempLTDO.setSideBallastColor(Color.GRAY);
        tempLTDO.setSideBallastWidth(22);
        tempLTDO.setSideBlockLineDashPercentageX10(0);
        tempLTDO.setSideBlockLineWidth(4);
        tempLTDO.setSideRailColor(Color.decode("#D07060"));
        tempLTDO.setSideRailCount(3);
        tempLTDO.setSideRailGap(6);
        tempLTDO.setSideRailWidth(2);
        tempLTDO.setSideTieColor(Color.decode("#382018"));
        tempLTDO.setSideTieGap(12);
        tempLTDO.setSideTieLength(18);
        tempLTDO.setSideTieWidth(6);
        tempLTDO.setBlockDefaultColor(Color.GRAY);
        tempLTDO.setBlockOccupiedColor(Color.RED);
        tempLTDO.setBlockAlternativeColor(Color.WHITE);
        this.ltdoList.add(tempLTDO);
        tempLTDO = new LayoutTrackDrawingOptions(this.british70sPresetName);
        tempLTDO.setMainBallastColor(Color.BLACK);
        tempLTDO.setMainBallastWidth(5);
        tempLTDO.setMainBlockLineDashPercentageX10(5);
        tempLTDO.setMainBlockLineWidth(4);
        tempLTDO.setMainRailColor(Color.BLACK);
        tempLTDO.setMainRailCount(0);
        tempLTDO.setMainRailGap(0);
        tempLTDO.setMainRailWidth(2);
        tempLTDO.setMainTieColor(Color.BLACK);
        tempLTDO.setMainTieGap(0);
        tempLTDO.setMainTieLength(0);
        tempLTDO.setMainTieWidth(0);
        tempLTDO.setSideBallastColor(Color.BLACK);
        tempLTDO.setSideBallastWidth(3);
        tempLTDO.setSideBlockLineDashPercentageX10(5);
        tempLTDO.setSideBlockLineWidth(2);
        tempLTDO.setSideRailColor(Color.BLACK);
        tempLTDO.setSideRailCount(0);
        tempLTDO.setSideRailGap(0);
        tempLTDO.setSideRailWidth(1);
        tempLTDO.setSideTieColor(Color.BLACK);
        tempLTDO.setSideTieGap(0);
        tempLTDO.setSideTieLength(0);
        tempLTDO.setSideTieWidth(0);
        tempLTDO.setBlockDefaultColor(Color.GRAY);
        tempLTDO.setBlockOccupiedColor(Color.RED);
        tempLTDO.setBlockAlternativeColor(Color.WHITE);
        this.ltdoList.add(tempLTDO);
        tempLTDO = new LayoutTrackDrawingOptions(this.csdazd71PresetName);
        tempLTDO.setMainBallastColor(Color.decode("#000000"));
        tempLTDO.setMainBallastWidth(0);
        tempLTDO.setMainBlockLineDashPercentageX10(6);
        tempLTDO.setMainBlockLineWidth(6);
        tempLTDO.setMainRailColor(Color.decode("#000000"));
        tempLTDO.setMainRailCount(1);
        tempLTDO.setMainRailGap(0);
        tempLTDO.setMainRailWidth(10);
        tempLTDO.setMainTieColor(Color.decode("#000000"));
        tempLTDO.setMainTieGap(0);
        tempLTDO.setMainTieLength(0);
        tempLTDO.setMainTieWidth(0);
        tempLTDO.setSideBallastColor(Color.decode("#000000"));
        tempLTDO.setSideBallastWidth(0);
        tempLTDO.setSideBlockLineDashPercentageX10(6);
        tempLTDO.setSideBlockLineWidth(6);
        tempLTDO.setSideRailColor(Color.decode("#000000"));
        tempLTDO.setSideRailCount(1);
        tempLTDO.setSideRailGap(0);
        tempLTDO.setSideRailWidth(10);
        tempLTDO.setSideTieColor(Color.decode("#000000"));
        tempLTDO.setSideTieGap(0);
        tempLTDO.setSideTieLength(0);
        tempLTDO.setSideTieWidth(0);
        tempLTDO.setBlockDefaultColor(Color.decode("#606060"));
        tempLTDO.setBlockOccupiedColor(Color.decode("#E00000"));
        tempLTDO.setBlockAlternativeColor(Color.decode("#FFFFE0"));
        this.ltdoList.add(tempLTDO);
        this.ltdoList.add(this.ltdOptions);
        this.presetsComboBox.removeAllItems();
        this.ltdoList.forEach(ltdo -> this.presetsComboBox.addItem(ltdo.getName()));
        this.presetsComboBox.setSelectedItem(this.leLTDOptions.getName());
    }
}

