/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.UserPreferencesManager;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutDoubleSlip;
import jmri.jmrit.display.layoutEditor.LayoutDoubleXOver;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutDoubleSlipEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutDoubleXOverEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutLHTurnoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutLHXOverEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutRHTurnoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutRHXOverEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutSingleSlipEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutSlipEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTurnoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTurntableEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutWyeEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutXOverEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LevelXingEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.PositionablePointEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.TrackSegmentEditor;
import jmri.jmrit.display.layoutEditor.LayoutLHTurnout;
import jmri.jmrit.display.layoutEditor.LayoutLHXOver;
import jmri.jmrit.display.layoutEditor.LayoutRHTurnout;
import jmri.jmrit.display.layoutEditor.LayoutRHXOver;
import jmri.jmrit.display.layoutEditor.LayoutSingleSlip;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LayoutWye;
import jmri.jmrit.display.layoutEditor.LayoutXOver;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.entryexit.EntryExitPairs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LayoutTrackEditor {
    protected final LayoutEditor layoutEditor;
    List<String> sensorList = new ArrayList<String>();
    private static final Logger log = LoggerFactory.getLogger(LayoutTrackEditor.class);

    public LayoutTrackEditor(@Nonnull LayoutEditor layoutEditor) {
        this.layoutEditor = layoutEditor;
    }

    @Nonnull
    public static LayoutTrackEditor makeTrackEditor(@Nonnull LayoutTrack layoutTrack, @Nonnull LayoutEditor layoutEditor) {
        if (layoutTrack instanceof LayoutTurnout) {
            if (layoutTrack instanceof LayoutRHTurnout) {
                return new LayoutRHTurnoutEditor(layoutEditor);
            }
            if (layoutTrack instanceof LayoutLHTurnout) {
                return new LayoutLHTurnoutEditor(layoutEditor);
            }
            if (layoutTrack instanceof LayoutWye) {
                return new LayoutWyeEditor(layoutEditor);
            }
            if (layoutTrack instanceof LayoutXOver) {
                if (layoutTrack instanceof LayoutRHXOver) {
                    return new LayoutRHXOverEditor(layoutEditor);
                }
                if (layoutTrack instanceof LayoutLHXOver) {
                    return new LayoutLHXOverEditor(layoutEditor);
                }
                if (layoutTrack instanceof LayoutDoubleXOver) {
                    return new LayoutDoubleXOverEditor(layoutEditor);
                }
                return new LayoutXOverEditor(layoutEditor);
            }
            if (layoutTrack instanceof LayoutSlip) {
                if (layoutTrack instanceof LayoutSingleSlip) {
                    return new LayoutSingleSlipEditor(layoutEditor);
                }
                if (layoutTrack instanceof LayoutDoubleSlip) {
                    return new LayoutDoubleSlipEditor(layoutEditor);
                }
                return new LayoutSlipEditor(layoutEditor);
            }
            return new LayoutTurnoutEditor(layoutEditor);
        }
        if (layoutTrack instanceof TrackSegment) {
            return new TrackSegmentEditor(layoutEditor);
        }
        if (layoutTrack instanceof PositionablePoint) {
            return new PositionablePointEditor(layoutEditor);
        }
        if (layoutTrack instanceof LevelXing) {
            return new LevelXingEditor(layoutEditor);
        }
        if (layoutTrack instanceof LayoutTurntable) {
            return new LayoutTurntableEditor(layoutEditor);
        }
        log.error("makeTrackEditor did not match type of {}", (Object)layoutTrack, (Object)new Exception("traceback"));
        return new LayoutTrackEditor(layoutEditor){

            @Override
            public void editLayoutTrack(@Nonnull LayoutTrackView layoutTrackView) {
                log.error("Not a valid LayoutTrackEditor implementation", (Throwable)new Exception("traceback"));
            }
        };
    }

    public abstract void editLayoutTrack(@Nonnull LayoutTrackView var1);

    protected void addDoneCancelButtons(JPanel target, JRootPane rp, ActionListener doneCallback, ActionListener cancelCallback) {
        JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
        target.add(doneButton);
        doneButton.addActionListener(doneCallback);
        doneButton.setToolTipText(Bundle.getMessage("DoneHint", Bundle.getMessage("ButtonDone")));
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        target.add(cancelButton);
        cancelButton.addActionListener(cancelCallback);
        cancelButton.setToolTipText(Bundle.getMessage("CancelHint", Bundle.getMessage("ButtonCancel")));
        rp.setDefaultButton(doneButton);
        rp.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "close");
    }

    @InvokeOnGuiThread
    void showSensorMessage() {
        if (this.sensorList.isEmpty()) {
            return;
        }
        StringBuilder msg = new StringBuilder(Bundle.getMessage("BlockSensorLine1"));
        msg.append(Bundle.getMessage("BlockSensorLine2"));
        String chkDup = "";
        this.sensorList.sort(null);
        for (String sName : this.sensorList) {
            if (!sName.equals(chkDup)) {
                msg.append("<br>&nbsp;&nbsp;&nbsp; " + sName);
            }
            chkDup = sName;
        }
        msg.append("<br>&nbsp;</html>");
        InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("BlockSensorTitle"), msg.toString(), "jmri.jmrit.display.EditorManager", "skipEntryExitDialog");
    }

    boolean hasNxSensorPairs(LayoutBlock loBlk) {
        if (loBlk == null) {
            return false;
        }
        List<String> blockSensors = InstanceManager.getDefault(EntryExitPairs.class).layoutBlockSensors(loBlk);
        if (blockSensors.isEmpty()) {
            return false;
        }
        this.sensorList.addAll(blockSensors);
        return true;
    }
}

