/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTrackEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LayoutTurntableView;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTurntableEditor
extends LayoutTrackEditor {
    private LayoutTurntable layoutTurntable = null;
    private LayoutTurntableView layoutTurntableView = null;
    private JmriJFrame editLayoutTurntableFrame = null;
    private final JTextField editLayoutTurntableRadiusTextField = new JTextField(8);
    private final JTextField editLayoutTurntableAngleTextField = new JTextField(8);
    private final NamedBeanComboBox<Block> editLayoutTurntableBlockNameComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private JButton editLayoutTurntableSegmentEditBlockButton;
    private JPanel editLayoutTurntableRayPanel;
    private JButton editLayoutTurntableAddRayTrackButton;
    private JCheckBox editLayoutTurntableDccControlledCheckBox;
    private String editLayoutTurntableOldRadius = "";
    private boolean editLayoutTurntableOpen = false;
    private boolean editLayoutTurntableNeedsRedraw = false;
    private final List<Turnout> turntableTurnouts = new ArrayList<Turnout>();
    private static final Logger log = LoggerFactory.getLogger(LayoutTurntableEditor.class);

    public LayoutTurntableEditor(@Nonnull LayoutEditor layoutEditor) {
        super(layoutEditor);
    }

    @Override
    public void editLayoutTrack(@Nonnull LayoutTrackView layoutTrackView) {
        Block blk;
        if (layoutTrackView instanceof LayoutTurntableView) {
            this.layoutTurntableView = (LayoutTurntableView)layoutTrackView;
            this.layoutTurntable = this.layoutTurntableView.getTurntable();
        } else {
            log.error("editLayoutTrack called with wrong type {}", (Object)layoutTrackView, (Object)new Exception("traceback"));
        }
        this.sensorList.clear();
        if (this.editLayoutTurntableOpen) {
            this.editLayoutTurntableFrame.setVisible(true);
        } else if (this.editLayoutTurntableFrame == null) {
            this.editLayoutTurntableFrame = new JmriJFrame(Bundle.getMessage("EditTurntable"), false, true);
            this.editLayoutTurntableFrame.addHelpMenu("package.jmri.jmrit.display.EditTurntable", true);
            this.editLayoutTurntableFrame.setLocation(50, 30);
            Container contentPane = this.editLayoutTurntableFrame.getContentPane();
            JPanel headerPane = new JPanel();
            JPanel footerPane = new JPanel();
            headerPane.setLayout(new BoxLayout(headerPane, 1));
            footerPane.setLayout(new BoxLayout(footerPane, 1));
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)headerPane, "North");
            contentPane.add((Component)footerPane, "South");
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            JLabel radiusLabel = new JLabel(Bundle.getMessage("TurntableRadius"));
            panel1.add(radiusLabel);
            radiusLabel.setLabelFor(this.editLayoutTurntableRadiusTextField);
            panel1.add(this.editLayoutTurntableRadiusTextField);
            this.editLayoutTurntableRadiusTextField.setToolTipText(Bundle.getMessage("TurntableRadiusHint"));
            headerPane.add(panel1);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            JLabel rayAngleLabel = new JLabel(Bundle.getMessage("RayAngle"));
            panel2.add(rayAngleLabel);
            rayAngleLabel.setLabelFor(this.editLayoutTurntableAngleTextField);
            panel2.add(this.editLayoutTurntableAngleTextField);
            this.editLayoutTurntableAngleTextField.setToolTipText(Bundle.getMessage("RayAngleHint"));
            headerPane.add(panel2);
            JPanel panel2a = new JPanel();
            panel2a.setLayout(new FlowLayout());
            JLabel blockNameLabel = new JLabel(Bundle.getMessage("BlockID"));
            panel2a.add(blockNameLabel);
            blockNameLabel.setLabelFor(this.editLayoutTurntableBlockNameComboBox);
            LayoutEditor.setupComboBox(this.editLayoutTurntableBlockNameComboBox, false, true, true);
            this.editLayoutTurntableBlockNameComboBox.setToolTipText(Bundle.getMessage("EditBlockNameHint"));
            panel2a.add(this.editLayoutTurntableBlockNameComboBox);
            this.editLayoutTurntableSegmentEditBlockButton = new JButton(Bundle.getMessage("EditBlock", ""));
            panel2a.add(this.editLayoutTurntableSegmentEditBlockButton);
            this.editLayoutTurntableSegmentEditBlockButton.addActionListener(this::editLayoutTurntableEditBlockPressed);
            this.editLayoutTurntableSegmentEditBlockButton.setToolTipText(Bundle.getMessage("EditBlockHint", ""));
            headerPane.add(panel2a);
            JPanel panel3 = new JPanel();
            panel3.setLayout(new FlowLayout());
            this.editLayoutTurntableAddRayTrackButton = new JButton(Bundle.getMessage("AddRayTrack"));
            panel3.add(this.editLayoutTurntableAddRayTrackButton);
            this.editLayoutTurntableAddRayTrackButton.setToolTipText(Bundle.getMessage("AddRayTrackHint"));
            this.editLayoutTurntableAddRayTrackButton.addActionListener(e -> {
                this.addRayTrackPressed(e);
                this.updateRayPanel();
            });
            this.editLayoutTurntableDccControlledCheckBox = new JCheckBox(Bundle.getMessage("TurntableDCCControlled"));
            panel3.add(this.editLayoutTurntableDccControlledCheckBox);
            headerPane.add(panel3);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            this.addDoneCancelButtons(panel5, this.editLayoutTurntableFrame.getRootPane(), this::editLayoutTurntableDonePressed, this::turntableEditCancelPressed);
            footerPane.add(panel5);
            this.editLayoutTurntableRayPanel = new JPanel();
            this.editLayoutTurntableRayPanel.setLayout(new BoxLayout(this.editLayoutTurntableRayPanel, 1));
            JScrollPane rayScrollPane = new JScrollPane(this.editLayoutTurntableRayPanel, 22, 30);
            contentPane.add((Component)rayScrollPane, "Center");
        }
        this.editLayoutTurntableBlockNameComboBox.setSelectedIndex(-1);
        LayoutBlock lb = this.layoutTurntable.getLayoutBlock();
        if (lb != null && (blk = lb.getBlock()) != null) {
            this.editLayoutTurntableBlockNameComboBox.setSelectedItem(blk);
        }
        this.editLayoutTurntableDccControlledCheckBox.setSelected(this.layoutTurntable.isTurnoutControlled());
        this.editLayoutTurntableDccControlledCheckBox.addActionListener(e -> {
            this.layoutTurntable.setTurnoutControlled(this.editLayoutTurntableDccControlledCheckBox.isSelected());
            for (Component comp : this.editLayoutTurntableRayPanel.getComponents()) {
                if (!(comp instanceof TurntableRayPanel)) continue;
                TurntableRayPanel trp = (TurntableRayPanel)comp;
                trp.showTurnoutDetails();
            }
            this.editLayoutTurntableFrame.pack();
        });
        this.updateRayPanel();
        this.editLayoutTurntableRadiusTextField.setText(" " + this.layoutTurntable.getRadius());
        this.editLayoutTurntableOldRadius = this.editLayoutTurntableRadiusTextField.getText();
        this.editLayoutTurntableAngleTextField.setText("0");
        this.editLayoutTurntableFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LayoutTurntableEditor.this.turntableEditCancelPressed(null);
            }
        });
        this.editLayoutTurntableFrame.pack();
        this.editLayoutTurntableFrame.setVisible(true);
        this.editLayoutTurntableOpen = true;
    }

    @InvokeOnGuiThread
    private void editLayoutTurntableEditBlockPressed(ActionEvent a) {
        LayoutBlock blockToEdit;
        String newName = this.editLayoutTurntableBlockNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (this.layoutTurntable.getBlockName().isEmpty() || !this.layoutTurntable.getBlockName().equals(newName)) {
            this.layoutTurntable.setLayoutBlock(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurntableNeedsRedraw = true;
        }
        if ((blockToEdit = this.layoutTurntable.getLayoutBlock()) == null) {
            JmriJOptionPane.showMessageDialog(this.editLayoutTurntableFrame, Bundle.getMessage("Error1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        blockToEdit.editLayoutBlock(this.editLayoutTurntableFrame);
        this.layoutEditor.setDirty();
        this.editLayoutTurntableNeedsRedraw = true;
    }

    private void updateRayPanel() {
        for (Component comp : this.editLayoutTurntableRayPanel.getComponents()) {
            this.editLayoutTurntableRayPanel.remove(comp);
        }
        this.turntableTurnouts.clear();
        for (LayoutTurntable.RayTrack rt : this.layoutTurntable.getRayTrackList()) {
            this.turntableTurnouts.add(rt.getTurnout());
        }
        this.editLayoutTurntableRayPanel.setLayout(new BoxLayout(this.editLayoutTurntableRayPanel, 1));
        for (LayoutTurntable.RayTrack rt : this.layoutTurntable.getRayTrackList()) {
            this.editLayoutTurntableRayPanel.add(new TurntableRayPanel(rt));
        }
        this.editLayoutTurntableRayPanel.revalidate();
        this.editLayoutTurntableRayPanel.repaint();
        this.editLayoutTurntableFrame.pack();
    }

    private void saveRayPanelDetail() {
        for (Component comp : this.editLayoutTurntableRayPanel.getComponents()) {
            if (!(comp instanceof TurntableRayPanel)) continue;
            TurntableRayPanel trp = (TurntableRayPanel)comp;
            trp.updateDetails();
        }
    }

    private void addRayTrackPressed(ActionEvent a) {
        double ang = 0.0;
        try {
            ang = Float.parseFloat(this.editLayoutTurntableAngleTextField.getText());
        }
        catch (Exception e) {
            JmriJOptionPane.showMessageDialog(this.editLayoutTurntableFrame, Bundle.getMessage("EntryError") + ": " + e + Bundle.getMessage("TryAgain"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.layoutTurntable.addRay(ang);
        this.layoutEditor.redrawPanel();
        this.layoutEditor.setDirty();
        this.editLayoutTurntableNeedsRedraw = false;
    }

    private void editLayoutTurntableDonePressed(ActionEvent a) {
        String str;
        String newName = this.editLayoutTurntableBlockNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (this.layoutTurntable.getBlockName().isEmpty() || !this.layoutTurntable.getBlockName().equals(newName)) {
            this.layoutTurntable.setLayoutBlock(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurntableNeedsRedraw = true;
        }
        if (!(str = this.editLayoutTurntableRadiusTextField.getText()).equals(this.editLayoutTurntableOldRadius)) {
            double rad = 0.0;
            try {
                rad = Float.parseFloat(str);
            }
            catch (Exception e) {
                JmriJOptionPane.showMessageDialog(this.editLayoutTurntableFrame, Bundle.getMessage("EntryError") + ": " + e + Bundle.getMessage("TryAgain"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            this.layoutTurntable.setRadius(rad);
            this.editLayoutTurntableNeedsRedraw = true;
        }
        this.editLayoutTurntableOpen = false;
        this.editLayoutTurntableFrame.setVisible(false);
        this.editLayoutTurntableFrame.dispose();
        this.editLayoutTurntableFrame = null;
        this.saveRayPanelDetail();
        if (this.editLayoutTurntableNeedsRedraw) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
            this.editLayoutTurntableNeedsRedraw = false;
        }
    }

    private void turntableEditCancelPressed(ActionEvent a) {
        this.editLayoutTurntableOpen = false;
        this.editLayoutTurntableFrame.setVisible(false);
        this.editLayoutTurntableFrame.dispose();
        this.editLayoutTurntableFrame = null;
        if (this.editLayoutTurntableNeedsRedraw) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
            this.editLayoutTurntableNeedsRedraw = false;
        }
    }

    public class TurntableRayPanel
    extends JPanel {
        private LayoutTurntable.RayTrack rayTrack = null;
        private final JPanel rayTurnoutPanel;
        private final NamedBeanComboBox<Turnout> turnoutNameComboBox;
        private final TitledBorder rayTitledBorder;
        private final JComboBox<String> rayTurnoutStateComboBox;
        private final JLabel rayTurnoutStateLabel;
        private final JTextField rayAngleTextField;
        private final int[] rayTurnoutStateValues = new int[]{2, 4};
        private final DecimalFormat twoDForm = new DecimalFormat("#.00");

        public TurntableRayPanel(LayoutTurntable.RayTrack rayTrack) {
            this.rayTrack = rayTrack;
            JPanel top = new JPanel();
            JLabel rayAngleLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("RayAngle")));
            top.add(rayAngleLabel);
            this.rayAngleTextField = new JTextField(5);
            top.add(this.rayAngleTextField);
            rayAngleLabel.setLabelFor(this.rayAngleTextField);
            this.rayAngleTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        Float.parseFloat(TurntableRayPanel.this.rayAngleTextField.getText());
                    }
                    catch (Exception ex) {
                        JmriJOptionPane.showMessageDialog(LayoutTurntableEditor.this.editLayoutTurntableFrame, Bundle.getMessage("EntryError") + ": " + ex + Bundle.getMessage("TryAgain"), Bundle.getMessage("ErrorTitle"), 0);
                    }
                }
            });
            this.setLayout(new BoxLayout(this, 1));
            this.add(top);
            this.turnoutNameComboBox = new NamedBeanComboBox(InstanceManager.getDefault(TurnoutManager.class));
            this.turnoutNameComboBox.setToolTipText(Bundle.getMessage("EditTurnoutToolTip"));
            LayoutEditor.setupComboBox(this.turnoutNameComboBox, false, true, false);
            this.turnoutNameComboBox.setSelectedItem(rayTrack.getTurnout());
            this.turnoutNameComboBox.addPopupMenuListener(LayoutTurntableEditor.this.layoutEditor.newTurnoutComboBoxPopupMenuListener(this.turnoutNameComboBox, LayoutTurntableEditor.this.turntableTurnouts));
            String turnoutStateThrown = InstanceManager.turnoutManagerInstance().getThrownText();
            String turnoutStateClosed = InstanceManager.turnoutManagerInstance().getClosedText();
            String[] turnoutStates = new String[]{turnoutStateClosed, turnoutStateThrown};
            this.rayTurnoutStateComboBox = new JComboBox<String>(turnoutStates);
            this.rayTurnoutStateLabel = new JLabel(Bundle.getMessage("TurnoutState"));
            this.rayTurnoutPanel = new JPanel();
            this.rayTurnoutPanel.setBorder(new EtchedBorder());
            this.rayTurnoutPanel.add(this.turnoutNameComboBox);
            this.rayTurnoutPanel.add(this.rayTurnoutStateLabel);
            this.rayTurnoutStateLabel.setLabelFor(this.rayTurnoutStateComboBox);
            this.rayTurnoutPanel.add(this.rayTurnoutStateComboBox);
            if (rayTrack.getTurnoutState() == 2) {
                this.rayTurnoutStateComboBox.setSelectedItem(turnoutStateClosed);
            } else {
                this.rayTurnoutStateComboBox.setSelectedItem(turnoutStateThrown);
            }
            this.add(this.rayTurnoutPanel);
            JButton deleteRayButton = new JButton(Bundle.getMessage("ButtonDelete"));
            top.add(deleteRayButton);
            deleteRayButton.setToolTipText(Bundle.getMessage("DeleteRayTrack"));
            deleteRayButton.addActionListener(e -> {
                this.delete();
                LayoutTurntableEditor.this.updateRayPanel();
            });
            this.rayTitledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
            this.setBorder(this.rayTitledBorder);
            this.showTurnoutDetails();
            this.rayAngleTextField.setText(this.twoDForm.format(rayTrack.getAngle()));
            this.rayTitledBorder.setTitle(Bundle.getMessage("Ray") + " : " + rayTrack.getConnectionIndex());
            if (rayTrack.getConnect() == null) {
                this.rayTitledBorder.setTitle(Bundle.getMessage("MakeLabel", Bundle.getMessage("Unconnected")) + " " + rayTrack.getConnectionIndex());
            } else if (rayTrack.getConnect().getLayoutBlock() != null) {
                this.rayTitledBorder.setTitle(Bundle.getMessage("MakeLabel", Bundle.getMessage("Connected")) + " " + rayTrack.getConnect().getLayoutBlock().getDisplayName());
            }
        }

        private void delete() {
            int n = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("Question7"), Bundle.getMessage("WarningTitle"), 0);
            if (n == 0) {
                LayoutTurntableEditor.this.layoutTurntable.deleteRay(this.rayTrack);
            }
        }

        private void updateDetails() {
            if (this.turnoutNameComboBox == null || this.rayTurnoutStateComboBox == null) {
                return;
            }
            String turnoutName = this.turnoutNameComboBox.getSelectedItemDisplayName();
            if (turnoutName == null) {
                turnoutName = "";
            }
            this.rayTrack.setTurnout(turnoutName, this.rayTurnoutStateValues[this.rayTurnoutStateComboBox.getSelectedIndex()]);
            if (!this.rayAngleTextField.getText().equals(this.twoDForm.format(this.rayTrack.getAngle()))) {
                try {
                    double ang = Float.parseFloat(this.rayAngleTextField.getText());
                    this.rayTrack.setAngle(ang);
                }
                catch (Exception e) {
                    log.error("Angle is not in correct format so will skip {}", (Object)this.rayAngleTextField.getText());
                }
            }
        }

        private void showTurnoutDetails() {
            boolean vis = LayoutTurntableEditor.this.layoutTurntable.isTurnoutControlled();
            this.rayTurnoutPanel.setVisible(vis);
            this.turnoutNameComboBox.setVisible(vis);
            this.rayTurnoutStateComboBox.setVisible(vis);
            this.rayTurnoutStateLabel.setVisible(vis);
        }
    }
}

