/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.InvokeOnGuiThread;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleTrackDiagramDialog {
    private LayoutEditor layoutEditor = null;
    private JmriJFrame scaleTrackDiagramFrame = null;
    private boolean scaleTrackDiagramOpen = false;
    private final JTextField xFactorField = new JTextField(6);
    private final JTextField yFactorField = new JTextField(6);
    private final JTextField xTranslateField = new JTextField(6);
    private final JTextField yTranslateField = new JTextField(6);
    private JButton scaleTrackDiagramDone;
    private JButton scaleTrackDiagramCancel;
    private static final Logger log = LoggerFactory.getLogger(ScaleTrackDiagramDialog.class);

    public ScaleTrackDiagramDialog(@Nonnull LayoutEditor thePanel) {
        this.layoutEditor = thePanel;
    }

    @InvokeOnGuiThread
    public void scaleTrackDiagram() {
        if (this.scaleTrackDiagramOpen) {
            this.scaleTrackDiagramFrame.setVisible(true);
            return;
        }
        if (this.scaleTrackDiagramFrame == null) {
            this.scaleTrackDiagramFrame = new JmriJFrame(Bundle.getMessage("ScaleTrackDiagram"));
            this.scaleTrackDiagramFrame.addHelpMenu("package.jmri.jmrit.display.ScaleTrackDiagram", true);
            this.scaleTrackDiagramFrame.setLocation(70, 30);
            Container theContentPane = this.scaleTrackDiagramFrame.getContentPane();
            theContentPane.setLayout(new BoxLayout(theContentPane, 3));
            JPanel panel31 = new JPanel();
            panel31.setLayout(new FlowLayout());
            JLabel xTranslateLabel = new JLabel(Bundle.getMessage("XTranslateLabel"));
            panel31.add(xTranslateLabel);
            xTranslateLabel.setLabelFor(this.xTranslateField);
            panel31.add(this.xTranslateField);
            this.xTranslateField.setToolTipText(Bundle.getMessage("XTranslateHint"));
            theContentPane.add(panel31);
            JPanel panel32 = new JPanel();
            panel32.setLayout(new FlowLayout());
            JLabel yTranslateLabel = new JLabel(Bundle.getMessage("YTranslateLabel"));
            panel32.add(yTranslateLabel);
            yTranslateLabel.setLabelFor(this.yTranslateField);
            panel32.add(this.yTranslateField);
            this.yTranslateField.setToolTipText(Bundle.getMessage("YTranslateHint"));
            theContentPane.add(panel32);
            JPanel panel33 = new JPanel();
            panel33.setLayout(new FlowLayout());
            JLabel message1Label = new JLabel(Bundle.getMessage("Message1Label"));
            panel33.add(message1Label);
            theContentPane.add(panel33);
            JPanel panel21 = new JPanel();
            panel21.setLayout(new FlowLayout());
            JLabel xFactorLabel = new JLabel(Bundle.getMessage("XFactorLabel"));
            panel21.add(xFactorLabel);
            xFactorLabel.setLabelFor(this.xFactorField);
            panel21.add(this.xFactorField);
            this.xFactorField.setToolTipText(Bundle.getMessage("FactorHint"));
            theContentPane.add(panel21);
            JPanel panel22 = new JPanel();
            panel22.setLayout(new FlowLayout());
            JLabel yFactorLabel = new JLabel(Bundle.getMessage("YFactorLabel"));
            panel22.add(yFactorLabel);
            yFactorLabel.setLabelFor(this.yFactorField);
            panel22.add(this.yFactorField);
            this.yFactorField.setToolTipText(Bundle.getMessage("FactorHint"));
            theContentPane.add(panel22);
            JPanel panel23 = new JPanel();
            panel23.setLayout(new FlowLayout());
            JLabel message2Label = new JLabel(Bundle.getMessage("Message2Label"));
            panel23.add(message2Label);
            theContentPane.add(panel23);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            this.scaleTrackDiagramDone = new JButton(Bundle.getMessage("ScaleTranslate"));
            panel5.add(this.scaleTrackDiagramDone);
            this.scaleTrackDiagramDone.addActionListener(this::scaleTrackDiagramDonePressed);
            this.scaleTrackDiagramDone.setToolTipText(Bundle.getMessage("ScaleTranslateHint"));
            this.scaleTrackDiagramCancel = new JButton(Bundle.getMessage("ButtonCancel"));
            panel5.add(this.scaleTrackDiagramCancel);
            this.scaleTrackDiagramCancel.addActionListener(this::scaleTrackDiagramCancelPressed);
            this.scaleTrackDiagramCancel.setToolTipText(Bundle.getMessage("CancelHint", Bundle.getMessage("ButtonCancel")));
            theContentPane.add(panel5);
            JRootPane rootPane = SwingUtilities.getRootPane(this.scaleTrackDiagramDone);
            rootPane.setDefaultButton(this.scaleTrackDiagramDone);
        }
        this.xFactorField.setText("1.0");
        this.yFactorField.setText("1.0");
        this.xTranslateField.setText("0");
        this.yTranslateField.setText("0");
        this.scaleTrackDiagramFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ScaleTrackDiagramDialog.this.scaleTrackDiagramCancelPressed(null);
            }
        });
        this.scaleTrackDiagramFrame.pack();
        this.scaleTrackDiagramFrame.setVisible(true);
        this.scaleTrackDiagramOpen = true;
    }

    private void scaleTrackDiagramDonePressed(@Nonnull ActionEvent event) {
        float yFactor;
        float xFactor;
        float yTranslation;
        float xTranslation;
        boolean changeFlag = false;
        boolean translateError = false;
        String newText = this.xTranslateField.getText().trim();
        try {
            xTranslation = Float.parseFloat(newText);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.scaleTrackDiagramFrame, e);
            return;
        }
        newText = this.yTranslateField.getText().trim();
        try {
            yTranslation = Float.parseFloat(newText);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.scaleTrackDiagramFrame, e);
            return;
        }
        newText = this.xFactorField.getText().trim();
        try {
            xFactor = Float.parseFloat(newText);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.scaleTrackDiagramFrame, e);
            return;
        }
        newText = this.yFactorField.getText().trim();
        try {
            yFactor = Float.parseFloat(newText);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.scaleTrackDiagramFrame, e);
            return;
        }
        if (xTranslation != 0.0f || yTranslation != 0.0f) {
            if (this.layoutEditor.translateTrack(xTranslation, yTranslation)) {
                changeFlag = true;
            } else {
                log.error("Error translating track diagram");
                translateError = true;
            }
        }
        if (!(translateError || (double)xFactor == 1.0 && (double)yFactor == 1.0)) {
            if (this.layoutEditor.scaleTrack(xFactor, yFactor)) {
                changeFlag = true;
            } else {
                log.error("Error scaling track diagram");
            }
        }
        this.layoutEditor.clearSelectionGroups();
        this.scaleTrackDiagramCancelPressed(null);
        if (changeFlag) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    private void scaleTrackDiagramCancelPressed(ActionEvent event) {
        this.scaleTrackDiagramOpen = false;
        this.scaleTrackDiagramFrame.setVisible(false);
        this.scaleTrackDiagramFrame.dispose();
        this.scaleTrackDiagramFrame = null;
    }

    private void showEntryErrorDialog(Component parentComponent, NumberFormatException e) {
        JmriJOptionPane.showMessageDialog(parentComponent, String.format("%s: %s %s", Bundle.getMessage("EntryError"), e, Bundle.getMessage("TryAgain")), Bundle.getMessage("ErrorTitle"), 0);
    }
}

