/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import jmri.Path;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutEditorAuxTools;
import jmri.jmrit.display.layoutEditor.LayoutShape;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurnoutView;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LayoutTurntableView;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.LevelXingView;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.PositionablePointView;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;

public interface LayoutModels {
    public boolean isDirty();

    public void setDirty();

    public void redrawPanel();

    @Nonnull
    public LayoutEditorAuxTools getLEAuxTools();

    @Nonnull
    public Stream<LayoutTrack> getLayoutTracksOfClass(Class<? extends LayoutTrack> var1);

    @Nonnull
    public Stream<LayoutTrackView> getLayoutTrackViewsOfClass(Class<? extends LayoutTrackView> var1);

    @Nonnull
    public List<PositionablePointView> getPositionablePointViews();

    @Nonnull
    public List<PositionablePoint> getPositionablePoints();

    @Nonnull
    public List<LayoutSlip> getLayoutSlips();

    @Nonnull
    public List<TrackSegmentView> getTrackSegmentViews();

    @Nonnull
    public List<TrackSegment> getTrackSegments();

    @Nonnull
    public List<LayoutTurnout> getLayoutTurnouts();

    @Nonnull
    public List<LayoutTurntable> getLayoutTurntables();

    @Nonnull
    public List<LevelXing> getLevelXings();

    @Nonnull
    public List<LevelXingView> getLevelXingViews();

    @Nonnull
    public List<LayoutTrack> getLayoutTracks();

    @Nonnull
    public List<LayoutTrackView> getLayoutTrackViews();

    public LayoutTrackView getLayoutTrackView(LayoutTrack var1);

    public LevelXingView getLevelXingView(LevelXing var1);

    public LayoutTurnoutView getLayoutTurnoutView(LayoutTurnout var1);

    public LayoutTurntableView getLayoutTurntableView(LayoutTurntable var1);

    public TrackSegmentView getTrackSegmentView(TrackSegment var1);

    public PositionablePointView getPositionablePointView(PositionablePoint var1);

    public void addLayoutTrack(@Nonnull LayoutTrack var1, @Nonnull LayoutTrackView var2);

    public void removeLayoutTrack(@Nonnull LayoutTrack var1);

    @Nonnull
    public List<LayoutTurnout> getLayoutTurnoutsAndSlips();

    @Nonnull
    public List<LayoutShape> getLayoutShapes();

    public int computeDirection(@Nonnull LayoutTrack var1, @Nonnull HitPointType var2, @Nonnull LayoutTrack var3, @Nonnull HitPointType var4);

    public int computeDirectionToCenter(@Nonnull LayoutTrack var1, @Nonnull HitPointType var2, @Nonnull PositionablePoint var3);

    public int computeDirectionFromCenter(@Nonnull PositionablePoint var1, @Nonnull LayoutTrack var2, @Nonnull HitPointType var3);

    default public int computeDirectionAB(@Nonnull LayoutTurnout track) {
        LayoutTurnoutView tv = this.getLayoutTurnoutView(track);
        return Path.computeDirection(tv.getCoordsA(), tv.getCoordsB());
    }

    default public int computeDirectionAC(@Nonnull LayoutTurnout track) {
        LayoutTurnoutView tv = this.getLayoutTurnoutView(track);
        return Path.computeDirection(tv.getCoordsA(), tv.getCoordsC());
    }

    default public int computeDirectionAD(@Nonnull LayoutTurnout track) {
        LayoutTurnoutView tv = this.getLayoutTurnoutView(track);
        return Path.computeDirection(tv.getCoordsA(), tv.getCoordsD());
    }

    default public int computeDirectionBC(@Nonnull LayoutTurnout track) {
        LayoutTurnoutView tv = this.getLayoutTurnoutView(track);
        return Path.computeDirection(tv.getCoordsB(), tv.getCoordsC());
    }

    default public int computeDirectionBD(@Nonnull LayoutTurnout track) {
        LayoutTurnoutView tv = this.getLayoutTurnoutView(track);
        return Path.computeDirection(tv.getCoordsB(), tv.getCoordsD());
    }

    default public int computeDirectionCD(@Nonnull LayoutTurnout track) {
        LayoutTurnoutView tv = this.getLayoutTurnoutView(track);
        return Path.computeDirection(tv.getCoordsC(), tv.getCoordsD());
    }

    default public void displayRemoveWarning(LayoutTrack track, List<String> itemList, String typeKey) {
        this.getLayoutTrackView(track).displayRemoveWarningDialog(itemList, typeKey);
    }
}

