/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.util.ColorUtil;
import jmri.util.MathUtil;
import jmri.util.QuickPromptUtil;
import jmri.util.swing.JmriColorChooser;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutShape {
    public static final int MAX_LINEWIDTH = 200;
    private LayoutEditor layoutEditor = null;
    private String name;
    private LayoutShapeType layoutShapeType;
    private int level = 3;
    private int lineWidth = 3;
    private Color lineColor = Color.BLACK;
    private Color fillColor = Color.DARK_GRAY;
    private boolean hidden = false;
    private final ArrayList<LayoutShapePoint> shapePoints;
    private JPopupMenu popup = null;
    private final JCheckBoxMenuItem hiddenCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("ShapeHiddenMenuItemTitle"));
    private static final Logger log = LoggerFactory.getLogger(LayoutShape.class);

    public LayoutShape(String name, LayoutEditor layoutEditor) {
        this.name = name;
        this.layoutEditor = layoutEditor;
        this.layoutShapeType = LayoutShapeType.Open;
        this.shapePoints = new ArrayList();
    }

    public LayoutShape(String name, LayoutShapeType t, LayoutEditor layoutEditor) {
        this(name, layoutEditor);
        this.layoutShapeType = t;
    }

    public LayoutShape(String name, Point2D c, LayoutEditor layoutEditor) {
        this(name, layoutEditor);
        this.shapePoints.add(new LayoutShapePoint(c));
    }

    public LayoutShape(LayoutShape layoutShape) {
        this(layoutShape.getName(), layoutShape.getLayoutEditor());
        this.setType(layoutShape.getType());
        this.setLevel(layoutShape.getLevel());
        this.setLineColor(layoutShape.getLineColor());
        this.setFillColor(layoutShape.getFillColor());
        for (LayoutShapePoint lsp : layoutShape.getPoints()) {
            this.shapePoints.add(new LayoutShapePoint(lsp.getType(), lsp.getPoint()));
        }
    }

    public String toString() {
        return String.format("LayoutShape %s", this.name);
    }

    public String getDisplayName() {
        return String.format("%s %s", Bundle.getMessage("LayoutShape"), this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public LayoutShapeType getType() {
        return this.layoutShapeType;
    }

    public void setType(LayoutShapeType t) {
        if (this.layoutShapeType != t) {
            switch (t) {
                case Open: 
                case Closed: 
                case Filled: {
                    this.layoutShapeType = t;
                    break;
                }
                default: {
                    log.error("Invalid Shape Type {}", (Object)t);
                }
            }
        }
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int w) {
        this.lineWidth = Math.max(0, w);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int l) {
        if (this.level != l) {
            this.level = l;
            this.layoutEditor.sortLayoutShapesByLevel();
        }
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.getLayoutEditor().redrawPanel();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public LayoutEditor getLayoutEditor() {
        return this.layoutEditor;
    }

    public void addPoint(Point2D p) {
        if (this.shapePoints.size() < this.getMaxNumberPoints()) {
            this.shapePoints.add(new LayoutShapePoint(p));
        }
    }

    public void addPoint(Point2D p, int nearIndex) {
        int cnt = this.shapePoints.size();
        if (cnt < this.getMaxNumberPoints()) {
            int beforeIndex;
            LayoutShapePoint lsp = this.shapePoints.get(nearIndex);
            Point2D sp = lsp.getPoint();
            int idxL = (nearIndex + cnt - 1) % cnt;
            LayoutShapePoint lspL = this.shapePoints.get(idxL);
            Point2D pL = lspL.getPoint();
            double distL = MathUtil.distance(p, pL);
            int idxR = (nearIndex + 1) % cnt;
            LayoutShapePoint lspR = this.shapePoints.get(idxR);
            Point2D pR = lspR.getPoint();
            double distR = MathUtil.distance(p, pR);
            if (this.getType() == LayoutShapeType.Open && nearIndex == 0) {
                distR = MathUtil.distance(pR, p);
                distL = MathUtil.distance(pR, sp);
            }
            int n = beforeIndex = distR < distL ? idxR : nearIndex;
            if (this.getType() == LayoutShapeType.Open && idxR == 0) {
                distR = MathUtil.distance(pL, p);
                int n2 = beforeIndex = distR < (distL = MathUtil.distance(pL, sp)) ? nearIndex : nearIndex + 1;
            }
            if (beforeIndex >= cnt) {
                this.shapePoints.add(new LayoutShapePoint(p));
            } else {
                this.shapePoints.add(beforeIndex, new LayoutShapePoint(p));
            }
        }
    }

    public void addPoint(LayoutShapePointType t, Point2D p) {
        if (this.shapePoints.size() < this.getMaxNumberPoints()) {
            this.shapePoints.add(new LayoutShapePoint(t, p));
        }
    }

    public void setPoint(int idx, Point2D p) {
        if (idx < this.shapePoints.size()) {
            this.shapePoints.get(idx).setPoint(p);
        }
    }

    public Point2D getPoint(int idx) {
        Point2D result = MathUtil.zeroPoint2D;
        if (idx < this.shapePoints.size()) {
            result = this.shapePoints.get(idx).getPoint();
        }
        return result;
    }

    public ArrayList<LayoutShapePoint> getPoints() {
        return this.shapePoints;
    }

    public int getNumberPoints() {
        return this.shapePoints.size();
    }

    public int getMaxNumberPoints() {
        return 10;
    }

    public Rectangle2D getBounds() {
        Rectangle2D result;
        if (!this.shapePoints.isEmpty()) {
            result = MathUtil.rectangleAtPoint(this.shapePoints.get(0).getPoint(), 1.0, 1.0);
            this.shapePoints.forEach(lsp -> result.add(lsp.getPoint()));
        } else {
            result = null;
        }
        return result;
    }

    protected HitPointType findHitPointType(@Nonnull Point2D hitPoint, boolean useRectangles) {
        HitPointType result = HitPointType.NONE;
        if (useRectangles) {
            Rectangle2D r = this.layoutEditor.layoutEditorControlRectAt(hitPoint);
            if (r.contains(this.getCoordsCenter())) {
                result = HitPointType.SHAPE_CENTER;
            }
            for (int idx = 0; idx < this.shapePoints.size(); ++idx) {
                if (!r.contains(this.shapePoints.get(idx).getPoint())) continue;
                result = HitPointType.shapePointIndexedValue(idx);
                break;
            }
        } else {
            double minDistance = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
            for (int idx = 0; idx < this.shapePoints.size(); ++idx) {
                double distance = MathUtil.distance(this.shapePoints.get(idx).getPoint(), hitPoint);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                result = HitPointType.shapePointIndexedValue(idx);
            }
        }
        return result;
    }

    public static boolean isShapeHitPointType(HitPointType t) {
        return t == HitPointType.SHAPE_CENTER || HitPointType.isShapePointOffsetHitPointType(t);
    }

    public Point2D getCoordsCenter() {
        Point2D sumPoint = MathUtil.zeroPoint2D();
        for (LayoutShapePoint lsp : this.shapePoints) {
            sumPoint = MathUtil.add(sumPoint, lsp.getPoint());
        }
        return MathUtil.divide(sumPoint, this.shapePoints.size());
    }

    public void setCoordsCenter(@Nonnull Point2D p) {
        Point2D factor = MathUtil.subtract(p, this.getCoordsCenter());
        if (!MathUtil.isEqualToZeroPoint2D(factor)) {
            this.shapePoints.forEach(lsp -> lsp.setPoint(MathUtil.add(factor, lsp.getPoint())));
        }
    }

    public void scaleCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        this.shapePoints.forEach(lsp -> lsp.setPoint(MathUtil.multiply(lsp.getPoint(), factor)));
    }

    public void translateCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        this.shapePoints.forEach(lsp -> lsp.setPoint(MathUtil.add(factor, lsp.getPoint())));
    }

    public void rotateCoords(double angleDEG) {
        Point2D center = this.getCoordsCenter();
        this.shapePoints.forEach(lsp -> lsp.setPoint(MathUtil.rotateDEG(lsp.getPoint(), center, angleDEG)));
    }

    @Nonnull
    protected JPopupMenu showShapePopUp(@CheckForNull JmriMouseEvent mouseEvent, final HitPointType hitPointType) {
        if (this.popup != null) {
            this.popup.removeAll();
        } else {
            this.popup = new JPopupMenu();
        }
        if (this.layoutEditor.isEditable()) {
            JMenuItem jmi = this.popup.add(Bundle.getMessage("ShapeNameMenuItemTitle", this.getName()));
            jmi.setToolTipText(Bundle.getMessage("ShapeNameMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                String newValue = QuickPromptUtil.promptForString(this.layoutEditor, Bundle.getMessage("LayoutShapeName"), Bundle.getMessage("LayoutShapeName"), this.name);
                LayoutEditorFindItems finder = this.layoutEditor.getFinder();
                if (finder.findLayoutShapeByName(newValue) == null) {
                    this.setName(newValue);
                    this.layoutEditor.repaint();
                } else {
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CanNotRename", Bundle.getMessage("Shape")), Bundle.getMessage("AlreadyExist", Bundle.getMessage("Shape")), 0);
                }
            });
            this.popup.add(new JSeparator(0));
            JMenu shapeTypeMenu = new JMenu(Bundle.getMessage("ChangeShapeTypeFromTo", this.getType().toString()));
            if (this.getType() != LayoutShapeType.Open) {
                jmi = shapeTypeMenu.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("ShapeTypeOpen")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutShape.this.setType(LayoutShapeType.Open);
                        LayoutShape.this.layoutEditor.repaint();
                    }
                }));
            }
            if (this.getType() != LayoutShapeType.Closed) {
                jmi = shapeTypeMenu.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("ShapeTypeClosed")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutShape.this.setType(LayoutShapeType.Closed);
                        LayoutShape.this.layoutEditor.repaint();
                    }
                }));
            }
            if (this.getType() != LayoutShapeType.Filled) {
                jmi = shapeTypeMenu.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("ShapeTypeFilled")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutShape.this.setType(LayoutShapeType.Filled);
                        LayoutShape.this.layoutEditor.repaint();
                    }
                }));
            }
            this.popup.add(shapeTypeMenu);
            if (hitPointType == HitPointType.SHAPE_CENTER) {
                JMenu shapePointTypeMenu = new JMenu(Bundle.getMessage("ChangeAllShapePointTypesTo"));
                jmi = shapePointTypeMenu.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("ShapePointTypeStraight")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (LayoutShapePoint ls : LayoutShape.this.shapePoints) {
                            ls.setType(LayoutShapePointType.Straight);
                        }
                        LayoutShape.this.layoutEditor.repaint();
                    }
                }));
                jmi = shapePointTypeMenu.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("ShapePointTypeCurve")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (LayoutShapePoint ls : LayoutShape.this.shapePoints) {
                            ls.setType(LayoutShapePointType.Curve);
                        }
                        LayoutShape.this.layoutEditor.repaint();
                    }
                }));
                this.popup.add(shapePointTypeMenu);
            } else {
                LayoutShapePoint lsp = this.shapePoints.get(hitPointType.shapePointIndex());
                if (lsp != null) {
                    String otherPointTypeName = lsp.getType() == LayoutShapePointType.Straight ? LayoutShapePointType.Curve.toString() : LayoutShapePointType.Straight.toString();
                    jmi = this.popup.add(Bundle.getMessage("ChangeShapePointTypeFromTo", lsp.getType().toString(), otherPointTypeName));
                    jmi.addActionListener(e3 -> {
                        switch (lsp.getType()) {
                            case Straight: {
                                lsp.setType(LayoutShapePointType.Curve);
                                break;
                            }
                            case Curve: {
                                lsp.setType(LayoutShapePointType.Straight);
                                break;
                            }
                            default: {
                                log.error("unexpected enum member!");
                            }
                        }
                        this.layoutEditor.repaint();
                    });
                }
            }
            jmi = this.popup.add(new JMenuItem(Bundle.getMessage("MakeLabel", Bundle.getMessage("ShapeLevelMenuItemTitle")) + this.level));
            jmi.setToolTipText(Bundle.getMessage("ShapeLevelMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                int newValue = QuickPromptUtil.promptForInteger(this.layoutEditor, Bundle.getMessage("ShapeLevelMenuItemTitle"), Bundle.getMessage("ShapeLevelMenuItemTitle"), this.level, QuickPromptUtil.checkIntRange(1, 10, null));
                this.setLevel(newValue);
                this.layoutEditor.repaint();
            });
            jmi = this.popup.add(new JMenuItem(Bundle.getMessage("ShapeLineColorMenuItemTitle")));
            jmi.setToolTipText(Bundle.getMessage("ShapeLineColorMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                Color newColor = JmriColorChooser.showDialog(null, "Choose a color", this.lineColor);
                if (newColor != null && !newColor.equals(this.lineColor)) {
                    this.setLineColor(newColor);
                    this.layoutEditor.repaint();
                }
            });
            jmi.setForeground(this.lineColor);
            jmi.setBackground(ColorUtil.contrast(this.lineColor));
            if (this.getType() == LayoutShapeType.Filled) {
                jmi = this.popup.add(new JMenuItem(Bundle.getMessage("ShapeFillColorMenuItemTitle")));
                jmi.setToolTipText(Bundle.getMessage("ShapeFillColorMenuItemToolTip"));
                jmi.addActionListener(e3 -> {
                    Color newColor = JmriColorChooser.showDialog(null, "Choose a color", this.fillColor);
                    if (newColor != null && !newColor.equals(this.fillColor)) {
                        this.setFillColor(newColor);
                        this.layoutEditor.repaint();
                    }
                });
                jmi.setForeground(this.fillColor);
                jmi.setBackground(ColorUtil.contrast(this.fillColor));
            }
            jmi = this.popup.add(new JMenuItem(Bundle.getMessage("MakeLabel", Bundle.getMessage("ShapeLineWidthMenuItemTitle")) + this.lineWidth));
            jmi.setToolTipText(Bundle.getMessage("ShapeLineWidthMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                int newValue = QuickPromptUtil.promptForInteger(this.layoutEditor, Bundle.getMessage("ShapeLineWidthMenuItemTitle"), Bundle.getMessage("ShapeLineWidthMenuItemTitle"), this.lineWidth, QuickPromptUtil.checkIntRange(1, 200, null));
                this.setLineWidth(newValue);
                this.layoutEditor.repaint();
            });
            this.popup.add(new JSeparator(0));
            if (hitPointType == HitPointType.SHAPE_CENTER) {
                jmi = this.popup.add(new AbstractAction(Bundle.getMessage("ShapeDuplicateMenuItemTitle")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutShape ls = new LayoutShape(LayoutShape.this);
                        ls.setName(LayoutShape.this.layoutEditor.getFinder().uniqueName("S"));
                        double gridSize = LayoutShape.this.layoutEditor.gContext.getGridSize();
                        Point2D.Double delta = new Point2D.Double(gridSize, gridSize);
                        for (LayoutShapePoint lsp : ls.getPoints()) {
                            lsp.setPoint(MathUtil.add(lsp.getPoint(), delta));
                        }
                        LayoutShape.this.layoutEditor.getLayoutShapes().add(ls);
                        LayoutShape.this.layoutEditor.clearSelectionGroups();
                        LayoutShape.this.layoutEditor.amendSelectionGroup(ls);
                    }
                });
                jmi.setToolTipText(Bundle.getMessage("ShapeDuplicateMenuItemToolTip"));
                this.popup.add(this.hiddenCheckBoxMenuItem);
                this.hiddenCheckBoxMenuItem.addActionListener(e3 -> this.setHidden(this.hiddenCheckBoxMenuItem.isSelected()));
                this.hiddenCheckBoxMenuItem.setToolTipText(Bundle.getMessage("ShapeHiddenMenuItemToolTip"));
                this.hiddenCheckBoxMenuItem.setSelected(this.isHidden());
                this.popup.add(new AbstractAction(Bundle.getMessage("ButtonDelete")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutShape.this.removeShape();
                    }
                });
            } else {
                this.popup.add(new AbstractAction(Bundle.getMessage("ButtonDelete")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (LayoutShape.this.shapePoints.size() == 1) {
                            LayoutShape.this.removeShape();
                        } else {
                            LayoutShape.this.shapePoints.remove(hitPointType.shapePointIndex());
                            LayoutShape.this.layoutEditor.repaint();
                        }
                    }
                });
            }
            if (mouseEvent != null) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
        return this.popup;
    }

    void removeShape() {
        if (this.layoutEditor.removeLayoutShape(this)) {
            this.remove();
            this.dispose();
        }
    }

    void dispose() {
        if (this.popup != null) {
            this.popup.removeAll();
        }
        this.popup = null;
    }

    void remove() {
    }

    protected void draw(Graphics2D g2) {
        if (this.isHidden()) {
            return;
        }
        GeneralPath path = new GeneralPath();
        int cnt = this.shapePoints.size();
        block4: for (int idx = 0; idx < cnt; ++idx) {
            LayoutShapePoint lsp = this.shapePoints.get(idx);
            Point2D p = lsp.getPoint();
            int idxL = (idx + cnt - 1) % cnt;
            LayoutShapePoint lspL = this.shapePoints.get(idxL);
            Point2D pL = lspL.getPoint();
            Point2D midL = MathUtil.midPoint(pL, p);
            int idxR = (idx + 1) % cnt;
            LayoutShapePoint lspR = this.shapePoints.get(idxR);
            Point2D pR = lspR.getPoint();
            Point2D midR = MathUtil.midPoint(p, pR);
            LayoutShapePointType lspt = lsp.getType();
            if (this.getType() == LayoutShapeType.Open && (idx == 0 || idxR == 0)) {
                lspt = LayoutShapePointType.Straight;
            }
            switch (lspt) {
                case Straight: {
                    if (idx == 0) {
                        if (this.getType() == LayoutShapeType.Open) {
                            path.moveTo(p.getX(), p.getY());
                        } else {
                            path.moveTo(midL.getX(), midL.getY());
                            path.lineTo(p.getX(), p.getY());
                        }
                    } else {
                        path.lineTo(midL.getX(), midL.getY());
                        path.lineTo(p.getX(), p.getY());
                    }
                    if (idxR == 0 && this.getType() == LayoutShapeType.Open) continue block4;
                    path.lineTo(midR.getX(), midR.getY());
                    continue block4;
                }
                case Curve: {
                    if (idx == 0) {
                        path.moveTo(midL.getX(), midL.getY());
                    }
                    path.quadTo(p.getX(), p.getY(), midR.getX(), midR.getY());
                    continue block4;
                }
                default: {
                    log.error("unexpected enum member!");
                }
            }
        }
        if (this.getType() == LayoutShapeType.Filled) {
            g2.setColor(this.fillColor);
            g2.fill(path);
        }
        g2.setStroke(new BasicStroke(this.lineWidth, 1, 1));
        g2.setColor(this.lineColor);
        g2.draw(path);
    }

    protected void drawEditControls(Graphics2D g2) {
        Color backgroundColor = this.layoutEditor.getBackground();
        Color controlsColor = ColorUtil.contrast(backgroundColor);
        controlsColor = ColorUtil.setAlpha(controlsColor, 0.5);
        g2.setColor(controlsColor);
        this.shapePoints.forEach(slp -> g2.draw(this.layoutEditor.layoutEditorControlRectAt(slp.getPoint())));
        if (!this.shapePoints.isEmpty()) {
            Point2D end0;
            Point2D end1 = end0 = this.shapePoints.get(0).getPoint();
            for (LayoutShapePoint lsp : this.shapePoints) {
                Point2D end2 = lsp.getPoint();
                g2.draw(new Line2D.Double(end1, end2));
                end1 = end2;
            }
            if (this.getType() != LayoutShapeType.Open) {
                g2.draw(new Line2D.Double(end1, end0));
            }
        }
        g2.draw(this.trackEditControlCircleAt(this.getCoordsCenter()));
    }

    public Ellipse2D trackEditControlCircleAt(@Nonnull Point2D inPoint) {
        return this.trackControlCircleAt(inPoint);
    }

    public Ellipse2D trackControlCircleAt(@Nonnull Point2D inPoint) {
        return new Ellipse2D.Double(inPoint.getX() - this.layoutEditor.circleRadius, inPoint.getY() - this.layoutEditor.circleRadius, this.layoutEditor.circleDiameter, this.layoutEditor.circleDiameter);
    }

    public static enum LayoutShapePointType {
        Straight,
        Curve;

    }

    public static enum LayoutShapeType {
        Open,
        Closed,
        Filled;

    }

    public static class LayoutShapePoint {
        private LayoutShapePointType type = LayoutShapePointType.Straight;
        private Point2D point;

        public LayoutShapePoint(Point2D c) {
            this.point = c;
        }

        public LayoutShapePoint(LayoutShapePointType t, Point2D c) {
            this(c);
            this.type = t;
        }

        public LayoutShapePointType getType() {
            return this.type;
        }

        public void setType(LayoutShapePointType type) {
            this.type = type;
        }

        public Point2D getPoint() {
            return this.point;
        }

        public void setPoint(Point2D point) {
            this.point = point;
        }
    }
}

