/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalMast;
import jmri.SignalMastLogicManager;
import jmri.Turnout;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LayoutSlip
extends LayoutTurnout {
    public int currentState = 1;
    private String turnoutBName = "";
    private NamedBeanHandle<Turnout> namedTurnoutB = null;
    private PropertyChangeListener mTurnoutListener = null;
    HashMap<Integer, TurnoutState> turnoutStates = new LinkedHashMap<Integer, TurnoutState>(4);
    private static final Logger log = LoggerFactory.getLogger(LayoutSlip.class);

    public LayoutSlip(String id, LayoutEditor models, LayoutTurnout.TurnoutType type) {
        super(id, models, type);
        this.turnoutStates.put(2, new TurnoutState(2, 2));
        this.turnoutStates.put(6, new TurnoutState(2, 4));
        this.turnoutStates.put(4, new TurnoutState(4, 4));
        if (type == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
            this.turnoutStates.remove(8);
        } else if (type == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
            this.turnoutStates.put(8, new TurnoutState(4, 2));
        } else {
            log.error("{}.setSlipType({}); invalid slip type", (Object)this.getName(), (Object)type);
        }
    }

    @Override
    public String toString() {
        return String.format("LayoutSlip %s (%s)", this.getId(), this.getSlipStateString(this.getSlipState()));
    }

    public LayoutTurnout.TurnoutType getSlipType() {
        return this.type;
    }

    public int getSlipState() {
        return this.currentState;
    }

    public String getTurnoutBName() {
        if (this.namedTurnoutB != null) {
            return this.namedTurnoutB.getName();
        }
        return this.turnoutBName;
    }

    public Turnout getTurnoutB() {
        Turnout result = null;
        if (this.namedTurnoutB == null && !this.turnoutBName.isEmpty()) {
            this.setTurnoutB(this.turnoutBName);
        }
        if (this.namedTurnoutB != null) {
            result = this.namedTurnoutB.getBean();
        }
        return result;
    }

    public void setTurnoutB(@CheckForNull String tName) {
        boolean reactivate = false;
        if (this.namedTurnoutB != null) {
            this.deactivateTurnout();
            reactivate = this.namedTurnout != null;
        }
        this.turnoutBName = tName;
        Turnout turnout = null;
        if (this.turnoutBName != null && !this.turnoutBName.isEmpty()) {
            turnout = InstanceManager.turnoutManagerInstance().getTurnout(this.turnoutBName);
        }
        if (turnout != null) {
            this.namedTurnoutB = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this.turnoutBName, turnout);
            this.activateTurnout();
        } else {
            this.turnoutBName = "";
            this.namedTurnoutB = null;
        }
        if (reactivate) {
            this.activateTurnout();
        }
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) {
        switch (connectionType) {
            case SLIP_A: {
                return this.connectA;
            }
            case SLIP_B: {
                return this.connectB;
            }
            case SLIP_C: {
                return this.connectC;
            }
            case SLIP_D: {
                return this.connectD;
            }
        }
        String errString = MessageFormat.format("{0}.getConnection({1}); Invalid Connection Type", new Object[]{this.getName(), connectionType});
        log.error("will throw {}", (Object)errString);
        throw new IllegalArgumentException(errString);
    }

    @Override
    public void setConnection(HitPointType connectionType, @CheckForNull LayoutTrack o, HitPointType type) throws JmriException {
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        switch (connectionType) {
            case SLIP_A: {
                this.connectA = o;
                break;
            }
            case SLIP_B: {
                this.connectB = o;
                break;
            }
            case SLIP_C: {
                this.connectC = o;
                break;
            }
            case SLIP_D: {
                this.connectD = o;
                break;
            }
            default: {
                String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid Connection Type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
                log.error("will throw {}", (Object)errString);
                throw new JmriException(errString);
            }
        }
    }

    public String getDisplayName() {
        String name = "Slip " + this.getId();
        String tnA = this.getTurnoutName();
        String tnB = this.getTurnoutBName();
        if (tnA != null && !tnA.isEmpty()) {
            name = name + " (" + tnA;
        }
        if (tnB != null && !tnB.isEmpty()) {
            name = name.contains(" (") ? name + ", " : name + "(";
            name = name + tnB;
        }
        if (name.contains("(")) {
            name = name + ")";
        }
        return name;
    }

    String getSlipStateString(int slipState) {
        String result = Bundle.getMessage("BeanStateUnknown");
        switch (slipState) {
            case 2: {
                result = "AC";
                break;
            }
            case 4: {
                result = "BD";
                break;
            }
            case 6: {
                result = "AD";
                break;
            }
            case 8: {
                result = "BC";
                break;
            }
        }
        return result;
    }

    public void toggleState(HitPointType selectedPointType) {
        if (!(this.disabled || this.disableWhenOccupied && this.isOccupied())) {
            int newSlipState = this.getSlipState();
            block0 : switch (selectedPointType) {
                case SLIP_LEFT: {
                    switch (newSlipState) {
                        case 2: {
                            if (this.type == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                                newSlipState = 4;
                                break block0;
                            }
                            newSlipState = 8;
                            break block0;
                        }
                        case 6: {
                            newSlipState = 4;
                            break block0;
                        }
                        default: {
                            newSlipState = 2;
                            break block0;
                        }
                        case 4: 
                    }
                    newSlipState = 6;
                    break;
                }
                case SLIP_RIGHT: {
                    switch (newSlipState) {
                        case 2: {
                            newSlipState = 6;
                            break block0;
                        }
                        case 6: {
                            newSlipState = 2;
                            break block0;
                        }
                        default: {
                            newSlipState = 4;
                            break block0;
                        }
                        case 4: 
                    }
                    if (this.type == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                        newSlipState = 2;
                        break;
                    }
                    newSlipState = 8;
                    break;
                }
                default: {
                    LoggingUtil.warnOnce(log, "Unexpected selectedPointType = {}", new Object[]{selectedPointType});
                }
            }
            this.setSlipState(newSlipState);
        }
    }

    void setSlipState(int newSlipState) {
        if (this.disableWhenOccupied && this.isOccupied()) {
            log.debug("Turnout not changed as Block is Occupied");
        } else if (!this.disabled) {
            this.currentState = newSlipState;
            TurnoutState ts = this.turnoutStates.get(newSlipState);
            if (this.getTurnout() != null) {
                this.getTurnout().setCommandedState(ts.getTurnoutAState());
            }
            if (this.getTurnoutB() != null) {
                this.getTurnoutB().setCommandedState(ts.getTurnoutBState());
            }
        }
    }

    @Override
    boolean isOccupied() {
        Boolean result = false;
        switch (this.getSlipState()) {
            case 2: {
                result = this.getLayoutBlock().getOccupancy() == 2 || this.getLayoutBlockC().getOccupancy() == 2;
                break;
            }
            case 6: {
                result = this.getLayoutBlock().getOccupancy() == 2 || this.getLayoutBlockD().getOccupancy() == 2;
                break;
            }
            case 8: {
                result = this.getLayoutBlockB().getOccupancy() == 2 || this.getLayoutBlockC().getOccupancy() == 2;
                break;
            }
            case 4: {
                result = this.getLayoutBlockB().getOccupancy() == 2 || this.getLayoutBlockD().getOccupancy() == 2;
                break;
            }
            case 1: {
                result = this.getLayoutBlock().getOccupancy() == 2 || this.getLayoutBlockB().getOccupancy() == 2 || this.getLayoutBlockC().getOccupancy() == 2 || this.getLayoutBlockD().getOccupancy() == 2;
                break;
            }
            default: {
                log.error("{}.isOccupied(); invalid slip state: {}", (Object)this.getName(), (Object)this.getSlipState());
            }
        }
        return result;
    }

    void activateTurnout() {
        if (this.namedTurnout != null) {
            this.mTurnoutListener = e -> this.updateState();
            ((Turnout)this.namedTurnout.getBean()).addPropertyChangeListener(this.mTurnoutListener, this.namedTurnout.getName(), "Layout Editor Slip");
        }
        if (this.namedTurnoutB != null) {
            this.mTurnoutListener = e -> this.updateState();
            this.namedTurnoutB.getBean().addPropertyChangeListener(this.mTurnoutListener, this.namedTurnoutB.getName(), "Layout Editor Slip");
        }
        this.updateState();
    }

    void deactivateTurnout() {
        if (this.mTurnoutListener != null) {
            if (this.namedTurnout != null) {
                ((Turnout)this.namedTurnout.getBean()).removePropertyChangeListener(this.mTurnoutListener);
            }
            if (this.namedTurnoutB != null) {
                this.namedTurnoutB.getBean().removePropertyChangeListener(this.mTurnoutListener);
            }
            this.mTurnoutListener = null;
        }
    }

    @Override
    public void updateBlockInfo() {
        LayoutBlock b1 = null;
        LayoutBlock b2 = null;
        if (this.getLayoutBlock() != null) {
            this.getLayoutBlock().updatePaths();
        }
        if (this.connectA != null && (b1 = ((TrackSegment)this.connectA).getLayoutBlock()) != null && b1 != this.getLayoutBlock()) {
            b1.updatePaths();
        }
        if (this.connectC != null && (b2 = ((TrackSegment)this.connectC).getLayoutBlock()) != null && b2 != this.getLayoutBlock() && b2 != b1) {
            b2.updatePaths();
        }
        if (this.connectB != null && (b1 = ((TrackSegment)this.connectB).getLayoutBlock()) != null && b1 != this.getLayoutBlock()) {
            b1.updatePaths();
        }
        if (this.connectD != null && (b2 = ((TrackSegment)this.connectD).getLayoutBlock()) != null && b2 != this.getLayoutBlock() && b2 != b1) {
            b2.updatePaths();
        }
        this.reCheckBlockBoundary();
    }

    @Override
    public boolean isMainline() {
        return this.connectA != null && ((TrackSegment)this.connectA).isMainline() || this.connectB != null && ((TrackSegment)this.connectB).isMainline() || this.connectC != null && ((TrackSegment)this.connectC).isMainline() || this.connectD != null && ((TrackSegment)this.connectD).isMainline();
    }

    @Override
    public String[] getBlockBoundaries() {
        String[] boundaryBetween = new String[4];
        if (!this.getBlockName().isEmpty() && this.getLayoutBlock() != null) {
            if (this.connectA instanceof TrackSegment && ((TrackSegment)this.connectA).getLayoutBlock() != this.getLayoutBlock()) {
                try {
                    boundaryBetween[0] = ((TrackSegment)this.connectA).getLayoutBlock().getDisplayName() + " - " + this.getLayoutBlock().getDisplayName();
                }
                catch (NullPointerException e) {
                    log.debug("TrackSegement at connection A doesn't contain a layout block");
                }
            }
            if (this.connectC instanceof TrackSegment && ((TrackSegment)this.connectC).getLayoutBlock() != this.getLayoutBlock()) {
                try {
                    boundaryBetween[2] = ((TrackSegment)this.connectC).getLayoutBlock().getDisplayName() + " - " + this.getLayoutBlock().getDisplayName();
                }
                catch (NullPointerException e) {
                    log.debug("TrackSegement at connection C doesn't contain a layout block");
                }
            }
            if (this.connectB instanceof TrackSegment && ((TrackSegment)this.connectB).getLayoutBlock() != this.getLayoutBlock()) {
                try {
                    boundaryBetween[1] = ((TrackSegment)this.connectB).getLayoutBlock().getDisplayName() + " - " + this.getLayoutBlock().getDisplayName();
                }
                catch (NullPointerException e) {
                    log.debug("TrackSegement at connection B doesn't contain a layout block");
                }
            }
            if (this.connectD instanceof TrackSegment && ((TrackSegment)this.connectD).getLayoutBlock() != this.getLayoutBlock()) {
                try {
                    boundaryBetween[3] = ((TrackSegment)this.connectD).getLayoutBlock().getDisplayName() + " - " + this.getLayoutBlock().getDisplayName();
                }
                catch (NullPointerException e) {
                    log.debug("TrackSegement at connection D doesn't contain a layout block");
                }
            }
        }
        return boundaryBetween;
    }

    @Override
    public void remove() {
        this.disableSML(this.getSignalAMast());
        this.disableSML(this.getSignalBMast());
        this.disableSML(this.getSignalCMast());
        this.disableSML(this.getSignalDMast());
        this.removeSML(this.getSignalAMast());
        this.removeSML(this.getSignalBMast());
        this.removeSML(this.getSignalCMast());
        this.removeSML(this.getSignalDMast());
    }

    void disableSML(SignalMast signalMast) {
        if (signalMast == null) {
            return;
        }
        InstanceManager.getDefault(SignalMastLogicManager.class).disableLayoutEditorUse(signalMast);
    }

    public HashMap<Integer, TurnoutState> getTurnoutStates() {
        return this.turnoutStates;
    }

    public int getTurnoutState(@Nonnull Turnout turn, int state) {
        if (turn == this.getTurnout()) {
            return this.getTurnoutState(state);
        }
        return this.getTurnoutBState(state);
    }

    public int getTurnoutState(int state) {
        return this.turnoutStates.get(state).getTurnoutAState();
    }

    public int getTurnoutBState(int state) {
        return this.turnoutStates.get(state).getTurnoutBState();
    }

    public void setTurnoutStates(int state, @Nonnull String turnStateA, @Nonnull String turnStateB) {
        if (!this.turnoutStates.containsKey(state)) {
            log.error("{}.setTurnoutStates({}, {}, {}); invalid state for slip", new Object[]{this.getName(), state, turnStateA, turnStateB});
            return;
        }
        this.turnoutStates.get(state).setTurnoutAState(Integer.parseInt(turnStateA));
        this.turnoutStates.get(state).setTurnoutBState(Integer.parseInt(turnStateB));
    }

    void updateState() {
        if (this.getTurnout() != null && this.getTurnoutB() != null) {
            int state_a = this.getTurnout().getKnownState();
            int state_b = this.getTurnoutB().getKnownState();
            for (Map.Entry<Integer, TurnoutState> en : this.turnoutStates.entrySet()) {
                if (en.getValue().getTurnoutAState() != state_a || en.getValue().getTurnoutBState() != state_b) continue;
                this.currentState = en.getKey();
                this.models.redrawPanel();
                return;
            }
        }
    }

    boolean isTurnoutInconsistent() {
        Turnout tA = this.getTurnout();
        if (tA != null && tA.getKnownState() == 8) {
            return true;
        }
        Turnout tB = this.getTurnoutB();
        return tB != null && tB.getKnownState() == 8;
    }

    @Override
    protected int getConnectivityStateForLayoutBlocks(@CheckForNull LayoutBlock thisLayoutBlock, @CheckForNull LayoutBlock prevLayoutBlock, @CheckForNull LayoutBlock nextLayoutBlock, boolean suppress) {
        int result = 1;
        LayoutBlock layoutBlockA = ((TrackSegment)this.getConnectA()).getLayoutBlock();
        LayoutBlock layoutBlockB = ((TrackSegment)this.getConnectB()).getLayoutBlock();
        LayoutBlock layoutBlockC = ((TrackSegment)this.getConnectC()).getLayoutBlock();
        LayoutBlock layoutBlockD = ((TrackSegment)this.getConnectD()).getLayoutBlock();
        if (layoutBlockA == thisLayoutBlock) {
            if (layoutBlockC == nextLayoutBlock || layoutBlockC == prevLayoutBlock) {
                result = 2;
            } else if (layoutBlockD == nextLayoutBlock || layoutBlockD == prevLayoutBlock) {
                result = 6;
            } else if (layoutBlockC == thisLayoutBlock) {
                result = 2;
            } else if (layoutBlockD == thisLayoutBlock) {
                result = 6;
            }
        } else if (layoutBlockB == thisLayoutBlock) {
            if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                if (layoutBlockD == nextLayoutBlock || layoutBlockD == prevLayoutBlock) {
                    result = 4;
                } else if (layoutBlockC == nextLayoutBlock || layoutBlockC == prevLayoutBlock) {
                    result = 8;
                } else if (layoutBlockD == thisLayoutBlock) {
                    result = 4;
                } else if (layoutBlockC == thisLayoutBlock) {
                    result = 8;
                }
            } else if (layoutBlockD == nextLayoutBlock || layoutBlockD == prevLayoutBlock) {
                result = 4;
            } else if (layoutBlockD == thisLayoutBlock) {
                result = 4;
            }
        } else if (layoutBlockC == thisLayoutBlock) {
            if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                if (layoutBlockA == nextLayoutBlock || layoutBlockA == prevLayoutBlock) {
                    result = 2;
                } else if (layoutBlockB == nextLayoutBlock || layoutBlockB == prevLayoutBlock) {
                    result = 8;
                } else if (layoutBlockA == thisLayoutBlock) {
                    result = 2;
                } else if (layoutBlockB == thisLayoutBlock) {
                    result = 8;
                }
            } else if (layoutBlockA == nextLayoutBlock || layoutBlockA == prevLayoutBlock) {
                result = 2;
            } else if (layoutBlockA == thisLayoutBlock) {
                result = 2;
            }
        } else if (layoutBlockD == thisLayoutBlock) {
            if (layoutBlockA == nextLayoutBlock || layoutBlockA == prevLayoutBlock) {
                result = 6;
            } else if (layoutBlockB == nextLayoutBlock || layoutBlockB == prevLayoutBlock) {
                result = 4;
            } else if (layoutBlockA == thisLayoutBlock) {
                result = 6;
            } else if (layoutBlockB == thisLayoutBlock) {
                result = 6;
            }
        } else {
            result = 1;
        }
        if (!suppress && result == 1) {
            log.error("{}.getConnectivityStateForLayoutBlocks(...); Cannot determine slip setting", (Object)this.getName());
        }
        return result;
    }

    @Override
    public void reCheckBlockBoundary() {
        TrackSegment trkD;
        TrackSegment trkB;
        TrackSegment trkC;
        TrackSegment trkA;
        if (this.connectA == null && this.connectB == null && this.connectC == null && this.connectD == null) {
            if (this.signalAMastNamed != null) {
                this.removeSML(this.getSignalAMast());
            }
            if (this.signalBMastNamed != null) {
                this.removeSML(this.getSignalBMast());
            }
            if (this.signalCMastNamed != null) {
                this.removeSML(this.getSignalCMast());
            }
            if (this.signalDMastNamed != null) {
                this.removeSML(this.getSignalDMast());
            }
            this.signalAMastNamed = null;
            this.signalBMastNamed = null;
            this.signalCMastNamed = null;
            this.signalDMastNamed = null;
            this.sensorANamed = null;
            this.sensorBNamed = null;
            this.sensorCNamed = null;
            this.sensorDNamed = null;
            return;
        }
        if (this.connectA == null || this.connectB == null || this.connectC == null || this.connectD == null) {
            return;
        }
        if (this.connectA instanceof TrackSegment && (trkA = (TrackSegment)this.connectA).getLayoutBlock() == this.getLayoutBlock()) {
            if (this.signalAMastNamed != null) {
                this.removeSML(this.getSignalAMast());
            }
            this.signalAMastNamed = null;
            this.sensorANamed = null;
        }
        if (this.connectC instanceof TrackSegment && (trkC = (TrackSegment)this.connectC).getLayoutBlock() == this.getLayoutBlock()) {
            if (this.signalCMastNamed != null) {
                this.removeSML(this.getSignalCMast());
            }
            this.signalCMastNamed = null;
            this.sensorCNamed = null;
        }
        if (this.connectB instanceof TrackSegment && (trkB = (TrackSegment)this.connectB).getLayoutBlock() == this.getLayoutBlock()) {
            if (this.signalBMastNamed != null) {
                this.removeSML(this.getSignalBMast());
            }
            this.signalBMastNamed = null;
            this.sensorBNamed = null;
        }
        if (this.connectD instanceof TrackSegment && (trkD = (TrackSegment)this.connectC).getLayoutBlock() == this.getLayoutBlock()) {
            if (this.signalDMastNamed != null) {
                this.removeSML(this.getSignalDMast());
            }
            this.signalDMastNamed = null;
            this.sensorDNamed = null;
        }
    }

    @Override
    @Nonnull
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        ArrayList<LayoutConnectivity> results = new ArrayList<LayoutConnectivity>();
        log.trace("Start in LayoutSlip.getLayoutConnectivity for {}", (Object)this.getName());
        LayoutConnectivity lc = null;
        LayoutBlock lbA = this.getLayoutBlock();
        LayoutBlock lbB = this.getLayoutBlockB();
        LayoutBlock lbC = this.getLayoutBlockC();
        LayoutBlock lbD = this.getLayoutBlockD();
        log.trace("    type: {}", (Object)this.type);
        log.trace("     lbA: {}", (Object)lbA);
        log.trace("     lbB: {}", (Object)lbB);
        log.trace("     lbC: {}", (Object)lbC);
        log.trace("     lbD: {}", (Object)lbD);
        if (lbA != null) {
            if (lbA != lbC) {
                log.debug("Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbA, lbC, this});
                lc = new LayoutConnectivity(lbA, lbC);
                lc.setXoverBoundary(this, 3);
                lc.setDirection(this.models.computeDirectionAC(this));
                log.trace("getLayoutConnectivity lbA != lbC");
                log.trace("  Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbA, lbC, this});
                results.add(lc);
            }
            if (lbB != lbD) {
                log.debug("Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbB, lbD, this});
                lc = new LayoutConnectivity(lbB, lbD);
                lc.setXoverBoundary(this, 4);
                lc.setDirection(this.models.computeDirectionBD(this));
                log.trace("getLayoutConnectivity lbA != lbC");
                log.trace("  Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbB, lbD, this});
                results.add(lc);
            }
            if (lbA != lbD) {
                log.debug("Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbA, lbD, this});
                lc = new LayoutConnectivity(lbA, lbD);
                lc.setXoverBoundary(this, 1);
                lc.setDirection(this.models.computeDirectionAD(this));
                log.trace("getLayoutConnectivity lbA != lbC");
                log.trace("  Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbA, lbD, this});
                results.add(lc);
            }
            if (this.type == LayoutTurnout.TurnoutType.DOUBLE_SLIP && lbB != lbC) {
                log.debug("Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbB, lbC, this});
                lc = new LayoutConnectivity(lbB, lbC);
                lc.setXoverBoundary(this, 2);
                lc.setDirection(this.models.computeDirectionBC(this));
                log.trace("getLayoutConnectivity lbA != lbC");
                log.trace("  Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbB, lbC, this});
                results.add(lc);
            }
        }
        return results;
    }

    @Override
    public List<HitPointType> checkForFreeConnections() {
        ArrayList<HitPointType> result = new ArrayList<HitPointType>();
        if (this.getConnectA() == null) {
            result.add(HitPointType.SLIP_A);
        }
        if (this.getConnectB() == null) {
            result.add(HitPointType.SLIP_B);
        }
        if (this.getConnectC() == null) {
            result.add(HitPointType.SLIP_C);
        }
        if (this.getConnectD() == null) {
            result.add(HitPointType.SLIP_D);
        }
        return result;
    }

    @Override
    @Nonnull
    public String getNameString() {
        Turnout turnout = this.getTurnout();
        Turnout turnoutB = this.getTurnoutB();
        if (turnout != null && turnoutB != null) {
            return turnout.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME) + " : " + turnoutB.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        }
        return this.getId();
    }

    public static class TurnoutState {
        private int turnoutAstate = 2;
        private int turnoutBstate = 2;
        private JComboBox<String> turnoutABox;
        private JComboBox<String> turnoutBBox;

        TurnoutState(int turnoutAstate, int turnoutBstate) {
            this.turnoutAstate = turnoutAstate;
            this.turnoutBstate = turnoutBstate;
        }

        public int getTurnoutAState() {
            return this.turnoutAstate;
        }

        public int getTurnoutBState() {
            return this.turnoutBstate;
        }

        public void setTurnoutAState(int state) {
            this.turnoutAstate = state;
        }

        public void setTurnoutBState(int state) {
            this.turnoutBstate = state;
        }

        public JComboBox<String> getComboA() {
            if (this.turnoutABox == null) {
                String[] state = new String[]{InstanceManager.turnoutManagerInstance().getClosedText(), InstanceManager.turnoutManagerInstance().getThrownText()};
                this.turnoutABox = new JComboBox<String>(state);
                if (this.turnoutAstate == 4) {
                    this.turnoutABox.setSelectedIndex(1);
                }
            }
            return this.turnoutABox;
        }

        public JComboBox<String> getComboB() {
            if (this.turnoutBBox == null) {
                String[] state = new String[]{InstanceManager.turnoutManagerInstance().getClosedText(), InstanceManager.turnoutManagerInstance().getThrownText()};
                this.turnoutBBox = new JComboBox<String>(state);
                if (this.turnoutBstate == 4) {
                    this.turnoutBBox.setSelectedIndex(1);
                }
            }
            return this.turnoutBBox;
        }

        public int getTestTurnoutAState() {
            int result = 4;
            if (this.turnoutABox != null && this.turnoutABox.getSelectedIndex() == 0) {
                result = 2;
            }
            return result;
        }

        public int getTestTurnoutBState() {
            int result = 4;
            if (this.turnoutBBox != null && this.turnoutBBox.getSelectedIndex() == 0) {
                result = 2;
            }
            return result;
        }

        public void updateStatesFromCombo() {
            if (this.turnoutABox != null && this.turnoutBBox != null) {
                this.turnoutAstate = this.getTestTurnoutAState();
                this.turnoutBstate = this.getTestTurnoutBState();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof TurnoutState)) {
                return false;
            }
            TurnoutState tso = (TurnoutState)object;
            return this.getTurnoutAState() == tso.getTurnoutAState() && this.getTurnoutBState() == tso.getTurnoutBState();
        }

        public int hashCode() {
            int result = 7;
            result = 37 * result + this.getTurnoutAState();
            result = 37 * result + this.getTurnoutBState();
            return result;
        }
    }
}

