/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Turnout;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutSlipEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurnoutView;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.LayoutBlockRouteTableAction;
import jmri.util.MathUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutSlipView
extends LayoutTurnoutView {
    private final LayoutSlip slip;
    public int currentState = 1;
    JPopupMenu popup = null;
    private static final Logger log = LoggerFactory.getLogger(LayoutSlipView.class);

    public LayoutSlipView(@Nonnull LayoutSlip slip, Point2D c, double rot, @Nonnull LayoutEditor layoutEditor) {
        super(slip, c, rot, layoutEditor);
        this.slip = slip;
        this.dispA = new Point2D.Double(-20.0, 0.0);
        this.pointA = MathUtil.add(this.getCoordsCenter(), this.dispA);
        this.pointC = MathUtil.subtract(this.getCoordsCenter(), this.dispA);
        this.dispB = new Point2D.Double(-14.0, 14.0);
        this.pointB = MathUtil.add(this.getCoordsCenter(), this.dispB);
        this.pointD = MathUtil.subtract(this.getCoordsCenter(), this.dispB);
        this.rotateCoords(rot);
        this.editor = new LayoutSlipEditor(layoutEditor);
    }

    public LayoutSlip getSlip() {
        return this.slip;
    }

    @Override
    public String toString() {
        return String.format("LayoutSlip %s (%s)", this.getId(), this.getSlipStateString(this.getSlipState()));
    }

    public LayoutTurnout.TurnoutType getSlipType() {
        return this.slip.getSlipType();
    }

    public int getSlipState() {
        return this.slip.getSlipState();
    }

    public String getTurnoutBName() {
        return this.slip.getTurnoutBName();
    }

    public Turnout getTurnoutB() {
        return this.slip.getTurnoutB();
    }

    public void setTurnoutB(@CheckForNull String tName) {
        this.slip.setTurnoutB(tName);
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        return this.slip.getConnection(connectionType);
    }

    @Override
    public void setConnection(HitPointType connectionType, @CheckForNull LayoutTrack o, HitPointType type) throws JmriException {
        this.slip.setConnection(connectionType, o, type);
    }

    public String getDisplayName() {
        String name = "Slip " + this.getId();
        String tnA = this.getTurnoutName();
        String tnB = this.getTurnoutBName();
        if (tnA != null && !tnA.isEmpty()) {
            name = name + " (" + tnA;
        }
        if (tnB != null && !tnB.isEmpty()) {
            name = name.contains(" (") ? name + ", " : name + "(";
            name = name + tnB;
        }
        if (name.contains("(")) {
            name = name + ")";
        }
        return name;
    }

    private String getSlipStateString(int slipState) {
        return this.slip.getSlipStateString(slipState);
    }

    public void toggleState(HitPointType selectedPointType) {
        this.slip.toggleState(selectedPointType);
    }

    private boolean isOccupied() {
        return this.slip.isOccupied();
    }

    @Override
    public Point2D getCoordsA() {
        return this.pointA;
    }

    @Override
    public Point2D getCoordsB() {
        return this.pointB;
    }

    @Override
    public Point2D getCoordsC() {
        return this.pointC;
    }

    @Override
    public Point2D getCoordsD() {
        return this.pointD;
    }

    Point2D getCoordsLeft() {
        Point2D leftCenter = MathUtil.midPoint(this.getCoordsA(), this.getCoordsB());
        double circleRadius = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
        double leftFract = circleRadius / this.getCoordsCenter().distance(leftCenter);
        return MathUtil.lerp(this.getCoordsCenter(), leftCenter, leftFract);
    }

    Point2D getCoordsRight() {
        Point2D rightCenter = MathUtil.midPoint(this.getCoordsC(), this.getCoordsD());
        double circleRadius = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
        double rightFract = circleRadius / this.getCoordsCenter().distance(rightCenter);
        return MathUtil.lerp(this.getCoordsCenter(), rightCenter, rightFract);
    }

    @Override
    public Point2D getCoordsForConnectionType(HitPointType connectionType) {
        Point2D result = this.getCoordsCenter();
        switch (connectionType) {
            case SLIP_A: {
                result = this.getCoordsA();
                break;
            }
            case SLIP_B: {
                result = this.getCoordsB();
                break;
            }
            case SLIP_C: {
                result = this.getCoordsC();
                break;
            }
            case SLIP_D: {
                result = this.getCoordsD();
                break;
            }
            case SLIP_LEFT: {
                result = this.getCoordsLeft();
                break;
            }
            case SLIP_RIGHT: {
                result = this.getCoordsRight();
                break;
            }
            default: {
                log.error("{}.getCoordsForConnectionType({}); Invalid Connection Type", (Object)this.getName(), (Object)connectionType);
            }
        }
        return result;
    }

    @Override
    public Rectangle2D getBounds() {
        return super.getBounds();
    }

    @Override
    public void updateBlockInfo() {
        this.slip.updateBlockInfo();
    }

    @Override
    protected HitPointType findHitPointType(@Nonnull Point2D hitPoint, boolean useRectangles, boolean requireUnconnected) {
        HitPointType result = HitPointType.NONE;
        if (!requireUnconnected) {
            double circleRadius = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
            Point2D leftCenter = this.getCoordsLeft();
            Point2D rightCenter = this.getCoordsRight();
            if (useRectangles) {
                Rectangle2D rightRectangle;
                Rectangle2D leftRectangle = this.layoutEditor.layoutEditorControlCircleRectAt(leftCenter);
                if (leftRectangle.contains(hitPoint)) {
                    result = HitPointType.SLIP_LEFT;
                }
                if ((rightRectangle = this.layoutEditor.layoutEditorControlCircleRectAt(rightCenter)).contains(hitPoint)) {
                    result = HitPointType.SLIP_RIGHT;
                }
            } else {
                double leftDistance = hitPoint.distance(leftCenter);
                double rightDistance = hitPoint.distance(rightCenter);
                if (leftDistance <= circleRadius || rightDistance <= circleRadius) {
                    HitPointType hitPointType = result = leftDistance < rightDistance ? HitPointType.SLIP_LEFT : HitPointType.SLIP_RIGHT;
                }
            }
        }
        if (result == HitPointType.NONE) {
            Rectangle2D r = this.layoutEditor.layoutEditorControlRectAt(hitPoint);
            if ((!requireUnconnected || this.getConnectA() == null) && r.contains(this.getCoordsA())) {
                result = HitPointType.SLIP_A;
            }
            if ((!requireUnconnected || this.getConnectB() == null) && r.contains(this.getCoordsB())) {
                result = HitPointType.SLIP_B;
            }
            if ((!requireUnconnected || this.getConnectC() == null) && r.contains(this.getCoordsC())) {
                result = HitPointType.SLIP_C;
            }
            if ((!requireUnconnected || this.getConnectD() == null) && r.contains(this.getCoordsD())) {
                result = HitPointType.SLIP_D;
            }
        }
        return result;
    }

    @Override
    public void setCoordsCenter(@Nonnull Point2D p) {
        super.setCoordsCenter(p);
        this.pointA = MathUtil.add(this.getCoordsCenter(), this.dispA);
        this.pointB = MathUtil.add(this.getCoordsCenter(), this.dispB);
        this.pointC = MathUtil.subtract(this.getCoordsCenter(), this.dispA);
        this.pointD = MathUtil.subtract(this.getCoordsCenter(), this.dispB);
    }

    @Override
    public void setCoordsA(@Nonnull Point2D p) {
        this.pointA = p;
        this.dispA = MathUtil.subtract(this.pointA, this.getCoordsCenter());
        this.pointC = MathUtil.subtract(this.getCoordsCenter(), this.dispA);
    }

    @Override
    public void setCoordsB(@Nonnull Point2D p) {
        this.pointB = p;
        this.dispB = MathUtil.subtract(this.pointB, this.getCoordsCenter());
        this.pointD = MathUtil.subtract(this.getCoordsCenter(), this.dispB);
    }

    @Override
    public void setCoordsC(@Nonnull Point2D p) {
        this.pointC = p;
        this.dispA = MathUtil.subtract(this.getCoordsCenter(), this.pointC);
        this.pointA = MathUtil.add(this.getCoordsCenter(), this.dispA);
    }

    @Override
    public void setCoordsD(@Nonnull Point2D p) {
        this.pointD = p;
        this.dispB = MathUtil.subtract(this.getCoordsCenter(), this.pointD);
        this.pointB = MathUtil.add(this.getCoordsCenter(), this.dispB);
    }

    @Override
    @Nonnull
    protected JPopupMenu showPopup(@Nonnull JmriMouseEvent mouseEvent) {
        if (this.popup != null) {
            this.popup.removeAll();
        } else {
            this.popup = new JPopupMenu();
        }
        if (this.layoutEditor.isEditable()) {
            String stateString;
            String slipStateString = this.getSlipStateString(this.getSlipState());
            slipStateString = String.format(" (%s)", slipStateString);
            JMenuItem jmi = null;
            switch (this.getSlipType()) {
                case SINGLE_SLIP: {
                    jmi = this.popup.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("LayoutSingleSlip")) + this.getId() + slipStateString);
                    break;
                }
                case DOUBLE_SLIP: {
                    jmi = this.popup.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("LayoutDoubleSlip")) + this.getId() + slipStateString);
                    break;
                }
                default: {
                    log.error("{}.showPopup(<mouseEvent>); Invalid slip type: {}", (Object)this.getName(), (Object)this.getSlipType());
                }
            }
            if (jmi != null) {
                jmi.setEnabled(false);
            }
            if (this.getTurnout() == null) {
                jmi = this.popup.add(Bundle.getMessage("NoTurnout"));
            } else {
                stateString = this.getTurnoutStateString(this.getTurnout().getKnownState());
                stateString = String.format(" (%s)", stateString);
                jmi = this.popup.add(Bundle.getMessage("BeanNameTurnout") + ": " + this.getTurnoutName() + stateString);
            }
            jmi.setEnabled(false);
            if (this.getTurnoutB() == null) {
                jmi = this.popup.add(Bundle.getMessage("NoTurnout"));
            } else {
                stateString = this.getTurnoutStateString(this.getTurnoutB().getKnownState());
                stateString = String.format(" (%s)", stateString);
                jmi = this.popup.add(Bundle.getMessage("BeanNameTurnout") + ": " + this.getTurnoutBName() + stateString);
            }
            jmi.setEnabled(false);
            boolean blockAssigned = false;
            if (this.getBlockName().isEmpty()) {
                jmi = this.popup.add(Bundle.getMessage("NoBlock"));
                jmi.setEnabled(false);
            } else {
                blockAssigned = true;
                jmi = this.popup.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", "A")) + this.getLayoutBlock().getDisplayName());
                jmi.setEnabled(false);
                if (this.getLayoutBlockB() != null && this.getLayoutBlockB() != this.getLayoutBlock()) {
                    jmi = this.popup.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", "B")) + this.getLayoutBlockB().getDisplayName());
                    jmi.setEnabled(false);
                }
                if (this.getLayoutBlockC() != null && this.getLayoutBlockC() != this.getLayoutBlock()) {
                    jmi = this.popup.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", "C")) + this.getLayoutBlockC().getDisplayName());
                    jmi.setEnabled(false);
                }
                if (this.getLayoutBlockD() != null && this.getLayoutBlockD() != this.getLayoutBlock()) {
                    jmi = this.popup.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", "D")) + this.getLayoutBlockD().getDisplayName());
                    jmi.setEnabled(false);
                }
            }
            if (this.getConnectA() != null || this.getConnectB() != null || this.getConnectC() != null || this.getConnectD() != null) {
                JMenu connectionsMenu = new JMenu(Bundle.getMessage("Connections"));
                if (this.getConnectA() != null) {
                    connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "A") + this.getConnectA().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LayoutSlipView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LayoutSlipView.this.getConnectA().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LayoutSlipView.this.layoutEditor.getLayoutTrackView(lt);
                                LayoutSlipView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                if (this.getConnectB() != null) {
                    connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "B") + this.getConnectB().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LayoutSlipView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LayoutSlipView.this.getConnectB().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LayoutSlipView.this.layoutEditor.getLayoutTrackView(lt);
                                LayoutSlipView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                if (this.getConnectC() != null) {
                    connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "C") + this.getConnectC().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LayoutSlipView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LayoutSlipView.this.getConnectC().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LayoutSlipView.this.layoutEditor.getLayoutTrackView(lt);
                                LayoutSlipView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                if (this.getConnectD() != null) {
                    connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "D") + this.getConnectD().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LayoutSlipView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LayoutSlipView.this.getConnectD().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LayoutSlipView.this.layoutEditor.getLayoutTrackView(lt);
                                LayoutSlipView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                this.popup.add(connectionsMenu);
            }
            this.popup.add(new JSeparator(0));
            JCheckBoxMenuItem hiddenCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("Hidden"));
            hiddenCheckBoxMenuItem.setSelected(this.isHidden());
            this.popup.add(hiddenCheckBoxMenuItem);
            hiddenCheckBoxMenuItem.addActionListener(e1 -> {
                JCheckBoxMenuItem o = (JCheckBoxMenuItem)e1.getSource();
                this.setHidden(o.isSelected());
            });
            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(Bundle.getMessage("Disabled"));
            cbmi.setSelected(this.isDisabled());
            this.popup.add(cbmi);
            cbmi.addActionListener(e2 -> {
                JCheckBoxMenuItem o = (JCheckBoxMenuItem)e2.getSource();
                this.setDisabled(o.isSelected());
            });
            cbmi = new JCheckBoxMenuItem(Bundle.getMessage("DisabledWhenOccupied"));
            cbmi.setSelected(this.isDisabledWhenOccupied());
            this.popup.add(cbmi);
            cbmi.addActionListener(e3 -> {
                JCheckBoxMenuItem o = (JCheckBoxMenuItem)e3.getSource();
                this.setDisableWhenOccupied(o.isSelected());
            });
            this.popup.add(new AbstractAction(Bundle.getMessage("ButtonEdit")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutSlipView.this.editor.editLayoutTrack(LayoutSlipView.this);
                }
            });
            this.popup.add(new AbstractAction(Bundle.getMessage("ButtonDelete")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LayoutSlipView.this.canRemove() && LayoutSlipView.this.removeInlineLogixNG() && LayoutSlipView.this.layoutEditor.removeLayoutSlip(LayoutSlipView.this.slip)) {
                        LayoutSlipView.this.remove();
                        LayoutSlipView.this.dispose();
                    }
                }
            });
            if (this.getConnectA() == null && this.getConnectB() == null && this.getConnectC() == null && this.getConnectD() == null) {
                JMenuItem rotateItem = new JMenuItem(Bundle.getMessage("Rotate") + "...");
                this.popup.add(rotateItem);
                rotateItem.addActionListener(event -> {
                    boolean entering = true;
                    boolean error = false;
                    String newAngle = "";
                    while (entering) {
                        error = false;
                        newAngle = JmriJOptionPane.showInputDialog((Component)this.layoutEditor, Bundle.getMessage("MakeLabel", Bundle.getMessage("EnterRotation")), "");
                        if (newAngle == null || newAngle.isEmpty()) {
                            return;
                        }
                        double rot = 0.0;
                        try {
                            rot = Double.parseDouble(newAngle);
                        }
                        catch (Exception e1) {
                            JmriJOptionPane.showMessageDialog(this.layoutEditor, Bundle.getMessage("Error3") + " " + e1, Bundle.getMessage("ErrorTitle"), 0);
                            error = true;
                            newAngle = "";
                        }
                        if (error) continue;
                        entering = false;
                        if (rot == 0.0) continue;
                        this.rotateCoords(rot);
                        this.layoutEditor.redrawPanel();
                    }
                });
            }
            if (this.getTurnout() != null && this.getTurnoutB() != null) {
                if (blockAssigned) {
                    AbstractAction ssaa = new AbstractAction(Bundle.getMessage("SetSignals")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutSlipView.this.layoutEditor.getLETools().setSignalsAtSlipFromMenu(LayoutSlipView.this.slip, LayoutSlipView.this.getLayoutEditorToolBarPanel().signalIconEditor, LayoutSlipView.this.getLayoutEditorToolBarPanel().signalFrame);
                        }
                    };
                    JMenu jm = new JMenu(Bundle.getMessage("SignalHeads"));
                    if (this.layoutEditor.getLETools().addLayoutSlipSignalHeadInfoToMenu(this.slip, jm).booleanValue()) {
                        jm.add(ssaa);
                        this.popup.add(jm);
                    } else {
                        this.popup.add(ssaa);
                    }
                }
                final String[] boundaryBetween = this.getBlockBoundaries();
                boolean blockBoundaries = false;
                for (int i = 0; i < 4; ++i) {
                    if (boundaryBetween[i] == null) continue;
                    blockBoundaries = true;
                }
                if (blockBoundaries) {
                    this.popup.add(new AbstractAction(Bundle.getMessage("SetSignalMasts")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutSlipView.this.layoutEditor.getLETools().setSignalMastsAtSlipFromMenu(LayoutSlipView.this.slip, boundaryBetween, LayoutSlipView.this.getLayoutEditorToolBarPanel().signalFrame);
                        }
                    });
                    this.popup.add(new AbstractAction(Bundle.getMessage("SetSensors")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutSlipView.this.layoutEditor.getLETools().setSensorsAtSlipFromMenu(LayoutSlipView.this.slip, boundaryBetween, LayoutSlipView.this.getLayoutEditorToolBarPanel().sensorIconEditor, LayoutSlipView.this.getLayoutEditorToolBarPanel().sensorFrame);
                        }
                    });
                }
                if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() && blockAssigned) {
                    this.popup.add(new AbstractAction(Bundle.getMessage("ViewBlockRouting")){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            LayoutBlockRouteTableAction routeTableAction = new LayoutBlockRouteTableAction("ViewRouting", LayoutSlipView.this.getLayoutBlock());
                            routeTableAction.actionPerformed(event);
                        }
                    });
                }
            }
            this.setAdditionalEditPopUpMenu(this.popup);
            this.layoutEditor.setShowAlignmentMenu(this.popup);
            this.addCommonPopupItems(mouseEvent, this.popup);
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (!this.viewAdditionalMenu.isEmpty()) {
            this.setAdditionalViewPopUpMenu(this.popup);
            this.addCommonPopupItems(mouseEvent, this.popup);
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        return this.popup;
    }

    @Override
    public String[] getBlockBoundaries() {
        return this.slip.getBlockBoundaries();
    }

    @Override
    public void dispose() {
        if (this.popup != null) {
            this.popup.removeAll();
        }
        this.popup = null;
    }

    @Override
    public void remove() {
        this.slip.remove();
    }

    public int getTurnoutState(@Nonnull Turnout turn, int state) {
        return this.slip.getTurnoutState(turn, state);
    }

    public int getTurnoutState(int state) {
        return this.slip.getTurnoutState(state);
    }

    public int getTurnoutBState(int state) {
        return this.slip.getTurnoutBState(state);
    }

    public void setTurnoutStates(int state, @Nonnull String turnStateA, @Nonnull String turnStateB) {
        this.slip.setTurnoutStates(state, turnStateA, turnStateB);
    }

    private boolean isTurnoutInconsistent() {
        return this.slip.isTurnoutInconsistent();
    }

    @Override
    protected void draw1(Graphics2D g2, boolean drawMain, boolean isBlock) {
        Color color;
        Point2D pA = this.getCoordsA();
        Point2D pB = this.getCoordsB();
        Point2D pC = this.getCoordsC();
        Point2D pD = this.getCoordsD();
        boolean mainlineA = this.isMainlineA();
        boolean mainlineB = this.isMainlineB();
        boolean mainlineC = this.isMainlineC();
        boolean mainlineD = this.isMainlineD();
        boolean drawUnselectedLeg = this.layoutEditor.isTurnoutDrawUnselectedLeg() || this.isTurnoutInconsistent();
        int slipState = this.getSlipState();
        Color colorA = color = g2.getColor();
        Color colorB = color;
        Color colorC = color;
        Color colorD = color;
        if (isBlock) {
            LayoutBlock layoutBlockA = this.getLayoutBlock();
            colorA = layoutBlockA != null ? layoutBlockA.getBlockTrackColor() : color;
            LayoutBlock layoutBlockB = this.getLayoutBlockB();
            colorB = layoutBlockB != null ? layoutBlockB.getBlockTrackColor() : color;
            LayoutBlock layoutBlockC = this.getLayoutBlockC();
            colorC = layoutBlockC != null ? layoutBlockC.getBlockTrackColor() : color;
            LayoutBlock layoutBlockD = this.getLayoutBlockD();
            Color color2 = colorD = layoutBlockD != null ? layoutBlockD.getBlockTrackColor() : color;
            if (slipState == 2) {
                colorA = layoutBlockA != null ? layoutBlockA.getBlockColor() : color;
                colorC = layoutBlockC != null ? layoutBlockC.getBlockColor() : color;
            } else if (slipState == 4) {
                colorB = layoutBlockB != null ? layoutBlockB.getBlockColor() : color;
                colorD = layoutBlockD != null ? layoutBlockD.getBlockColor() : color;
            } else if (slipState == 6) {
                colorA = layoutBlockA != null ? layoutBlockA.getBlockColor() : color;
                colorD = layoutBlockD != null ? layoutBlockD.getBlockColor() : color;
            } else if (slipState == 8) {
                colorB = layoutBlockB != null ? layoutBlockB.getBlockColor() : color;
                colorC = layoutBlockC != null ? layoutBlockC.getBlockColor() : color;
            }
        }
        Point2D oneForthPointAC = MathUtil.oneFourthPoint(pA, pC);
        Point2D oneThirdPointAC = MathUtil.oneThirdPoint(pA, pC);
        Point2D midPointAC = MathUtil.midPoint(pA, pC);
        Point2D twoThirdsPointAC = MathUtil.twoThirdsPoint(pA, pC);
        Point2D threeFourthsPointAC = MathUtil.threeFourthsPoint(pA, pC);
        Point2D oneForthPointBD = MathUtil.oneFourthPoint(pB, pD);
        Point2D oneThirdPointBD = MathUtil.oneThirdPoint(pB, pD);
        Point2D midPointBD = MathUtil.midPoint(pB, pD);
        Point2D twoThirdsPointBD = MathUtil.twoThirdsPoint(pB, pD);
        Point2D threeFourthsPointBD = MathUtil.threeFourthsPoint(pB, pD);
        Point2D midPointAD = MathUtil.midPoint(oneThirdPointAC, twoThirdsPointBD);
        Point2D midPointBC = MathUtil.midPoint(oneThirdPointBD, twoThirdsPointAC);
        if (slipState == 6) {
            if (drawMain == mainlineA) {
                g2.setColor(colorA);
                g2.draw(new Line2D.Double(pA, oneThirdPointAC));
                g2.draw(new Line2D.Double(oneThirdPointAC, midPointAD));
            }
            if (drawMain == mainlineD) {
                g2.setColor(colorD);
                g2.draw(new Line2D.Double(midPointAD, twoThirdsPointBD));
                g2.draw(new Line2D.Double(twoThirdsPointBD, pD));
            }
        } else if (slipState == 2) {
            if (drawMain == mainlineA) {
                g2.setColor(colorA);
                g2.draw(new Line2D.Double(pA, oneThirdPointAC));
                g2.draw(new Line2D.Double(oneThirdPointAC, midPointAC));
            }
            if (drawMain == mainlineC) {
                g2.setColor(colorC);
                g2.draw(new Line2D.Double(midPointAC, twoThirdsPointAC));
                g2.draw(new Line2D.Double(twoThirdsPointAC, pC));
            }
        } else if (slipState == 4) {
            if (drawMain == mainlineB) {
                g2.setColor(colorB);
                g2.draw(new Line2D.Double(pB, oneThirdPointBD));
                g2.draw(new Line2D.Double(oneThirdPointBD, midPointBD));
            }
            if (drawMain == mainlineD) {
                g2.setColor(colorD);
                g2.draw(new Line2D.Double(midPointBD, twoThirdsPointBD));
                g2.draw(new Line2D.Double(twoThirdsPointBD, pD));
            }
        } else if (slipState == 8 && this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
            if (drawMain == mainlineB) {
                g2.setColor(colorB);
                g2.draw(new Line2D.Double(pB, oneThirdPointBD));
                g2.draw(new Line2D.Double(oneThirdPointBD, midPointBC));
            }
            if (drawMain == mainlineC) {
                g2.setColor(colorC);
                g2.draw(new Line2D.Double(midPointBC, twoThirdsPointAC));
                g2.draw(new Line2D.Double(twoThirdsPointAC, pC));
            }
        }
        if (!isBlock || drawUnselectedLeg) {
            if (slipState == 2) {
                if (drawMain == mainlineB) {
                    g2.setColor(colorB);
                    g2.draw(new Line2D.Double(pB, oneForthPointBD));
                }
                if (drawMain == mainlineD) {
                    g2.setColor(colorD);
                    g2.draw(new Line2D.Double(threeFourthsPointBD, pD));
                }
            } else if (slipState == 4) {
                if (drawMain == mainlineA) {
                    g2.setColor(colorA);
                    g2.draw(new Line2D.Double(pA, oneForthPointAC));
                }
                if (drawMain == mainlineC) {
                    g2.setColor(colorC);
                    g2.draw(new Line2D.Double(threeFourthsPointAC, pC));
                }
            } else if (slipState == 6) {
                if (drawMain == mainlineB) {
                    g2.setColor(colorB);
                    g2.draw(new Line2D.Double(pB, oneForthPointBD));
                }
                if (drawMain == mainlineC) {
                    g2.setColor(colorC);
                    g2.draw(new Line2D.Double(threeFourthsPointAC, pC));
                }
            } else if (slipState == 8) {
                if (drawMain == mainlineA) {
                    g2.setColor(colorA);
                    g2.draw(new Line2D.Double(pA, oneForthPointAC));
                }
                if (drawMain == mainlineD) {
                    g2.setColor(colorD);
                    g2.draw(new Line2D.Double(threeFourthsPointBD, pD));
                }
            } else {
                if (drawMain == mainlineA) {
                    g2.setColor(colorA);
                    g2.draw(new Line2D.Double(pA, oneForthPointAC));
                }
                if (drawMain == mainlineB) {
                    g2.setColor(colorB);
                    g2.draw(new Line2D.Double(pB, oneForthPointBD));
                }
                if (drawMain == mainlineC) {
                    g2.setColor(colorC);
                    g2.draw(new Line2D.Double(threeFourthsPointAC, pC));
                }
                if (drawMain == mainlineD) {
                    g2.setColor(colorD);
                    g2.draw(new Line2D.Double(threeFourthsPointBD, pD));
                }
            }
        }
    }

    @Override
    protected void draw2(Graphics2D g2, boolean drawMain, float railDisplacement) {
        int slipState;
        GeneralPath path;
        Point2D pA = this.getCoordsA();
        Point2D pB = this.getCoordsB();
        Point2D pC = this.getCoordsC();
        Point2D pD = this.getCoordsD();
        Point2D pM = this.getCoordsCenter();
        Point2D vAC = MathUtil.normalize(MathUtil.subtract(pC, pA), railDisplacement);
        double dirAC_DEG = MathUtil.computeAngleDEG(pA, pC);
        Point2D vACo = MathUtil.orthogonal(vAC);
        Point2D pAL = MathUtil.subtract(pA, vACo);
        Point2D pAR = MathUtil.add(pA, vACo);
        Point2D pCL = MathUtil.subtract(pC, vACo);
        Point2D pCR = MathUtil.add(pC, vACo);
        Point2D vBD = MathUtil.normalize(MathUtil.subtract(pD, pB), railDisplacement);
        double dirBD_DEG = MathUtil.computeAngleDEG(pB, pD);
        Point2D vBDo = MathUtil.orthogonal(vBD);
        Point2D pBL = MathUtil.subtract(pB, vBDo);
        Point2D pBR = MathUtil.add(pB, vBDo);
        Point2D pDL = MathUtil.subtract(pD, vBDo);
        Point2D pDR = MathUtil.add(pD, vBDo);
        double deltaDEG = MathUtil.absDiffAngleDEG(dirAC_DEG, dirBD_DEG);
        double deltaRAD = Math.toRadians(deltaDEG);
        double hypotV = (double)railDisplacement / Math.cos((Math.PI - deltaRAD) / 2.0);
        double hypotK = (double)railDisplacement / Math.cos(deltaRAD / 2.0);
        log.debug("dir AC: {}, BD: {}, diff: {}", new Object[]{dirAC_DEG, dirBD_DEG, deltaDEG});
        Point2D vDisK = MathUtil.normalize(MathUtil.subtract(vAC, vBD), hypotK);
        Point2D vDisV = MathUtil.normalize(MathUtil.orthogonal(vDisK), hypotV);
        Point2D pKL = MathUtil.subtract(pM, vDisK);
        Point2D pKR = MathUtil.add(pM, vDisK);
        Point2D pVL = MathUtil.add(pM, vDisV);
        Point2D pVR = MathUtil.subtract(pM, vDisV);
        double railGap = 2.0 / Math.sin(deltaRAD);
        Point2D vAC2 = MathUtil.normalize(vAC, railGap);
        Point2D vBD2 = MathUtil.normalize(vBD, railGap);
        Point2D pKRtA = MathUtil.subtract(pKR, vAC2);
        Point2D pVRtA = MathUtil.subtract(pVR, vAC2);
        Point2D pKLtC = MathUtil.add(pKL, vAC2);
        Point2D pVLtC = MathUtil.add(pVL, vAC2);
        Point2D pVRtB = MathUtil.subtract(pVR, vBD2);
        Point2D pKLtB = MathUtil.subtract(pKL, vBD2);
        Point2D pKRtD = MathUtil.add(pKR, vBD2);
        Point2D pVLtD = MathUtil.add(pVL, vBD2);
        Point2D pAPL = MathUtil.add(pAL, MathUtil.subtract(pVL, pAR));
        Point2D pBPR = MathUtil.add(pBR, MathUtil.subtract(pVL, pBL));
        Point2D pCPR = MathUtil.add(pCR, MathUtil.subtract(pVR, pCL));
        Point2D pDPL = MathUtil.add(pDL, MathUtil.subtract(pVR, pDR));
        Point2D vACo2 = MathUtil.normalize(vACo, 2.0);
        Point2D vBDo2 = MathUtil.normalize(vBDo, 2.0);
        Point2D pASL = MathUtil.add(pAPL, vACo2);
        Point2D pBSR = MathUtil.subtract(pBPR, vBDo2);
        Point2D pCSR = MathUtil.subtract(pCPR, vACo2);
        Point2D pDSL = MathUtil.add(pDPL, vBDo2);
        Point2D pVLP = MathUtil.add(pVLtD, vAC2);
        Point2D pVRP = MathUtil.subtract(pVRtA, vBD2);
        Point2D pKLH = MathUtil.midPoint(pM, pKL);
        Point2D pKRH = MathUtil.midPoint(pM, pKR);
        boolean mainlineA = this.isMainlineA();
        boolean mainlineB = this.isMainlineB();
        boolean mainlineC = this.isMainlineC();
        boolean mainlineD = this.isMainlineD();
        if (drawMain == mainlineA) {
            g2.draw(new Line2D.Double(pAR, pVL));
            g2.draw(new Line2D.Double(pVLtD, pKLtB));
            path = new GeneralPath();
            path.moveTo(pAL.getX(), pAL.getY());
            path.lineTo(pAPL.getX(), pAPL.getY());
            path.quadTo(pKL.getX(), pKL.getY(), pDPL.getX(), pDPL.getY());
            g2.draw(path);
        }
        if (drawMain == mainlineB) {
            g2.draw(new Line2D.Double(pBL, pVL));
            g2.draw(new Line2D.Double(pVLtC, pKRtA));
            if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                path = new GeneralPath();
                path.moveTo(pBR.getX(), pBR.getY());
                path.lineTo(pBPR.getX(), pBPR.getY());
                path.quadTo(pKR.getX(), pKR.getY(), pCPR.getX(), pCPR.getY());
                g2.draw(path);
            } else {
                g2.draw(new Line2D.Double(pBR, pKR));
            }
        }
        if (drawMain == mainlineC) {
            g2.draw(new Line2D.Double(pCL, pVR));
            g2.draw(new Line2D.Double(pVRtB, pKRtD));
            if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                path = new GeneralPath();
                path.moveTo(pCR.getX(), pCR.getY());
                path.lineTo(pCPR.getX(), pCPR.getY());
                path.quadTo(pKR.getX(), pKR.getY(), pBPR.getX(), pBPR.getY());
                g2.draw(path);
            } else {
                g2.draw(new Line2D.Double(pCR, pKR));
            }
        }
        if (drawMain == mainlineD) {
            g2.draw(new Line2D.Double(pDR, pVR));
            g2.draw(new Line2D.Double(pVRtA, pKLtC));
            path = new GeneralPath();
            path.moveTo(pDL.getX(), pDL.getY());
            path.lineTo(pDPL.getX(), pDPL.getY());
            path.quadTo(pKL.getX(), pKL.getY(), pAPL.getX(), pAPL.getY());
            g2.draw(path);
        }
        if ((slipState = this.getSlipState()) == 6) {
            if (drawMain == mainlineA) {
                g2.draw(new Line2D.Double(pASL, pKL));
                g2.draw(new Line2D.Double(pVLP, pKLH));
            }
            if (drawMain == mainlineB) {
                g2.draw(new Line2D.Double(pBPR, pKR));
                g2.draw(new Line2D.Double(pVLtC, pKRH));
            }
            if (drawMain == mainlineC) {
                g2.draw(new Line2D.Double(pCPR, pKR));
                g2.draw(new Line2D.Double(pVRtB, pKRH));
            }
            if (drawMain == mainlineD) {
                g2.draw(new Line2D.Double(pDSL, pKL));
                g2.draw(new Line2D.Double(pVRP, pKLH));
            }
        } else if (slipState == 2) {
            if (drawMain == mainlineA) {
                g2.draw(new Line2D.Double(pAPL, pKL));
                g2.draw(new Line2D.Double(pVLtD, pKLH));
            }
            if (drawMain == mainlineB) {
                g2.draw(new Line2D.Double(pBSR, pKR));
                g2.draw(new Line2D.Double(pVLP, pKRH));
            }
            if (drawMain == mainlineC) {
                g2.draw(new Line2D.Double(pCPR, pKR));
                g2.draw(new Line2D.Double(pVRtB, pKRH));
            }
            if (drawMain == mainlineD) {
                g2.draw(new Line2D.Double(pDSL, pKL));
                g2.draw(new Line2D.Double(pVRP, pKLH));
            }
        } else if (slipState == 4) {
            if (drawMain == mainlineA) {
                g2.draw(new Line2D.Double(pASL, pKL));
                g2.draw(new Line2D.Double(pVLP, pKLH));
            }
            if (drawMain == mainlineB) {
                g2.draw(new Line2D.Double(pBPR, pKR));
                g2.draw(new Line2D.Double(pVLtC, pKRH));
            }
            if (drawMain == mainlineC) {
                g2.draw(new Line2D.Double(pCSR, pKR));
                g2.draw(new Line2D.Double(pVRP, pKRH));
            }
            if (drawMain == mainlineD) {
                g2.draw(new Line2D.Double(pDPL, pKL));
                g2.draw(new Line2D.Double(pVRtA, pKLH));
            }
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP && slipState == 8) {
            if (drawMain == mainlineA) {
                g2.draw(new Line2D.Double(pAPL, pKL));
                g2.draw(new Line2D.Double(pVLtD, pKLH));
            }
            if (drawMain == mainlineB) {
                g2.draw(new Line2D.Double(pBSR, pKR));
                g2.draw(new Line2D.Double(pVLP, pKRH));
            }
            if (drawMain == mainlineC) {
                g2.draw(new Line2D.Double(pCSR, pKR));
                g2.draw(new Line2D.Double(pVRP, pKRH));
            }
            if (drawMain == mainlineD) {
                g2.draw(new Line2D.Double(pDPL, pKL));
                g2.draw(new Line2D.Double(pVRtA, pKLH));
            }
        }
    }

    @Override
    protected void highlightUnconnected(Graphics2D g2, HitPointType specificType) {
        if ((specificType == HitPointType.NONE || specificType == HitPointType.SLIP_A) && this.getConnectA() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsA()));
        }
        if ((specificType == HitPointType.NONE || specificType == HitPointType.SLIP_B) && this.getConnectB() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsB()));
        }
        if ((specificType == HitPointType.NONE || specificType == HitPointType.SLIP_C) && this.getConnectC() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsC()));
        }
        if ((specificType == HitPointType.NONE || specificType == HitPointType.SLIP_D) && this.getConnectD() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsD()));
        }
    }

    @Override
    protected void drawTurnoutControls(Graphics2D g2) {
        if (!(this.isDisabled() || this.isDisabledWhenOccupied() && this.isOccupied())) {
            int stateA = 1;
            Turnout toA = this.getTurnout();
            if (toA != null) {
                stateA = toA.getKnownState();
            }
            Color foregroundColor = g2.getColor();
            Color backgroundColor = g2.getBackground();
            if (stateA == 4) {
                g2.setColor(backgroundColor);
            } else if (stateA != 2) {
                g2.setColor(foregroundColor);
            }
            Point2D leftCircleCenter = this.getCoordsLeft();
            if (this.layoutEditor.isTurnoutFillControlCircles()) {
                g2.fill(this.trackControlCircleAt(leftCircleCenter));
            } else {
                g2.draw(this.trackControlCircleAt(leftCircleCenter));
            }
            if (stateA != 2) {
                g2.setColor(foregroundColor);
            }
            int stateB = 1;
            Turnout toB = this.getTurnoutB();
            if (toB != null) {
                stateB = toB.getKnownState();
            }
            if (stateB == 4) {
                g2.setColor(backgroundColor);
            } else if (stateB != 2) {
                g2.setColor(foregroundColor);
            }
            Point2D rightCircleCenter = this.getCoordsRight();
            if (this.layoutEditor.isTurnoutFillControlCircles()) {
                g2.fill(this.trackControlCircleAt(rightCircleCenter));
            } else {
                g2.draw(this.trackControlCircleAt(rightCircleCenter));
            }
            if (stateB != 2) {
                g2.setColor(foregroundColor);
            }
        }
    }

    @Override
    protected int getConnectivityStateForLayoutBlocks(@CheckForNull LayoutBlock thisLayoutBlock, @CheckForNull LayoutBlock prevLayoutBlock, @CheckForNull LayoutBlock nextLayoutBlock, boolean suppress) {
        return this.slip.getConnectivityStateForLayoutBlocks(thisLayoutBlock, prevLayoutBlock, nextLayoutBlock, suppress);
    }

    @Override
    public void reCheckBlockBoundary() {
        this.slip.reCheckBlockBoundary();
    }

    @Override
    @Nonnull
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        return this.slip.getLayoutConnectivity();
    }

    @Override
    public List<HitPointType> checkForFreeConnections() {
        return this.slip.checkForFreeConnections();
    }

    public static class TurnoutState {
        private int turnoutA = 2;
        private int turnoutB = 2;
        private JComboBox<String> turnoutABox;
        private JComboBox<String> turnoutBBox;

        TurnoutState(int turnoutA, int turnoutB) {
            this.turnoutA = turnoutA;
            this.turnoutB = turnoutB;
        }

        public int getTurnoutAState() {
            return this.turnoutA;
        }

        public int getTurnoutBState() {
            return this.turnoutB;
        }

        public void setTurnoutAState(int state) {
            this.turnoutA = state;
        }

        public void setTurnoutBState(int state) {
            this.turnoutB = state;
        }

        public JComboBox<String> getComboA() {
            if (this.turnoutABox == null) {
                String[] state = new String[]{InstanceManager.turnoutManagerInstance().getClosedText(), InstanceManager.turnoutManagerInstance().getThrownText()};
                this.turnoutABox = new JComboBox<String>(state);
                if (this.turnoutA == 4) {
                    this.turnoutABox.setSelectedIndex(1);
                }
            }
            return this.turnoutABox;
        }

        public JComboBox<String> getComboB() {
            if (this.turnoutBBox == null) {
                String[] state = new String[]{InstanceManager.turnoutManagerInstance().getClosedText(), InstanceManager.turnoutManagerInstance().getThrownText()};
                this.turnoutBBox = new JComboBox<String>(state);
                if (this.turnoutB == 4) {
                    this.turnoutBBox.setSelectedIndex(1);
                }
            }
            return this.turnoutBBox;
        }

        public int getTestTurnoutAState() {
            int result = 4;
            if (this.turnoutABox != null && this.turnoutABox.getSelectedIndex() == 0) {
                result = 2;
            }
            return result;
        }

        public int getTestTurnoutBState() {
            int result = 4;
            if (this.turnoutBBox != null && this.turnoutBBox.getSelectedIndex() == 0) {
                result = 2;
            }
            return result;
        }

        public void updateStatesFromCombo() {
            if (this.turnoutABox != null && this.turnoutBBox != null) {
                this.turnoutA = this.getTestTurnoutAState();
                this.turnoutB = this.getTestTurnoutBState();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof TurnoutState)) {
                return false;
            }
            TurnoutState tso = (TurnoutState)object;
            return this.getTurnoutAState() == tso.getTurnoutAState() && this.getTurnoutBState() == tso.getTurnoutBState();
        }

        public int hashCode() {
            int result = 7;
            result = 37 * result + this.getTurnoutAState();
            result = 37 * result + this.getTurnoutBState();
            return result;
        }
    }
}

