/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastLogicManager;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.signalling.SignallingGuiTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LayoutTurnout
extends LayoutTrack {
    public static final int UNKNOWN = 1;
    public static final int INCONSISTENT = 8;
    public static final int STATE_AC = 2;
    public static final int STATE_BD = 4;
    public static final int STATE_AD = 6;
    public static final int STATE_BC = 8;
    public static final double turnoutBXDefault = 20.0;
    public static final double turnoutCXDefault = 20.0;
    public static final double turnoutWidDefault = 10.0;
    public static final double xOverLongDefault = 30.0;
    public static final double xOverHWidDefault = 10.0;
    public static final double xOverShortDefault = 10.0;
    protected NamedBeanHandle<Turnout> namedTurnout = null;
    protected NamedBeanHandle<Turnout> secondNamedTurnout = null;
    private PropertyChangeListener mTurnoutListener = null;
    @Nonnull
    private String turnoutName = "";
    @Nonnull
    private String secondTurnoutName = "";
    private boolean secondTurnoutInverted = false;
    protected NamedBeanHandle<LayoutBlock> namedLayoutBlockA = null;
    protected NamedBeanHandle<LayoutBlock> namedLayoutBlockB = null;
    protected NamedBeanHandle<LayoutBlock> namedLayoutBlockC = null;
    protected NamedBeanHandle<LayoutBlock> namedLayoutBlockD = null;
    protected NamedBeanHandle<SignalHead> signalA1HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalA2HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalA3HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalB1HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalB2HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalC1HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalC2HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalD1HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalD2HeadNamed = null;
    protected NamedBeanHandle<SignalMast> signalAMastNamed = null;
    protected NamedBeanHandle<SignalMast> signalBMastNamed = null;
    protected NamedBeanHandle<SignalMast> signalCMastNamed = null;
    protected NamedBeanHandle<SignalMast> signalDMastNamed = null;
    protected NamedBeanHandle<Sensor> sensorANamed = null;
    protected NamedBeanHandle<Sensor> sensorBNamed = null;
    protected NamedBeanHandle<Sensor> sensorCNamed = null;
    protected NamedBeanHandle<Sensor> sensorDNamed = null;
    protected final TurnoutType type;
    public LayoutTrack connectA = null;
    public LayoutTrack connectB = null;
    public LayoutTrack connectC = null;
    public LayoutTrack connectD = null;
    public int continuingSense = 2;
    public boolean disabled = false;
    public boolean disableWhenOccupied = false;
    private int version = 1;
    @Nonnull
    public String linkedTurnoutName = "";
    public LinkType linkType = LinkType.NO_LINK;
    private final boolean useBlockSpeed = false;
    public String connectAName = "";
    public String connectBName = "";
    public String connectCName = "";
    public String connectDName = "";
    public String tBlockAName = "";
    public String tBlockBName = "";
    public String tBlockCName = "";
    public String tBlockDName = "";
    boolean active = true;
    private ToolTip _tooltip;
    private boolean _showTooltip;
    private static final Logger log = LoggerFactory.getLogger(LayoutTurnout.class);

    protected LayoutTurnout(@Nonnull String id, @Nonnull LayoutEditor models, TurnoutType t) {
        super(id, models);
        this.type = t;
        this.createTooltip(models);
    }

    protected LayoutTurnout(@Nonnull String id, @Nonnull LayoutEditor models) {
        this(id, models, TurnoutType.NONE);
    }

    public LayoutTurnout(@Nonnull String id, TurnoutType t, @Nonnull LayoutEditor models) {
        this(id, t, models, 1);
    }

    public LayoutTurnout(@Nonnull String id, TurnoutType t, @Nonnull LayoutEditor models, int v) {
        super(id, models);
        this.namedTurnout = null;
        this.turnoutName = "";
        this.mTurnoutListener = null;
        this.disabled = false;
        this.disableWhenOccupied = false;
        this.type = t;
        this.version = v;
        this.createTooltip(models);
    }

    private void createTooltip(LayoutEditor models) {
        ToolTip tt = new ToolTip(null, 0, 0, new Font("SansSerif", 0, 12), Color.black, new Color(215, 225, 255), Color.black, null);
        this.setToolTip(tt);
        this.setShowToolTip(models.showToolTip());
    }

    public static boolean isTurnoutTypeTurnout(TurnoutType type) {
        return type == TurnoutType.RH_TURNOUT || type == TurnoutType.LH_TURNOUT || type == TurnoutType.WYE_TURNOUT;
    }

    public boolean isTurnoutTypeTurnout() {
        return LayoutTurnout.isTurnoutTypeTurnout(this.getTurnoutType());
    }

    public static boolean isTurnoutTypeXover(TurnoutType type) {
        return type == TurnoutType.DOUBLE_XOVER || type == TurnoutType.RH_XOVER || type == TurnoutType.LH_XOVER;
    }

    public boolean isTurnoutTypeXover() {
        return LayoutTurnout.isTurnoutTypeXover(this.getTurnoutType());
    }

    public static boolean isTurnoutTypeSlip(TurnoutType type) {
        return type == TurnoutType.SINGLE_SLIP || type == TurnoutType.DOUBLE_SLIP;
    }

    public boolean isTurnoutTypeSlip() {
        return LayoutTurnout.isTurnoutTypeSlip(this.getTurnoutType());
    }

    public static boolean hasEnteringSingleTrack(TurnoutType type) {
        return LayoutTurnout.isTurnoutTypeTurnout(type);
    }

    public boolean hasEnteringSingleTrack() {
        return LayoutTurnout.hasEnteringSingleTrack(this.getTurnoutType());
    }

    public static boolean hasEnteringDoubleTrack(TurnoutType type) {
        return LayoutTurnout.isTurnoutTypeXover(type) || LayoutTurnout.isTurnoutTypeSlip(type);
    }

    public boolean hasEnteringDoubleTrack() {
        return LayoutTurnout.hasEnteringDoubleTrack(this.getTurnoutType());
    }

    @Nonnull
    public String toString() {
        return "LayoutTurnout " + this.getName();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public boolean useBlockSpeed() {
        return false;
    }

    @Nonnull
    public String getTurnoutName() {
        if (this.namedTurnout != null) {
            this.turnoutName = this.namedTurnout.getName();
        }
        return this.turnoutName;
    }

    @Nonnull
    public String getSecondTurnoutName() {
        if (this.secondNamedTurnout != null) {
            this.secondTurnoutName = this.secondNamedTurnout.getName();
        }
        return this.secondTurnoutName;
    }

    public boolean isSecondTurnoutInverted() {
        return this.secondTurnoutInverted;
    }

    @Nonnull
    public String getBlockName() {
        String result = null;
        if (this.namedLayoutBlockA != null) {
            result = this.namedLayoutBlockA.getName();
        }
        return result == null ? "" : result;
    }

    @Nonnull
    public String getBlockBName() {
        String result = this.getBlockName();
        if (this.namedLayoutBlockB != null) {
            result = this.namedLayoutBlockB.getName();
        }
        return result;
    }

    @Nonnull
    public String getBlockCName() {
        String result = this.getBlockName();
        if (this.namedLayoutBlockC != null) {
            result = this.namedLayoutBlockC.getName();
        }
        return result;
    }

    @Nonnull
    public String getBlockDName() {
        String result = this.getBlockName();
        if (this.namedLayoutBlockD != null) {
            result = this.namedLayoutBlockD.getName();
        }
        return result;
    }

    @CheckForNull
    public SignalHead getSignalHead(Geometry loc) {
        NamedBeanHandle<SignalHead> signalHead = null;
        switch (loc) {
            case POINTA1: {
                signalHead = this.signalA1HeadNamed;
                break;
            }
            case POINTA2: {
                signalHead = this.signalA2HeadNamed;
                break;
            }
            case POINTA3: {
                signalHead = this.signalA3HeadNamed;
                break;
            }
            case POINTB1: {
                signalHead = this.signalB1HeadNamed;
                break;
            }
            case POINTB2: {
                signalHead = this.signalB2HeadNamed;
                break;
            }
            case POINTC1: {
                signalHead = this.signalC1HeadNamed;
                break;
            }
            case POINTC2: {
                signalHead = this.signalC2HeadNamed;
                break;
            }
            case POINTD1: {
                signalHead = this.signalD1HeadNamed;
                break;
            }
            case POINTD2: {
                signalHead = this.signalD2HeadNamed;
                break;
            }
            default: {
                log.warn("{}.getSignalHead({}); Unhandled point type", (Object)this.getName(), (Object)loc);
            }
        }
        if (signalHead != null) {
            return signalHead.getBean();
        }
        return null;
    }

    @CheckForNull
    public SignalHead getSignalA1() {
        return this.signalA1HeadNamed != null ? this.signalA1HeadNamed.getBean() : null;
    }

    @Nonnull
    public String getSignalA1Name() {
        if (this.signalA1HeadNamed != null) {
            return this.signalA1HeadNamed.getName();
        }
        return "";
    }

    public void setSignalA1Name(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalA1HeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        if (head != null) {
            this.signalA1HeadNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head);
        } else {
            this.signalA1HeadNamed = null;
            log.error("{}.setSignalA1Name({}); not fournd for turnout {}", new Object[]{this.getName(), signalHead, this.getTurnoutName()});
        }
    }

    @CheckForNull
    public SignalHead getSignalA2() {
        return this.signalA2HeadNamed != null ? this.signalA2HeadNamed.getBean() : null;
    }

    @Nonnull
    public String getSignalA2Name() {
        if (this.signalA2HeadNamed != null) {
            return this.signalA2HeadNamed.getName();
        }
        return "";
    }

    public void setSignalA2Name(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalA2HeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        if (head != null) {
            this.signalA2HeadNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head);
        } else {
            this.signalA2HeadNamed = null;
            log.error("{}.setSignalA2Name({}); not fournd for turnout {}", new Object[]{this.getName(), signalHead, this.getTurnoutName()});
        }
    }

    @CheckForNull
    public SignalHead getSignalA3() {
        return this.signalA3HeadNamed != null ? this.signalA3HeadNamed.getBean() : null;
    }

    @Nonnull
    public String getSignalA3Name() {
        if (this.signalA3HeadNamed != null) {
            return this.signalA3HeadNamed.getName();
        }
        return "";
    }

    public void setSignalA3Name(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalA3HeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        if (head != null) {
            this.signalA3HeadNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head);
        } else {
            this.signalA3HeadNamed = null;
            log.error("{}.setSignalA3Name({}); not fournd for turnout {}", new Object[]{this.getName(), signalHead, this.getTurnoutName()});
        }
    }

    @CheckForNull
    public SignalHead getSignalB1() {
        return this.signalB1HeadNamed != null ? this.signalB1HeadNamed.getBean() : null;
    }

    @Nonnull
    public String getSignalB1Name() {
        if (this.signalB1HeadNamed != null) {
            return this.signalB1HeadNamed.getName();
        }
        return "";
    }

    public void setSignalB1Name(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalB1HeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        if (head != null) {
            this.signalB1HeadNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head);
        } else {
            this.signalB1HeadNamed = null;
            log.error("{}.setSignalB1Name({}); not fournd for turnout {}", new Object[]{this.getName(), signalHead, this.getTurnoutName()});
        }
    }

    @CheckForNull
    public SignalHead getSignalB2() {
        return this.signalB2HeadNamed != null ? this.signalB2HeadNamed.getBean() : null;
    }

    @Nonnull
    public String getSignalB2Name() {
        if (this.signalB2HeadNamed != null) {
            return this.signalB2HeadNamed.getName();
        }
        return "";
    }

    public void setSignalB2Name(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalB2HeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        if (head != null) {
            this.signalB2HeadNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head);
        } else {
            this.signalB2HeadNamed = null;
            log.error("{}.setSignalB2Name({}); not fournd for turnout {}", new Object[]{this.getName(), signalHead, this.getTurnoutName()});
        }
    }

    @CheckForNull
    public SignalHead getSignalC1() {
        return this.signalC1HeadNamed != null ? this.signalC1HeadNamed.getBean() : null;
    }

    @Nonnull
    public String getSignalC1Name() {
        if (this.signalC1HeadNamed != null) {
            return this.signalC1HeadNamed.getName();
        }
        return "";
    }

    public void setSignalC1Name(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalC1HeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        if (head != null) {
            this.signalC1HeadNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head);
        } else {
            this.signalC1HeadNamed = null;
            log.error("{}.setSignalC1Name({}); not fournd for turnout {}", new Object[]{this.getName(), signalHead, this.getTurnoutName()});
        }
    }

    @CheckForNull
    public SignalHead getSignalC2() {
        return this.signalC2HeadNamed != null ? this.signalC2HeadNamed.getBean() : null;
    }

    @Nonnull
    public String getSignalC2Name() {
        if (this.signalC2HeadNamed != null) {
            return this.signalC2HeadNamed.getName();
        }
        return "";
    }

    public void setSignalC2Name(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalC2HeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        if (head != null) {
            this.signalC2HeadNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head);
        } else {
            this.signalC2HeadNamed = null;
            log.error("{}.setSignalC2Name({}); not fournd for turnout {}", new Object[]{this.getName(), signalHead, this.getTurnoutName()});
        }
    }

    @CheckForNull
    public SignalHead getSignalD1() {
        return this.signalD1HeadNamed != null ? this.signalD1HeadNamed.getBean() : null;
    }

    @Nonnull
    public String getSignalD1Name() {
        if (this.signalD1HeadNamed != null) {
            return this.signalD1HeadNamed.getName();
        }
        return "";
    }

    public void setSignalD1Name(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalD1HeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        if (head != null) {
            this.signalD1HeadNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head);
        } else {
            this.signalD1HeadNamed = null;
            log.error("{}.setSignalD1Name({}); not fournd for turnout {}", new Object[]{this.getName(), signalHead, this.getTurnoutName()});
        }
    }

    @CheckForNull
    public SignalHead getSignalD2() {
        return this.signalD2HeadNamed != null ? this.signalD2HeadNamed.getBean() : null;
    }

    @Nonnull
    public String getSignalD2Name() {
        if (this.signalD2HeadNamed != null) {
            return this.signalD2HeadNamed.getName();
        }
        return "";
    }

    public void setSignalD2Name(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalD2HeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        if (head != null) {
            this.signalD2HeadNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head);
        } else {
            this.signalD2HeadNamed = null;
            log.error("{}.setSignalD2Name({}); not fournd for turnout {}", new Object[]{this.getName(), signalHead, this.getTurnoutName()});
        }
    }

    public void removeBeanReference(@CheckForNull NamedBean nb) {
        if (nb == null) {
            return;
        }
        if (nb instanceof SignalMast) {
            if (nb.equals(this.getSignalAMast())) {
                this.setSignalAMast(null);
                return;
            }
            if (nb.equals(this.getSignalBMast())) {
                this.setSignalBMast(null);
                return;
            }
            if (nb.equals(this.getSignalCMast())) {
                this.setSignalCMast(null);
                return;
            }
            if (nb.equals(this.getSignalDMast())) {
                this.setSignalDMast(null);
            }
        } else if (nb instanceof Sensor) {
            if (nb.equals(this.getSensorA())) {
                this.setSensorA(null);
                return;
            }
            if (nb.equals(this.getSensorB())) {
                this.setSensorB(null);
                return;
            }
            if (nb.equals(this.getSensorC())) {
                this.setSensorC(null);
                return;
            }
            if (nb.equals(this.getSensorB())) {
                this.setSensorD(null);
            }
        } else if (nb instanceof SignalHead) {
            if (nb.equals(this.getSignalHead(Geometry.POINTA1))) {
                this.setSignalA1Name(null);
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTA2))) {
                this.setSignalA2Name(null);
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTA3))) {
                this.setSignalA3Name(null);
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTB1))) {
                this.setSignalB1Name(null);
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTB2))) {
                this.setSignalB2Name(null);
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTC1))) {
                this.setSignalC1Name(null);
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTC2))) {
                this.setSignalC2Name(null);
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTD1))) {
                this.setSignalD1Name(null);
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTD2))) {
                this.setSignalD2Name(null);
            }
        }
    }

    @Override
    public boolean canRemove() {
        ArrayList<String> beanReferences = this.getBeanReferences("All");
        if (!beanReferences.isEmpty()) {
            this.models.displayRemoveWarning(this, beanReferences, "BeanNameTurnout");
        }
        return beanReferences.isEmpty();
    }

    @Nonnull
    public ArrayList<String> getBeanReferences(String pointName) {
        ArrayList<String> references = new ArrayList<String>();
        if (pointName.equals("A") || pointName.equals("All")) {
            if (!this.getSignalAMastName().isEmpty()) {
                references.add(this.getSignalAMastName());
            }
            if (!this.getSensorAName().isEmpty()) {
                references.add(this.getSensorAName());
            }
            if (!this.getSignalA1Name().isEmpty()) {
                references.add(this.getSignalA1Name());
            }
            if (!this.getSignalA2Name().isEmpty()) {
                references.add(this.getSignalA2Name());
            }
            if (!this.getSignalA3Name().isEmpty()) {
                references.add(this.getSignalA3Name());
            }
        }
        if (pointName.equals("B") || pointName.equals("All")) {
            if (!this.getSignalBMastName().isEmpty()) {
                references.add(this.getSignalBMastName());
            }
            if (!this.getSensorBName().isEmpty()) {
                references.add(this.getSensorBName());
            }
            if (!this.getSignalB1Name().isEmpty()) {
                references.add(this.getSignalB1Name());
            }
            if (!this.getSignalB2Name().isEmpty()) {
                references.add(this.getSignalB2Name());
            }
        }
        if (pointName.equals("C") || pointName.equals("All")) {
            if (!this.getSignalCMastName().isEmpty()) {
                references.add(this.getSignalCMastName());
            }
            if (!this.getSensorCName().isEmpty()) {
                references.add(this.getSensorCName());
            }
            if (!this.getSignalC1Name().isEmpty()) {
                references.add(this.getSignalC1Name());
            }
            if (!this.getSignalC2Name().isEmpty()) {
                references.add(this.getSignalC2Name());
            }
        }
        if (pointName.equals("D") || pointName.equals("All")) {
            if (!this.getSignalDMastName().isEmpty()) {
                references.add(this.getSignalDMastName());
            }
            if (!this.getSensorDName().isEmpty()) {
                references.add(this.getSensorDName());
            }
            if (!this.getSignalD1Name().isEmpty()) {
                references.add(this.getSignalD1Name());
            }
            if (!this.getSignalD2Name().isEmpty()) {
                references.add(this.getSignalD2Name());
            }
        }
        return references;
    }

    @Nonnull
    public String getSignalAMastName() {
        if (this.signalAMastNamed != null) {
            return this.signalAMastNamed.getName();
        }
        return "";
    }

    public SignalMast getSignalAMast() {
        if (this.signalAMastNamed != null) {
            return this.signalAMastNamed.getBean();
        }
        return null;
    }

    public void setSignalAMast(@CheckForNull String signalMast) {
        if (signalMast == null || signalMast.isEmpty()) {
            this.signalAMastNamed = null;
            return;
        }
        SignalMast mast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMast);
        if (mast != null) {
            this.signalAMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        } else {
            this.signalAMastNamed = null;
            log.error("{}.setSignalAMast({}); not fournd for turnout {}", new Object[]{this.getName(), signalMast, this.getTurnoutName()});
        }
    }

    @Nonnull
    public String getSignalBMastName() {
        if (this.signalBMastNamed != null) {
            return this.signalBMastNamed.getName();
        }
        return "";
    }

    public SignalMast getSignalBMast() {
        if (this.signalBMastNamed != null) {
            return this.signalBMastNamed.getBean();
        }
        return null;
    }

    public void setSignalBMast(@CheckForNull String signalMast) {
        if (signalMast == null || signalMast.isEmpty()) {
            this.signalBMastNamed = null;
            return;
        }
        SignalMast mast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMast);
        if (mast != null) {
            this.signalBMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        } else {
            this.signalBMastNamed = null;
            log.error("{}.setSignalBMast({}); not fournd for turnout {}", new Object[]{this.getName(), signalMast, this.getTurnoutName()});
        }
    }

    @Nonnull
    public String getSignalCMastName() {
        if (this.signalCMastNamed != null) {
            return this.signalCMastNamed.getName();
        }
        return "";
    }

    public SignalMast getSignalCMast() {
        if (this.signalCMastNamed != null) {
            return this.signalCMastNamed.getBean();
        }
        return null;
    }

    public void setSignalCMast(@CheckForNull String signalMast) {
        if (signalMast == null || signalMast.isEmpty()) {
            this.signalCMastNamed = null;
            return;
        }
        SignalMast mast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMast);
        if (mast != null) {
            this.signalCMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        } else {
            log.error("{}.setSignalCMast({}); not fournd for turnout {}", new Object[]{this.getName(), signalMast, this.getTurnoutName()});
            this.signalCMastNamed = null;
        }
    }

    @Nonnull
    public String getSignalDMastName() {
        if (this.signalDMastNamed != null) {
            return this.signalDMastNamed.getName();
        }
        return "";
    }

    public SignalMast getSignalDMast() {
        if (this.signalDMastNamed != null) {
            return this.signalDMastNamed.getBean();
        }
        return null;
    }

    public void setSignalDMast(@CheckForNull String signalMast) {
        if (signalMast == null || signalMast.isEmpty()) {
            this.signalDMastNamed = null;
            return;
        }
        SignalMast mast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMast);
        if (mast != null) {
            this.signalDMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        } else {
            log.error("{}.setSignalDMast({}); not fournd for turnout {}", new Object[]{this.getName(), signalMast, this.getTurnoutName()});
            this.signalDMastNamed = null;
        }
    }

    @Nonnull
    public String getSensorAName() {
        if (this.sensorANamed != null) {
            return this.sensorANamed.getName();
        }
        return "";
    }

    @CheckForNull
    public Sensor getSensorA() {
        if (this.sensorANamed != null) {
            return this.sensorANamed.getBean();
        }
        return null;
    }

    public void setSensorA(@CheckForNull String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.sensorANamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.sensorANamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException ex) {
            this.sensorANamed = null;
        }
    }

    @Nonnull
    public String getSensorBName() {
        if (this.sensorBNamed != null) {
            return this.sensorBNamed.getName();
        }
        return "";
    }

    @CheckForNull
    public Sensor getSensorB() {
        if (this.sensorBNamed != null) {
            return this.sensorBNamed.getBean();
        }
        return null;
    }

    public void setSensorB(@CheckForNull String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.sensorBNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.sensorBNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException ex) {
            this.sensorBNamed = null;
        }
    }

    @Nonnull
    public String getSensorCName() {
        if (this.sensorCNamed != null) {
            return this.sensorCNamed.getName();
        }
        return "";
    }

    @CheckForNull
    public Sensor getSensorC() {
        if (this.sensorCNamed != null) {
            return this.sensorCNamed.getBean();
        }
        return null;
    }

    public void setSensorC(@CheckForNull String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.sensorCNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.sensorCNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException ex) {
            this.sensorCNamed = null;
        }
    }

    @Nonnull
    public String getSensorDName() {
        if (this.sensorDNamed != null) {
            return this.sensorDNamed.getName();
        }
        return "";
    }

    @CheckForNull
    public Sensor getSensorD() {
        if (this.sensorDNamed != null) {
            return this.sensorDNamed.getBean();
        }
        return null;
    }

    public void setSensorD(@CheckForNull String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.sensorDNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.sensorDNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException ex) {
            this.sensorDNamed = null;
        }
    }

    @Nonnull
    public String getLinkedTurnoutName() {
        return this.linkedTurnoutName;
    }

    public void setLinkedTurnoutName(@Nonnull String s) {
        this.linkedTurnoutName = s;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(LinkType ltype) {
        this.linkType = ltype;
    }

    public TurnoutType getTurnoutType() {
        return this.type;
    }

    public LayoutTrack getConnectA() {
        return this.connectA;
    }

    public LayoutTrack getConnectB() {
        return this.connectB;
    }

    public LayoutTrack getConnectC() {
        return this.connectC;
    }

    public LayoutTrack getConnectD() {
        return this.connectD;
    }

    public Turnout getTurnout() {
        if (this.namedTurnout == null) {
            this.setTurnout(this.turnoutName);
            if (this.namedTurnout == null) {
                return null;
            }
        }
        return this.namedTurnout.getBean();
    }

    public int getContinuingSense() {
        return this.continuingSense;
    }

    public boolean isInContinuingSenseState() {
        return this.getState() == this.continuingSense;
    }

    public void setTurnout(@Nonnull String name) {
        String tName = Objects.requireNonNull(name);
        if (this.namedTurnout != null) {
            this.deactivateTurnout();
        }
        this.turnoutName = tName;
        Turnout turnout = null;
        if (!this.turnoutName.isEmpty()) {
            turnout = InstanceManager.turnoutManagerInstance().getTurnout(this.turnoutName);
        }
        if (turnout != null) {
            this.namedTurnout = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this.turnoutName, turnout);
            this.activateTurnout();
        } else {
            this.turnoutName = "";
            this.namedTurnout = null;
            this.setDisableWhenOccupied(false);
        }
        Turnout secondTurnout = this.getSecondTurnout();
        if (secondTurnout != null && secondTurnout.getFeedbackMode() == 1) {
            secondTurnout.setLeadingTurnout(turnout, false);
        }
    }

    public Turnout getSecondTurnout() {
        Turnout result = null;
        if (this.secondNamedTurnout == null) {
            this.setSecondTurnout(this.secondTurnoutName);
        }
        if (this.secondNamedTurnout != null) {
            result = this.secondNamedTurnout.getBean();
        }
        return result;
    }

    public void setSecondTurnout(@Nonnull String name) {
        String tName = Objects.requireNonNull(name);
        if (tName.equals(this.secondTurnoutName)) {
            return;
        }
        if (this.secondNamedTurnout != null) {
            this.deactivateTurnout();
            Turnout turnout = this.secondNamedTurnout.getBean();
            if (turnout.getLeadingTurnout() == this.namedTurnout.getBean()) {
                turnout.setLeadingTurnout(null);
            }
        }
        String oldSecondTurnoutName = this.secondTurnoutName;
        this.secondTurnoutName = tName;
        Turnout turnout = null;
        if (!tName.isEmpty()) {
            turnout = InstanceManager.turnoutManagerInstance().getTurnout(this.secondTurnoutName);
        }
        if (turnout != null) {
            this.secondNamedTurnout = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this.secondTurnoutName, turnout);
            if (turnout.getFeedbackMode() == 1) {
                turnout.setLeadingTurnout(this.getTurnout(), false);
            }
        } else {
            this.secondTurnoutName = "";
            this.secondNamedTurnout = null;
        }
        this.activateTurnout();
        if (this.isTurnoutTypeTurnout()) {
            LayoutEditorFindItems lf = new LayoutEditorFindItems(this.models);
            if (oldSecondTurnoutName != null && !oldSecondTurnoutName.isEmpty()) {
                LayoutTurnout oldLinked;
                Turnout oldTurnout = InstanceManager.turnoutManagerInstance().getTurnout(oldSecondTurnoutName);
                String oldSystemName = oldTurnout == null ? null : oldTurnout.getSystemName();
                LayoutTurnout layoutTurnout = oldLinked = oldSystemName == null ? null : lf.findLayoutTurnoutByTurnoutName(oldSystemName);
                if (oldLinked == null) {
                    String oldUserName = oldTurnout == null ? null : oldTurnout.getUserName();
                    LayoutTurnout layoutTurnout2 = oldLinked = oldUserName == null ? null : lf.findLayoutTurnoutByTurnoutName(oldUserName);
                }
                if (oldLinked != null && oldLinked.getSecondTurnout() == this.getTurnout()) {
                    oldLinked.setSecondTurnout("");
                }
            }
            if (turnout != null) {
                LayoutTurnout newLinked = lf.findLayoutTurnoutByTurnoutName(turnout.getSystemName());
                if (newLinked == null) {
                    newLinked = lf.findLayoutTurnoutByTurnoutName(turnout.getUserName());
                }
                if (newLinked != null) {
                    newLinked.setSecondTurnout(this.turnoutName);
                }
            }
        }
    }

    public void setSecondTurnoutInverted(boolean inverted) {
        this.secondTurnoutInverted = inverted;
    }

    public void setContinuingSense(int sense) {
        this.continuingSense = sense;
    }

    public void setDisabled(boolean state) {
        if (this.disabled != state) {
            this.disabled = state;
            if (this.models != null) {
                this.models.redrawPanel();
            }
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisableWhenOccupied(boolean state) {
        if (this.disableWhenOccupied != state) {
            this.disableWhenOccupied = state;
            if (this.models != null) {
                this.models.redrawPanel();
            }
        }
    }

    public boolean isDisabledWhenOccupied() {
        return this.disableWhenOccupied;
    }

    @Override
    @CheckForNull
    public LayoutTrack getConnection(HitPointType connectionType) {
        LayoutTrack result = null;
        switch (connectionType) {
            case TURNOUT_A: {
                result = this.connectA;
                break;
            }
            case TURNOUT_B: {
                result = this.connectB;
                break;
            }
            case TURNOUT_C: {
                result = this.connectC;
                break;
            }
            case TURNOUT_D: {
                result = this.connectD;
                break;
            }
            default: {
                String errString = MessageFormat.format("{0}.getConnection({1}); Invalid Connection Type", new Object[]{this.getName(), connectionType});
                log.error("will throw {}", (Object)errString);
                throw new IllegalArgumentException(errString);
            }
        }
        return result;
    }

    @Override
    public void setConnection(HitPointType connectionType, @CheckForNull LayoutTrack o, HitPointType type) throws JmriException {
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); unexpected type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type, new Exception("traceback")});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        switch (connectionType) {
            case TURNOUT_A: {
                this.connectA = o;
                break;
            }
            case TURNOUT_B: {
                this.connectB = o;
                break;
            }
            case TURNOUT_C: {
                this.connectC = o;
                break;
            }
            case TURNOUT_D: {
                this.connectD = o;
                break;
            }
            default: {
                String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid Connection Type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
                log.error("will throw {}", (Object)errString);
                throw new JmriException(errString);
            }
        }
    }

    public void setConnectA(@CheckForNull LayoutTrack o, HitPointType type) {
        this.connectA = o;
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            log.error("{}.setConnectA({}, {}); unexpected type", new Object[]{this.getName(), o == null ? "null" : o.getName(), type});
        }
    }

    public void setConnectB(@CheckForNull LayoutTrack o, HitPointType type) {
        this.connectB = o;
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            log.error("{}.setConnectB({}, {}); unexpected type", new Object[]{this.getName(), o == null ? "null" : o.getName(), type});
        }
    }

    public void setConnectC(@CheckForNull LayoutTrack o, HitPointType type) {
        this.connectC = o;
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            log.error("{}.setConnectC({}, {}); unexpected type", new Object[]{this.getName(), o == null ? "null" : o.getName(), type});
        }
    }

    public void setConnectD(@CheckForNull LayoutTrack o, HitPointType type) {
        this.connectD = o;
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            log.error("{}.setConnectD({}, {}); unexpected type", new Object[]{this.getName(), o == null ? "null" : o.getName(), type});
        }
    }

    public LayoutBlock getLayoutBlock() {
        return this.namedLayoutBlockA != null ? this.namedLayoutBlockA.getBean() : null;
    }

    public LayoutBlock getLayoutBlockB() {
        return this.namedLayoutBlockB != null ? this.namedLayoutBlockB.getBean() : this.getLayoutBlock();
    }

    public LayoutBlock getLayoutBlockC() {
        return this.namedLayoutBlockC != null ? this.namedLayoutBlockC.getBean() : this.getLayoutBlock();
    }

    public LayoutBlock getLayoutBlockD() {
        return this.namedLayoutBlockD != null ? this.namedLayoutBlockD.getBean() : this.getLayoutBlock();
    }

    public void updateBlockInfo() {
        LayoutBlock bA = null;
        LayoutBlock bB = null;
        LayoutBlock bC = null;
        LayoutBlock bD = null;
        this.models.getLEAuxTools().setBlockConnectivityChanged();
        if (this.getLayoutBlock() != null) {
            this.getLayoutBlock().updatePaths();
        }
        if (this.connectA != null && (bA = ((TrackSegment)this.connectA).getLayoutBlock()) != null && bA != this.getLayoutBlock()) {
            bA.updatePaths();
        }
        if (this.getLayoutBlockB() != null && this.getLayoutBlockB() != this.getLayoutBlock() && this.getLayoutBlockB() != bA) {
            this.getLayoutBlockB().updatePaths();
        }
        if (this.connectB != null && (bB = ((TrackSegment)this.connectB).getLayoutBlock()) != null && bB != this.getLayoutBlock() && bB != bA && bB != this.getLayoutBlockB()) {
            bB.updatePaths();
        }
        if (this.getLayoutBlockC() != null && this.getLayoutBlockC() != this.getLayoutBlock() && this.getLayoutBlockC() != bA && this.getLayoutBlockC() != bB && this.getLayoutBlockC() != this.getLayoutBlockB()) {
            this.getLayoutBlockC().updatePaths();
        }
        if (this.connectC != null && (bC = ((TrackSegment)this.connectC).getLayoutBlock()) != null && bC != this.getLayoutBlock() && bC != bA && bC != this.getLayoutBlockB() && bC != bB && bC != this.getLayoutBlockC()) {
            bC.updatePaths();
        }
        if (this.getLayoutBlockD() != null && this.getLayoutBlockD() != this.getLayoutBlock() && this.getLayoutBlockD() != bA && this.getLayoutBlockD() != bB && this.getLayoutBlockD() != this.getLayoutBlockB() && this.getLayoutBlockD() != bC && this.getLayoutBlockD() != this.getLayoutBlockC()) {
            this.getLayoutBlockD().updatePaths();
        }
        if (this.connectD != null && (bD = ((TrackSegment)this.connectD).getLayoutBlock()) != null && bD != this.getLayoutBlock() && bD != bA && bD != this.getLayoutBlockB() && bD != bB && bD != this.getLayoutBlockC() && bD != bC && bD != this.getLayoutBlockD()) {
            bD.updatePaths();
        }
    }

    protected void setLayoutBlock(LayoutBlock newLayoutBlock) {
        LayoutBlock blockA = this.getLayoutBlock();
        LayoutBlock blockB = this.getLayoutBlockB();
        LayoutBlock blockC = this.getLayoutBlockC();
        LayoutBlock blockD = this.getLayoutBlockD();
        if (blockA != newLayoutBlock) {
            if (blockA != null && blockA != blockB && blockA != blockC && blockA != blockD) {
                blockA.decrementUse();
            }
            blockA = newLayoutBlock;
            if (newLayoutBlock != null) {
                String userName = newLayoutBlock.getUserName();
                if (userName != null) {
                    this.namedLayoutBlockA = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, newLayoutBlock);
                }
            } else {
                this.namedLayoutBlockA = null;
                this.setDisableWhenOccupied(false);
            }
            if (blockA != null && (blockA == blockB || blockA == blockC || blockA == blockD)) {
                blockA.decrementUse();
            }
        }
    }

    protected void setLayoutBlockB(LayoutBlock newLayoutBlock) {
        if (this.getLayoutBlock() == null) {
            this.setLayoutBlock(newLayoutBlock);
        }
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            LayoutBlock blockA = this.getLayoutBlock();
            LayoutBlock blockB = this.getLayoutBlockB();
            LayoutBlock blockC = this.getLayoutBlockC();
            LayoutBlock blockD = this.getLayoutBlockD();
            if (blockB != newLayoutBlock) {
                if (blockB != null && blockB != blockA && blockB != blockC && blockB != blockD) {
                    blockB.decrementUse();
                }
                blockB = newLayoutBlock;
                if (newLayoutBlock != null) {
                    String userName = newLayoutBlock.getUserName();
                    if (userName != null) {
                        this.namedLayoutBlockB = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, newLayoutBlock);
                    }
                } else {
                    this.namedLayoutBlockB = null;
                }
                if (blockB != null && (blockB == blockA || blockB == blockC || blockB == blockD)) {
                    blockB.decrementUse();
                }
            }
        } else {
            log.error("{}.setLayoutBlockB({}); not a crossover/slip", (Object)this.getName(), (Object)newLayoutBlock.getUserName());
        }
    }

    protected void setLayoutBlockC(@CheckForNull LayoutBlock newLayoutBlock) {
        if (this.getLayoutBlock() == null) {
            this.setLayoutBlock(newLayoutBlock);
        }
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            LayoutBlock blockA = this.getLayoutBlock();
            LayoutBlock blockB = this.getLayoutBlockB();
            LayoutBlock blockC = this.getLayoutBlockC();
            LayoutBlock blockD = this.getLayoutBlockD();
            if (blockC != newLayoutBlock) {
                if (blockC != null && blockC != blockA && blockC != blockB && blockC != blockD) {
                    blockC.decrementUse();
                }
                blockC = newLayoutBlock;
                if (newLayoutBlock != null) {
                    String userName = newLayoutBlock.getUserName();
                    if (userName != null) {
                        this.namedLayoutBlockC = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, newLayoutBlock);
                    }
                } else {
                    this.namedLayoutBlockC = null;
                }
                if (blockC != null && (blockC == blockA || blockC == blockB || blockC == blockD)) {
                    blockC.decrementUse();
                }
            }
        } else {
            log.error("{}.setLayoutBlockC({}); not a crossover/slip", (Object)this.getName(), (Object)newLayoutBlock.getUserName());
        }
    }

    protected void setLayoutBlockD(LayoutBlock newLayoutBlock) {
        if (this.getLayoutBlock() == null) {
            this.setLayoutBlock(newLayoutBlock);
        }
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            LayoutBlock blockA = this.getLayoutBlock();
            LayoutBlock blockB = this.getLayoutBlockB();
            LayoutBlock blockC = this.getLayoutBlockC();
            LayoutBlock blockD = this.getLayoutBlockD();
            if (blockD != newLayoutBlock) {
                if (blockD != null && blockD != blockA && blockD != blockB && blockD != blockC) {
                    blockD.decrementUse();
                }
                blockD = newLayoutBlock;
                if (newLayoutBlock != null) {
                    String userName = newLayoutBlock.getUserName();
                    if (userName != null) {
                        this.namedLayoutBlockD = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, newLayoutBlock);
                    }
                } else {
                    this.namedLayoutBlockD = null;
                }
                if (blockD != null && (blockD == blockA || blockD == blockB || blockD == blockC)) {
                    blockD.decrementUse();
                }
            }
        } else {
            log.error("{}.setLayoutBlockD({}); not a crossover/slip", (Object)this.getName(), (Object)newLayoutBlock.getUserName());
        }
    }

    public void setLayoutBlockByName(@Nonnull String name) {
        this.setLayoutBlock(this.models.provideLayoutBlock(name));
    }

    public void setLayoutBlockBByName(@Nonnull String name) {
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            this.setLayoutBlockB(this.models.provideLayoutBlock(name));
        } else {
            log.error("{}.setLayoutBlockBByName({}); not a crossover/slip", (Object)this.getName(), (Object)name);
        }
    }

    public void setLayoutBlockCByName(@Nonnull String name) {
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            this.setLayoutBlockC(this.models.provideLayoutBlock(name));
        } else {
            log.error("{}.setLayoutBlockCByName({}); not a crossover/slip", (Object)this.getName(), (Object)name);
        }
    }

    public void setLayoutBlockDByName(@Nonnull String name) {
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            this.setLayoutBlockD(this.models.provideLayoutBlock(name));
        } else {
            log.error("{}.setLayoutBlockDByName({}); not a crossover/slip", (Object)this.getName(), (Object)name);
        }
    }

    public boolean isMainlineA() {
        if (this.connectA != null) {
            return ((TrackSegment)this.connectA).isMainline();
        }
        if (this.isTurnoutTypeXover()) {
            if (this.connectB != null) {
                return ((TrackSegment)this.connectB).isMainline();
            }
        } else if (this.isTurnoutTypeSlip()) {
            if (this.connectD != null) {
                return ((TrackSegment)this.connectD).isMainline();
            }
        } else if (this.connectB != null && ((TrackSegment)this.connectB).isMainline() || this.connectC != null && ((TrackSegment)this.connectC).isMainline()) {
            return true;
        }
        return false;
    }

    public boolean isMainlineB() {
        if (this.connectB != null) {
            return ((TrackSegment)this.connectB).isMainline();
        }
        if (this.isTurnoutTypeXover()) {
            if (this.connectA != null) {
                return ((TrackSegment)this.connectA).isMainline();
            }
        } else if (this.getTurnoutType() == TurnoutType.DOUBLE_SLIP) {
            if (this.connectD != null) {
                return ((TrackSegment)this.connectD).isMainline();
            }
        } else if (this.continuingSense == 2 && this.connectA != null) {
            return ((TrackSegment)this.connectA).isMainline();
        }
        return false;
    }

    public boolean isMainlineC() {
        if (this.connectC != null) {
            return ((TrackSegment)this.connectC).isMainline();
        }
        if (this.isTurnoutTypeXover()) {
            if (this.connectD != null) {
                return ((TrackSegment)this.connectD).isMainline();
            }
        } else if (this.getTurnoutType() == TurnoutType.DOUBLE_SLIP) {
            if (this.connectB != null) {
                return ((TrackSegment)this.connectB).isMainline();
            }
        } else if (this.continuingSense == 4 && this.connectA != null) {
            return ((TrackSegment)this.connectA).isMainline();
        }
        return false;
    }

    public boolean isMainlineD() {
        if (this.connectD != null) {
            return ((TrackSegment)this.connectD).isMainline();
        }
        if (this.isTurnoutTypeSlip()) {
            if (this.connectB != null) {
                return ((TrackSegment)this.connectB).isMainline();
            }
        } else if (this.connectC != null) {
            return ((TrackSegment)this.connectC).isMainline();
        }
        return false;
    }

    @Override
    public boolean isMainline() {
        return this.isMainlineA() || this.isMainlineB() || this.isMainlineC() || this.isMainlineD();
    }

    private void activateTurnout() {
        this.deactivateTurnout();
        if (this.namedTurnout != null) {
            this.mTurnoutListener = e -> {
                if (e.getNewValue() == null) {
                    return;
                }
                if (this.disableWhenOccupied && this.isOccupied()) {
                    return;
                }
                if (this.secondNamedTurnout != null) {
                    int t1state = this.namedTurnout.getBean().getCommandedState();
                    int t2state = this.secondNamedTurnout.getBean().getCommandedState();
                    if (e.getSource().equals(this.namedTurnout.getBean()) && e.getNewValue().equals(t1state)) {
                        if (this.secondTurnoutInverted) {
                            t1state = Turnout.invertTurnoutState(t1state);
                        }
                        if (this.secondNamedTurnout.getBean().getCommandedState() != t1state) {
                            this.secondNamedTurnout.getBean().setCommandedState(t1state);
                        }
                    } else if (e.getSource().equals(this.secondNamedTurnout.getBean()) && e.getNewValue().equals(t2state)) {
                        if (this.secondTurnoutInverted) {
                            t2state = Turnout.invertTurnoutState(t2state);
                        }
                        if (this.namedTurnout.getBean().getCommandedState() != t2state) {
                            this.namedTurnout.getBean().setCommandedState(t2state);
                        }
                    }
                }
                this.models.redrawPanel();
            };
            this.namedTurnout.getBean().addPropertyChangeListener(this.mTurnoutListener, this.namedTurnout.getName(), "Layout Editor Turnout");
        }
        if (this.secondNamedTurnout != null) {
            this.secondNamedTurnout.getBean().addPropertyChangeListener(this.mTurnoutListener, this.secondNamedTurnout.getName(), "Layout Editor Turnout");
        }
    }

    private void deactivateTurnout() {
        if (this.mTurnoutListener != null) {
            if (this.namedTurnout != null) {
                this.namedTurnout.getBean().removePropertyChangeListener(this.mTurnoutListener);
            }
            if (this.secondNamedTurnout != null) {
                this.secondNamedTurnout.getBean().removePropertyChangeListener(this.mTurnoutListener);
            }
            this.mTurnoutListener = null;
        }
    }

    public void toggleTurnout() {
        if (this.getTurnout() != null) {
            if (this.getTurnout().getCommandedState() == 2) {
                this.setState(4);
            } else {
                this.setState(2);
            }
        } else {
            log.debug("Turnout Icon not associated with a Turnout");
        }
    }

    public void setState(int state) {
        if (this.getTurnout() != null && !this.disabled) {
            if (this.disableWhenOccupied && this.isOccupied()) {
                log.debug("Turnout not changed as Block is Occupied");
            } else {
                this.getTurnout().setCommandedState(state);
                Turnout secondTurnout = this.getSecondTurnout();
                if (secondTurnout != null) {
                    if (this.secondTurnoutInverted) {
                        secondTurnout.setCommandedState(Turnout.invertTurnoutState(state));
                    } else {
                        secondTurnout.setCommandedState(state);
                    }
                }
            }
        }
    }

    public int getState() {
        int result = 1;
        if (this.getTurnout() != null) {
            result = this.getTurnout().getKnownState();
        }
        if (this.getSecondTurnout() != null) {
            int t2state = this.getSecondTurnout().getKnownState();
            if (this.secondTurnoutInverted) {
                t2state = Turnout.invertTurnoutState(t2state);
            }
            if (result != t2state) {
                return 8;
            }
        }
        return result;
    }

    boolean isOccupied() {
        if (this.isTurnoutTypeTurnout()) {
            if (this.getLayoutBlock().getOccupancy() == 2) {
                log.debug("Block {} is Occupied", (Object)this.getBlockName());
                return true;
            }
        } else if (this.isTurnoutTypeXover() && this.getTurnout().getKnownState() == 2) {
            if (this.getLayoutBlock().getOccupancy() == 2 && this.getLayoutBlockB().getOccupancy() == 2) {
                log.debug("Blocks {} & {} are Occupied", (Object)this.getBlockName(), (Object)this.getBlockBName());
                return true;
            }
            if (this.getLayoutBlockC().getOccupancy() == 2 && this.getLayoutBlockD().getOccupancy() == 2) {
                log.debug("Blocks {} & {} are Occupied", (Object)this.getBlockCName(), (Object)this.getBlockDName());
                return true;
            }
        }
        if ((this.getTurnoutType() == TurnoutType.DOUBLE_XOVER || this.getTurnoutType() == TurnoutType.LH_XOVER) && this.getTurnout().getKnownState() == 4 && this.getLayoutBlockB().getOccupancy() == 2 && this.getLayoutBlockD().getOccupancy() == 2) {
            log.debug("Blocks {} & {} are Occupied", (Object)this.getBlockBName(), (Object)this.getBlockDName());
            return true;
        }
        if ((this.getTurnoutType() == TurnoutType.DOUBLE_XOVER || this.getTurnoutType() == TurnoutType.RH_XOVER) && this.getTurnout().getKnownState() == 4 && this.getLayoutBlock().getOccupancy() == 2 && this.getLayoutBlockC().getOccupancy() == 2) {
            log.debug("Blocks {} & {} are Occupied", (Object)this.getLayoutBlock(), (Object)this.getBlockCName());
            return true;
        }
        return false;
    }

    @Override
    public void setObjects(@Nonnull LayoutEditor p) {
        String userName;
        LayoutBlock lb;
        this.connectA = p.getFinder().findTrackSegmentByName(this.connectAName);
        this.connectB = p.getFinder().findTrackSegmentByName(this.connectBName);
        this.connectC = p.getFinder().findTrackSegmentByName(this.connectCName);
        this.connectD = p.getFinder().findTrackSegmentByName(this.connectDName);
        if (!this.tBlockAName.isEmpty()) {
            lb = p.provideLayoutBlock(this.tBlockAName);
            if (lb != null) {
                userName = lb.getUserName();
                if (userName != null) {
                    this.namedLayoutBlockA = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, lb);
                    lb.incrementUse();
                }
            } else {
                log.error("{}.setObjects(...); bad blockname A '{}'", (Object)this.getName(), (Object)this.tBlockAName);
                this.namedLayoutBlockA = null;
            }
            this.tBlockAName = null;
        }
        if (!this.tBlockBName.isEmpty()) {
            lb = p.provideLayoutBlock(this.tBlockBName);
            if (lb != null) {
                userName = lb.getUserName();
                if (userName != null) {
                    this.namedLayoutBlockB = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, lb);
                }
                if (this.namedLayoutBlockB != this.namedLayoutBlockA) {
                    lb.incrementUse();
                }
            } else {
                log.error("{}.setObjects(...); bad blockname B '{}'", (Object)this.getName(), (Object)this.tBlockBName);
                this.namedLayoutBlockB = null;
            }
            this.tBlockBName = null;
        }
        if (!this.tBlockCName.isEmpty()) {
            lb = p.provideLayoutBlock(this.tBlockCName);
            if (lb != null) {
                userName = lb.getUserName();
                if (userName != null) {
                    this.namedLayoutBlockC = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, lb);
                }
                if (this.namedLayoutBlockC != this.namedLayoutBlockA && this.namedLayoutBlockC != this.namedLayoutBlockB) {
                    lb.incrementUse();
                }
            } else {
                log.error("{}.setObjects(...); bad blockname C '{}'", (Object)this.getName(), (Object)this.tBlockCName);
                this.namedLayoutBlockC = null;
            }
            this.tBlockCName = null;
        }
        if (!this.tBlockDName.isEmpty()) {
            lb = p.provideLayoutBlock(this.tBlockDName);
            if (lb != null) {
                userName = lb.getUserName();
                if (userName != null) {
                    this.namedLayoutBlockD = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, lb);
                }
                if (this.namedLayoutBlockD != this.namedLayoutBlockA && this.namedLayoutBlockD != this.namedLayoutBlockB && this.namedLayoutBlockD != this.namedLayoutBlockC) {
                    lb.incrementUse();
                }
            } else {
                log.error("{}.setObjects(...); bad blockname D '{}'", (Object)this.getName(), (Object)this.tBlockDName);
                this.namedLayoutBlockD = null;
            }
            this.tBlockDName = null;
        }
        this.activateTurnout();
    }

    public String[] getBlockBoundaries() {
        String[] boundaryBetween = new String[4];
        if (this.isTurnoutTypeTurnout()) {
            if (this.getLayoutBlock() != null) {
                LayoutBlock aLBlock = null;
                if (this.connectA instanceof TrackSegment && (aLBlock = ((TrackSegment)this.connectA).getLayoutBlock()) != this.getLayoutBlock()) {
                    try {
                        boundaryBetween[0] = aLBlock.getDisplayName() + " - " + this.getLayoutBlock().getDisplayName();
                    }
                    catch (NullPointerException e) {
                        log.debug("TrackSegement at connection A doesn't contain a layout block");
                    }
                }
                LayoutBlock bLBlock = null;
                if (this.connectB instanceof TrackSegment && (bLBlock = ((TrackSegment)this.connectB).getLayoutBlock()) != this.getLayoutBlock()) {
                    try {
                        boundaryBetween[1] = bLBlock.getDisplayName() + " - " + this.getLayoutBlock().getDisplayName();
                    }
                    catch (NullPointerException e) {
                        log.debug("TrackSegement at connection B doesn't contain a layout block");
                    }
                }
                LayoutBlock cLBlock = null;
                if (this.connectC instanceof TrackSegment && ((TrackSegment)this.connectC).getLayoutBlock() != this.getLayoutBlock() && (cLBlock = ((TrackSegment)this.connectC).getLayoutBlock()) != this.getLayoutBlock()) {
                    try {
                        boundaryBetween[2] = cLBlock.getDisplayName() + " - " + this.getLayoutBlock().getDisplayName();
                    }
                    catch (NullPointerException e) {
                        log.debug("TrackSegement at connection C doesn't contain a layout block");
                    }
                }
            }
        } else {
            LayoutBlock aLBlock = null;
            LayoutBlock bLBlock = null;
            LayoutBlock cLBlock = null;
            LayoutBlock dLBlock = null;
            if (this.getLayoutBlock() != null) {
                if (this.connectA instanceof TrackSegment) {
                    aLBlock = ((TrackSegment)this.connectA).getLayoutBlock();
                    if (aLBlock != this.getLayoutBlock()) {
                        try {
                            boundaryBetween[0] = aLBlock.getDisplayName() + " - " + this.getLayoutBlock().getDisplayName();
                        }
                        catch (NullPointerException e) {
                            log.debug("TrackSegement at connection A doesn't contain a layout block");
                        }
                    } else if (this.getLayoutBlock() != this.getLayoutBlockB()) {
                        try {
                            boundaryBetween[0] = this.getLayoutBlock().getDisplayName() + " - " + this.getLayoutBlockB().getDisplayName();
                        }
                        catch (NullPointerException e) {
                            log.debug("TrackSegement at connection A doesn't contain a layout block");
                        }
                    }
                }
                if (this.connectB instanceof TrackSegment) {
                    bLBlock = ((TrackSegment)this.connectB).getLayoutBlock();
                    if (bLBlock != this.getLayoutBlock() && bLBlock != this.getLayoutBlockB()) {
                        try {
                            boundaryBetween[1] = bLBlock.getDisplayName() + " - " + this.getLayoutBlockB().getDisplayName();
                        }
                        catch (NullPointerException e) {
                            log.debug("TrackSegement at connection B doesn't contain a layout block");
                        }
                    } else if (this.getLayoutBlock() != this.getLayoutBlockB()) {
                        try {
                            boundaryBetween[1] = this.getLayoutBlockB().getDisplayName() + " - " + this.getLayoutBlock().getDisplayName();
                        }
                        catch (NullPointerException e) {
                            log.debug("TrackSegement at connection A doesn't contain a layout block");
                        }
                    }
                }
                if (this.connectC instanceof TrackSegment) {
                    cLBlock = ((TrackSegment)this.connectC).getLayoutBlock();
                    if (cLBlock != this.getLayoutBlock() && cLBlock != this.getLayoutBlockB() && cLBlock != this.getLayoutBlockC()) {
                        try {
                            boundaryBetween[2] = cLBlock.getDisplayName() + " - " + this.getLayoutBlockC().getDisplayName();
                        }
                        catch (NullPointerException e) {
                            log.debug("TrackSegement at connection C doesn't contain a layout block");
                        }
                    } else if (this.getLayoutBlockC() != this.getLayoutBlockD()) {
                        try {
                            boundaryBetween[2] = this.getLayoutBlockC().getDisplayName() + " - " + this.getLayoutBlockD().getDisplayName();
                        }
                        catch (NullPointerException e) {
                            log.debug("TrackSegement at connection A doesn't contain a layout block");
                        }
                    }
                }
                if (this.connectD instanceof TrackSegment) {
                    dLBlock = ((TrackSegment)this.connectD).getLayoutBlock();
                    if (dLBlock != this.getLayoutBlock() && dLBlock != this.getLayoutBlockB() && dLBlock != this.getLayoutBlockC() && dLBlock != this.getLayoutBlockD()) {
                        try {
                            boundaryBetween[3] = dLBlock.getDisplayName() + " - " + this.getLayoutBlockD().getDisplayName();
                        }
                        catch (NullPointerException e) {
                            log.debug("TrackSegement at connection C doesn't contain a layout block");
                        }
                    } else if (this.getLayoutBlockC() != this.getLayoutBlockD()) {
                        try {
                            boundaryBetween[3] = this.getLayoutBlockD().getDisplayName() + " - " + this.getLayoutBlockC().getDisplayName();
                        }
                        catch (NullPointerException e) {
                            log.debug("TrackSegement at connection A doesn't contain a layout block");
                        }
                    }
                }
            }
        }
        return boundaryBetween;
    }

    @Nonnull
    public ArrayList<LayoutBlock> getProtectedBlocks(NamedBean bean) {
        ArrayList<LayoutBlock> ret = new ArrayList<LayoutBlock>(2);
        if (this.getLayoutBlock() == null) {
            return ret;
        }
        if (this.isTurnoutTypeXover()) {
            if (!(this.getTurnoutType() != TurnoutType.DOUBLE_XOVER && this.getTurnoutType() != TurnoutType.RH_XOVER || this.getSignalAMast() != bean && this.getSignalCMast() != bean && this.getSensorA() != bean && this.getSensorC() != bean)) {
                if (this.getSignalAMast() == bean || this.getSensorA() == bean) {
                    if (this.connectA != null) {
                        if (((TrackSegment)this.connectA).getLayoutBlock() == this.getLayoutBlock()) {
                            if (this.getLayoutBlockB() != null && this.getLayoutBlock() != this.getLayoutBlockB() && this.getLayoutBlockC() != null && this.getLayoutBlock() != this.getLayoutBlockC()) {
                                ret.add(this.getLayoutBlockB());
                                ret.add(this.getLayoutBlockC());
                            }
                        } else {
                            ret.add(this.getLayoutBlock());
                        }
                    }
                } else if (this.connectC != null && this.getLayoutBlockC() != null) {
                    if (((TrackSegment)this.connectC).getLayoutBlock() == this.getLayoutBlockC()) {
                        if (this.getLayoutBlockC() != this.getLayoutBlock() && this.getLayoutBlockD() != null && this.getLayoutBlockC() != this.getLayoutBlockD()) {
                            ret.add(this.getLayoutBlock());
                            ret.add(this.getLayoutBlockD());
                        }
                    } else {
                        ret.add(this.getLayoutBlockC());
                    }
                }
            }
            if (!(this.getTurnoutType() != TurnoutType.DOUBLE_XOVER && this.getTurnoutType() != TurnoutType.LH_XOVER || this.getSignalBMast() != bean && this.getSignalDMast() != bean && this.getSensorB() != bean && this.getSensorD() != bean)) {
                if (this.getSignalBMast() == bean || this.getSensorB() == bean) {
                    if (this.connectB != null && this.getLayoutBlockB() != null) {
                        if (((TrackSegment)this.connectB).getLayoutBlock() == this.getLayoutBlockB()) {
                            if (this.getLayoutBlock() != this.getLayoutBlockB() && this.getLayoutBlockD() != null && this.getLayoutBlockB() != this.getLayoutBlockD()) {
                                ret.add(this.getLayoutBlock());
                                ret.add(this.getLayoutBlockD());
                            }
                        } else {
                            ret.add(this.getLayoutBlockB());
                        }
                    }
                } else if (this.connectD != null && this.getLayoutBlockD() != null) {
                    if (((TrackSegment)this.connectD).getLayoutBlock() == this.getLayoutBlockD()) {
                        if (this.getLayoutBlockB() != null && this.getLayoutBlockB() != this.getLayoutBlockD() && this.getLayoutBlockC() != null && this.getLayoutBlockC() != this.getLayoutBlockD()) {
                            ret.add(this.getLayoutBlockB());
                            ret.add(this.getLayoutBlockC());
                        }
                    } else {
                        ret.add(this.getLayoutBlockD());
                    }
                }
            }
            if (this.getTurnoutType() == TurnoutType.RH_XOVER && (this.getSignalBMast() == bean || this.getSignalDMast() == bean || this.getSensorB() == bean || this.getSensorD() == bean)) {
                if (this.getSignalBMast() == bean || this.getSensorB() == bean) {
                    if (this.connectB != null && ((TrackSegment)this.connectB).getLayoutBlock() == this.getLayoutBlockB()) {
                        if (this.getLayoutBlockB() != this.getLayoutBlock()) {
                            ret.add(this.getLayoutBlock());
                        }
                    } else {
                        ret.add(this.getLayoutBlockB());
                    }
                } else if (this.connectD != null && ((TrackSegment)this.connectD).getLayoutBlock() == this.getLayoutBlockD()) {
                    if (this.getLayoutBlockC() != this.getLayoutBlockD()) {
                        ret.add(this.getLayoutBlockC());
                    }
                } else {
                    ret.add(this.getLayoutBlockD());
                }
            }
            if (this.getTurnoutType() == TurnoutType.LH_XOVER && (this.getSensorA() == bean || this.getSensorC() == bean || this.getSignalAMast() == bean || this.getSignalCMast() == bean)) {
                if (this.getSignalAMast() == bean || this.getSensorA() == bean) {
                    if (this.connectA != null && ((TrackSegment)this.connectA).getLayoutBlock() == this.getLayoutBlock()) {
                        if (this.getLayoutBlockB() != this.getLayoutBlock()) {
                            ret.add(this.getLayoutBlockB());
                        }
                    } else {
                        ret.add(this.getLayoutBlock());
                    }
                } else if (this.connectC != null && ((TrackSegment)this.connectC).getLayoutBlock() == this.getLayoutBlockC()) {
                    if (this.getLayoutBlockC() != this.getLayoutBlockD()) {
                        ret.add(this.getLayoutBlockD());
                    }
                } else {
                    ret.add(this.getLayoutBlockC());
                }
            }
        } else if (this.connectA != null) {
            if (this.getSignalAMast() == bean || this.getSensorA() == bean) {
                if (((TrackSegment)this.connectA).getLayoutBlock() == this.getLayoutBlock()) {
                    if (this.connectB != null && this.connectC != null && ((TrackSegment)this.connectB).getLayoutBlock() != this.getLayoutBlock() && ((TrackSegment)this.connectC).getLayoutBlock() != this.getLayoutBlock()) {
                        ret.add(((TrackSegment)this.connectB).getLayoutBlock());
                        ret.add(((TrackSegment)this.connectC).getLayoutBlock());
                    }
                } else {
                    ret.add(this.getLayoutBlock());
                }
            } else if (this.getSignalBMast() == bean || this.getSensorB() == bean) {
                if (this.connectB != null && ((TrackSegment)this.connectB).getLayoutBlock() == this.getLayoutBlock()) {
                    if (((TrackSegment)this.connectA).getLayoutBlock() != this.getLayoutBlock()) {
                        ret.add(((TrackSegment)this.connectA).getLayoutBlock());
                    }
                } else {
                    ret.add(this.getLayoutBlock());
                }
            } else if (this.getSignalCMast() == bean || this.getSensorC() == bean) {
                if (this.connectC != null && ((TrackSegment)this.connectC).getLayoutBlock() == this.getLayoutBlock()) {
                    if (((TrackSegment)this.connectA).getLayoutBlock() != this.getLayoutBlock()) {
                        ret.add(((TrackSegment)this.connectA).getLayoutBlock());
                    }
                } else {
                    ret.add(this.getLayoutBlock());
                }
            }
        }
        return ret;
    }

    protected void removeSML(@CheckForNull SignalMast signalMast) {
        if (signalMast == null) {
            return;
        }
        if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() && InstanceManager.getDefault(SignalMastLogicManager.class).isSignalMastUsed(signalMast)) {
            SignallingGuiTools.removeSignalMastLogic(null, signalMast);
        }
    }

    public void remove() {
        this.deactivateTurnout();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    protected int getConnectivityStateForLayoutBlocks(LayoutBlock currLayoutBlock, LayoutBlock prevLayoutBlock, LayoutBlock nextLayoutBlock, boolean suppress) {
        int result = 1;
        LayoutBlock layoutBlockA = ((TrackSegment)this.getConnectA()).getLayoutBlock();
        LayoutBlock layoutBlockB = ((TrackSegment)this.getConnectB()).getLayoutBlock();
        LayoutBlock layoutBlockC = ((TrackSegment)this.getConnectC()).getLayoutBlock();
        TurnoutType tTyp = this.getTurnoutType();
        switch (tTyp) {
            case RH_TURNOUT: 
            case LH_TURNOUT: 
            case WYE_TURNOUT: {
                if (layoutBlockA == currLayoutBlock) {
                    if (layoutBlockC == nextLayoutBlock || layoutBlockC == prevLayoutBlock) {
                        result = 4;
                        break;
                    }
                    if (layoutBlockB == nextLayoutBlock || layoutBlockB == prevLayoutBlock) {
                        result = 2;
                        break;
                    }
                    if (layoutBlockB == currLayoutBlock) {
                        result = 2;
                        break;
                    }
                    if (layoutBlockC == currLayoutBlock) {
                        result = 4;
                        break;
                    }
                    if (!suppress) {
                        log.error("{}.getConnectivityStateForLayoutBlocks(...); Cannot determine turnout setting for {}", (Object)this.getName(), (Object)this.getTurnoutName());
                    }
                    result = 2;
                    break;
                }
                if (layoutBlockB == currLayoutBlock) {
                    result = 2;
                    break;
                }
                if (layoutBlockC == currLayoutBlock) {
                    result = 4;
                    break;
                }
                if (!suppress) {
                    log.debug("lb {} nlb {} connect B {} connect C {}", new Object[]{currLayoutBlock, nextLayoutBlock, layoutBlockB, layoutBlockC});
                    log.error("{}.getConnectivityStateForLayoutBlocks(...); Cannot determine turnout setting for {}", (Object)this.getName(), (Object)this.getTurnoutName());
                }
                result = 2;
                break;
            }
            case RH_XOVER: 
            case LH_XOVER: 
            case DOUBLE_XOVER: {
                if (this.getLayoutBlock() == currLayoutBlock) {
                    if (tTyp != TurnoutType.LH_XOVER && (this.getLayoutBlockC() == nextLayoutBlock || this.getLayoutBlockC() == prevLayoutBlock)) {
                        result = 4;
                        break;
                    }
                    if (this.getLayoutBlockB() == nextLayoutBlock || this.getLayoutBlockB() == prevLayoutBlock) {
                        result = 2;
                        break;
                    }
                    if (this.getLayoutBlockB() == currLayoutBlock) {
                        result = 2;
                        break;
                    }
                    if (tTyp != TurnoutType.LH_XOVER && this.getLayoutBlockC() == currLayoutBlock) {
                        result = 4;
                        break;
                    }
                    if (!suppress) {
                        log.error("{}.getConnectivityStateForLayoutBlocks(...); Cannot determine turnout setting for {}", (Object)this.getName(), (Object)this.getTurnoutName());
                    }
                    result = 2;
                    break;
                }
                if (this.getLayoutBlockB() == currLayoutBlock) {
                    if (this.getLayoutBlock() == nextLayoutBlock || this.getLayoutBlock() == prevLayoutBlock) {
                        result = 2;
                        break;
                    }
                    if (tTyp != TurnoutType.RH_XOVER && (this.getLayoutBlockD() == nextLayoutBlock || this.getLayoutBlockD() == prevLayoutBlock || this.getLayoutBlockD() == currLayoutBlock)) {
                        result = 4;
                        break;
                    }
                    if (!suppress) {
                        log.error("{}.getConnectivityStateForLayoutBlocks(...); Cannot determine turnout setting for {}", (Object)this.getName(), (Object)this.getTurnoutName());
                    }
                    result = 2;
                    break;
                }
                if (this.getLayoutBlockC() == currLayoutBlock) {
                    if (tTyp != TurnoutType.LH_XOVER && (this.getLayoutBlock() == nextLayoutBlock || this.getLayoutBlock() == prevLayoutBlock)) {
                        result = 4;
                        break;
                    }
                    if (this.getLayoutBlockD() == nextLayoutBlock || this.getLayoutBlockD() == prevLayoutBlock || this.getLayoutBlockD() == currLayoutBlock) {
                        result = 2;
                        break;
                    }
                    if (tTyp != TurnoutType.LH_XOVER && this.getLayoutBlockD() == currLayoutBlock) {
                        result = 4;
                        break;
                    }
                    if (!suppress) {
                        log.error("{}.getConnectivityStateForLayoutBlocks(...); Cannot determine turnout setting for {}", (Object)this.getName(), (Object)this.getTurnoutName());
                    }
                    result = 2;
                    break;
                }
                if (this.getLayoutBlockD() != currLayoutBlock) break;
                if (this.getLayoutBlockC() == nextLayoutBlock || this.getLayoutBlockC() == prevLayoutBlock) {
                    result = 2;
                    break;
                }
                if (tTyp != TurnoutType.RH_XOVER && (this.getLayoutBlockB() == nextLayoutBlock || this.getLayoutBlockB() == prevLayoutBlock)) {
                    result = 4;
                    break;
                }
                if (!suppress) {
                    log.error("{}.getConnectivityStateForLayoutBlocks(...); Cannot determine turnout setting for {}", (Object)this.getName(), (Object)this.getTurnoutName());
                }
                result = 2;
                break;
            }
            default: {
                log.warn("{}.getConnectivityStateForLayoutBlocks(...) unknown getTurnoutType: {}", (Object)this.getName(), (Object)tTyp);
            }
        }
        return result;
    }

    @Override
    public void reCheckBlockBoundary() {
        TrackSegment trkD;
        TrackSegment trkC;
        TrackSegment trkB;
        TrackSegment trkA;
        if (this.connectA == null && this.connectB == null && this.connectC == null) {
            if (this.isTurnoutTypeTurnout()) {
                if (this.signalAMastNamed != null) {
                    this.removeSML(this.getSignalAMast());
                }
                if (this.signalBMastNamed != null) {
                    this.removeSML(this.getSignalBMast());
                }
                if (this.signalCMastNamed != null) {
                    this.removeSML(this.getSignalCMast());
                }
                this.signalAMastNamed = null;
                this.signalBMastNamed = null;
                this.signalCMastNamed = null;
                this.sensorANamed = null;
                this.sensorBNamed = null;
                this.sensorCNamed = null;
                return;
            }
            if (this.isTurnoutTypeXover() && this.connectD == null) {
                if (this.signalAMastNamed != null) {
                    this.removeSML(this.getSignalAMast());
                }
                if (this.signalBMastNamed != null) {
                    this.removeSML(this.getSignalBMast());
                }
                if (this.signalCMastNamed != null) {
                    this.removeSML(this.getSignalCMast());
                }
                if (this.signalDMastNamed != null) {
                    this.removeSML(this.getSignalDMast());
                }
                this.signalAMastNamed = null;
                this.signalBMastNamed = null;
                this.signalCMastNamed = null;
                this.signalDMastNamed = null;
                this.sensorANamed = null;
                this.sensorBNamed = null;
                this.sensorCNamed = null;
                this.sensorDNamed = null;
                return;
            }
        }
        if (this.connectA == null || this.connectB == null || this.connectC == null) {
            return;
        }
        if (this.connectD == null && this.isTurnoutTypeXover()) {
            return;
        }
        if (this.connectA instanceof TrackSegment && (trkA = (TrackSegment)this.connectA).getLayoutBlock() == this.getLayoutBlock()) {
            if (this.signalAMastNamed != null) {
                this.removeSML(this.getSignalAMast());
            }
            this.signalAMastNamed = null;
            this.sensorANamed = null;
        }
        if (this.connectB instanceof TrackSegment && ((trkB = (TrackSegment)this.connectB).getLayoutBlock() == this.getLayoutBlock() || trkB.getLayoutBlock() == this.getLayoutBlockB())) {
            if (this.signalBMastNamed != null) {
                this.removeSML(this.getSignalBMast());
            }
            this.signalBMastNamed = null;
            this.sensorBNamed = null;
        }
        if (this.connectC instanceof TrackSegment && ((trkC = (TrackSegment)this.connectC).getLayoutBlock() == this.getLayoutBlock() || trkC.getLayoutBlock() == this.getLayoutBlockB() || trkC.getLayoutBlock() == this.getLayoutBlockC())) {
            if (this.signalCMastNamed != null) {
                this.removeSML(this.getSignalCMast());
            }
            this.signalCMastNamed = null;
            this.sensorCNamed = null;
        }
        if (this.connectD != null && this.connectD instanceof TrackSegment && this.isTurnoutTypeXover() && ((trkD = (TrackSegment)this.connectD).getLayoutBlock() == this.getLayoutBlock() || trkD.getLayoutBlock() == this.getLayoutBlockB() || trkD.getLayoutBlock() == this.getLayoutBlockC() || trkD.getLayoutBlock() == this.getLayoutBlockD())) {
            if (this.signalDMastNamed != null) {
                this.removeSML(this.getSignalDMast());
            }
            this.signalDMastNamed = null;
            this.sensorDNamed = null;
        }
    }

    @Override
    @Nonnull
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        ArrayList<LayoutConnectivity> results = new ArrayList<LayoutConnectivity>();
        log.trace("Start in layoutTurnout.getLayoutConnectivity for {}", (Object)this.getName());
        LayoutConnectivity lc = null;
        LayoutBlock lbA = this.getLayoutBlock();
        LayoutBlock lbB = this.getLayoutBlockB();
        LayoutBlock lbC = this.getLayoutBlockC();
        LayoutBlock lbD = this.getLayoutBlockD();
        log.trace("    type: {}", (Object)this.type);
        log.trace("     lbA: {}", (Object)lbA);
        log.trace("     lbB: {}", (Object)lbB);
        log.trace("     lbC: {}", (Object)lbC);
        log.trace("     lbD: {}", (Object)lbD);
        if (this.hasEnteringDoubleTrack() && lbA != null && (lbA != lbB || lbA != lbC || lbA != lbD)) {
            if (lbA != lbB) {
                log.debug("Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbA, lbB, this});
                lc = new LayoutConnectivity(lbA, lbB);
                lc.setXoverBoundary(this, 1);
                lc.setDirection(this.models.computeDirectionAB(this));
                log.trace("getLayoutConnectivity lbA != lbB");
                log.trace("   Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbA, lbB, this});
                results.add(lc);
            }
            if (this.getTurnoutType() != TurnoutType.LH_XOVER && lbA != lbC) {
                log.debug("Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbA, lbC, this});
                lc = new LayoutConnectivity(lbA, lbC);
                lc.setXoverBoundary(this, 3);
                lc.setDirection(this.models.computeDirectionAC(this));
                log.trace("getLayoutConnectivity lbA != lbC");
                log.trace("   Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbA, lbC, this});
                results.add(lc);
            }
            if (lbC != lbD) {
                log.debug("Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbC, lbD, this});
                lc = new LayoutConnectivity(lbC, lbD);
                lc.setXoverBoundary(this, 2);
                lc.setDirection(this.models.computeDirectionCD(this));
                log.trace("getLayoutConnectivity lbC != lbD");
                log.trace("   Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbC, lbD, this});
                results.add(lc);
            }
            if (this.getTurnoutType() != TurnoutType.RH_XOVER && lbB != lbD) {
                log.debug("Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbB, lbD, this});
                lc = new LayoutConnectivity(lbB, lbD);
                lc.setXoverBoundary(this, 4);
                lc.setDirection(this.models.computeDirectionBD(this));
                log.trace("getLayoutConnectivity lbB != lbD");
                log.trace("   Block boundary  ('{}'<->'{}') found at {}", new Object[]{lbB, lbD, this});
                results.add(lc);
            }
        }
        return results;
    }

    @Override
    @Nonnull
    public List<HitPointType> checkForFreeConnections() {
        ArrayList<HitPointType> result = new ArrayList<HitPointType>();
        if (this.getConnectA() == null) {
            result.add(HitPointType.TURNOUT_A);
        }
        if (this.getConnectB() == null) {
            result.add(HitPointType.TURNOUT_B);
        }
        if (this.getConnectC() == null) {
            result.add(HitPointType.TURNOUT_C);
        }
        if (this.isTurnoutTypeXover() && this.getConnectD() == null) {
            result.add(HitPointType.TURNOUT_D);
        }
        return result;
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        return this.getLayoutBlock() != null;
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        HashMap<LayoutTrack, String> blocksAndTracksMap = new HashMap<LayoutTrack, String>();
        if (this.connectA != null) {
            blocksAndTracksMap.put(this.connectA, this.getBlockName());
        }
        if (this.connectB != null) {
            blocksAndTracksMap.put(this.connectB, this.getBlockBName());
        }
        if (this.connectC != null) {
            blocksAndTracksMap.put(this.connectC, this.getBlockCName());
        }
        if ((this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) && this.connectD != null) {
            blocksAndTracksMap.put(this.connectD, this.getBlockDName());
        }
        List<Set<String>> TrackNameSets = null;
        LinkedHashSet<String> TrackNameSet = null;
        for (Map.Entry entry : blocksAndTracksMap.entrySet()) {
            LayoutTrack theConnect = (LayoutTrack)entry.getKey();
            String theBlockName = (String)entry.getValue();
            TrackNameSet = null;
            TrackNameSets = blockNamesToTrackNameSetsMap.get(theBlockName);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block ('{}') trackNameSets", (Object)theBlockName);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(theBlockName, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet<String>();
                TrackNameSets.add(TrackNameSet);
            }
            if (TrackNameSet.add(this.getName())) {
                log.debug("*    Add track '{}' to trackNameSet for block '{}'", (Object)this.getName(), (Object)theBlockName);
            }
            theConnect.collectContiguousTracksNamesInBlockNamed(theBlockName, TrackNameSet);
        }
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        if (!TrackNameSet.contains(this.getName())) {
            ArrayList<LayoutTrack> connects = new ArrayList<LayoutTrack>();
            if (this.getBlockName().equals(blockName) && this.connectA != null) {
                connects.add(this.connectA);
            }
            if (this.getBlockBName().equals(blockName) && this.connectB != null) {
                connects.add(this.connectB);
            }
            if (this.getBlockCName().equals(blockName) && this.connectC != null) {
                connects.add(this.connectC);
            }
            if ((this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) && this.getBlockDName().equals(blockName) && this.connectD != null) {
                connects.add(this.connectD);
            }
            for (LayoutTrack connect : connects) {
                if (TrackNameSet.add(this.getName())) {
                    log.debug("*    Add track '{}' for block '{}'", (Object)this.getName(), (Object)blockName);
                }
                connect.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
        }
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
        this.setLayoutBlock(layoutBlock);
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            this.setLayoutBlockB(layoutBlock);
            this.setLayoutBlockC(layoutBlock);
            this.setLayoutBlockD(layoutBlock);
        }
    }

    @Override
    public String getTypeName() {
        return Bundle.getMessage("TypeName_Turnout");
    }

    public void setShowToolTip(boolean set) {
        this._showTooltip = set;
    }

    public boolean showToolTip() {
        return this._showTooltip;
    }

    public void setToolTip(ToolTip tip) {
        this._tooltip = tip;
    }

    public ToolTip getToolTip() {
        return this._tooltip;
    }

    @Nonnull
    public String getNameString() {
        Turnout turnout = this.getTurnout();
        if (turnout != null) {
            return turnout.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        }
        return this.getId();
    }

    public static enum Geometry {
        NONE,
        POINTA1,
        POINTA2,
        POINTA3,
        POINTB1,
        POINTB2,
        POINTC1,
        POINTC2,
        POINTD1,
        POINTD2;

    }

    public static enum LinkType {
        NO_LINK,
        FIRST_3_WAY,
        SECOND_3_WAY,
        THROAT_TO_THROAT;

    }

    public static enum TurnoutType {
        NONE,
        RH_TURNOUT,
        LH_TURNOUT,
        WYE_TURNOUT,
        DOUBLE_XOVER,
        RH_XOVER,
        LH_XOVER,
        SINGLE_SLIP,
        DOUBLE_SLIP;

    }
}

