/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Turnout;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTurntable
extends LayoutTrack {
    private NamedBeanHandle<LayoutBlock> namedLayoutBlock = null;
    private boolean turnoutControlled = false;
    private double radius = 25.0;
    private int lastKnownIndex = -1;
    public final List<RayTrack> rayTrackList = new ArrayList<RayTrack>();
    public String tLayoutBlockName = "";
    private boolean active = true;
    private static final Logger log = LoggerFactory.getLogger(LayoutTurntable.class);

    public LayoutTurntable(@Nonnull String id, @Nonnull LayoutEditor models) {
        super(id, models);
    }

    @Nonnull
    public String toString() {
        return "LayoutTurntable " + this.getName();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    @Nonnull
    public String getBlockName() {
        String result = null;
        if (this.namedLayoutBlock != null) {
            result = this.namedLayoutBlock.getName();
        }
        return result == null ? "" : result;
    }

    @CheckForNull
    public LayoutBlock getLayoutBlock() {
        return this.namedLayoutBlock != null ? this.namedLayoutBlock.getBean() : null;
    }

    public void setLayoutBlock(@CheckForNull LayoutBlock newLayoutBlock) {
        LayoutBlock layoutBlock = this.getLayoutBlock();
        if (layoutBlock != newLayoutBlock) {
            String newName;
            if (layoutBlock != null) {
                layoutBlock.decrementUse();
            }
            this.namedLayoutBlock = newLayoutBlock != null ? ((newName = newLayoutBlock.getUserName()) != null && !newName.isEmpty() ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(newName, newLayoutBlock) : null) : null;
        }
    }

    public void setLayoutBlockByName(@CheckForNull String name) {
        if (name != null && !name.isEmpty()) {
            this.setLayoutBlock(this.models.provideLayoutBlock(name));
        }
    }

    public RayTrack addRay(double angle) {
        RayTrack rt = new RayTrack(angle, this.getNewIndex());
        this.rayTrackList.add(rt);
        return rt;
    }

    private int getNewIndex() {
        int index = -1;
        if (this.rayTrackList.isEmpty()) {
            return 0;
        }
        boolean found = true;
        while (found) {
            ++index;
            found = false;
            for (RayTrack rt : this.rayTrackList) {
                if (index != rt.getConnectionIndex()) continue;
                found = true;
            }
        }
        return index;
    }

    public void addRayTrack(double angle, int index, String name) {
        RayTrack rt = new RayTrack(angle, index);
        this.rayTrackList.add(rt);
        rt.connectName = name;
    }

    @CheckForNull
    public TrackSegment getRayConnectIndexed(int index) {
        TrackSegment result = null;
        for (RayTrack rt : this.rayTrackList) {
            if (rt.getConnectionIndex() != index) continue;
            result = rt.getConnect();
            break;
        }
        return result;
    }

    @CheckForNull
    public TrackSegment getRayConnectOrdered(int i) {
        RayTrack rt;
        TrackSegment result = null;
        if (i < this.rayTrackList.size() && (rt = this.rayTrackList.get(i)) != null) {
            result = rt.getConnect();
        }
        return result;
    }

    public void setRayConnect(@CheckForNull TrackSegment ts, int index) {
        for (RayTrack rt : this.rayTrackList) {
            if (rt.getConnectionIndex() != index) continue;
            rt.setConnect(ts);
            break;
        }
    }

    @Nonnull
    public List<RayTrack> getRayTrackList() {
        return this.rayTrackList;
    }

    public int getNumberRays() {
        return this.rayTrackList.size();
    }

    public int getRayIndex(int i) {
        int result = 0;
        if (i < this.rayTrackList.size()) {
            RayTrack rt = this.rayTrackList.get(i);
            result = rt.getConnectionIndex();
        }
        return result;
    }

    public double getRayAngle(int i) {
        double result = 0.0;
        if (i < this.rayTrackList.size()) {
            RayTrack rt = this.rayTrackList.get(i);
            result = rt.getAngle();
        }
        return result;
    }

    public void setRayTurnout(int index, @CheckForNull String turnoutName, int state) {
        boolean found = false;
        for (RayTrack rt : this.rayTrackList) {
            if (rt.getConnectionIndex() != index) continue;
            rt.setTurnout(turnoutName, state);
            found = true;
            break;
        }
        if (!found) {
            log.error("{}.setRayTurnout({}, {}, {}); Attempt to add Turnout control to a non-existant ray track", new Object[]{this.getName(), index, turnoutName, state});
        }
    }

    @CheckForNull
    public String getRayTurnoutName(int i) {
        String result = null;
        if (i < this.rayTrackList.size()) {
            RayTrack rt = this.rayTrackList.get(i);
            result = rt.getTurnoutName();
        }
        return result;
    }

    @CheckForNull
    public Turnout getRayTurnout(int i) {
        Turnout result = null;
        if (i < this.rayTrackList.size()) {
            RayTrack rt = this.rayTrackList.get(i);
            result = rt.getTurnout();
        }
        return result;
    }

    public int getRayTurnoutState(int i) {
        int result = 0;
        if (i < this.rayTrackList.size()) {
            RayTrack rt = this.rayTrackList.get(i);
            result = rt.getTurnoutState();
        }
        return result;
    }

    public boolean isRayDisabled(int i) {
        boolean result = false;
        if (i < this.rayTrackList.size()) {
            RayTrack rt = this.rayTrackList.get(i);
            result = rt.isDisabled();
        }
        return result;
    }

    public void setRayDisabled(int i, boolean boo) {
        if (i < this.rayTrackList.size()) {
            RayTrack rt = this.rayTrackList.get(i);
            rt.setDisabled(boo);
        }
    }

    public boolean isRayDisabledWhenOccupied(int i) {
        boolean result = false;
        if (i < this.rayTrackList.size()) {
            RayTrack rt = this.rayTrackList.get(i);
            result = rt.isDisabledWhenOccupied();
        }
        return result;
    }

    public void setRayDisabledWhenOccupied(int i, boolean boo) {
        if (i < this.rayTrackList.size()) {
            RayTrack rt = this.rayTrackList.get(i);
            rt.setDisabledWhenOccupied(boo);
        }
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        TrackSegment result = null;
        if (!HitPointType.isTurntableRayHitType(connectionType)) {
            String errString = MessageFormat.format("{0}.getCoordsForConnectionType({1}); Invalid connection type", new Object[]{this.getName(), connectionType});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        result = this.getRayConnectIndexed(connectionType.turntableTrackIndex());
        return result;
    }

    @Override
    public void setConnection(HitPointType connectionType, @CheckForNull LayoutTrack o, HitPointType type) throws JmriException {
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        if (HitPointType.isTurntableRayHitType(connectionType)) {
            if (o != null && !(o instanceof TrackSegment)) {
                String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid object: {4}", new Object[]{this.getName(), connectionType, o.getName(), type, o.getClass().getName()});
                log.error("will throw {}", (Object)errString);
                throw new JmriException(errString);
            }
        } else {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid connection type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        this.setRayConnect((TrackSegment)o, connectionType.turntableTrackIndex());
    }

    public boolean isMainlineIndexed(int index) {
        boolean result = false;
        for (RayTrack rt : this.rayTrackList) {
            TrackSegment ts;
            if (rt.getConnectionIndex() != index || (ts = rt.getConnect()) == null) continue;
            result = ts.isMainline();
            break;
        }
        return result;
    }

    public boolean isMainlineOrdered(int i) {
        TrackSegment ts;
        RayTrack rt;
        boolean result = false;
        if (i < this.rayTrackList.size() && (rt = this.rayTrackList.get(i)) != null && (ts = rt.getConnect()) != null) {
            result = ts.isMainline();
        }
        return result;
    }

    @Override
    public boolean isMainline() {
        return false;
    }

    @Override
    public void setObjects(@Nonnull LayoutEditor p) {
        if (this.tLayoutBlockName != null && !this.tLayoutBlockName.isEmpty()) {
            this.setLayoutBlockByName(this.tLayoutBlockName);
        }
        this.tLayoutBlockName = null;
        this.rayTrackList.forEach(rt -> rt.setConnect(p.getFinder().findTrackSegmentByName(rt.connectName)));
    }

    public boolean isTurnoutControlled() {
        return this.turnoutControlled;
    }

    public void setTurnoutControlled(boolean boo) {
        this.turnoutControlled = boo;
    }

    public void setPosition(int index) {
        if (this.isTurnoutControlled()) {
            boolean found = false;
            for (RayTrack rt : this.rayTrackList) {
                if (rt.getConnectionIndex() != index) continue;
                this.lastKnownIndex = index;
                rt.setPosition();
                this.models.redrawPanel();
                this.models.setDirty();
                found = true;
                break;
            }
            if (!found) {
                log.error("{}.setPosition({}); Attempt to set the position on a non-existant ray track", (Object)this.getName(), (Object)index);
            }
        }
    }

    public int getPosition() {
        return this.lastKnownIndex;
    }

    public void deleteRay(@Nonnull RayTrack rayTrack) {
        TrackSegment t = null;
        if (this.rayTrackList == null) {
            log.error("{}.deleteRay(null); rayTrack is null", (Object)this.getName());
        } else {
            t = rayTrack.getConnect();
            this.getRayTrackList().remove(rayTrack.getConnectionIndex());
            rayTrack.dispose();
        }
        if (t != null) {
            this.models.removeTrackSegment(t);
        }
        this.models.redrawPanel();
        this.models.setDirty();
    }

    public void remove() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    protected void reCheckBlockBoundary() {
    }

    @Override
    @CheckForNull
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        return null;
    }

    @Override
    @Nonnull
    public List<HitPointType> checkForFreeConnections() {
        ArrayList<HitPointType> result = new ArrayList<HitPointType>();
        for (int k = 0; k < this.getNumberRays(); ++k) {
            if (this.getRayConnectOrdered(k) != null) continue;
            result.add(HitPointType.turntableTrackIndexedValue(k));
        }
        return result;
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        return true;
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        HashMap<TrackSegment, String> blocksAndTracksMap = new HashMap<TrackSegment, String>();
        for (int k = 0; k < this.getNumberRays(); ++k) {
            TrackSegment ts = this.getRayConnectOrdered(k);
            if (ts == null) continue;
            String blockName = ts.getBlockName();
            blocksAndTracksMap.put(ts, blockName);
        }
        for (Map.Entry entry : blocksAndTracksMap.entrySet()) {
            LayoutTrack theConnect = (LayoutTrack)entry.getKey();
            String theBlockName = (String)entry.getValue();
            LinkedHashSet<String> TrackNameSet = null;
            List<Set<String>> TrackNameSets = blockNamesToTrackNameSetsMap.get(theBlockName);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block (''{}'') trackNameSets", (Object)theBlockName);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(theBlockName, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet<String>();
                TrackNameSets.add(TrackNameSet);
            }
            if (TrackNameSet.add(this.getName())) {
                log.debug("*    Add track ''{}'' to trackNameSet for block ''{}''", (Object)this.getName(), (Object)theBlockName);
            }
            theConnect.collectContiguousTracksNamesInBlockNamed(theBlockName, TrackNameSet);
        }
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        if (!TrackNameSet.contains(this.getName())) {
            for (int k = 0; k < this.getNumberRays(); ++k) {
                String blk;
                TrackSegment ts = this.getRayConnectOrdered(k);
                if (ts == null || (blk = ts.getBlockName()).isEmpty() || !blk.equals(blockName)) continue;
                if (TrackNameSet.add(this.getName())) {
                    log.debug("*    Add track ''{}'' for block ''{}''", (Object)this.getName(), (Object)blockName);
                }
                ts.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
        }
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    @Override
    public String getTypeName() {
        return Bundle.getMessage("TypeName_Turntable");
    }

    public class RayTrack {
        private double rayAngle = 0.0;
        private TrackSegment connect = null;
        private int connectionIndex = -1;
        private boolean disabled = false;
        private boolean disableWhenOccupied = false;
        public String connectName = "";
        private NamedBeanHandle<Turnout> namedTurnout;
        private int turnoutState;
        private PropertyChangeListener mTurnoutListener;

        public RayTrack(double angle, int index) {
            this.rayAngle = MathUtil.wrapPM360(angle);
            this.connect = null;
            this.connectionIndex = index;
            this.disabled = false;
            this.disableWhenOccupied = false;
        }

        public void setDisabled(boolean boo) {
            if (this.disabled != boo) {
                this.disabled = boo;
                if (LayoutTurntable.this.models != null) {
                    LayoutTurntable.this.models.redrawPanel();
                }
            }
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabledWhenOccupied(boolean boo) {
            if (this.disableWhenOccupied != boo) {
                this.disableWhenOccupied = boo;
                if (LayoutTurntable.this.models != null) {
                    LayoutTurntable.this.models.redrawPanel();
                }
            }
        }

        public boolean isDisabledWhenOccupied() {
            return this.disableWhenOccupied;
        }

        public TrackSegment getConnect() {
            return this.connect;
        }

        public void setConnect(TrackSegment ts) {
            this.connect = ts;
        }

        public double getAngle() {
            return this.rayAngle;
        }

        public void setAngle(double an) {
            this.rayAngle = MathUtil.wrapPM360(an);
        }

        public int getConnectionIndex() {
            return this.connectionIndex;
        }

        public boolean isOccupied() {
            LayoutBlock lb;
            boolean result = false;
            if (this.connect != null && (lb = this.connect.getLayoutBlock()) != null) {
                result = lb.getOccupancy() == 2;
            }
            return result;
        }

        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="2nd check of turnoutName is considered redundant by SpotBugs, but required by ecj")
        public void setTurnout(@Nonnull String turnoutName, int state) {
            Turnout turnout = null;
            if (this.mTurnoutListener == null) {
                this.mTurnoutListener = e -> {
                    if (this.getTurnout().getKnownState() == this.turnoutState) {
                        LayoutTurntable.this.lastKnownIndex = this.connectionIndex;
                        LayoutTurntable.this.models.redrawPanel();
                        LayoutTurntable.this.models.setDirty();
                    }
                };
            }
            if (turnoutName != null) {
                turnout = InstanceManager.turnoutManagerInstance().getTurnout(turnoutName);
            }
            if (this.namedTurnout != null && this.namedTurnout.getBean() != turnout) {
                this.namedTurnout.getBean().removePropertyChangeListener(this.mTurnoutListener);
            }
            if (!(turnout == null || this.namedTurnout != null && this.namedTurnout.getBean() == turnout || turnoutName == null || turnoutName.isEmpty())) {
                this.namedTurnout = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(turnoutName, turnout);
                turnout.addPropertyChangeListener(this.mTurnoutListener, turnoutName, "Layout Editor Turntable");
            }
            if (turnout == null) {
                this.namedTurnout = null;
            }
            if (this.turnoutState != state) {
                this.turnoutState = state;
            }
        }

        public void setPosition() {
            if (this.namedTurnout != null) {
                if (this.disableWhenOccupied && this.isOccupied()) {
                    log.debug("Can not setPosition of turntable ray when it is occupied");
                } else {
                    this.getTurnout().setCommandedState(this.turnoutState);
                }
            }
        }

        public Turnout getTurnout() {
            if (this.namedTurnout == null) {
                return null;
            }
            return this.namedTurnout.getBean();
        }

        @CheckForNull
        public String getTurnoutName() {
            if (this.namedTurnout == null) {
                return null;
            }
            return this.namedTurnout.getName();
        }

        public int getTurnoutState() {
            return this.turnoutState;
        }

        void dispose() {
            if (this.getTurnout() != null) {
                this.getTurnout().removePropertyChangeListener(this.mTurnoutListener);
            }
            if (LayoutTurntable.this.lastKnownIndex == this.connectionIndex) {
                LayoutTurntable.this.lastKnownIndex = -1;
            }
        }
    }
}

