/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.SignalMastManager;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.signalling.SignallingGuiTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelXing
extends LayoutTrack {
    private NamedBeanHandle<LayoutBlock> namedLayoutBlockAC = null;
    private NamedBeanHandle<LayoutBlock> namedLayoutBlockBD = null;
    protected NamedBeanHandle<SignalHead> signalAHeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalBHeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalCHeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalDHeadNamed = null;
    protected NamedBeanHandle<SignalMast> signalAMastNamed = null;
    protected NamedBeanHandle<SignalMast> signalBMastNamed = null;
    protected NamedBeanHandle<SignalMast> signalCMastNamed = null;
    protected NamedBeanHandle<SignalMast> signalDMastNamed = null;
    private NamedBeanHandle<Sensor> sensorANamed = null;
    private NamedBeanHandle<Sensor> sensorBNamed = null;
    private NamedBeanHandle<Sensor> sensorCNamed = null;
    private NamedBeanHandle<Sensor> sensorDNamed = null;
    private LayoutTrack connectA = null;
    private LayoutTrack connectB = null;
    private LayoutTrack connectC = null;
    private LayoutTrack connectD = null;
    public String connectAName = "";
    public String connectBName = "";
    public String connectCName = "";
    public String connectDName = "";
    public String tLayoutBlockNameAC = "";
    public String tLayoutBlockNameBD = "";
    boolean active = true;
    ArrayList<SignalMast> sml = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(LevelXing.class);

    public LevelXing(String id, LayoutEditor models) {
        super(id, models);
    }

    public String toString() {
        return "LevelXing " + this.getName();
    }

    @Nonnull
    public String getBlockNameAC() {
        String result = null;
        if (this.namedLayoutBlockAC != null) {
            result = this.namedLayoutBlockAC.getName();
        }
        return result == null ? "" : result;
    }

    @Nonnull
    public String getBlockNameBD() {
        String result = this.getBlockNameAC();
        if (this.namedLayoutBlockBD != null) {
            result = this.namedLayoutBlockBD.getName();
        }
        return result;
    }

    public SignalHead getSignalHead(Geometry loc) {
        NamedBeanHandle<SignalHead> namedBean = null;
        switch (loc) {
            case POINTA: {
                namedBean = this.signalAHeadNamed;
                break;
            }
            case POINTB: {
                namedBean = this.signalBHeadNamed;
                break;
            }
            case POINTC: {
                namedBean = this.signalCHeadNamed;
                break;
            }
            case POINTD: {
                namedBean = this.signalDHeadNamed;
                break;
            }
            default: {
                log.warn("{}.getSignalHead({})", (Object)this.getName(), (Object)loc);
            }
        }
        if (namedBean != null) {
            return namedBean.getBean();
        }
        return null;
    }

    public SignalMast getSignalMast(Geometry loc) {
        NamedBeanHandle<SignalMast> namedBean = null;
        switch (loc) {
            case POINTA: {
                namedBean = this.signalAMastNamed;
                break;
            }
            case POINTB: {
                namedBean = this.signalBMastNamed;
                break;
            }
            case POINTC: {
                namedBean = this.signalCMastNamed;
                break;
            }
            case POINTD: {
                namedBean = this.signalDMastNamed;
                break;
            }
            default: {
                log.warn("{}.getSignalMast({})", (Object)this.getName(), (Object)loc);
            }
        }
        if (namedBean != null) {
            return namedBean.getBean();
        }
        return null;
    }

    public Sensor getSensor(Geometry loc) {
        NamedBeanHandle<Sensor> namedBean = null;
        switch (loc) {
            case POINTA: {
                namedBean = this.sensorANamed;
                break;
            }
            case POINTB: {
                namedBean = this.sensorBNamed;
                break;
            }
            case POINTC: {
                namedBean = this.sensorCNamed;
                break;
            }
            case POINTD: {
                namedBean = this.sensorDNamed;
                break;
            }
            default: {
                log.warn("{}.getSensor({})", (Object)this.getName(), (Object)loc);
            }
        }
        if (namedBean != null) {
            return namedBean.getBean();
        }
        return null;
    }

    @Nonnull
    public String getSignalAName() {
        if (this.signalAHeadNamed != null) {
            return this.signalAHeadNamed.getName();
        }
        return "";
    }

    public void setSignalAName(String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalAHeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        this.signalAHeadNamed = head != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head) : null;
    }

    @Nonnull
    public String getSignalBName() {
        if (this.signalBHeadNamed != null) {
            return this.signalBHeadNamed.getName();
        }
        return "";
    }

    public void setSignalBName(String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalBHeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        this.signalBHeadNamed = head != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head) : null;
    }

    @Nonnull
    public String getSignalCName() {
        if (this.signalCHeadNamed != null) {
            return this.signalCHeadNamed.getName();
        }
        return "";
    }

    public void setSignalCName(String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalCHeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        this.signalCHeadNamed = head != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head) : null;
    }

    @Nonnull
    public String getSignalDName() {
        if (this.signalDHeadNamed != null) {
            return this.signalDHeadNamed.getName();
        }
        return "";
    }

    public void setSignalDName(String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalDHeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        this.signalDHeadNamed = head != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head) : null;
    }

    public void removeBeanReference(NamedBean nb) {
        if (nb == null) {
            return;
        }
        if (nb instanceof SignalMast) {
            if (nb.equals(this.getSignalAMast())) {
                this.setSignalAMast(null);
                return;
            }
            if (nb.equals(this.getSignalBMast())) {
                this.setSignalBMast(null);
                return;
            }
            if (nb.equals(this.getSignalCMast())) {
                this.setSignalCMast(null);
                return;
            }
            if (nb.equals(this.getSignalDMast())) {
                this.setSignalDMast(null);
                return;
            }
        }
        if (nb instanceof Sensor) {
            if (nb.equals(this.getSensorA())) {
                this.setSensorAName(null);
                return;
            }
            if (nb.equals(this.getSensorB())) {
                this.setSensorBName(null);
                return;
            }
            if (nb.equals(this.getSensorC())) {
                this.setSensorCName(null);
                return;
            }
            if (nb.equals(this.getSensorD())) {
                this.setSensorDName(null);
                return;
            }
        }
        if (nb instanceof SignalHead) {
            if (nb.equals(this.getSignalHead(Geometry.POINTA))) {
                this.setSignalAName(null);
                return;
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTB))) {
                this.setSignalBName(null);
                return;
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTC))) {
                this.setSignalCName(null);
                return;
            }
            if (nb.equals(this.getSignalHead(Geometry.POINTD))) {
                this.setSignalDName(null);
            }
        }
    }

    public String getSignalAMastName() {
        if (this.signalAMastNamed != null) {
            return this.signalAMastNamed.getName();
        }
        return "";
    }

    public SignalMast getSignalAMast() {
        if (this.signalAMastNamed != null) {
            return this.signalAMastNamed.getBean();
        }
        return null;
    }

    public void setSignalAMast(String signalMast) {
        if (signalMast == null || signalMast.isEmpty()) {
            this.signalAMastNamed = null;
            return;
        }
        try {
            SignalMast mast = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(signalMast);
            this.signalAMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        }
        catch (IllegalArgumentException ex) {
            this.signalAMastNamed = null;
        }
    }

    public String getSignalBMastName() {
        if (this.signalBMastNamed != null) {
            return this.signalBMastNamed.getName();
        }
        return "";
    }

    public SignalMast getSignalBMast() {
        if (this.signalBMastNamed != null) {
            return this.signalBMastNamed.getBean();
        }
        return null;
    }

    public void setSignalBMast(String signalMast) {
        if (signalMast == null || signalMast.isEmpty()) {
            this.signalBMastNamed = null;
            return;
        }
        try {
            SignalMast mast = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(signalMast);
            this.signalBMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        }
        catch (IllegalArgumentException ex) {
            this.signalBMastNamed = null;
        }
    }

    public String getSignalCMastName() {
        if (this.signalCMastNamed != null) {
            return this.signalCMastNamed.getName();
        }
        return "";
    }

    public SignalMast getSignalCMast() {
        if (this.signalCMastNamed != null) {
            return this.signalCMastNamed.getBean();
        }
        return null;
    }

    public void setSignalCMast(String signalMast) {
        if (signalMast == null || signalMast.isEmpty()) {
            this.signalCMastNamed = null;
            return;
        }
        try {
            SignalMast mast = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(signalMast);
            this.signalCMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        }
        catch (IllegalArgumentException ex) {
            this.signalCMastNamed = null;
        }
    }

    public String getSignalDMastName() {
        if (this.signalDMastNamed != null) {
            return this.signalDMastNamed.getName();
        }
        return "";
    }

    public SignalMast getSignalDMast() {
        if (this.signalDMastNamed != null) {
            return this.signalDMastNamed.getBean();
        }
        return null;
    }

    public void setSignalDMast(String signalMast) {
        if (signalMast == null || signalMast.isEmpty()) {
            this.signalDMastNamed = null;
            return;
        }
        try {
            SignalMast mast = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(signalMast);
            this.signalDMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        }
        catch (IllegalArgumentException ex) {
            this.signalDMastNamed = null;
        }
    }

    public String getSensorAName() {
        if (this.sensorANamed != null) {
            return this.sensorANamed.getName();
        }
        return "";
    }

    public Sensor getSensorA() {
        if (this.sensorANamed != null) {
            return this.sensorANamed.getBean();
        }
        return null;
    }

    public void setSensorAName(String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.sensorANamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.sensorANamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException ex) {
            this.sensorANamed = null;
        }
    }

    public String getSensorBName() {
        if (this.sensorBNamed != null) {
            return this.sensorBNamed.getName();
        }
        return "";
    }

    public Sensor getSensorB() {
        if (this.sensorBNamed != null) {
            return this.sensorBNamed.getBean();
        }
        return null;
    }

    public void setSensorBName(String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.sensorBNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.sensorBNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException ex) {
            this.sensorBNamed = null;
        }
    }

    public String getSensorCName() {
        if (this.sensorCNamed != null) {
            return this.sensorCNamed.getName();
        }
        return "";
    }

    public Sensor getSensorC() {
        if (this.sensorCNamed != null) {
            return this.sensorCNamed.getBean();
        }
        return null;
    }

    public void setSensorCName(String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.sensorCNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.sensorCNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException ex) {
            this.sensorCNamed = null;
        }
    }

    public String getSensorDName() {
        if (this.sensorDNamed != null) {
            return this.sensorDNamed.getName();
        }
        return "";
    }

    public Sensor getSensorD() {
        if (this.sensorDNamed != null) {
            return this.sensorDNamed.getBean();
        }
        return null;
    }

    public void setSensorDName(String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.sensorDNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.sensorDNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException ex) {
            this.sensorDNamed = null;
        }
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        switch (connectionType) {
            case LEVEL_XING_A: {
                return this.connectA;
            }
            case LEVEL_XING_B: {
                return this.connectB;
            }
            case LEVEL_XING_C: {
                return this.connectC;
            }
            case LEVEL_XING_D: {
                return this.connectD;
            }
        }
        String errstring = MessageFormat.format("{0}.getConnection({1}); invalid connection type", new Object[]{this.getName(), connectionType});
        log.error("will throw {}", (Object)errstring);
        throw new JmriException(errstring);
    }

    @Override
    public void setConnection(HitPointType connectionType, LayoutTrack o, HitPointType type) throws JmriException {
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); invalid type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        switch (connectionType) {
            case LEVEL_XING_A: {
                this.connectA = o;
                break;
            }
            case LEVEL_XING_B: {
                this.connectB = o;
                break;
            }
            case LEVEL_XING_C: {
                this.connectC = o;
                break;
            }
            case LEVEL_XING_D: {
                this.connectD = o;
                break;
            }
            default: {
                String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); invalid connection type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
                log.error("will throw {}", (Object)errString);
                throw new JmriException(errString);
            }
        }
    }

    public LayoutTrack getConnectA() {
        return this.connectA;
    }

    public LayoutTrack getConnectB() {
        return this.connectB;
    }

    public LayoutTrack getConnectC() {
        return this.connectC;
    }

    public LayoutTrack getConnectD() {
        return this.connectD;
    }

    public void setConnectA(LayoutTrack o, HitPointType type) {
        this.connectA = o;
        if (this.connectA != null && type != HitPointType.TRACK) {
            log.error("{}.setConnectA(({}, {}); invalid type", new Object[]{this.getName(), o.getName(), type});
        }
    }

    public void setConnectB(LayoutTrack o, HitPointType type) {
        this.connectB = o;
        if (this.connectB != null && type != HitPointType.TRACK) {
            log.error("{}.setConnectB(({}, {}); invalid type", new Object[]{this.getName(), o.getName(), type});
        }
    }

    public void setConnectC(LayoutTrack o, HitPointType type) {
        this.connectC = o;
        if (this.connectC != null && type != HitPointType.TRACK) {
            log.error("{}.setConnectC(({}, {}); invalid type", new Object[]{this.getName(), o.getName(), type});
        }
    }

    public void setConnectD(LayoutTrack o, HitPointType type) {
        this.connectD = o;
        if (this.connectD != null && type != HitPointType.TRACK) {
            log.error("{}.setConnectD(({}, {}); invalid type", new Object[]{this.getName(), o.getName(), type});
        }
    }

    public LayoutBlock getLayoutBlockAC() {
        return this.namedLayoutBlockAC != null ? this.namedLayoutBlockAC.getBean() : null;
    }

    public LayoutBlock getLayoutBlockBD() {
        return this.namedLayoutBlockBD != null ? this.namedLayoutBlockBD.getBean() : this.getLayoutBlockAC();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Null is accepted as a valid value")
    public void setLayoutBlockAC(LayoutBlock newLayoutBlock) {
        LayoutBlock blockAC = this.getLayoutBlockAC();
        LayoutBlock blockBD = this.getLayoutBlockBD();
        if (blockAC != newLayoutBlock) {
            if (blockAC != null && blockAC != blockBD) {
                blockAC.decrementUse();
            }
            blockAC = newLayoutBlock;
            this.namedLayoutBlockAC = newLayoutBlock != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(newLayoutBlock.getUserName(), newLayoutBlock) : null;
            if (blockAC != null && blockAC == blockBD) {
                blockAC.decrementUse();
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Null is accepted as a valid value")
    public void setLayoutBlockBD(LayoutBlock newLayoutBlock) {
        LayoutBlock blockAC = this.getLayoutBlockAC();
        LayoutBlock blockBD = this.getLayoutBlockBD();
        if (blockBD != newLayoutBlock) {
            if (blockBD != null && blockBD != blockAC) {
                blockBD.decrementUse();
            }
            blockBD = newLayoutBlock;
            this.namedLayoutBlockBD = newLayoutBlock != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(newLayoutBlock.getUserName(), newLayoutBlock) : null;
            if (blockBD != null && blockBD == blockAC) {
                blockBD.decrementUse();
            }
        }
    }

    public void updateBlockInfo() {
        LayoutBlock blockAC = this.getLayoutBlockAC();
        LayoutBlock blockBD = this.getLayoutBlockBD();
        LayoutBlock b1 = null;
        LayoutBlock b2 = null;
        if (blockAC != null) {
            blockAC.updatePaths();
        }
        if (this.connectA != null && (b1 = ((TrackSegment)this.connectA).getLayoutBlock()) != null && b1 != blockAC) {
            b1.updatePaths();
        }
        if (this.connectC != null && (b2 = ((TrackSegment)this.connectC).getLayoutBlock()) != null && b2 != blockAC && b2 != b1) {
            b2.updatePaths();
        }
        if (blockBD != null) {
            blockBD.updatePaths();
        }
        if (this.connectB != null && (b1 = ((TrackSegment)this.connectB).getLayoutBlock()) != null && b1 != blockBD) {
            b1.updatePaths();
        }
        if (this.connectD != null && (b2 = ((TrackSegment)this.connectD).getLayoutBlock()) != null && b2 != blockBD && b2 != b1) {
            b2.updatePaths();
        }
        this.reCheckBlockBoundary();
    }

    void removeSML(SignalMast signalMast) {
        if (signalMast == null) {
            return;
        }
        if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() && InstanceManager.getDefault(SignalMastLogicManager.class).isSignalMastUsed(signalMast)) {
            SignallingGuiTools.removeSignalMastLogic(null, signalMast);
        }
    }

    public boolean isMainlineAC() {
        return this.connectA != null && ((TrackSegment)this.connectA).isMainline() || this.connectC != null && ((TrackSegment)this.connectC).isMainline();
    }

    public boolean isMainlineBD() {
        return this.connectB != null && ((TrackSegment)this.connectB).isMainline() || this.connectD != null && ((TrackSegment)this.connectD).isMainline();
    }

    @Override
    public boolean isMainline() {
        return this.isMainlineAC() || this.isMainlineBD();
    }

    @Override
    public void setObjects(LayoutEditor p) {
        String userName;
        LayoutBlock lb;
        this.connectA = p.getFinder().findTrackSegmentByName(this.connectAName);
        this.connectB = p.getFinder().findTrackSegmentByName(this.connectBName);
        this.connectC = p.getFinder().findTrackSegmentByName(this.connectCName);
        this.connectD = p.getFinder().findTrackSegmentByName(this.connectDName);
        if (!this.tLayoutBlockNameAC.isEmpty()) {
            lb = p.provideLayoutBlock(this.tLayoutBlockNameAC);
            userName = lb.getUserName();
            if (userName != null) {
                this.namedLayoutBlockAC = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, lb);
                if (this.namedLayoutBlockBD != this.namedLayoutBlockAC) {
                    lb.incrementUse();
                }
            } else {
                log.error("LevelXing.setObjects(); bad blockname AC ''{}''", (Object)this.tLayoutBlockNameAC);
                this.namedLayoutBlockAC = null;
            }
            this.tLayoutBlockNameAC = null;
        }
        if (!this.tLayoutBlockNameBD.isEmpty()) {
            lb = p.provideLayoutBlock(this.tLayoutBlockNameBD);
            userName = lb.getUserName();
            if (userName != null) {
                this.namedLayoutBlockBD = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(userName, lb);
                if (this.namedLayoutBlockBD != this.namedLayoutBlockAC) {
                    lb.incrementUse();
                }
            } else {
                log.error("{}.setObjects(); bad blockname BD ''{}''", (Object)this, (Object)this.tLayoutBlockNameBD);
                this.namedLayoutBlockBD = null;
            }
            this.tLayoutBlockNameBD = null;
        }
    }

    @Override
    public boolean canRemove() {
        ArrayList<String> beanReferences = this.getBeanReferences("All");
        if (!beanReferences.isEmpty()) {
            this.models.displayRemoveWarning(this, beanReferences, "LevelCrossing");
        }
        return beanReferences.isEmpty();
    }

    public ArrayList<String> getBeanReferences(String pointName) {
        ArrayList<String> references = new ArrayList<String>();
        if (pointName.equals("A") || pointName.equals("All")) {
            if (!this.getSignalAMastName().isEmpty()) {
                references.add(this.getSignalAMastName());
            }
            if (!this.getSensorAName().isEmpty()) {
                references.add(this.getSensorAName());
            }
            if (!this.getSignalAName().isEmpty()) {
                references.add(this.getSignalAName());
            }
        }
        if (pointName.equals("B") || pointName.equals("All")) {
            if (!this.getSignalBMastName().isEmpty()) {
                references.add(this.getSignalBMastName());
            }
            if (!this.getSensorBName().isEmpty()) {
                references.add(this.getSensorBName());
            }
            if (!this.getSignalBName().isEmpty()) {
                references.add(this.getSignalBName());
            }
        }
        if (pointName.equals("C") || pointName.equals("All")) {
            if (!this.getSignalCMastName().isEmpty()) {
                references.add(this.getSignalCMastName());
            }
            if (!this.getSensorCName().isEmpty()) {
                references.add(this.getSensorCName());
            }
            if (!this.getSignalCName().isEmpty()) {
                references.add(this.getSignalCName());
            }
        }
        if (pointName.equals("D") || pointName.equals("All")) {
            if (!this.getSignalDMastName().isEmpty()) {
                references.add(this.getSignalDMastName());
            }
            if (!this.getSensorDName().isEmpty()) {
                references.add(this.getSensorDName());
            }
            if (!this.getSignalDName().isEmpty()) {
                references.add(this.getSignalDName());
            }
        }
        return references;
    }

    public String[] getBlockBoundaries() {
        String[] boundaryBetween = new String[4];
        String blockNameAC = this.getBlockNameAC();
        String blockNameBD = this.getBlockNameBD();
        LayoutBlock blockAC = this.getLayoutBlockAC();
        LayoutBlock blockBD = this.getLayoutBlockAC();
        if (!blockNameAC.isEmpty() && blockAC != null) {
            if (this.connectA instanceof TrackSegment && ((TrackSegment)this.connectA).getLayoutBlock() != blockAC) {
                try {
                    boundaryBetween[0] = ((TrackSegment)this.connectA).getLayoutBlock().getDisplayName() + " - " + blockAC.getDisplayName();
                }
                catch (NullPointerException e) {
                    log.debug("TrackSegement at connection A doesn't contain a layout block");
                }
            }
            if (this.connectC instanceof TrackSegment && ((TrackSegment)this.connectC).getLayoutBlock() != blockAC) {
                try {
                    boundaryBetween[2] = ((TrackSegment)this.connectC).getLayoutBlock().getDisplayName() + " - " + blockAC.getDisplayName();
                }
                catch (NullPointerException e) {
                    log.debug("TrackSegement at connection C doesn't contain a layout block");
                }
            }
        }
        if (!blockNameBD.isEmpty() && blockBD != null) {
            if (this.connectB instanceof TrackSegment && ((TrackSegment)this.connectB).getLayoutBlock() != blockBD) {
                try {
                    boundaryBetween[1] = ((TrackSegment)this.connectB).getLayoutBlock().getDisplayName() + " - " + blockBD.getDisplayName();
                }
                catch (NullPointerException e) {
                    log.debug("TrackSegement at connection B doesn't contain a layout block");
                }
            }
            if (this.connectD instanceof TrackSegment && ((TrackSegment)this.connectD).getLayoutBlock() != blockBD) {
                try {
                    boundaryBetween[3] = ((TrackSegment)this.connectD).getLayoutBlock().getDisplayName() + " - " + blockBD.getDisplayName();
                }
                catch (NullPointerException e) {
                    log.debug("TrackSegement at connection D doesn't contain a layout block");
                }
            }
        }
        return boundaryBetween;
    }

    public void remove() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void addSignalMastLogic(SignalMast sm) {
        if (this.sml.contains(sm)) {
            return;
        }
        if (this.sml.isEmpty()) {
            this.sml.add(sm);
            return;
        }
        SignalMastLogic sl = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(sm);
        for (SignalMast signalMast : this.sml) {
            SignalMastLogic s = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(signalMast);
            if (s != null) {
                s.setConflictingLogic(sm, this);
            }
            sl.setConflictingLogic(signalMast, this);
        }
        this.sml.add(sm);
    }

    public void removeSignalMastLogic(SignalMast sm) {
        if (!this.sml.contains(sm)) {
            return;
        }
        this.sml.remove(sm);
        if (this.sml.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.sml.size(); ++i) {
            SignalMastLogic s = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(sm);
            if (s == null) continue;
            s.removeConflictingLogic(sm, this);
        }
    }

    @Override
    public void reCheckBlockBoundary() {
    }

    protected ArrayList<LayoutConnectivity> getLayoutConnectivity() {
        return null;
    }

    @Override
    public List<HitPointType> checkForFreeConnections() {
        ArrayList<HitPointType> result = new ArrayList<HitPointType>();
        if (this.getConnectA() == null) {
            result.add(HitPointType.LEVEL_XING_A);
        }
        if (this.getConnectB() == null) {
            result.add(HitPointType.LEVEL_XING_B);
        }
        if (this.getConnectC() == null) {
            result.add(HitPointType.LEVEL_XING_C);
        }
        if (this.getConnectD() == null) {
            result.add(HitPointType.LEVEL_XING_D);
        }
        return result;
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        return this.getLayoutBlockAC() != null && this.getLayoutBlockBD() != null;
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        HashMap<LayoutTrack, String> blocksAndTracksMap = new HashMap<LayoutTrack, String>();
        if (this.getLayoutBlockAC() != null && this.connectA != null) {
            blocksAndTracksMap.put(this.connectA, this.getLayoutBlockAC().getDisplayName());
        }
        if (this.getLayoutBlockAC() != null && this.connectC != null) {
            blocksAndTracksMap.put(this.connectC, this.getLayoutBlockAC().getDisplayName());
        }
        if (this.getLayoutBlockBD() != null && this.connectB != null) {
            blocksAndTracksMap.put(this.connectB, this.getLayoutBlockBD().getDisplayName());
        }
        if (this.getLayoutBlockBD() != null && this.connectD != null) {
            blocksAndTracksMap.put(this.connectD, this.getLayoutBlockBD().getDisplayName());
        }
        List<Set<String>> TrackNameSets = null;
        LinkedHashSet<String> TrackNameSet = null;
        for (Map.Entry entry : blocksAndTracksMap.entrySet()) {
            LayoutTrack theConnect = (LayoutTrack)entry.getKey();
            String theBlockName = (String)entry.getValue();
            TrackNameSet = null;
            TrackNameSets = blockNamesToTrackNameSetsMap.get(theBlockName);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block ('{}') trackNameSets", (Object)theBlockName);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(theBlockName, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet<String>();
                TrackNameSets.add(TrackNameSet);
            }
            if (TrackNameSet.add(this.getName())) {
                log.debug("*    Add track ''{}'' to trackNameSet for block ''{}''", (Object)this.getName(), (Object)theBlockName);
            }
            theConnect.collectContiguousTracksNamesInBlockNamed(theBlockName, TrackNameSet);
        }
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        if (!TrackNameSet.contains(this.getName())) {
            if (this.getBlockNameAC().equals(blockName)) {
                if (TrackNameSet.add(this.getName())) {
                    log.debug("*    Add track ''{}'for block ''{}''", (Object)this.getName(), (Object)blockName);
                }
                if (this.connectA != null) {
                    this.connectA.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
                }
                if (this.connectC != null) {
                    this.connectC.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
                }
            }
            if (this.getBlockNameBD().equals(blockName)) {
                if (TrackNameSet.add(this.getName())) {
                    log.debug("*    Add track ''{}''for block ''{}''", (Object)this.getName(), (Object)blockName);
                }
                if (this.connectB != null) {
                    this.connectB.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
                }
                if (this.connectD != null) {
                    this.connectD.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
                }
            }
        }
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
        this.setLayoutBlockAC(layoutBlock);
        this.setLayoutBlockBD(layoutBlock);
    }

    @Override
    public String getTypeName() {
        return Bundle.getMessage("TypeName_LevelXing");
    }

    public static enum Geometry {
        POINTA,
        POINTB,
        POINTC,
        POINTD;

    }
}

