/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LevelXingEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.jmrit.display.layoutEditor.LayoutEditorToolBarPanel;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.LayoutBlockRouteTableAction;
import jmri.util.MathUtil;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelXingView
extends LayoutTrackView {
    private Point2D dispA = new Point2D.Double(-20.0, 0.0);
    private Point2D dispB = new Point2D.Double(-14.0, 14.0);
    private final LevelXingEditor editor;
    private final LevelXing xing;
    JPopupMenu popup = null;
    ArrayList<JMenuItem> editAdditionalMenu = new ArrayList(0);
    ArrayList<JMenuItem> viewAdditionalMenu = new ArrayList(0);
    private static final Logger log = LoggerFactory.getLogger(LevelXingView.class);

    public LevelXingView(@Nonnull LevelXing xing, @Nonnull LayoutEditor layoutEditor) {
        super(xing, layoutEditor);
        this.xing = xing;
        this.editor = new LevelXingEditor(layoutEditor);
    }

    public LevelXingView(@Nonnull LevelXing xing, @Nonnull Point2D c, @Nonnull LayoutEditor layoutEditor) {
        super(xing, c, layoutEditor);
        this.xing = xing;
        this.editor = new LevelXingEditor(layoutEditor);
    }

    @Nonnull
    public LevelXing getLevelXing() {
        return this.xing;
    }

    public String toString() {
        return "LevelXing " + this.getName();
    }

    @Nonnull
    public String getBlockNameAC() {
        return this.xing.getBlockNameAC();
    }

    @Nonnull
    public String getBlockNameBD() {
        return this.xing.getBlockNameBD();
    }

    public SignalHead getSignalHead(LevelXing.Geometry loc) {
        return this.xing.getSignalHead(loc);
    }

    public SignalMast getSignalMast(LevelXing.Geometry loc) {
        return this.xing.getSignalMast(loc);
    }

    public Sensor getSensor(LevelXing.Geometry loc) {
        return this.xing.getSensor(loc);
    }

    @Nonnull
    public String getSignalAName() {
        return this.xing.getSignalAName();
    }

    public void setSignalAName(String signalHead) {
        this.xing.setSignalAName(signalHead);
    }

    @Nonnull
    public String getSignalBName() {
        return this.xing.getSignalBName();
    }

    public void setSignalBName(String signalHead) {
        this.xing.setSignalBName(signalHead);
    }

    @Nonnull
    public String getSignalCName() {
        return this.xing.getSignalCName();
    }

    public void setSignalCName(String signalHead) {
        this.xing.setSignalCName(signalHead);
    }

    @Nonnull
    public String getSignalDName() {
        return this.xing.getSignalDName();
    }

    public void setSignalDName(String signalHead) {
        this.xing.setSignalDName(signalHead);
    }

    public void removeBeanReference(NamedBean nb) {
        this.xing.removeBeanReference(nb);
    }

    public String getSignalAMastName() {
        return this.xing.getSignalAMastName();
    }

    public SignalMast getSignalAMast() {
        return this.xing.getSignalAMast();
    }

    public void setSignalAMast(String signalMast) {
        this.xing.setSignalAMast(signalMast);
    }

    public String getSignalBMastName() {
        return this.xing.getSignalBMastName();
    }

    public SignalMast getSignalBMast() {
        return this.xing.getSignalBMast();
    }

    public void setSignalBMast(String signalMast) {
        this.xing.setSignalBMast(signalMast);
    }

    public String getSignalCMastName() {
        return this.xing.getSignalCMastName();
    }

    public SignalMast getSignalCMast() {
        return this.xing.getSignalCMast();
    }

    public void setSignalCMast(String signalMast) {
        this.xing.setSignalCMast(signalMast);
    }

    public String getSignalDMastName() {
        return this.xing.getSignalDMastName();
    }

    public SignalMast getSignalDMast() {
        return this.xing.getSignalDMast();
    }

    public void setSignalDMast(String signalMast) {
        this.xing.setSignalDMast(signalMast);
    }

    public String getSensorAName() {
        return this.xing.getSensorAName();
    }

    public Sensor getSensorA() {
        return this.xing.getSensorA();
    }

    public void setSensorAName(String sensorName) {
        this.xing.setSensorAName(sensorName);
    }

    public String getSensorBName() {
        return this.xing.getSensorBName();
    }

    public Sensor getSensorB() {
        return this.xing.getSensorB();
    }

    public void setSensorBName(String sensorName) {
        this.xing.setSensorBName(sensorName);
    }

    public String getSensorCName() {
        return this.xing.getSensorCName();
    }

    public Sensor getSensorC() {
        return this.xing.getSensorC();
    }

    public void setSensorCName(String sensorName) {
        this.xing.setSensorCName(sensorName);
    }

    public String getSensorDName() {
        return this.xing.getSensorDName();
    }

    public Sensor getSensorD() {
        return this.xing.getSensorD();
    }

    public void setSensorDName(String sensorName) {
        this.xing.setSensorDName(sensorName);
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        return this.xing.getConnection(connectionType);
    }

    @Override
    public void setConnection(HitPointType connectionType, LayoutTrack o, HitPointType type) throws JmriException {
        this.xing.setConnection(connectionType, o, type);
    }

    public LayoutTrack getConnectA() {
        return this.xing.getConnectA();
    }

    public LayoutTrack getConnectB() {
        return this.xing.getConnectB();
    }

    public LayoutTrack getConnectC() {
        return this.xing.getConnectC();
    }

    public LayoutTrack getConnectD() {
        return this.xing.getConnectD();
    }

    public void setConnectA(LayoutTrack o, HitPointType type) {
        this.xing.setConnectA(o, type);
    }

    public void setConnectB(LayoutTrack o, HitPointType type) {
        this.xing.setConnectB(o, type);
    }

    public void setConnectC(LayoutTrack o, HitPointType type) {
        this.xing.setConnectC(o, type);
    }

    public void setConnectD(LayoutTrack o, HitPointType type) {
        this.xing.setConnectD(o, type);
    }

    public LayoutBlock getLayoutBlockAC() {
        return this.xing.getLayoutBlockAC();
    }

    public LayoutBlock getLayoutBlockBD() {
        return this.xing.getLayoutBlockBD();
    }

    public Point2D getCoordsA() {
        return MathUtil.add(this.getCoordsCenter(), this.dispA);
    }

    public Point2D getCoordsB() {
        return MathUtil.add(this.getCoordsCenter(), this.dispB);
    }

    public Point2D getCoordsC() {
        return MathUtil.subtract(this.getCoordsCenter(), this.dispA);
    }

    public Point2D getCoordsD() {
        return MathUtil.subtract(this.getCoordsCenter(), this.dispB);
    }

    @Override
    public Point2D getCoordsForConnectionType(HitPointType connectionType) {
        Point2D result = this.getCoordsCenter();
        switch (connectionType) {
            case LEVEL_XING_CENTER: {
                break;
            }
            case LEVEL_XING_A: {
                result = this.getCoordsA();
                break;
            }
            case LEVEL_XING_B: {
                result = this.getCoordsB();
                break;
            }
            case LEVEL_XING_C: {
                result = this.getCoordsC();
                break;
            }
            case LEVEL_XING_D: {
                result = this.getCoordsD();
                break;
            }
            default: {
                log.error("{}.getCoordsForConnectionType({}); Invalid connection type ", (Object)this.getName(), (Object)connectionType);
            }
        }
        return result;
    }

    @Override
    public Rectangle2D getBounds() {
        Point2D pointA = this.getCoordsA();
        Rectangle2D.Double result = new Rectangle2D.Double(pointA.getX(), pointA.getY(), 0.0, 0.0);
        result.add(this.getCoordsB());
        result.add(this.getCoordsC());
        result.add(this.getCoordsD());
        return result;
    }

    public boolean isMainlineAC() {
        return this.xing.isMainlineAC();
    }

    public boolean isMainlineBD() {
        return this.xing.isMainlineBD();
    }

    public void setCoordsA(Point2D p) {
        this.dispA = MathUtil.subtract(p, this.getCoordsCenter());
    }

    public void setCoordsB(Point2D p) {
        this.dispB = MathUtil.subtract(p, this.getCoordsCenter());
    }

    public void setCoordsC(Point2D p) {
        this.dispA = MathUtil.subtract(this.getCoordsCenter(), p);
    }

    public void setCoordsD(Point2D p) {
        this.dispB = MathUtil.subtract(this.getCoordsCenter(), p);
    }

    @Override
    public void scaleCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        super.setCoordsCenter(MathUtil.granulize(MathUtil.multiply(this.getCoordsCenter(), (Point2D)factor), 1.0));
        this.dispA = MathUtil.granulize(MathUtil.multiply(this.dispA, (Point2D)factor), 1.0);
        this.dispB = MathUtil.granulize(MathUtil.multiply(this.dispB, (Point2D)factor), 1.0);
    }

    @Override
    public void translateCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        super.setCoordsCenter(MathUtil.add(this.getCoordsCenter(), factor));
    }

    @Override
    public void rotateCoords(double angleDEG) {
        double rotRAD = Math.toRadians(angleDEG);
        double sineRot = Math.sin(rotRAD);
        double cosineRot = Math.cos(rotRAD);
        Point2D center_temp = this.getCoordsCenter();
        super.setCoordsCenter(MathUtil.zeroPoint2D);
        this.dispA = this.rotatePoint(this.dispA, sineRot, cosineRot);
        this.dispB = this.rotatePoint(this.dispB, sineRot, cosineRot);
        super.setCoordsCenter(center_temp);
    }

    @Override
    protected HitPointType findHitPointType(Point2D hitPoint, boolean useRectangles, boolean requireUnconnected) {
        Point2D p;
        double distance;
        HitPointType result = HitPointType.NONE;
        Rectangle2D r = this.trackControlCircleRectAt(hitPoint);
        Point2D minPoint = MathUtil.zeroPoint2D;
        double circleRadius = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
        double minDistance = Double.POSITIVE_INFINITY;
        if (!requireUnconnected && (distance = MathUtil.distance(p = this.getCoordsCenter(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.LEVEL_XING_CENTER;
        }
        if ((!requireUnconnected || this.getConnectA() == null) && (distance = MathUtil.distance(p = this.getCoordsA(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.LEVEL_XING_A;
        }
        if ((!requireUnconnected || this.getConnectB() == null) && (distance = MathUtil.distance(p = this.getCoordsB(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.LEVEL_XING_B;
        }
        if ((!requireUnconnected || this.getConnectC() == null) && (distance = MathUtil.distance(p = this.getCoordsC(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.LEVEL_XING_C;
        }
        if ((!requireUnconnected || this.getConnectD() == null) && (distance = MathUtil.distance(p = this.getCoordsD(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.LEVEL_XING_D;
        }
        if (useRectangles && !r.contains(minPoint) || !useRectangles && minDistance > circleRadius) {
            result = HitPointType.NONE;
        }
        return result;
    }

    @Override
    public boolean canRemove() {
        return this.xing.canRemove();
    }

    @Override
    @Nonnull
    protected JPopupMenu showPopup(@Nonnull JmriMouseEvent mouseEvent) {
        if (this.popup != null) {
            this.popup.removeAll();
        } else {
            this.popup = new JPopupMenu();
        }
        if (this.layoutEditor.isEditable()) {
            JMenuItem jmi = this.popup.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("LevelCrossing")) + this.getName());
            jmi.setEnabled(false);
            boolean blockACAssigned = false;
            boolean blockBDAssigned = false;
            if (this.getLayoutBlockAC() == null) {
                jmi = this.popup.add(Bundle.getMessage("NoBlockX", "AC"));
            } else {
                jmi = this.popup.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", "AC")) + this.getLayoutBlockAC().getDisplayName());
                blockACAssigned = true;
            }
            jmi.setEnabled(false);
            if (this.getLayoutBlockBD() == null) {
                jmi = this.popup.add(Bundle.getMessage("NoBlockX", "BD"));
            } else {
                jmi = this.popup.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", "BD")) + this.getLayoutBlockBD().getDisplayName());
                blockBDAssigned = true;
            }
            jmi.setEnabled(false);
            if (this.getConnectA() != null || this.getConnectB() != null || this.getConnectC() != null || this.getConnectD() != null) {
                JMenu connectionsMenu = new JMenu(Bundle.getMessage("Connections"));
                if (this.getConnectA() != null) {
                    connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "A") + this.getConnectA().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LevelXingView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LevelXingView.this.getConnectA().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LevelXingView.this.layoutEditor.getLayoutTrackView(lt);
                                LevelXingView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                if (this.getConnectB() != null) {
                    connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "B") + this.getConnectB().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LevelXingView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LevelXingView.this.getConnectB().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LevelXingView.this.layoutEditor.getLayoutTrackView(lt);
                                LevelXingView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                if (this.getConnectC() != null) {
                    connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "C") + this.getConnectC().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LevelXingView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LevelXingView.this.getConnectC().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LevelXingView.this.layoutEditor.getLayoutTrackView(lt);
                                LevelXingView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                if (this.getConnectD() != null) {
                    connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "D") + this.getConnectD().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LevelXingView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LevelXingView.this.getConnectD().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LevelXingView.this.layoutEditor.getLayoutTrackView(lt);
                                LevelXingView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                this.popup.add(connectionsMenu);
            }
            this.popup.add(new JSeparator(0));
            JCheckBoxMenuItem hiddenCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("Hidden"));
            hiddenCheckBoxMenuItem.setSelected(this.isHidden());
            this.popup.add(hiddenCheckBoxMenuItem);
            hiddenCheckBoxMenuItem.addActionListener(e3 -> this.setHidden(hiddenCheckBoxMenuItem.isSelected()));
            this.popup.add(new AbstractAction(Bundle.getMessage("ButtonEdit")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LevelXingView.this.editor.editLayoutTrack(LevelXingView.this);
                }
            });
            this.popup.add(new AbstractAction(Bundle.getMessage("ButtonDelete")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LevelXingView.this.canRemove() && LevelXingView.this.removeInlineLogixNG() && LevelXingView.this.layoutEditor.removeLevelXing(LevelXingView.this.xing)) {
                        LevelXingView.this.xing.remove();
                        LevelXingView.this.dispose();
                    }
                }
            });
            if (blockACAssigned && blockBDAssigned) {
                AbstractAction ssaa = new AbstractAction(Bundle.getMessage("SetSignals")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutEditorToolBarPanel letbp = LevelXingView.this.getLayoutEditorToolBarPanel();
                        LevelXingView.this.layoutEditor.getLETools().setSignalsAtLevelXingFromMenu(LevelXingView.this.xing, letbp.signalIconEditor, letbp.signalFrame);
                    }
                };
                JMenu jm = new JMenu(Bundle.getMessage("SignalHeads"));
                if (this.layoutEditor.getLETools().addLevelXingSignalHeadInfoToMenu(this.xing, jm).booleanValue()) {
                    jm.add(ssaa);
                    this.popup.add(jm);
                } else {
                    this.popup.add(ssaa);
                }
            }
            final String[] boundaryBetween = this.xing.getBlockBoundaries();
            boolean blockBoundaries = false;
            if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
                if (blockACAssigned && !blockBDAssigned) {
                    this.popup.add(new AbstractAction(Bundle.getMessage("ViewBlockRouting")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutBlockRouteTableAction routeTableAction = new LayoutBlockRouteTableAction("ViewRouting", LevelXingView.this.getLayoutBlockAC());
                            routeTableAction.actionPerformed(e);
                        }
                    });
                } else if (!blockACAssigned && blockBDAssigned) {
                    this.popup.add(new AbstractAction(Bundle.getMessage("ViewBlockRouting")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutBlockRouteTableAction routeTableAction = new LayoutBlockRouteTableAction("ViewRouting", LevelXingView.this.getLayoutBlockBD());
                            routeTableAction.actionPerformed(e);
                        }
                    });
                } else if (blockACAssigned && blockBDAssigned) {
                    JMenu viewRouting = new JMenu(Bundle.getMessage("ViewBlockRouting"));
                    viewRouting.add(new AbstractAction(this.getLayoutBlockAC().getDisplayName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutBlockRouteTableAction routeTableAction = new LayoutBlockRouteTableAction(LevelXingView.this.getLayoutBlockAC().getDisplayName(), LevelXingView.this.getLayoutBlockAC());
                            routeTableAction.actionPerformed(e);
                        }
                    });
                    viewRouting.add(new AbstractAction(this.getLayoutBlockBD().getDisplayName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutBlockRouteTableAction routeTableAction = new LayoutBlockRouteTableAction(LevelXingView.this.getLayoutBlockBD().getDisplayName(), LevelXingView.this.getLayoutBlockBD());
                            routeTableAction.actionPerformed(e);
                        }
                    });
                    this.popup.add(viewRouting);
                }
            }
            for (int i = 0; i < 4; ++i) {
                if (boundaryBetween[i] == null) continue;
                blockBoundaries = true;
            }
            if (blockBoundaries) {
                this.popup.add(new AbstractAction(Bundle.getMessage("SetSignalMasts")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutEditorToolBarPanel letbp = LevelXingView.this.getLayoutEditorToolBarPanel();
                        LevelXingView.this.layoutEditor.getLETools().setSignalMastsAtLevelXingFromMenu(LevelXingView.this.xing, boundaryBetween, letbp.signalFrame);
                    }
                });
                this.popup.add(new AbstractAction(Bundle.getMessage("SetSensors")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutEditorToolBarPanel letbp = LevelXingView.this.getLayoutEditorToolBarPanel();
                        LevelXingView.this.layoutEditor.getLETools().setSensorsAtLevelXingFromMenu(LevelXingView.this.xing, boundaryBetween, letbp.sensorIconEditor, letbp.sensorFrame);
                    }
                });
            }
            this.layoutEditor.setShowAlignmentMenu(this.popup);
            this.addCommonPopupItems(mouseEvent, this.popup);
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (!this.viewAdditionalMenu.isEmpty()) {
            this.setAdditionalViewPopUpMenu(this.popup);
            this.addCommonPopupItems(mouseEvent, this.popup);
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        return this.popup;
    }

    public void dispose() {
        if (this.popup != null) {
            this.popup.removeAll();
        }
        this.popup = null;
    }

    public void addEditPopUpMenu(JMenuItem menu) {
        if (!this.editAdditionalMenu.contains(menu)) {
            this.editAdditionalMenu.add(menu);
        }
    }

    public void addViewPopUpMenu(JMenuItem menu) {
        if (!this.viewAdditionalMenu.contains(menu)) {
            this.viewAdditionalMenu.add(menu);
        }
    }

    public void setAdditionalEditPopUpMenu(JPopupMenu popup) {
        if (this.editAdditionalMenu.isEmpty()) {
            return;
        }
        popup.addSeparator();
        for (JMenuItem mi : this.editAdditionalMenu) {
            popup.add(mi);
        }
    }

    public void setAdditionalViewPopUpMenu(JPopupMenu popup) {
        if (this.viewAdditionalMenu.isEmpty()) {
            return;
        }
        popup.addSeparator();
        for (JMenuItem mi : this.viewAdditionalMenu) {
            popup.add(mi);
        }
    }

    @Override
    protected void drawDecorations(Graphics2D g2) {
    }

    @Override
    protected void draw1(Graphics2D g2, boolean isMain, boolean isBlock) {
        if (isMain == this.isMainlineAC()) {
            if (isBlock) {
                this.setColorForTrackBlock(g2, this.getLayoutBlockAC());
            }
            g2.draw(new Line2D.Double(this.getCoordsA(), this.getCoordsC()));
        }
        if (isMain == this.isMainlineBD()) {
            if (isBlock) {
                this.setColorForTrackBlock(g2, this.getLayoutBlockBD());
            }
            g2.draw(new Line2D.Double(this.getCoordsB(), this.getCoordsD()));
        }
    }

    @Override
    protected void draw2(Graphics2D g2, boolean isMain, float railDisplacement) {
        Point2D pA = this.getCoordsA();
        Point2D pB = this.getCoordsB();
        Point2D pC = this.getCoordsC();
        Point2D pD = this.getCoordsD();
        Point2D pM = this.getCoordsCenter();
        Point2D vAC = MathUtil.normalize(MathUtil.subtract(pC, pA), railDisplacement);
        double dirAC_DEG = MathUtil.computeAngleDEG(pA, pC);
        Point2D vACo = MathUtil.orthogonal(vAC);
        Point2D pAL = MathUtil.subtract(pA, vACo);
        Point2D pAR = MathUtil.add(pA, vACo);
        Point2D pCL = MathUtil.subtract(pC, vACo);
        Point2D pCR = MathUtil.add(pC, vACo);
        Point2D vBD = MathUtil.normalize(MathUtil.subtract(pD, pB), railDisplacement);
        double dirBD_DEG = MathUtil.computeAngleDEG(pB, pD);
        Point2D vBDo = MathUtil.orthogonal(vBD);
        Point2D pBL = MathUtil.subtract(pB, vBDo);
        Point2D pBR = MathUtil.add(pB, vBDo);
        Point2D pDL = MathUtil.subtract(pD, vBDo);
        Point2D pDR = MathUtil.add(pD, vBDo);
        double deltaDEG = MathUtil.absDiffAngleDEG(dirAC_DEG, dirBD_DEG);
        double deltaRAD = Math.toRadians(deltaDEG);
        double hypotK = (double)railDisplacement / Math.cos((Math.PI - deltaRAD) / 2.0);
        double hypotV = (double)railDisplacement / Math.cos(deltaRAD / 2.0);
        log.debug("dir AC: {}, BD: {}, diff: {}", new Object[]{dirAC_DEG, dirBD_DEG, deltaDEG});
        Point2D vDisK = MathUtil.normalize(MathUtil.add(vAC, vBD), hypotK);
        Point2D vDisV = MathUtil.normalize(MathUtil.orthogonal(vDisK), hypotV);
        Point2D pKL = MathUtil.subtract(pM, vDisK);
        Point2D pKR = MathUtil.add(pM, vDisK);
        Point2D pVL = MathUtil.subtract(pM, vDisV);
        Point2D pVR = MathUtil.add(pM, vDisV);
        if (isMain == this.isMainlineAC()) {
            Point2D vAC2 = MathUtil.normalize(vAC, 2.0);
            Point2D pKLtC = MathUtil.add(pKL, vAC2);
            Point2D pVRtA = MathUtil.subtract(pVR, vAC2);
            Point2D pVLtC = MathUtil.add(pVL, vAC2);
            Point2D pKRtA = MathUtil.subtract(pKR, vAC2);
            g2.draw(new Line2D.Double(pAR, pKL));
            g2.draw(new Line2D.Double(pKLtC, pVRtA));
            g2.draw(new Line2D.Double(pVR, pCR));
            g2.draw(new Line2D.Double(pAL, pVL));
            g2.draw(new Line2D.Double(pVLtC, pKRtA));
            g2.draw(new Line2D.Double(pKR, pCL));
        }
        if (isMain == this.isMainlineBD()) {
            Point2D vBD2 = MathUtil.normalize(vBD, 2.0);
            Point2D pVRtD = MathUtil.add(pVR, vBD2);
            Point2D pKRtB = MathUtil.subtract(pKR, vBD2);
            Point2D pKLtD = MathUtil.add(pKL, vBD2);
            Point2D pVLtB = MathUtil.subtract(pVL, vBD2);
            g2.draw(new Line2D.Double(pBR, pVR));
            g2.draw(new Line2D.Double(pVRtD, pKRtB));
            g2.draw(new Line2D.Double(pKR, pDR));
            g2.draw(new Line2D.Double(pBL, pKL));
            g2.draw(new Line2D.Double(pKLtD, pVLtB));
            g2.draw(new Line2D.Double(pVL, pDL));
        }
    }

    @Override
    protected void highlightUnconnected(Graphics2D g2, HitPointType specificType) {
        if ((specificType == HitPointType.NONE || specificType == HitPointType.LEVEL_XING_A) && this.getConnectA() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsA()));
        }
        if ((specificType == HitPointType.NONE || specificType == HitPointType.LEVEL_XING_B) && this.getConnectB() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsB()));
        }
        if ((specificType == HitPointType.NONE || specificType == HitPointType.LEVEL_XING_C) && this.getConnectC() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsC()));
        }
        if ((specificType == HitPointType.NONE || specificType == HitPointType.LEVEL_XING_D) && this.getConnectD() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsD()));
        }
    }

    @Override
    protected void drawEditControls(Graphics2D g2) {
        g2.setColor(this.layoutEditor.getDefaultTrackColorColor());
        g2.draw(this.trackEditControlCircleAt(this.getCoordsCenter()));
        if (this.getConnectA() == null) {
            g2.setColor(Color.magenta);
        } else {
            g2.setColor(Color.blue);
        }
        g2.draw(this.layoutEditor.layoutEditorControlRectAt(this.getCoordsA()));
        if (this.getConnectB() == null) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(Color.green);
        }
        g2.draw(this.layoutEditor.layoutEditorControlRectAt(this.getCoordsB()));
        if (this.getConnectC() == null) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(Color.green);
        }
        g2.draw(this.layoutEditor.layoutEditorControlRectAt(this.getCoordsC()));
        if (this.getConnectD() == null) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(Color.green);
        }
        g2.draw(this.layoutEditor.layoutEditorControlRectAt(this.getCoordsD()));
    }

    @Override
    protected void drawTurnoutControls(Graphics2D g2) {
    }

    @Override
    public void reCheckBlockBoundary() {
    }

    protected ArrayList<LayoutConnectivity> getLayoutConnectivity() {
        return null;
    }

    @Override
    public List<HitPointType> checkForFreeConnections() {
        throw new IllegalArgumentException("should have called Object instead of view temporary");
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        throw new IllegalArgumentException("should have called Object instead of View temporary");
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        throw new IllegalArgumentException("should have called Object instead of View temporary");
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        throw new IllegalArgumentException("should have called Object instead of View temporary");
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
        throw new IllegalArgumentException("should have called Object instead of View temporary");
    }
}

