/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import jmri.Block;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.Path;
import jmri.Reportable;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Cannot rename for user data compatiblity reasons.")
public class MemoryIcon
extends jmri.jmrit.display.MemoryIcon {
    private final String defaultText = " ";
    LayoutEditor panel;
    private LayoutBlock lBlock = null;
    private final JCheckBoxMenuItem updateBlockItem = new JCheckBoxMenuItem("Update Block Details");
    private static final Logger log = LoggerFactory.getLogger(MemoryIcon.class);

    public MemoryIcon(String s, LayoutEditor panel) {
        super(s, (Editor)panel);
        this.panel = panel;
        log.debug("MemoryIcon ctor= {}", (Object)MemoryIcon.class.getName());
    }

    @Override
    public void setText(String text) {
        if (text == null || text.isEmpty()) {
            super.setText(" ");
        } else {
            super.setText(text);
        }
    }

    public LayoutBlock getLayoutBlock() {
        return this.lBlock;
    }

    public void setLayoutBlock(LayoutBlock lb) {
        this.lBlock = lb;
    }

    @Override
    public void displayState() {
        Object key;
        log.debug("displayState");
        if (this.getMemory() == null) {
            this.setText(" ");
            this.updateSize();
            return;
        }
        if (this.re != null) {
            InstanceManager.throttleManagerInstance().removeListener(this.re.getDccLocoAddress(), this);
            this.re = null;
        }
        if ((key = this.getMemory().getValue()) != null) {
            HashMap<String, NamedIcon> map = this.getMap();
            if (map == null) {
                Object val = key;
                if (val instanceof RosterEntry) {
                    RosterEntry roster = (RosterEntry)val;
                    val = this.updateIconFromRosterVal(roster);
                    this.flipRosterIcon = false;
                    if (val == null) {
                        return;
                    }
                }
                if (val instanceof String) {
                    if (((String)val).isEmpty()) {
                        this.setText(" ");
                    } else {
                        this.setText((String)val);
                    }
                    this.setIcon(null);
                    this._text = true;
                    this._icon = false;
                    this.setAttributes(this.getPopupUtility(), this);
                    this.updateSize();
                } else if (val instanceof ImageIcon) {
                    this.setIcon((ImageIcon)val);
                    this.setText(null);
                    this._text = false;
                    this._icon = true;
                    this.updateSize();
                } else if (val instanceof Number) {
                    this.setText(val.toString());
                    this.setIcon(null);
                    this._text = true;
                    this._icon = false;
                    this.setAttributes(this.getPopupUtility(), this);
                    this.updateSize();
                } else if (val instanceof IdTag) {
                    this.setText(((IdTag)val).getDisplayName());
                    this.setIcon(null);
                    this._text = true;
                    this._icon = false;
                    this.updateSize();
                } else if (val instanceof Reportable) {
                    this.setText(((Reportable)val).toReportString());
                    this.setIcon(null);
                    this._text = true;
                    this._icon = false;
                    this.updateSize();
                } else {
                    log.warn("can't display current value of {}, val= {} of Class {}", new Object[]{this.getNamedMemory().getName(), val, val.getClass().getName()});
                }
            } else {
                NamedIcon newicon = map.get(key.toString());
                if (newicon != null) {
                    this.setText(null);
                    super.setIcon(newicon);
                    this._text = false;
                    this._icon = true;
                    this.updateSize();
                } else {
                    this.setIcon(this.getDefaultIcon());
                    this.setText(null);
                    this._text = false;
                    this._icon = true;
                    this.updateSize();
                }
            }
        } else {
            this.setIcon(null);
            this.setText(" ");
            this._text = true;
            this._icon = false;
            this.updateSize();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        this.panel.redrawPanel();
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable()) {
            popup.add(this.updateBlockItem);
            this.updateBlockItem.setSelected(this.updateBlockValueOnChange());
            this.updateBlockItem.addActionListener(e -> this.updateBlockValueOnChange(this.updateBlockItem.isSelected()));
        }
        return super.showPopUp(popup);
    }

    @Override
    public void setMemory(String pName) {
        super.setMemory(pName);
        this.lBlock = InstanceManager.getDefault(LayoutBlockManager.class).getBlockWithMemoryAssigned(this.getMemory());
    }

    @Override
    protected void setValue(Object obj) {
        if (this.updateBlockValue && this.lBlock != null) {
            this.lBlock.getBlock().setValue(obj);
        } else {
            this.getMemory().setValue(obj);
            this.updateSize();
        }
    }

    @Override
    protected void addRosterToIcon(RosterEntry roster) {
        int dirB;
        int dirA;
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() || this.lBlock == null) {
            super.addRosterToIcon(roster);
            return;
        }
        int paths = this.lBlock.getNumberOfThroughPaths();
        Block srcBlock = null;
        Block desBlock = null;
        for (int i = 0; i < paths; ++i) {
            if (!this.lBlock.isThroughPathActive(i).booleanValue()) continue;
            srcBlock = this.lBlock.getThroughPathSource(i);
            desBlock = this.lBlock.getThroughPathDestination(i);
            break;
        }
        if (srcBlock != null && desBlock != null) {
            dirA = this.lBlock.getNeighbourDirection(srcBlock);
            dirB = this.lBlock.getNeighbourDirection(desBlock);
        } else {
            dirA = 64;
            dirB = 128;
        }
        Object[] options = new Object[]{"Facing " + Path.decodeDirection(dirB), "Facing " + Path.decodeDirection(dirA), "Do Not Add"};
        int n = JmriJOptionPane.showOptionDialog(this, "Would you like to assign loco " + roster.titleString() + " to this location", "Assign Loco", -1, 3, null, options, options[2]);
        if (n == 2 || n == -1) {
            return;
        }
        if (n == 0) {
            this.flipRosterIcon = true;
            if (this.updateBlockValue) {
                this.lBlock.getBlock().setDirection(dirB);
            }
        } else {
            this.flipRosterIcon = false;
            if (this.updateBlockValue) {
                this.lBlock.getBlock().setDirection(dirA);
            }
        }
        if (this.getMemory().getValue() == roster) {
            this.updateIconFromRosterVal(roster);
        } else {
            this.setValue(roster);
        }
    }
}

