/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.display.MultiSensorIcon;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.MultiIconEditor;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;

public class MultiSensorIconFrame
extends JmriJFrame {
    private final JPanel content = new JPanel();
    private JmriJFrame defaultsFrame;
    private MultiIconEditor defaultIcons;
    private LayoutEditor layoutEditor = null;
    private final JRadioButton updown = new JRadioButton(Bundle.getMessage("UpDown"));
    private final JRadioButton rightleft = new JRadioButton(Bundle.getMessage("RightLeft"));
    private final ButtonGroup group = new ButtonGroup();
    int isEmpty = 0;
    int _numberOfPositions = 3;

    MultiSensorIconFrame(LayoutEditor p) {
        super("Enter MultiSensor");
        this.layoutEditor = p;
        this.addHelpMenu("package.jmri.jmrit.display.MultiSensorIconFrame", true);
    }

    @Override
    public void initComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("IconChecksClickLabel")));
        this.group.add(this.updown);
        this.group.add(this.rightleft);
        this.rightleft.setSelected(true);
        p.add(this.rightleft);
        p.add(this.updown);
        this.getContentPane().add(p);
        this.getContentPane().add(this.content);
        this.content.setLayout(new BoxLayout(this.content, 1));
        this.content.add(new Entry(this.content, this, "resources/icons/USS/plate/levers/l-left.gif", 1));
        this.content.add(new Entry(this.content, this, "resources/icons/USS/plate/levers/l-vertical.gif", 2));
        this.content.add(new Entry(this.content, this, "resources/icons/USS/plate/levers/l-right.gif", 3));
        this.getContentPane().add(new JSeparator());
        JButton b = new JButton(Bundle.getMessage("ButtonAddAdditionalSensor"));
        ActionListener a = new ActionListener(){
            JPanel self;
            JmriJFrame frame;

            @Override
            public void actionPerformed(ActionEvent a) {
                ++MultiSensorIconFrame.this._numberOfPositions;
                this.self.add(new Entry(this.self, this.frame, "resources/icons/USSpanels/Plates/lever-v.gif", MultiSensorIconFrame.this._numberOfPositions));
                this.frame.pack();
            }

            ActionListener init(JPanel self, JmriJFrame frame) {
                this.frame = frame;
                this.self = self;
                return this;
            }
        }.init(this.content, this);
        b.addActionListener(a);
        this.getContentPane().add(b);
        this.getContentPane().add(new JSeparator());
        b = new JButton(Bundle.getMessage("SetStateIcons"));
        this.defaultIcons = new MultiIconEditor(3);
        this.defaultIcons.setIcon(0, Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanStateUnknown")), "resources/icons/USS/plate/levers/l-inactive.gif");
        this.defaultIcons.setIcon(1, Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanStateInconsistent")), "resources/icons/USS/plate/levers/l-unknown.gif");
        this.defaultIcons.setIcon(2, Bundle.getMessage("MakeLabel", Bundle.getMessage("SensorStateInactive")), "resources/icons/USS/plate/levers/l-inconsistent.gif");
        this.defaultIcons.complete();
        this.defaultsFrame = new JmriJFrame("", false, true);
        this.defaultsFrame.getContentPane().add((Component)new JLabel(Bundle.getMessage("IconChangeInfo")), "North");
        this.defaultsFrame.getContentPane().add(this.defaultIcons);
        this.defaultsFrame.pack();
        this.defaultsFrame.addHelpMenu("package.jmri.jmrit.display.MultiSensorIconDefaultsFrame", true);
        b.addActionListener(a12 -> this.defaultsFrame.setVisible(true));
        this.getContentPane().add(b);
        this.getContentPane().add(new JSeparator());
        b = new JButton(Bundle.getMessage("ButtonCreateIcon"));
        b.addActionListener(a1 -> {
            this.make();
            if (this.isEmpty != 1) {
                this.removeWindows();
            }
        });
        this.getContentPane().add(b);
    }

    void remove(Entry e) {
        this.content.remove(e);
        this.pack();
    }

    void make() {
        MultiSensorIcon m = new MultiSensorIcon(this.layoutEditor);
        m.setUnknownIcon(this.defaultIcons.getIcon(0));
        m.setInconsistentIcon(this.defaultIcons.getIcon(1));
        m.setInactiveIcon(this.defaultIcons.getIcon(2));
        for (int i = 0; i < this.content.getComponentCount(); ++i) {
            Entry e = (Entry)this.content.getComponent(i);
            if (e.sensor.getSelectedItem() == null) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("Error19", i + 1), Bundle.getMessage("WarningTitle"), 2);
                this.isEmpty = 1;
                return;
            }
            m.addEntry(e.sensor.getSelectedItemDisplayName(), e.ed.getIcon(0));
        }
        m.setUpDown(this.updown.isSelected());
        m.setDisplayLevel(10);
        this.layoutEditor.addMultiSensor(m);
    }

    void removeWindows() {
        for (int i = 0; i < this.content.getComponentCount(); ++i) {
            ((Entry)this.content.getComponent(i)).dispose();
        }
        this.defaultsFrame.dispose();
        super.dispose();
    }

    class Entry
    extends JPanel {
        NamedBeanComboBox<Sensor> sensor = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SensorManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
        JPanel self;
        MultiIconEditor ed = new MultiIconEditor(1);
        JmriJFrame edf = new JmriJFrame("", false, true);

        @Override
        public String toString() {
            return this.ed.getIcon(0).toString();
        }

        Entry(JPanel self, JmriJFrame frame, String name, int position) {
            this.self = self;
            this.setLayout(new FlowLayout());
            this.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameSensor") + " " + Bundle.getMessage("MultiSensorPosition", position))));
            this.add(this.sensor);
            JComboBoxUtil.setupComboBoxMaxRows(this.sensor);
            this.ed.setIcon(0, Bundle.getMessage("MakeLabel", Bundle.getMessage("SensorStateActive") + " " + Bundle.getMessage("MultiSensorPosition", position)), name);
            this.ed.complete();
            this.edf.getContentPane().add((Component)new JLabel(Bundle.getMessage("IconChangeInfo")), "North");
            this.edf.getContentPane().add(this.ed);
            this.edf.pack();
            JButton b = new JButton(Bundle.getMessage("SetIconButton"));
            b.addActionListener(a -> this.edf.setVisible(true));
            this.add(b);
            b = new JButton(Bundle.getMessage("ButtonDelete"));
            ActionListener a2 = new ActionListener(){
                Entry entry;
                JPanel self;
                JmriJFrame frame;

                @Override
                public void actionPerformed(ActionEvent a) {
                    this.self.remove(this.entry);
                    --MultiSensorIconFrame.this._numberOfPositions;
                    this.frame.pack();
                }

                ActionListener init(Entry entry, JPanel self, JmriJFrame frame) {
                    this.entry = entry;
                    this.self = self;
                    this.frame = frame;
                    return this;
                }
            }.init(this, self, frame);
            b.addActionListener(a2);
            this.add(b);
        }

        public void dispose() {
            this.edf.dispose();
        }
    }
}

