/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.TrackSegmentEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackDrawingOptions;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.LayoutBlockRouteTableAction;
import jmri.util.ColorUtil;
import jmri.util.MathUtil;
import jmri.util.QuickPromptUtil;
import jmri.util.swing.JmriColorChooser;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackSegmentView
extends LayoutTrackView {
    private boolean dashed = false;
    private boolean arc = false;
    private boolean circle = false;
    private boolean flip = false;
    private double angle = 0.0;
    private boolean changed = false;
    private boolean bezier = false;
    private final ArrayList<Point2D> bezierControlPoints = new ArrayList();
    private final TrackSegmentEditor editor;
    private final TrackSegment trackSegment;
    public String tConnect1Name = "";
    public String tConnect2Name = "";
    public String tLayoutBlockName = "";
    private JPopupMenu popupMenu = null;
    private final JCheckBoxMenuItem mainlineCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("MainlineCheckBoxMenuItemTitle"));
    private final JCheckBoxMenuItem hiddenCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("HiddenCheckBoxMenuItemTitle"));
    private final JCheckBoxMenuItem dashedCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("DashedCheckBoxMenuItemTitle"));
    private final JCheckBoxMenuItem flippedCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("FlippedCheckBoxMenuItemTitle"));
    public static final int MAX_BUMPER_LENGTH = 40;
    public static final int MIN_BUMPER_LENGTH = 8;
    public static final int MAX_BUMPER_WIDTH = 10;
    public static final int MIN_BUMPER_WIDTH = 1;
    private static final int MAX_ARROW_LINE_WIDTH = 5;
    private static final int MAX_ARROW_LENGTH = 60;
    private static final int MAX_ARROW_GAP = 40;
    private static final int MAX_BRIDGE_LINE_WIDTH = 5;
    private static final int MIN_BRIDGE_LINE_WIDTH = 1;
    private static final int MAX_BRIDGE_APPROACH_WIDTH = 100;
    private static final int MIN_BRIDGE_APPROACH_WIDTH = 8;
    private static final int MAX_BRIDGE_DECK_WIDTH = 80;
    private static final int MIN_BRIDGE_DECK_WIDTH = 6;
    private static final int MAX_BUMPER_LINE_WIDTH = 9;
    private static final int MIN_BUMPER_LINE_WIDTH = 1;
    private static final int MAX_TUNNEL_FLOOR_WIDTH = 40;
    private static final int MIN_TUNNEL_FLOOR_WIDTH = 4;
    private static final int MAX_TUNNEL_LINE_WIDTH = 9;
    private static final int MIN_TUNNEL_LINE_WIDTH = 1;
    private static final int MAX_TUNNEL_ENTRANCE_WIDTH = 80;
    private static final int MIN_TUNNEL_ENTRANCE_WIDTH = 1;
    private boolean active = true;
    public static final int SHOWCON = 1;
    public static final int HIDECON = 2;
    public static final int HIDECONALL = 4;
    public int showConstructionLine = 1;
    private Point2D pt1;
    private Point2D pt2;
    private double cX;
    private double cY;
    private double cW;
    private double cH;
    private double startAdj;
    private double centreX;
    private double centreY;
    private double tmpangle;
    private double chordLength;
    private int arrowStyle = 0;
    private boolean arrowEndStart = false;
    private boolean arrowEndStop = false;
    private boolean arrowDirIn = false;
    private boolean arrowDirOut = false;
    private Color arrowColor = Color.BLACK;
    private int arrowLineWidth = 4;
    private int arrowLength = 4;
    private int arrowGap = 1;
    private boolean bridgeSideRight = false;
    private boolean bridgeSideLeft = false;
    private boolean bridgeHasEntry = false;
    private boolean bridgeHasExit = false;
    private Color bridgeColor = Color.BLACK;
    private int bridgeDeckWidth = 10;
    private int bridgeLineWidth = 1;
    private int bridgeApproachWidth = 4;
    private boolean bumperEndStart = false;
    private boolean bumperEndStop = false;
    private Color bumperColor = Color.BLACK;
    private int bumperLineWidth = 3;
    private int bumperLength = 20;
    private boolean bumperFlipped = false;
    private boolean tunnelSideRight = false;
    private boolean tunnelSideLeft = false;
    private boolean tunnelHasEntry = false;
    private boolean tunnelHasExit = false;
    private Color tunnelColor = Color.BLACK;
    private int tunnelFloorWidth = 10;
    private int tunnelLineWidth = 1;
    private int tunnelEntranceWidth = 16;
    private static final Logger log = LoggerFactory.getLogger(TrackSegmentView.class);

    public TrackSegmentView(@Nonnull TrackSegment track, @Nonnull LayoutEditor layoutEditor) {
        super(track, layoutEditor);
        this.trackSegment = track;
        this.setupDefaultBumperSizes(layoutEditor);
        this.editor = new TrackSegmentEditor(layoutEditor);
    }

    public TrackSegmentView(@Nonnull TrackSegment track, @Nonnull LayoutEditor layoutEditor, boolean arc, boolean flip, boolean circle) {
        this(track, layoutEditor);
    }

    @Nonnull
    public TrackSegment getTrackSegment() {
        return this.trackSegment;
    }

    public String toString() {
        return "TrackSegmentView " + this.getName() + " c1:{" + this.getConnect1Name() + " (" + this.getType1() + ")}, c2:{" + this.getConnect2Name() + " (" + this.getType2() + ")}";
    }

    @Nonnull
    public String getBlockName() {
        return this.trackSegment.getBlockName();
    }

    public HitPointType getType1() {
        return this.trackSegment.getType1();
    }

    public HitPointType getType2() {
        return this.trackSegment.getType2();
    }

    public LayoutTrack getConnect1() {
        return this.trackSegment.getConnect1();
    }

    public LayoutTrack getConnect2() {
        return this.trackSegment.getConnect2();
    }

    protected void setNewConnect1(@CheckForNull LayoutTrack connectTrack, HitPointType connectionType) {
        this.trackSegment.setNewConnect1(connectTrack, connectionType);
    }

    protected void setNewConnect2(@CheckForNull LayoutTrack connectTrack, HitPointType connectionType) {
        this.trackSegment.setNewConnect2(connectTrack, connectionType);
    }

    public boolean replaceTrackConnection(@CheckForNull LayoutTrack oldTrack, @CheckForNull LayoutTrack newTrack, HitPointType newType) {
        return this.trackSegment.replaceTrackConnection(oldTrack, newTrack, newType);
    }

    public boolean isDashed() {
        return this.dashed;
    }

    public void setDashed(boolean dash) {
        if (this.dashed != dash) {
            this.dashed = dash;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isArc() {
        return this.arc;
    }

    public void setArc(boolean boo) {
        if (this.arc != boo) {
            this.arc = boo;
            if (this.arc) {
                this.circle = false;
                this.bezier = false;
                this.hideConstructionLines(1);
            }
            this.changed = true;
        }
    }

    public boolean isCircle() {
        return this.circle;
    }

    public void setCircle(boolean boo) {
        if (this.circle != boo) {
            this.circle = boo;
            if (this.circle) {
                if (this.bezier) {
                    if (this.getConnect1() != null && this.getConnect2() != null) {
                        double r2;
                        double r1;
                        Point2D op2;
                        Point2D end1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
                        Point2D end2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
                        double chordLength = MathUtil.distance(end1, end2);
                        int cnt = this.bezierControlPoints.size();
                        Point2D cp0 = this.bezierControlPoints.get(0);
                        Point2D cpN = this.bezierControlPoints.get(cnt - 1);
                        Point2D op1 = MathUtil.add(end1, MathUtil.orthogonal(MathUtil.subtract(cp0, end1)));
                        Point2D ip = MathUtil.intersect(end1, op1, end2, op2 = MathUtil.subtract(end2, MathUtil.orthogonal(MathUtil.subtract(cpN, end2))));
                        if (ip != null && Math.abs((r1 = MathUtil.distance(ip, end1)) - (r2 = MathUtil.distance(ip, end2))) <= 1.0) {
                            this.setAngle(Math.toDegrees(2.0 * Math.asin(chordLength / (2.0 * r1))));
                            double distance = MathUtil.distance(end1, end2, ip);
                            this.setFlip(distance < 0.0);
                        }
                    }
                    this.bezier = false;
                } else if (this.getAngle() < 1.0) {
                    this.setAngle(90.0);
                }
                this.arc = true;
                this.hideConstructionLines(1);
            }
            this.changed = true;
        }
    }

    public boolean isFlip() {
        return this.flip;
    }

    public void setFlip(boolean boo) {
        if (this.flip != boo) {
            this.flip = boo;
            this.changed = true;
            this.hideConstructionLines(1);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isBezier() {
        return this.bezier;
    }

    public void setBezier(boolean bool) {
        if (this.bezier != bool) {
            this.bezier = bool;
            if (this.bezier) {
                this.arc = false;
                this.circle = false;
                this.hideConstructionLines(1);
            }
            this.changed = true;
        }
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double x) {
        this.angle = MathUtil.pin(x, 0.0, 180.0);
        this.changed = true;
    }

    public double getDirectionRAD() {
        Point2D ep1 = this.getCoordsCenter();
        Point2D ep2 = this.getCoordsCenter();
        if (this.getConnect1() != null) {
            ep1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
        }
        if (this.getConnect2() != null) {
            ep2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
        }
        return 1.5707963267948966 - MathUtil.computeAngleRAD(ep1, ep2);
    }

    public double getDirectionDEG() {
        return Math.toDegrees(this.getDirectionRAD());
    }

    public boolean trackNeedsRedraw() {
        return this.changed;
    }

    public void trackRedrawn() {
        this.changed = false;
    }

    public LayoutBlock getLayoutBlock() {
        return this.trackSegment.getLayoutBlock();
    }

    public String getConnect1Name() {
        return this.trackSegment.getConnect1Name();
    }

    public String getConnect2Name() {
        return this.trackSegment.getConnect2Name();
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        return this.trackSegment.getConnection(connectionType);
    }

    @Override
    public void setConnection(HitPointType connectionType, @CheckForNull LayoutTrack o, HitPointType type) throws JmriException {
    }

    public int getNumberOfBezierControlPoints() {
        return this.bezierControlPoints.size();
    }

    public Point2D getBezierControlPoint(int index) {
        Point2D result = this.getCoordsCenter();
        if (index < 0) {
            index += this.bezierControlPoints.size();
        }
        if (index >= 0 && index < this.bezierControlPoints.size()) {
            result = this.bezierControlPoints.get(index);
        }
        return result;
    }

    public void setBezierControlPoint(@CheckForNull Point2D p, int index) {
        if (index < 0) {
            index += this.bezierControlPoints.size();
        }
        if (index >= 0 && index <= this.bezierControlPoints.size()) {
            if (index < this.bezierControlPoints.size()) {
                this.bezierControlPoints.set(index, p);
            } else {
                this.bezierControlPoints.add(p);
            }
        }
    }

    @Nonnull
    public ArrayList<Point2D> getBezierControlPoints() {
        return this.bezierControlPoints;
    }

    public void setLayoutBlock(@CheckForNull LayoutBlock newLayoutBlock) {
        this.trackSegment.setLayoutBlock(newLayoutBlock);
    }

    public void setLayoutBlockByName(@CheckForNull String name) {
        this.trackSegment.setLayoutBlockByName(name);
    }

    @Override
    public void scaleCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        super.setCoordsCenter(MathUtil.multiply(this.getCoordsCenter(), (Point2D)factor));
        if (this.isBezier()) {
            for (Point2D p : this.bezierControlPoints) {
                p.setLocation(MathUtil.multiply(p, (Point2D)factor));
            }
        }
    }

    @Override
    public void translateCoords(double xFactor, double yFactor) {
        super.setCoordsCenter(MathUtil.add(this.getCoordsCenter(), new Point2D.Double(xFactor, yFactor)));
    }

    @Override
    public void rotateCoords(double angleDEG) {
        if (this.isBezier()) {
            for (Point2D p : this.bezierControlPoints) {
                p.setLocation(MathUtil.rotateDEG(p, this.getCoordsCenter(), angleDEG));
            }
        }
    }

    @Override
    public void setCoordsCenter(@Nonnull Point2D newCenterPoint) {
        if (this.getCoordsCenter() != newCenterPoint) {
            if (this.isBezier()) {
                Point2D delta = MathUtil.subtract(newCenterPoint, this.getCoordsCenter());
                for (Point2D p : this.bezierControlPoints) {
                    p.setLocation(MathUtil.add(p, delta));
                }
            }
            super.setCoordsCenter(newCenterPoint);
        }
    }

    public void updateBlockInfo() {
        this.trackSegment.updateBlockInfo();
    }

    @Override
    protected HitPointType findHitPointType(Point2D hitPoint, boolean useRectangles, boolean requireUnconnected) {
        HitPointType result = HitPointType.NONE;
        if (!requireUnconnected) {
            double distance;
            Point2D p;
            Rectangle2D r = this.layoutEditor.layoutEditorControlCircleRectAt(hitPoint);
            Point2D minPoint = MathUtil.zeroPoint2D;
            double circleRadius = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
            double minDistance = Double.POSITIVE_INFINITY;
            if (this.isCircle()) {
                p = this.getCoordsCenterCircle();
                distance = MathUtil.distance(p, hitPoint);
                if (distance < minDistance) {
                    minDistance = distance;
                    minPoint = p;
                    result = HitPointType.TRACK_CIRCLE_CENTRE;
                }
            } else if (this.isBezier()) {
                for (int index = 0; index < this.bezierControlPoints.size(); ++index) {
                    p = this.bezierControlPoints.get(index);
                    distance = MathUtil.distance(p, hitPoint);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    minPoint = p;
                    result = HitPointType.bezierPointIndexedValue(index);
                }
            }
            if (r.contains(p = this.getCentreSeg()) && (distance = MathUtil.distance(p, hitPoint)) <= minDistance) {
                minDistance = distance;
                minPoint = p;
                result = HitPointType.TRACK;
            }
            if (result != HitPointType.NONE && (useRectangles ? !r.contains(minPoint) : minDistance > circleRadius)) {
                result = HitPointType.NONE;
            }
        }
        return result;
    }

    @Override
    public Point2D getCoordsForConnectionType(HitPointType connectionType) {
        Point2D result = this.getCentreSeg();
        if (connectionType == HitPointType.TRACK_CIRCLE_CENTRE) {
            result = this.getCoordsCenterCircle();
        } else if (HitPointType.isBezierHitType(connectionType)) {
            result = this.getBezierControlPoint(connectionType.bezierPointIndex());
        }
        return result;
    }

    @Override
    public Rectangle2D getBounds() {
        Point2D ep1 = this.getCoordsCenter();
        Point2D ep2 = this.getCoordsCenter();
        if (this.getConnect1() != null) {
            ep1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
        }
        if (this.getConnect2() != null) {
            ep2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
        }
        Rectangle2D.Double result = new Rectangle2D.Double(ep1.getX(), ep1.getY(), 0.0, 0.0);
        result.add(ep2);
        if (this.isArc()) {
            result.add(this.getCentreSeg());
            if (this.isCircle()) {
                result.add(this.getCoordsCenterCircle());
            }
        } else if (this.isBezier()) {
            for (int index = 0; index < this.bezierControlPoints.size(); ++index) {
                result.add(this.bezierControlPoints.get(index));
            }
        }
        result.add(this.getCoordsCenter());
        return result;
    }

    private void addNumericMenuItem(@Nonnull JMenu menu, @Nonnull String titleKey, @Nonnull String toolTipKey, @Nonnull Supplier<Integer> val, @Nonnull Consumer<Integer> set, @CheckForNull Predicate<Integer> predicate) {
        int oldVal = val.get();
        JMenuItem jmi = menu.add(new JMenuItem(Bundle.getMessage("MakeLabel", Bundle.getMessage(titleKey)) + oldVal));
        jmi.setToolTipText(Bundle.getMessage(toolTipKey));
        jmi.addActionListener(e3 -> {
            int newValue = QuickPromptUtil.promptForInteger(this.layoutEditor, Bundle.getMessage(titleKey), Bundle.getMessage(titleKey), (Integer)val.get(), predicate);
            set.accept(newValue);
            this.layoutEditor.repaint();
        });
    }

    @Override
    @Nonnull
    protected JPopupMenu showPopup(@Nonnull JmriMouseEvent mouseEvent) {
        PositionablePoint pp;
        PositionablePoint pp2;
        JCheckBoxMenuItem jcbmi;
        PositionablePoint pp3;
        PositionablePoint pp4;
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        } else {
            this.popupMenu = new JPopupMenu();
        }
        Object info = Bundle.getMessage("TrackSegment");
        info = this.isArc() ? (this.isCircle() ? (String)info + " (" + Bundle.getMessage("Circle") + ")" : (String)info + " (" + Bundle.getMessage("Ellipse") + ")") : (this.isBezier() ? (String)info + " (" + Bundle.getMessage("Bezier") + ")" : (String)info + " (" + Bundle.getMessage("Line") + ")");
        JMenuItem jmi = this.popupMenu.add(Bundle.getMessage("MakeLabel", info) + this.getName());
        jmi.setEnabled(false);
        jmi = this.getBlockName().isEmpty() ? this.popupMenu.add(Bundle.getMessage("NoBlock")) : this.popupMenu.add(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameBlock")) + this.getLayoutBlock().getDisplayName());
        jmi.setEnabled(false);
        if (this.getConnect1() != null || this.getConnect2() != null) {
            JMenu connectionsMenu = new JMenu(Bundle.getMessage("Connections"));
            if (this.getConnect1() != null) {
                connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "1") + this.getConnect1().getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutEditorFindItems lf = TrackSegmentView.this.layoutEditor.getFinder();
                        LayoutTrack lt = lf.findObjectByName(TrackSegmentView.this.getConnect1().getName());
                        if (lt != null) {
                            LayoutTrackView ltv = TrackSegmentView.this.layoutEditor.getLayoutTrackView(lt);
                            TrackSegmentView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                            ltv.showPopup();
                        }
                    }
                });
            }
            if (this.getConnect2() != null) {
                connectionsMenu.add(new AbstractAction(Bundle.getMessage("MakeLabel", "2") + this.getConnect2().getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutEditorFindItems lf = TrackSegmentView.this.layoutEditor.getFinder();
                        LayoutTrack lt = lf.findObjectByName(TrackSegmentView.this.getConnect2().getName());
                        if (lt != null) {
                            LayoutTrackView ltv = TrackSegmentView.this.layoutEditor.getLayoutTrackView(lt);
                            TrackSegmentView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                            ltv.showPopup();
                        }
                    }
                });
            }
            this.popupMenu.add(connectionsMenu);
        }
        this.popupMenu.add(new JSeparator(0));
        this.popupMenu.add(this.mainlineCheckBoxMenuItem);
        this.mainlineCheckBoxMenuItem.addActionListener(e3 -> this.trackSegment.setMainline(this.mainlineCheckBoxMenuItem.isSelected()));
        this.mainlineCheckBoxMenuItem.setToolTipText(Bundle.getMessage("MainlineCheckBoxMenuItemToolTip"));
        this.mainlineCheckBoxMenuItem.setSelected(this.trackSegment.isMainline());
        this.popupMenu.add(this.hiddenCheckBoxMenuItem);
        this.hiddenCheckBoxMenuItem.addActionListener(e3 -> this.setHidden(this.hiddenCheckBoxMenuItem.isSelected()));
        this.hiddenCheckBoxMenuItem.setToolTipText(Bundle.getMessage("HiddenCheckBoxMenuItemToolTip"));
        this.hiddenCheckBoxMenuItem.setSelected(this.isHidden());
        this.popupMenu.add(this.dashedCheckBoxMenuItem);
        this.dashedCheckBoxMenuItem.addActionListener(e3 -> this.setDashed(this.dashedCheckBoxMenuItem.isSelected()));
        this.dashedCheckBoxMenuItem.setToolTipText(Bundle.getMessage("DashedCheckBoxMenuItemToolTip"));
        this.dashedCheckBoxMenuItem.setSelected(this.dashed);
        if (this.isArc()) {
            this.popupMenu.add(this.flippedCheckBoxMenuItem);
            this.flippedCheckBoxMenuItem.addActionListener(e3 -> this.setFlip(this.flippedCheckBoxMenuItem.isSelected()));
            this.flippedCheckBoxMenuItem.setToolTipText(Bundle.getMessage("FlippedCheckBoxMenuItemToolTip"));
            this.flippedCheckBoxMenuItem.setSelected(this.isFlip());
        }
        JMenu decorationsMenu = new JMenu(Bundle.getMessage("DecorationMenuTitle"));
        decorationsMenu.setToolTipText(Bundle.getMessage("DecorationMenuToolTip"));
        boolean hasEC1 = false;
        if (this.getType1() == HitPointType.POS_POINT && (pp4 = (PositionablePoint)this.getConnect1()).getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            hasEC1 = true;
        }
        boolean hasEC2 = false;
        if (this.getType2() == HitPointType.POS_POINT && (pp3 = (PositionablePoint)this.getConnect2()).getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            hasEC2 = true;
        }
        if (hasEC1 || hasEC2) {
            JMenu arrowsMenu = new JMenu(Bundle.getMessage("ArrowsMenuTitle"));
            decorationsMenu.setToolTipText(Bundle.getMessage("ArrowsMenuToolTip"));
            decorationsMenu.add(arrowsMenu);
            JMenu arrowsCountMenu = new JMenu(Bundle.getMessage("DecorationStyleMenuTitle"));
            arrowsCountMenu.setToolTipText(Bundle.getMessage("DecorationStyleMenuToolTip"));
            arrowsMenu.add(arrowsCountMenu);
            jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
            arrowsCountMenu.add(jcbmi);
            jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
            jcbmi.addActionListener(e3 -> {
                this.setArrowEndStart(false);
                this.setArrowEndStop(false);
            });
            jcbmi.setSelected(this.arrowStyle == 0);
            for (int i = 1; i < 6; ++i) {
                jcbmi = this.loadArrowImageToJCBItem(i, arrowsCountMenu);
                int n = i;
                jcbmi.addActionListener(e3 -> {
                    this.setArrowEndStart(this.getType1() == HitPointType.POS_POINT && ((PositionablePoint)this.getConnect1()).getType() == PositionablePoint.PointType.EDGE_CONNECTOR);
                    this.setArrowEndStop(this.getType2() == HitPointType.POS_POINT && ((PositionablePoint)this.getConnect2()).getType() == PositionablePoint.PointType.EDGE_CONNECTOR);
                    this.setArrowStyle(n);
                });
                jcbmi.setSelected(this.arrowStyle == i);
            }
            if (hasEC1 && hasEC2) {
                JMenu arrowsEndMenu = new JMenu(Bundle.getMessage("DecorationEndMenuTitle"));
                arrowsEndMenu.setToolTipText(Bundle.getMessage("DecorationEndMenuToolTip"));
                arrowsMenu.add(arrowsEndMenu);
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
                arrowsEndMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    this.setArrowEndStart(false);
                    this.setArrowEndStop(false);
                });
                jcbmi.setSelected(!this.arrowEndStart && !this.arrowEndStop);
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationStartMenuItemTitle"));
                arrowsEndMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationStartMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    this.setArrowEndStart(true);
                    this.setArrowEndStop(false);
                });
                jcbmi.setSelected(this.arrowEndStart && !this.arrowEndStop);
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationEndMenuItemTitle"));
                arrowsEndMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationEndMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    this.setArrowEndStop(true);
                    this.setArrowEndStart(false);
                });
                jcbmi.setSelected(!this.arrowEndStart && this.arrowEndStop);
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationBothMenuItemTitle"));
                arrowsEndMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationBothMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    this.setArrowEndStart(true);
                    this.setArrowEndStop(true);
                });
                jcbmi.setSelected(this.arrowEndStart && this.arrowEndStop);
            }
            JMenu arrowsDirMenu = new JMenu(Bundle.getMessage("ArrowsDirectionMenuTitle"));
            arrowsDirMenu.setToolTipText(Bundle.getMessage("ArrowsDirectionMenuToolTip"));
            arrowsMenu.add(arrowsDirMenu);
            jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
            arrowsDirMenu.add(jcbmi);
            jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
            jcbmi.addActionListener(e3 -> {
                this.setArrowDirIn(false);
                this.setArrowDirOut(false);
            });
            jcbmi.setSelected(!this.arrowDirIn && !this.arrowDirOut);
            jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("ArrowsDirectionInMenuItemTitle"));
            arrowsDirMenu.add(jcbmi);
            jcbmi.setToolTipText(Bundle.getMessage("ArrowsDirectionInMenuItemToolTip"));
            jcbmi.addActionListener(e3 -> {
                this.setArrowDirIn(true);
                this.setArrowDirOut(false);
            });
            jcbmi.setSelected(this.arrowDirIn && !this.arrowDirOut);
            jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("ArrowsDirectionOutMenuItemTitle"));
            arrowsDirMenu.add(jcbmi);
            jcbmi.setToolTipText(Bundle.getMessage("ArrowsDirectionOutMenuItemToolTip"));
            jcbmi.addActionListener(e3 -> {
                this.setArrowDirOut(true);
                this.setArrowDirIn(false);
            });
            jcbmi.setSelected(!this.arrowDirIn && this.arrowDirOut);
            jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("ArrowsDirectionBothMenuItemTitle"));
            arrowsDirMenu.add(jcbmi);
            jcbmi.setToolTipText(Bundle.getMessage("ArrowsDirectionBothMenuItemToolTip"));
            jcbmi.addActionListener(e3 -> {
                this.setArrowDirIn(true);
                this.setArrowDirOut(true);
            });
            jcbmi.setSelected(this.arrowDirIn && this.arrowDirOut);
            jmi = arrowsMenu.add(new JMenuItem(Bundle.getMessage("DecorationColorMenuItemTitle")));
            jmi.setToolTipText(Bundle.getMessage("DecorationColorMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                Color newColor = JmriColorChooser.showDialog(null, "Choose a color", this.arrowColor);
                if (newColor != null && !newColor.equals(this.arrowColor)) {
                    this.setArrowColor(newColor);
                }
            });
            jmi.setForeground(this.arrowColor);
            jmi.setBackground(ColorUtil.contrast(this.arrowColor));
            jmi = arrowsMenu.add(new JMenuItem(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationLineWidthMenuItemTitle")) + this.arrowLineWidth));
            jmi.setToolTipText(Bundle.getMessage("DecorationLineWidthMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                int newValue = QuickPromptUtil.promptForInt(this.layoutEditor, Bundle.getMessage("DecorationLineWidthMenuItemTitle"), Bundle.getMessage("DecorationLineWidthMenuItemTitle"), this.arrowLineWidth);
                this.setArrowLineWidth(newValue);
            });
            jmi = arrowsMenu.add(new JMenuItem(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationLengthMenuItemTitle")) + this.arrowLength));
            jmi.setToolTipText(Bundle.getMessage("DecorationLengthMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                int newValue = QuickPromptUtil.promptForInt(this.layoutEditor, Bundle.getMessage("DecorationLengthMenuItemTitle"), Bundle.getMessage("DecorationLengthMenuItemTitle"), this.arrowLength);
                this.setArrowLength(newValue);
            });
            jmi = arrowsMenu.add(new JMenuItem(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationGapMenuItemTitle")) + this.arrowGap));
            jmi.setToolTipText(Bundle.getMessage("DecorationGapMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                int newValue = QuickPromptUtil.promptForInt(this.layoutEditor, Bundle.getMessage("DecorationGapMenuItemTitle"), Bundle.getMessage("DecorationGapMenuItemTitle"), this.arrowGap);
                this.setArrowGap(newValue);
            });
        }
        JMenu bridgeMenu = new JMenu(Bundle.getMessage("BridgeMenuTitle"));
        decorationsMenu.setToolTipText(Bundle.getMessage("BridgeMenuToolTip"));
        decorationsMenu.add(bridgeMenu);
        JMenu bridgeSideMenu = new JMenu(Bundle.getMessage("DecorationSideMenuTitle"));
        bridgeSideMenu.setToolTipText(Bundle.getMessage("DecorationSideMenuToolTip"));
        bridgeMenu.add(bridgeSideMenu);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
        bridgeSideMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setBridgeSideLeft(false);
            this.setBridgeSideRight(false);
        });
        jcbmi.setSelected(!this.bridgeSideLeft && !this.bridgeSideRight);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationSideLeftMenuItemTitle"));
        bridgeSideMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationSideLeftMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setBridgeSideLeft(true);
            this.setBridgeSideRight(false);
        });
        jcbmi.setSelected(this.bridgeSideLeft && !this.bridgeSideRight);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationSideRightMenuItemTitle"));
        bridgeSideMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationSideRightMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setBridgeSideRight(true);
            this.setBridgeSideLeft(false);
        });
        jcbmi.setSelected(!this.bridgeSideLeft && this.bridgeSideRight);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationBothMenuItemTitle"));
        bridgeSideMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationBothMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setBridgeSideLeft(true);
            this.setBridgeSideRight(true);
        });
        jcbmi.setSelected(this.bridgeSideLeft && this.bridgeSideRight);
        JMenu bridgeEndMenu = new JMenu(Bundle.getMessage("DecorationEndMenuTitle"));
        bridgeEndMenu.setToolTipText(Bundle.getMessage("DecorationEndMenuToolTip"));
        bridgeMenu.add(bridgeEndMenu);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
        bridgeEndMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setBridgeHasEntry(false);
            this.setBridgeHasExit(false);
        });
        jcbmi.setSelected(!this.bridgeHasEntry && !this.bridgeHasExit);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationEntryMenuItemTitle"));
        bridgeEndMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationEntryMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setBridgeHasEntry(true);
            this.setBridgeHasExit(false);
        });
        jcbmi.setSelected(this.bridgeHasEntry && !this.bridgeHasExit);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationExitMenuItemTitle"));
        bridgeEndMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationExitMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setBridgeHasExit(true);
            this.setBridgeHasEntry(false);
        });
        jcbmi.setSelected(!this.bridgeHasEntry && this.bridgeHasExit);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationBothMenuItemTitle"));
        bridgeEndMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationBothMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setBridgeHasEntry(true);
            this.setBridgeHasExit(true);
        });
        jcbmi.setSelected(this.bridgeHasEntry && this.bridgeHasExit);
        jmi = bridgeMenu.add(new JMenuItem(Bundle.getMessage("DecorationColorMenuItemTitle")));
        jmi.setToolTipText(Bundle.getMessage("DecorationColorMenuItemToolTip"));
        jmi.addActionListener(e3 -> {
            Color newColor = JmriColorChooser.showDialog(null, "Choose a color", this.bridgeColor);
            if (newColor != null && !newColor.equals(this.bridgeColor)) {
                this.setBridgeColor(newColor);
            }
        });
        jmi.setForeground(this.bridgeColor);
        jmi.setBackground(ColorUtil.contrast(this.bridgeColor));
        this.addNumericMenuItem(bridgeMenu, "DecorationLineWidthMenuItemTitle", "DecorationLineWidthMenuItemToolTip", this::getBridgeLineWidth, this::setBridgeLineWidth, QuickPromptUtil.checkIntRange(1, 5, null));
        this.addNumericMenuItem(bridgeMenu, "BridgeApproachWidthMenuItemTitle", "BridgeApproachWidthMenuItemToolTip", this::getBridgeApproachWidth, this::setBridgeApproachWidth, QuickPromptUtil.checkIntRange(4, 100, null));
        this.addNumericMenuItem(bridgeMenu, "BridgeDeckWidthMenuItemTitle", "BridgeDeckWidthMenuItemToolTip", this::getBridgeDeckWidth, this::setBridgeDeckWidth, QuickPromptUtil.checkIntRange(1, 80, null));
        boolean hasEB1 = false;
        if (this.getType1() == HitPointType.POS_POINT && (pp2 = (PositionablePoint)this.getConnect1()).getType() == PositionablePoint.PointType.END_BUMPER) {
            hasEB1 = true;
        }
        boolean hasEB2 = false;
        if (this.getType2() == HitPointType.POS_POINT && (pp = (PositionablePoint)this.getConnect2()).getType() == PositionablePoint.PointType.END_BUMPER) {
            hasEB2 = true;
        }
        if (hasEB1 || hasEB2) {
            JMenu endBumperMenu = new JMenu(Bundle.getMessage("EndBumperMenuTitle"));
            decorationsMenu.setToolTipText(Bundle.getMessage("EndBumperMenuToolTip"));
            decorationsMenu.add(endBumperMenu);
            if (hasEB1 && hasEB2) {
                JMenu endBumperEndMenu = new JMenu(Bundle.getMessage("DecorationEndMenuTitle"));
                endBumperEndMenu.setToolTipText(Bundle.getMessage("DecorationEndMenuToolTip"));
                endBumperMenu.add(endBumperEndMenu);
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
                endBumperEndMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    this.setBumperEndStart(false);
                    this.setBumperEndStop(false);
                });
                jcbmi.setSelected(!this.bumperEndStart && !this.bumperEndStop);
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationStartMenuItemTitle"));
                endBumperEndMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationStartMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    this.setBumperEndStart(true);
                    this.setBumperEndStop(false);
                });
                jcbmi.setSelected(this.bumperEndStart && !this.bumperEndStop);
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationEndMenuItemTitle"));
                endBumperEndMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationEndMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    this.setBumperEndStart(false);
                    this.setBumperEndStop(true);
                });
                jcbmi.setSelected(!this.bumperEndStart && this.bumperEndStop);
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationBothMenuItemTitle"));
                endBumperEndMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationEndMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    this.setBumperEndStart(true);
                    this.setBumperEndStop(true);
                });
                jcbmi.setSelected(this.bumperEndStart && this.bumperEndStop);
            } else {
                JCheckBoxMenuItem enableCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("EndBumperEnableMenuItemTitle"));
                enableCheckBoxMenuItem.setToolTipText(Bundle.getMessage("EndBumperEnableMenuItemToolTip"));
                endBumperMenu.add(enableCheckBoxMenuItem);
                enableCheckBoxMenuItem.addActionListener(e3 -> {
                    if (this.getType1() == HitPointType.POS_POINT && ((PositionablePoint)this.getConnect1()).getType() == PositionablePoint.PointType.END_BUMPER) {
                        this.setBumperEndStart(enableCheckBoxMenuItem.isSelected());
                    }
                    if (this.getType2() == HitPointType.POS_POINT && ((PositionablePoint)this.getConnect2()).getType() == PositionablePoint.PointType.END_BUMPER) {
                        this.setBumperEndStop(enableCheckBoxMenuItem.isSelected());
                    }
                });
                enableCheckBoxMenuItem.setSelected(this.bumperEndStart || this.bumperEndStop);
            }
            jmi = endBumperMenu.add(new JMenuItem(Bundle.getMessage("DecorationColorMenuItemTitle")));
            jmi.setToolTipText(Bundle.getMessage("DecorationColorMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                Color newColor = JmriColorChooser.showDialog(null, "Choose a color", this.bumperColor);
                if (newColor != null && !newColor.equals(this.bumperColor)) {
                    this.setBumperColor(newColor);
                }
            });
            jmi.setForeground(this.bumperColor);
            jmi.setBackground(ColorUtil.contrast(this.bumperColor));
            jmi = endBumperMenu.add(new JMenuItem(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationLineWidthMenuItemTitle")) + this.bumperLineWidth));
            jmi.setToolTipText(Bundle.getMessage("DecorationLineWidthMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                int newValue = QuickPromptUtil.promptForInteger(this.layoutEditor, Bundle.getMessage("DecorationLineWidthMenuItemTitle"), Bundle.getMessage("DecorationLineWidthMenuItemTitle"), this.getBumperLineWidth(), t -> {
                    if (t < 0 || t > 10) {
                        throw new IllegalArgumentException(Bundle.getMessage("DecorationLengthMenuItemRange", 10));
                    }
                    return true;
                });
                this.setBumperLineWidth(newValue);
            });
            jmi = endBumperMenu.add(new JMenuItem(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationLengthMenuItemTitle")) + this.bumperLength));
            jmi.setToolTipText(Bundle.getMessage("DecorationLengthMenuItemToolTip"));
            jmi.addActionListener(e3 -> {
                int newValue = QuickPromptUtil.promptForInteger(this.layoutEditor, Bundle.getMessage("DecorationLengthMenuItemTitle"), Bundle.getMessage("DecorationLengthMenuItemTitle"), this.bumperLength, t -> {
                    if (t < 0 || t > 40) {
                        throw new IllegalArgumentException(Bundle.getMessage("DecorationLengthMenuItemRange", 40));
                    }
                    return true;
                });
                this.setBumperLength(newValue);
            });
        }
        JMenu tunnelMenu = new JMenu(Bundle.getMessage("TunnelMenuTitle"));
        decorationsMenu.setToolTipText(Bundle.getMessage("TunnelMenuToolTip"));
        decorationsMenu.add(tunnelMenu);
        JMenu tunnelSideMenu = new JMenu(Bundle.getMessage("DecorationSideMenuTitle"));
        tunnelSideMenu.setToolTipText(Bundle.getMessage("DecorationSideMenuToolTip"));
        tunnelMenu.add(tunnelSideMenu);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
        tunnelSideMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setTunnelSideLeft(false);
            this.setTunnelSideRight(false);
        });
        jcbmi.setSelected(!this.tunnelSideLeft && !this.tunnelSideRight);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationSideLeftMenuItemTitle"));
        tunnelSideMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationSideLeftMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setTunnelSideLeft(true);
            this.setTunnelSideRight(false);
        });
        jcbmi.setSelected(this.tunnelSideLeft && !this.tunnelSideRight);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationSideRightMenuItemTitle"));
        tunnelSideMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationSideRightMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setTunnelSideRight(true);
            this.setTunnelSideLeft(false);
        });
        jcbmi.setSelected(!this.tunnelSideLeft && this.tunnelSideRight);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationBothMenuItemTitle"));
        tunnelSideMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationBothMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setTunnelSideLeft(true);
            this.setTunnelSideRight(true);
        });
        jcbmi.setSelected(this.tunnelSideLeft && this.tunnelSideRight);
        JMenu tunnelEndMenu = new JMenu(Bundle.getMessage("DecorationEndMenuTitle"));
        tunnelEndMenu.setToolTipText(Bundle.getMessage("DecorationEndMenuToolTip"));
        tunnelMenu.add(tunnelEndMenu);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
        tunnelEndMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setTunnelHasEntry(false);
            this.setTunnelHasExit(false);
        });
        jcbmi.setSelected(!this.tunnelHasEntry && !this.tunnelHasExit);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationEntryMenuItemTitle"));
        tunnelEndMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationEntryMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setTunnelHasEntry(true);
            this.setTunnelHasExit(false);
        });
        jcbmi.setSelected(this.tunnelHasEntry && !this.tunnelHasExit);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationExitMenuItemTitle"));
        tunnelEndMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationExitMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setTunnelHasExit(true);
            this.setTunnelHasEntry(false);
        });
        jcbmi.setSelected(!this.tunnelHasEntry && this.tunnelHasExit);
        jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationBothMenuItemTitle"));
        tunnelEndMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationBothMenuItemToolTip"));
        jcbmi.addActionListener(e3 -> {
            this.setTunnelHasEntry(true);
            this.setTunnelHasExit(true);
        });
        jcbmi.setSelected(this.tunnelHasEntry && this.tunnelHasExit);
        jmi = tunnelMenu.add(new JMenuItem(Bundle.getMessage("DecorationColorMenuItemTitle")));
        jmi.setToolTipText(Bundle.getMessage("DecorationColorMenuItemToolTip"));
        jmi.addActionListener(e3 -> {
            Color newColor = JmriColorChooser.showDialog(null, "Choose a color", this.tunnelColor);
            if (newColor != null && !newColor.equals(this.tunnelColor)) {
                this.setTunnelColor(newColor);
            }
        });
        jmi.setForeground(this.tunnelColor);
        jmi.setBackground(ColorUtil.contrast(this.tunnelColor));
        this.addNumericMenuItem(tunnelMenu, "TunnelFloorWidthMenuItemTitle", "TunnelFloorWidthMenuItemToolTip", this::getTunnelFloorWidth, this::setTunnelFloorWidth, QuickPromptUtil.checkIntRange(1, 40, null));
        this.addNumericMenuItem(tunnelMenu, "DecorationLineWidthMenuItemTitle", "DecorationLineWidthMenuItemToolTip", this::getTunnelLineWidth, this::setTunnelLineWidth, QuickPromptUtil.checkIntRange(1, 9, null));
        this.addNumericMenuItem(tunnelMenu, "TunnelEntranceWidthMenuItemTitle", "TunnelEntranceWidthMenuItemToolTip", this::getTunnelEntranceWidth, this::setTunnelEntranceWidth, QuickPromptUtil.checkIntRange(1, 80, null));
        this.popupMenu.add(decorationsMenu);
        this.popupMenu.add(new JSeparator(0));
        this.popupMenu.add(new AbstractAction(Bundle.getMessage("ButtonEdit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSegmentView.this.editor.editLayoutTrack(TrackSegmentView.this);
            }
        });
        this.popupMenu.add(new AbstractAction(Bundle.getMessage("ButtonDelete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrackSegmentView.this.canRemove() && TrackSegmentView.this.removeInlineLogixNG()) {
                    TrackSegmentView.this.layoutEditor.removeTrackSegment(TrackSegmentView.this.trackSegment);
                    TrackSegmentView.this.remove();
                    TrackSegmentView.this.dispose();
                }
            }
        });
        this.popupMenu.add(new AbstractAction(Bundle.getMessage("SplitTrackSegment")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSegmentView.this.splitTrackSegment();
            }
        });
        JMenu lineType = new JMenu(Bundle.getMessage("ChangeTo"));
        jmi = lineType.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("Line")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSegmentView.this.changeType(0);
            }
        }));
        jmi.setSelected(!this.isArc() && !this.isBezier());
        jmi = lineType.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("Circle")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSegmentView.this.changeType(1);
            }
        }));
        jmi.setSelected(this.isArc() && this.isCircle());
        jmi = lineType.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("Ellipse")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSegmentView.this.changeType(2);
            }
        }));
        jmi.setSelected(this.isArc() && !this.isCircle());
        jmi = lineType.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("Bezier")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSegmentView.this.changeType(3);
            }
        }));
        jmi.setSelected(!this.isArc() && this.isBezier());
        this.popupMenu.add(lineType);
        if (this.isArc() || this.isBezier()) {
            if (this.hideConstructionLines()) {
                this.popupMenu.add(new AbstractAction(Bundle.getMessage("ShowConstruct")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackSegmentView.this.hideConstructionLines(1);
                    }
                });
            } else {
                this.popupMenu.add(new AbstractAction(Bundle.getMessage("HideConstruct")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackSegmentView.this.hideConstructionLines(2);
                    }
                });
            }
        }
        if (!this.getBlockName().isEmpty() && InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            this.popupMenu.add(new AbstractAction(Bundle.getMessage("ViewBlockRouting")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutBlockRouteTableAction routeTableAction = new LayoutBlockRouteTableAction("ViewRouting", TrackSegmentView.this.getLayoutBlock());
                    routeTableAction.actionPerformed(e);
                }
            });
        }
        this.addCommonPopupItems(mouseEvent, this.popupMenu);
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        return this.popupMenu;
    }

    @Override
    public boolean canRemove() {
        ArrayList<String> itemList = new ArrayList<String>();
        HitPointType type1Temp = this.getType1();
        LayoutTrack conn1Temp = this.getConnect1();
        itemList.addAll(this.getPointReferences(type1Temp, conn1Temp));
        HitPointType type2Temp = this.getType2();
        LayoutTrack conn2Temp = this.getConnect2();
        itemList.addAll(this.getPointReferences(type2Temp, conn2Temp));
        if (!itemList.isEmpty()) {
            this.displayRemoveWarningDialog(itemList, "TrackSegment");
        }
        return itemList.isEmpty();
    }

    public ArrayList<String> getPointReferences(HitPointType type, LayoutTrack conn) {
        ArrayList<String> result = new ArrayList<String>();
        if (type == HitPointType.POS_POINT && conn instanceof PositionablePoint) {
            PositionablePoint pt = (PositionablePoint)conn;
            if (!pt.getEastBoundSignal().isEmpty()) {
                result.add(pt.getEastBoundSignal());
            }
            if (!pt.getWestBoundSignal().isEmpty()) {
                result.add(pt.getWestBoundSignal());
            }
            if (!pt.getEastBoundSignalMastName().isEmpty()) {
                result.add(pt.getEastBoundSignalMastName());
            }
            if (!pt.getWestBoundSignalMastName().isEmpty()) {
                result.add(pt.getWestBoundSignalMastName());
            }
            if (!pt.getEastBoundSensorName().isEmpty()) {
                result.add(pt.getEastBoundSensorName());
            }
            if (!pt.getWestBoundSensorName().isEmpty()) {
                result.add(pt.getWestBoundSensorName());
            }
            if (pt.getType() == PositionablePoint.PointType.EDGE_CONNECTOR && pt.getLinkedPoint() != null) {
                result.add(Bundle.getMessage("DeleteECisActive"));
            }
        }
        if (HitPointType.isTurnoutHitType(type) && conn instanceof LayoutTurnout) {
            LayoutTurnout lt = (LayoutTurnout)conn;
            switch (type) {
                case TURNOUT_A: {
                    result = lt.getBeanReferences("A");
                    break;
                }
                case TURNOUT_B: {
                    result = lt.getBeanReferences("B");
                    break;
                }
                case TURNOUT_C: {
                    result = lt.getBeanReferences("C");
                    break;
                }
                case TURNOUT_D: {
                    result = lt.getBeanReferences("D");
                    break;
                }
                default: {
                    log.error("Unexpected HitPointType: {}", (Object)type);
                }
            }
        }
        if (HitPointType.isLevelXingHitType(type) && conn instanceof LevelXing) {
            LevelXing lx = (LevelXing)conn;
            switch (type) {
                case LEVEL_XING_A: {
                    result = lx.getBeanReferences("A");
                    break;
                }
                case LEVEL_XING_B: {
                    result = lx.getBeanReferences("B");
                    break;
                }
                case LEVEL_XING_C: {
                    result = lx.getBeanReferences("C");
                    break;
                }
                case LEVEL_XING_D: {
                    result = lx.getBeanReferences("D");
                    break;
                }
                default: {
                    log.error("Unexpected HitPointType: {}", (Object)type);
                }
            }
        }
        if (HitPointType.isSlipHitType(type) && conn instanceof LayoutSlip) {
            LayoutSlip ls = (LayoutSlip)conn;
            switch (type) {
                case SLIP_A: {
                    result = ls.getBeanReferences("A");
                    break;
                }
                case SLIP_B: {
                    result = ls.getBeanReferences("B");
                    break;
                }
                case SLIP_C: {
                    result = ls.getBeanReferences("C");
                    break;
                }
                case SLIP_D: {
                    result = ls.getBeanReferences("D");
                    break;
                }
                default: {
                    log.error("Unexpected HitPointType: {}", (Object)type);
                }
            }
        }
        return result;
    }

    public void splitTrackSegment() {
        Point2D p = this.getCentreSeg();
        PositionablePoint newAnchor = this.layoutEditor.addAnchor(p);
        this.layoutEditor.setLink(newAnchor, HitPointType.POS_POINT, this.trackSegment, HitPointType.TRACK);
        String name = this.layoutEditor.getFinder().uniqueName("T", 1);
        TrackSegment newTrackSegment = new TrackSegment(name, newAnchor, HitPointType.POS_POINT, this.getConnect2(), this.getType2(), this.trackSegment.isMainline(), this.layoutEditor);
        TrackSegmentView ntsv = new TrackSegmentView(newTrackSegment, this.layoutEditor);
        this.layoutEditor.addLayoutTrack(newTrackSegment, ntsv);
        this.layoutEditor.setDirty();
        newTrackSegment.setLayoutBlock(this.getLayoutBlock());
        ntsv.setArc(this.isArc());
        ntsv.setCircle(this.isCircle());
        ntsv.setAngle(this.getAngle() / 2.0);
        this.setAngle(this.getAngle() / 2.0);
        ntsv.setFlip(this.isFlip());
        ntsv.setDashed(this.isDashed());
        HashMap<String, String> d = new HashMap<String, String>();
        this.getDecorations().forEach((k, v) -> {
            if (k.equals("arrow")) {
                if (this.isArrowEndStop()) {
                    d.put((String)k, (String)v);
                    this.setArrowEndStop(false);
                }
            } else if (k.equals("bumper")) {
                if (this.isBumperEndStop()) {
                    d.put((String)k, (String)v);
                    this.setBumperEndStop(false);
                }
            } else {
                d.put((String)k, (String)v);
            }
        });
        ntsv.setDecorations(d);
        if (this.getConnect2() instanceof PositionablePoint) {
            PositionablePoint pp = (PositionablePoint)this.getConnect2();
            pp.replaceTrackConnection(this.trackSegment, newTrackSegment);
        } else {
            this.layoutEditor.setLink(this.getConnect2(), this.getType2(), newTrackSegment, HitPointType.TRACK);
        }
        this.layoutEditor.setLink(newAnchor, HitPointType.POS_POINT, newTrackSegment, HitPointType.TRACK);
        this.trackSegment.setConnect2(newAnchor, HitPointType.POS_POINT);
        LayoutBlock b = this.getLayoutBlock();
        if (b != null) {
            newTrackSegment.setLayoutBlock(b);
            this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
            newTrackSegment.updateBlockInfo();
        }
        this.layoutEditor.setDirty();
        this.layoutEditor.redrawPanel();
    }

    protected void showBezierPopUp(JmriMouseEvent e, HitPointType hitPointType) {
        final int bezierControlPointIndex = hitPointType.bezierPointIndex();
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        } else {
            this.popupMenu = new JPopupMenu();
        }
        JMenuItem jmi = this.popupMenu.add(Bundle.getMessage("BezierControlPoint") + " #" + bezierControlPointIndex);
        jmi.setEnabled(false);
        this.popupMenu.add(new JSeparator(0));
        if (this.bezierControlPoints.size() <= 9) {
            this.popupMenu.add(new AbstractAction(Bundle.getMessage("AddBezierControlPointAfter")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSegmentView.this.addBezierControlPointAfter(bezierControlPointIndex);
                }
            });
            this.popupMenu.add(new AbstractAction(Bundle.getMessage("AddBezierControlPointBefore")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSegmentView.this.addBezierControlPointBefore(bezierControlPointIndex);
                }
            });
        }
        if (this.bezierControlPoints.size() > 2) {
            this.popupMenu.add(new AbstractAction(Bundle.getMessage("DeleteBezierControlPoint") + " #" + bezierControlPointIndex){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSegmentView.this.deleteBezierControlPoint(bezierControlPointIndex);
                }
            });
        }
        this.addCommonPopupItems(e, this.popupMenu);
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void addBezierControlPointBefore(int index) {
        Point2D addPoint = this.getBezierControlPoint(index);
        if (index > 0) {
            addPoint = MathUtil.midPoint(this.getBezierControlPoint(index - 1), addPoint);
        } else {
            Point2D ep1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
            addPoint = MathUtil.midPoint(ep1, addPoint);
        }
        this.bezierControlPoints.add(index, addPoint);
        this.layoutEditor.redrawPanel();
        this.layoutEditor.setDirty();
    }

    private void addBezierControlPointAfter(int index) {
        int cnt = this.bezierControlPoints.size();
        Point2D addPoint = this.getBezierControlPoint(index);
        if (index < cnt - 1) {
            addPoint = MathUtil.midPoint(addPoint, this.getBezierControlPoint(index + 1));
            this.bezierControlPoints.add(index + 1, addPoint);
        } else {
            Point2D ep2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
            addPoint = MathUtil.midPoint(addPoint, ep2);
            this.bezierControlPoints.add(addPoint);
        }
        this.layoutEditor.redrawPanel();
        this.layoutEditor.setDirty();
    }

    private void deleteBezierControlPoint(int index) {
        if (index >= 0 && index < this.bezierControlPoints.size()) {
            this.bezierControlPoints.remove(index);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    void changeType(int choice) {
        switch (choice) {
            case 0: {
                this.setArc(false);
                this.setAngle(0.0);
                this.setCircle(false);
                this.setBezier(false);
                break;
            }
            case 1: {
                this.setCircle(true);
                this.setArc(true);
                break;
            }
            case 2: {
                this.setArc(true);
                this.setAngle(90.0);
                this.setCircle(false);
                this.setBezier(false);
                break;
            }
            case 3: {
                this.setArc(false);
                this.setCircle(false);
                if (this.bezierControlPoints.size() == 0) {
                    Point2D ep1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
                    Point2D ep2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
                    Point2D offset = MathUtil.subtract(ep2, ep1);
                    offset = MathUtil.normalize(offset, MathUtil.length(offset) / 3.0);
                    offset = MathUtil.orthogonal(offset);
                    Point2D pt1 = MathUtil.add(MathUtil.oneThirdPoint(ep1, ep2), offset);
                    Point2D pt2 = MathUtil.subtract(MathUtil.twoThirdsPoint(ep1, ep2), offset);
                    this.bezierControlPoints.add(pt1);
                    this.bezierControlPoints.add(pt2);
                }
                this.setBezier(true);
                break;
            }
        }
        this.layoutEditor.redrawPanel();
        this.layoutEditor.setDirty();
    }

    public void dispose() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
        this.popupMenu = null;
    }

    public void remove() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isShowConstructionLines() {
        return (this.showConstructionLine & 2) != 2 && (this.showConstructionLine & 4) != 4;
    }

    public void hideConstructionLines(int hide) {
        this.showConstructionLine = hide == 4 ? (this.showConstructionLine |= 4) : (hide == 1 ? ((this.showConstructionLine & 4) == 4 ? (this.showConstructionLine &= 0xFFFFFFFB) : hide) : 2);
        this.layoutEditor.redrawPanel();
        this.layoutEditor.setDirty();
    }

    public boolean hideConstructionLines() {
        return (this.showConstructionLine & 1) != 1;
    }

    public Point2D getTmpPt1() {
        return this.pt1;
    }

    public Point2D getTmpPt2() {
        return this.pt2;
    }

    public void setTmpPt1(Point2D Pt1) {
        this.pt1 = Pt1;
        this.changed = true;
    }

    public void setTmpPt2(Point2D Pt2) {
        this.pt2 = Pt2;
        this.changed = true;
    }

    public double getCX() {
        return this.cX;
    }

    public void setCX(double CX) {
        this.cX = CX;
    }

    public double getCY() {
        return this.cY;
    }

    public void setCY(double CY) {
        this.cY = CY;
    }

    public double getCW() {
        return this.cW;
    }

    public void setCW(double CW) {
        this.cW = CW;
    }

    public double getCH() {
        return this.cH;
    }

    public void setCH(double CH) {
        this.cH = CH;
    }

    public double getStartAdj() {
        return this.startAdj;
    }

    public void setStartAdj(double startAdj) {
        this.startAdj = startAdj;
    }

    public double getCentreSegX() {
        return this.getCentreSeg().getX();
    }

    public void setCentreSegX(double x) {
        super.setCoordsCenter(new Point2D.Double(x, this.getCentreSeg().getY()));
    }

    public double getCentreSegY() {
        return this.getCentreSeg().getY();
    }

    public void setCentreSegY(double y) {
        super.setCoordsCenter(new Point2D.Double(this.getCentreSeg().getX(), y));
    }

    public Point2D getCentreSeg() {
        Point2D result = MathUtil.zeroPoint2D;
        if (this.getConnect1() != null && this.getConnect2() != null) {
            Point2D ep1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
            Point2D ep2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
            if (this.isCircle()) {
                result = this.getCoordsCenter();
            } else if (this.isArc()) {
                Point2D delta;
                super.setCoordsCenter(MathUtil.midPoint(ep1, ep2));
                if (this.isFlip()) {
                    Point2D t = ep1;
                    ep1 = ep2;
                    ep2 = t;
                }
                delta = (delta = MathUtil.subtract(ep1, ep2)).getX() >= 0.0 != delta.getY() >= 0.0 ? MathUtil.divide(delta, 5.0, -5.0) : MathUtil.divide(delta, -5.0, 5.0);
                result = MathUtil.add(this.getCoordsCenter(), delta);
            } else if (this.isBezier()) {
                int idx;
                int len = this.bezierControlPoints.size() + 2;
                Point2D[] points = new Point2D[len];
                points[0] = ep1;
                for (idx = 1; idx < len - 1; ++idx) {
                    points[idx] = this.bezierControlPoints.get(idx - 1);
                }
                points[len - 1] = ep2;
                for (idx = len - 1; idx > 0; --idx) {
                    for (int jdx = 0; jdx < idx; ++jdx) {
                        points[jdx] = MathUtil.midPoint(points[jdx], points[jdx + 1]);
                    }
                }
                result = points[0];
            } else {
                result = MathUtil.midPoint(ep1, ep2);
            }
            super.setCoordsCenter(result);
        }
        return result;
    }

    public void setCentreSeg(Point2D p) {
        super.setCoordsCenter(p);
    }

    public double getCentreX() {
        return this.centreX;
    }

    public void setCentreX(double x) {
        this.centreX = x;
    }

    public double getCentreY() {
        return this.centreY;
    }

    public void setCentreY(double y) {
        this.centreY = y;
    }

    public Point2D getCentre() {
        return new Point2D.Double(this.centreX, this.centreY);
    }

    public double getTmpAngle() {
        return this.tmpangle;
    }

    public void setTmpAngle(double a) {
        this.tmpangle = a;
    }

    public Point2D getCoordsCenterCircle() {
        return this.getCentre();
    }

    public void setCoordsCenterCircle(Point2D p) {
        this.centreX = p.getX();
        this.centreY = p.getY();
    }

    public double getChordLength() {
        return this.chordLength;
    }

    public void setChordLength(double chord) {
        this.chordLength = chord;
    }

    protected void reCalculateTrackSegmentAngle(double x, double y) {
        if (!this.isBezier()) {
            double pt2y;
            double pt2x;
            double pt1y;
            double pt1x;
            if (this.isFlip()) {
                pt1x = this.getTmpPt2().getX();
                pt1y = this.getTmpPt2().getY();
                pt2x = this.getTmpPt1().getX();
                pt2y = this.getTmpPt1().getY();
            } else {
                pt1x = this.getTmpPt1().getX();
                pt1y = this.getTmpPt1().getY();
                pt2x = this.getTmpPt2().getX();
                pt2y = this.getTmpPt2().getY();
            }
            double a = pt2x - x;
            double o = pt2y - y;
            double la = Math.hypot(a, o);
            a = pt1x - x;
            o = pt1y - y;
            double lb = Math.hypot(a, o);
            double newangle = Math.toDegrees(Math.acos((-this.getChordLength() * this.getChordLength() + la * la + lb * lb) / (2.0 * la * lb)));
            this.setAngle(newangle);
        }
    }

    protected void calculateTrackSegmentAngle() {
        Point2D pt2;
        Point2D pt1;
        if (this.isFlip()) {
            pt1 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
            pt2 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
        } else {
            pt1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
            pt2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
        }
        if (this.getTmpPt1() != pt1 || this.getTmpPt2() != pt2 || this.trackNeedsRedraw()) {
            this.setTmpPt1(pt1);
            this.setTmpPt2(pt2);
            double pt1x = pt1.getX();
            double pt1y = pt1.getY();
            double pt2x = pt2.getX();
            double pt2y = pt2.getY();
            if (this.getAngle() == 0.0) {
                this.setTmpAngle(90.0);
            } else {
                this.setTmpAngle(this.getAngle());
            }
            double halfAngleRAD = Math.toRadians(this.getTmpAngle()) / 2.0;
            double a = pt2x - pt1x;
            double o = pt2y - pt1y;
            double chord = Math.hypot(a, o);
            this.setChordLength(chord);
            if (chord > 0.0) {
                double radius = chord / 2.0 / Math.sin(halfAngleRAD);
                double startRad = Math.atan2(a, o) - halfAngleRAD;
                this.setStartAdj(Math.toDegrees(startRad));
                if (this.isCircle()) {
                    this.setCentreX(pt2x - Math.cos(startRad) * radius);
                    this.setCentreY(pt2y + Math.sin(startRad) * radius);
                    this.setCW(radius * 2.0);
                    this.setCH(radius * 2.0);
                    this.setCX(this.getCentreX() - radius);
                    this.setCY(this.getCentreY() - radius);
                    Point2D.Double offset = new Point2D.Double(radius * Math.cos(startRad + halfAngleRAD), -radius * Math.sin(startRad + halfAngleRAD));
                    this.setCentreSeg(MathUtil.add(this.getCentre(), offset));
                } else {
                    this.setStartAdj((double)Math.round(this.getStartAdj() / 90.0) * 90.0);
                    this.setCW(Math.abs(a) * 2.0);
                    this.setCH(Math.abs(o) * 2.0);
                    if (o * a < 0.0) {
                        a = -a;
                    } else {
                        o = -o;
                    }
                    this.setCX(Math.min(pt1x, pt2x) - Math.max(a, 0.0));
                    this.setCY(Math.min(pt1y, pt2y) - Math.max(o, 0.0));
                }
            }
        }
    }

    @Override
    protected void draw1(Graphics2D g2, boolean isMain, boolean isBlock) {
        if (!isBlock && this.isDashed() && this.getLayoutBlock() != null) {
            return;
        }
        if (isMain == this.trackSegment.isMainline()) {
            if (isBlock) {
                this.setColorForTrackBlock(g2, this.getLayoutBlock());
            }
            if (this.isArc()) {
                this.calculateTrackSegmentAngle();
                g2.draw(new Arc2D.Double(this.getCX(), this.getCY(), this.getCW(), this.getCH(), this.getStartAdj(), this.getTmpAngle(), 0));
                this.trackRedrawn();
            } else if (this.isBezier()) {
                Point2D[] points = this.getBezierPoints();
                MathUtil.drawBezier(g2, points);
            } else {
                Point2D end1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
                Point2D end2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
                g2.draw(new Line2D.Double(end1, end2));
            }
        }
    }

    @Override
    protected void draw2(Graphics2D g2, boolean isMain, float railDisplacement) {
        if (this.isDashed() && this.getLayoutBlock() != null) {
            return;
        }
        if (isMain == this.trackSegment.isMainline()) {
            if (this.isArc()) {
                this.calculateTrackSegmentAngle();
                Rectangle2D.Double cRectangle2D = new Rectangle2D.Double(this.getCX(), this.getCY(), this.getCW(), this.getCH());
                Rectangle2D tRectangle2D = MathUtil.inset(cRectangle2D, -railDisplacement);
                double startAdj = this.getStartAdj();
                double tmpAngle = this.getTmpAngle();
                g2.draw(new Arc2D.Double(tRectangle2D.getX(), tRectangle2D.getY(), tRectangle2D.getWidth(), tRectangle2D.getHeight(), startAdj, tmpAngle, 0));
                tRectangle2D = MathUtil.inset(cRectangle2D, railDisplacement);
                g2.draw(new Arc2D.Double(tRectangle2D.getX(), tRectangle2D.getY(), tRectangle2D.getWidth(), tRectangle2D.getHeight(), startAdj, tmpAngle, 0));
                this.trackRedrawn();
            } else if (this.isBezier()) {
                Point2D[] points = this.getBezierPoints();
                MathUtil.drawBezier(g2, points, -railDisplacement);
                MathUtil.drawBezier(g2, points, railDisplacement);
            } else {
                Point2D end1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
                Point2D end2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
                Point2D delta = MathUtil.subtract(end2, end1);
                Point2D vector = MathUtil.normalize(delta, railDisplacement);
                vector = MathUtil.orthogonal(vector);
                Point2D ep1L = MathUtil.add(end1, vector);
                Point2D ep2L = MathUtil.add(end2, vector);
                g2.draw(new Line2D.Double(ep1L, ep2L));
                Point2D ep1R = MathUtil.subtract(end1, vector);
                Point2D ep2R = MathUtil.subtract(end2, vector);
                g2.draw(new Line2D.Double(ep1R, ep2R));
            }
        }
    }

    @Override
    protected void highlightUnconnected(Graphics2D g2, HitPointType selectedType) {
    }

    @Override
    protected void drawEditControls(Graphics2D g2) {
        g2.setColor(Color.black);
        if (this.isShowConstructionLines()) {
            Point2D ep1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
            Point2D ep2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
            if (this.isCircle()) {
                Point2D circleCenterPoint = this.getCoordsCenterCircle();
                g2.draw(new Line2D.Double(circleCenterPoint, ep1));
                g2.draw(new Line2D.Double(circleCenterPoint, ep2));
                g2.draw(this.trackEditControlCircleAt(circleCenterPoint));
                g2.draw(this.layoutEditor.layoutEditorControlRectAt(circleCenterPoint));
            } else if (this.isBezier()) {
                Point2D lastPt = ep1;
                for (Point2D bcp : this.bezierControlPoints) {
                    g2.draw(new Line2D.Double(lastPt, bcp));
                    lastPt = bcp;
                    g2.draw(this.layoutEditor.layoutEditorControlRectAt(bcp));
                }
                g2.draw(new Line2D.Double(lastPt, ep2));
            }
        }
        g2.draw(this.trackEditControlCircleAt(this.getCentreSeg()));
    }

    @Override
    protected void drawTurnoutControls(Graphics2D g2) {
    }

    @Override
    public void reCheckBlockBoundary() {
    }

    @Override
    protected void drawDecorations(Graphics2D g2) {
        Point2D.Double p2;
        Point2D.Double p1;
        Point2D ep1L;
        Point2D ep1R;
        Point2D delta;
        Point2D[] points;
        Rectangle2D tRectangle2D;
        Rectangle2D.Double cRectangle2D;
        double stopAngleRAD;
        double startAngleRAD;
        log.trace("TrackSegmentView: drawDecorations arrowStyle {}", (Object)this.arrowStyle);
        Point2D ep1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
        Point2D ep2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
        Point2D p1P = ep1;
        Point2D p2P = ep2;
        if (this.isArc()) {
            this.calculateTrackSegmentAngle();
            double startAngleDEG = this.getStartAdj();
            double extentAngleDEG = this.getTmpAngle();
            startAngleRAD = 1.5707963267948966 - Math.toRadians(startAngleDEG);
            stopAngleRAD = 1.5707963267948966 - Math.toRadians(startAngleDEG + extentAngleDEG);
            if (this.isFlip()) {
                startAngleRAD += Math.PI;
                stopAngleRAD += Math.PI;
            } else {
                double temp = startAngleRAD;
                startAngleRAD = stopAngleRAD;
                stopAngleRAD = temp;
            }
        } else if (this.isBezier()) {
            Point2D cp0 = this.bezierControlPoints.get(0);
            Point2D cpN = this.bezierControlPoints.get(this.bezierControlPoints.size() - 1);
            startAngleRAD = 1.5707963267948966 - MathUtil.computeAngleRAD(cp0, ep1);
            stopAngleRAD = 1.5707963267948966 - MathUtil.computeAngleRAD(ep2, cpN);
        } else {
            stopAngleRAD = startAngleRAD = 1.5707963267948966 - MathUtil.computeAngleRAD(ep2, ep1);
        }
        if (this.arrowStyle > 0) {
            log.trace("arrowstyle>0 with width {}", (Object)this.arrowLineWidth);
            g2.setStroke(new BasicStroke(this.arrowLineWidth, 0, 0, 1.0f));
            g2.setColor(this.arrowColor);
            int offset = 1;
            if (this.arrowEndStart) {
                if (this.arrowDirIn) {
                    offset = this.drawArrow(g2, ep1, Math.PI + startAngleRAD, false, offset);
                }
                if (this.arrowDirOut) {
                    offset = this.drawArrow(g2, ep1, Math.PI + startAngleRAD, true, offset);
                }
            }
            offset = 1;
            if (this.arrowEndStop) {
                if (this.arrowDirIn) {
                    offset = this.drawArrow(g2, ep2, stopAngleRAD, false, offset);
                }
                if (this.arrowDirOut) {
                    offset = this.drawArrow(g2, ep2, stopAngleRAD, true, offset);
                }
            }
        }
        if (this.bridgeSideLeft || this.bridgeSideRight) {
            float halfWidth = (float)this.bridgeDeckWidth / 2.0f;
            log.trace("bridgeleft/right with width {}", (Object)this.bridgeLineWidth);
            g2.setStroke(new BasicStroke(this.bridgeLineWidth, 0, 0, 1.0f));
            g2.setColor(this.bridgeColor);
            if (this.isArc()) {
                this.calculateTrackSegmentAngle();
                cRectangle2D = new Rectangle2D.Double(this.getCX(), this.getCY(), this.getCW(), this.getCH());
                double startAdj = this.getStartAdj();
                double tmpAngle = this.getTmpAngle();
                if (this.bridgeSideLeft) {
                    tRectangle2D = MathUtil.inset(cRectangle2D, -halfWidth);
                    g2.draw(new Arc2D.Double(tRectangle2D.getX(), tRectangle2D.getY(), tRectangle2D.getWidth(), tRectangle2D.getHeight(), startAdj, tmpAngle, 0));
                }
                if (this.bridgeSideRight) {
                    tRectangle2D = MathUtil.inset(cRectangle2D, halfWidth);
                    g2.draw(new Arc2D.Double(tRectangle2D.getX(), tRectangle2D.getY(), tRectangle2D.getWidth(), tRectangle2D.getHeight(), startAdj, tmpAngle, 0));
                }
            } else if (this.isBezier()) {
                points = this.getBezierPoints();
                if (this.bridgeSideLeft) {
                    MathUtil.drawBezier(g2, points, -halfWidth);
                }
                if (this.bridgeSideRight) {
                    MathUtil.drawBezier(g2, points, halfWidth);
                }
            } else {
                delta = MathUtil.subtract(ep2, ep1);
                Point2D vector = MathUtil.normalize(delta, halfWidth);
                vector = MathUtil.orthogonal(vector);
                if (this.bridgeSideRight) {
                    ep1R = MathUtil.add(ep1, vector);
                    Point2D ep2R = MathUtil.add(ep2, vector);
                    g2.draw(new Line2D.Double(ep1R, ep2R));
                }
                if (this.bridgeSideLeft) {
                    ep1L = MathUtil.subtract(ep1, vector);
                    Point2D ep2L = MathUtil.subtract(ep2, vector);
                    g2.draw(new Line2D.Double(ep1L, ep2L));
                }
            }
            if (this.isFlip()) {
                boolean temp = this.bridgeSideRight;
                this.bridgeSideRight = this.bridgeSideLeft;
                this.bridgeSideLeft = temp;
            }
            if (this.bridgeHasEntry) {
                if (this.bridgeSideRight) {
                    p1 = new Point2D.Double(-this.bridgeApproachWidth, (float)this.bridgeApproachWidth + halfWidth);
                    p2 = new Point2D.Double(0.0, halfWidth);
                    p1P = MathUtil.add(MathUtil.rotateRAD(p1, startAngleRAD), ep1);
                    p2P = MathUtil.add(MathUtil.rotateRAD(p2, startAngleRAD), ep1);
                    g2.draw(new Line2D.Double(p1P, p2P));
                }
                if (this.bridgeSideLeft) {
                    p1 = new Point2D.Double(-this.bridgeApproachWidth, (float)(-this.bridgeApproachWidth) - halfWidth);
                    p2 = new Point2D.Double(0.0, -halfWidth);
                    p1P = MathUtil.add(MathUtil.rotateRAD(p1, startAngleRAD), ep1);
                    p2P = MathUtil.add(MathUtil.rotateRAD(p2, startAngleRAD), ep1);
                    g2.draw(new Line2D.Double(p1P, p2P));
                }
            }
            if (this.bridgeHasExit) {
                if (this.bridgeSideRight) {
                    p1 = new Point2D.Double(this.bridgeApproachWidth, (float)this.bridgeApproachWidth + halfWidth);
                    p2 = new Point2D.Double(0.0, halfWidth);
                    p1P = MathUtil.add(MathUtil.rotateRAD(p1, stopAngleRAD), ep2);
                    p2P = MathUtil.add(MathUtil.rotateRAD(p2, stopAngleRAD), ep2);
                    g2.draw(new Line2D.Double(p1P, p2P));
                }
                if (this.bridgeSideLeft) {
                    p1 = new Point2D.Double(this.bridgeApproachWidth, (float)(-this.bridgeApproachWidth) - halfWidth);
                    p2 = new Point2D.Double(0.0, -halfWidth);
                    p1P = MathUtil.add(MathUtil.rotateRAD(p1, stopAngleRAD), ep2);
                    p2P = MathUtil.add(MathUtil.rotateRAD(p2, stopAngleRAD), ep2);
                    g2.draw(new Line2D.Double(p1P, p2P));
                }
            }
            if (this.isFlip()) {
                boolean temp = this.bridgeSideRight;
                this.bridgeSideRight = this.bridgeSideLeft;
                this.bridgeSideLeft = temp;
            }
        }
        if (this.bumperEndStart || this.bumperEndStop) {
            log.trace("bumper end/start with width {}", (Object)this.bumperLineWidth);
            g2.setStroke(new BasicStroke(this.bumperLineWidth, 0, 0, 1.0f));
            g2.setColor(this.bumperColor);
            float halfLength = (float)this.bumperLength / 2.0f;
            if (this.bumperFlipped) {
                double temp = startAngleRAD;
                startAngleRAD = stopAngleRAD;
                stopAngleRAD = temp;
            }
            p1 = new Point2D.Double(0.0, -halfLength);
            p2 = new Point2D.Double(0.0, halfLength);
            if (this.bumperEndStart) {
                p1P = MathUtil.add(MathUtil.rotateRAD(p1, startAngleRAD), ep1);
                p2P = MathUtil.add(MathUtil.rotateRAD(p2, startAngleRAD), ep1);
                g2.draw(new Line2D.Double(p1P, p2P));
            }
            if (this.bumperEndStop) {
                p1P = MathUtil.add(MathUtil.rotateRAD(p1, stopAngleRAD), ep2);
                p2P = MathUtil.add(MathUtil.rotateRAD(p2, stopAngleRAD), ep2);
                g2.draw(new Line2D.Double(p1P, p2P));
            }
        }
        if (this.tunnelSideRight || this.tunnelSideLeft) {
            Point2D p7P;
            Point2D p6P;
            Point2D p5P;
            Point2D p4P;
            Point2D p3P;
            Point2D.Double p7;
            Point2D.Double p6;
            Point2D.Double p5;
            Point2D.Double p4;
            Point2D.Double p3;
            boolean temp;
            log.trace("tunnel left/right with width {}", (Object)this.tunnelLineWidth);
            float halfWidth = (float)this.tunnelFloorWidth / 2.0f;
            g2.setStroke(new BasicStroke(this.tunnelLineWidth, 0, 2, 10.0f, new float[]{6.0f, 4.0f}, 0.0f));
            g2.setColor(this.tunnelColor);
            if (this.isArc()) {
                this.calculateTrackSegmentAngle();
                cRectangle2D = new Rectangle2D.Double(this.getCX(), this.getCY(), this.getCW(), this.getCH());
                double startAngleDEG = this.getStartAdj();
                double extentAngleDEG = this.getTmpAngle();
                if (this.tunnelSideRight) {
                    tRectangle2D = MathUtil.inset(cRectangle2D, halfWidth);
                    g2.draw(new Arc2D.Double(tRectangle2D.getX(), tRectangle2D.getY(), tRectangle2D.getWidth(), tRectangle2D.getHeight(), startAngleDEG, extentAngleDEG, 0));
                }
                if (this.tunnelSideLeft) {
                    tRectangle2D = MathUtil.inset(cRectangle2D, -halfWidth);
                    g2.draw(new Arc2D.Double(tRectangle2D.getX(), tRectangle2D.getY(), tRectangle2D.getWidth(), tRectangle2D.getHeight(), startAngleDEG, extentAngleDEG, 0));
                }
                this.trackRedrawn();
            } else if (this.isBezier()) {
                points = this.getBezierPoints();
                if (this.tunnelSideRight) {
                    MathUtil.drawBezier(g2, points, halfWidth);
                }
                if (this.tunnelSideLeft) {
                    MathUtil.drawBezier(g2, points, -halfWidth);
                }
            } else {
                delta = MathUtil.subtract(ep2, ep1);
                Point2D vector = MathUtil.normalize(delta, halfWidth);
                vector = MathUtil.orthogonal(vector);
                if (this.tunnelSideRight) {
                    ep1L = MathUtil.add(ep1, vector);
                    Point2D ep2L = MathUtil.add(ep2, vector);
                    g2.draw(new Line2D.Double(ep1L, ep2L));
                }
                if (this.tunnelSideLeft) {
                    ep1R = MathUtil.subtract(ep1, vector);
                    Point2D ep2R = MathUtil.subtract(ep2, vector);
                    g2.draw(new Line2D.Double(ep1R, ep2R));
                }
            }
            g2.setStroke(new BasicStroke(this.tunnelLineWidth, 0, 0, 1.0f));
            g2.setColor(this.tunnelColor);
            this.tunnelEntranceWidth = Math.max(this.tunnelEntranceWidth, this.tunnelFloorWidth + 6);
            double halfEntranceWidth = (double)this.tunnelEntranceWidth / 2.0;
            double halfFloorWidth = (double)this.tunnelFloorWidth / 2.0;
            double halfDiffWidth = halfEntranceWidth - halfFloorWidth;
            if (this.isFlip()) {
                temp = this.tunnelSideRight;
                this.tunnelSideRight = this.tunnelSideLeft;
                this.tunnelSideLeft = temp;
            }
            if (this.tunnelHasEntry) {
                if (this.tunnelSideRight) {
                    p1 = new Point2D.Double(0.0, 0.0);
                    p2 = new Point2D.Double(0.0, halfFloorWidth);
                    p3 = new Point2D.Double(0.0, halfEntranceWidth);
                    p4 = new Point2D.Double(-halfEntranceWidth - halfFloorWidth, halfEntranceWidth);
                    p5 = new Point2D.Double(-halfEntranceWidth - halfFloorWidth, halfEntranceWidth - halfDiffWidth);
                    p6 = new Point2D.Double(-halfFloorWidth, halfEntranceWidth - halfDiffWidth);
                    p7 = new Point2D.Double(-halfDiffWidth, 0.0);
                    p1P = MathUtil.add(MathUtil.rotateRAD(p1, startAngleRAD), ep1);
                    p2P = MathUtil.add(MathUtil.rotateRAD(p2, startAngleRAD), ep1);
                    p3P = MathUtil.add(MathUtil.rotateRAD(p3, startAngleRAD), ep1);
                    p4P = MathUtil.add(MathUtil.rotateRAD(p4, startAngleRAD), ep1);
                    p5P = MathUtil.add(MathUtil.rotateRAD(p5, startAngleRAD), ep1);
                    p6P = MathUtil.add(MathUtil.rotateRAD(p6, startAngleRAD), ep1);
                    p7P = MathUtil.add(MathUtil.rotateRAD(p7, startAngleRAD), ep1);
                    GeneralPath path = new GeneralPath();
                    path.moveTo(p1P.getX(), p1P.getY());
                    path.lineTo(p2P.getX(), p2P.getY());
                    path.quadTo(p3P.getX(), p3P.getY(), p4P.getX(), p4P.getY());
                    path.lineTo(p5P.getX(), p5P.getY());
                    path.quadTo(p6P.getX(), p6P.getY(), p7P.getX(), p7P.getY());
                    path.closePath();
                    g2.draw(path);
                }
                if (this.tunnelSideLeft) {
                    p1 = new Point2D.Double(0.0, 0.0);
                    p2 = new Point2D.Double(0.0, -halfFloorWidth);
                    p3 = new Point2D.Double(0.0, -halfEntranceWidth);
                    p4 = new Point2D.Double(-halfEntranceWidth - halfFloorWidth, -halfEntranceWidth);
                    p5 = new Point2D.Double(-halfEntranceWidth - halfFloorWidth, -halfEntranceWidth + halfDiffWidth);
                    p6 = new Point2D.Double(-halfFloorWidth, -halfEntranceWidth + halfDiffWidth);
                    p7 = new Point2D.Double(-halfDiffWidth, 0.0);
                    p1P = MathUtil.add(MathUtil.rotateRAD(p1, startAngleRAD), ep1);
                    p2P = MathUtil.add(MathUtil.rotateRAD(p2, startAngleRAD), ep1);
                    p3P = MathUtil.add(MathUtil.rotateRAD(p3, startAngleRAD), ep1);
                    p4P = MathUtil.add(MathUtil.rotateRAD(p4, startAngleRAD), ep1);
                    p5P = MathUtil.add(MathUtil.rotateRAD(p5, startAngleRAD), ep1);
                    p6P = MathUtil.add(MathUtil.rotateRAD(p6, startAngleRAD), ep1);
                    p7P = MathUtil.add(MathUtil.rotateRAD(p7, startAngleRAD), ep1);
                    GeneralPath path = new GeneralPath();
                    path.moveTo(p1P.getX(), p1P.getY());
                    path.lineTo(p2P.getX(), p2P.getY());
                    path.quadTo(p3P.getX(), p3P.getY(), p4P.getX(), p4P.getY());
                    path.lineTo(p5P.getX(), p5P.getY());
                    path.quadTo(p6P.getX(), p6P.getY(), p7P.getX(), p7P.getY());
                    path.closePath();
                    g2.draw(path);
                }
            }
            if (this.tunnelHasExit) {
                if (this.tunnelSideRight) {
                    p1 = new Point2D.Double(0.0, 0.0);
                    p2 = new Point2D.Double(0.0, halfFloorWidth);
                    p3 = new Point2D.Double(0.0, halfEntranceWidth);
                    p4 = new Point2D.Double(halfEntranceWidth + halfFloorWidth, halfEntranceWidth);
                    p5 = new Point2D.Double(halfEntranceWidth + halfFloorWidth, halfEntranceWidth - halfDiffWidth);
                    p6 = new Point2D.Double(halfFloorWidth, halfEntranceWidth - halfDiffWidth);
                    p7 = new Point2D.Double(halfDiffWidth, 0.0);
                    p1P = MathUtil.add(MathUtil.rotateRAD(p1, stopAngleRAD), ep2);
                    p2P = MathUtil.add(MathUtil.rotateRAD(p2, stopAngleRAD), ep2);
                    p3P = MathUtil.add(MathUtil.rotateRAD(p3, stopAngleRAD), ep2);
                    p4P = MathUtil.add(MathUtil.rotateRAD(p4, stopAngleRAD), ep2);
                    p5P = MathUtil.add(MathUtil.rotateRAD(p5, stopAngleRAD), ep2);
                    p6P = MathUtil.add(MathUtil.rotateRAD(p6, stopAngleRAD), ep2);
                    p7P = MathUtil.add(MathUtil.rotateRAD(p7, stopAngleRAD), ep2);
                    GeneralPath path = new GeneralPath();
                    path.moveTo(p1P.getX(), p1P.getY());
                    path.lineTo(p2P.getX(), p2P.getY());
                    path.quadTo(p3P.getX(), p3P.getY(), p4P.getX(), p4P.getY());
                    path.lineTo(p5P.getX(), p5P.getY());
                    path.quadTo(p6P.getX(), p6P.getY(), p7P.getX(), p7P.getY());
                    path.closePath();
                    g2.draw(path);
                }
                if (this.tunnelSideLeft) {
                    p1 = new Point2D.Double(0.0, 0.0);
                    p2 = new Point2D.Double(0.0, -halfFloorWidth);
                    p3 = new Point2D.Double(0.0, -halfEntranceWidth);
                    p4 = new Point2D.Double(halfEntranceWidth + halfFloorWidth, -halfEntranceWidth);
                    p5 = new Point2D.Double(halfEntranceWidth + halfFloorWidth, -halfEntranceWidth + halfDiffWidth);
                    p6 = new Point2D.Double(halfFloorWidth, -halfEntranceWidth + halfDiffWidth);
                    p7 = new Point2D.Double(halfDiffWidth, 0.0);
                    p1P = MathUtil.add(MathUtil.rotateRAD(p1, stopAngleRAD), ep2);
                    p2P = MathUtil.add(MathUtil.rotateRAD(p2, stopAngleRAD), ep2);
                    p3P = MathUtil.add(MathUtil.rotateRAD(p3, stopAngleRAD), ep2);
                    p4P = MathUtil.add(MathUtil.rotateRAD(p4, stopAngleRAD), ep2);
                    p5P = MathUtil.add(MathUtil.rotateRAD(p5, stopAngleRAD), ep2);
                    p6P = MathUtil.add(MathUtil.rotateRAD(p6, stopAngleRAD), ep2);
                    p7P = MathUtil.add(MathUtil.rotateRAD(p7, stopAngleRAD), ep2);
                    GeneralPath path = new GeneralPath();
                    path.moveTo(p1P.getX(), p1P.getY());
                    path.lineTo(p2P.getX(), p2P.getY());
                    path.quadTo(p3P.getX(), p3P.getY(), p4P.getX(), p4P.getY());
                    path.lineTo(p5P.getX(), p5P.getY());
                    path.quadTo(p6P.getX(), p6P.getY(), p7P.getX(), p7P.getY());
                    path.closePath();
                    g2.draw(path);
                }
            }
            if (this.isFlip()) {
                temp = this.tunnelSideRight;
                this.tunnelSideRight = this.tunnelSideLeft;
                this.tunnelSideLeft = temp;
            }
        }
    }

    @Nonnull
    private Point2D[] getBezierPoints() {
        Point2D ep1 = this.layoutEditor.getCoords(this.getConnect1(), this.getType1());
        Point2D ep2 = this.layoutEditor.getCoords(this.getConnect2(), this.getType2());
        int cnt = this.bezierControlPoints.size() + 2;
        Point2D[] points = new Point2D[cnt];
        points[0] = ep1;
        for (int idx = 0; idx < cnt - 2; ++idx) {
            points[idx + 1] = this.bezierControlPoints.get(idx);
        }
        points[cnt - 1] = ep2;
        return points;
    }

    private int drawArrow(Graphics2D g2, Point2D ep, double angleRAD, boolean dirOut, int offset) {
        log.trace("drawArrow in TrackSegmentView");
        switch (this.arrowStyle) {
            default: {
                this.arrowStyle = 0;
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                Point2D p3;
                Point2D p2;
                Point2D p1;
                if (dirOut) {
                    p1 = new Point2D.Double(offset, -this.arrowLength);
                    p2 = new Point2D.Double(offset + this.arrowLength, 0.0);
                    p3 = new Point2D.Double(offset, this.arrowLength);
                } else {
                    p1 = new Point2D.Double(offset + this.arrowLength, -this.arrowLength);
                    p2 = new Point2D.Double(offset, 0.0);
                    p3 = new Point2D.Double(offset + this.arrowLength, this.arrowLength);
                }
                p1 = MathUtil.add(MathUtil.rotateRAD(p1, angleRAD), ep);
                p2 = MathUtil.add(MathUtil.rotateRAD(p2, angleRAD), ep);
                p3 = MathUtil.add(MathUtil.rotateRAD(p3, angleRAD), ep);
                g2.draw(new Line2D.Double(p1, p2));
                g2.draw(new Line2D.Double(p2, p3));
                offset += this.arrowLength + this.arrowGap;
                break;
            }
            case 2: {
                Point2D p6;
                Point2D p5;
                Point2D p4;
                Point2D p3;
                Point2D p2;
                Point2D p1;
                if (dirOut) {
                    p1 = new Point2D.Double(offset, -this.arrowLength);
                    p2 = new Point2D.Double(offset + this.arrowLength, 0.0);
                    p3 = new Point2D.Double(offset, this.arrowLength);
                    p4 = new Point2D.Double(offset + this.arrowLineWidth + this.arrowGap, -this.arrowLength);
                    p5 = new Point2D.Double(offset + this.arrowLineWidth + this.arrowGap + this.arrowLength, 0.0);
                    p6 = new Point2D.Double(offset + this.arrowLineWidth + this.arrowGap, this.arrowLength);
                } else {
                    p1 = new Point2D.Double(offset + this.arrowLength, -this.arrowLength);
                    p2 = new Point2D.Double(offset, 0.0);
                    p3 = new Point2D.Double(offset + this.arrowLength, this.arrowLength);
                    p4 = new Point2D.Double(offset + this.arrowLineWidth + this.arrowGap + this.arrowLength, -this.arrowLength);
                    p5 = new Point2D.Double(offset + this.arrowLineWidth + this.arrowGap, 0.0);
                    p6 = new Point2D.Double(offset + this.arrowLineWidth + this.arrowGap + this.arrowLength, this.arrowLength);
                }
                p1 = MathUtil.add(MathUtil.rotateRAD(p1, angleRAD), ep);
                p2 = MathUtil.add(MathUtil.rotateRAD(p2, angleRAD), ep);
                p3 = MathUtil.add(MathUtil.rotateRAD(p3, angleRAD), ep);
                p4 = MathUtil.add(MathUtil.rotateRAD(p4, angleRAD), ep);
                p5 = MathUtil.add(MathUtil.rotateRAD(p5, angleRAD), ep);
                p6 = MathUtil.add(MathUtil.rotateRAD(p6, angleRAD), ep);
                g2.draw(new Line2D.Double(p1, p2));
                g2.draw(new Line2D.Double(p2, p3));
                g2.draw(new Line2D.Double(p4, p5));
                g2.draw(new Line2D.Double(p5, p6));
                offset += this.arrowLength + 2 * (this.arrowLineWidth + this.arrowGap);
                break;
            }
            case 3: {
                Point2D p3;
                Point2D p2;
                Point2D p1;
                if (dirOut) {
                    p1 = new Point2D.Double(offset, -this.arrowLength);
                    p2 = new Point2D.Double(offset + this.arrowLength, 0.0);
                    p3 = new Point2D.Double(offset, this.arrowLength);
                } else {
                    p1 = new Point2D.Double(offset + this.arrowLength, -this.arrowLength);
                    p2 = new Point2D.Double(offset, 0.0);
                    p3 = new Point2D.Double(offset + this.arrowLength, this.arrowLength);
                }
                p1 = MathUtil.add(MathUtil.rotateRAD(p1, angleRAD), ep);
                p2 = MathUtil.add(MathUtil.rotateRAD(p2, angleRAD), ep);
                p3 = MathUtil.add(MathUtil.rotateRAD(p3, angleRAD), ep);
                GeneralPath path = new GeneralPath();
                path.moveTo(p1.getX(), p1.getY());
                path.lineTo(p2.getX(), p2.getY());
                path.lineTo(p3.getX(), p3.getY());
                path.closePath();
                if (this.arrowLineWidth > 1) {
                    g2.fill(path);
                } else {
                    g2.draw(path);
                }
                offset += this.arrowLength + this.arrowGap;
                break;
            }
            case 4: {
                Point2D p4;
                Point2D p3;
                Point2D p2;
                Point2D p1;
                if (dirOut) {
                    p1 = new Point2D.Double(offset, 0.0);
                    p2 = new Point2D.Double(offset + 2 * this.arrowLength, -this.arrowLength);
                    p3 = new Point2D.Double(offset + 3 * this.arrowLength, 0.0);
                    p4 = new Point2D.Double(offset + 2 * this.arrowLength, this.arrowLength);
                } else {
                    p1 = new Point2D.Double(offset, 0.0);
                    p2 = new Point2D.Double(offset + 4 * this.arrowLength, -this.arrowLength);
                    p3 = new Point2D.Double(offset + 3 * this.arrowLength, 0.0);
                    p4 = new Point2D.Double(offset + 4 * this.arrowLength, this.arrowLength);
                }
                p1 = MathUtil.add(MathUtil.rotateRAD(p1, angleRAD), ep);
                p2 = MathUtil.add(MathUtil.rotateRAD(p2, angleRAD), ep);
                p3 = MathUtil.add(MathUtil.rotateRAD(p3, angleRAD), ep);
                p4 = MathUtil.add(MathUtil.rotateRAD(p4, angleRAD), ep);
                g2.draw(new Line2D.Double(p1, p3));
                g2.draw(new Line2D.Double(p2, p3));
                g2.draw(new Line2D.Double(p3, p4));
                offset += 3 * this.arrowLength + this.arrowGap;
                break;
            }
            case 5: {
                Point2D p4;
                Point2D p3;
                Point2D p2;
                Point2D p1;
                if (dirOut) {
                    p1 = new Point2D.Double(offset, 0.0);
                    p2 = new Point2D.Double(offset + 2 * this.arrowLength, -this.arrowLength);
                    p3 = new Point2D.Double(offset + 3 * this.arrowLength, 0.0);
                    p4 = new Point2D.Double(offset + 2 * this.arrowLength, this.arrowLength);
                } else {
                    p1 = new Point2D.Double(offset, 0.0);
                    p2 = new Point2D.Double(offset + 4 * this.arrowLength, -this.arrowLength);
                    p3 = new Point2D.Double(offset + 3 * this.arrowLength, 0.0);
                    p4 = new Point2D.Double(offset + 4 * this.arrowLength, this.arrowLength);
                }
                p1 = MathUtil.add(MathUtil.rotateRAD(p1, angleRAD), ep);
                p2 = MathUtil.add(MathUtil.rotateRAD(p2, angleRAD), ep);
                p3 = MathUtil.add(MathUtil.rotateRAD(p3, angleRAD), ep);
                p4 = MathUtil.add(MathUtil.rotateRAD(p4, angleRAD), ep);
                GeneralPath path = new GeneralPath();
                path.moveTo(p4.getX(), p4.getY());
                path.lineTo(p2.getX(), p2.getY());
                path.lineTo(p3.getX(), p3.getY());
                path.closePath();
                if (this.arrowLineWidth > 1) {
                    g2.fill(path);
                } else {
                    g2.draw(path);
                }
                g2.draw(new Line2D.Double(p1, p3));
                offset += 3 * this.arrowLength + this.arrowGap;
                break;
            }
        }
        return offset;
    }

    @Override
    public boolean hasDecorations() {
        return this.arrowStyle > 0 || this.bridgeSideLeft || this.bridgeSideRight || this.bumperEndStart || this.bumperEndStop || this.tunnelSideLeft || this.tunnelSideRight;
    }

    @Override
    public Map<String, String> getDecorations() {
        if (this.decorations == null) {
            this.decorations = new HashMap();
        }
        if (this.arrowStyle > 0) {
            ArrayList<Object> arrowValues = new ArrayList<Object>();
            arrowValues.add("style=" + this.arrowStyle);
            if (!this.arrowEndStart || !this.arrowEndStop) {
                if (this.arrowEndStop) {
                    arrowValues.add("stop");
                } else {
                    this.arrowEndStart = true;
                    arrowValues.add("start");
                }
            }
            if (this.arrowDirIn && !this.arrowDirOut) {
                arrowValues.add("in");
            } else if (!this.arrowDirIn && this.arrowDirOut) {
                arrowValues.add("out");
            } else {
                this.arrowDirIn = true;
                this.arrowDirOut = true;
                arrowValues.add("both");
            }
            arrowValues.add("color=" + ColorUtil.colorToHexString(this.arrowColor));
            arrowValues.add("linewidth=" + this.arrowLineWidth);
            arrowValues.add("length=" + this.arrowLength);
            arrowValues.add("gap=" + this.arrowGap);
            this.decorations.put("arrow", String.join((CharSequence)";", arrowValues));
        }
        if (this.bridgeSideLeft || this.bridgeSideRight) {
            ArrayList<Object> bridgeValues = new ArrayList<Object>();
            if (this.bridgeHasEntry && !this.bridgeHasExit) {
                bridgeValues.add("entry");
            } else if (!this.bridgeHasEntry && this.bridgeHasExit) {
                bridgeValues.add("exit");
            } else if (this.bridgeHasEntry && this.bridgeHasExit) {
                bridgeValues.add("both");
            }
            if (this.bridgeSideLeft && !this.bridgeSideRight) {
                bridgeValues.add("left");
            } else if (!this.bridgeSideLeft && this.bridgeSideRight) {
                bridgeValues.add("right");
            }
            bridgeValues.add("color=" + ColorUtil.colorToHexString(this.bridgeColor));
            bridgeValues.add("linewidth=" + this.bridgeLineWidth);
            bridgeValues.add("approachwidth=" + this.bridgeApproachWidth);
            bridgeValues.add("deckwidth=" + this.bridgeDeckWidth);
            this.decorations.put("bridge", String.join((CharSequence)";", bridgeValues));
        }
        if (this.bumperEndStart || this.bumperEndStop) {
            ArrayList<Object> bumperValues = new ArrayList<Object>();
            if (this.bumperEndStart) {
                bumperValues.add("start");
            } else if (this.bumperEndStop) {
                bumperValues.add("stop");
            }
            if (this.bumperFlipped) {
                bumperValues.add("flip");
            }
            bumperValues.add("color=" + ColorUtil.colorToHexString(this.bumperColor));
            bumperValues.add("length=" + this.bumperLength);
            bumperValues.add("linewidth=" + this.bumperLineWidth);
            this.decorations.put("bumper", String.join((CharSequence)";", bumperValues));
        }
        if (this.tunnelSideLeft || this.tunnelSideRight) {
            ArrayList<Object> tunnelValues = new ArrayList<Object>();
            if (this.tunnelHasEntry && !this.tunnelHasExit) {
                tunnelValues.add("entry");
            } else if (!this.tunnelHasEntry && this.tunnelHasExit) {
                tunnelValues.add("exit");
            } else if (this.tunnelHasEntry && this.tunnelHasExit) {
                tunnelValues.add("both");
            }
            if (this.tunnelSideLeft && !this.tunnelSideRight) {
                tunnelValues.add("left");
            } else if (this.tunnelSideLeft && !this.tunnelSideRight) {
                tunnelValues.add("right");
            }
            tunnelValues.add("color=" + ColorUtil.colorToHexString(this.tunnelColor));
            tunnelValues.add("linewidth=" + this.tunnelLineWidth);
            tunnelValues.add("entrancewidth=" + this.tunnelEntranceWidth);
            tunnelValues.add("floorwidth=" + this.tunnelFloorWidth);
            this.decorations.put("tunnel", String.join((CharSequence)";", tunnelValues));
        }
        return this.decorations;
    }

    @Override
    public void setDecorations(@Nonnull Map<String, String> decorations) {
        Color defaultTrackColor = this.layoutEditor.getDefaultTrackColorColor();
        super.setDecorations(decorations);
        if (decorations != null) {
            for (Map.Entry<String, String> entry : decorations.entrySet()) {
                String valueString;
                boolean hasRight;
                boolean hasLeft;
                int n;
                boolean hasOut;
                boolean hasIn;
                log.debug("Key = ''{}'', Value = ''{}''", (Object)entry.getKey(), (Object)entry.getValue());
                String key = entry.getKey();
                if (key.equals("arrow")) {
                    String[] values;
                    String arrowValue = entry.getValue();
                    boolean atStart = true;
                    boolean atStop = true;
                    hasIn = false;
                    hasOut = false;
                    int lineWidth = 1;
                    int length = 3;
                    int gap = 1;
                    int count = 1;
                    Color color = defaultTrackColor;
                    String[] stringArray = values = arrowValue.split(";");
                    n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String valueString2;
                        String value = stringArray[i];
                        if (value.equals("single")) {
                            count = 1;
                            continue;
                        }
                        if (value.equals("double")) {
                            count = 2;
                            continue;
                        }
                        if (value.equals("triple")) {
                            count = 3;
                            continue;
                        }
                        if (value.startsWith("style=")) {
                            valueString2 = value.substring(value.lastIndexOf("=") + 1);
                            count = Integer.parseInt(valueString2);
                            continue;
                        }
                        if (value.equals("start")) {
                            atStop = false;
                            continue;
                        }
                        if (value.equals("stop")) {
                            atStart = false;
                            continue;
                        }
                        if (value.equals("in")) {
                            hasIn = true;
                            continue;
                        }
                        if (value.equals("out")) {
                            hasOut = true;
                            continue;
                        }
                        if (value.equals("both")) {
                            hasIn = true;
                            hasOut = true;
                            continue;
                        }
                        if (value.startsWith("color=")) {
                            valueString2 = value.substring(value.lastIndexOf("=") + 1);
                            color = Color.decode(valueString2);
                            continue;
                        }
                        if (value.startsWith("linewidth=")) {
                            valueString2 = value.substring(value.lastIndexOf("=") + 1);
                            lineWidth = Integer.parseInt(valueString2);
                            continue;
                        }
                        if (value.startsWith("length=")) {
                            valueString2 = value.substring(value.lastIndexOf("=") + 1);
                            length = Integer.parseInt(valueString2);
                            continue;
                        }
                        if (value.startsWith("gap=")) {
                            valueString2 = value.substring(value.lastIndexOf("=") + 1);
                            gap = Integer.parseInt(valueString2);
                            continue;
                        }
                        log.debug("arrow value ignored: {}", (Object)value);
                    }
                    hasIn |= !hasOut;
                    if (!atStart && !atStop) {
                        atStart = true;
                        atStop = true;
                    }
                    this.setArrowEndStart(atStart);
                    this.setArrowEndStop(atStop);
                    this.setArrowDirIn(hasIn);
                    this.setArrowDirOut(hasOut);
                    this.setArrowColor(color);
                    this.setArrowLineWidth(lineWidth);
                    this.setArrowLength(length);
                    this.setArrowGap(gap);
                    this.setArrowStyle(count);
                    continue;
                }
                if (key.equals("bridge")) {
                    String[] values;
                    String bridgeValue = entry.getValue();
                    hasLeft = true;
                    hasRight = true;
                    boolean hasEntry = false;
                    boolean hasExit = false;
                    int approachWidth = 4;
                    int lineWidth = 1;
                    int deckWidth = 2;
                    Color color = defaultTrackColor;
                    String[] stringArray = values = bridgeValue.split(";");
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String value = stringArray[n];
                        if (value.equals("left")) {
                            hasRight = false;
                            continue;
                        }
                        if (value.equals("right")) {
                            hasLeft = false;
                            continue;
                        }
                        if (value.equals("entry")) {
                            hasEntry = true;
                            continue;
                        }
                        if (value.equals("exit")) {
                            hasExit = true;
                            continue;
                        }
                        if (value.equals("both")) {
                            hasEntry = true;
                            hasExit = true;
                            continue;
                        }
                        if (value.startsWith("color=")) {
                            valueString = value.substring(value.lastIndexOf("=") + 1);
                            color = Color.decode(valueString);
                            continue;
                        }
                        if (value.startsWith("approachwidth=")) {
                            valueString = value.substring(value.lastIndexOf("=") + 1);
                            approachWidth = Integer.parseInt(valueString);
                            continue;
                        }
                        if (value.startsWith("linewidth=")) {
                            valueString = value.substring(value.lastIndexOf("=") + 1);
                            lineWidth = Integer.parseInt(valueString);
                            continue;
                        }
                        if (value.startsWith("deckwidth=")) {
                            valueString = value.substring(value.lastIndexOf("=") + 1);
                            deckWidth = Integer.parseInt(valueString);
                            continue;
                        }
                        log.debug("bridge value ignored: {}", (Object)value);
                    }
                    if (!hasLeft && !hasRight) {
                        hasLeft = true;
                        hasRight = true;
                    }
                    this.setBridgeSideRight(hasRight);
                    this.setBridgeSideLeft(hasLeft);
                    this.setBridgeHasEntry(hasEntry);
                    this.setBridgeHasExit(hasExit);
                    this.setBridgeColor(color);
                    this.setBridgeDeckWidth(deckWidth);
                    this.setBridgeLineWidth(lineWidth);
                    this.setBridgeApproachWidth(approachWidth);
                    continue;
                }
                if (key.equals("bumper")) {
                    String[] values;
                    String bumperValue = entry.getValue();
                    int lineWidth = 1;
                    int length = 4;
                    boolean isFlipped = false;
                    boolean atStart = true;
                    boolean atStop = true;
                    Color color = defaultTrackColor;
                    for (String value : values = bumperValue.split(";")) {
                        String valueString3;
                        if (value.equals("start")) {
                            atStop = false;
                            continue;
                        }
                        if (value.equals("stop")) {
                            atStart = false;
                            continue;
                        }
                        if (value.equals("both")) continue;
                        if (value.equals("flip")) {
                            isFlipped = true;
                            continue;
                        }
                        if (value.startsWith("color=")) {
                            valueString3 = value.substring(value.lastIndexOf("=") + 1);
                            color = Color.decode(valueString3);
                            continue;
                        }
                        if (value.startsWith("linewidth=")) {
                            valueString3 = value.substring(value.lastIndexOf("=") + 1);
                            lineWidth = Integer.parseInt(valueString3);
                            continue;
                        }
                        if (value.startsWith("length=")) {
                            valueString3 = value.substring(value.lastIndexOf("=") + 1);
                            length = Integer.parseInt(valueString3);
                            continue;
                        }
                        log.debug("bumper value ignored: {}", (Object)value);
                    }
                    boolean bl = !atStart;
                    this.setBumperEndStart(atStart);
                    this.setBumperEndStop(atStop |= bl);
                    this.setBumperColor(color);
                    this.setBumperLineWidth(lineWidth);
                    this.setBumperLength(length);
                    this.setBumperFlipped(isFlipped);
                    continue;
                }
                if (key.equals("tunnel")) {
                    String[] values;
                    String tunnelValue = entry.getValue();
                    hasLeft = true;
                    hasRight = true;
                    hasIn = false;
                    hasOut = false;
                    int entranceWidth = 4;
                    int lineWidth = 1;
                    int floorWidth = 2;
                    Color color = defaultTrackColor;
                    String[] stringArray = values = tunnelValue.split(";");
                    int n3 = stringArray.length;
                    for (n = 0; n < n3; ++n) {
                        String value = stringArray[n];
                        if (value.equals("left")) {
                            hasRight = false;
                            continue;
                        }
                        if (value.equals("right")) {
                            hasLeft = false;
                            continue;
                        }
                        if (value.equals("entry")) {
                            hasIn = true;
                            continue;
                        }
                        if (value.equals("exit")) {
                            hasOut = true;
                            continue;
                        }
                        if (value.equals("both")) {
                            hasIn = true;
                            hasOut = true;
                            continue;
                        }
                        if (value.startsWith("color=")) {
                            valueString = value.substring(value.lastIndexOf("=") + 1);
                            color = Color.decode(valueString);
                            continue;
                        }
                        if (value.startsWith("entrancewidth=")) {
                            valueString = value.substring(value.lastIndexOf("=") + 1);
                            entranceWidth = Integer.parseInt(valueString);
                            continue;
                        }
                        if (value.startsWith("linewidth=")) {
                            valueString = value.substring(value.lastIndexOf("=") + 1);
                            lineWidth = Integer.parseInt(valueString);
                            continue;
                        }
                        if (value.startsWith("floorwidth=")) {
                            valueString = value.substring(value.lastIndexOf("=") + 1);
                            floorWidth = Integer.parseInt(valueString);
                            continue;
                        }
                        log.debug("tunnel value ignored: {}", (Object)value);
                    }
                    if (!hasLeft && !hasRight) {
                        hasLeft = true;
                        hasRight = true;
                    }
                    this.setTunnelSideRight(hasRight);
                    this.setTunnelSideLeft(hasLeft);
                    this.setTunnelHasEntry(hasIn);
                    this.setTunnelHasExit(hasOut);
                    this.setTunnelColor(color);
                    this.setTunnelEntranceWidth(entranceWidth);
                    this.setTunnelLineWidth(lineWidth);
                    this.setTunnelFloorWidth(floorWidth);
                    continue;
                }
                log.debug("Unknown decoration key: {}, value: {}", (Object)key, (Object)entry.getValue());
            }
        }
    }

    public int getArrowStyle() {
        return this.arrowStyle;
    }

    public void setArrowStyle(int newVal) {
        log.trace("TrackSegmentView:setArrowStyle {} {} {}", new Object[]{newVal, this.arrowEndStart, this.arrowEndStop});
        if (this.arrowStyle != newVal) {
            if (newVal > 0) {
                if (!this.arrowEndStart && !this.arrowEndStop) {
                    this.arrowEndStart = true;
                    this.arrowEndStop = true;
                }
                if (!this.arrowDirIn && !this.arrowDirOut) {
                    this.arrowDirOut = true;
                }
            } else {
                newVal = 0;
            }
            this.arrowStyle = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isArrowEndStart() {
        return this.arrowEndStart;
    }

    public void setArrowEndStart(boolean newVal) {
        if (this.arrowEndStart != newVal) {
            this.arrowEndStart = newVal;
            if (!this.arrowEndStart && !this.arrowEndStop) {
                this.arrowStyle = 0;
            } else if (this.arrowStyle == 0) {
                this.arrowStyle = 1;
            }
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isArrowEndStop() {
        return this.arrowEndStop;
    }

    public void setArrowEndStop(boolean newVal) {
        if (this.arrowEndStop != newVal) {
            this.arrowEndStop = newVal;
            if (!this.arrowEndStart && !this.arrowEndStop) {
                this.arrowStyle = 0;
            } else if (this.arrowStyle == 0) {
                this.arrowStyle = 1;
            }
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isArrowDirIn() {
        return this.arrowDirIn;
    }

    public void setArrowDirIn(boolean newVal) {
        if (this.arrowDirIn != newVal) {
            this.arrowDirIn = newVal;
            if (!this.arrowDirIn && !this.arrowDirOut) {
                this.arrowStyle = 0;
            } else if (this.arrowStyle == 0) {
                this.arrowStyle = 1;
            }
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isArrowDirOut() {
        return this.arrowDirOut;
    }

    public void setArrowDirOut(boolean newVal) {
        if (this.arrowDirOut != newVal) {
            this.arrowDirOut = newVal;
            if (!this.arrowDirIn && !this.arrowDirOut) {
                this.arrowStyle = 0;
            } else if (this.arrowStyle == 0) {
                this.arrowStyle = 1;
            }
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(Color newVal) {
        if (this.arrowColor != newVal) {
            this.arrowColor = newVal;
            JmriColorChooser.addRecentColor(newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getArrowLineWidth() {
        return this.arrowLineWidth;
    }

    public void setArrowLineWidth(int newVal) {
        if (this.arrowLineWidth != newVal) {
            this.arrowLineWidth = MathUtil.pin(newVal, 1, 5);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(int newVal) {
        if (this.arrowLength != newVal) {
            this.arrowLength = MathUtil.pin(newVal, 2, 60);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getArrowGap() {
        return this.arrowGap;
    }

    public void setArrowGap(int newVal) {
        if (this.arrowGap != newVal) {
            this.arrowGap = MathUtil.pin(newVal, 0, 40);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isBridgeSideRight() {
        return this.bridgeSideRight;
    }

    public void setBridgeSideRight(boolean newVal) {
        if (this.bridgeSideRight != newVal) {
            this.bridgeSideRight = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isBridgeSideLeft() {
        return this.bridgeSideLeft;
    }

    public void setBridgeSideLeft(boolean newVal) {
        if (this.bridgeSideLeft != newVal) {
            this.bridgeSideLeft = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isBridgeHasEntry() {
        return this.bridgeHasEntry;
    }

    public void setBridgeHasEntry(boolean newVal) {
        if (this.bridgeHasEntry != newVal) {
            this.bridgeHasEntry = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isBridgeHasExit() {
        return this.bridgeHasExit;
    }

    public void setBridgeHasExit(boolean newVal) {
        if (this.bridgeHasExit != newVal) {
            this.bridgeHasExit = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public Color getBridgeColor() {
        return this.bridgeColor;
    }

    public void setBridgeColor(Color newVal) {
        if (this.bridgeColor != newVal) {
            this.bridgeColor = newVal;
            JmriColorChooser.addRecentColor(newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getBridgeDeckWidth() {
        return this.bridgeDeckWidth;
    }

    public void setBridgeDeckWidth(int newVal) {
        if (this.bridgeDeckWidth != newVal) {
            this.bridgeDeckWidth = Math.max(6, newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getBridgeLineWidth() {
        return this.bridgeLineWidth;
    }

    public void setBridgeLineWidth(int newVal) {
        if (this.bridgeLineWidth != newVal) {
            this.bridgeLineWidth = Math.max(1, newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getBridgeApproachWidth() {
        return this.bridgeApproachWidth;
    }

    public void setBridgeApproachWidth(int newVal) {
        if (this.bridgeApproachWidth != newVal) {
            this.bridgeApproachWidth = Math.max(8, newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isBumperEndStart() {
        return this.bumperEndStart;
    }

    public void setBumperEndStart(boolean newVal) {
        if (this.bumperEndStart != newVal) {
            this.bumperEndStart = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isBumperEndStop() {
        return this.bumperEndStop;
    }

    public void setBumperEndStop(boolean newVal) {
        if (this.bumperEndStop != newVal) {
            this.bumperEndStop = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public Color getBumperColor() {
        return this.bumperColor;
    }

    public void setBumperColor(Color newVal) {
        if (this.bumperColor != newVal) {
            this.bumperColor = newVal;
            JmriColorChooser.addRecentColor(newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getBumperLineWidth() {
        return this.bumperLineWidth;
    }

    public void setBumperLineWidth(int newVal) {
        if (this.bumperLineWidth != newVal) {
            this.bumperLineWidth = MathUtil.pin(newVal, 1, 9);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getBumperLength() {
        return this.bumperLength;
    }

    public void setBumperLength(int newVal) {
        if (this.bumperLength != newVal) {
            this.bumperLength = Math.max(8, newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isBumperFlipped() {
        return this.bumperFlipped;
    }

    public void setBumperFlipped(boolean newVal) {
        if (this.bumperFlipped != newVal) {
            this.bumperFlipped = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    private void setupDefaultBumperSizes(@Nonnull LayoutEditor layoutEditor) {
        LayoutTrackDrawingOptions ltdo = layoutEditor.getLayoutTrackDrawingOptions();
        int tieLength = ltdo.getSideTieLength();
        int tieWidth = ltdo.getSideTieWidth();
        int railWidth = ltdo.getSideRailWidth();
        int railGap = ltdo.getSideRailGap();
        if (this.trackSegment.isMainline()) {
            tieLength = ltdo.getMainTieLength();
            tieWidth = ltdo.getMainTieWidth();
            railWidth = ltdo.getMainRailWidth();
            railGap = ltdo.getMainRailGap();
        }
        this.bumperLineWidth = Math.max(railWidth, ltdo.getMainBlockLineWidth()) * 2;
        this.bumperLength = railGap + 2 * railWidth;
        if (tieLength > 0 && tieWidth > 0) {
            this.bumperLineWidth = tieWidth;
            this.bumperLength = tieLength * 3 / 2;
        }
        this.bumperLineWidth = Math.max(1, this.bumperLineWidth);
        this.bumperLength = Math.max(8, this.bumperLength);
    }

    public boolean isTunnelSideRight() {
        return this.tunnelSideRight;
    }

    public void setTunnelSideRight(boolean newVal) {
        if (this.tunnelSideRight != newVal) {
            this.tunnelSideRight = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isTunnelSideLeft() {
        return this.tunnelSideLeft;
    }

    public void setTunnelSideLeft(boolean newVal) {
        if (this.tunnelSideLeft != newVal) {
            this.tunnelSideLeft = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isTunnelHasEntry() {
        return this.tunnelHasEntry;
    }

    public void setTunnelHasEntry(boolean newVal) {
        if (this.tunnelHasEntry != newVal) {
            this.tunnelHasEntry = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public boolean isTunnelHasExit() {
        return this.tunnelHasExit;
    }

    public void setTunnelHasExit(boolean newVal) {
        if (this.tunnelHasExit != newVal) {
            this.tunnelHasExit = newVal;
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public Color getTunnelColor() {
        return this.tunnelColor;
    }

    public void setTunnelColor(Color newVal) {
        if (this.tunnelColor != newVal) {
            this.tunnelColor = newVal;
            JmriColorChooser.addRecentColor(newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getTunnelFloorWidth() {
        return this.tunnelFloorWidth;
    }

    public void setTunnelFloorWidth(int newVal) {
        if (this.tunnelFloorWidth != newVal) {
            this.tunnelFloorWidth = Math.max(4, newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getTunnelLineWidth() {
        return this.tunnelLineWidth;
    }

    public void setTunnelLineWidth(int newVal) {
        if (this.tunnelLineWidth != newVal) {
            this.tunnelLineWidth = Math.max(1, newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    public int getTunnelEntranceWidth() {
        return this.tunnelEntranceWidth;
    }

    public void setTunnelEntranceWidth(int newVal) {
        if (this.tunnelEntranceWidth != newVal) {
            this.tunnelEntranceWidth = Math.max(1, newVal);
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    @Override
    @Nonnull
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        return this.trackSegment.getLayoutConnectivity();
    }

    @Override
    @Nonnull
    public List<HitPointType> checkForFreeConnections() {
        return new ArrayList<HitPointType>();
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        return this.getLayoutBlock() != null;
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        List<Set<String>> TrackNameSets = null;
        LinkedHashSet<String> TrackNameSet = null;
        String blockName = this.getBlockName();
        if (!blockName.isEmpty()) {
            TrackNameSets = blockNamesToTrackNameSetsMap.get(blockName);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block (''{}'') trackNameSets", (Object)blockName);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(blockName, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet<String>();
                TrackNameSets.add(TrackNameSet);
            }
            if (TrackNameSet.add(this.getName())) {
                log.debug("*    Add track ''{}'' to TrackNameSets for block ''{}''", (Object)this.getName(), (Object)blockName);
            }
            if (this.getConnect1() != null) {
                this.getConnect1().collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
            if (this.getConnect2() != null) {
                this.getConnect2().collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
        }
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        if (!TrackNameSet.contains(this.getName()) && this.getBlockName().equals(blockName)) {
            if (TrackNameSet.add(this.getName())) {
                log.debug("*    Add track ''{}''for block ''{}''", (Object)this.getName(), (Object)blockName);
            }
            if (this.getConnect1() != null) {
                this.getConnect1().collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
            if (this.getConnect2() != null) {
                this.getConnect2().collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
        }
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
        this.setLayoutBlock(layoutBlock);
    }
}

