/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.blockRoutingTable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Path;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutBlockNeighbourTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int NEIGHBOURCOL = 0;
    static final int DIRECTIONCOL = 1;
    static final int MUTUALCOL = 2;
    static final int RELATCOL = 3;
    static final int METRICCOL = 4;
    static final int NUMCOL = 5;
    boolean editable = false;
    private LayoutBlock lBlock = null;
    private static final Logger log = LoggerFactory.getLogger(LayoutBlockNeighbourTableModel.class);

    public LayoutBlockNeighbourTableModel(boolean editable, LayoutBlock lBlock) {
        this.editable = editable;
        this.lBlock = lBlock;
        lBlock.addPropertyChangeListener(this);
    }

    @Override
    public int getRowCount() {
        return this.lBlock.getNumberOfNeighbours();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Neighbour");
            }
            case 1: {
                return Bundle.getMessage("Direction");
            }
            case 2: {
                return Bundle.getMessage("Mutual");
            }
            case 3: {
                return Bundle.getMessage("TrafficFlow");
            }
            case 4: {
                return Bundle.getMessage("Metric");
            }
        }
        return "<UNKNOWN>";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 4) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("length")) {
            this.fireTableDataChanged();
        } else if (this.matchPropertyName(e)) {
            int row = (Integer)e.getNewValue();
            this.fireTableRowsUpdated(row, row);
        }
    }

    protected boolean matchPropertyName(PropertyChangeEvent e) {
        return e.getPropertyName().contains("neighbourmetric") || e.getPropertyName().contains("neighbourpacketflow");
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.lBlock == null) {
            log.debug("layout Block is null!");
            return "Error";
        }
        switch (col) {
            case 0: {
                return this.lBlock.getNeighbourAtIndex(row).getDisplayName();
            }
            case 2: {
                Boolean mutual = this.lBlock.isNeighbourMutual(row);
                if (mutual.booleanValue()) {
                    return Bundle.getMessage("ButtonYes");
                }
                return Bundle.getMessage("ButtonNo");
            }
            case 1: {
                return Path.decodeDirection(this.lBlock.getNeighbourDirection(row));
            }
            case 4: {
                return this.lBlock.getNeighbourMetric(row);
            }
            case 3: {
                return this.lBlock.getNeighbourPacketFlowAsString(row);
            }
        }
        return "<UNKNOWN>";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public int getPreferredWidth(int column) {
        int retval = 20;
        retval = Math.max(retval, new JLabel((String)this.getColumnName((int)column)).getPreferredSize().width + 15);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (this.getColumnClass(column).equals(String.class)) {
                retval = Math.max(retval, new JLabel((String)this.getValueAt((int)row, (int)column).toString()).getPreferredSize().width);
                continue;
            }
            if (!this.getColumnClass(column).equals(Integer.class)) continue;
            retval = Math.max(retval, new JLabel((String)this.getValueAt((int)row, (int)column).toString()).getPreferredSize().width);
        }
        return retval + 5;
    }

    public void dispose() {
    }

    public Manager<LayoutBlock> getManager() {
        return InstanceManager.getDefault(LayoutBlockManager.class);
    }
}

