/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.blockRoutingTable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Path;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutBlockRouteTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int DESTCOL = 0;
    static final int NEXTHOPCOL = 1;
    static final int HOPCOUNTCOL = 2;
    static final int DIRECTIONCOL = 3;
    static final int METRICCOL = 4;
    static final int LENGTHCOL = 5;
    static final int STATECOL = 6;
    static final int VALIDCOL = 7;
    static final int NUMCOL = 8;
    boolean editable = false;
    private LayoutBlock lBlock = null;
    private static final Logger log = LoggerFactory.getLogger(LayoutBlockRouteTableModel.class);

    public LayoutBlockRouteTableModel(boolean editable, LayoutBlock lBlock) {
        this.editable = editable;
        this.lBlock = lBlock;
        lBlock.addPropertyChangeListener(this);
    }

    @Override
    public int getRowCount() {
        return this.lBlock.getNumberOfRoutes();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Destination");
            }
            case 1: {
                return Bundle.getMessage("NextHop");
            }
            case 2: {
                return Bundle.getMessage("HopCount");
            }
            case 3: {
                return Bundle.getMessage("Direction");
            }
            case 4: {
                return Bundle.getMessage("Metric");
            }
            case 5: {
                return Bundle.getMessage("Length");
            }
            case 6: {
                return Bundle.getMessage("State");
            }
            case 7: {
                return Bundle.getMessage("Valid");
            }
        }
        return "<UNKNOWN>";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 2) {
            return Integer.class;
        }
        if (col == 4) {
            return Integer.class;
        }
        if (col == 5) {
            return Float.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("length")) {
            this.fireTableDataChanged();
        } else if (e.getPropertyName().equals("routing")) {
            this.fireTableDataChanged();
        } else if (this.matchPropertyName(e)) {
            int row = (Integer)e.getNewValue();
            this.fireTableRowsUpdated(row, row);
        }
    }

    protected boolean matchPropertyName(PropertyChangeEvent e) {
        return e.getPropertyName().contains("state") || e.getPropertyName().contains("hop") || e.getPropertyName().contains("metric") || e.getPropertyName().contains("valid") || e.getPropertyName().contains("neighbourmetric");
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.lBlock == null) {
            log.debug("layout Block is null!");
            return "Error";
        }
        switch (col) {
            case 0: {
                return this.lBlock.getRouteDestBlockAtIndex(row).getDisplayName();
            }
            case 1: {
                String nextBlock = this.lBlock.getRouteNextBlockAtIndex(row).getDisplayName();
                if (nextBlock.equals(this.lBlock.getDisplayName())) {
                    nextBlock = Bundle.getMessage("DirectConnect");
                }
                return nextBlock;
            }
            case 2: {
                return this.lBlock.getRouteHopCountAtIndex(row);
            }
            case 3: {
                return Path.decodeDirection(this.lBlock.getRouteDirectionAtIndex(row));
            }
            case 4: {
                return this.lBlock.getRouteMetric(row);
            }
            case 5: {
                return Float.valueOf(this.lBlock.getRouteLengthAtIndex(row));
            }
            case 6: {
                return this.lBlock.getRouteStateAsString(row);
            }
            case 7: {
                String value = "";
                if (this.lBlock.getRouteValid(row)) {
                    value = "*";
                }
                return value;
            }
        }
        return "<UNKNOWN>";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public int getPreferredWidth(int column) {
        int retval = 20;
        retval = Math.max(retval, new JLabel((String)this.getColumnName((int)column)).getPreferredSize().width + 15);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (this.getColumnClass(column).equals(String.class)) {
                retval = Math.max(retval, new JLabel((String)this.getValueAt((int)row, (int)column).toString()).getPreferredSize().width);
                continue;
            }
            if (!this.getColumnClass(column).equals(Integer.class)) continue;
            retval = Math.max(retval, new JLabel((String)this.getValueAt((int)row, (int)column).toString()).getPreferredSize().width);
        }
        return retval + 5;
    }

    public void dispose() {
    }

    public Manager<LayoutBlock> getManager() {
        return InstanceManager.getDefault(LayoutBlockManager.class);
    }
}

