/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.Color;
import java.util.List;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.Sensor;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.ColorUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutBlockManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(LayoutBlockManagerXml.class);

    @Override
    public Element store(Object o) {
        NamedBeanHandle<Sensor> tmStable;
        Element layoutblocks = new Element("layoutblocks");
        this.setStoreElementClass(layoutblocks);
        LayoutBlockManager tm = (LayoutBlockManager)o;
        if (tm.isAdvancedRoutingEnabled()) {
            layoutblocks.setAttribute("blockrouting", "yes");
        }
        if ((tmStable = tm.getNamedStabilisedSensor()) != null) {
            layoutblocks.setAttribute("routingStablisedSensor", tmStable.getName());
        }
        if (tm.getNamedBeanSet().isEmpty()) {
            return null;
        }
        for (LayoutBlock b : tm.getNamedBeanSet()) {
            if (b == null || b.getUseCount() <= 0) continue;
            Element elem = new Element("layoutblock").setAttribute("systemName", b.getSystemName());
            elem.addContent((Content)new Element("systemName").addContent(b.getSystemName()));
            this.storeCommon(b, elem);
            if (!b.getOccupancySensorName().isEmpty()) {
                elem.setAttribute("occupancysensor", b.getOccupancySensorName());
            }
            elem.setAttribute("occupiedsense", "" + b.getOccupiedSense());
            elem.setAttribute("trackcolor", ColorUtil.colorToColorName(b.getBlockTrackColor()));
            elem.setAttribute("occupiedcolor", ColorUtil.colorToColorName(b.getBlockOccupiedColor()));
            elem.setAttribute("extracolor", ColorUtil.colorToColorName(b.getBlockExtraColor()));
            if (!b.getMemoryName().isEmpty()) {
                elem.setAttribute("memory", b.getMemoryName());
            }
            if (!b.useDefaultMetric()) {
                elem.addContent((Content)new Element("metric").addContent("" + b.getBlockMetric()));
            }
            layoutblocks.addContent((Content)elem);
        }
        return layoutblocks;
    }

    public void setStoreElementClass(Element layoutblocks) {
        layoutblocks.setAttribute("class", this.getClass().getName());
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        this.replaceLayoutBlockManager();
        this.loadLayoutBlocks(shared);
        return true;
    }

    public void loadLayoutBlocks(Element layoutblocks) {
        LayoutBlockManager tm = InstanceManager.getDefault(LayoutBlockManager.class);
        try {
            tm.enableAdvancedRouting(layoutblocks.getAttribute("blockrouting").getBooleanValue());
        }
        catch (DataConversionException e1) {
            log.warn("unable to convert layout block manager blockrouting attribute");
        }
        catch (NullPointerException e1) {
            // empty catch block
        }
        if (layoutblocks.getAttribute("routingStablisedSensor") != null) {
            try {
                tm.setStabilisedSensor(layoutblocks.getAttribute("routingStablisedSensor").getValue());
            }
            catch (JmriException e1) {
                // empty catch block
            }
        }
        List layoutblockList = layoutblocks.getChildren("layoutblock");
        if (log.isDebugEnabled()) {
            log.debug("Found {} layoutblocks", (Object)layoutblockList.size());
        }
        for (Element e : layoutblockList) {
            Color color;
            String sysName = this.getSystemName(e);
            if (sysName == null) {
                log.warn("unexpected null in systemName {} {}", (Object)e, (Object)e.getAttributes());
                break;
            }
            String userName = this.getUserName(e);
            LayoutBlock b = tm.createNewLayoutBlock(sysName, userName);
            this.loadCommon(b, e);
            if (b == null) continue;
            try {
                color = ColorUtil.stringToColor(e.getAttribute("trackcolor").getValue());
                b.setBlockTrackColor(color);
            }
            catch (IllegalArgumentException ex) {
                b.setBlockTrackColor(Color.darkGray);
                log.error("Invalid trackcolor '{}'; using 'darkGray'", (Object)e.getAttribute("trackcolor").getValue());
            }
            try {
                color = ColorUtil.stringToColor(e.getAttribute("occupiedcolor").getValue());
                b.setBlockOccupiedColor(color);
            }
            catch (IllegalArgumentException ex) {
                b.setBlockOccupiedColor(Color.red);
                log.error("Invalid occupiedcolor '{}'; using 'red'", (Object)e.getAttribute("occupiedcolor").getValue());
            }
            Attribute a = e.getAttribute("extracolor");
            if (a != null) {
                try {
                    b.setBlockExtraColor(ColorUtil.stringToColor(a.getValue()));
                }
                catch (IllegalArgumentException ex) {
                    b.setBlockExtraColor(Color.white);
                    log.error("Invalid extracolor '{}'; using 'white'", (Object)e.getAttribute("extracolor").getValue());
                }
            }
            if ((a = e.getAttribute("occupancysensor")) != null) {
                b.setOccupancySensorName(a.getValue());
            }
            if ((a = e.getAttribute("memory")) != null) {
                b.setMemoryName(a.getValue());
            }
            a = e.getAttribute("occupancysensorsense");
            int sense = 2;
            try {
                sense = e.getAttribute("occupiedsense").getIntValue();
            }
            catch (DataConversionException ex) {
                log.error("failed to convert occupiedsense attribute");
            }
            b.setOccupiedSense(sense);
            if (e.getChild("metric") == null) continue;
            String stMetric = e.getChild("metric").getText();
            try {
                b.setBlockMetric(Integer.parseInt(stMetric));
            }
            catch (NumberFormatException ex) {
                log.error("failed to convert metric attribute for block {}", (Object)b.getDisplayName());
            }
        }
    }

    protected void replaceLayoutBlockManager() {
        if (InstanceManager.getDefault(LayoutBlockManager.class).getClass().getName().equals(LayoutBlockManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(LayoutBlockManager.class) != null) {
            InstanceManager.getDefault(ConfigureManager.class).deregister(InstanceManager.getDefault(LayoutBlockManager.class));
        }
        LayoutBlockManager pManager = InstanceManager.getDefault(LayoutBlockManager.class);
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerConfig(pManager, 120);
        }
    }
}

