/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JFrame;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.TransitManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutShape;
import jmri.jmrit.display.layoutEditor.LayoutSlipView;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackDrawingOptions;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.configurexml.Bundle;
import jmri.util.ColorUtil;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutEditorXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(LayoutEditorXml.class);

    @Override
    public Element store(Object o) {
        LayoutEditor p = (LayoutEditor)o;
        Element panel = new Element("LayoutEditor");
        panel.setAttribute("class", this.getClass().getName());
        panel.setAttribute("name", p.getLayoutName());
        if (InstanceManager.getDefault(GuiLafPreferencesManager.class).isEditorUseOldLocSize()) {
            panel.setAttribute("x", "" + p.gContext.getUpperLeftX());
            panel.setAttribute("y", "" + p.gContext.getUpperLeftY());
            panel.setAttribute("windowheight", "" + p.gContext.getWindowHeight());
            panel.setAttribute("windowwidth", "" + p.gContext.getWindowWidth());
        } else {
            Point loc = p.getLocation();
            panel.setAttribute("x", "" + loc.x);
            panel.setAttribute("y", "" + loc.y);
            Dimension size = p.getSize();
            panel.setAttribute("windowheight", "" + size.height);
            panel.setAttribute("windowwidth", "" + size.width);
        }
        panel.setAttribute("panelheight", "" + p.gContext.getLayoutHeight());
        panel.setAttribute("panelwidth", "" + p.gContext.getLayoutWidth());
        panel.setAttribute("sliders", p.getScroll() ? "yes" : "no");
        panel.setAttribute("scrollable", p.getScrollable());
        panel.setAttribute("editable", p.isEditable() ? "yes" : "no");
        panel.setAttribute("positionable", p.allPositionable() ? "yes" : "no");
        panel.setAttribute("controlling", p.allControlling() ? "yes" : "no");
        panel.setAttribute("animating", p.isAnimating() ? "yes" : "no");
        panel.setAttribute("showhelpbar", p.getShowHelpBar() ? "yes" : "no");
        panel.setAttribute("drawgrid", p.getDrawGrid() ? "yes" : "no");
        panel.setAttribute("snaponadd", p.getSnapOnAdd() ? "yes" : "no");
        panel.setAttribute("snaponmove", p.getSnapOnMove() ? "yes" : "no");
        panel.setAttribute("antialiasing", p.getAntialiasingOn() ? "yes" : "no");
        panel.setAttribute("turnoutcircles", p.getTurnoutCircles() ? "yes" : "no");
        panel.setAttribute("tooltipsnotedit", p.getTooltipsNotEdit() ? "yes" : "no");
        panel.setAttribute("tooltipsinedit", p.getTooltipsInEdit() ? "yes" : "no");
        panel.setAttribute("mainlinetrackwidth", "" + p.gContext.getMainlineBlockWidth());
        panel.setAttribute("xscale", Float.toString((float)p.gContext.getXScale()));
        panel.setAttribute("yscale", Float.toString((float)p.gContext.getYScale()));
        panel.setAttribute("sidetrackwidth", "" + p.gContext.getSidelineBlockWidth());
        panel.setAttribute("defaulttrackcolor", p.getDefaultTrackColor());
        panel.setAttribute("defaultoccupiedtrackcolor", p.getDefaultOccupiedTrackColor());
        panel.setAttribute("defaultalternativetrackcolor", p.getDefaultAlternativeTrackColor());
        panel.setAttribute("defaulttextcolor", p.getDefaultTextColor());
        String turnoutCircleColor = p.getTurnoutCircleColor();
        panel.setAttribute("turnoutcirclecolor", turnoutCircleColor);
        String turnoutCircleThrownColor = p.getTurnoutCircleThrownColor();
        if (!turnoutCircleColor.equals(turnoutCircleThrownColor)) {
            panel.setAttribute("turnoutcirclethrowncolor", turnoutCircleThrownColor);
        }
        if (p.isTurnoutFillControlCircles()) {
            panel.setAttribute("turnoutfillcontrolcircles", "yes");
        }
        panel.setAttribute("turnoutcirclesize", "" + p.getTurnoutCircleSize());
        panel.setAttribute("turnoutdrawunselectedleg", p.isTurnoutDrawUnselectedLeg() ? "yes" : "no");
        panel.setAttribute("turnoutbx", Float.toString((float)p.getTurnoutBX()));
        panel.setAttribute("turnoutcx", Float.toString((float)p.getTurnoutCX()));
        panel.setAttribute("turnoutwid", Float.toString((float)p.getTurnoutWid()));
        panel.setAttribute("xoverlong", Float.toString((float)p.getXOverLong()));
        panel.setAttribute("xoverhwid", Float.toString((float)p.getXOverHWid()));
        panel.setAttribute("xovershort", Float.toString((float)p.getXOverShort()));
        panel.setAttribute("autoblkgenerate", p.getAutoBlockAssignment() ? "yes" : "no");
        if (p.getBackgroundColor() != null) {
            panel.setAttribute("redBackground", "" + p.getBackgroundColor().getRed());
            panel.setAttribute("greenBackground", "" + p.getBackgroundColor().getGreen());
            panel.setAttribute("blueBackground", "" + p.getBackgroundColor().getBlue());
        }
        panel.setAttribute("gridSize", "" + p.gContext.getGridSize());
        panel.setAttribute("gridSize2nd", "" + p.gContext.getGridSize2nd());
        p.resetDirty();
        panel.setAttribute("openDispatcher", p.getOpenDispatcherOnLoad() ? "yes" : "no");
        panel.setAttribute("useDirectTurnoutControl", p.getDirectTurnoutControl() ? "yes" : "no");
        if (p.isHighlightCursor()) {
            panel.setAttribute("highlightCursor", "yes");
        }
        try {
            LayoutTrackDrawingOptions ltdo = p.getLayoutTrackDrawingOptions();
            Element e = ConfigXmlManager.elementFromObject(ltdo);
            if (e != null) {
                panel.addContent((Content)e);
            }
        }
        catch (Exception e) {
            log.error("Error storing contents element: ", (Throwable)e);
        }
        List<Positionable> contents = p.getContents();
        for (Positionable sub : contents) {
            if (sub != null && sub.storeItem()) {
                try {
                    Element element = ConfigXmlManager.elementFromObject(sub);
                    if (element == null) continue;
                    panel.addContent((Content)element);
                }
                catch (Exception exception) {
                    log.error("Error storing contents element: ", (Throwable)exception);
                }
                continue;
            }
            log.warn("Null entry found when storing panel contents.");
        }
        List<LayoutTrack> layoutTracks = p.getLayoutTracks();
        int num = layoutTracks.size();
        if (log.isDebugEnabled()) {
            log.debug("N LayoutTrack elements: {}", (Object)num);
        }
        for (LayoutTrackView layoutTrackView : p.getLayoutTurnoutViews()) {
            if (layoutTrackView instanceof LayoutSlipView) continue;
            this.storeOne(panel, layoutTrackView);
        }
        for (LayoutTrackView layoutTrackView : p.getTrackSegmentViews()) {
            this.storeOne(panel, layoutTrackView);
        }
        for (LayoutTrackView layoutTrackView : p.getPositionablePointViews()) {
            this.storeOne(panel, layoutTrackView);
        }
        for (LayoutTrackView layoutTrackView : p.getLevelXingViews()) {
            this.storeOne(panel, layoutTrackView);
        }
        for (LayoutTrackView layoutTrackView : p.getLayoutSlipViews()) {
            this.storeOne(panel, layoutTrackView);
        }
        for (LayoutTrackView layoutTrackView : p.getLayoutTurntableViews()) {
            this.storeOne(panel, layoutTrackView);
        }
        for (LayoutShape layoutShape : p.getLayoutShapes()) {
            this.storeOne(panel, layoutShape);
        }
        return panel;
    }

    private void storeOne(Element panel, Object item) {
        try {
            Element e = ConfigXmlManager.elementFromObject(item);
            if (e != null) {
                panel.addContent((Content)e);
            }
        }
        catch (Exception ex) {
            log.error("Error storing layout item: {}", item, (Object)ex);
        }
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        UserPreferencesManager prefsMgr;
        Attribute a;
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        boolean result = true;
        int x = 0;
        int y = 0;
        int windowHeight = 400;
        int windowWidth = 300;
        int panelHeight = 340;
        int panelWidth = 280;
        int sidetrackwidth = 3;
        int mainlinetrackwidth = 3;
        try {
            a = shared.getAttribute("x");
            if (a != null) {
                x = a.getIntValue();
            }
            if ((a = shared.getAttribute("y")) != null) {
                y = a.getIntValue();
            }
            if ((a = shared.getAttribute("height")) != null) {
                windowHeight = a.getIntValue();
                panelHeight = windowHeight - 60;
            }
            if ((a = shared.getAttribute("width")) != null) {
                windowWidth = a.getIntValue();
                panelWidth = windowWidth - 18;
            }
            if ((a = shared.getAttribute("windowheight")) != null) {
                windowHeight = a.getIntValue();
            }
            if ((a = shared.getAttribute("windowwidth")) != null) {
                windowWidth = a.getIntValue();
            }
            if ((a = shared.getAttribute("panelheight")) != null) {
                panelHeight = a.getIntValue();
            }
            if ((a = shared.getAttribute("panelwidth")) != null) {
                panelWidth = a.getIntValue();
            }
            mainlinetrackwidth = shared.getAttribute("mainlinetrackwidth").getIntValue();
            sidetrackwidth = shared.getAttribute("sidetrackwidth").getIntValue();
        }
        catch (DataConversionException e) {
            log.error("failed to convert LayoutEditor attribute");
            result = false;
        }
        double xScale = 1.0;
        double yScale = 1.0;
        a = shared.getAttribute("xscale");
        if (a != null) {
            try {
                xScale = Float.parseFloat(a.getValue());
            }
            catch (NumberFormatException e) {
                log.error("failed to convert xscale attribute to float - {}", (Object)a.getValue());
                result = false;
            }
        }
        if ((a = shared.getAttribute("yscale")) != null) {
            try {
                yScale = Float.parseFloat(a.getValue());
            }
            catch (NumberFormatException e) {
                log.error("failed to convert yscale attribute to float - {}", (Object)a.getValue());
                result = false;
            }
        }
        String name = "";
        a = shared.getAttribute("name");
        if (a != null) {
            name = a.getValue();
        }
        if (InstanceManager.getDefault(EditorManager.class).contains(name)) {
            JFrame frame = new JFrame("DialogDemo");
            frame.setDefaultCloseOperation(2);
            log.warn("File contains a panel with the same name ({}) as an existing panel", (Object)name);
            int n = JmriJOptionPane.showConfirmDialog(frame, Bundle.getMessage("DuplicatePanel", name), Bundle.getMessage("DuplicatePanelTitle"), 0);
            if (n != 0) {
                return false;
            }
        }
        if (!InstanceManager.getDefault(GuiLafPreferencesManager.class).isEditorUseOldLocSize() && (prefsMgr = InstanceManager.getNullableDefault(UserPreferencesManager.class)) != null) {
            Dimension prefsWindowSize;
            String windowFrameRef = "jmri.jmrit.display.layoutEditor.LayoutEditor:" + name;
            Point prefsWindowLocation = prefsMgr.getWindowLocation(windowFrameRef);
            if (prefsWindowLocation != null) {
                x = (int)prefsWindowLocation.getX();
                y = (int)prefsWindowLocation.getY();
            }
            if ((prefsWindowSize = prefsMgr.getWindowSize(windowFrameRef)) != null && prefsWindowSize.getHeight() != 0.0 && prefsWindowSize.getWidth() != 0.0) {
                windowHeight = (int)prefsWindowSize.getHeight();
                windowWidth = (int)prefsWindowSize.getWidth();
            }
        }
        LayoutEditor panel = new LayoutEditor(name);
        panel.setLayoutName(name);
        InstanceManager.getDefault(EditorManager.class).add(panel);
        panel.gContext.setMainlineTrackWidth(mainlinetrackwidth);
        panel.gContext.setSidelineTrackWidth(sidetrackwidth);
        panel.gContext.setXScale(xScale);
        panel.gContext.setYScale(yScale);
        String color = "darkGray";
        try {
            a = shared.getAttribute("defaulttrackcolor");
            if (a != null) {
                color = a.getValue();
            }
            panel.setDefaultTrackColor(ColorUtil.stringToColor(color));
        }
        catch (IllegalArgumentException e) {
            panel.setDefaultTrackColor(Color.BLACK);
            log.error("Invalid defaulttrackcolor {}; using black", (Object)color);
        }
        color = "black";
        try {
            a = shared.getAttribute("defaulttextcolor");
            if (a != null) {
                color = a.getValue();
            }
            panel.setDefaultTextColor(ColorUtil.stringToColor(color));
        }
        catch (IllegalArgumentException e) {
            panel.setDefaultTextColor(Color.BLACK);
            log.error("Invalid defaulttextcolor {}; using black", (Object)color);
        }
        color = "track";
        try {
            a = shared.getAttribute("turnoutcirclecolor");
            if (a != null) {
                color = a.getValue();
            }
            panel.setTurnoutCircleColor(ColorUtil.stringToColor(color));
        }
        catch (IllegalArgumentException e) {
            panel.setTurnoutCircleColor(Color.BLACK);
            log.error("Invalid color {}; using black", (Object)color);
        }
        try {
            a = shared.getAttribute("turnoutcirclethrowncolor");
            if (a != null) {
                color = a.getValue();
            }
            panel.setTurnoutCircleThrownColor(ColorUtil.stringToColor(color));
        }
        catch (IllegalArgumentException e) {
            panel.setTurnoutCircleThrownColor(Color.BLACK);
            log.error("Invalid color {}; using black", (Object)color);
        }
        try {
            panel.setTurnoutFillControlCircles(shared.getAttribute("turnoutfillcontrolcircles").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert turnoutfillcontrolcircles attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing turnoutfillcontrolcircles attribute");
        }
        a = shared.getAttribute("turnoutcirclesize");
        if (a != null) {
            try {
                panel.setTurnoutCircleSize(a.getIntValue());
            }
            catch (DataConversionException e) {
                log.warn("unable to convert turnoutcirclesize");
            }
        }
        try {
            panel.setTurnoutDrawUnselectedLeg(shared.getAttribute("turnoutdrawunselectedleg").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert turnoutdrawunselectedleg attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing turnoutdrawunselectedleg attribute");
        }
        a = shared.getAttribute("turnoutbx");
        if (a != null) {
            try {
                panel.setTurnoutBX(Float.parseFloat(a.getValue()));
            }
            catch (NumberFormatException e) {
                log.error("failed to convert turnoutbx to float - {}", (Object)a.getValue());
                result = false;
            }
        }
        if ((a = shared.getAttribute("turnoutcx")) != null) {
            try {
                panel.setTurnoutCX(Float.parseFloat(a.getValue()));
            }
            catch (NumberFormatException e) {
                log.error("failed to convert turnoutcx to float - {}", (Object)a.getValue());
                result = false;
            }
        }
        if ((a = shared.getAttribute("turnoutwid")) != null) {
            try {
                panel.setTurnoutWid(Float.parseFloat(a.getValue()));
            }
            catch (NumberFormatException e) {
                log.error("failed to convert turnoutwid to float - {}", (Object)a.getValue());
                result = false;
            }
        }
        if ((a = shared.getAttribute("xoverlong")) != null) {
            try {
                panel.setXOverLong(Float.parseFloat(a.getValue()));
            }
            catch (NumberFormatException e) {
                log.error("failed to convert xoverlong to float - {}", (Object)a.getValue());
                result = false;
            }
        }
        if ((a = shared.getAttribute("xoverhwid")) != null) {
            try {
                panel.setXOverHWid(Float.parseFloat(a.getValue()));
            }
            catch (NumberFormatException e) {
                log.error("failed to convert xoverhwid to float - {}", (Object)a.getValue());
                result = false;
            }
        }
        if ((a = shared.getAttribute("xovershort")) != null) {
            try {
                panel.setXOverShort(Float.parseFloat(a.getValue()));
            }
            catch (NumberFormatException e) {
                log.error("failed to convert xovershort to float - {}", (Object)a.getValue());
                result = false;
            }
        }
        if ((a = shared.getAttribute("gridSize")) != null) {
            try {
                panel.gContext.setGridSize(Integer.parseInt(a.getValue()));
            }
            catch (NumberFormatException e) {
                log.error("failed to convert gridSize to int - {}", (Object)a.getValue());
                result = false;
            }
        }
        if ((a = shared.getAttribute("gridSize2nd")) != null) {
            try {
                panel.gContext.setGridSize2nd(Integer.parseInt(a.getValue()));
            }
            catch (NumberFormatException e) {
                log.error("failed to convert gridSize2nd to int - {}", (Object)a.getValue());
                result = false;
            }
        }
        try {
            panel.setAllPositionable(shared.getAttribute("positionable").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert positionable attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing positionable attribute");
        }
        try {
            panel.setAllControlling(shared.getAttribute("controlling").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert controlling attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing controlling attribute");
        }
        try {
            panel.setTurnoutAnimation(shared.getAttribute("animating").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert animating attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing animating attribute");
        }
        try {
            panel.setDrawGrid(shared.getAttribute("drawgrid").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert drawgrid attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing drawgrid attribute");
        }
        try {
            panel.setSnapOnAdd(shared.getAttribute("snaponadd").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert snaponadd attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing snaponadd attribute");
        }
        try {
            panel.setSnapOnMove(shared.getAttribute("snaponmove").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert snaponmove attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing snaponmove attribute");
        }
        try {
            panel.setTurnoutCircles(shared.getAttribute("turnoutcircles").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert turnoutcircles attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing turnoutcircles attribute");
        }
        try {
            panel.setTooltipsNotEdit(shared.getAttribute("tooltipsnotedit").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert tooltipsnotedit attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing tooltipsnotedit attribute");
        }
        try {
            panel.setAutoBlockAssignment(shared.getAttribute("autoblkgenerate").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert autoblkgenerate attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing autoblkgenerate attribute");
        }
        try {
            panel.setTooltipsInEdit(shared.getAttribute("tooltipsinedit").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert tooltipsinedit attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing tooltipsinedit attribute");
        }
        a = shared.getAttribute("defaulttrackcolor");
        if (a != null) {
            try {
                panel.setDefaultTrackColor(ColorUtil.stringToColor(a.getValue()));
            }
            catch (IllegalArgumentException e) {
                panel.setDefaultTrackColor(Color.darkGray);
                log.error("Invalid defaulttrackcolor {}; using 'darkGray'", (Object)a.getValue());
            }
        }
        if ((a = shared.getAttribute("defaultoccupiedtrackcolor")) != null) {
            try {
                panel.setDefaultOccupiedTrackColor(ColorUtil.stringToColor(a.getValue()));
            }
            catch (IllegalArgumentException e) {
                panel.setDefaultOccupiedTrackColor(Color.red);
                log.error("Invalid defaultoccupiedtrackcolor {}; using 'red'", (Object)a.getValue());
            }
        }
        if ((a = shared.getAttribute("defaultalternativetrackcolor")) != null) {
            try {
                panel.setDefaultAlternativeTrackColor(ColorUtil.stringToColor(a.getValue()));
            }
            catch (IllegalArgumentException e) {
                panel.setDefaultAlternativeTrackColor(Color.white);
                log.error("Invalid defaultalternativetrackcolor {}; using 'white'", (Object)a.getValue());
            }
        }
        try {
            int red = shared.getAttribute("redBackground").getIntValue();
            int blue = shared.getAttribute("blueBackground").getIntValue();
            int green = shared.getAttribute("greenBackground").getIntValue();
            Color backgroundColor = new Color(red, green, blue);
            panel.setDefaultBackgroundColor(backgroundColor);
            panel.setBackgroundColor(backgroundColor);
        }
        catch (DataConversionException e) {
            log.warn("Could not parse color attributes!");
        }
        catch (NullPointerException e) {
            log.debug("missing background color attributes");
        }
        try {
            panel.setDirectTurnoutControl(shared.getAttribute("useDirectTurnoutControl").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert Layout Editor useDirectTurnoutControl attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing useDirectTurnoutControl attribute");
        }
        try {
            panel.setHighlightCursor(shared.getAttribute("highlightCursor").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert highlightCursor attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing highlightCursor attribute");
        }
        panel.initView();
        for (Element item : shared.getChildren()) {
            String adapterName = item.getAttribute("class").getValue();
            adapterName = ConfigXmlManager.currentClassName(adapterName);
            if (log.isDebugEnabled()) {
                String id = "<null>";
                try {
                    id = item.getAttribute("name").getValue();
                    log.debug("Load {} for [{}] via {}", new Object[]{id, panel.getName(), adapterName});
                }
                catch (NullPointerException e) {
                    log.debug("Load layout object for [{}] via {}", (Object)panel.getName(), (Object)adapterName);
                    log.debug("Load layout object for [{}] via {}", (Object)panel.getName(), (Object)adapterName);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                adapterName = ConfigXmlManager.currentClassName(adapterName);
                XmlAdapter adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter.load(item, panel);
                if (panel.loadOK()) continue;
                result = false;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JmriConfigureXmlException e) {
                log.error("Exception while loading {}", (Object)item.getName(), (Object)e);
                result = false;
            }
        }
        panel.disposeLoadData();
        panel.setConnections();
        try {
            panel.setAllEditable(shared.getAttribute("editable").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert editable attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing editable attribute");
        }
        try {
            panel.setShowHelpBar(shared.getAttribute("showhelpbar").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert showhelpbar attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing showhelpbar attribute");
        }
        try {
            panel.setAntialiasingOn(shared.getAttribute("antialiasing").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert antialiasing attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing antialiasing attribute");
        }
        String slValue = "both";
        try {
            boolean value = shared.getAttribute("sliders").getBooleanValue();
            slValue = value ? "both" : "none";
        }
        catch (DataConversionException e) {
            log.warn("unable to convert sliders attribute");
        }
        catch (NullPointerException e) {
            log.debug("missing sliders attribute");
        }
        a = shared.getAttribute("scrollable");
        if (a != null) {
            slValue = a.getValue();
        }
        panel.setScroll(slValue);
        panel.pack();
        panel.setLayoutDimensions(windowWidth, windowHeight, x, y, panelWidth, panelHeight);
        panel.setVisible(true);
        panel.resetDirty();
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerUser(panel);
        }
        if (InstanceManager.getDefault(TransitManager.class).getNamedBeanSet().size() > 0) {
            try {
                boolean value = shared.getAttribute("openDispatcher").getBooleanValue();
                panel.setOpenDispatcherOnLoad(value);
                if (value) {
                    DispatcherFrame df = InstanceManager.getDefault(DispatcherFrame.class);
                    df.loadAtStartup();
                }
            }
            catch (DataConversionException e) {
                log.warn("unable to convert openDispatcher attribute");
            }
            catch (NullPointerException e) {
                log.debug("missing openDispatcher attribute");
            }
        }
        return result;
    }

    @Override
    public int loadOrder() {
        return 390;
    }
}

