/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.Color;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrackDrawingOptions;
import jmri.util.ColorUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTrackDrawingOptionsXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(LayoutTrackDrawingOptionsXml.class);

    @Override
    public Element store(Object o) {
        LayoutTrackDrawingOptions p = (LayoutTrackDrawingOptions)o;
        Element element = new Element("layoutTrackDrawingOptions");
        element.setAttribute("name", p.getName());
        element.addContent((Content)new Element("mainBallastColor").addContent(ColorUtil.colorToHexString(p.getMainBallastColor())));
        element.addContent((Content)new Element("mainBallastWidth").addContent("" + p.getMainBallastWidth()));
        element.addContent((Content)new Element("mainBlockLineDashPercentageX10").addContent("" + p.getMainBlockLineDashPercentageX10()));
        element.addContent((Content)new Element("mainBlockLineWidth").addContent("" + p.getMainBlockLineWidth()));
        element.addContent((Content)new Element("mainRailColor").addContent(ColorUtil.colorToHexString(p.getMainRailColor())));
        element.addContent((Content)new Element("mainRailCount").addContent("" + p.getMainRailCount()));
        element.addContent((Content)new Element("mainRailGap").addContent("" + p.getMainRailGap()));
        element.addContent((Content)new Element("mainRailWidth").addContent("" + p.getMainRailWidth()));
        element.addContent((Content)new Element("mainTieColor").addContent(ColorUtil.colorToHexString(p.getMainTieColor())));
        element.addContent((Content)new Element("mainTieGap").addContent("" + p.getMainTieGap()));
        element.addContent((Content)new Element("mainTieLength").addContent("" + p.getMainTieLength()));
        element.addContent((Content)new Element("mainTieWidth").addContent("" + p.getMainTieWidth()));
        element.addContent((Content)new Element("sideBallastColor").addContent(ColorUtil.colorToHexString(p.getSideBallastColor())));
        element.addContent((Content)new Element("sideBallastWidth").addContent("" + p.getSideBallastWidth()));
        element.addContent((Content)new Element("sideBlockLineDashPercentageX10").addContent("" + p.getSideBlockLineDashPercentageX10()));
        element.addContent((Content)new Element("sideBlockLineWidth").addContent("" + p.getSideBlockLineWidth()));
        element.addContent((Content)new Element("sideRailColor").addContent(ColorUtil.colorToHexString(p.getSideRailColor())));
        element.addContent((Content)new Element("sideRailCount").addContent("" + p.getSideRailCount()));
        element.addContent((Content)new Element("sideRailGap").addContent("" + p.getSideRailGap()));
        element.addContent((Content)new Element("sideRailWidth").addContent("" + p.getSideRailWidth()));
        element.addContent((Content)new Element("sideTieColor").addContent(ColorUtil.colorToHexString(p.getSideTieColor())));
        element.addContent((Content)new Element("sideTieGap").addContent("" + p.getSideTieGap()));
        element.addContent((Content)new Element("sideTieLength").addContent("" + p.getSideTieLength()));
        element.addContent((Content)new Element("sideTieWidth").addContent("" + p.getSideTieWidth()));
        element.setAttribute("class", this.getClass().getName());
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    @Override
    public void load(Element element, Object o) {
        LayoutEditor p = (LayoutEditor)o;
        LayoutTrackDrawingOptions ltdo = p.getLayoutTrackDrawingOptions();
        String name = element.getAttribute("name").getValue();
        ltdo.setName(name);
        ltdo.setMainBallastColor(this.getElementColor(element, "mainBallastColor", ltdo.getMainBallastColor()));
        ltdo.setMainBallastWidth(this.getElementInt(element, "mainBallastWidth", ltdo.getMainBallastWidth()));
        ltdo.setMainBlockLineDashPercentageX10(this.getElementInt(element, "mainBlockLineDashPercentageX10", ltdo.getMainBlockLineDashPercentageX10()));
        ltdo.setMainBlockLineWidth(this.getElementInt(element, "mainBlockLineWidth", ltdo.getMainBlockLineWidth()));
        ltdo.setMainRailColor(this.getElementColor(element, "mainRailColor", ltdo.getMainRailColor()));
        ltdo.setMainRailCount(this.getElementInt(element, "mainRailCount", ltdo.getMainRailCount()));
        ltdo.setMainRailGap(this.getElementInt(element, "mainRailGap", ltdo.getMainRailGap()));
        ltdo.setMainRailWidth(this.getElementInt(element, "mainRailWidth", ltdo.getMainRailWidth()));
        ltdo.setMainTieColor(this.getElementColor(element, "mainTieColor", ltdo.getMainTieColor()));
        ltdo.setMainTieGap(this.getElementInt(element, "mainTieGap", ltdo.getMainTieGap()));
        ltdo.setMainTieLength(this.getElementInt(element, "mainTieLength", ltdo.getMainTieLength()));
        ltdo.setMainTieWidth(this.getElementInt(element, "mainTieWidth", ltdo.getMainTieWidth()));
        ltdo.setSideBallastColor(this.getElementColor(element, "sideBallastColor", ltdo.getSideBallastColor()));
        ltdo.setSideBallastWidth(this.getElementInt(element, "sideBallastWidth", ltdo.getSideBallastWidth()));
        ltdo.setSideBlockLineDashPercentageX10(this.getElementInt(element, "sideBlockLineDashPercentageX10", ltdo.getSideBlockLineDashPercentageX10()));
        ltdo.setSideBlockLineWidth(this.getElementInt(element, "sideBlockLineWidth", ltdo.getSideBlockLineWidth()));
        ltdo.setSideRailColor(this.getElementColor(element, "sideRailColor", ltdo.getSideBallastColor()));
        ltdo.setSideRailCount(this.getElementInt(element, "sideRailCount", ltdo.getSideRailCount()));
        ltdo.setSideRailGap(this.getElementInt(element, "sideRailGap", ltdo.getSideRailGap()));
        ltdo.setSideRailWidth(this.getElementInt(element, "sideRailWidth", ltdo.getSideRailWidth()));
        ltdo.setSideTieColor(this.getElementColor(element, "sideTieColor", ltdo.getSideTieColor()));
        ltdo.setSideTieGap(this.getElementInt(element, "sideTieGap", ltdo.getSideTieGap()));
        ltdo.setSideTieLength(this.getElementInt(element, "sideTieLength", ltdo.getSideTieLength()));
        ltdo.setSideTieWidth(this.getElementInt(element, "sideTieWidth", ltdo.getSideTieWidth()));
        p.setLayoutTrackDrawingOptions(ltdo);
    }

    @CheckReturnValue
    private Color getElementColor(@Nonnull Element el, @Nonnull String child, @CheckForNull Color defVal) {
        String val;
        Element c = el.getChild(child);
        if (c != null && (val = c.getText()) != null && !val.isEmpty()) {
            defVal = Color.decode(val);
        }
        return defVal;
    }

    int getElementInt(Element el, String child, int defVal) {
        String val;
        Element c = el.getChild(child);
        if (c != null && (val = c.getText()) != null && !val.isEmpty()) {
            defVal = Integer.parseInt(val);
        }
        return defVal;
    }
}

