/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.geom.Point2D;
import java.util.List;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LayoutTurntableView;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.configurexml.LayoutTrackViewXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTurntableViewXml
extends LayoutTrackViewXml {
    private static final Logger log = LoggerFactory.getLogger(LayoutTurntableViewXml.class);

    @Override
    public Element store(Object o) {
        LayoutTurntableView pv = (LayoutTurntableView)o;
        LayoutTurntable p = pv.getTurntable();
        Element element = new Element("layoutturntable");
        boolean turnoutControl = p.isTurnoutControlled();
        element.setAttribute("ident", p.getId());
        if (!p.getBlockName().isEmpty()) {
            element.setAttribute("blockname", p.getBlockName());
        }
        element.setAttribute("radius", "" + p.getRadius());
        Point2D coords = pv.getCoordsCenter();
        element.setAttribute("xcen", "" + coords.getX());
        element.setAttribute("ycen", "" + coords.getY());
        element.setAttribute("turnoutControlled", turnoutControl ? "yes" : "no");
        element.setAttribute("class", "jmri.jmrit.display.layoutEditor.configurexml.LayoutTurntableXml");
        for (int i = 0; i < p.getNumberRays(); ++i) {
            Element rElem = new Element("raytrack");
            rElem.setAttribute("angle", "" + p.getRayAngle(i));
            TrackSegment t = p.getRayConnectOrdered(i);
            if (t != null) {
                rElem.setAttribute("connectname", t.getId());
            }
            rElem.setAttribute("index", "" + p.getRayIndex(i));
            if (turnoutControl && p.getRayTurnoutName(i) != null) {
                rElem.setAttribute("turnout", p.getRayTurnoutName(i));
                if (p.getRayTurnoutState(i) == 4) {
                    rElem.setAttribute("turnoutstate", "thrown");
                } else {
                    rElem.setAttribute("turnoutstate", "closed");
                }
                if (p.isRayDisabled(i)) {
                    rElem.setAttribute("disabled", "yes");
                }
                if (p.isRayDisabledWhenOccupied(i)) {
                    rElem.setAttribute("disableWhenOccupied", "yes");
                }
            }
            element.addContent((Content)rElem);
        }
        this.storeLogixNG_Data(pv, element);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    @Override
    public void load(Element element, Object o) {
        LayoutEditor p = (LayoutEditor)o;
        String name = element.getAttribute("ident").getValue();
        double x = 0.0;
        double y = 0.0;
        double radius = 25.0;
        try {
            x = element.getAttribute("xcen").getFloatValue();
            y = element.getAttribute("ycen").getFloatValue();
            radius = element.getAttribute("radius").getFloatValue();
        }
        catch (DataConversionException e) {
            log.error("failed to convert layoutturntable center or radius attributes");
        }
        LayoutTurntable lt = new LayoutTurntable(name, p);
        LayoutTurntableView lv = new LayoutTurntableView(lt, (Point2D)new Point2D.Double(x, y), p);
        p.addLayoutTrack(lt, lv);
        lv.setCoordsCenter(new Point2D.Double(x, y));
        log.trace("LayoutTurntable at {}, {}", (Object)x, (Object)y);
        lt.setRadius(radius);
        Attribute a = element.getAttribute("blockname");
        if (a != null) {
            lt.tLayoutBlockName = a.getValue();
        }
        try {
            lt.setTurnoutControlled(element.getAttribute("turnoutControlled").getBooleanValue());
        }
        catch (DataConversionException e1) {
            log.warn("unable to convert layout turnout turnoutControlled attribute");
        }
        catch (NullPointerException e1) {
            // empty catch block
        }
        List rayTrackList = element.getChildren("raytrack");
        if (rayTrackList.size() > 0) {
            for (Element value : rayTrackList) {
                double angle = 0.0;
                int index = 0;
                try {
                    angle = value.getAttribute("angle").getFloatValue();
                    index = value.getAttribute("index").getIntValue();
                }
                catch (DataConversionException e) {
                    log.error("failed to convert ray track angle or index attributes");
                }
                String connectName = "";
                a = value.getAttribute("connectname");
                if (a != null) {
                    connectName = a.getValue();
                }
                lt.addRayTrack(angle, index, connectName);
                if (!lt.isTurnoutControlled() || value.getAttribute("turnout") == null) continue;
                if (value.getAttribute("turnoutstate").getValue().equals("thrown")) {
                    lt.setRayTurnout(index, value.getAttribute("turnout").getValue(), 4);
                } else {
                    lt.setRayTurnout(index, value.getAttribute("turnout").getValue(), 2);
                }
                try {
                    lt.setRayDisabled(index, value.getAttribute("disabled").getBooleanValue());
                }
                catch (DataConversionException e1) {
                    log.warn("unable to convert layout turnout disabled attribute");
                }
                catch (NullPointerException e1) {
                    // empty catch block
                }
                try {
                    lt.setRayDisabledWhenOccupied(index, value.getAttribute("disableWhenOccupied").getBooleanValue());
                }
                catch (DataConversionException e1) {
                    log.warn("unable to convert layout turnout disableWhenOccupied attribute");
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        this.loadLogixNG_Data(lv, element);
    }
}

