/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.geom.Point2D;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.LevelXingView;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.configurexml.LayoutTrackViewXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelXingViewXml
extends LayoutTrackViewXml {
    private static final Logger log = LoggerFactory.getLogger(LevelXingViewXml.class);

    @Override
    public Element store(Object o) {
        LevelXingView lv = (LevelXingView)o;
        LevelXing lt = lv.getLevelXing();
        Element element = new Element("levelxing");
        element.setAttribute("ident", lt.getId());
        if (!lt.getBlockNameAC().isEmpty()) {
            element.setAttribute("blocknameac", lt.getBlockNameAC());
        }
        if (!lt.getBlockNameBD().isEmpty()) {
            element.setAttribute("blocknamebd", lt.getBlockNameBD());
        }
        if (lt.getConnectA() != null) {
            element.setAttribute("connectaname", ((TrackSegment)lt.getConnectA()).getId());
        }
        if (lt.getConnectB() != null) {
            element.setAttribute("connectbname", ((TrackSegment)lt.getConnectB()).getId());
        }
        if (lt.getConnectC() != null) {
            element.setAttribute("connectcname", ((TrackSegment)lt.getConnectC()).getId());
        }
        if (lt.getConnectD() != null) {
            element.setAttribute("connectdname", ((TrackSegment)lt.getConnectD()).getId());
        }
        if (lv.isHidden()) {
            element.setAttribute("hidden", "yes");
        }
        if (!lt.getSignalAName().isEmpty()) {
            element.setAttribute("signalaname", lt.getSignalAName());
        }
        if (!lt.getSignalBName().isEmpty()) {
            element.setAttribute("signalbname", lt.getSignalBName());
        }
        if (!lt.getSignalCName().isEmpty()) {
            element.setAttribute("signalcname", lt.getSignalCName());
        }
        if (!lt.getSignalDName().isEmpty()) {
            element.setAttribute("signaldname", lt.getSignalDName());
        }
        Point2D coords = lv.getCoordsCenter();
        element.setAttribute("xcen", "" + coords.getX());
        element.setAttribute("ycen", "" + coords.getY());
        coords = lv.getCoordsA();
        element.setAttribute("xa", "" + coords.getX());
        element.setAttribute("ya", "" + coords.getY());
        coords = lv.getCoordsB();
        element.setAttribute("xb", "" + coords.getX());
        element.setAttribute("yb", "" + coords.getY());
        if (!lt.getSignalAMastName().isEmpty()) {
            element.addContent((Content)new Element("signalAMast").addContent(lt.getSignalAMastName()));
        }
        if (!lt.getSignalBMastName().isEmpty()) {
            element.addContent((Content)new Element("signalBMast").addContent(lt.getSignalBMastName()));
        }
        if (!lt.getSignalCMastName().isEmpty()) {
            element.addContent((Content)new Element("signalCMast").addContent(lt.getSignalCMastName()));
        }
        if (!lt.getSignalDMastName().isEmpty()) {
            element.addContent((Content)new Element("signalDMast").addContent(lt.getSignalDMastName()));
        }
        if (!lt.getSensorAName().isEmpty()) {
            element.addContent((Content)new Element("sensorA").addContent(lt.getSensorAName()));
        }
        if (!lt.getSensorBName().isEmpty()) {
            element.addContent((Content)new Element("sensorB").addContent(lt.getSensorBName()));
        }
        if (!lt.getSensorCName().isEmpty()) {
            element.addContent((Content)new Element("sensorC").addContent(lt.getSensorCName()));
        }
        if (!lt.getSensorDName().isEmpty()) {
            element.addContent((Content)new Element("sensorD").addContent(lt.getSensorDName()));
        }
        this.storeLogixNG_Data(lv, element);
        element.setAttribute("class", "jmri.jmrit.display.layoutEditor.configurexml.LevelXingXml");
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    @Override
    public void load(Element element, Object o) {
        String sensor;
        String mast;
        LayoutEditor p = (LayoutEditor)o;
        String name = element.getAttribute("ident").getValue();
        double x = 0.0;
        double y = 0.0;
        try {
            x = element.getAttribute("xcen").getFloatValue();
            y = element.getAttribute("ycen").getFloatValue();
        }
        catch (DataConversionException e) {
            log.error("failed to convert levelxing center  attribute");
        }
        LevelXing lt = new LevelXing(name, p);
        LevelXingView lv = new LevelXingView(lt, (Point2D)new Point2D.Double(x, y), p);
        Attribute a = element.getAttribute("blocknameac");
        if (a != null) {
            lt.tLayoutBlockNameAC = a.getValue();
        }
        if ((a = element.getAttribute("blocknamebd")) != null) {
            lt.tLayoutBlockNameBD = a.getValue();
        }
        if ((a = element.getAttribute("connectaname")) != null) {
            lt.connectAName = a.getValue();
        }
        if ((a = element.getAttribute("connectbname")) != null) {
            lt.connectBName = a.getValue();
        }
        if ((a = element.getAttribute("connectcname")) != null) {
            lt.connectCName = a.getValue();
        }
        if ((a = element.getAttribute("connectdname")) != null) {
            lt.connectDName = a.getValue();
        }
        if ((a = element.getAttribute("signalaname")) != null) {
            lt.setSignalAName(a.getValue());
        }
        if ((a = element.getAttribute("signalbname")) != null) {
            lt.setSignalBName(a.getValue());
        }
        if ((a = element.getAttribute("signalcname")) != null) {
            lt.setSignalCName(a.getValue());
        }
        if ((a = element.getAttribute("signaldname")) != null) {
            lt.setSignalDName(a.getValue());
        }
        try {
            x = element.getAttribute("xa").getFloatValue();
            y = element.getAttribute("ya").getFloatValue();
        }
        catch (DataConversionException e) {
            log.error("failed to convert levelxing a coords attribute");
        }
        lv.setCoordsA(new Point2D.Double(x, y));
        try {
            x = element.getAttribute("xb").getFloatValue();
            y = element.getAttribute("yb").getFloatValue();
        }
        catch (DataConversionException e) {
            log.error("failed to convert levelxing b coords attribute");
        }
        lv.setCoordsB(new Point2D.Double(x, y));
        try {
            lv.setHidden(element.getAttribute("hidden").getBooleanValue());
        }
        catch (DataConversionException e1) {
            log.warn("unable to convert levelxing hidden attribute");
        }
        catch (NullPointerException e1) {
            // empty catch block
        }
        if (element.getChild("signalAMast") != null && (mast = element.getChild("signalAMast").getText()) != null && !mast.isEmpty()) {
            lt.setSignalAMast(mast);
        }
        if (element.getChild("signalBMast") != null && (mast = element.getChild("signalBMast").getText()) != null && !mast.isEmpty()) {
            lt.setSignalBMast(mast);
        }
        if (element.getChild("signalCMast") != null && (mast = element.getChild("signalCMast").getText()) != null && !mast.isEmpty()) {
            lt.setSignalCMast(mast);
        }
        if (element.getChild("signalDMast") != null && (mast = element.getChild("signalDMast").getText()) != null && !mast.isEmpty()) {
            lt.setSignalDMast(mast);
        }
        if (element.getChild("sensorA") != null && (sensor = element.getChild("sensorA").getText()) != null && !sensor.isEmpty()) {
            lt.setSensorAName(sensor);
        }
        if (element.getChild("sensorB") != null && (sensor = element.getChild("sensorB").getText()) != null && !sensor.isEmpty()) {
            lt.setSensorBName(sensor);
        }
        if (element.getChild("sensorC") != null && (sensor = element.getChild("sensorC").getText()) != null && !sensor.isEmpty()) {
            lt.setSensorCName(sensor);
        }
        if (element.getChild("sensorD") != null && (sensor = element.getChild("sensorD").getText()) != null && !sensor.isEmpty()) {
            lt.setSensorDName(sensor);
        }
        this.loadLogixNG_Data(lv, element);
        p.addLayoutTrack(lt, lv);
    }
}

