/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.jmrit.display.layoutEditor.configurexml.LayoutTrackViewXml;
import jmri.util.ColorUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackSegmentViewXml
extends LayoutTrackViewXml {
    static final AbstractXmlAdapter.EnumIO<HitPointType> htpMap = new AbstractXmlAdapter.EnumIoNamesNumbers<HitPointType>(HitPointType.class);
    private static final Logger log = LoggerFactory.getLogger(TrackSegmentViewXml.class);

    @Override
    public Element store(Object o) {
        Map<String, String> decorations;
        TrackSegmentView view = (TrackSegmentView)o;
        TrackSegment trk = view.getTrackSegment();
        Element element = new Element("tracksegment");
        element.setAttribute("ident", trk.getId());
        if (!trk.getBlockName().isEmpty()) {
            element.setAttribute("blockname", trk.getBlockName());
        }
        element.setAttribute("connect1name", trk.getConnect1Name());
        element.setAttribute("type1", htpMap.outputFromEnum(trk.getType1()));
        element.setAttribute("connect2name", trk.getConnect2Name());
        element.setAttribute("type2", htpMap.outputFromEnum(trk.getType2()));
        element.setAttribute("dashed", view.isDashed() ? "yes" : "no");
        element.setAttribute("mainline", trk.isMainline() ? "yes" : "no");
        element.setAttribute("hidden", view.isHidden() ? "yes" : "no");
        if (view.isArc()) {
            element.setAttribute("arc", "yes");
            element.setAttribute("flip", view.isFlip() ? "yes" : "no");
            element.setAttribute("circle", view.isCircle() ? "yes" : "no");
            if (view.isCircle()) {
                element.setAttribute("angle", "" + view.getAngle());
                element.setAttribute("hideConLines", view.hideConstructionLines() ? "yes" : "no");
            }
        }
        if (view.isBezier()) {
            element.setAttribute("bezier", "yes");
            element.setAttribute("hideConLines", view.hideConstructionLines() ? "yes" : "no");
            Element elementControlpoints = new Element("controlpoints");
            for (int i = 0; i < view.getNumberOfBezierControlPoints(); ++i) {
                Element elementControlpoint = new Element("controlpoint");
                elementControlpoint.setAttribute("index", "" + i);
                Point2D pt = view.getBezierControlPoint(i);
                DecimalFormat twoDecFormat = new DecimalFormat("#.##");
                elementControlpoint.setAttribute("x", "" + Float.valueOf(twoDecFormat.format(pt.getX())));
                elementControlpoint.setAttribute("y", "" + Float.valueOf(twoDecFormat.format(pt.getY())));
                elementControlpoints.addContent((Content)elementControlpoint);
            }
            element.addContent((Content)elementControlpoints);
        }
        if ((decorations = view.getDecorations()).size() > 0) {
            Element decorationElement;
            Element decorationsElement = new Element("decorations");
            for (Map.Entry<String, String> entry : decorations.entrySet()) {
                String name = entry.getKey();
                if (name.equals("arrow") || name.equals("bridge") || name.equals("bumper") || name.equals("tunnel")) continue;
                Element decorationElement2 = new Element("decoration");
                decorationElement2.setAttribute("name", name);
                String value = entry.getValue();
                if (!value.isEmpty()) {
                    decorationElement2.setAttribute("value", value);
                }
                decorationsElement.addContent((Content)decorationElement2);
            }
            element.addContent((Content)decorationsElement);
            if (view.getArrowStyle() > 0) {
                decorationElement = new Element("arrow");
                decorationElement.setAttribute("style", Integer.toString(view.getArrowStyle()));
                if (view.isArrowEndStart() && view.isArrowEndStop()) {
                    decorationElement.setAttribute("end", "both");
                } else if (view.isArrowEndStop()) {
                    decorationElement.setAttribute("end", "stop");
                } else {
                    decorationElement.setAttribute("end", "start");
                }
                if (view.isArrowDirIn() && view.isArrowDirOut()) {
                    decorationElement.setAttribute("direction", "both");
                } else if (view.isArrowDirOut()) {
                    decorationElement.setAttribute("direction", "out");
                } else {
                    decorationElement.setAttribute("direction", "in");
                }
                decorationElement.setAttribute("color", ColorUtil.colorToHexString(view.getArrowColor()));
                decorationElement.setAttribute("linewidth", Integer.toString(view.getArrowLineWidth()));
                decorationElement.setAttribute("length", Integer.toString(view.getArrowLength()));
                decorationElement.setAttribute("gap", Integer.toString(view.getArrowGap()));
                decorationsElement.addContent((Content)decorationElement);
            }
            if (view.isBridgeSideLeft() || view.isBridgeSideRight()) {
                decorationElement = new Element("bridge");
                if (view.isBridgeSideLeft() && view.isBridgeSideRight()) {
                    decorationElement.setAttribute("side", "both");
                } else if (view.isBridgeSideLeft()) {
                    decorationElement.setAttribute("side", "left");
                } else {
                    decorationElement.setAttribute("side", "right");
                }
                if (view.isBridgeHasEntry() && view.isBridgeHasExit()) {
                    decorationElement.setAttribute("end", "both");
                } else if (view.isBridgeHasEntry()) {
                    decorationElement.setAttribute("end", "entry");
                } else if (view.isBridgeHasExit()) {
                    decorationElement.setAttribute("end", "exit");
                }
                decorationElement.setAttribute("color", ColorUtil.colorToHexString(view.getBridgeColor()));
                decorationElement.setAttribute("linewidth", Integer.toString(view.getBridgeLineWidth()));
                decorationElement.setAttribute("approachwidth", Integer.toString(view.getBridgeApproachWidth()));
                decorationElement.setAttribute("deckwidth", Integer.toString(view.getBridgeDeckWidth()));
                decorationsElement.addContent((Content)decorationElement);
            }
            if (view.isBumperEndStart() || view.isBumperEndStop()) {
                decorationElement = new Element("bumper");
                if (view.isBumperEndStart() && view.isBumperEndStop()) {
                    decorationElement.setAttribute("end", "both");
                } else if (view.isBumperEndStop()) {
                    decorationElement.setAttribute("end", "stop");
                } else {
                    decorationElement.setAttribute("end", "start");
                }
                decorationElement.setAttribute("color", ColorUtil.colorToHexString(view.getBumperColor()));
                decorationElement.setAttribute("linewidth", Integer.toString(view.getBumperLineWidth()));
                decorationElement.setAttribute("length", Integer.toString(view.getBumperLength()));
                if (view.isBumperFlipped()) {
                    decorationElement.setAttribute("flip", "true");
                }
                decorationsElement.addContent((Content)decorationElement);
            }
            if (view.isTunnelSideLeft() || view.isTunnelSideRight()) {
                decorationElement = new Element("tunnel");
                if (view.isTunnelSideLeft() && view.isTunnelSideRight()) {
                    decorationElement.setAttribute("side", "both");
                } else if (view.isTunnelSideLeft()) {
                    decorationElement.setAttribute("side", "left");
                } else {
                    decorationElement.setAttribute("side", "right");
                }
                if (view.isTunnelHasEntry() && view.isTunnelHasExit()) {
                    decorationElement.setAttribute("end", "both");
                } else if (view.isTunnelHasEntry()) {
                    decorationElement.setAttribute("end", "entry");
                } else if (view.isTunnelHasExit()) {
                    decorationElement.setAttribute("end", "exit");
                }
                decorationElement.setAttribute("color", ColorUtil.colorToHexString(view.getTunnelColor()));
                decorationElement.setAttribute("linewidth", Integer.toString(view.getTunnelLineWidth()));
                decorationElement.setAttribute("entrancewidth", Integer.toString(view.getTunnelEntranceWidth()));
                decorationElement.setAttribute("floorwidth", Integer.toString(view.getTunnelFloorWidth()));
                decorationsElement.addContent((Content)decorationElement);
            }
        }
        log.debug("storing old fixed class name for TrackSegment");
        element.setAttribute("class", "jmri.jmrit.display.layoutEditor.configurexml.TrackSegmentXml");
        this.storeLogixNG_Data(view, element);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    @Override
    public void load(Element element, Object o) {
        Attribute a;
        List decorationElementList;
        Element decorationsElement;
        LayoutEditor p = (LayoutEditor)o;
        String name = element.getAttribute("ident").getValue();
        boolean dash = this.getAttributeBooleanValue(element, "dashed", true);
        boolean main = this.getAttributeBooleanValue(element, "mainline", true);
        boolean hide = this.getAttributeBooleanValue(element, "hidden", false);
        String con1Name = element.getAttribute("connect1name").getValue();
        String con2Name = element.getAttribute("connect2name").getValue();
        HitPointType type1 = htpMap.inputFromAttribute(element.getAttribute("type1"));
        HitPointType type2 = htpMap.inputFromAttribute(element.getAttribute("type2"));
        TrackSegment lt = new TrackSegment(name, con1Name, type1, con2Name, type2, main, p);
        TrackSegmentView lv = new TrackSegmentView(lt, p);
        lv.setHidden(hide);
        lv.setDashed(dash);
        lv.setArc(this.getAttributeBooleanValue(element, "arc", false));
        if (lv.isArc()) {
            lv.setFlip(this.getAttributeBooleanValue(element, "flip", false));
            lv.setCircle(this.getAttributeBooleanValue(element, "circle", false));
            if (lv.isCircle()) {
                lv.setAngle(this.getAttributeDoubleValue(element, "angle", 0.0));
            }
        }
        if (this.getAttributeBooleanValue(element, "bezier", false)) {
            Element controlpointsElement = element.getChild("controlpoints");
            if (controlpointsElement != null) {
                List elementList = controlpointsElement.getChildren("controlpoint");
                if (elementList != null) {
                    if (elementList.size() >= 2) {
                        for (Element value : elementList) {
                            double x = 0.0;
                            double y = 0.0;
                            int index = 0;
                            try {
                                index = value.getAttribute("index").getIntValue();
                                x = value.getAttribute("x").getFloatValue();
                                y = value.getAttribute("y").getFloatValue();
                            }
                            catch (DataConversionException e) {
                                log.error("failed to convert controlpoint coordinates or index attributes");
                            }
                            lv.setBezierControlPoint(new Point2D.Double(x, y), index);
                        }
                    } else {
                        log.error("Track segment Bezier two controlpoint elements not found. (found {})", (Object)elementList.size());
                    }
                } else {
                    log.error("Track segment Bezier controlpoint elements not found.");
                }
            } else {
                log.error("Track segment Bezier controlpoints element not found.");
            }
            lv.setBezier(true);
        }
        if (this.getAttributeBooleanValue(element, "hideConLines", false)) {
            lv.hideConstructionLines(2);
        }
        if ((decorationsElement = element.getChild("decorations")) != null && (decorationElementList = decorationsElement.getChildren()) != null) {
            HashMap<String, String> decorations = new HashMap<String, String>();
            for (Element decorationElement : decorationElementList) {
                String value;
                Attribute a2;
                String decorationName = decorationElement.getName();
                if (decorationName.equals("arrow")) {
                    a2 = decorationElement.getAttribute("style");
                    if (a2 != null) {
                        try {
                            lv.setArrowStyle(a2.getIntValue());
                        }
                        catch (DataConversionException dataConversionException) {
                            // empty catch block
                        }
                    }
                    lv.setArrowEndStart(true);
                    lv.setArrowEndStop(true);
                    a2 = decorationElement.getAttribute("end");
                    if (a2 != null) {
                        value = a2.getValue();
                        if (value.equals("start")) {
                            lv.setArrowEndStop(false);
                        } else if (value.equals("stop")) {
                            lv.setArrowEndStart(false);
                        }
                    }
                    lv.setArrowDirIn(true);
                    lv.setArrowDirOut(true);
                    a2 = decorationElement.getAttribute("direction");
                    if (a2 != null) {
                        value = a2.getValue();
                        if (value.equals("in")) {
                            lv.setArrowDirOut(false);
                        } else if (value.equals("out")) {
                            lv.setArrowDirIn(false);
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("color")) != null) {
                        try {
                            lv.setArrowColor(ColorUtil.stringToColor(a2.getValue()));
                        }
                        catch (IllegalArgumentException e) {
                            lv.setArrowColor(Color.BLACK);
                            log.error("Invalid color {}; using black", (Object)a2.getValue());
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("linewidth")) != null) {
                        try {
                            lv.setArrowLineWidth(a2.getIntValue());
                        }
                        catch (DataConversionException e) {
                            // empty catch block
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("length")) != null) {
                        try {
                            lv.setArrowLength(a2.getIntValue());
                        }
                        catch (DataConversionException e) {
                            // empty catch block
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("gap")) == null) continue;
                    try {
                        lv.setArrowGap(a2.getIntValue());
                    }
                    catch (DataConversionException e) {}
                    continue;
                }
                if (decorationName.equals("bridge")) {
                    lv.setBridgeSideLeft(true);
                    lv.setBridgeSideRight(true);
                    a2 = decorationElement.getAttribute("side");
                    if (a2 != null) {
                        value = a2.getValue();
                        if (value.equals("right")) {
                            lv.setBridgeSideLeft(false);
                        } else if (value.equals("left")) {
                            lv.setBridgeSideRight(false);
                        }
                    }
                    lv.setBridgeHasEntry(false);
                    lv.setBridgeHasExit(false);
                    a2 = decorationElement.getAttribute("end");
                    if (a2 != null) {
                        value = a2.getValue();
                        if (value.equals("both")) {
                            lv.setBridgeHasEntry(true);
                            lv.setBridgeHasExit(true);
                        } else if (value.equals("entry")) {
                            lv.setBridgeHasEntry(true);
                            lv.setBridgeHasExit(false);
                        } else if (value.equals("exit")) {
                            lv.setBridgeHasEntry(false);
                            lv.setBridgeHasExit(true);
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("color")) != null) {
                        try {
                            lv.setBridgeColor(ColorUtil.stringToColor(a2.getValue()));
                        }
                        catch (IllegalArgumentException e) {
                            lv.setBridgeColor(Color.BLACK);
                            log.error("Invalid color {}; using black", (Object)a2.getValue());
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("linewidth")) != null) {
                        try {
                            lv.setBridgeLineWidth(a2.getIntValue());
                        }
                        catch (DataConversionException e) {
                            // empty catch block
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("approachwidth")) != null) {
                        try {
                            lv.setBridgeApproachWidth(a2.getIntValue());
                        }
                        catch (DataConversionException e) {
                            // empty catch block
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("deckwidth")) == null) continue;
                    try {
                        lv.setBridgeDeckWidth(a2.getIntValue());
                    }
                    catch (DataConversionException e) {}
                    continue;
                }
                if (decorationName.equals("bumper")) {
                    lv.setBumperEndStart(true);
                    lv.setBumperEndStop(true);
                    a2 = decorationElement.getAttribute("end");
                    if (a2 != null) {
                        value = a2.getValue();
                        if (value.equals("start")) {
                            lv.setBumperEndStop(false);
                        } else if (value.equals("stop")) {
                            lv.setBumperEndStart(false);
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("color")) != null) {
                        try {
                            lv.setBumperColor(ColorUtil.stringToColor(a2.getValue()));
                        }
                        catch (IllegalArgumentException e) {
                            lv.setBumperColor(Color.BLACK);
                            log.error("Invalid color {}; using black", (Object)a2.getValue());
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("linewidth")) != null) {
                        try {
                            lv.setBumperLineWidth(a2.getIntValue());
                        }
                        catch (DataConversionException e) {
                            // empty catch block
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("length")) != null) {
                        try {
                            lv.setBumperLength(a2.getIntValue());
                        }
                        catch (DataConversionException e) {
                            // empty catch block
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("flip")) == null) continue;
                    try {
                        lv.setBumperFlipped(a2.getBooleanValue());
                    }
                    catch (DataConversionException e) {}
                    continue;
                }
                if (decorationName.equals("tunnel")) {
                    lv.setTunnelSideLeft(true);
                    lv.setTunnelSideRight(true);
                    a2 = decorationElement.getAttribute("side");
                    if (a2 != null) {
                        value = a2.getValue();
                        if (value.equals("right")) {
                            lv.setTunnelSideLeft(false);
                        } else if (value.equals("left")) {
                            lv.setTunnelSideRight(false);
                        }
                    }
                    lv.setTunnelHasEntry(false);
                    lv.setTunnelHasExit(false);
                    a2 = decorationElement.getAttribute("end");
                    if (a2 != null) {
                        value = a2.getValue();
                        if (value.equals("both")) {
                            lv.setTunnelHasEntry(true);
                            lv.setTunnelHasExit(true);
                        } else if (value.equals("entry")) {
                            lv.setTunnelHasEntry(true);
                            lv.setTunnelHasExit(false);
                        } else if (value.equals("exit")) {
                            lv.setTunnelHasEntry(false);
                            lv.setTunnelHasExit(true);
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("color")) != null) {
                        try {
                            lv.setTunnelColor(ColorUtil.stringToColor(a2.getValue()));
                        }
                        catch (IllegalArgumentException e) {
                            lv.setTunnelColor(Color.BLACK);
                            log.error("Invalid color {}; using black", (Object)a2.getValue());
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("linewidth")) != null) {
                        try {
                            lv.setTunnelLineWidth(a2.getIntValue());
                        }
                        catch (DataConversionException e) {
                            // empty catch block
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("entrancewidth")) != null) {
                        try {
                            lv.setTunnelEntranceWidth(a2.getIntValue());
                        }
                        catch (DataConversionException e) {
                            // empty catch block
                        }
                    }
                    if ((a2 = decorationElement.getAttribute("floorwidth")) == null) continue;
                    try {
                        lv.setTunnelFloorWidth(a2.getIntValue());
                    }
                    catch (DataConversionException e) {}
                    continue;
                }
                try {
                    String eName = decorationElement.getAttribute("name").getValue();
                    Attribute a3 = decorationElement.getAttribute("value");
                    String eValue = a3 != null ? a3.getValue() : "";
                    decorations.put(eName, eValue);
                }
                catch (NullPointerException nullPointerException) {}
            }
            lv.setDecorations(decorations);
        }
        if ((a = element.getAttribute("blockname")) != null) {
            lt.tLayoutBlockName = a.getValue();
        }
        this.loadLogixNG_Data(lv, element);
        p.addLayoutTrack(lt, lv);
    }
}

