/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.logixng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.logixng.Bundle;
import jmri.jmrit.display.logixng.CategoryDisplay;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionLayoutTurnout
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private String _layoutEditorName;
    private LayoutEditor _layoutEditor;
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private String _layoutTurnoutName;
    private LayoutTurnout _layoutTurnout;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private Operation _operation = Operation.Enable;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private static final Logger log = LoggerFactory.getLogger(ActionLayoutTurnout.class);

    public ActionLayoutTurnout(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionLayoutTurnout copy = new ActionLayoutTurnout(sysName, userName);
        copy.setComment(this.getComment());
        if (this._layoutEditor != null) {
            copy.setLayoutEditor(this._layoutEditor.getName());
        }
        copy.setLayoutTurnout(this._layoutTurnout);
        copy.setOperation(this._operation);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setStateAddressing(this._stateAddressing);
        copy.setStateFormula(this._stateFormula);
        copy.setStateLocalVariable(this._stateLocalVariable);
        copy.setStateReference(this._stateReference);
        return manager.registerAction(copy);
    }

    public void setLayoutEditor(@CheckForNull String layoutEditorName) {
        this.assertListenersAreNotRegistered(log, "setEditor");
        InstanceManager.getDefault(EditorManager.class).removePropertyChangeListener("editors", this);
        this._layoutEditorName = layoutEditorName;
        this._layoutEditor = layoutEditorName != null ? InstanceManager.getDefault(EditorManager.class).get(LayoutEditor.class, layoutEditorName) : null;
        if (this._layoutEditor != null) {
            InstanceManager.getDefault(EditorManager.class).addPropertyChangeListener("editors", this);
        } else {
            this._layoutTurnout = null;
        }
    }

    public String getLayoutEditorName() {
        if (this._layoutEditor != null) {
            return this._layoutEditor.getName();
        }
        return null;
    }

    public LayoutTurnout findLayoutTurnout(String name) {
        if (this._layoutEditor != null) {
            for (LayoutTurnout lt : this._layoutEditor.getLayoutTurnouts()) {
                String turnoutName = lt.getTurnoutName();
                if (turnoutName.isBlank() || !name.equals(turnoutName)) continue;
                return lt;
            }
        }
        return null;
    }

    public LayoutTurnout findLayoutTurnout(Turnout turnout) {
        if (this._layoutEditor != null) {
            for (LayoutTurnout lt : this._layoutEditor.getLayoutTurnouts()) {
                String turnoutName = lt.getTurnoutName();
                if (turnoutName.isBlank() || !turnoutName.equals(turnout.getSystemName()) && !turnoutName.equals(turnout.getUserName())) continue;
                return lt;
            }
        }
        return null;
    }

    public void setLayoutTurnout(@CheckForNull String layoutTurnoutName) {
        this.assertListenersAreNotRegistered(log, "setLayoutTurnout");
        this._layoutTurnoutName = layoutTurnoutName;
        this._layoutTurnout = layoutTurnoutName != null && this._layoutEditor != null ? this.findLayoutTurnout(layoutTurnoutName) : null;
    }

    public void setLayoutTurnout(@CheckForNull LayoutTurnout layoutTurnout) {
        this.assertListenersAreNotRegistered(log, "setLayoutTurnout");
        this._layoutTurnout = layoutTurnout != null && this._layoutEditor != null ? layoutTurnout : null;
    }

    public LayoutTurnout getLayoutTurnout() {
        return this._layoutTurnout;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setStateAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseStateFormula();
    }

    public NamedBeanAddressing getStateAddressing() {
        return this._stateAddressing;
    }

    public void setOperation(Operation isControlling) {
        this._operation = isControlling;
    }

    public Operation getOperation() {
        return this._operation;
    }

    public void setStateReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getStateReference() {
        return this._stateReference;
    }

    public void setStateLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getStateLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setStateFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseStateFormula();
    }

    public String getStateFormula() {
        return this._stateFormula;
    }

    private void parseStateFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public Category getCategory() {
        return CategoryDisplay.DISPLAY;
    }

    private String getNewState() throws JmriException {
        switch (this._stateAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._stateReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._stateLocalVariable), false);
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToString(this._stateExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        LayoutTurnout layoutTurnout;
        switch (this._addressing) {
            case Direct: {
                layoutTurnout = this._layoutTurnout;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                layoutTurnout = this.findLayoutTurnout(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                Object value = symbolTable.getValue(this._localVariable);
                if (value instanceof Turnout) {
                    layoutTurnout = this.findLayoutTurnout((Turnout)value);
                    break;
                }
                layoutTurnout = this.findLayoutTurnout(TypeConversionUtil.convertToString(value, false));
                break;
            }
            case Formula: {
                if (this._expressionNode != null) {
                    Object value = this._expressionNode.calculate(this.getConditionalNG().getSymbolTable());
                    if (value instanceof Turnout) {
                        layoutTurnout = this.findLayoutTurnout((Turnout)value);
                        break;
                    }
                    layoutTurnout = this.findLayoutTurnout(TypeConversionUtil.convertToString(value, false));
                    break;
                }
                layoutTurnout = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (layoutTurnout == null) {
            log.debug("layoutTurnout is null");
            return;
        }
        String name = this._stateAddressing != NamedBeanAddressing.Direct ? this.getNewState() : null;
        Operation operation = this._stateAddressing == NamedBeanAddressing.Direct ? this._operation : Operation.valueOf(name);
        ThreadingUtil.runOnGUI(() -> {
            switch (operation) {
                case Disable: {
                    layoutTurnout.setDisabled(true);
                    break;
                }
                case Enable: {
                    layoutTurnout.setDisabled(false);
                    break;
                }
                default: {
                    throw new RuntimeException("operation has invalid value: " + operation.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionLayoutTurnout_Short", new Object[0]);
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String positonableName;
        String editorName = this._layoutEditor != null ? this._layoutEditor.getName() : Bundle.getMessage(locale, "BeanNotSelected", new Object[0]);
        switch (this._addressing) {
            case Direct: {
                String layoutTurnoutName = this._layoutTurnout != null ? this._layoutTurnout.getTurnoutName() : Bundle.getMessage(locale, "BeanNotSelected", new Object[0]);
                positonableName = Bundle.getMessage(locale, "AddressByDirect", layoutTurnoutName);
                break;
            }
            case Reference: {
                positonableName = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                positonableName = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                positonableName = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._stateAddressing) {
            case Direct: {
                state = Bundle.getMessage(locale, "AddressByDirect", this._operation._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._stateReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._stateLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._stateFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "ActionLayoutTurnout_Long", editorName, positonableName, state);
    }

    @Override
    public void setup() {
        if (this._layoutEditorName != null && this._layoutEditor == null) {
            this.setLayoutEditor(this._layoutEditorName);
        }
        if (this._layoutTurnoutName != null && this._layoutTurnout == null) {
            this.setLayoutTurnout(this._layoutTurnoutName);
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("editors".equals(evt.getPropertyName()) && evt.getOldValue() == this._layoutEditor) {
            this._layoutEditor = null;
            this._layoutTurnout = null;
            InstanceManager.getDefault(EditorManager.class).removePropertyChangeListener("editors", this);
        }
    }

    @Override
    public void disposeMe() {
        InstanceManager.getDefault(EditorManager.class).removePropertyChangeListener("editors", this);
    }

    public static enum Operation {
        Disable(Bundle.getMessage("ActionLayoutTurnout_Disable")),
        Enable(Bundle.getMessage("ActionLayoutTurnout_Enable"));

        private final String _text;

        private Operation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

