/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.logixng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.logixng.Bundle;
import jmri.jmrit.display.logixng.CategoryDisplay;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionPositionable
extends AbstractDigitalAction
implements VetoableChangeListener {
    private String _editorName;
    private Editor _editor;
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private String _positionableName;
    private Positionable _positionable;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private Operation _operation = Operation.Enable;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private static final Logger log = LoggerFactory.getLogger(ActionPositionable.class);

    public ActionPositionable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionPositionable copy = new ActionPositionable(sysName, userName);
        copy.setComment(this.getComment());
        copy.setEditor(this._editorName);
        copy.setPositionable(this._positionableName);
        copy.setOperation(this._operation);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setStateAddressing(this._stateAddressing);
        copy.setStateFormula(this._stateFormula);
        copy.setStateLocalVariable(this._stateLocalVariable);
        copy.setStateReference(this._stateReference);
        return manager.registerAction(copy);
    }

    public void setEditor(@CheckForNull String editorName) {
        this.assertListenersAreNotRegistered(log, "setEditor");
        this._editorName = editorName;
        this._editor = editorName != null ? InstanceManager.getDefault(EditorManager.class).getByName(editorName) : null;
    }

    public String getEditorName() {
        return this._editorName;
    }

    public void setPositionable(@CheckForNull String positionableName) {
        this.assertListenersAreNotRegistered(log, "setPositionable");
        this._positionableName = positionableName;
        this._positionable = positionableName != null && this._editor != null ? this._editor.getIdContents().get(this._positionableName) : null;
    }

    public String getPositionableName() {
        return this._positionableName;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setStateAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseStateFormula();
    }

    public NamedBeanAddressing getStateAddressing() {
        return this._stateAddressing;
    }

    public void setOperation(Operation isControlling) {
        this._operation = isControlling;
    }

    public Operation getOperation() {
        return this._operation;
    }

    public void setStateReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getStateReference() {
        return this._stateReference;
    }

    public void setStateLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getStateLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setStateFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseStateFormula();
    }

    public String getStateFormula() {
        return this._stateFormula;
    }

    private void parseStateFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public Category getCategory() {
        return CategoryDisplay.DISPLAY;
    }

    private String getNewState() throws JmriException {
        switch (this._stateAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._stateReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._stateLocalVariable), false);
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToString(this._stateExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    private void throwErrorPositionableDoesNotExists() throws JmriException {
        ConditionalNG lng = this.getConditionalNG();
        ConditionalNG cng = this.getConditionalNG();
        Module m = this.getModule();
        String errorMessage = m != null ? Bundle.getMessage("ActionPositionable_ErrorNoPositionable_Module", this.getLongDescription(), m.getDisplayName(), this.getSystemName()) : Bundle.getMessage("ActionPositionable_ErrorNoPositionable_LogixNG", this.getLongDescription(), lng.getDisplayName(), cng.getDisplayName(), this.getSystemName());
        List<String> list = Arrays.asList(errorMessage.split("\n"));
        throw new JmriException(Bundle.getMessage("ActionPositionable_ErrorNoPositionable"), list);
    }

    @Override
    public void execute() throws JmriException {
        Positionable positionable;
        switch (this._addressing) {
            case Direct: {
                positionable = this._positionable;
                if (positionable != null || this._positionableName == null || this._positionableName.isBlank()) break;
                this.throwErrorPositionableDoesNotExists();
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                positionable = this._editor.getIdContents().get(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                positionable = this._editor.getIdContents().get(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                positionable = this._expressionNode != null ? this._editor.getIdContents().get(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (positionable == null) {
            log.error("positionable is null");
            return;
        }
        String name = this._stateAddressing != NamedBeanAddressing.Direct ? this.getNewState() : null;
        Operation operation = this._stateAddressing == NamedBeanAddressing.Direct ? this._operation : Operation.valueOf(name);
        ThreadingUtil.runOnGUI(() -> {
            switch (operation) {
                case Disable: {
                    positionable.setControlling(false);
                    break;
                }
                case Enable: {
                    positionable.setControlling(true);
                    break;
                }
                case Hide: {
                    positionable.setHidden(true);
                    break;
                }
                case Show: {
                    positionable.setHidden(false);
                    break;
                }
                default: {
                    throw new RuntimeException("operation has invalid value: " + operation.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionPositionable_Short", new Object[0]);
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String positonableName;
        String editorName = this._editorName != null ? this._editorName : Bundle.getMessage(locale, "BeanNotSelected", new Object[0]);
        switch (this._addressing) {
            case Direct: {
                String positionableName = this._positionableName != null ? this._positionableName : Bundle.getMessage(locale, "BeanNotSelected", new Object[0]);
                positonableName = Bundle.getMessage(locale, "AddressByDirect", positionableName);
                break;
            }
            case Reference: {
                positonableName = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                positonableName = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                positonableName = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._stateAddressing) {
            case Direct: {
                state = Bundle.getMessage(locale, "AddressByDirect", this._operation._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._stateReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._stateLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._stateFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "ActionPositionable_Long", editorName, positonableName, state);
    }

    @Override
    public void setup() {
        if (this._editorName != null && this._editor == null) {
            this.setEditor(this._editorName);
        }
        if (this._positionableName != null && this._positionable == null) {
            this.setPositionable(this._positionableName);
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    public static enum Operation {
        Disable(Bundle.getMessage("ActionPositionable_Disable")),
        Enable(Bundle.getMessage("ActionPositionable_Enable")),
        Hide(Bundle.getMessage("ActionPositionable_Hide")),
        Show(Bundle.getMessage("ActionPositionable_Show"));

        private final String _text;

        private Operation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

