/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.logixng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.display.logixng.Bundle;
import jmri.jmrit.display.logixng.CategoryDisplay;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowManagement
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private String _jmriJFrameTitle;
    private JmriJFrame _jmriJFrame;
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private boolean _ignoreWindowNotFound = false;
    private final LogixNG_SelectEnum<HideOrShow> _selectEnumHideOrShow = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])HideOrShow.values(), (Enum)HideOrShow.DoNothing, (PropertyChangeListener)this);
    private final LogixNG_SelectEnum<MaximizeMinimizeNormalize> _selectEnumMaximizeMinimizeNormalize = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])MaximizeMinimizeNormalize.values(), (Enum)MaximizeMinimizeNormalize.DoNothing, (PropertyChangeListener)this);
    private final LogixNG_SelectEnum<BringToFrontOrBack> _selectEnumBringToFrontOrBack = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])BringToFrontOrBack.values(), (Enum)BringToFrontOrBack.DoNothing, (PropertyChangeListener)this);
    private static final Logger log = LoggerFactory.getLogger(WindowManagement.class);

    public WindowManagement(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        WindowManagement copy = new WindowManagement(sysName, userName);
        copy.setComment(this.getComment());
        copy.setJmriJFrame(this._jmriJFrameTitle);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy._ignoreWindowNotFound = this._ignoreWindowNotFound;
        this._selectEnumHideOrShow.copy(copy._selectEnumHideOrShow);
        this._selectEnumMaximizeMinimizeNormalize.copy(copy._selectEnumMaximizeMinimizeNormalize);
        this._selectEnumBringToFrontOrBack.copy(copy._selectEnumBringToFrontOrBack);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectEnum<HideOrShow> getSelectEnumHideOrShow() {
        return this._selectEnumHideOrShow;
    }

    public LogixNG_SelectEnum<MaximizeMinimizeNormalize> getSelectEnumMaximizeMinimizeNormalize() {
        return this._selectEnumMaximizeMinimizeNormalize;
    }

    public LogixNG_SelectEnum<BringToFrontOrBack> getSelectEnumBringToFrontOrBack() {
        return this._selectEnumBringToFrontOrBack;
    }

    public void setJmriJFrame(@CheckForNull String jmriJFrameTitle) {
        this.assertListenersAreNotRegistered(log, "setJmriJFrame");
        this._jmriJFrameTitle = jmriJFrameTitle;
        this._jmriJFrame = null;
    }

    public void setJmriJFrame(@CheckForNull JmriJFrame jmriJFrame) {
        this.assertListenersAreNotRegistered(log, "setJmriJFrame");
        this._jmriJFrame = jmriJFrame;
        this._jmriJFrameTitle = jmriJFrame != null ? jmriJFrame.getTitle() : "";
    }

    public JmriJFrame getJmriJFrame() {
        return this._jmriJFrame;
    }

    public String getJmriJFrameTitle() {
        return this._jmriJFrameTitle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setIgnoreWindowNotFound(boolean ignoreWindowNotFound) {
        this._ignoreWindowNotFound = ignoreWindowNotFound;
    }

    public boolean isIgnoreWindowNotFound() {
        return this._ignoreWindowNotFound;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public Category getCategory() {
        return CategoryDisplay.DISPLAY;
    }

    private void throwErrorJmriJFrameDoesNotExists() throws JmriException {
        LogixNG lng = this.getLogixNG();
        ConditionalNG cng = this.getConditionalNG();
        Module m = this.getModule();
        String errorMessage = m != null ? Bundle.getMessage("WindowManagement_ErrorNoJmriJFrame_Module", this.getLongDescription(), m.getDisplayName(), this.getSystemName()) : Bundle.getMessage("WindowManagement_ErrorNoJmriJFrame_LogixNG", this.getLongDescription(), lng.getDisplayName(), cng.getDisplayName(), this.getSystemName());
        List<String> list = Arrays.asList(errorMessage.split("\n"));
        throw new JmriException(Bundle.getMessage("WindowManagement_ErrorNoJmriJFrame"), list);
    }

    @Override
    public void execute() throws JmriException {
        JmriJFrame jmriJFrame;
        ConditionalNG conditionalNG = this.getConditionalNG();
        switch (this._addressing) {
            case Direct: {
                jmriJFrame = this._jmriJFrame;
                if (jmriJFrame != null || this._jmriJFrameTitle == null || this._jmriJFrameTitle.isBlank() || (jmriJFrame = JmriJFrame.getFrame(this._jmriJFrameTitle)) != null) break;
                if (this._ignoreWindowNotFound) {
                    log.debug("Window is not found");
                    return;
                }
                this.throwErrorJmriJFrameDoesNotExists();
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._reference);
                jmriJFrame = JmriJFrame.getFrame(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                jmriJFrame = JmriJFrame.getFrame(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                jmriJFrame = this._expressionNode != null ? JmriJFrame.getFrame(TypeConversionUtil.convertToString(this._expressionNode.calculate(conditionalNG.getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (jmriJFrame == null) {
            log.error("Window is null");
            return;
        }
        HideOrShow hideOrShow = this._selectEnumHideOrShow.evaluateEnum(conditionalNG);
        MaximizeMinimizeNormalize maximizeMinimizeNormalize = this._selectEnumMaximizeMinimizeNormalize.evaluateEnum(conditionalNG);
        BringToFrontOrBack bringToFrontOrBack = this._selectEnumBringToFrontOrBack.evaluateEnum(conditionalNG);
        JmriJFrame frame = jmriJFrame;
        ThreadingUtil.runOnGUI(() -> {
            hideOrShow.run(frame);
            maximizeMinimizeNormalize.run(frame);
            bringToFrontOrBack.run(frame);
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "WindowManagement_Short", new Object[0]);
    }

    @Override
    public String getLongDescription(Locale locale) {
        String jmriJFrameName;
        switch (this._addressing) {
            case Direct: {
                jmriJFrameName = this._jmriJFrameTitle != null ? this._jmriJFrameTitle : Bundle.getMessage(locale, "BeanNotSelected", new Object[0]);
                jmriJFrameName = Bundle.getMessage(locale, "AddressByDirect", jmriJFrameName);
                break;
            }
            case Reference: {
                jmriJFrameName = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                jmriJFrameName = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                jmriJFrameName = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(jmriJFrameName);
        if (!this._selectEnumHideOrShow.isEnum(HideOrShow.DoNothing)) {
            strings.add(this._selectEnumHideOrShow.getDescription(locale));
        }
        if (!this._selectEnumMaximizeMinimizeNormalize.isEnum(MaximizeMinimizeNormalize.DoNothing)) {
            strings.add(this._selectEnumMaximizeMinimizeNormalize.getDescription(locale));
        }
        if (!this._selectEnumBringToFrontOrBack.isEnum(BringToFrontOrBack.DoNothing)) {
            strings.add(this._selectEnumBringToFrontOrBack.getDescription(locale));
        }
        if (this._ignoreWindowNotFound) {
            strings.add(Bundle.getMessage("WindowManagement_IgnoreWindowNotFound_Descr", Bundle.getMessage("WindowManagement_IgnoreWindowNotFound")));
        } else {
            strings.add("");
        }
        return Bundle.getMessage(locale, "WindowManagement_Long_" + Integer.toString(strings.size()), strings.toArray());
    }

    @Override
    public void setup() {
        if (this._jmriJFrameTitle != null && this._jmriJFrame == null) {
            this.setJmriJFrame(this._jmriJFrameTitle);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    public static enum BringToFrontOrBack {
        DoNothing(Bundle.getMessage("WindowManagement_BringToFrontOrBack_DoNothing"), f -> {}),
        Front(Bundle.getMessage("WindowManagement_BringToFrontOrBack_Front"), f -> f.toFront()),
        Back(Bundle.getMessage("WindowManagement_BringToFrontOrBack_Back"), f -> f.toBack());

        private final String _text;
        private final FrameAction _action;

        private BringToFrontOrBack(String text, FrameAction action) {
            this._text = text;
            this._action = action;
        }

        public void run(JmriJFrame f) {
            this._action.run(f);
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum MaximizeMinimizeNormalize {
        DoNothing(Bundle.getMessage("WindowManagement_MaximizeMinimizeNormalize_DoNothing"), f -> {}),
        Minimize(Bundle.getMessage("WindowManagement_MaximizeMinimizeNormalize_Minimize"), f -> f.setExtendedState(1)),
        Normalize(Bundle.getMessage("WindowManagement_MaximizeMinimizeNormalize_Normalize"), f -> f.setExtendedState(0)),
        Maximize(Bundle.getMessage("WindowManagement_MaximizeMinimizeNormalize_Maximize"), f -> f.setExtendedState(6));

        private final String _text;
        private final FrameAction _action;

        private MaximizeMinimizeNormalize(String text, FrameAction action) {
            this._text = text;
            this._action = action;
        }

        public void run(JmriJFrame f) {
            this._action.run(f);
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum HideOrShow {
        DoNothing(Bundle.getMessage("WindowManagement_HideOrShow_DoNothing"), f -> {}),
        Show(Bundle.getMessage("WindowManagement_HideOrShow_Show"), f -> f.setVisible(true)),
        Hide(Bundle.getMessage("WindowManagement_HideOrShow_Hide"), f -> f.setVisible(false));

        private final String _text;
        private final FrameAction _action;

        private HideOrShow(String text, FrameAction action) {
            this._text = text;
            this._action = action;
        }

        public void run(JmriJFrame f) {
            this._action.run(f);
        }

        public String toString() {
            return this._text;
        }
    }

    private static interface FrameAction {
        public void run(JmriJFrame var1);
    }
}

