/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.logixng.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import jmri.InstanceManager;
import jmri.jmrit.display.AudioIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.logixng.ActionAudioIcon;
import jmri.jmrit.display.logixng.swing.Bundle;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.swing.JComboBoxUtil;

public class ActionAudioIconSwing
extends AbstractDigitalActionSwing {
    private String _selectedEditor;
    private JComboBox<EditorItem> _editorComboBox;
    private JTabbedPane _tabbedPaneAudioIcon;
    private JComboBox<String> _positionableComboBox;
    private JPanel _panelAudioIconDirect;
    private JPanel _panelAudioIconReference;
    private JPanel _panelAudioIconLocalVariable;
    private JPanel _panelAudioIconFormula;
    private JTextField _positionableReferenceTextField;
    private JTextField _positionableLocalVariableTextField;
    private JTextField _positionableFormulaTextField;
    private JTabbedPane _tabbedPaneAudioIconState;
    private JComboBox<ActionAudioIcon.Operation> _isControllingComboBox;
    private JPanel _panelAudioIconStateDirect;
    private JPanel _panelAudioIconStateReference;
    private JPanel _panelAudioIconStateLocalVariable;
    private JPanel _panelAudioIconStateFormula;
    private JTextField _positionableStateReferenceTextField;
    private JTextField _positionableStateLocalVariableTextField;
    private JTextField _positionableStateFormulaTextField;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionAudioIcon action = (ActionAudioIcon)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this._selectedEditor = action != null ? action.getEditorName() : null;
        JPanel innerPanel = new JPanel();
        this._editorComboBox = new JComboBox();
        JComboBoxUtil.setupComboBoxMaxRows(this._editorComboBox);
        for (Editor editor : InstanceManager.getDefault(EditorManager.class).getAll()) {
            EditorItem item = new EditorItem(editor);
            this._editorComboBox.addItem(item);
            if (!editor.getName().equals(this._selectedEditor)) continue;
            this._editorComboBox.setSelectedItem(item);
        }
        this._editorComboBox.addActionListener(this::updateAudioIcons);
        this._tabbedPaneAudioIcon = new JTabbedPane();
        this._panelAudioIconDirect = new JPanel();
        this._panelAudioIconReference = new JPanel();
        this._panelAudioIconLocalVariable = new JPanel();
        this._panelAudioIconFormula = new JPanel();
        this._tabbedPaneAudioIcon.addTab(NamedBeanAddressing.Direct.toString(), this._panelAudioIconDirect);
        this._tabbedPaneAudioIcon.addTab(NamedBeanAddressing.Reference.toString(), this._panelAudioIconReference);
        this._tabbedPaneAudioIcon.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelAudioIconLocalVariable);
        this._tabbedPaneAudioIcon.addTab(NamedBeanAddressing.Formula.toString(), this._panelAudioIconFormula);
        this._positionableComboBox = new JComboBox();
        JComboBoxUtil.setupComboBoxMaxRows(this._positionableComboBox);
        this.updateAudioIcons(null);
        this._panelAudioIconDirect.add(this._positionableComboBox);
        this._positionableReferenceTextField = new JTextField();
        this._positionableReferenceTextField.setColumns(30);
        this._panelAudioIconReference.add(this._positionableReferenceTextField);
        this._positionableLocalVariableTextField = new JTextField();
        this._positionableLocalVariableTextField.setColumns(30);
        this._panelAudioIconLocalVariable.add(this._positionableLocalVariableTextField);
        this._positionableFormulaTextField = new JTextField();
        this._positionableFormulaTextField.setColumns(30);
        this._panelAudioIconFormula.add(this._positionableFormulaTextField);
        this._tabbedPaneAudioIconState = new JTabbedPane();
        this._panelAudioIconStateDirect = new JPanel();
        this._panelAudioIconStateReference = new JPanel();
        this._panelAudioIconStateLocalVariable = new JPanel();
        this._panelAudioIconStateFormula = new JPanel();
        this._tabbedPaneAudioIconState.addTab(NamedBeanAddressing.Direct.toString(), this._panelAudioIconStateDirect);
        this._tabbedPaneAudioIconState.addTab(NamedBeanAddressing.Reference.toString(), this._panelAudioIconStateReference);
        this._tabbedPaneAudioIconState.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelAudioIconStateLocalVariable);
        this._tabbedPaneAudioIconState.addTab(NamedBeanAddressing.Formula.toString(), this._panelAudioIconStateFormula);
        this._isControllingComboBox = new JComboBox();
        for (ActionAudioIcon.Operation e : ActionAudioIcon.Operation.values()) {
            this._isControllingComboBox.addItem(e);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._isControllingComboBox);
        this._panelAudioIconStateDirect.add(this._isControllingComboBox);
        this._positionableStateReferenceTextField = new JTextField();
        this._positionableStateReferenceTextField.setColumns(30);
        this._panelAudioIconStateReference.add(this._positionableStateReferenceTextField);
        this._positionableStateLocalVariableTextField = new JTextField();
        this._positionableStateLocalVariableTextField.setColumns(30);
        this._panelAudioIconStateLocalVariable.add(this._positionableStateLocalVariableTextField);
        this._positionableStateFormulaTextField = new JTextField();
        this._positionableStateFormulaTextField.setColumns(30);
        this._panelAudioIconStateFormula.add(this._positionableStateFormulaTextField);
        if (action != null) {
            switch (action.getAddressing()) {
                case Direct: {
                    this._tabbedPaneAudioIcon.setSelectedComponent(this._panelAudioIconDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneAudioIcon.setSelectedComponent(this._panelAudioIconReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneAudioIcon.setSelectedComponent(this._panelAudioIconLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneAudioIcon.setSelectedComponent(this._panelAudioIconFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            if (action.getAudioIconName() != null) {
                this._positionableComboBox.setSelectedItem(action.getAudioIconName());
            }
            this._positionableReferenceTextField.setText(action.getReference());
            this._positionableLocalVariableTextField.setText(action.getLocalVariable());
            this._positionableFormulaTextField.setText(action.getFormula());
            switch (action.getStateAddressing()) {
                case Direct: {
                    this._tabbedPaneAudioIconState.setSelectedComponent(this._panelAudioIconStateDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneAudioIconState.setSelectedComponent(this._panelAudioIconStateReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneAudioIconState.setSelectedComponent(this._panelAudioIconStateLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneAudioIconState.setSelectedComponent(this._panelAudioIconStateFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            this._isControllingComboBox.setSelectedItem((Object)action.getOperation());
            this._positionableStateReferenceTextField.setText(action.getStateReference());
            this._positionableStateLocalVariableTextField.setText(action.getStateLocalVariable());
            this._positionableStateFormulaTextField.setText(action.getStateFormula());
        }
        JComponent[] components = new JComponent[]{this._editorComboBox, this._tabbedPaneAudioIcon, this._tabbedPaneAudioIconState};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionAudioIcon_Components"), components);
        for (JComponent c : componentList) {
            innerPanel.add(c);
        }
        this.panel.add(innerPanel);
        JPanel labelPanel = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage("ActionAudioIcon_Info"));
        label.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        labelPanel.add(label);
        this.panel.add(labelPanel);
    }

    private void updateAudioIcons(ActionEvent e) {
        this._positionableComboBox.removeAllItems();
        if (this._editorComboBox.getSelectedIndex() == -1) {
            return;
        }
        EditorItem item = this._editorComboBox.getItemAt(this._editorComboBox.getSelectedIndex());
        ArrayList<String> list = new ArrayList<String>();
        for (Positionable positionable : item._editor.getContents()) {
            if (positionable.getId() == null || !(positionable instanceof AudioIcon)) continue;
            list.add(positionable.getId());
        }
        Collections.sort(list);
        for (String s : list) {
            this._positionableComboBox.addItem(s);
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block12: {
            ActionAudioIcon action = new ActionAudioIcon("IQDA1", null);
            try {
                if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconReference) {
                    action.setReference(this._positionableReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                if (this._tabbedPaneAudioIconState.getSelectedComponent() == this._panelAudioIconStateReference) {
                    action.setStateReference(this._positionableStateReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                action.setFormula(this._positionableFormulaTextField.getText());
                if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                    break block12;
                }
                if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    break block12;
                }
                if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    break block12;
                }
                if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    break block12;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionAudioIcon action = new ActionAudioIcon(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block17: {
            if (!(object instanceof ActionAudioIcon)) {
                throw new IllegalArgumentException("object must be an ActionAudioIcon but is a: " + object.getClass().getName());
            }
            ActionAudioIcon action = (ActionAudioIcon)object;
            if (this._editorComboBox.getSelectedIndex() != -1) {
                action.setEditor(this._editorComboBox.getItemAt((int)this._editorComboBox.getSelectedIndex())._editor.getName());
            }
            if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconDirect) {
                action.setAudioIcon(this._positionableComboBox.getItemAt(this._positionableComboBox.getSelectedIndex()));
            }
            try {
                if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                } else if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    action.setReference(this._positionableReferenceTextField.getText());
                } else if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    action.setLocalVariable(this._positionableLocalVariableTextField.getText());
                } else if (this._tabbedPaneAudioIcon.getSelectedComponent() == this._panelAudioIconFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    action.setFormula(this._positionableFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneAudioIcon has unknown selection");
                }
                if (this._tabbedPaneAudioIconState.getSelectedComponent() == this._panelAudioIconStateDirect) {
                    action.setStateAddressing(NamedBeanAddressing.Direct);
                    action.setOperation(this._isControllingComboBox.getItemAt(this._isControllingComboBox.getSelectedIndex()));
                    break block17;
                }
                if (this._tabbedPaneAudioIconState.getSelectedComponent() == this._panelAudioIconStateReference) {
                    action.setStateAddressing(NamedBeanAddressing.Reference);
                    action.setStateReference(this._positionableStateReferenceTextField.getText());
                    break block17;
                }
                if (this._tabbedPaneAudioIconState.getSelectedComponent() == this._panelAudioIconStateLocalVariable) {
                    action.setStateAddressing(NamedBeanAddressing.LocalVariable);
                    action.setStateLocalVariable(this._positionableStateLocalVariableTextField.getText());
                    break block17;
                }
                if (this._tabbedPaneAudioIconState.getSelectedComponent() == this._panelAudioIconStateFormula) {
                    action.setStateAddressing(NamedBeanAddressing.Formula);
                    action.setStateFormula(this._positionableStateFormulaTextField.getText());
                    break block17;
                }
                throw new IllegalArgumentException("_tabbedPaneAudioIconState has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionAudioIcon_Short");
    }

    @Override
    public void dispose() {
    }

    private static class EditorItem {
        private final Editor _editor;

        public EditorItem(Editor editor) {
            this._editor = editor;
        }

        public String toString() {
            return this._editor.getName();
        }
    }
}

