/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.logixng.swing;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.logixng.ActionLayoutTurnout;
import jmri.jmrit.display.logixng.swing.Bundle;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.swing.JComboBoxUtil;

public class ActionLayoutTurnoutSwing
extends AbstractDigitalActionSwing {
    private String _selectedLayoutEditor;
    private JComboBox<EditorItem> _layoutEditorComboBox;
    private JTabbedPane _tabbedPaneLayoutTurnout;
    private JComboBox<Turnout> _layoutTurnoutComboBox;
    private JPanel _panelLayoutTurnoutDirect;
    private JPanel _panelLayoutTurnoutReference;
    private JPanel _panelLayoutTurnoutLocalVariable;
    private JPanel _panelLayoutTurnoutFormula;
    private JTextField _layoutTurnoutReferenceTextField;
    private JTextField _layoutTurnoutLocalVariableTextField;
    private JTextField _layoutTurnoutFormulaTextField;
    private JTabbedPane _tabbedPaneLayoutTurnoutState;
    private JComboBox<ActionLayoutTurnout.Operation> _isControllingComboBox;
    private JPanel _panelLayoutTurnoutStateDirect;
    private JPanel _panelLayoutTurnoutStateReference;
    private JPanel _panelLayoutTurnoutStateLocalVariable;
    private JPanel _panelLayoutTurnoutStateFormula;
    private JTextField _layoutTurnoutStateReferenceTextField;
    private JTextField _layoutTurnoutStateLocalVariableTextField;
    private JTextField _layoutTurnoutStateFormulaTextField;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionLayoutTurnout action = (ActionLayoutTurnout)object;
        this.panel = new JPanel();
        this._selectedLayoutEditor = action != null ? action.getLayoutEditorName() : null;
        this._layoutEditorComboBox = new JComboBox();
        JComboBoxUtil.setupComboBoxMaxRows(this._layoutEditorComboBox);
        for (LayoutEditor layoutEditor : InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class)) {
            EditorItem item = new EditorItem(layoutEditor);
            this._layoutEditorComboBox.addItem(item);
            if (!layoutEditor.getName().equals(this._selectedLayoutEditor)) continue;
            this._layoutEditorComboBox.setSelectedItem(item);
        }
        this._layoutEditorComboBox.addActionListener(this::updateLayoutTurnouts);
        this._tabbedPaneLayoutTurnout = new JTabbedPane();
        this._panelLayoutTurnoutDirect = new JPanel();
        this._panelLayoutTurnoutReference = new JPanel();
        this._panelLayoutTurnoutLocalVariable = new JPanel();
        this._panelLayoutTurnoutFormula = new JPanel();
        this._tabbedPaneLayoutTurnout.addTab(NamedBeanAddressing.Direct.toString(), this._panelLayoutTurnoutDirect);
        this._tabbedPaneLayoutTurnout.addTab(NamedBeanAddressing.Reference.toString(), this._panelLayoutTurnoutReference);
        this._tabbedPaneLayoutTurnout.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLayoutTurnoutLocalVariable);
        this._tabbedPaneLayoutTurnout.addTab(NamedBeanAddressing.Formula.toString(), this._panelLayoutTurnoutFormula);
        this._layoutTurnoutComboBox = new JComboBox();
        JComboBoxUtil.setupComboBoxMaxRows(this._layoutTurnoutComboBox);
        this.updateLayoutTurnouts(null);
        this._panelLayoutTurnoutDirect.add(this._layoutTurnoutComboBox);
        this._layoutTurnoutReferenceTextField = new JTextField();
        this._layoutTurnoutReferenceTextField.setColumns(30);
        this._panelLayoutTurnoutReference.add(this._layoutTurnoutReferenceTextField);
        this._layoutTurnoutLocalVariableTextField = new JTextField();
        this._layoutTurnoutLocalVariableTextField.setColumns(30);
        this._panelLayoutTurnoutLocalVariable.add(this._layoutTurnoutLocalVariableTextField);
        this._layoutTurnoutFormulaTextField = new JTextField();
        this._layoutTurnoutFormulaTextField.setColumns(30);
        this._panelLayoutTurnoutFormula.add(this._layoutTurnoutFormulaTextField);
        this._tabbedPaneLayoutTurnoutState = new JTabbedPane();
        this._panelLayoutTurnoutStateDirect = new JPanel();
        this._panelLayoutTurnoutStateReference = new JPanel();
        this._panelLayoutTurnoutStateLocalVariable = new JPanel();
        this._panelLayoutTurnoutStateFormula = new JPanel();
        this._tabbedPaneLayoutTurnoutState.addTab(NamedBeanAddressing.Direct.toString(), this._panelLayoutTurnoutStateDirect);
        this._tabbedPaneLayoutTurnoutState.addTab(NamedBeanAddressing.Reference.toString(), this._panelLayoutTurnoutStateReference);
        this._tabbedPaneLayoutTurnoutState.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLayoutTurnoutStateLocalVariable);
        this._tabbedPaneLayoutTurnoutState.addTab(NamedBeanAddressing.Formula.toString(), this._panelLayoutTurnoutStateFormula);
        this._isControllingComboBox = new JComboBox();
        for (ActionLayoutTurnout.Operation e : ActionLayoutTurnout.Operation.values()) {
            this._isControllingComboBox.addItem(e);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._isControllingComboBox);
        this._panelLayoutTurnoutStateDirect.add(this._isControllingComboBox);
        this._layoutTurnoutStateReferenceTextField = new JTextField();
        this._layoutTurnoutStateReferenceTextField.setColumns(30);
        this._panelLayoutTurnoutStateReference.add(this._layoutTurnoutStateReferenceTextField);
        this._layoutTurnoutStateLocalVariableTextField = new JTextField();
        this._layoutTurnoutStateLocalVariableTextField.setColumns(30);
        this._panelLayoutTurnoutStateLocalVariable.add(this._layoutTurnoutStateLocalVariableTextField);
        this._layoutTurnoutStateFormulaTextField = new JTextField();
        this._layoutTurnoutStateFormulaTextField.setColumns(30);
        this._panelLayoutTurnoutStateFormula.add(this._layoutTurnoutStateFormulaTextField);
        if (action != null) {
            switch (action.getAddressing()) {
                case Direct: {
                    this._tabbedPaneLayoutTurnout.setSelectedComponent(this._panelLayoutTurnoutDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneLayoutTurnout.setSelectedComponent(this._panelLayoutTurnoutReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneLayoutTurnout.setSelectedComponent(this._panelLayoutTurnoutLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneLayoutTurnout.setSelectedComponent(this._panelLayoutTurnoutFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            if (action.getLayoutTurnout() != null) {
                this._layoutTurnoutComboBox.setSelectedItem(action.getLayoutTurnout());
            }
            this._layoutTurnoutReferenceTextField.setText(action.getReference());
            this._layoutTurnoutLocalVariableTextField.setText(action.getLocalVariable());
            this._layoutTurnoutFormulaTextField.setText(action.getFormula());
            switch (action.getStateAddressing()) {
                case Direct: {
                    this._tabbedPaneLayoutTurnoutState.setSelectedComponent(this._panelLayoutTurnoutStateDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneLayoutTurnoutState.setSelectedComponent(this._panelLayoutTurnoutStateReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneLayoutTurnoutState.setSelectedComponent(this._panelLayoutTurnoutStateLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneLayoutTurnoutState.setSelectedComponent(this._panelLayoutTurnoutStateFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            this._isControllingComboBox.setSelectedItem((Object)action.getOperation());
            this._layoutTurnoutStateReferenceTextField.setText(action.getStateReference());
            this._layoutTurnoutStateLocalVariableTextField.setText(action.getStateLocalVariable());
            this._layoutTurnoutStateFormulaTextField.setText(action.getStateFormula());
        }
        JComponent[] components = new JComponent[]{this._layoutEditorComboBox, this._tabbedPaneLayoutTurnout, this._tabbedPaneLayoutTurnoutState};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionLayoutTurnout_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    private void updateLayoutTurnouts(ActionEvent e) {
        this._layoutTurnoutComboBox.removeAllItems();
        if (this._layoutEditorComboBox.getSelectedIndex() == -1) {
            return;
        }
        EditorItem item = this._layoutEditorComboBox.getItemAt(this._layoutEditorComboBox.getSelectedIndex());
        ArrayList<LayoutTurnout> list = new ArrayList<LayoutTurnout>();
        for (LayoutTurnout layoutTurnout : item._layoutEditor.getLayoutTurnouts()) {
            if (layoutTurnout.getTurnoutName().isBlank()) continue;
            list.add(layoutTurnout);
        }
        Collections.sort(list, (o1, o2) -> o1.getTurnoutName().compareTo(o2.getTurnoutName()));
        for (LayoutTurnout lt : list) {
            this._layoutTurnoutComboBox.addItem(new Turnout(lt));
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block12: {
            ActionLayoutTurnout action = new ActionLayoutTurnout("IQDA1", null);
            try {
                if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutReference) {
                    action.setReference(this._layoutTurnoutReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                if (this._tabbedPaneLayoutTurnoutState.getSelectedComponent() == this._panelLayoutTurnoutStateReference) {
                    action.setStateReference(this._layoutTurnoutStateReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                action.setFormula(this._layoutTurnoutFormulaTextField.getText());
                if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                    break block12;
                }
                if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    break block12;
                }
                if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    break block12;
                }
                if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    break block12;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionLayoutTurnout action = new ActionLayoutTurnout(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block19: {
            if (!(object instanceof ActionLayoutTurnout)) {
                throw new IllegalArgumentException("object must be an ActionLayoutTurnout but is a: " + object.getClass().getName());
            }
            ActionLayoutTurnout action = (ActionLayoutTurnout)object;
            if (this._layoutEditorComboBox.getSelectedIndex() != -1) {
                action.setLayoutEditor(this._layoutEditorComboBox.getItemAt((int)this._layoutEditorComboBox.getSelectedIndex())._layoutEditor.getName());
            }
            if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutDirect) {
                if (this._layoutTurnoutComboBox.getSelectedIndex() != -1) {
                    action.setLayoutTurnout(this._layoutTurnoutComboBox.getItemAt((int)this._layoutTurnoutComboBox.getSelectedIndex())._lt);
                } else {
                    action.setLayoutTurnout((LayoutTurnout)null);
                }
            }
            try {
                if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                } else if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    action.setReference(this._layoutTurnoutReferenceTextField.getText());
                } else if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    action.setLocalVariable(this._layoutTurnoutLocalVariableTextField.getText());
                } else if (this._tabbedPaneLayoutTurnout.getSelectedComponent() == this._panelLayoutTurnoutFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    action.setFormula(this._layoutTurnoutFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneLayoutTurnout has unknown selection");
                }
                if (this._tabbedPaneLayoutTurnoutState.getSelectedComponent() == this._panelLayoutTurnoutStateDirect) {
                    action.setStateAddressing(NamedBeanAddressing.Direct);
                    action.setOperation(this._isControllingComboBox.getItemAt(this._isControllingComboBox.getSelectedIndex()));
                    break block19;
                }
                if (this._tabbedPaneLayoutTurnoutState.getSelectedComponent() == this._panelLayoutTurnoutStateReference) {
                    action.setStateAddressing(NamedBeanAddressing.Reference);
                    action.setStateReference(this._layoutTurnoutStateReferenceTextField.getText());
                    break block19;
                }
                if (this._tabbedPaneLayoutTurnoutState.getSelectedComponent() == this._panelLayoutTurnoutStateLocalVariable) {
                    action.setStateAddressing(NamedBeanAddressing.LocalVariable);
                    action.setStateLocalVariable(this._layoutTurnoutStateLocalVariableTextField.getText());
                    break block19;
                }
                if (this._tabbedPaneLayoutTurnoutState.getSelectedComponent() == this._panelLayoutTurnoutStateFormula) {
                    action.setStateAddressing(NamedBeanAddressing.Formula);
                    action.setStateFormula(this._layoutTurnoutStateFormulaTextField.getText());
                    break block19;
                }
                throw new IllegalArgumentException("_tabbedPaneLayoutTurnoutState has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionLayoutTurnout_Short");
    }

    @Override
    public void dispose() {
    }

    private static class Turnout {
        private final LayoutTurnout _lt;

        public Turnout(LayoutTurnout turnout) {
            this._lt = turnout;
        }

        public String toString() {
            return this._lt.getTurnoutName();
        }
    }

    private static class EditorItem {
        private final LayoutEditor _layoutEditor;

        public EditorItem(LayoutEditor layoutEditor) {
            this._layoutEditor = layoutEditor;
        }

        public String toString() {
            return this._layoutEditor.getName();
        }
    }
}

