/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.logixng.swing;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.logixng.ActionPositionable;
import jmri.jmrit.display.logixng.swing.Bundle;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.swing.JComboBoxUtil;

public class ActionPositionableSwing
extends AbstractDigitalActionSwing {
    private String _selectedEditor;
    private JComboBox<EditorItem> _editorComboBox;
    private JTabbedPane _tabbedPanePositionable;
    private JComboBox<String> _positionableComboBox;
    private JPanel _panelPositionableDirect;
    private JPanel _panelPositionableReference;
    private JPanel _panelPositionableLocalVariable;
    private JPanel _panelPositionableFormula;
    private JTextField _positionableReferenceTextField;
    private JTextField _positionableLocalVariableTextField;
    private JTextField _positionableFormulaTextField;
    private JTabbedPane _tabbedPanePositionableState;
    private JComboBox<ActionPositionable.Operation> _isControllingComboBox;
    private JPanel _panelPositionableStateDirect;
    private JPanel _panelPositionableStateReference;
    private JPanel _panelPositionableStateLocalVariable;
    private JPanel _panelPositionableStateFormula;
    private JTextField _positionableStateReferenceTextField;
    private JTextField _positionableStateLocalVariableTextField;
    private JTextField _positionableStateFormulaTextField;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionPositionable action = (ActionPositionable)object;
        this.panel = new JPanel();
        this._selectedEditor = action != null ? action.getEditorName() : null;
        this._editorComboBox = new JComboBox();
        JComboBoxUtil.setupComboBoxMaxRows(this._editorComboBox);
        for (Editor editor : InstanceManager.getDefault(EditorManager.class).getAll()) {
            EditorItem item = new EditorItem(editor);
            this._editorComboBox.addItem(item);
            if (!editor.getName().equals(this._selectedEditor)) continue;
            this._editorComboBox.setSelectedItem(item);
        }
        this._editorComboBox.addActionListener(this::updatePositionables);
        this._tabbedPanePositionable = new JTabbedPane();
        this._panelPositionableDirect = new JPanel();
        this._panelPositionableReference = new JPanel();
        this._panelPositionableLocalVariable = new JPanel();
        this._panelPositionableFormula = new JPanel();
        this._tabbedPanePositionable.addTab(NamedBeanAddressing.Direct.toString(), this._panelPositionableDirect);
        this._tabbedPanePositionable.addTab(NamedBeanAddressing.Reference.toString(), this._panelPositionableReference);
        this._tabbedPanePositionable.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelPositionableLocalVariable);
        this._tabbedPanePositionable.addTab(NamedBeanAddressing.Formula.toString(), this._panelPositionableFormula);
        this._positionableComboBox = new JComboBox();
        JComboBoxUtil.setupComboBoxMaxRows(this._positionableComboBox);
        this.updatePositionables(null);
        this._panelPositionableDirect.add(this._positionableComboBox);
        this._positionableReferenceTextField = new JTextField();
        this._positionableReferenceTextField.setColumns(30);
        this._panelPositionableReference.add(this._positionableReferenceTextField);
        this._positionableLocalVariableTextField = new JTextField();
        this._positionableLocalVariableTextField.setColumns(30);
        this._panelPositionableLocalVariable.add(this._positionableLocalVariableTextField);
        this._positionableFormulaTextField = new JTextField();
        this._positionableFormulaTextField.setColumns(30);
        this._panelPositionableFormula.add(this._positionableFormulaTextField);
        this._tabbedPanePositionableState = new JTabbedPane();
        this._panelPositionableStateDirect = new JPanel();
        this._panelPositionableStateReference = new JPanel();
        this._panelPositionableStateLocalVariable = new JPanel();
        this._panelPositionableStateFormula = new JPanel();
        this._tabbedPanePositionableState.addTab(NamedBeanAddressing.Direct.toString(), this._panelPositionableStateDirect);
        this._tabbedPanePositionableState.addTab(NamedBeanAddressing.Reference.toString(), this._panelPositionableStateReference);
        this._tabbedPanePositionableState.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelPositionableStateLocalVariable);
        this._tabbedPanePositionableState.addTab(NamedBeanAddressing.Formula.toString(), this._panelPositionableStateFormula);
        this._isControllingComboBox = new JComboBox();
        for (ActionPositionable.Operation e : ActionPositionable.Operation.values()) {
            this._isControllingComboBox.addItem(e);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._isControllingComboBox);
        this._panelPositionableStateDirect.add(this._isControllingComboBox);
        this._positionableStateReferenceTextField = new JTextField();
        this._positionableStateReferenceTextField.setColumns(30);
        this._panelPositionableStateReference.add(this._positionableStateReferenceTextField);
        this._positionableStateLocalVariableTextField = new JTextField();
        this._positionableStateLocalVariableTextField.setColumns(30);
        this._panelPositionableStateLocalVariable.add(this._positionableStateLocalVariableTextField);
        this._positionableStateFormulaTextField = new JTextField();
        this._positionableStateFormulaTextField.setColumns(30);
        this._panelPositionableStateFormula.add(this._positionableStateFormulaTextField);
        if (action != null) {
            switch (action.getAddressing()) {
                case Direct: {
                    this._tabbedPanePositionable.setSelectedComponent(this._panelPositionableDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPanePositionable.setSelectedComponent(this._panelPositionableReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPanePositionable.setSelectedComponent(this._panelPositionableLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPanePositionable.setSelectedComponent(this._panelPositionableFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            if (action.getPositionableName() != null) {
                this._positionableComboBox.setSelectedItem(action.getPositionableName());
            }
            this._positionableReferenceTextField.setText(action.getReference());
            this._positionableLocalVariableTextField.setText(action.getLocalVariable());
            this._positionableFormulaTextField.setText(action.getFormula());
            switch (action.getStateAddressing()) {
                case Direct: {
                    this._tabbedPanePositionableState.setSelectedComponent(this._panelPositionableStateDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPanePositionableState.setSelectedComponent(this._panelPositionableStateReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPanePositionableState.setSelectedComponent(this._panelPositionableStateLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPanePositionableState.setSelectedComponent(this._panelPositionableStateFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            this._isControllingComboBox.setSelectedItem((Object)action.getOperation());
            this._positionableStateReferenceTextField.setText(action.getStateReference());
            this._positionableStateLocalVariableTextField.setText(action.getStateLocalVariable());
            this._positionableStateFormulaTextField.setText(action.getStateFormula());
        }
        JComponent[] components = new JComponent[]{this._editorComboBox, this._tabbedPanePositionable, this._tabbedPanePositionableState};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionPositionable_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    private void updatePositionables(ActionEvent e) {
        this._positionableComboBox.removeAllItems();
        if (this._editorComboBox.getSelectedIndex() == -1) {
            return;
        }
        EditorItem item = this._editorComboBox.getItemAt(this._editorComboBox.getSelectedIndex());
        ArrayList<String> list = new ArrayList<String>();
        for (Positionable positionable : item._editor.getContents()) {
            if (positionable.getId() == null) continue;
            list.add(positionable.getId());
        }
        Collections.sort(list);
        for (String s : list) {
            this._positionableComboBox.addItem(s);
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block12: {
            ActionPositionable action = new ActionPositionable("IQDA1", null);
            try {
                if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableReference) {
                    action.setReference(this._positionableReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                if (this._tabbedPanePositionableState.getSelectedComponent() == this._panelPositionableStateReference) {
                    action.setStateReference(this._positionableStateReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                action.setFormula(this._positionableFormulaTextField.getText());
                if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                    break block12;
                }
                if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    break block12;
                }
                if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    break block12;
                }
                if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    break block12;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionPositionable action = new ActionPositionable(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block17: {
            if (!(object instanceof ActionPositionable)) {
                throw new IllegalArgumentException("object must be an ActionPositionable but is a: " + object.getClass().getName());
            }
            ActionPositionable action = (ActionPositionable)object;
            if (this._editorComboBox.getSelectedIndex() != -1) {
                action.setEditor(this._editorComboBox.getItemAt((int)this._editorComboBox.getSelectedIndex())._editor.getName());
            }
            if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableDirect) {
                action.setPositionable(this._positionableComboBox.getItemAt(this._positionableComboBox.getSelectedIndex()));
            }
            try {
                if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                } else if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    action.setReference(this._positionableReferenceTextField.getText());
                } else if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    action.setLocalVariable(this._positionableLocalVariableTextField.getText());
                } else if (this._tabbedPanePositionable.getSelectedComponent() == this._panelPositionableFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    action.setFormula(this._positionableFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPanePositionable has unknown selection");
                }
                if (this._tabbedPanePositionableState.getSelectedComponent() == this._panelPositionableStateDirect) {
                    action.setStateAddressing(NamedBeanAddressing.Direct);
                    action.setOperation(this._isControllingComboBox.getItemAt(this._isControllingComboBox.getSelectedIndex()));
                    break block17;
                }
                if (this._tabbedPanePositionableState.getSelectedComponent() == this._panelPositionableStateReference) {
                    action.setStateAddressing(NamedBeanAddressing.Reference);
                    action.setStateReference(this._positionableStateReferenceTextField.getText());
                    break block17;
                }
                if (this._tabbedPanePositionableState.getSelectedComponent() == this._panelPositionableStateLocalVariable) {
                    action.setStateAddressing(NamedBeanAddressing.LocalVariable);
                    action.setStateLocalVariable(this._positionableStateLocalVariableTextField.getText());
                    break block17;
                }
                if (this._tabbedPanePositionableState.getSelectedComponent() == this._panelPositionableStateFormula) {
                    action.setStateAddressing(NamedBeanAddressing.Formula);
                    action.setStateFormula(this._positionableStateFormulaTextField.getText());
                    break block17;
                }
                throw new IllegalArgumentException("_tabbedPanePositionableState has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionPositionable_Short");
    }

    @Override
    public void dispose() {
    }

    private static class EditorItem {
        private final Editor _editor;

        public EditorItem(Editor editor) {
            this._editor = editor;
        }

        public String toString() {
            return this._editor.getName();
        }
    }
}

