/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.palette.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontPanel
extends JPanel
implements ItemListener {
    static final String[] JUSTIFICATION = new String[]{Bundle.getMessage("left"), Bundle.getMessage("center"), Bundle.getMessage("right")};
    static final String[] STYLES = new String[]{Bundle.getMessage("Plain"), Bundle.getMessage("Bold"), Bundle.getMessage("Italic"), Bundle.getMessage("Bold/italic")};
    static final String[] FONTSIZE = new String[]{"6", "8", "10", "11", "12", "14", "16", "20", "24", "28", "32", "36"};
    public static final int SIZE = 1;
    public static final int STYLE = 2;
    public static final int JUST = 3;
    public static final int FACE = 4;
    private AJComboBox<Font> _fontFaceBox;
    private AJComboBox<String> _fontSizeBox;
    private AJComboBox<String> _fontStyleBox;
    private AJComboBox<String> _fontJustBox;
    PositionablePopupUtil _util;
    ActionListener _callBack;
    private static final Logger log = LoggerFactory.getLogger(FontPanel.class);

    public FontPanel(PositionablePopupUtil util, ActionListener ca) {
        this._util = util;
        this._callBack = ca;
        this.makeFontPanels();
    }

    private JPanel makeBoxPanel(String caption, JComboBox<?> box) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(Bundle.getMessage(caption)));
        box.addItemListener(this);
        panel.add(box);
        return panel;
    }

    private void makeFontPanels() {
        JPanel fontPanel = new JPanel();
        Font defaultFont = this._util.getFont();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilyNames = ge.getAvailableFontFamilyNames();
        Font[] fonts = new Font[fontFamilyNames.length];
        int k = 0;
        for (String fontFamilyName : fontFamilyNames) {
            fonts[k++] = new Font(fontFamilyName, defaultFont.getStyle(), defaultFont.getSize()){

                @Override
                public String toString() {
                    return this.getFamily();
                }
            };
        }
        this._fontFaceBox = new AJComboBox<Font>(fonts, 4);
        fontPanel.add(this.makeBoxPanel("EditFont", this._fontFaceBox));
        this._fontSizeBox = new AJComboBox<String>(FONTSIZE, 1);
        fontPanel.add(this.makeBoxPanel("FontSize", this._fontSizeBox));
        this._fontStyleBox = new AJComboBox<String>(STYLES, 2);
        fontPanel.add(this.makeBoxPanel("FontStyle", this._fontStyleBox));
        this._fontJustBox = new AJComboBox<String>(JUSTIFICATION, 3);
        fontPanel.add(this.makeBoxPanel("Justification", this._fontJustBox));
        this.add(fontPanel);
    }

    public void setFontSelections() {
        this._fontFaceBox.setSelectedItem(this._util.getFont());
        int row = 4;
        for (int i = 0; i < FONTSIZE.length; ++i) {
            if (this._util.getFontSize() != Integer.parseInt(FONTSIZE[i])) continue;
            row = i;
            break;
        }
        this._fontSizeBox.setSelectedIndex(row);
        this._fontStyleBox.setSelectedIndex(this._util.getFont().getStyle());
        switch (this._util.getJustification()) {
            case 0: {
                row = 0;
                break;
            }
            case 4: {
                row = 1;
                break;
            }
            default: {
                row = 2;
            }
        }
        this._fontJustBox.setSelectedIndex(row);
        this._callBack.actionPerformed(null);
    }

    @Override
    @SuppressFBWarnings(value={"Raw use of parameterized class"}, justification="AJComboBox is checked")
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof AJComboBox) {
            AJComboBox comboBox = (AJComboBox)e.getSource();
            switch (comboBox._which) {
                case 1: {
                    String size = comboBox.getSelectedItem() != null ? (String)comboBox.getSelectedItem() : "10";
                    this._util.setFontSize(Float.parseFloat(size));
                    break;
                }
                case 2: {
                    int style = 0;
                    switch (comboBox.getSelectedIndex()) {
                        case 0: {
                            style = 0;
                            break;
                        }
                        case 1: {
                            style = 1;
                            break;
                        }
                        case 2: {
                            style = 2;
                            break;
                        }
                        case 3: {
                            style = 3;
                            break;
                        }
                        default: {
                            log.warn("Unexpected index {}  in itemStateChanged", (Object)comboBox.getSelectedIndex());
                        }
                    }
                    this._util.setFontStyle(style);
                    break;
                }
                case 3: {
                    int just = 0;
                    switch (comboBox.getSelectedIndex()) {
                        case 0: {
                            just = 0;
                            break;
                        }
                        case 1: {
                            just = 4;
                            break;
                        }
                        case 2: {
                            just = 2;
                            break;
                        }
                        default: {
                            log.warn("Unexpected index {}  in itemStateChanged", (Object)comboBox.getSelectedIndex());
                        }
                    }
                    this._util.setJustification(just);
                    break;
                }
                case 4: {
                    Font font = comboBox.getSelectedItem() != null ? (Font)comboBox.getSelectedItem() : (Font)comboBox.getItemAt(0);
                    this._util.setFont(font);
                    break;
                }
                default: {
                    log.warn("Unexpected _which {}  in itemStateChanged", (Object)comboBox._which);
                }
            }
            this._callBack.actionPerformed(null);
        }
    }

    static class AJComboBox<T>
    extends JComboBox<T> {
        int _which;

        AJComboBox(T[] items, int which) {
            super(items);
            this._which = which;
        }
    }
}

