/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.jmrit.catalog.CatalogPanel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.FamilyItemPanel;
import jmri.jmrit.display.palette.ItemDialog;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.util.swing.ImagePanel;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconDialog
extends ItemDialog {
    protected String _family;
    protected HashMap<String, NamedIcon> _iconMap;
    protected ImagePanel _iconEditPanel;
    protected CatalogPanel _catalog;
    protected final JLabel _nameLabel;
    private static final Logger log = LoggerFactory.getLogger(IconDialog.class);

    public IconDialog(String type, String family, FamilyItemPanel parent) {
        super(type, Bundle.getMessage("ShowIconsTitle", family), parent);
        this._family = family;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(5));
        JPanel p = new JPanel();
        this._nameLabel = new JLabel(Bundle.getMessage("FamilyName", family));
        p.add(this._nameLabel);
        panel.add(p);
        this._iconEditPanel = new ImagePanel();
        this._iconEditPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), Bundle.getMessage("PreviewBorderTitle")));
        if (!this._parent.isUpdate()) {
            this._iconEditPanel.setImage(this._parent._frame.getPreviewBackground());
        } else {
            this._iconEditPanel.setImage(this._parent._frame.getBackground(0));
        }
        panel.add(this._iconEditPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.makeDoneButtonPanel(buttonPanel, "ButtonDone");
        panel.add(buttonPanel);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(panel);
        this._catalog = this.makeCatalog();
        p.add(this._catalog);
        JScrollPane sp = new JScrollPane(p);
        this.setContentPane(sp);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IconDialog.this.cancel();
            }
        });
    }

    protected void setMap(HashMap<String, NamedIcon> iconMap) {
        this._iconMap = iconMap != null ? IconDialog.clone(iconMap) : this._parent.makeNewIconMap(this._type);
        if (!this._type.equals("MultiSensor") && !this._type.equals("SignalHead")) {
            ItemPanel.checkIconMap(this._type, this._iconMap);
        }
        this._parent.addIconsToPanel(this._iconMap, this._iconEditPanel, true);
        this.setLocationRelativeTo(this._parent);
        this.setVisible(true);
        this.pack();
        log.debug("setMap: initialization done.");
    }

    private CatalogPanel makeCatalog() {
        CatalogPanel catalog = CatalogPanel.makeDefaultCatalog(false, false, true);
        catalog.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
        ImagePanel panel = catalog.getPreviewPanel();
        if (!this._parent.isUpdate()) {
            panel.setImage(this._parent._frame.getPreviewBackground());
        } else {
            panel.setImage(this._parent._frame.getBackground(0));
        }
        return catalog;
    }

    protected ImagePanel getIconEditPanel() {
        return this._iconEditPanel;
    }

    protected ImagePanel getCatalogPreviewPanel() {
        return this._catalog.getPreviewPanel();
    }

    protected boolean doDoneAction() {
        boolean sameMap;
        boolean nameUsed;
        String family;
        if (log.isDebugEnabled()) {
            log.debug("doDoneAction: {} for {} family= {}", new Object[]{this._parent._update ? "Update" : "", this._type, this._family});
        }
        if (this._family == null || this._family.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NoFamilyName"), Bundle.getMessage("MessageTitle"), 1);
            return false;
        }
        HashMap<String, HashMap<String, NamedIcon>> families = ItemPalette.getFamilyMaps(this._type);
        HashMap<String, NamedIcon> catalogSet = families.get(this._family);
        if (catalogSet == null) {
            family = this._parent.findFamilyOfMap(null, this._iconMap, families);
            nameUsed = false;
        } else {
            family = this._parent.findFamilyOfMap(this._family, this._iconMap, families);
            nameUsed = true;
        }
        if (family != null ? !this.mapInCatalogOK(sameMap = this._parent.mapsAreEqual(this._iconMap, families.get(family)), nameUsed, this._family, family) : !this.mapNotInCatalogOK(sameMap = catalogSet == null ? false : this._parent.mapsAreEqual(catalogSet, this._iconMap), nameUsed, this._family)) {
            return false;
        }
        this._parent.dialogDoneAction(this._family, this._iconMap);
        return true;
    }

    protected boolean mapInCatalogOK(boolean sameMap, boolean nameUsed, String editFamily, String catalogFamily) {
        log.debug("doDoneAction: map of {} in storage with name= {}", (Object)editFamily, (Object)catalogFamily);
        if (this._parent._update) {
            if (!catalogFamily.equals(editFamily)) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("CannotChangeName", editFamily, catalogFamily), Bundle.getMessage("MessageTitle"), 1);
                return false;
            }
        } else {
            log.debug("doDoneAction: name {} {} used and map {} same as {}", new Object[]{editFamily, nameUsed ? "is" : "NOT", sameMap ? "" : "NOT", catalogFamily});
            if (catalogFamily.equals(editFamily)) {
                if (!sameMap) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("DuplicateFamilyName", editFamily, this._type, Bundle.getMessage("UseAnotherName")), Bundle.getMessage("MessageTitle"), 1);
                    return false;
                }
            } else if (sameMap) {
                String oldFamily = this._parent.getFamilyName();
                if (oldFamily != null) {
                    if (nameUsed) {
                        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SameNameSet", editFamily, catalogFamily), Bundle.getMessage("MessageTitle"), 1);
                        return false;
                    }
                } else if (!nameUsed) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("DuplicateFamilyName", editFamily, this._type, Bundle.getMessage("CannotUseName", catalogFamily)), Bundle.getMessage("MessageTitle"), 1);
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean mapNotInCatalogOK(boolean sameMap, boolean nameUsed, String editFamily) {
        String oldFamily = this._parent.getFamilyName();
        if (this._parent._update) {
            if (nameUsed) {
                log.debug("{} keys a stored map. name is used", (Object)editFamily);
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NeedDifferentName", editFamily), Bundle.getMessage("MessageTitle"), 1);
                return false;
            }
        } else if (oldFamily != null) {
            log.debug("Editing set {}. {} {} a stored map.", new Object[]{oldFamily, editFamily, nameUsed ? "is" : "NOT"});
            if (nameUsed) {
                if (!editFamily.equals(oldFamily) && !sameMap) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("badReplaceIconSet", oldFamily, editFamily), Bundle.getMessage("MessageTitle"), 1);
                    return false;
                }
            } else {
                int result = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("ReplaceFamily", oldFamily, editFamily), Bundle.getMessage("QuestionTitle"), -1, 3, null, new Object[]{oldFamily, editFamily, Bundle.getMessage("ButtonCancel")}, Bundle.getMessage("ButtonCancel"));
                switch (result) {
                    case 0: {
                        this._family = oldFamily;
                        break;
                    }
                    case -1: 
                    case 2: {
                        return true;
                    }
                }
            }
        } else if (nameUsed) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("DuplicateFamilyName", editFamily, this._type, Bundle.getMessage("UseAnotherName")), Bundle.getMessage("MessageTitle"), 1);
            return false;
        }
        return true;
    }

    protected void renameFamily() {
        String family = this._parent.getValidFamilyName(null, this._iconMap);
        if (family != null) {
            this._family = family;
            this._nameLabel.setText(Bundle.getMessage("FamilyName", this._family));
            this.invalidate();
        }
    }

    protected void makeDoneButtonPanel(JPanel buttonPanel, String text) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton doneButton = new JButton(Bundle.getMessage(text));
        doneButton.addActionListener(a -> {
            if (this.doDoneAction()) {
                this.dispose();
            }
        });
        panel.add(doneButton);
        JButton renameButton = new JButton(Bundle.getMessage("renameFamily"));
        renameButton.addActionListener(a -> this.renameFamily());
        panel.add(renameButton);
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(a -> this.cancel());
        panel.add(cancelButton);
        buttonPanel.add(panel);
    }

    protected void cancel() {
        this._parent.setFamily();
        this._parent._cntlDown = false;
        super.dispose();
    }

    protected static HashMap<String, NamedIcon> clone(HashMap<String, NamedIcon> map) {
        HashMap<String, NamedIcon> clone = null;
        if (map != null) {
            clone = new HashMap<String, NamedIcon>();
            for (Map.Entry<String, NamedIcon> entry : map.entrySet()) {
                clone.put(entry.getKey(), new NamedIcon(entry.getValue()));
            }
        }
        return clone;
    }
}

