/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.IconDialog;
import jmri.jmrit.display.palette.IndicatorTOItemPanel;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorTOIconDialog
extends IconDialog {
    private HashMap<String, HashMap<String, NamedIcon>> _iconGroupsMap;
    private static final Logger log = LoggerFactory.getLogger(IndicatorTOIconDialog.class);

    public IndicatorTOIconDialog(String type, String family, IndicatorTOItemPanel parent) {
        super(type, family, parent);
    }

    protected void setMaps(HashMap<String, HashMap<String, NamedIcon>> iconMaps) {
        IndicatorTOItemPanel p = (IndicatorTOItemPanel)this._parent;
        if (iconMaps != null) {
            this._iconGroupsMap = new HashMap();
            for (Map.Entry<String, HashMap<String, NamedIcon>> entry : iconMaps.entrySet()) {
                this._iconGroupsMap.put(entry.getKey(), IconDialog.clone(entry.getValue()));
            }
        } else {
            this._iconGroupsMap = p.makeNewIconMap();
        }
        p.addIcons2Panel(this._iconGroupsMap, this._iconEditPanel, true);
        this.setLocationRelativeTo(p);
        this.setVisible(true);
        this.pack();
        log.debug("setMaps: initialization done.");
    }

    @Override
    protected void makeDoneButtonPanel(JPanel buttonPanel, String text) {
        super.makeDoneButtonPanel(buttonPanel, text);
        IndicatorTOItemPanel p = (IndicatorTOItemPanel)this._parent;
        if (!p._cntlDown) {
            return;
        }
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout());
        JButton button = new JButton(Bundle.getMessage("addMissingStatus"));
        button.addActionListener(a -> this.addMissingStatus());
        button.setToolTipText(Bundle.getMessage("ToolTipMissingStatus"));
        panel1.add(button);
        button = new JButton(Bundle.getMessage("addStatus"));
        button.addActionListener(a -> this.addStatusSet());
        button.setToolTipText(Bundle.getMessage("addStatus"));
        panel1.add(button);
        button = new JButton(Bundle.getMessage("deleteStatus"));
        button.addActionListener(a -> this.deleteStatusSet());
        button.setToolTipText(Bundle.getMessage("ToolTipDeleteStatus"));
        panel1.add(button);
        buttonPanel.add(panel1);
    }

    @Override
    protected void renameFamily() {
        IndicatorTOItemPanel p = (IndicatorTOItemPanel)this._parent;
        String family = p.getValidFamily(null, this._iconGroupsMap);
        if (family != null) {
            this._family = family;
            this._nameLabel.setText(Bundle.getMessage("FamilyName", this._family));
            this.invalidate();
        }
    }

    @Override
    protected boolean doDoneAction() {
        boolean sameMap;
        boolean nameUsed;
        String family;
        if (log.isDebugEnabled()) {
            log.debug("doDoneAction: {} for {} family= {}", new Object[]{this._parent._update ? "Update" : "", this._type, this._family});
        }
        if (this._family == null || this._family.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NoFamilyName"), Bundle.getMessage("MessageTitle"), 1);
            return false;
        }
        IndicatorTOItemPanel p = (IndicatorTOItemPanel)this._parent;
        HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> families = ItemPalette.getLevel4FamilyMaps(this._type);
        HashMap<String, HashMap<String, NamedIcon>> catalogSet = families.get(this._family);
        if (catalogSet == null) {
            family = p.findFamilyOfMaps(null, this._iconGroupsMap, families);
            nameUsed = false;
        } else {
            family = p.findFamilyOfMaps(this._family, this._iconGroupsMap, families);
            nameUsed = true;
        }
        if (family != null ? !this.mapInCatalogOK(sameMap = p.familiesAreEqual(this._iconGroupsMap, families.get(family)), nameUsed, this._family, family) : !this.mapNotInCatalogOK(sameMap = catalogSet == null ? false : p.familiesAreEqual(catalogSet, this._iconGroupsMap), nameUsed, this._family)) {
            return false;
        }
        p.dialogDone(this._family, this._iconGroupsMap);
        return true;
    }

    private void addMissingStatus() {
        Set<String> set = this._iconGroupsMap.keySet();
        HashMap<String, String> options = new HashMap<String, String>();
        for (String status : ItemPanel.INDICATOR_TRACK) {
            if (set.contains(status)) continue;
            options.put(ItemPalette.convertText(status), status);
        }
        if (!options.isEmpty()) {
            Object[] selections = options.keySet().toArray();
            String key = (String)JmriJOptionPane.showInputDialog(this, Bundle.getMessage("PickStatus"), Bundle.getMessage("QuestionTitle"), 3, null, selections, selections[0]);
            if (key != null) {
                this.addStatus((String)options.get(key));
            }
        } else {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("AllStatus"), Bundle.getMessage("MessageTitle"), 1);
        }
    }

    private void addStatusSet() {
        String status = JmriJOptionPane.showInputDialog(this, Bundle.getMessage("StatusName"), Bundle.getMessage("createNewFamily"), 3);
        if (status != null) {
            this.addStatus(status);
        }
    }

    private void deleteStatusSet() {
        Set<String> set = this._iconGroupsMap.keySet();
        HashMap<String, String> options = new HashMap<String, String>();
        for (String status : set) {
            options.put(ItemPalette.convertText(status), status);
        }
        Object[] selections = options.keySet().toArray();
        String key = (String)JmriJOptionPane.showInputDialog(this, Bundle.getMessage("PickDelete"), Bundle.getMessage("QuestionTitle"), 3, null, selections, selections[0]);
        if (key != null) {
            this._iconGroupsMap.remove(options.get(key));
            IndicatorTOItemPanel p = (IndicatorTOItemPanel)this._parent;
            if (this._iconGroupsMap.isEmpty()) {
                p.deleteFamilySet();
                this.dispose();
            }
            p.addIcons2Panel(this._iconGroupsMap, this._iconEditPanel, true);
            this._iconEditPanel.invalidate();
            this.pack();
        }
    }

    private void addStatus(String status) {
        HashMap<String, NamedIcon> iconMap = this._parent.makeNewIconMap("Turnout");
        this._iconGroupsMap.put(status, iconMap);
        IndicatorTOItemPanel p = (IndicatorTOItemPanel)this._parent;
        p.addIcons2Panel(this._iconGroupsMap, this._iconEditPanel, true);
        this._iconEditPanel.invalidate();
        this.pack();
    }
}

