/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.Turnout;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.IndicatorTurnoutIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.DetectionPanel;
import jmri.jmrit.display.palette.IndicatorTOIconDialog;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.jmrit.display.palette.TableItemPanel;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.ImagePanel;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorTOItemPanel
extends TableItemPanel<Turnout> {
    private JPanel _tablePanel;
    private HashMap<String, HashMap<String, NamedIcon>> _unstoredMaps;
    private DetectionPanel _detectPanel;
    protected HashMap<String, HashMap<String, NamedIcon>> _iconGroupsMap;
    private static final Logger log = LoggerFactory.getLogger(IndicatorTOItemPanel.class);

    public IndicatorTOItemPanel(DisplayFrame parentFrame, String type, String family, PickListModel<Turnout> model) {
        super(parentFrame, type, family, model);
    }

    @Override
    public void init() {
        if (!this._initialized) {
            super.init();
            this._detectPanel = new DetectionPanel(this);
            this.add((Component)this._detectPanel, 1);
        }
        this.hideIcons();
    }

    @Override
    public void init(JPanel bottomPanel) {
        super.init(bottomPanel);
        this.add((Component)this._iconFamilyPanel, 0);
    }

    public void initUpdate(ActionListener doneAction, HashMap<String, HashMap<String, NamedIcon>> iconMaps) {
        this._iconGroupsMap = iconMaps;
        if (iconMaps != null) {
            this.checkCurrentMaps(iconMaps);
        }
        if (this._family == null || this._family.isEmpty()) {
            this._family = Bundle.getMessage("unNamed");
        }
        this._detectPanel = new DetectionPanel(this);
        super.init(doneAction, null);
        this.add((Component)this._detectPanel, 1);
        this.add((Component)this._iconFamilyPanel, 2);
    }

    private void checkCurrentMaps(HashMap<String, HashMap<String, NamedIcon>> iconMaps) {
        String family = this.getValidFamily(this._family, iconMaps);
        if (this._isUnstoredMap) {
            this._unstoredMaps = iconMaps;
            int result = JmriJOptionPane.showConfirmDialog(this._frame.getEditor(), Bundle.getMessage("UnkownFamilyName", family), Bundle.getMessage("QuestionTitle"), 0, 3);
            if (result == 0) {
                ItemPalette.addLevel4Family(this._itemType, family, iconMaps);
            }
            this._family = family;
        } else if (family != null) {
            if (!family.equals(this._family)) {
                log.info("{} icon's family \"{}\" found but is called \"{}\" in the Catalog.  Name changed to Catalog name.", new Object[]{this._itemType, this._family, family});
                this._family = family;
            }
            return;
        }
    }

    protected String getValidFamily(String family, HashMap<String, HashMap<String, NamedIcon>> iconMap) {
        String mapFamily;
        HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> families = ItemPalette.getLevel4FamilyMaps(this._itemType);
        if (families == null || families.isEmpty()) {
            return null;
        }
        if (iconMap != null) {
            mapFamily = this.findFamilyOfMaps(null, iconMap, families);
            if (log.isDebugEnabled()) {
                log.debug("getValidFamily: findFamilyOfMaps {} found stored family \"{}\" for family \"{}\".", new Object[]{this._itemType, mapFamily, family});
            }
            if (mapFamily == null) {
                this._isUnstoredMap = true;
            } else {
                this._isUnstoredMap = false;
                if (family != null) {
                    return mapFamily;
                }
            }
        }
        mapFamily = family;
        boolean nameOK = false;
        block0: while (!nameOK) {
            Container fr;
            if ((mapFamily == null || mapFamily.isEmpty()) && ((mapFamily = JmriJOptionPane.showInputDialog(fr = this._dialog != null ? this._dialog : this, Bundle.getMessage("EnterFamilyName"), Bundle.getMessage("createNewFamily"), 3)) == null || mapFamily.isEmpty())) {
                return null;
            }
            for (String fam : families.keySet()) {
                log.debug("check names. fam={} family={} mapFamily={}", new Object[]{fam, family, mapFamily});
                if (mapFamily.equals(fam)) {
                    JmriJOptionPane.showMessageDialog(this._frame, Bundle.getMessage("DuplicateFamilyName", mapFamily, this._itemType, Bundle.getMessage("UseAnotherName")), Bundle.getMessage("WarningTitle"), 2);
                    mapFamily = null;
                    nameOK = false;
                    continue block0;
                }
                nameOK = true;
            }
        }
        return mapFamily;
    }

    protected String findFamilyOfMaps(String exemptFamily, HashMap<String, HashMap<String, NamedIcon>> newMap, HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> families) {
        for (Map.Entry<String, HashMap<String, HashMap<String, NamedIcon>>> entry : families.entrySet()) {
            String family = entry.getKey();
            if (family.equals(exemptFamily)) continue;
            log.debug(" familyKey = {}", (Object)entry.getKey());
            HashMap<String, HashMap<String, NamedIcon>> statusMaps = entry.getValue();
            if (!this.familiesAreEqual(newMap, statusMaps)) continue;
            return family;
        }
        return null;
    }

    protected boolean familiesAreEqual(HashMap<String, HashMap<String, NamedIcon>> famOne, HashMap<String, HashMap<String, NamedIcon>> famTwo) {
        if (famOne.size() != famTwo.size()) {
            return false;
        }
        for (Map.Entry<String, HashMap<String, NamedIcon>> ent : famOne.entrySet()) {
            String statusKey = ent.getKey();
            log.debug("  statusKey = {}", (Object)statusKey);
            HashMap<String, NamedIcon> map = famTwo.get(statusKey);
            if (map == null) {
                return false;
            }
            if (!this.mapsAreEqual(ent.getValue(), map)) {
                return false;
            }
            log.debug("  status {}'s are equal.", (Object)statusKey);
        }
        return true;
    }

    @Override
    protected boolean namesStoredMap(String family) {
        HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> families = ItemPalette.getLevel4FamilyMaps(this._itemType);
        return families.keySet().contains(family);
    }

    @Override
    protected JPanel initTablePanel(PickListModel<Turnout> model) {
        this._tablePanel = super.initTablePanel(model);
        return this._tablePanel;
    }

    @Override
    public void dispose() {
        if (this._detectPanel != null) {
            this._detectPanel.dispose();
        }
        super.dispose();
    }

    @Override
    protected void makeFamiliesPanel() {
        HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> families = ItemPalette.getLevel4FamilyMaps(this._itemType);
        boolean isEmpty = families.values().isEmpty();
        if (this._bottomPanel == null) {
            this.makeBottomPanel(isEmpty);
        } else if (isEmpty ^ this._wasEmpty) {
            this.remove(this._bottomPanel);
            this.makeBottomPanel(isEmpty);
        }
        this._wasEmpty = isEmpty;
        if (isEmpty) {
            this._iconGroupsMap = this._unstoredMaps;
            this.addIcons2Panel(this._iconGroupsMap, this._iconPanel, false);
            if (!this._suppressDragging) {
                this.makeDragIconPanel();
                this.makeDndIcon();
            }
            this.addFamilyPanels(false);
        } else {
            this.makeFamiliesPanel(families);
        }
    }

    private void makeFamiliesPanel(@Nonnull HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> families) {
        this.makeFamilyButtons(families.keySet());
        if (this._iconGroupsMap == null) {
            this._iconGroupsMap = families.get(this._family);
            if (this._iconGroupsMap == null) {
                this._isUnstoredMap = true;
                this._iconGroupsMap = this._unstoredMaps;
            }
        }
        this.addIcons2Panel(this._iconGroupsMap, this._iconPanel, false);
        if (!this._suppressDragging) {
            this.makeDragIconPanel();
            this.makeDndIcon();
        }
        this.addFamilyPanels(!families.isEmpty());
    }

    @Override
    protected String getDisplayKey() {
        return "TurnoutStateClosed";
    }

    protected void addIcons2Panel(HashMap<String, HashMap<String, NamedIcon>> iconMaps, ImagePanel iconPanel, boolean dropIcon) {
        if (iconMaps == null) {
            return;
        }
        GridBagLayout gridbag = new GridBagLayout();
        iconPanel.setLayout(gridbag);
        iconPanel.removeAll();
        GridBagConstraints c = ItemPanel.itemGridBagConstraint();
        if (iconMaps.isEmpty()) {
            iconPanel.add(Box.createRigidArea(new Dimension(70, 70)));
        }
        for (Map.Entry<String, HashMap<String, NamedIcon>> stringHashMapEntry : iconMaps.entrySet()) {
            c.gridx = 0;
            ++c.gridy;
            String statusName = stringHashMapEntry.getKey();
            JPanel panel = new JPanel();
            panel.add(new JLabel(ItemPalette.convertText(statusName)));
            panel.setOpaque(false);
            gridbag.setConstraints(panel, c);
            iconPanel.add(panel);
            ++c.gridx;
            HashMap<String, NamedIcon> iconMap = stringHashMapEntry.getValue();
            ItemPanel.checkIconMap("Turnout", iconMap);
            for (Map.Entry<String, NamedIcon> ent : iconMap.entrySet()) {
                String key = ent.getKey();
                panel = this.makeIconDisplayPanel(key, iconMap, dropIcon);
                gridbag.setConstraints(panel, c);
                iconPanel.add(panel);
                ++c.gridx;
            }
        }
    }

    @Override
    protected void hideIcons() {
        if (this._tablePanel != null) {
            this._tablePanel.setVisible(true);
            this._tablePanel.invalidate();
        }
        if (this._detectPanel != null) {
            this._detectPanel.setVisible(true);
            this._detectPanel.invalidate();
        }
        super.hideIcons();
    }

    @Override
    protected void showIcons() {
        if (this._detectPanel != null) {
            this._detectPanel.setVisible(false);
            this._detectPanel.invalidate();
        }
        if (this._tablePanel != null) {
            this._tablePanel.setVisible(false);
            this._tablePanel.invalidate();
        }
        super.showIcons();
    }

    @Override
    protected void deleteFamilySet() {
        if (JmriJOptionPane.showConfirmDialog(this._frame, Bundle.getMessage("confirmDelete", this._family), Bundle.getMessage("QuestionTitle"), 0, 3) == 0) {
            ItemPalette.removeLevel4IconMap(this._itemType, this._family, null);
            this._family = null;
            this._tablePanel.setVisible(true);
            this.updateFamiliesPanel();
            this.setFamily(this._family);
        }
    }

    protected HashMap<String, HashMap<String, NamedIcon>> makeNewIconMap() {
        HashMap<String, HashMap<String, NamedIcon>> map = new HashMap<String, HashMap<String, NamedIcon>>();
        for (String statusKey : INDICATOR_TRACK) {
            map.put(statusKey, this.makeNewIconMap("Turnout"));
        }
        return map;
    }

    protected void makeDndIcon() {
        if (this._iconGroupsMap != null) {
            this.makeDndIcon(this._iconGroupsMap.get("ClearTrack"));
        } else {
            this.makeDndIcon(null);
        }
    }

    @Override
    protected void setFamilyMaps() {
        this._iconGroupsMap = ItemPalette.getLevel4Family(this._itemType, this._family);
        if (this._iconGroupsMap == null) {
            this._isUnstoredMap = true;
            this._iconGroupsMap = this._unstoredMaps;
        }
        if (!this._suppressDragging) {
            this.makeDragIconPanel();
            this.makeDndIcon();
        }
        this.addIcons2Panel(this._iconGroupsMap, this._iconPanel, false);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Cast follows specific Constructor")
    protected void openDialog(String type, String family) {
        this.closeDialogs();
        this.hideIcons();
        this._dialog = new IndicatorTOIconDialog(type, family, this);
        IndicatorTOIconDialog d = (IndicatorTOIconDialog)this._dialog;
        if (this._family == null) {
            d.setMaps(null);
        } else {
            d.setMaps(this._iconGroupsMap);
        }
        d.pack();
    }

    protected void dialogDone(String family, HashMap<String, HashMap<String, NamedIcon>> iconMap) {
        if (!(this._update || family.equals(this._family) && this.familiesAreEqual(iconMap, this._iconGroupsMap))) {
            ItemPalette.removeLevel4IconMap(this._itemType, this._family, null);
            ItemPalette.addLevel4Family(this._itemType, family, iconMap);
        } else {
            this._iconGroupsMap = iconMap;
            if (!this.namesStoredMap(family)) {
                this._isUnstoredMap = true;
            }
            if (this._isUnstoredMap) {
                this._unstoredMaps = this._iconGroupsMap;
            }
        }
        this._family = family;
        this.makeFamiliesPanel();
        this.setFamily(family);
        this._cntlDown = false;
        this.hideIcons();
        if (log.isDebugEnabled()) {
            log.debug("dialogDoneAction done for {} {}. {} unStored={}", new Object[]{this._itemType, this._family, this._update ? "update" : "", this._isUnstoredMap});
        }
    }

    public boolean getShowTrainName() {
        return this._detectPanel.getShowTrainName();
    }

    public void setShowTrainName(boolean show) {
        this._detectPanel.setShowTrainName(show);
    }

    public String getOccSensor() {
        return this._detectPanel.getOccSensor();
    }

    public String getOccBlock() {
        return this._detectPanel.getOccBlock();
    }

    public void setOccDetector(String name) {
        this._detectPanel.setOccDetector(name);
    }

    public ArrayList<String> getPaths() {
        return this._detectPanel.getPaths();
    }

    public void setPaths(ArrayList<String> paths) {
        this._detectPanel.setPaths(paths);
    }

    public HashMap<String, HashMap<String, NamedIcon>> getIconMaps() {
        if (this._iconGroupsMap != null) {
            return this._iconGroupsMap;
        }
        this._iconGroupsMap = ItemPalette.getLevel4FamilyMaps(this._itemType).get(this._family);
        if (this._iconGroupsMap == null) {
            this._iconGroupsMap = this._unstoredMaps;
        }
        if (this._iconGroupsMap == null) {
            log.warn("Family \"{}\" for type \"{}\" not found.", (Object)this._family, (Object)this._itemType);
            this._iconGroupsMap = this.makeNewIconMap();
        }
        return this._iconGroupsMap;
    }

    @Override
    protected JLabel getDragger(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
        return new IconDragJLabel(flavor, icon);
    }

    protected class IconDragJLabel
    extends DragJLabel {
        public IconDragJLabel(DataFlavor flavor, NamedIcon icon) {
            super(flavor, icon);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return super.isDataFlavorSupported(flavor);
        }

        @Override
        protected boolean okToDrag() {
            Object bean = IndicatorTOItemPanel.this.getDeviceNamedBean();
            if (bean == null) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("noRowSelected"), Bundle.getMessage("WarningTitle"), 2);
                return false;
            }
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            Object bean = IndicatorTOItemPanel.this.getDeviceNamedBean();
            if (bean == null) {
                return null;
            }
            HashMap<String, HashMap<String, NamedIcon>> iconMap = IndicatorTOItemPanel.this.getIconMaps();
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                IndicatorTurnoutIcon t = new IndicatorTurnoutIcon(IndicatorTOItemPanel.this._frame.getEditor());
                t.setOccBlock(IndicatorTOItemPanel.this._detectPanel.getOccBlock());
                t.setOccSensor(IndicatorTOItemPanel.this._detectPanel.getOccSensor());
                t.setShowTrain(IndicatorTOItemPanel.this._detectPanel.getShowTrainName());
                t.setTurnout(bean.getSystemName());
                t.setFamily(IndicatorTOItemPanel.this._family);
                for (Map.Entry<String, HashMap<String, NamedIcon>> entry : iconMap.entrySet()) {
                    String status = entry.getKey();
                    for (Map.Entry<String, NamedIcon> ent : entry.getValue().entrySet()) {
                        t.setIcon(status, ent.getKey(), new NamedIcon(ent.getValue()));
                    }
                }
                t.setLevel(7);
                return t;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                StringBuilder sb = new StringBuilder(IndicatorTOItemPanel.this._itemType);
                sb.append(" icons for \"");
                sb.append(bean.getDisplayName());
                sb.append("\"");
                return sb.toString();
            }
            return null;
        }
    }
}

