/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import jmri.CatalogTree;
import jmri.CatalogTreeLeaf;
import jmri.CatalogTreeManager;
import jmri.CatalogTreeNode;
import jmri.InstanceManager;
import jmri.Light;
import jmri.Sensor;
import jmri.Turnout;
import jmri.jmrit.XmlFile;
import jmri.jmrit.catalog.DirectorySearcher;
import jmri.jmrit.catalog.ImageIndexEditor;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.palette.BackgroundItemPanel;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.ClockItemPanel;
import jmri.jmrit.display.palette.GlobalVariableItemPanel;
import jmri.jmrit.display.palette.IconItemPanel;
import jmri.jmrit.display.palette.IndicatorItemPanel;
import jmri.jmrit.display.palette.IndicatorTOItemPanel;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.jmrit.display.palette.MemoryItemPanel;
import jmri.jmrit.display.palette.MultiSensorItemPanel;
import jmri.jmrit.display.palette.PortalItemPanel;
import jmri.jmrit.display.palette.RPSItemPanel;
import jmri.jmrit.display.palette.ReporterItemPanel;
import jmri.jmrit.display.palette.SignalHeadItemPanel;
import jmri.jmrit.display.palette.SignalMastItemPanel;
import jmri.jmrit.display.palette.TableItemPanel;
import jmri.jmrit.display.palette.TextItemPanel;
import jmri.jmrit.picker.PickListModel;
import jmri.util.FileUtil;
import jmri.util.PlaceWindow;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemPalette
extends DisplayFrame
implements ChangeListener {
    public static final int STRUT_SIZE = 5;
    static final String RED_X = "resources/icons/misc/X-red.gif";
    @GuardedBy(value="ItemPalette")
    static JTabbedPane _tabPane;
    @GuardedBy(value="ItemPalette")
    static HashMap<String, ItemPanel> _tabIndex;
    private static volatile HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> _iconMaps;
    private static volatile HashMap<String, HashMap<String, HashMap<String, HashMap<String, NamedIcon>>>> _indicatorTOMaps;
    private static int tabWidth;
    private ItemPanel _currentItemPanel;
    private static final Logger log;

    public static void storeIcons() {
        if (_iconMaps == null) {
            return;
        }
        CatalogTreeManager manager = InstanceManager.getDefault(CatalogTreeManager.class);
        CatalogTree tree = manager.getBySystemName("NXPI");
        if (tree != null) {
            manager.deregister(tree);
        }
        tree = manager.newCatalogTree("NXPI", "Item Palette");
        CatalogTreeNode root = tree.getRoot();
        for (Map.Entry<String, HashMap<String, HashMap<String, NamedIcon>>> entry : _iconMaps.entrySet()) {
            root.add(ItemPalette.store3levelMap(entry.getKey(), entry.getValue()));
            if (!log.isDebugEnabled()) continue;
            log.debug("Add type node {}", (Object)entry.getKey());
        }
        for (Map.Entry<String, HashMap<String, HashMap<String, Serializable>>> entry : _indicatorTOMaps.entrySet()) {
            CatalogTreeNode typeNode = new CatalogTreeNode(entry.getKey());
            for (Map.Entry<String, HashMap<String, Serializable>> ent : entry.getValue().entrySet()) {
                typeNode.add(ItemPalette.store3levelMap(ent.getKey(), ent.getValue()));
                log.debug("Add IndicatorTO node {}", (Object)ent.getKey());
            }
            root.add(typeNode);
            log.debug("Add IndicatorTO node {}", (Object)entry.getKey());
        }
    }

    static CatalogTreeNode store3levelMap(String type, HashMap<String, HashMap<String, NamedIcon>> familyMap) {
        CatalogTreeNode typeNode = new CatalogTreeNode(type);
        for (Map.Entry<String, HashMap<String, NamedIcon>> mapEntry : familyMap.entrySet()) {
            String family = mapEntry.getKey();
            CatalogTreeNode familyNode = new CatalogTreeNode(family);
            HashMap<String, NamedIcon> iconMap = mapEntry.getValue();
            for (Map.Entry<String, NamedIcon> iconEntry : iconMap.entrySet()) {
                String state = iconEntry.getKey();
                String path = iconEntry.getValue().getURL();
                familyNode.addLeaf(state, path);
            }
            typeNode.add(familyNode);
            log.debug("Add familyNode {}", (Object)familyNode);
        }
        return typeNode;
    }

    public static void loadIcons() {
        if (_iconMaps == null) {
            InstanceManager.getDefault(CatalogTreeManager.class).loadImageIndex();
            _iconMaps = new HashMap();
            _indicatorTOMaps = new HashMap();
            if (!ItemPalette.loadSavedIcons()) {
                ItemPalette.loadDefaultIcons();
            }
        }
    }

    static boolean loadSavedIcons() {
        CatalogTreeManager manager = InstanceManager.getDefault(CatalogTreeManager.class);
        CatalogTree tree = manager.getBySystemName("NXPI");
        if (tree != null) {
            CatalogTreeNode root = tree.getRoot();
            Enumeration<TreeNode> e = root.children();
            while (e.hasMoreElements()) {
                CatalogTreeNode node = (CatalogTreeNode)e.nextElement();
                String typeName = (String)node.getUserObject();
                if (typeName.equals("IndicatorTO")) {
                    HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> familyTOMap = ItemPalette.loadIndicatorFamilyMap(node);
                    log.debug("Add {} indicatorTO families to item type {} for _indicatorTOMaps.", (Object)familyTOMap.size(), (Object)typeName);
                    _indicatorTOMaps.put(typeName, familyTOMap);
                    continue;
                }
                HashMap<String, HashMap<String, NamedIcon>> familyMap = ItemPalette.loadFamilyMap(node);
                _iconMaps.put(typeName, familyMap);
                log.debug("Add item type {} to _iconMaps.", (Object)typeName);
            }
            log.debug("Icon Map has {} members", (Object)_iconMaps.size());
            return true;
        }
        return false;
    }

    static HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> loadIndicatorFamilyMap(CatalogTreeNode node) {
        HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> familyMap = new HashMap<String, HashMap<String, HashMap<String, NamedIcon>>>();
        Enumeration<TreeNode> ee = node.children();
        while (ee.hasMoreElements()) {
            CatalogTreeNode famNode = (CatalogTreeNode)ee.nextElement();
            String name = (String)famNode.getUserObject();
            familyMap.put(name, ItemPalette.loadFamilyMap(famNode));
        }
        return familyMap;
    }

    static HashMap<String, HashMap<String, NamedIcon>> loadFamilyMap(CatalogTreeNode node) {
        HashMap<String, HashMap<String, NamedIcon>> familyMap = new HashMap<String, HashMap<String, NamedIcon>>();
        Enumeration<TreeNode> ee = node.children();
        while (ee.hasMoreElements()) {
            CatalogTreeNode famNode = (CatalogTreeNode)ee.nextElement();
            String familyName = (String)famNode.getUserObject();
            HashMap<String, NamedIcon> iconMap = new HashMap<String, NamedIcon>();
            ArrayList<CatalogTreeLeaf> list = famNode.getLeaves();
            for (CatalogTreeLeaf catalogTreeLeaf : list) {
                String iconName = catalogTreeLeaf.getName();
                String path = catalogTreeLeaf.getPath();
                NamedIcon icon = NamedIcon.getIconByName(path);
                if (icon == null) {
                    log.warn("loadFamilyMap cannot find icon \"{}\" in family\"{}\" at path \"{}\"", new Object[]{iconName, familyName, path});
                    String fileName = RED_X;
                    icon = new NamedIcon(fileName, fileName);
                }
                iconMap.put(iconName, icon);
                log.debug("Add {} icon to family \"{}\"", (Object)iconName, (Object)familyName);
            }
            familyMap.put(familyName, iconMap);
        }
        return familyMap;
    }

    static List<Element> getDefaultIconItemTypes() throws JDOMException, IOException {
        URL file = FileUtil.findURL("xml/defaultPanelIcons.xml");
        if (file == null) {
            throw new IllegalArgumentException("defaultPanelIcons file (xml/defaultPanelIcons.xml) doesn't exist.");
        }
        XmlFile xf = new XmlFile(){};
        Element root = xf.rootFromURL(file);
        return root.getChild("ItemTypes").getChildren();
    }

    static void loadDefaultIcons() {
        try {
            List<Element> typeList = ItemPalette.getDefaultIconItemTypes();
            for (Element type : typeList) {
                String typeName = type.getName();
                List families = type.getChildren();
                ItemPalette.loadFamilies(typeName, families);
            }
        }
        catch (IOException | JDOMException e) {
            log.error("error reading file \"defaultPanelIcons.xml\" due to: ", e);
        }
    }

    static void loadFamilies(String typeName, List<Element> families) {
        if (typeName.equals("IndicatorTO")) {
            HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> familyTOMap = ItemPalette.loadDefaultIndicatorTOMap(families, null);
            _indicatorTOMaps.put(typeName, familyTOMap);
            log.debug("Add {} indicatorTO families to item type {} to _indicatorTOMaps.", (Object)familyTOMap.size(), (Object)typeName);
        } else {
            HashMap<String, HashMap<String, NamedIcon>> familyMap = ItemPalette.loadDefaultFamilyMap(families, null);
            _iconMaps.put(typeName, familyMap);
            log.debug("Add {} families to item type \"{}\" to _iconMaps.", (Object)familyMap.size(), (Object)typeName);
        }
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Stores are not dead. Both statements APPEND additional items into their maps")
    public static void loadMissingItemType(String itemType) {
        try {
            Element thisType = null;
            List<Element> typeList = ItemPalette.getDefaultIconItemTypes();
            for (Element type : typeList) {
                String typeName = type.getName();
                if (!typeName.equals(itemType)) continue;
                thisType = type;
                break;
            }
            if (thisType == null) {
                log.error("No type \"{}\" in file \"defaultPanelIcons.xml\"", (Object)itemType);
                return;
            }
            List families = thisType.getChildren();
            if (itemType.equals("IndicatorTO")) {
                HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> familyMaps = _indicatorTOMaps.get(itemType);
                familyMaps = ItemPalette.loadDefaultIndicatorTOMap(families, familyMaps);
            } else {
                HashMap<String, HashMap<String, NamedIcon>> familyMap = ItemPalette.getFamilyMaps(itemType);
                familyMap = ItemPalette.loadDefaultFamilyMap(families, familyMap);
            }
            InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
        }
        catch (IOException | JDOMException ex) {
            log.error("error reading file \"defaultPanelIcons.xml\" due to: ", ex);
        }
    }

    static HashMap<String, HashMap<String, NamedIcon>> loadDefaultFamilyMap(List<Element> families, HashMap<String, HashMap<String, NamedIcon>> familyMap) {
        if (familyMap == null) {
            familyMap = new HashMap();
        }
        for (Element family : families) {
            String familyName = family.getName();
            HashMap<String, NamedIcon> iconMap = new HashMap<String, NamedIcon>();
            List iconfiles = family.getChildren();
            for (Element iconfile : iconfiles) {
                NamedIcon icon;
                String iconName = iconfile.getName();
                String fileName = iconfile.getText().trim();
                if (fileName.length() == 0) {
                    log.warn("loadDefaultFamilyMap: icon \"{}\" in family \"{}\" has no image file.", (Object)iconName, (Object)familyName);
                    fileName = RED_X;
                }
                if ((icon = NamedIcon.getIconByName(fileName)) == null) {
                    log.warn("loadDefaultFamilyMap: icon \"{}\" in family \"{}\" cannot get icon from file \"{}\".", new Object[]{iconName, familyName, fileName});
                    fileName = RED_X;
                    icon = new NamedIcon(fileName, fileName);
                }
                iconMap.put(iconName, icon);
            }
            familyMap.put(familyName, iconMap);
            if (!log.isDebugEnabled()) continue;
            log.debug("Add {}  icons to family \"{}\"", (Object)iconMap.size(), (Object)familyName);
        }
        return familyMap;
    }

    static HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> loadDefaultIndicatorTOMap(List<Element> typeList, HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> familyTOMap) {
        if (familyTOMap == null) {
            familyTOMap = new HashMap();
        }
        for (Element element : typeList) {
            String familyName = element.getName();
            List types = element.getChildren();
            HashMap<String, HashMap<String, NamedIcon>> familyMap = ItemPalette.loadDefaultFamilyMap(types, null);
            familyTOMap.put(familyName, familyMap);
            if (!log.isDebugEnabled()) continue;
            log.debug("Add {} IndicatorTO sub-families to item type {}  to IndicatorTO families.", (Object)familyMap.size(), (Object)familyName);
        }
        return familyTOMap;
    }

    public static ItemPalette getDefault(String title, @Nonnull Editor ed) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        ItemPalette instance = InstanceManager.getOptionalDefault(ItemPalette.class).orElseGet(() -> InstanceManager.setDefault(ItemPalette.class, new ItemPalette(title, ed)));
        if (!ed.equals(instance.getEditor())) {
            instance.updateBackground(ed);
            InstanceManager.getDefault(PlaceWindow.class).nextTo(ed, null, instance);
        }
        instance.pack();
        InstanceManager.getDefault(PlaceWindow.class).nextTo(ed, null, instance);
        instance.setVisible(true);
        return instance;
    }

    public void setEditor(Editor ed) {
        this.updateBackground(ed);
        InstanceManager.getDefault(PlaceWindow.class).nextTo(ed, null, this);
    }

    public ItemPalette(String title, Editor ed) {
        super(title, ed);
        this.init();
        this.setTitle(Bundle.getMessage("ItemPaletteTitle"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ItemPalette.loadIcons();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ItemPalette.this.closePanels(e);
            }
        });
        this.makeMenus();
        ItemPalette.buildTabPane(this);
        this.setLayout(new BorderLayout(5, 5));
        ItemPalette itemPalette = this;
        synchronized (itemPalette) {
            this.add((Component)_tabPane, "Center");
            JScrollPane sp = (JScrollPane)_tabPane.getSelectedComponent();
            this._currentItemPanel = (ItemPanel)sp.getViewport().getView();
            this._currentItemPanel.hideIcons();
        }
    }

    static void buildTabPane(ItemPalette palette) {
        _tabPane = new JTabbedPane();
        _tabIndex = new HashMap();
        tabWidth = ItemPalette.getTabWidth();
        ItemPanel itemPanel = new TableItemPanel<Turnout>(palette, "Turnout", null, PickListModel.turnoutPickModelInstance());
        ItemPalette.addItemTab(itemPanel, "Turnout", "BeanNameTurnout");
        itemPanel = new TableItemPanel<Sensor>(palette, "Sensor", null, PickListModel.sensorPickModelInstance());
        ItemPalette.addItemTab(itemPanel, "Sensor", "BeanNameSensor");
        itemPanel = new SignalHeadItemPanel((DisplayFrame)palette, "SignalHead", null, PickListModel.signalHeadPickModelInstance());
        ItemPalette.addItemTab(itemPanel, "SignalHead", "BeanNameSignalHead");
        itemPanel = new SignalMastItemPanel((DisplayFrame)palette, "SignalMast", null, PickListModel.signalMastPickModelInstance());
        ItemPalette.addItemTab(itemPanel, "SignalMast", "BeanNameSignalMast");
        itemPanel = new MemoryItemPanel((DisplayFrame)palette, "Memory", null, PickListModel.memoryPickModelInstance());
        ItemPalette.addItemTab(itemPanel, "Memory", "BeanNameMemory");
        itemPanel = new GlobalVariableItemPanel((DisplayFrame)palette, "Global Variable", null, PickListModel.globalVariablePickModelInstance());
        ItemPalette.addItemTab(itemPanel, "GlobalVariable", "BeanNameGlobalVariable");
        itemPanel = new ReporterItemPanel((DisplayFrame)palette, "Reporter", null, PickListModel.reporterPickModelInstance());
        ItemPalette.addItemTab(itemPanel, "Reporter", "BeanNameReporter");
        itemPanel = new TableItemPanel<Light>(palette, "Light", null, PickListModel.lightPickModelInstance());
        ItemPalette.addItemTab(itemPanel, "Light", "BeanNameLight");
        itemPanel = new MultiSensorItemPanel((DisplayFrame)palette, "MultiSensor", null, PickListModel.multiSensorPickModelInstance());
        ItemPalette.addItemTab(itemPanel, "MultiSensor", "MultiSensor");
        itemPanel = new IconItemPanel(palette, "Icon");
        ItemPalette.addItemTab(itemPanel, "Icon", "Icon");
        itemPanel = new BackgroundItemPanel(palette, "Background");
        ItemPalette.addItemTab(itemPanel, "Background", "Background");
        itemPanel = new TextItemPanel(palette, "Text");
        ItemPalette.addItemTab(itemPanel, "Text", "Text");
        itemPanel = new RPSItemPanel(palette, "RPSReporter", null);
        ItemPalette.addItemTab(itemPanel, "RPSReporter", "RPSreporter");
        itemPanel = new ClockItemPanel(palette, "FastClock");
        ItemPalette.addItemTab(itemPanel, "FastClock", "FastClock");
        itemPanel = new IndicatorItemPanel(palette, "IndicatorTrack", null);
        ItemPalette.addItemTab(itemPanel, "IndicatorTrack", "IndicatorTrack");
        itemPanel = new IndicatorTOItemPanel((DisplayFrame)palette, "IndicatorTO", null, PickListModel.turnoutPickModelInstance());
        ItemPalette.addItemTab(itemPanel, "IndicatorTO", "IndicatorTO");
        itemPanel = new PortalItemPanel(palette, "Portal", null);
        ItemPalette.addItemTab(itemPanel, "Portal", "BeanNamePortal");
        ItemPalette.setTabs();
        _tabPane.addChangeListener(palette);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addItemTab(ItemPanel itemPanel, String key, String tabTitle) {
        itemPanel.init();
        JScrollPane scrollPane = new JScrollPane(itemPanel);
        Class<ItemPalette> clazz = ItemPalette.class;
        synchronized (ItemPalette.class) {
            _tabPane.add(Bundle.getMessage(tabTitle), scrollPane);
            _tabIndex.put(key, itemPanel);
            log.debug("_tabIndex.size()={}", (Object)_tabIndex.size());
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    static int getTabWidth() {
        int maxTabWidth = 0;
        for (Map.Entry<String, String> t : ItemPanel.NAME_MAP.entrySet()) {
            maxTabWidth = Math.max(maxTabWidth, new JLabel(Bundle.getMessage(t.getValue())).getWidth());
        }
        return maxTabWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setTabs() {
        JLabel lab = new JLabel();
        lab.setPreferredSize(new Dimension(tabWidth, 30));
        Class<ItemPalette> clazz = ItemPalette.class;
        synchronized (ItemPalette.class) {
            for (int i = 0; i == _tabPane.getTabCount(); ++i) {
                _tabPane.setTabComponentAt(i, lab);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane tp = (JTabbedPane)e.getSource();
        JScrollPane sp = (JScrollPane)tp.getSelectedComponent();
        ItemPanel newItemPanel = (ItemPanel)sp.getViewport().getView();
        newItemPanel.closeDialogs();
        newItemPanel.previewColorChange();
        newItemPanel.revalidate();
        if (this._currentItemPanel != null) {
            this._currentItemPanel.closeDialogs();
        }
        this._currentItemPanel = newItemPanel;
    }

    private void makeMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu findIcon = new JMenu(Bundle.getMessage("findIconMenu"));
        menuBar.add(findIcon);
        JMenuItem editItem = new JMenuItem(Bundle.getMessage("editIndexMenu"));
        editItem.addActionListener(e -> {
            ImageIndexEditor ii = InstanceManager.getDefault(ImageIndexEditor.class);
            ii.pack();
            ii.setVisible(true);
        });
        findIcon.add(editItem);
        findIcon.addSeparator();
        JMenuItem openItem = new JMenuItem(Bundle.getMessage("openDirMenu"));
        openItem.addActionListener(e -> InstanceManager.getDefault(DirectorySearcher.class).openDirectory());
        findIcon.add(openItem);
        JMenuItem searchItem = new JMenuItem(Bundle.getMessage("searchFSMenu"));
        searchItem.addActionListener(e -> DirectorySearcher.instance().searchFS());
        findIcon.add(searchItem);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.display.ItemPalette", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePanels(WindowEvent e) {
        ItemPalette itemPalette = this;
        synchronized (itemPalette) {
            Component[] comps = _tabPane.getComponents();
            if (log.isDebugEnabled()) {
                log.debug("closePanels: tab count= {}", (Object)_tabPane.getTabCount());
            }
            for (Component comp : comps) {
                JViewport vp = (JViewport)((JScrollPane)comp).getComponent(0);
                Component ip = vp.getView();
                if (!(ip instanceof ItemPanel)) continue;
                ((ItemPanel)ip).closeDialogs();
            }
        }
        super.windowClosing(e);
    }

    private static boolean familyNameOK(String type, String family, Iterator<String> it) {
        if (family == null || family.length() == 0) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EnterFamilyName"), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        while (it.hasNext()) {
            String f = it.next();
            if (!family.equals(f)) continue;
            JmriJOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("DuplicateFamilyName"), family, type), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        return true;
    }

    protected static boolean addFamily(String type, String family, HashMap<String, NamedIcon> iconMap) {
        if (family == null) {
            return false;
        }
        HashMap<String, HashMap<String, NamedIcon>> typeMap = ItemPalette.getFamilyMaps(type);
        typeMap.put(family, iconMap);
        InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
        return true;
    }

    @Nonnull
    public static HashMap<String, HashMap<String, NamedIcon>> getFamilyMaps(String type) {
        return _iconMaps.computeIfAbsent(type, k -> new HashMap());
    }

    protected static void removeIconMap(String type, String family) {
        if (log.isDebugEnabled()) {
            log.debug("removeIconMap for family \"{}\" in type \"{}\"", (Object)family, (Object)type);
        }
        HashMap<String, HashMap<String, NamedIcon>> families = ItemPalette.getFamilyMaps(type);
        families.remove(family);
        InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
        if (log.isDebugEnabled()) {
            for (String s : families.keySet()) {
                log.debug("removeIconMap remaining Keys: family \"{}\" in type \"{}\"", (Object)s, (Object)type);
            }
        }
    }

    public static HashMap<String, NamedIcon> getIconMap(String type, String family) {
        HashMap<String, HashMap<String, NamedIcon>> itemMap = _iconMaps.get(type);
        if (itemMap == null) {
            log.error("getIconMap failed. item type \"{}\" not found.", (Object)type);
            return null;
        }
        HashMap<String, NamedIcon> iconMap = itemMap.get(family);
        if (iconMap == null) {
            log.warn("getIconMap failed. family \"{}\" not found in item type \"{}\"", (Object)family, (Object)type);
            return null;
        }
        return ItemPalette.cloneMap(iconMap);
    }

    protected static boolean addLevel4Family(String type, String family, HashMap<String, HashMap<String, NamedIcon>> iconMap) {
        Iterator<String> iter = ItemPalette.getLevel4FamilyMaps(type).keySet().iterator();
        if (ItemPalette.familyNameOK(type, family, iter)) {
            ItemPalette.getLevel4FamilyMaps(type).put(family, iconMap);
            InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
            return true;
        }
        return false;
    }

    protected static void addLevel4FamilyMap(String type, String family, String key, HashMap<String, NamedIcon> iconMap) {
        HashMap<String, HashMap<String, NamedIcon>> familyMap = ItemPalette.getLevel4Family(type, family);
        familyMap.put(key, iconMap);
        InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
    }

    protected static HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> getLevel4FamilyMaps(String type) {
        return _indicatorTOMaps.get(type);
    }

    protected static HashMap<String, HashMap<String, NamedIcon>> getLevel4Family(String type, String family) {
        HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> map = _indicatorTOMaps.get(type);
        return map.get(family);
    }

    protected static void removeLevel4IconMap(String type, String family, String key) {
        if (log.isDebugEnabled()) {
            log.debug("removeLevel4IconMap for indicator family \"{}\" in type \"{}\" with key \"{}\"", new Object[]{family, type, key});
        }
        if (key != null) {
            _indicatorTOMaps.get(type).get(family).remove(key);
        } else {
            _indicatorTOMaps.get(type).remove(family);
        }
        InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
    }

    protected static HashMap<String, NamedIcon> cloneMap(HashMap<String, NamedIcon> map) {
        HashMap<String, NamedIcon> clone = new HashMap<String, NamedIcon>();
        if (map != null) {
            for (Map.Entry<String, NamedIcon> entry : map.entrySet()) {
                String name = entry.getKey();
                NamedIcon icon = new NamedIcon(entry.getValue());
                clone.put(name, icon);
            }
        }
        return clone;
    }

    public static String convertText(String name) {
        String cName;
        try {
            cName = Bundle.getMessage(name);
        }
        catch (Exception e) {
            cName = name;
        }
        return cName;
    }

    static {
        log = LoggerFactory.getLogger(ItemPalette.class);
    }
}

