/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.FamilyItemPanel;
import jmri.jmrit.display.palette.IconDialog;
import jmri.jmrit.display.palette.MultiSensorItemPanel;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSensorIconDialog
extends IconDialog {
    private static final Logger log = LoggerFactory.getLogger(MultiSensorIconDialog.class);

    public MultiSensorIconDialog(String type, String family, FamilyItemPanel parent) {
        super(type, family, parent);
    }

    protected String getIconName() {
        return MultiSensorItemPanel.POSITION[this._iconMap.size() - 3];
    }

    @Override
    protected void makeDoneButtonPanel(JPanel buttonPanel, String text) {
        super.makeDoneButtonPanel(buttonPanel, text);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout());
        JButton addSensor = new JButton(Bundle.getMessage("addIcon"));
        addSensor.addActionListener(a -> {
            if (this.addNewIcon(this.getIconName())) {
                this.finishAddDelete();
            }
        });
        addSensor.setToolTipText(Bundle.getMessage("ToolTipAddPosition"));
        panel2.add(addSensor);
        JButton deleteSensor = new JButton(Bundle.getMessage("deleteIcon"));
        deleteSensor.addActionListener(a -> {
            if (this.deleteIcon()) {
                this.finishAddDelete();
            }
        });
        deleteSensor.setToolTipText(Bundle.getMessage("ToolTipDeletePosition"));
        panel2.add(deleteSensor);
        buttonPanel.add(panel2);
    }

    private void finishAddDelete() {
        this._iconEditPanel.removeAll();
        this._parent.addIconsToPanel(this._iconMap, this._iconEditPanel, true);
        this.pack();
    }

    @Override
    protected boolean doDoneAction() {
        MultiSensorItemPanel parent = (MultiSensorItemPanel)this._parent;
        if (this._iconMap.size() != parent.getIconMap().size()) {
            parent.setSelections();
        }
        return super.doDoneAction();
    }

    private boolean addNewIcon(String name) {
        if (log.isDebugEnabled()) {
            log.debug("addNewIcon Action: iconMap.size()= {}", (Object)this._iconMap.size());
        }
        if (name == null || name.length() == 0) {
            JmriJOptionPane.showMessageDialog(this._parent._frame, Bundle.getMessage("NoIconName"), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        if (this._iconMap.get(name) != null) {
            JmriJOptionPane.showMessageDialog(this._parent._frame, Bundle.getMessage("DuplicateIconName", name), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        String fileName = "resources/icons/misc/X-red.gif";
        NamedIcon icon = new NamedIcon(fileName, fileName);
        this._iconMap.put(name, icon);
        return true;
    }

    private boolean deleteIcon() {
        if (log.isDebugEnabled()) {
            log.debug("deleteSensor Action: iconMap.size()= {}", (Object)this._iconMap.size());
        }
        if (this._iconMap.size() < 4) {
            return false;
        }
        String name = MultiSensorItemPanel.POSITION[this._iconMap.size() - 4];
        this._iconMap.remove(name);
        return true;
    }
}

