/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.panelEditor.configurexml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JFrame;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.panelEditor.PanelEditor;
import jmri.util.gui.GuiLafPreferencesManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelEditorXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(PanelEditorXml.class);

    @Override
    public Element store(Object o) {
        PanelEditor p = (PanelEditor)o;
        Element panel = new Element("paneleditor");
        JFrame frame = p.getTargetFrame();
        Dimension size = frame.getSize();
        Point posn = frame.getLocation();
        panel.setAttribute("class", "jmri.jmrit.display.panelEditor.configurexml.PanelEditorXml");
        panel.setAttribute("name", frame.getTitle());
        panel.setAttribute("x", "" + posn.x);
        panel.setAttribute("y", "" + posn.y);
        panel.setAttribute("height", "" + size.height);
        panel.setAttribute("width", "" + size.width);
        panel.setAttribute("editable", p.isEditable() ? "yes" : "no");
        panel.setAttribute("positionable", p.allPositionable() ? "yes" : "no");
        panel.setAttribute("showtooltips", p.showToolTip() ? "yes" : "no");
        panel.setAttribute("controlling", p.allControlling() ? "yes" : "no");
        panel.setAttribute("hide", p.showHidden() ? "no" : "yes");
        panel.setAttribute("panelmenu", p.isPanelMenuVisible() ? "yes" : "no");
        panel.setAttribute("scrollable", p.getScrollable());
        if (p.getBackgroundColor() != null) {
            panel.setAttribute("redBackground", "" + p.getBackgroundColor().getRed());
            panel.setAttribute("greenBackground", "" + p.getBackgroundColor().getGreen());
            panel.setAttribute("blueBackground", "" + p.getBackgroundColor().getBlue());
        }
        List<Positionable> contents = p.getContents();
        if (log.isDebugEnabled()) {
            log.debug("N elements: {}", (Object)contents.size());
        }
        for (Positionable sub : contents) {
            if (sub == null || !sub.storeItem()) continue;
            try {
                Element e = ConfigXmlManager.elementFromObject(sub);
                if (e == null) continue;
                panel.addContent((Content)e);
            }
            catch (RuntimeException e) {
                log.error("Error storing panel element", (Throwable)e);
            }
        }
        return panel;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        UserPreferencesManager prefsMgr;
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        boolean result = true;
        int x = 0;
        int y = 0;
        int height = 400;
        int width = 300;
        try {
            Attribute a = shared.getAttribute("x");
            if (a != null) {
                x = a.getIntValue();
            }
            if ((a = shared.getAttribute("y")) != null) {
                y = a.getIntValue();
            }
            if ((a = shared.getAttribute("height")) != null) {
                height = a.getIntValue();
            }
            if ((a = shared.getAttribute("width")) != null) {
                width = a.getIntValue();
            }
        }
        catch (DataConversionException e) {
            log.error("failed to convert PanelEditor's attribute");
            result = false;
        }
        String name = "Panel";
        if (shared.getAttribute("name") != null) {
            name = shared.getAttribute("name").getValue();
        }
        if (InstanceManager.getDefault(EditorManager.class).contains(name)) {
            log.warn("File contains a panel with the same name ({}) as an existing panel", (Object)name);
            result = false;
        }
        if (!InstanceManager.getDefault(GuiLafPreferencesManager.class).isEditorUseOldLocSize() && (prefsMgr = InstanceManager.getNullableDefault(UserPreferencesManager.class)) != null) {
            Dimension prefsWindowSize;
            Point prefsWindowLocation = prefsMgr.getWindowLocation(name);
            if (prefsWindowLocation != null) {
                x = (int)prefsWindowLocation.getX();
                y = (int)prefsWindowLocation.getY();
            }
            if ((prefsWindowSize = prefsMgr.getWindowSize(name)) != null && prefsWindowSize.getHeight() != 0.0 && prefsWindowSize.getWidth() != 0.0) {
                height = (int)prefsWindowSize.getHeight();
                width = (int)prefsWindowSize.getWidth();
            }
        }
        PanelEditor panel = new PanelEditor(name);
        panel.setTitle();
        panel.setKeepSize(false);
        panel.getTargetFrame().setLocation(x, y);
        panel.getTargetFrame().setSize(width, height);
        panel.setAllEditable(!shared.getAttributeValue("editable", "yes").equals("no"));
        panel.setAllPositionable(!shared.getAttributeValue("positionable", "yes").equals("no"));
        panel.setAllShowToolTip(!shared.getAttributeValue("showtooltips", "yes").equals("no"));
        panel.setAllControlling(!shared.getAttributeValue("controlling", "yes").equals("no"));
        panel.setShowHidden(!shared.getAttributeValue("hide", "no").equals("yes"));
        panel.setPanelMenuVisible(!shared.getAttributeValue("panelmenu", "yes").equals("no"));
        panel.setScroll(shared.getAttributeValue("scrollable", "both"));
        try {
            int red = shared.getAttribute("redBackground").getIntValue();
            int blue = shared.getAttribute("blueBackground").getIntValue();
            int green = shared.getAttribute("greenBackground").getIntValue();
            panel.setBackgroundColor(new Color(red, green, blue));
        }
        catch (DataConversionException e) {
            log.warn("Could not parse color attributes!");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        panel.initView();
        List panelItems = shared.getChildren();
        for (Element item : panelItems) {
            String adapterName = item.getAttribute("class").getValue();
            log.debug("load via {}", (Object)adapterName);
            try {
                XmlAdapter adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter.load(item, panel);
                if (panel.loadOK()) continue;
                result = false;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JmriConfigureXmlException e) {
                log.error("Exception while loading {}", (Object)item.getName(), (Object)e);
                result = false;
            }
        }
        panel.disposeLoadData();
        panel.pack();
        panel.setAllEditable(panel.isEditable());
        panel.getTargetFrame().setVisible(true);
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerUser(panel);
        }
        panel.getTargetFrame().setLocation(x, y);
        panel.getTargetFrame().setSize(width, height);
        return result;
    }

    @Override
    public int loadOrder() {
        return 390;
    }
}

