/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.switchboardEditor.configurexml;

import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.display.switchboardEditor.BeanSwitch;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanSwitchXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(BeanSwitchXml.class);

    @Override
    public Element store(Object o) {
        BeanSwitch bs = (BeanSwitch)o;
        Element element = new Element("beanswitch");
        element.setAttribute("label", bs.getNameString());
        element.setAttribute("username", bs.getUserNameString());
        if (bs.getNamedBean() != null) {
            element.setAttribute("connected", "true");
        } else {
            element.setAttribute("connected", "false");
        }
        Element textElement = new Element("activeText");
        textElement.setAttribute("text", bs.getActiveText());
        element.addContent((Content)textElement);
        textElement = new Element("inactiveText");
        textElement.setAttribute("text", bs.getInactiveText());
        element.addContent((Content)textElement);
        textElement = new Element("unknownText");
        textElement.setAttribute("text", bs.getUnknownText());
        element.addContent((Content)textElement);
        textElement = new Element("inconsistentText");
        textElement.setAttribute("text", bs.getInconsistentText());
        element.addContent((Content)textElement);
        String txt = bs.getToolTip();
        if (txt != null) {
            Element elem = new Element("tooltip").addContent(txt);
            element.addContent((Content)elem);
        }
        element.setAttribute("class", BeanSwitchXml.class.getName());
        return element;
    }

    @Override
    public void load(Element element, Object o) {
        log.debug("load xml called");
    }
}

