/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.switchboardEditor.configurexml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JFrame;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.switchboardEditor.SwitchBoardLabelDisplays;
import jmri.jmrit.display.switchboardEditor.SwitchboardEditor;
import jmri.util.ColorUtil;
import jmri.util.gui.GuiLafPreferencesManager;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchboardEditorXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(SwitchboardEditorXml.class);

    @Override
    public Element store(Object o) {
        SwitchboardEditor p = (SwitchboardEditor)o;
        Element panel = new Element("switchboardeditor");
        JFrame frame = p.getTargetFrame();
        panel.setAttribute("class", "jmri.jmrit.display.switchboardEditor.configurexml.SwitchboardEditorXml");
        panel.setAttribute("name", frame.getTitle());
        panel.setAttribute("editable", p.isEditable() ? "yes" : "no");
        panel.setAttribute("showtooltips", p.showToolTip() ? "yes" : "no");
        panel.setAttribute("controlling", p.allControlling() ? "yes" : "no");
        panel.setAttribute("hide", p.isVisible() ? "no" : "yes");
        panel.setAttribute("panelmenu", p.isPanelMenuVisible() ? "yes" : "no");
        panel.setAttribute("scrollable", p.getScrollable());
        panel.setAttribute("hideunconnected", p.hideUnconnected() ? "yes" : "no");
        panel.setAttribute("autoitemrange", p.autoItemRange() ? "yes" : "no");
        panel.setAttribute("rangemin", "" + p.getPanelMenuRangeMin());
        panel.setAttribute("rangemax", "" + p.getPanelMenuRangeMax());
        panel.setAttribute("type", p.getSwitchType());
        panel.setAttribute("connection", p.getSwitchManu());
        panel.setAttribute("shape", p.getSwitchShape());
        panel.setAttribute("rows", "" + p.getRows());
        panel.setAttribute("total", "" + p.getTotal());
        panel.setAttribute("showusername", p.showUserName());
        panel.setAttribute("iconscale", "" + p.getIconScale());
        panel.setAttribute("defaulttextcolor", p.getDefaultTextColor());
        panel.setAttribute("activecolor", p.getActiveSwitchColor());
        panel.setAttribute("inactivecolor", p.getInactiveSwitchColor());
        if (p.getBackgroundColor() != null) {
            panel.setAttribute("redBackground", "" + p.getBackgroundColor().getRed());
            panel.setAttribute("greenBackground", "" + p.getBackgroundColor().getGreen());
            panel.setAttribute("blueBackground", "" + p.getBackgroundColor().getBlue());
        }
        return panel;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        UserPreferencesManager prefsMgr;
        Attribute a;
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        boolean result = true;
        int x = 0;
        int y = 0;
        int height = 400;
        int width = 300;
        int rangemin = 1;
        int rangemax = 32;
        int rows = 4;
        int iconscale = 100;
        try {
            a = shared.getAttribute("x");
            if (a != null) {
                x = a.getIntValue();
            }
            if ((a = shared.getAttribute("y")) != null) {
                y = a.getIntValue();
            }
            if ((a = shared.getAttribute("height")) != null) {
                height = a.getIntValue();
            }
            if ((a = shared.getAttribute("width")) != null) {
                width = a.getIntValue();
            }
        }
        catch (DataConversionException e) {
            log.error("failed to convert Switchboard's attribute");
            result = false;
        }
        String name = "Switchboard";
        if (shared.getAttribute("name") != null) {
            name = shared.getAttribute("name").getValue();
        }
        if (InstanceManager.getDefault(EditorManager.class).contains(name)) {
            log.warn("File contains a panel with the same name ({}) as an existing panel", (Object)name);
            result = false;
        }
        if (!InstanceManager.getDefault(GuiLafPreferencesManager.class).isEditorUseOldLocSize() && (prefsMgr = InstanceManager.getNullableDefault(UserPreferencesManager.class)) != null) {
            Dimension prefsWindowSize;
            Point prefsWindowLocation = prefsMgr.getWindowLocation(name);
            if (prefsWindowLocation != null) {
                x = (int)prefsWindowLocation.getX();
                y = (int)prefsWindowLocation.getY();
            }
            if ((prefsWindowSize = prefsMgr.getWindowSize(name)) != null && prefsWindowSize.getHeight() != 0.0 && prefsWindowSize.getWidth() != 0.0) {
                height = (int)prefsWindowSize.getHeight();
                width = (int)prefsWindowSize.getWidth();
            }
        }
        SwitchboardEditor panel = new SwitchboardEditor(name);
        InstanceManager.getDefault(EditorManager.class).add(panel);
        panel.getTargetFrame().setLocation(x, y);
        panel.getTargetFrame().setSize(width, height);
        panel.setTitle();
        boolean value = true;
        a = shared.getAttribute("editable");
        if (a != null && a.getValue().equals("no")) {
            value = false;
        }
        panel.setAllEditable(value);
        a = shared.getAttribute("showtooltips");
        value = a == null || !a.getValue().equals("no");
        panel.setAllShowToolTip(value);
        a = shared.getAttribute("controlling");
        value = a == null || !a.getValue().equals("no");
        panel.setAllControlling(value);
        a = shared.getAttribute("hide");
        value = a != null && a.getValue().equals("yes");
        panel.setShowHidden(value);
        a = shared.getAttribute("panelmenu");
        value = a == null || !a.getValue().equals("no");
        panel.setPanelMenuVisible(value);
        String state = "both";
        a = shared.getAttribute("scrollable");
        if (a != null) {
            state = a.getValue();
        }
        panel.setScroll(state);
        a = shared.getAttribute("hideunconnected");
        value = a != null && a.getValue().equals("yes");
        panel.setHideUnconnected(value);
        a = shared.getAttribute("autoitemrange");
        value = a == null || !a.getValue().equals("no");
        panel.setAutoItemRange(value);
        try {
            rangemin = shared.getAttribute("rangemin").getIntValue();
            rangemax = shared.getAttribute("rangemax").getIntValue();
        }
        catch (DataConversionException e) {
            log.error("failed to convert Switchboard's range");
            result = false;
        }
        panel.setPanelMenuRangeMin(rangemin);
        panel.setPanelMenuRangeMax(rangemax);
        String type = shared.getAttribute("type").getValue();
        panel.setSwitchType(type);
        String connection = shared.getAttribute("connection").getValue();
        panel.setSwitchManu(connection);
        log.debug("SwitchBoard connection choice set to {}", (Object)connection);
        String shape = shared.getAttribute("shape").getValue();
        panel.setSwitchShape(shape);
        if (shared.getAttribute("columns") != null) {
            try {
                rows = shared.getAttribute("columns").getIntValue();
            }
            catch (DataConversionException e) {
                log.error("failed to convert Switchboard's row (formerly column) count");
                result = false;
            }
        }
        if (shared.getAttribute("rows") != null) {
            try {
                rows = shared.getAttribute("rows").getIntValue();
            }
            catch (DataConversionException e) {
                log.error("failed to convert Switchboard's row count");
                result = false;
            }
        }
        panel.setRows(rows);
        a = shared.getAttribute("showusername");
        if (a == null || a.getValue().equals("yes")) {
            panel.setShowUserName(SwitchBoardLabelDisplays.BOTH_NAMES);
        } else if (a.getValue().equals("no")) {
            panel.setShowUserName(SwitchBoardLabelDisplays.SYSTEM_NAME);
        } else {
            panel.setShowUserName(SwitchBoardLabelDisplays.USER_NAME);
        }
        if (shared.getAttribute("iconscale") != null) {
            try {
                iconscale = shared.getAttribute("iconscale").getIntValue();
            }
            catch (DataConversionException e) {
                log.error("failed to convert Switchboard's icon scale setting");
                result = false;
            }
        }
        panel.setIconScale(iconscale);
        Color defaultTextColor = Color.BLACK;
        if (shared.getAttribute("defaulttextcolor") != null) {
            String color = shared.getAttribute("defaulttextcolor").getValue();
            try {
                defaultTextColor = ColorUtil.stringToColor(color);
            }
            catch (IllegalArgumentException ex) {
                log.error("Invalid defaulttextcolor {} using black", (Object)color);
            }
        }
        panel.setDefaultTextColor(defaultTextColor);
        try {
            int red = shared.getAttribute("redBackground").getIntValue();
            int blue = shared.getAttribute("blueBackground").getIntValue();
            int green = shared.getAttribute("greenBackground").getIntValue();
            panel.setDefaultBackgroundColor(new Color(red, green, blue));
        }
        catch (DataConversionException e) {
            log.warn("Could not parse color attributes!");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Color activeColor = Color.RED;
        if (shared.getAttribute("activecolor") != null) {
            String color = shared.getAttribute("activecolor").getValue();
            try {
                activeColor = ColorUtil.stringToColor(color);
            }
            catch (IllegalArgumentException ex) {
                log.error("Invalid activecolor {}, using red", (Object)color);
            }
        }
        panel.setDefaultActiveColor(activeColor);
        Color inactiveColor = Color.GREEN;
        if (shared.getAttribute("inactivecolor") != null) {
            String color = shared.getAttribute("inactivecolor").getValue();
            try {
                inactiveColor = ColorUtil.stringToColor(color);
            }
            catch (IllegalArgumentException ex) {
                log.error("Invalid inactivecolor {}, using green", (Object)color);
            }
        }
        panel.setDefaultInactiveColor(inactiveColor);
        panel.initView();
        List panelItems = shared.getChildren();
        for (Element item : panelItems) {
            String adapterName = item.getAttribute("class").getValue();
            log.debug("load via {}", (Object)adapterName);
            try {
                XmlAdapter adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter.load(item, panel);
                if (panel.loadOK()) continue;
                result = false;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JmriConfigureXmlException e) {
                log.error("Exception while loading {}", (Object)item.getName(), (Object)e);
                result = false;
            }
        }
        panel.disposeLoadData();
        panel.pack();
        panel.setAllEditable(panel.isEditable());
        panel.getTargetFrame().setVisible(true);
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerUser(panel);
        }
        panel.getTargetFrame().setLocation(x, y);
        panel.getTargetFrame().setSize(width, height);
        panel.updatePressed();
        log.debug("Switchboard ready");
        return result;
    }

    @Override
    public int loadOrder() {
        return 390;
    }
}

