/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.entryexit;

import jmri.Block;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.entryexit.PointDetails;
import jmri.jmrit.entryexit.Source;

public class ManuallySetRoute {
    LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
    PointDetails sourcePoint = null;
    NamedBean destLoc = null;
    int depth = 0;

    public ManuallySetRoute(PointDetails pd) {
        this.sourcePoint = pd;
        LayoutBlock facing = this.lbm.getFacingBlockByNamedBean(pd.getSensor(), pd.getPanel());
        EntryExitPairs manager = InstanceManager.getDefault(EntryExitPairs.class);
        for (LayoutBlock pro : this.lbm.getProtectingBlocksByNamedBean(pd.getSensor(), pd.getPanel())) {
            DestinationPoints dp;
            if (!this.findDestPoint(pro, facing)) continue;
            PointDetails dest = manager.providePoint(this.destLoc, pd.getPanel());
            Source src = manager.getSourceForPoint(pd);
            if (dest == null || src == null || (dp = src.getDestForPoint(dest)) == null) continue;
            dp.setInterlockRoute(false);
            break;
        }
    }

    boolean findDestPoint(LayoutBlock pro, LayoutBlock facing) {
        ++this.depth;
        if (this.depth > 50) {
            return false;
        }
        boolean looking = true;
        if (pro.getNumberOfThroughPaths() == 0) {
            this.destLoc = this.lbm.getSensorAtEndBumper(pro.getBlock(), this.sourcePoint.getPanel());
        } else {
            while (looking) {
                Block found = this.cycle(pro, facing);
                if (found != null) {
                    this.destLoc = this.lbm.getFacingBean(pro.getBlock(), found, this.sourcePoint.getPanel(), Sensor.class);
                    if (this.destLoc != null) {
                        looking = false;
                        continue;
                    }
                    this.findDestPoint(this.lbm.getLayoutBlock(found), pro);
                    looking = false;
                    continue;
                }
                looking = false;
            }
        }
        return this.destLoc != null;
    }

    Block cycle(LayoutBlock protect, LayoutBlock face) {
        for (int i = 0; i < protect.getNumberOfThroughPaths(); ++i) {
            if (!protect.isThroughPathActive(i).booleanValue() || protect.getThroughPathSource(i) != face.getBlock()) continue;
            Block found = protect.getThroughPathDestination(i);
            LayoutBlock lfound = this.lbm.getLayoutBlock(found);
            if (found.getState() != 4 || lfound == null || lfound.getUseExtraColor()) continue;
            return found;
        }
        return null;
    }
}

