/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.entryexit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.SensorIcon;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.entryexit.Source;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointDetails {
    LayoutEditor panel = null;
    LayoutBlock facing;
    List<LayoutBlock> protectingBlocks;
    private NamedBean refObj;
    private Object refLoc;
    private Sensor sensor;
    private SignalMast signalmast;
    private SignalHead signalhead;
    static int nxButtonTimeout = 10;
    Source sourceRoute;
    transient Hashtable<DestinationPoints, Source> destinations = new Hashtable(5);
    boolean routeToSet = false;
    boolean routeFromSet = false;
    protected PropertyChangeListener nxButtonListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            PointDetails.this.nxButtonStateChange(e);
        }
    };
    private int nxButtonState = 4;
    transient Thread nxButtonTimeOutThr;
    boolean extendedtime = false;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(PointDetails.class);

    public PointDetails(LayoutBlock facing, List<LayoutBlock> protecting) {
        this.facing = facing;
        this.protectingBlocks = protecting;
    }

    public LayoutBlock getFacing() {
        return this.facing;
    }

    public List<LayoutBlock> getProtecting() {
        return this.protectingBlocks;
    }

    void setRouteTo(boolean boo) {
        this.routeToSet = boo;
    }

    void setRouteFrom(boolean boo) {
        this.routeFromSet = boo;
    }

    public void setPanel(LayoutEditor panel) {
        this.panel = panel;
        for (LayoutEditor layout : InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class)) {
            for (SensorIcon si : layout.getSensorList()) {
                if (this.sensor != si.getNamedBean()) continue;
                this.panel = layout;
                return;
            }
        }
    }

    void setSensor(Sensor sen) {
        if (this.sensor == sen) {
            return;
        }
        if (this.sensor != null) {
            this.sensor.removePropertyChangeListener(this.nxButtonListener);
        }
        this.sensor = sen;
        if (this.sensor != null) {
            this.sensor.addPropertyChangeListener(this.nxButtonListener);
        }
    }

    void addSensorList() {
        this.sensor.addPropertyChangeListener(this.nxButtonListener);
    }

    void removeSensorList() {
        this.sensor.removePropertyChangeListener(this.nxButtonListener);
    }

    private void nxButtonStateChange(PropertyChangeEvent e) {
        if (!e.getPropertyName().equals("KnownState")) {
            return;
        }
        int now = (Integer)e.getNewValue();
        int old = (Integer)e.getOldValue();
        if (old == 1 || old == 8) {
            this.setButtonState(4);
            return;
        }
        DestinationPoints destPoint = null;
        for (Map.Entry<DestinationPoints, Source> entry : this.destinations.entrySet()) {
            destPoint = entry.getKey();
            if (!destPoint.isEnabled() || entry.getValue().getPoint().getNXState() != 8) continue;
            this.setButtonState(8);
            destPoint.activeBean(false);
            log.debug("[nxButtonStateChange] Single point route selected");
            return;
        }
        if (this.sourceRoute != null) {
            if (now == 2 && this.getNXState() == 4) {
                this.setButtonState(8);
                for (Map.Entry<Object, Object> entry : this.sourceRoute.pointToDest.entrySet()) {
                    if (!((DestinationPoints)entry.getValue()).isEnabled() || ((DestinationPoints)entry.getValue()).getUniDirection() || ((PointDetails)entry.getKey()).getNXState() != 8) continue;
                    this.sourceRoute.activeBean((DestinationPoints)entry.getValue(), true);
                }
            } else if (now == 4 && this.getNXState() == 8) {
                this.setButtonState(4);
            } else if (now == 4 && this.getNXState() == 2) {
                this.setButtonState(8);
                for (Map.Entry<Object, Object> entry : this.sourceRoute.pointToDest.entrySet()) {
                    if (!((DestinationPoints)entry.getValue()).isEnabled() || ((DestinationPoints)entry.getValue()).getUniDirection() || ((PointDetails)entry.getKey()).getNXState() != 8) continue;
                    this.sourceRoute.activeBean((DestinationPoints)entry.getValue(), false);
                }
            }
        } else if (destPoint != null) {
            if (now == 2) {
                this.setButtonState(8);
            } else if (this.getNXState() == 2) {
                this.setButtonState(8);
            } else if (this.getNXState() == 8) {
                this.setButtonState(4);
            }
        }
        log.debug("[nxButtonStateChange] Initial button or possible multiple point route");
        InstanceManager.getDefault(EntryExitPairs.class).setMultiPointRoute(this, this.panel);
    }

    void setSignalMast(SignalMast mast) {
        this.signalmast = mast;
    }

    void setSource(Source src) {
        if (this.sourceRoute == src) {
            return;
        }
        this.sourceRoute = src;
    }

    void setDestination(DestinationPoints srcdp, Source src) {
        if (!this.destinations.containsKey(srcdp)) {
            this.destinations.put(srcdp, src);
        }
    }

    void removeDestination(DestinationPoints srcdp) {
        this.destinations.remove(srcdp);
        if (this.sourceRoute == null && this.destinations.isEmpty()) {
            this.stopFlashSensor();
            this.sensor.removePropertyChangeListener(this.nxButtonListener);
            this.setSensor(null);
        }
    }

    void removeSource(Source src) {
        this.sourceRoute = null;
        if (this.destinations.isEmpty()) {
            this.stopFlashSensor();
            this.setSensor(null);
        }
    }

    void setButtonState(int state) {
        this.setNXButtonState(state);
    }

    void setNXState(int state) {
        if (state == this.nxButtonState) {
            return;
        }
        if (state == 8) {
            this.nxButtonTimeOut();
            this.flashSensor();
        } else {
            this.cancelNXButtonTimeOut();
            this.stopFlashSensor();
        }
        this.nxButtonState = state;
    }

    public int getNXState() {
        return this.nxButtonState;
    }

    SignalMast getSignalMast() {
        return this.signalmast;
    }

    void setSignalHead(SignalHead head) {
        this.signalhead = head;
    }

    SignalHead getSignalHead() {
        return this.signalhead;
    }

    public LayoutEditor getPanel() {
        return this.panel;
    }

    public void setRefObject(NamedBean refObs) {
        for (LayoutEditor pnl : InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class)) {
            if (this.refLoc != null) continue;
            this.setRefObjectByPanel(refObs, pnl);
        }
    }

    public void setRefObjectByPanel(NamedBean refObs, LayoutEditor pnl) {
        this.refObj = refObs;
        if (pnl != null && this.refObj != null) {
            if (this.refObj instanceof SignalMast || this.refObj instanceof Sensor) {
                this.refLoc = pnl.getFinder().findPositionablePointByEastBoundBean(this.refObj);
                if (this.refLoc == null) {
                    this.refLoc = pnl.getFinder().findPositionablePointByWestBoundBean(this.refObj);
                }
                if (this.refLoc == null) {
                    this.refLoc = pnl.getFinder().findLayoutTurnoutByBean(this.refObj);
                }
                if (this.refLoc == null) {
                    this.refLoc = pnl.getFinder().findLevelXingByBean(this.refObj);
                }
                if (this.refLoc == null) {
                    this.refLoc = pnl.getFinder().findLayoutSlipByBean(this.refObj);
                }
                if (this.refObj instanceof Sensor) {
                    this.setSensor((Sensor)this.refObj);
                }
            } else if (this.refObj instanceof SignalHead) {
                String signal = ((SignalHead)this.refObj).getDisplayName();
                this.refLoc = pnl.getFinder().findPositionablePointByEastBoundSignal(signal);
                if (this.refLoc == null) {
                    this.refLoc = pnl.getFinder().findPositionablePointByWestBoundSignal(signal);
                }
            }
        }
    }

    public NamedBean getRefObject() {
        return this.refObj;
    }

    public Object getRefLocation() {
        return this.refLoc;
    }

    public boolean isRouteToPointSet() {
        return this.routeToSet;
    }

    public boolean isRouteFromPointSet() {
        return this.routeFromSet;
    }

    public String getDisplayName() {
        if (this.sensor != null) {
            Object description = this.sensor.getDisplayName();
            if (this.signalmast != null) {
                description = (String)description + " (" + this.signalmast.getDisplayName() + ")";
            }
            return description;
        }
        if (this.refObj instanceof SignalMast) {
            return ((SignalMast)this.refObj).getDisplayName();
        }
        if (this.refObj instanceof Sensor) {
            return ((Sensor)this.refObj).getDisplayName();
        }
        if (this.refObj instanceof SignalHead) {
            return ((SignalHead)this.refObj).getDisplayName();
        }
        return "no display name";
    }

    void nxButtonTimeOut() {
        if (this.nxButtonTimeOutThr != null && this.nxButtonTimeOutThr.isAlive()) {
            return;
        }
        this.extendedtime = true;
        class ButtonTimeOut
        implements Runnable {
            ButtonTimeOut() {
            }

            @Override
            public void run() {
                try {
                    Thread.sleep((long)nxButtonTimeout * 1000L);
                    if (PointDetails.this.extendedtime) {
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException ex) {
                    log.debug("[nxButtonTimeOut] Flash timer cancelled");
                }
                PointDetails.this.setNXButtonState(4);
            }
        }
        ButtonTimeOut t = new ButtonTimeOut();
        this.nxButtonTimeOutThr = ThreadingUtil.newThread(t, "NX Button Timeout " + this.getSensor().getDisplayName());
        this.nxButtonTimeOutThr.start();
    }

    void cancelNXButtonTimeOut() {
        if (this.nxButtonTimeOutThr != null) {
            this.nxButtonTimeOutThr.interrupt();
        }
    }

    public void flashSensor() {
        for (SensorIcon si : this.getPanel().getSensorList()) {
            if (si.getSensor() != this.getSensor()) continue;
            si.flashSensor(2, 2, 4);
        }
    }

    public void stopFlashSensor() {
        for (SensorIcon si : this.getPanel().getSensorList()) {
            if (si.getSensor() != this.getSensor()) continue;
            si.stopFlash();
        }
    }

    public synchronized void setNXButtonState(int state) {
        int sensorState;
        if (this.getSensor() == null) {
            return;
        }
        if (state == 4) {
            if (this.isRouteToPointSet()) {
                state = 2;
            } else if (this.isRouteFromPointSet()) {
                state = 2;
            }
        }
        this.setNXState(state);
        switch (state) {
            case 4: {
                sensorState = 4;
                break;
            }
            case 2: {
                sensorState = 2;
                break;
            }
            case 8: {
                sensorState = 2;
                break;
            }
            default: {
                sensorState = 1;
            }
        }
        if (this.getSensor().getKnownState() != sensorState) {
            this.removeSensorList();
            try {
                this.getSensor().setKnownState(sensorState);
            }
            catch (JmriException ex) {
                log.error("Could not set Sensor known state.", (Throwable)ex);
            }
            this.addSensorList();
        }
    }

    public Sensor getSensor() {
        if (this.getRefObject() == null) {
            return null;
        }
        if (this.getPanel() != null && !this.getPanel().isEditable() && this.sensor != null) {
            return this.sensor;
        }
        if (this.getRefObject() instanceof Sensor) {
            this.setSensor((Sensor)this.getRefObject());
            return (Sensor)this.getRefObject();
        }
        Object objLoc = this.getRefLocation();
        NamedBean objRef = this.getRefObject();
        SignalHead head = null;
        SignalMast mast = null;
        String username = "";
        String systemname = "";
        Sensor foundSensor = null;
        if (objRef instanceof SignalMast) {
            mast = (SignalMast)objRef;
        }
        if (objRef instanceof SignalHead) {
            head = (SignalHead)objRef;
            username = head.getUserName();
            systemname = head.getSystemName();
        }
        SensorManager sm = InstanceManager.sensorManagerInstance();
        if (objLoc instanceof PositionablePoint) {
            PositionablePoint p = (PositionablePoint)objLoc;
            if (mast != null) {
                if (p.getEastBoundSignalMast() == objRef) {
                    foundSensor = p.getEastBoundSensor();
                } else if (p.getWestBoundSignalMast() == objRef) {
                    foundSensor = p.getWestBoundSensor();
                }
            } else if (head != null) {
                if (p.getEastBoundSignal().equals(username) || p.getEastBoundSignal().equals(systemname)) {
                    foundSensor = p.getEastBoundSensor();
                } else if (p.getWestBoundSignal().equals(username) || p.getWestBoundSignal().equals(systemname)) {
                    foundSensor = p.getWestBoundSensor();
                }
            }
        } else if (objLoc instanceof LayoutSlip) {
            LayoutSlip sl = (LayoutSlip)objLoc;
            if (mast != null) {
                if (sl.getSignalAMast() == objRef) {
                    foundSensor = sl.getSensorA();
                } else if (sl.getSignalBMast() == objRef) {
                    foundSensor = sl.getSensorB();
                } else if (sl.getSignalCMast() == objRef) {
                    foundSensor = sl.getSensorC();
                } else if (sl.getSignalDMast() == objRef) {
                    foundSensor = sl.getSensorD();
                }
            }
            if (head != null) {
                if (sl.getSignalA1Name().equals(username) || sl.getSignalA1Name().equals(systemname)) {
                    foundSensor = sm.getSensor(sl.getSensorAName());
                } else if (sl.getSignalB1Name().equals(username) || sl.getSignalB1Name().equals(systemname)) {
                    foundSensor = sm.getSensor(sl.getSensorBName());
                } else if (sl.getSignalC1Name().equals(username) || sl.getSignalC1Name().equals(systemname)) {
                    foundSensor = sm.getSensor(sl.getSensorCName());
                } else if (sl.getSignalD1Name().equals(username) || sl.getSignalD1Name().equals(systemname)) {
                    foundSensor = sm.getSensor(sl.getSensorDName());
                }
            }
        } else if (objLoc instanceof LayoutTurnout) {
            LayoutTurnout t = (LayoutTurnout)objLoc;
            if (mast != null) {
                if (t.getSignalAMast() == objRef) {
                    foundSensor = t.getSensorA();
                } else if (t.getSignalBMast() == objRef) {
                    foundSensor = t.getSensorB();
                } else if (t.getSignalCMast() == objRef) {
                    foundSensor = t.getSensorC();
                } else if (t.getSignalDMast() == objRef) {
                    foundSensor = t.getSensorD();
                }
            }
            if (head != null) {
                if (t.getSignalA1Name().equals(username) || t.getSignalA1Name().equals(systemname)) {
                    foundSensor = t.getSensorA();
                } else if (t.getSignalA2Name().equals(username) || t.getSignalA2Name().equals(systemname)) {
                    foundSensor = t.getSensorA();
                } else if (t.getSignalA3Name().equals(username) || t.getSignalA3Name().equals(systemname)) {
                    foundSensor = t.getSensorA();
                } else if (t.getSignalB1Name().equals(username) || t.getSignalB1Name().equals(systemname)) {
                    foundSensor = t.getSensorB();
                } else if (t.getSignalB2Name().equals(username) || t.getSignalB2Name().equals(systemname)) {
                    foundSensor = t.getSensorB();
                } else if (t.getSignalC1Name().equals(username) || t.getSignalC1Name().equals(systemname)) {
                    foundSensor = t.getSensorC();
                } else if (t.getSignalC2Name().equals(username) || t.getSignalC2Name().equals(systemname)) {
                    foundSensor = t.getSensorC();
                } else if (t.getSignalD1Name().equals(username) || t.getSignalD1Name().equals(systemname)) {
                    foundSensor = t.getSensorD();
                } else if (t.getSignalD2Name().equals(username) || t.getSignalD2Name().equals(systemname)) {
                    foundSensor = t.getSensorD();
                }
            }
        } else if (objLoc instanceof LevelXing) {
            LevelXing x = (LevelXing)objLoc;
            if (mast != null) {
                if (x.getSignalAMast() == objRef) {
                    foundSensor = x.getSensorA();
                } else if (x.getSignalBMast() == objRef) {
                    foundSensor = x.getSensorB();
                } else if (x.getSignalCMast() == objRef) {
                    foundSensor = x.getSensorC();
                } else if (x.getSignalDMast() == objRef) {
                    foundSensor = x.getSensorD();
                }
            }
            if (head != null) {
                if (x.getSignalAName().equals(username) || x.getSignalAName().equals(systemname)) {
                    foundSensor = x.getSensorA();
                } else if (x.getSignalBName().equals(username) || x.getSignalBName().equals(systemname)) {
                    foundSensor = x.getSensorB();
                } else if (x.getSignalCName().equals(username) || x.getSignalCName().equals(systemname)) {
                    foundSensor = x.getSensorC();
                } else if (x.getSignalDName().equals(username) || x.getSignalDName().equals(systemname)) {
                    foundSensor = x.getSensorD();
                }
            }
        }
        this.setSensor(foundSensor);
        return foundSensor;
    }

    NamedBean getSignal() {
        if (this.getPanel() != null && !this.getPanel().isEditable() && this.getSignalMast() != null) {
            return this.getSignalMast();
        }
        if (this.getPanel() != null && !this.getPanel().isEditable() && this.getSignalHead() != null) {
            return this.getSignalHead();
        }
        SignalHeadManager sh = InstanceManager.getDefault(SignalHeadManager.class);
        NamedBean signal = null;
        if (this.getRefObject() == null) {
            log.error("Signal not found at point");
            return null;
        }
        if (this.getRefObject() instanceof SignalMast) {
            signal = this.getRefObject();
            this.setSignalMast((SignalMast)this.getRefObject());
            return signal;
        }
        if (this.getRefObject() instanceof SignalHead) {
            signal = this.getRefObject();
            this.setSignalHead((SignalHead)this.getRefObject());
            return signal;
        }
        Sensor sen = (Sensor)this.getRefObject();
        log.debug("  Looking at sensor '{}' on panel '{}' at '{}'", new Object[]{sen.getDisplayName(), this.getPanel().getLayoutName(), this.getRefLocation()});
        if (this.getRefLocation() instanceof PositionablePoint) {
            PositionablePoint p = (PositionablePoint)this.getRefLocation();
            if (p.getEastBoundSensor() == sen) {
                if (p.getEastBoundSignalMast() != null) {
                    signal = p.getEastBoundSignalMast();
                } else if (!p.getEastBoundSignal().isEmpty()) {
                    signal = sh.getSignalHead(p.getEastBoundSignal());
                }
            } else if (p.getWestBoundSensor() == sen) {
                if (p.getWestBoundSignalMast() != null) {
                    signal = p.getWestBoundSignalMast();
                } else if (!p.getWestBoundSignal().isEmpty()) {
                    signal = sh.getSignalHead(p.getWestBoundSignal());
                }
            }
        } else if (this.getRefLocation() instanceof LayoutSlip) {
            LayoutSlip t = (LayoutSlip)this.getRefLocation();
            if (t.getSensorA() == sen) {
                if (t.getSignalAMast() != null) {
                    signal = t.getSignalAMast();
                } else if (!t.getSignalA1Name().isEmpty()) {
                    signal = sh.getSignalHead(t.getSignalA1Name());
                }
            } else if (t.getSensorB() == sen) {
                if (t.getSignalBMast() != null) {
                    signal = t.getSignalBMast();
                } else if (!t.getSignalB1Name().isEmpty()) {
                    signal = sh.getSignalHead(t.getSignalB1Name());
                }
            } else if (t.getSensorC() == sen) {
                if (t.getSignalCMast() != null) {
                    signal = t.getSignalCMast();
                } else if (!t.getSignalC1Name().isEmpty()) {
                    signal = sh.getSignalHead(t.getSignalC1Name());
                }
            } else if (t.getSensorD() == sen) {
                if (t.getSignalDMast() != null) {
                    signal = t.getSignalDMast();
                } else if (!t.getSignalD1Name().isEmpty()) {
                    signal = sh.getSignalHead(t.getSignalD1Name());
                }
            }
        } else if (this.getRefLocation() instanceof LayoutTurnout) {
            LayoutTurnout t = (LayoutTurnout)this.getRefLocation();
            if (t.getSensorA() == sen) {
                if (t.getSignalAMast() != null) {
                    signal = t.getSignalAMast();
                } else if (!t.getSignalA1Name().isEmpty()) {
                    signal = sh.getSignalHead(t.getSignalA1Name());
                }
            } else if (t.getSensorB() == sen) {
                if (t.getSignalBMast() != null) {
                    signal = t.getSignalBMast();
                } else if (!t.getSignalB1Name().isEmpty()) {
                    signal = sh.getSignalHead(t.getSignalB1Name());
                }
            } else if (t.getSensorC() == sen) {
                if (t.getSignalCMast() != null) {
                    signal = t.getSignalCMast();
                } else if (!t.getSignalC1Name().isEmpty()) {
                    signal = sh.getSignalHead(t.getSignalC1Name());
                }
            } else if (t.getSensorD() == sen) {
                if (t.getSignalDMast() != null) {
                    signal = t.getSignalDMast();
                } else if (!t.getSignalD1Name().isEmpty()) {
                    signal = sh.getSignalHead(t.getSignalD1Name());
                }
            }
        } else if (this.getRefLocation() instanceof LevelXing) {
            LevelXing x = (LevelXing)this.getRefLocation();
            if (x.getSensorA() == sen) {
                if (x.getSignalAMast() != null) {
                    signal = x.getSignalAMast();
                } else if (!x.getSignalAName().isEmpty()) {
                    signal = sh.getSignalHead(x.getSignalAName());
                }
            } else if (x.getSensorB() == sen) {
                if (x.getSignalBMast() != null) {
                    signal = x.getSignalBMast();
                } else if (!x.getSignalBName().isEmpty()) {
                    signal = sh.getSignalHead(x.getSignalBName());
                }
            } else if (x.getSensorC() == sen) {
                if (x.getSignalCMast() != null) {
                    signal = x.getSignalCMast();
                } else if (!x.getSignalCName().isEmpty()) {
                    signal = sh.getSignalHead(x.getSignalCName());
                }
            } else if (x.getSensorD() == sen) {
                if (x.getSignalDMast() != null) {
                    signal = x.getSignalDMast();
                } else if (!x.getSignalDName().isEmpty()) {
                    signal = sh.getSignalHead(x.getSignalDName());
                }
            }
        }
        if (signal instanceof SignalMast) {
            this.setSignalMast((SignalMast)signal);
        } else if (signal instanceof SignalHead) {
            this.setSignalHead((SignalHead)signal);
        }
        return signal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointDetails tmp = (PointDetails)obj;
        if (tmp.getFacing() != this.facing) {
            return false;
        }
        if (!tmp.getProtecting().equals(this.protectingBlocks)) {
            return false;
        }
        return tmp.getPanel() == this.panel;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.panel != null ? this.panel.hashCode() : 0);
        hash = 37 * hash + (this.facing != null ? this.facing.hashCode() : 0);
        hash = 37 * hash + (this.protectingBlocks != null ? this.protectingBlocks.hashCode() : 0);
        return hash;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }
}

